/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.PcgSystemInitiative;
import gmgen.plugin.PlayerCharacterOutput;
import gmgen.plugin.SystemAttribute;
import gmgen.plugin.SystemHP;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.OpenPCGRequestMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.StatList;
import pcgen.core.character.CharacterSpell;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;

public class PcgCombatant
extends Combatant {
    protected PlayerCharacter pc;
    protected PcRenderer renderer;
    protected float crAdj = 0.0f;

    public PcgCombatant(PlayerCharacter pc) {
        this.pc = pc;
        Globals.setCurrentPC(pc);
        this.init = new PcgSystemInitiative(pc);
        StatList sl = pc.getStatList();
        this.hitPoints = new SystemHP(new SystemAttribute("Constitution", sl.getTotalStatFor("CON")), pc.hitPoints(), pc.hitPoints());
        this.setCombatantType("PC");
    }

    public PcgCombatant(PlayerCharacter pc, String type) {
        this(pc);
        this.setCombatantType(type);
    }

    public PcgCombatant(Element combatant, GMBComponent comp) {
        try {
            File pcgFile = new File(combatant.getChild("PCG").getAttribute("file").getValue());
            OpenPCGRequestMessage msg = new OpenPCGRequestMessage(comp, pcgFile, true);
            GMBus.send(msg);
            this.pc = msg.getPlayerCharacter();
            Globals.setCurrentPC(this.pc);
            this.init = new PcgSystemInitiative(this.pc);
            StatList sl = this.pc.getStatList();
            this.hitPoints = new SystemHP(new SystemAttribute("Constitution", sl.getTotalStatFor("CON")), this.pc.hitPoints(), this.pc.hitPoints());
            this.setStatus(combatant.getAttribute("status").getValue());
            this.setCombatantType(combatant.getAttribute("type").getValue());
            this.init.setBonus(combatant.getChild("Initiative").getAttribute("bonus").getIntValue());
            try {
                this.init.setCurrentInitiative(combatant.getChild("Initiative").getAttribute("current").getIntValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.hitPoints.setMax(combatant.getChild("HitPoints").getAttribute("max").getIntValue());
            this.hitPoints.setCurrent(combatant.getChild("HitPoints").getAttribute("current").getIntValue());
            this.hitPoints.setSubdual(combatant.getChild("HitPoints").getAttribute("subdual").getIntValue());
            this.hitPoints.setState(combatant.getChild("HitPoints").getAttribute("state").getValue());
        }
        catch (Exception e) {
            Logging.errorPrint("Initiative", e);
        }
    }

    public void setCR(float cr) {
        Globals.setCurrentPC(this.pc);
        this.crAdj = cr - (float)this.pc.calcCR();
    }

    public float getCR() {
        Globals.setCurrentPC(this.pc);
        return (float)this.pc.calcCR() + this.crAdj;
    }

    public void setName(String name) {
        this.pc.setName(name);
        this.pc.setDirty(true);
    }

    public String getName() {
        return this.pc.getName();
    }

    public PlayerCharacter getPC() {
        return this.pc;
    }

    public void setPlayer(String player) {
        this.pc.setPlayersName(player);
        this.pc.setDirty(true);
    }

    public String getPlayer() {
        return this.pc.getPlayersName();
    }

    public Element getSaveElement() {
        Element retElement = new Element("PcgCombatant");
        Element initiative = new Element("Initiative");
        Element hp = new Element("HitPoints");
        Element pcg = new Element("PCG");
        pcg.setAttribute("file", this.pc.getFileName() + "");
        retElement.addContent(pcg);
        initiative.setAttribute("bonus", this.init.getBonus() + "");
        if (this.init.getCurrentInitiative() > 0) {
            initiative.setAttribute("current", this.init.getCurrentInitiative() + "");
        }
        retElement.addContent(initiative);
        hp.setAttribute("current", this.hitPoints.getCurrent() + "");
        hp.setAttribute("subdual", this.hitPoints.getSubdual() + "");
        hp.setAttribute("max", this.hitPoints.getMax() + "");
        hp.setAttribute("state", this.hitPoints.getState() + "");
        retElement.addContent(hp);
        retElement.setAttribute("name", this.getName());
        retElement.setAttribute("player", this.getPlayer());
        retElement.setAttribute("status", this.getStatus());
        retElement.setAttribute("type", this.getCombatantType());
        return retElement;
    }

    public void setXP(int experience) {
        this.pc.setXP(experience);
        this.pc.setDirty(true);
    }

    public int getXP() {
        return this.pc.getXP();
    }

    public void editRow(LinkedList columnOrder, int colNumber, Object data) {
        String columnName = (String)columnOrder.get(colNumber);
        String strData = String.valueOf(data);
        if (columnName.equals("Name")) {
            this.setName(strData);
        } else if (columnName.equals("Player")) {
            this.setPlayer(strData);
        } else if (columnName.equals("Status")) {
            this.setStatus(strData);
        } else if (columnName.equals("+")) {
            Integer intData = new Integer(strData);
            this.init.setBonus(intData);
        } else if (columnName.equals("Init")) {
            Integer intData = new Integer(strData);
            this.init.setCurrentInitiative(intData);
        } else if (columnName.equals("#")) {
            Integer intData = new Integer(strData);
            this.setNumber(intData);
        } else if (columnName.equals("HP")) {
            Integer intData = new Integer(strData);
            this.hitPoints.setCurrent(intData);
        } else if (columnName.equals("HP Max")) {
            Integer intData = new Integer(strData);
            this.hitPoints.setMax(intData);
        } else if (columnName.equals("Dur")) {
            Integer intData = new Integer(strData);
            this.setDuration(intData);
        } else if (columnName.equals("Type")) {
            this.setCombatantType(strData);
        }
    }

    public String toHtmlString() {
        if (this.renderer == null) {
            this.renderer = new PcRenderer();
        }
        return this.renderer.getHtmlText();
    }

    protected class PcRenderer {
        protected String htmlString;
        protected int serial = 0;

        public String getHtmlText() {
            if (this.serial < PcgCombatant.this.pc.getSerial() || this.htmlString == null) {
                StringBuffer statBuf = new StringBuffer();
                statBuf.append("<html>");
                Globals.setCurrentPC(PcgCombatant.this.pc);
                statBuf.append(this.getStatBlockHeader());
                statBuf.append("<body class='Normal' lang='EN-US'>");
                statBuf.append(this.getStatBlockTitle());
                statBuf.append(this.getStatBlockCore());
                statBuf.append("<DIV style='MARGIN: 0px 10px'>");
                statBuf.append(this.getStatBlockLineSkills());
                statBuf.append(this.getStatBlockLinePossessions());
                try {
                    statBuf.append(this.getStatBlockLineSpells());
                }
                catch (Exception e) {
                    Logging.errorPrint(e.getMessage(), e);
                }
                statBuf.append("</DIV>");
                statBuf.append("<br>");
                statBuf.append("</html>");
                this.serial = PcgCombatant.this.pc.getSerial();
                this.htmlString = statBuf.toString();
            }
            return this.htmlString;
        }

        protected String getStatBlockCore() {
            StringBuffer statBuf = new StringBuffer();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<font class='type'>CR</font> ");
            statBuf.append(pcOut.getCR());
            statBuf.append("; ");
            statBuf.append("<font class='type'>Size</font> ");
            statBuf.append(pcOut.getSize());
            statBuf.append("; ");
            statBuf.append("<font class='type'>Type</font> ");
            statBuf.append(pcOut.getCritterType());
            statBuf.append("; ");
            statBuf.append("<font class='type'>HD</font> ");
            statBuf.append(pcOut.getHitDice());
            statBuf.append("; ");
            statBuf.append("<font class='type'>hp</font> ");
            statBuf.append(pcOut.getHitPoints());
            statBuf.append("; ");
            statBuf.append("<font class='type'>Init</font> <font class='highlight'>");
            statBuf.append(pcOut.getInitTotal());
            statBuf.append("</font> (");
            statBuf.append(pcOut.getInitStatMod());
            statBuf.append("Dex, ");
            statBuf.append(pcOut.getInitMiscMod());
            statBuf.append("Misc); ");
            statBuf.append("<font class='type'>Spd</font> ");
            statBuf.append(pcOut.getSpeed());
            statBuf.append("; ");
            statBuf.append("<font class='type'>AC</font> <font class='highlight'>");
            statBuf.append(pcOut.getAC());
            statBuf.append("</font> (flatfooted <font class='highlight'>");
            statBuf.append(pcOut.getACFlatFooted());
            statBuf.append("</font>, touch <font class='highlight'>");
            statBuf.append(pcOut.getACTouch());
            statBuf.append("</font>); ");
            statBuf.append("<font class='type'>Melee:</font> <a href='attack:Melee\\");
            statBuf.append(pcOut.getMeleeTotal());
            statBuf.append("' class='highlight'>");
            statBuf.append(pcOut.getMeleeTotal());
            statBuf.append("</a>; ");
            statBuf.append("<font class='type'>Ranged:</font> <a href='attack:Ranged\\");
            statBuf.append(pcOut.getRangedTotal());
            statBuf.append("' class='highlight'>");
            statBuf.append(pcOut.getRangedTotal());
            statBuf.append("</a>; ");
            statBuf.append("<font class='type'>Weapons:</font>");
            List weaponList = PcgCombatant.this.pc.getExpandedWeapons(0);
            for (int i = 0; i < weaponList.size(); ++i) {
                Equipment eq = (Equipment)weaponList.get(i);
                statBuf.append("<a href=\"attack:");
                statBuf.append(pcOut.getWeaponName(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponToHit(i));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponRange(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponType(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponDamage(i));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponCritRange(i));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponCritMult(i));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponHand(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponSize(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponSpecialProperties(eq));
                statBuf.append("\" class=\"dialog\"> ");
                statBuf.append(pcOut.getWeaponName(eq));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponToHit(i));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponRange(eq));
                statBuf.append("/");
                statBuf.append(pcOut.getWeaponType(eq));
                statBuf.append(" (");
                statBuf.append(pcOut.getWeaponDamage(i));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponCritRange(i));
                statBuf.append("/x");
                statBuf.append(pcOut.getWeaponCritMult(i));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponHand(eq));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponSize(eq));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponSpecialProperties(eq));
                statBuf.append(") </a> or ");
            }
            statBuf.append("<a href=\"attack:Unarmed\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.TOTALHIT"));
            statBuf.append("\\\\B\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.DAMAGE"));
            statBuf.append("\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.CRIT"));
            statBuf.append("\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.MULT"));
            statBuf.append("\" class=\"dialog\"> ");
            statBuf.append("Unarmed ");
            statBuf.append(pcOut.getExportToken("WEAPONH.TOTALHIT"));
            statBuf.append(" (");
            statBuf.append(pcOut.getExportToken("WEAPONH.DAMAGE"));
            statBuf.append(" ");
            statBuf.append(pcOut.getExportToken("WEAPONH.CRIT"));
            statBuf.append("/x");
            statBuf.append(pcOut.getExportToken("WEAPONH.MULT"));
            statBuf.append(") </a> or ");
            statBuf.append("<a href=\"attack:Grapple\\");
            statBuf.append(pcOut.getExportToken("ATTACK.GRAPPLE.TOTAL"));
            statBuf.append("\\\\B\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.DAMAGE"));
            statBuf.append("\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.CRIT"));
            statBuf.append("\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.MULT"));
            statBuf.append("\" class=\"dialog\"> ");
            statBuf.append("Grapple ");
            statBuf.append(pcOut.getExportToken("ATTACK.GRAPPLE.TOTAL"));
            statBuf.append(" (");
            statBuf.append(pcOut.getExportToken("WEAPONH.DAMAGE"));
            statBuf.append(" ");
            statBuf.append(pcOut.getExportToken("WEAPONH.CRIT"));
            statBuf.append("/x");
            statBuf.append(pcOut.getExportToken("WEAPONH.MULT"));
            statBuf.append(")</a>; ");
            statBuf.append("<font class='type'>SA:</font> ");
            statBuf.append(pcOut.getSpecialAbilities());
            int turnTimes = PcgCombatant.this.pc.getVariableValue("TurnTimesUndead", "").intValue();
            if (turnTimes > 0) {
                int turnDieNumber = PcgCombatant.this.pc.getVariableValue("TurnDiceUndead", "").intValue();
                int turnDieSize = PcgCombatant.this.pc.getVariableValue("TurnDieSizeUndead", "").intValue();
                int turnDamage = PcgCombatant.this.pc.getVariableValue("TurnDamagePlusUndead", "").intValue();
                int turnLevel = PcgCombatant.this.pc.getVariableValue("TurnLevelUndead", "").intValue();
                int turnCheck = PcgCombatant.this.pc.getVariableValue("TurnCheckUndead", "").intValue();
                statBuf.append("; <font class='type'>Turn/Rebuke Undead:</font> Turning level <a href=\"dice:Turn Undead (Max HD Affected)\\max(min(max((ceil((1d20" + (turnCheck > 0 ? "+" : "") + turnCheck + ")/3)-4),-4),4)+" + turnLevel + ",0)" + '\"' + " class=" + '\"' + "dialog" + '\"' + "> " + turnLevel + "</a>, Turn Damage: " + "<a href=" + '\"' + "dice:Turn Damage (Total HD Affected)\\" + "max(" + turnDieNumber + "d" + turnDieSize + (turnDamage > 0 ? "+" : "") + turnDamage + ",0)" + '\"' + " class=" + '\"' + "dialog" + '\"' + "> " + turnDieNumber + "d" + turnDieSize + (turnDamage > 0 ? "+" : "") + turnDamage + "</a>, " + turnTimes + "/day");
            }
            statBuf.append("; ");
            statBuf.append("<font class='type'>Vision:</font> ");
            statBuf.append(pcOut.getVision());
            statBuf.append(" ");
            statBuf.append("<font class='type'>AL:</font> ");
            statBuf.append(pcOut.getAlignmentShort());
            statBuf.append("; ");
            statBuf.append("<font class='type'>Sv:</font> Fort <font class='highlight'>");
            statBuf.append("<a href='save:FORTITUDE\\");
            statBuf.append(pcOut.getSaveFort());
            statBuf.append("' class='highlight'> ");
            statBuf.append(pcOut.getSaveFort());
            statBuf.append("</a>");
            statBuf.append("</font>, Ref <font class='highlight'>");
            statBuf.append("<a href='save:REFLEX\\");
            statBuf.append(pcOut.getSaveRef());
            statBuf.append("' class='highlight'> ");
            statBuf.append(pcOut.getSaveRef());
            statBuf.append("</a>");
            statBuf.append("</font>, Will <font class='highlight'>");
            statBuf.append("<a href='save:WILL\\");
            statBuf.append(pcOut.getSaveWill());
            statBuf.append("' class='highlight'> ");
            statBuf.append(pcOut.getSaveWill());
            statBuf.append("</a>");
            statBuf.append("</font>; ");
            StatList sl = pcOut.getStatList();
            List statList = sl.getStats();
            for (int i = 0; i < statList.size(); ++i) {
                PCStat stat = (PCStat)statList.get(i);
                if (PcgCombatant.this.pc.isNonAbility(i)) {
                    statBuf.append("<font class='type'>");
                    statBuf.append(stat.getAbb());
                    statBuf.append("</font>");
                    statBuf.append("*");
                    statBuf.append("&nbsp;(");
                    statBuf.append("0");
                    statBuf.append(") ");
                    continue;
                }
                statBuf.append("<font class='type'>");
                statBuf.append(stat.getAbb());
                statBuf.append("</font> ");
                statBuf.append(pcOut.getStat(stat.getAbb()));
                statBuf.append("&nbsp;(");
                statBuf.append("<a href='check:");
                statBuf.append(stat.getAbb());
                statBuf.append("\\1d20");
                statBuf.append(pcOut.getStatMod(stat.getAbb()));
                statBuf.append("' class='dialog'>");
                statBuf.append(pcOut.getStatMod(stat.getAbb()));
                statBuf.append("</a>) ");
            }
            statBuf.append("</p>");
            return statBuf.toString();
        }

        protected String getStatBlockHeader() {
            StringBuffer statBuf = new StringBuffer();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<head><title>");
            statBuf.append(pcOut.getName());
            statBuf.append(" - ");
            statBuf.append(PcgCombatant.this.pc.getPlayersName());
            statBuf.append("(");
            statBuf.append(PcgCombatant.this.pc.getCostPool());
            statBuf.append(" Points) in GMGEN Statblock Format");
            statBuf.append("</title>");
            statBuf.append("<style type='text/css'>");
            statBuf.append("a:link {color: #006699}");
            statBuf.append("a:visited {color: #006699}");
            statBuf.append("a:hover {color: #006699}");
            statBuf.append("a:active {color: #006699}");
            statBuf.append(".type {color:#555555;font-weight:bold}");
            statBuf.append(".highlight {color:#FF0000}");
            statBuf.append(".dialog {color:#006699}");
            statBuf.append("</style></head>");
            return statBuf.toString();
        }

        protected String getStatBlockLinePossessions() {
            StringBuffer statBuf = new StringBuffer();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<p><font class='type'>Possessions:</font>&nbsp;");
            statBuf.append(pcOut.getEquipmentList());
            statBuf.append("</p>");
            return statBuf.toString();
        }

        protected String getStatBlockLineSkills() {
            StringBuffer statBuf = new StringBuffer();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<p><font class='type'>Skills and Feats:</font>&nbsp;");
            PcgCombatant.this.pc.getAllSkillList(true);
            int includeSkills = SettingsHandler.getIncludeSkills();
            if (includeSkills == 3) {
                includeSkills = SettingsHandler.getSkillsTab_IncludeSkills();
            }
            PcgCombatant.this.pc.populateSkills(includeSkills, 2);
            ArrayList skillList = PcgCombatant.this.pc.getSkillListInOutputOrder();
            boolean firstLine = true;
            for (int i = 0; i < skillList.size(); ++i) {
                if (!firstLine) {
                    statBuf.append(", ");
                }
                firstLine = false;
                Skill skill = (Skill)skillList.get(i);
                int modSkill = -1;
                if (skill.getKeyStat().compareToIgnoreCase("None") != 0) {
                    modSkill = skill.modifier(PcgCombatant.this.pc) - PcgCombatant.this.pc.getStatList().getStatModFor(skill.getKeyStat());
                }
                int temp = skill.modifier(PcgCombatant.this.pc) + skill.getTotalRank(PcgCombatant.this.pc).intValue();
                statBuf.append("<a href='skill:");
                statBuf.append(skill.getOutputName());
                statBuf.append("\\1d20");
                statBuf.append(temp < 0 ? Integer.toString(temp) : "+" + temp);
                statBuf.append("' class='dialog'> ");
                statBuf.append(skill.getOutputName());
                statBuf.append(" (");
                statBuf.append(temp);
                statBuf.append(")</a>");
            }
            statBuf.append("; ");
            statBuf.append(pcOut.getFeatList());
            statBuf.append("</p>");
            PcgCombatant.this.pc.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills(), 1);
            return statBuf.toString();
        }

        protected String getStatBlockLineSpells() {
            StringBuffer statBuf = new StringBuffer();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            List domainList = PcgCombatant.this.pc.getCharacterDomainList();
            if (domainList.size() > 0) {
                statBuf.append("<p>");
                statBuf.append("<font class='type'>Deity:</font>");
                statBuf.append(pcOut.getDeity());
                statBuf.append("<br>");
                statBuf.append("<font class='type'>Domains:</font>&nbsp;");
                boolean firstLine = true;
                for (int i = 0; i < domainList.size(); ++i) {
                    if (!firstLine) {
                        statBuf.append(", ");
                    }
                    firstLine = false;
                    Domain dom = ((CharacterDomain)domainList.get(i)).getDomain();
                    statBuf.append(pcOut.getDomainName(dom));
                    statBuf.append(" (");
                    statBuf.append(pcOut.getDomainPower(dom));
                    statBuf.append(")");
                }
                statBuf.append("</p>");
            }
            statBuf.append("<p>");
            ArrayList classList = (ArrayList)PcgCombatant.this.pc.getClassList().clone();
            classList.add(PcgCombatant.this.pc.getRace());
            ArrayList<String> bookList = new ArrayList<String>(PcgCombatant.this.pc.getSpellBooks());
            bookList.add(Globals.getDefaultSpellBook());
            for (int bookIndex = 1; bookIndex < bookList.size(); ++bookIndex) {
                this.statBlockLineSpellBook(PcgCombatant.this.pc, statBuf, classList, (String)bookList.get(bookIndex));
            }
            return statBuf.toString();
        }

        protected void statBlockLineSpellBook(PlayerCharacter pc, StringBuffer statBuf, ArrayList classList, String spellBookName) {
            boolean printedFirst = false;
            for (int i = 0; i < classList.size(); ++i) {
                PObject aObject = (PObject)classList.get(i);
                if (aObject == null) continue;
                int level = 0;
                List spellList = aObject.getCharacterSpell(null, spellBookName, level);
                if (spellList.size() >= 1) {
                    if (!printedFirst) {
                        statBuf.append("<br><font class='type'>" + spellBookName + ":</font><br> ");
                    }
                    statBuf.append("<font class='type'>" + aObject.getName() + ":</font><br> ");
                    printedFirst = true;
                }
                while (spellList.size() >= 1) {
                    statBuf.append("<font class='type'>Level " + level + ":</font> ");
                    boolean firstLine = true;
                    for (int j = 0; j < spellList.size(); ++j) {
                        if (!firstLine) {
                            statBuf.append(", ");
                        }
                        firstLine = false;
                        Spell spell = ((CharacterSpell)spellList.get(j)).getSpell();
                        CharacterSpell cs = (CharacterSpell)spellList.get(j);
                        statBuf.append("<a href=\"spell:");
                        statBuf.append(spell.getName());
                        statBuf.append("\\");
                        statBuf.append(pc.parseSpellString(spell, spell.getDescription(), cs.getOwner()));
                        statBuf.append("\\");
                        statBuf.append(spell.getRange());
                        statBuf.append("\\");
                        statBuf.append(spell.getCastingTime());
                        statBuf.append("\\");
                        statBuf.append(spell.getSaveInfo());
                        statBuf.append("\\");
                        statBuf.append(pc.parseSpellString(spell, spell.getDuration(), cs.getOwner()));
                        statBuf.append("\\");
                        statBuf.append(pc.parseSpellString(spell, spell.getTarget(), cs.getOwner()));
                        statBuf.append("\" class=\"dialog\">");
                        statBuf.append(spell.getName());
                        statBuf.append("</a>");
                    }
                    statBuf.append("<br>");
                    spellList = aObject.getCharacterSpell(null, spellBookName, ++level);
                }
            }
        }

        protected String getStatBlockTitle() {
            StringBuffer statBuf = new StringBuffer();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<p class='gork'><font size='+1'><b>");
            statBuf.append(pcOut.getName());
            statBuf.append(", ");
            statBuf.append(pcOut.getGender());
            statBuf.append(" ");
            statBuf.append(pcOut.getRace());
            String region = pcOut.getRegion();
            if (!"".equals(region) && region != null && !"None".equals(region)) {
                statBuf.append(" From " + region + " ");
            }
            statBuf.append(pcOut.getClasses() + " ");
            statBuf.append("</b></font></p>");
            return statBuf.toString();
        }
    }
}

