/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.StatList;
import pcgen.io.ExportHandler;

public class PlayerCharacterOutput {
    private PlayerCharacter pc;

    public PlayerCharacterOutput(PlayerCharacter pc) {
        this.pc = pc;
        Globals.setCurrentPC(pc);
    }

    public String getAC() {
        return this.pc.getACTotal() + "";
    }

    public String getACFlatFooted() {
        return this.pc.flatfootedAC() + "";
    }

    public String getACTouch() {
        return this.pc.touchAC() + "";
    }

    public String getAlignmentLong() {
        return SettingsHandler.getGame().getLongAlignmentAtIndex(this.pc.getAlignment());
    }

    public String getAlignmentShort() {
        return SettingsHandler.getGame().getShortAlignmentAtIndex(this.pc.getAlignment());
    }

    public String getBAB() {
        return this.pc.baseAttackBonus() + "";
    }

    public String getCR() {
        return this.pc.calcCR() + "";
    }

    public String getClasses() {
        StringBuffer sb = new StringBuffer();
        ArrayList classList = this.pc.getClassList();
        for (int i = 0; i < classList.size(); ++i) {
            PCClass mClass = (PCClass)classList.get(i);
            sb.append(mClass.getName() + mClass.getLevel() + " ");
        }
        return sb.toString();
    }

    public String getCritterType() {
        return this.pc.getCritterType();
    }

    public String getDeity() {
        Deity deity = this.pc.getDeity();
        if (deity != null) {
            return deity.getOutputName();
        }
        return null;
    }

    public String getDomainName(Domain domain) {
        return domain.getName();
    }

    public String getDomainPower(Domain domain) {
        return domain.piDescString();
    }

    public String getEquipmentList() {
        StringBuffer sb = new StringBuffer();
        List eqList = this.pc.getEquipmentListInOutputOrder();
        boolean firstLine = true;
        for (int i = 0; i < eqList.size(); ++i) {
            Equipment eq = (Equipment)eqList.get(i);
            if (!firstLine) {
                sb.append(", ");
            }
            firstLine = false;
            DecimalFormat formater = new DecimalFormat();
            formater.setMaximumFractionDigits(1);
            formater.setMinimumFractionDigits(0);
            sb.append(formater.format(eq.getQty()) + " " + eq.getName());
        }
        return sb.toString();
    }

    public String getExportToken(String token) {
        try {
            StringWriter retWriter = new StringWriter();
            BufferedWriter bufWriter = new BufferedWriter(retWriter);
            ExportHandler export = new ExportHandler(new File(""));
            export.replaceTokenSkipMath(this.pc, token, bufWriter);
            retWriter.flush();
            try {
                bufWriter.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            return retWriter.toString();
        }
        catch (Exception e) {
            System.out.println("Failure fetching token: " + token);
            return "";
        }
    }

    public String getFeatList() {
        StringBuffer sb = new StringBuffer();
        ArrayList featList = this.pc.getFeatList();
        boolean firstLine = true;
        for (int i = 0; i < featList.size(); ++i) {
            Feat feat = (Feat)featList.get(i);
            if (!firstLine) {
                sb.append(", ");
            }
            firstLine = false;
            sb.append(feat.qualifiedName());
        }
        return sb.toString();
    }

    public String getGender() {
        return this.pc.getGender();
    }

    public String getHitDice() {
        return this.getExportToken("HITDICE");
    }

    public String getHitPoints() {
        return this.pc.hitPoints() + "";
    }

    public String getInitMiscMod() {
        StatList sl = this.pc.getStatList();
        int statMod = sl.getStatModFor("DEX");
        int miscMod = this.pc.initiativeMod() - statMod;
        return "+" + miscMod;
    }

    public String getInitStatMod() {
        StatList sl = this.pc.getStatList();
        int statMod = sl.getStatModFor("DEX");
        return "+" + statMod;
    }

    public String getInitTotal() {
        return "+" + this.pc.initiativeMod();
    }

    public String getMeleeTotal() {
        int tohitBonus = (int)this.pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)this.pc.getTotalBonusTo("TOHIT", "TYPE.MELEE") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT.MELEE");
        return this.pc.getAttackString(0, tohitBonus);
    }

    public String getName() {
        return this.pc.getName();
    }

    public String getRace() {
        return this.pc.getRace().getName();
    }

    public String getRangedTotal() {
        int tohitBonus = (int)this.pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)this.pc.getTotalBonusTo("TOHIT", "TYPE.RANGED") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT.RANGED");
        return this.pc.getAttackString(0, tohitBonus);
    }

    public String getRegion() {
        return this.pc.getRegion();
    }

    public String getSaveFort() {
        return "+" + new Double(this.pc.getBonus(1, true)).intValue();
    }

    public String getSaveRef() {
        return "+" + new Double(this.pc.getBonus(2, true)).intValue();
    }

    public String getSaveWill() {
        return "+" + new Double(this.pc.getBonus(3, true)).intValue();
    }

    public String getSize() {
        return this.pc.getSize();
    }

    public String getSkillList() {
        StringBuffer sb = new StringBuffer();
        ArrayList skillList = this.pc.getSkillListInOutputOrder();
        boolean firstLine = true;
        for (int i = 0; i < skillList.size(); ++i) {
            Skill skill = (Skill)skillList.get(i);
            int modSkill = -1;
            if (skill.getKeyStat().compareToIgnoreCase("None") != 0) {
                modSkill = skill.modifier(this.pc) - this.pc.getStatList().getStatModFor(skill.getKeyStat());
            }
            if (skill.getTotalRank(this.pc).intValue() <= 0 && modSkill <= 0) continue;
            int temp = skill.modifier(this.pc) + skill.getTotalRank(this.pc).intValue();
            if (!firstLine) {
                sb.append(", ");
            }
            firstLine = false;
            sb.append(skill.getOutputName() + " +" + temp);
        }
        return sb.toString();
    }

    public String getSpecialAbilities() {
        StringBuffer sb = new StringBuffer();
        boolean firstLine = true;
        ArrayList saList = this.pc.getSpecialAbilityTimesList();
        for (int i = 0; i < saList.size(); ++i) {
            if (!firstLine) {
                sb.append(", ");
            }
            firstLine = false;
            sb.append((String)saList.get(i));
        }
        return sb.toString();
    }

    public String getSpeed() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.pc.getNumberOfMovements(); ++i) {
            sb.append(this.pc.getMovementType(i) + " " + this.pc.movement(i) + Globals.getDistanceUnit());
        }
        return sb.toString();
    }

    public String getStat(String statAbbrev) {
        StatList sl = this.pc.getStatList();
        return sl.getTotalStatFor(statAbbrev) + "";
    }

    public StatList getStatList() {
        return this.pc.getStatList();
    }

    public String getStatMod(String statAbbrev) {
        int returnValue = 0;
        StatList sl = this.pc.getStatList();
        returnValue = sl.getStatModFor(statAbbrev);
        return returnValue < 0 ? Integer.toString(returnValue) : "+" + returnValue;
    }

    public String getVision() {
        return this.pc.getVision();
    }

    public String getWeaponToken(int weaponNo, String Token2) {
        return this.getExportToken("WEAPON." + weaponNo + "." + Token2);
    }

    public String getWeaponCritMult(int weaponNo) {
        return this.getWeaponToken(weaponNo, "MULT");
    }

    public String getWeaponCritRange(int weaponNo) {
        return this.getWeaponToken(weaponNo, "CRIT");
    }

    public String getWeaponDamage(int weaponNo) {
        return this.getWeaponToken(weaponNo, "DAMAGE");
    }

    public String getWeaponHand(Equipment eq) {
        int end;
        String location = Equipment.getLocationName(eq.getLocation());
        int start = location.indexOf(40) + 1;
        if (start > 0 && (end = location.indexOf(41, start)) > 0) {
            location = location.substring(start, end);
        }
        return location;
    }

    public String getWeaponName(Equipment eq) {
        return eq.getOutputName() + eq.getAppliedName();
    }

    public String getWeaponRange(Equipment eq) {
        return eq.getRange(this.pc).toString() + Globals.getDistanceUnit();
    }

    public String getWeaponSize(Equipment eq) {
        return eq.getSize();
    }

    public String getWeaponSpecialProperties(Equipment eq) {
        return eq.getSpecialProperties(this.pc);
    }

    public String getWeaponToHit(int weaponNo) {
        return this.getWeaponToken(weaponNo, "TOTALHIT");
    }

    public String getWeaponType(Equipment eq) {
        String types = this.getWeaponType(eq, true);
        if (eq.isDouble()) {
            types = types + '/' + this.getWeaponType(eq, false);
        }
        return types;
    }

    public String getWeaponType(Equipment eq, boolean primary) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer aTok = new StringTokenizer(SettingsHandler.getGame().getWeaponTypes(), "|", false);
        while (aTok.countTokens() >= 2) {
            String aType = aTok.nextToken();
            String abbrev = aTok.nextToken();
            if (!eq.isType(aType, true)) continue;
            sb.append(abbrev);
        }
        return sb.toString();
    }

    public String getUnarmedAttack() {
        return this.getExportToken("WEAPONH.TOTALHIT");
    }

    public String getUnarmedDamage() {
        return this.getExportToken("WEAPONH.DAMAGE");
    }

    public String getUnarmedCritRange() {
        return this.getExportToken("WEAPONH.CRIT");
    }

    public String getUnarmedCritMult() {
        return this.getExportToken("WEAPONH.MULT");
    }
}

