/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Event;
import java.util.LinkedList;
import java.util.Vector;
import org.jdom.Element;
import pcgen.util.Logging;

public class Spell
extends Event {
    protected String effect;
    protected String name;
    protected String player;
    protected String status = "Active";
    protected boolean alert;
    protected int duration;

    public Spell(String name, String player, String effect, int duration, int init, boolean alert) {
        super(name, player, effect, duration, init, alert);
    }

    public Spell(Element spell) {
        try {
            String name = spell.getAttribute("name").getValue();
            String player = spell.getAttribute("player").getValue();
            String status = spell.getAttribute("status").getValue();
            String effect = spell.getAttribute("effect").getValue();
            int duration = spell.getChild("Initiative").getAttribute("duration").getIntValue();
            int init = spell.getChild("Initiative").getAttribute("initiative").getIntValue();
            boolean alert = spell.getChild("Initiative").getAttribute("alert").getBooleanValue();
            this.setValues(name, player, status, effect, duration, init, alert);
        }
        catch (Exception e) {
            Logging.errorPrint("Initiative", e);
        }
    }

    public String getEndText() {
        return "Spell " + this.getName() + "'s Duration Expired";
    }

    public Vector getRowVector(LinkedList columnOrder) {
        Vector<String> rowVector = new Vector<String>();
        int columns = columnOrder.size();
        for (int j = 0; j < columns; ++j) {
            String columnName = (String)columnOrder.get(j);
            if (columnName.equals("Name")) {
                rowVector.add("Spell: " + this.getName());
                continue;
            }
            if (columnName.equals("Player")) {
                rowVector.add("Owner: " + this.getPlayer());
                continue;
            }
            if (columnName.equals("Status")) {
                rowVector.add(this.getStatus());
                continue;
            }
            if (columnName.equals("+")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("Init")) {
                rowVector.add("" + this.init.getCurrentInitiative());
                continue;
            }
            if (columnName.equals("Dur")) {
                rowVector.add("" + this.getDuration());
                continue;
            }
            if (columnName.equals("#")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("HP")) {
                rowVector.add("");
                continue;
            }
            if (columnName.equals("HP Max")) {
                rowVector.add("");
                continue;
            }
            if (!columnName.equals("Type")) continue;
            rowVector.add("-");
        }
        return rowVector;
    }

    public Element getSaveElement() {
        Element retElement = new Element("Spell");
        Element initiative = new Element("Initiative");
        initiative.setAttribute("initiative", this.init.getCurrentInitiative() + "");
        initiative.setAttribute("duration", this.getDuration() + "");
        initiative.setAttribute("alert", this.isAlert() + "");
        retElement.addContent(initiative);
        retElement.setAttribute("name", this.getName());
        retElement.setAttribute("player", this.getPlayer());
        retElement.setAttribute("status", this.getStatus());
        retElement.setAttribute("effect", this.getEffect());
        return retElement;
    }
}

