/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.PcgCombatant;
import gmgen.plugin.SystemAttribute;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.StatList;

public class SystemHP {
    private String state = "";
    private SystemAttribute attribute;
    private boolean firstround;
    private int current;
    private int max;
    private int subdual;

    public SystemHP(SystemAttribute attribute, int hpmax, int current) {
        this.attribute = attribute;
        this.max = hpmax;
        this.current = current;
    }

    public SystemHP(SystemAttribute attribute, int hpmax) {
        this(attribute, hpmax, hpmax);
    }

    public SystemHP(int hpmax) {
        this(new SystemAttribute("Attribute", 10), hpmax, hpmax);
    }

    public void setAttribute(SystemAttribute attribute) {
        this.attribute = attribute;
    }

    public SystemAttribute getAttribute() {
        return this.attribute;
    }

    public void setCurrent(int current) {
        if (current > this.max) {
            current = this.max;
        }
        if (current > this.current) {
            this.heal(current - this.current);
        } else if (current < this.current) {
            this.damage(this.current - current);
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public static boolean isD20ModernMassive(Combatant cbt, int damage) {
        if (cbt instanceof PcgCombatant) {
            PcgCombatant pcgcbt = (PcgCombatant)cbt;
            PlayerCharacter pc = pcgcbt.getPC();
            Globals.setCurrentPC(pc);
            StatList sl = pc.getStatList();
            if (damage > sl.getTotalStatFor("CON")) {
                return true;
            }
        } else if (damage > cbt.getHP().getAttribute().getValue()) {
            return true;
        }
        return false;
    }

    public static boolean isDndMassive(Combatant cbt, int damage) {
        int damageThreshold = 50;
        if (SettingsHandler.getGMGenOption("Initiative.Damage.Massive.SizeMod", true) && cbt instanceof PcgCombatant) {
            PcgCombatant pcgcbt = (PcgCombatant)cbt;
            PlayerCharacter pc = pcgcbt.getPC();
            String size = pc.getSize();
            if (size.equals("Fine")) {
                damageThreshold = 10;
            }
            if (size.equals("Diminutive")) {
                damageThreshold = 20;
            }
            if (size.equals("Tiny")) {
                damageThreshold = 30;
            }
            if (size.equals("Small")) {
                damageThreshold = 40;
            }
            if (size.equals("Large")) {
                damageThreshold = 60;
            }
            if (size.equals("Huge")) {
                damageThreshold = 70;
            }
            if (size.equals("Gargantuan")) {
                damageThreshold = 80;
            }
            if (size.equals("Colossal")) {
                damageThreshold = 90;
            }
        }
        return damage >= damageThreshold;
    }

    public static boolean isHouseHalfMassive(Combatant cbt, int damage) {
        SystemHP hp = cbt.getHP();
        return damage > hp.getMax();
    }

    public void setMax(int hpmax) {
        this.max = hpmax;
        if (this.max > this.current) {
            this.current = this.max;
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public void setSubdual(int subdual) {
        this.subdualDamage(subdual - this.getSubdual());
    }

    public int getSubdual() {
        return this.subdual;
    }

    public String bleed() {
        if (this.state.equals("Bleeding") && !this.firstround) {
            this.damage(1);
        }
        return this.state;
    }

    public String damage(int damage) {
        boolean dyingStart;
        if (this.current > -1 && this.current - damage < 0 && !(dyingStart = SettingsHandler.getGMGenOption("Initiative.Damage.Dying.Start", true))) {
            this.firstround = true;
        }
        this.current -= damage;
        int disabledType = SettingsHandler.getGMGenOption("Initiative.Damage.Disabled", 1);
        int disabledLowRange = 0;
        if (disabledType == 2) {
            disabledLowRange = -1 * Math.max(0, this.attribute.getModifier());
        }
        if (this.current <= 0 && this.current >= disabledLowRange) {
            this.state = "Disabled";
        } else if (this.current < disabledLowRange) {
            this.state = "Bleeding";
        }
        int deathType = SettingsHandler.getGMGenOption("Initiative.Damage.Death", 1);
        if (deathType == 1) {
            if (this.current <= -10) {
                this.state = "Dead";
                this.current = 0;
            }
        } else if (deathType == 2 && this.current <= -1 * this.attribute.getValue()) {
            this.state = "Dead";
            this.current = 0;
        }
        this.checkSubdual();
        return this.state;
    }

    public String endDurationedStatus() {
        if (this.state.equals("Unconsious") || this.state.equals("Dazed")) {
            this.state = "";
        }
        return this.state;
    }

    public void endRound() {
        this.firstround = false;
    }

    public String heal(int heal) {
        if (!this.state.equals("Dead")) {
            this.current += heal;
            this.subdual -= heal;
            if (this.current > this.max) {
                this.current = this.max;
            }
            if (this.subdual < 0) {
                this.subdual = 0;
            }
            if (this.state.equals("Bleeding")) {
                this.state = "Stable";
            }
            if (this.current > 0) {
                this.state = "";
            }
            this.checkSubdual();
        }
        return this.state;
    }

    public String kill() {
        this.state = "Dead";
        this.current = 0;
        return this.state;
    }

    public String nonLethalDamage(boolean type) {
        if (this.state.equals("")) {
            this.state = type ? "Unconsious" : "Dazed";
        }
        return this.state;
    }

    public String raise() {
        if (this.state.equals("Dead")) {
            this.state = "";
            this.current = 1;
        }
        return this.state;
    }

    public String stabilize() {
        if (this.state.equals("Bleeding")) {
            this.state = "Stable";
        }
        return this.state;
    }

    public String subdualDamage(int damage) {
        this.subdual += damage;
        return this.checkSubdual();
    }

    private String checkSubdual() {
        int disabledType = SettingsHandler.getGMGenOption("Initiative.Damage.Disabled", 1);
        int disabledBonus = 0;
        if (disabledType == 2) {
            disabledBonus = Math.max(0, this.attribute.getModifier());
        }
        if ((this.state.equals("") || this.state.equals("Staggered") || this.state.equals("Unconsious")) && this.subdual > 0) {
            if (this.subdual >= this.current && this.subdual <= this.current + disabledBonus) {
                this.state = "Staggered";
            } else if (this.subdual > this.current + disabledBonus) {
                this.state = "Unconsious";
            }
        }
        return this.state;
    }
}

