/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.ErrorListDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ErrorListCellRenderer
extends JComponent
implements ListCellRenderer {
    private Font boldFont;
    private Font plainFont = UIManager.getFont("Label.font");
    private FontMetrics boldFM;
    private FontMetrics plainFM;
    private String path;
    private String[] messages;

    public ErrorListCellRenderer() {
        this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        this.plainFM = this.getFontMetrics(this.plainFont);
        this.boldFM = this.getFontMetrics(this.boldFont);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ErrorListDialog.ErrorEntry entry = (ErrorListDialog.ErrorEntry)value;
        this.path = entry.path + ":";
        this.messages = entry.messages;
        return this;
    }

    public Dimension getPreferredSize() {
        int width = this.boldFM.stringWidth(this.path);
        int height = this.boldFM.getHeight();
        for (int i = 0; i < this.messages.length; ++i) {
            width = Math.max(this.plainFM.stringWidth(this.messages[i]), width);
            height += this.plainFM.getHeight();
        }
        Insets insets = this.getBorder().getBorderInsets(this);
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public void paintComponent(Graphics g) {
        Insets insets = this.getBorder().getBorderInsets(this);
        g.setFont(this.boldFont);
        g.drawString(this.path, insets.left, insets.top + this.boldFM.getAscent());
        int y = insets.top + this.boldFM.getHeight() + 2;
        g.setFont(this.plainFont);
        for (int i = 0; i < this.messages.length; ++i) {
            g.drawString(this.messages[i], insets.left, y + this.plainFM.getAscent());
            y += this.plainFM.getHeight();
        }
    }
}

