/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.EnhancedDialog;
import gmgen.pluginmgr.ErrorListCellRenderer;
import gmgen.util.MiscUtilities;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ErrorListDialog
extends EnhancedDialog {
    private JButton ok;
    private JButton pluginMgr;

    public ErrorListDialog(Frame frame, String title, String caption, Vector messages, boolean showPluginMgrButton) {
        super(frame, title, true);
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
        iconBox.add(Box.createGlue());
        content.add("West", iconBox);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(caption);
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        centerPanel.add("North", label);
        JList errors = new JList(messages);
        errors.setCellRenderer(new ErrorListCellRenderer());
        errors.setVisibleRowCount(Math.min(messages.size(), 4));
        JScrollPane scrollPane = new JScrollPane(errors, 22, 32);
        Dimension size = scrollPane.getPreferredSize();
        size.width = Math.min(size.width, 400);
        scrollPane.setPreferredSize(size);
        centerPanel.add("Center", scrollPane);
        content.add("Center", centerPanel);
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.ok = new JButton(MiscUtilities.getLocalization("common.ok", null));
        this.ok.addActionListener(new ActionHandler());
        if (showPluginMgrButton) {
            this.pluginMgr = new JButton(MiscUtilities.getLocalization("error-list.plugin-manager", null));
            this.pluginMgr.addActionListener(new ActionHandler());
            buttons.add(this.pluginMgr);
            buttons.add(Box.createHorizontalStrut(6));
        }
        buttons.add(this.ok);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.getRootPane().setDefaultButton(this.ok);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public void cancel() {
        this.dispose();
    }

    public void ok() {
        this.dispose();
    }

    public class ActionHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ErrorListDialog.this.ok) {
                ErrorListDialog.this.dispose();
            } else if (evt.getSource() == ErrorListDialog.this.pluginMgr) {
                // empty if block
            }
        }
    }

    public static class ErrorEntry {
        String path;
        String[] messages;

        public ErrorEntry(String path, String messageProp, Object[] args) {
            this.path = path;
            String message = MiscUtilities.getLocalization(messageProp, args);
            if (message == null) {
                message = "Undefined property: " + messageProp;
            }
            Vector<String> tokenizedMessage = new Vector<String>();
            int lastIndex = -1;
            for (int i = 0; i < message.length(); ++i) {
                if (message.charAt(i) != '\n') continue;
                tokenizedMessage.addElement(message.substring(lastIndex + 1, i));
                lastIndex = i;
            }
            if (lastIndex != message.length()) {
                tokenizedMessage.addElement(message.substring(lastIndex + 1));
            }
            this.messages = new String[tokenizedMessage.size()];
            tokenizedMessage.copyInto(this.messages);
        }
    }
}

