/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.messages.ComponentAddedMessage;
import gmgen.pluginmgr.messages.ComponentRemovedMessage;
import java.util.Vector;
import pcgen.util.Logging;

public class GMBus {
    private static Vector components = new Vector();
    private static GMBComponent[] copyComponents;

    private GMBus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GMBComponent[] getComponents() {
        Vector vector = components;
        synchronized (vector) {
            if (copyComponents == null) {
                copyComponents = new GMBComponent[components.size()];
                components.copyInto(copyComponents);
            }
            return copyComponents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToBus(GMBComponent comp) {
        Vector vector = components;
        synchronized (vector) {
            components.addElement(comp);
            GMBus.send(new ComponentAddedMessage(comp));
            copyComponents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromBus(GMBComponent comp) {
        Vector vector = components;
        synchronized (vector) {
            components.removeElement(comp);
            GMBus.send(new ComponentRemovedMessage(comp));
            copyComponents = null;
        }
    }

    public static void send(GMBMessage message) {
        Logging.debugPrint(message.toString());
        GMBComponent[] comps = GMBus.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            try {
                if (comps[i] == message.getSource()) continue;
                comps[i].handleMessage(message);
                if (!message.isVetoed()) continue;
                break;
            }
            catch (Throwable t) {
                Logging.errorPrint("Exception while sending message on GMBus:" + t.getMessage(), t);
            }
        }
        message.getSource().handleMessage(message);
    }
}

