/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.GMGenSystem;
import gmgen.pluginmgr.Plugin;
import gmgen.pluginmgr.PluginLoader;
import gmgen.util.MiscUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;

public class JARClassLoader
extends ClassLoader {
    private static final Object NO_CLASS = new Object();
    private static Hashtable classHash = new Hashtable();
    private Plugin.JAR jar;
    private Vector pluginClasses = new Vector();
    private ZipFile zipFile;
    static /* synthetic */ Class class$gmgen$pluginmgr$Plugin;

    public JARClassLoader() {
    }

    public JARClassLoader(String path) throws IOException {
        this.zipFile = new ZipFile(path);
        this.jar = new Plugin.JAR(path, this);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            String lname = name.toLowerCase();
            if (lname.endsWith(".props") || lname.endsWith(".properties") || !name.endsWith(".class")) continue;
            classHash.put(MiscUtilities.fileToClass(name), this);
            if (!name.endsWith("Plugin.class")) continue;
            this.pluginClasses.addElement(name);
        }
        PluginLoader.addPluginJAR(this.jar);
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void closeZipFile() {
        if (this.zipFile == null) {
            return;
        }
        try {
            this.zipFile.close();
        }
        catch (IOException io) {
            Logging.errorPrint(io.getMessage(), io);
        }
        this.zipFile = null;
    }

    public Class loadClass(String clazz, boolean resolveIt) throws ClassNotFoundException {
        Object obj = classHash.get(clazz);
        if (obj == NO_CLASS) {
            throw new ClassNotFoundException(clazz);
        }
        if (obj instanceof ClassLoader) {
            JARClassLoader classLoader = (JARClassLoader)obj;
            return classLoader._loadClass(clazz, resolveIt);
        }
        try {
            ClassLoader parentLoader = this.getClass().getClassLoader();
            Class<?> cls = parentLoader != null ? parentLoader.loadClass(clazz) : this.findSystemClass(clazz);
            return cls;
        }
        catch (ClassNotFoundException cnf) {
            classHash.put(clazz, NO_CLASS);
            throw cnf;
        }
    }

    public void startAllPlugins(String system) {
        int i;
        Vector<Plugin> plugins = new Vector<Plugin>();
        for (i = 0; i < this.pluginClasses.size(); ++i) {
            String name = (String)this.pluginClasses.elementAt(i);
            name = MiscUtilities.fileToClass(name);
            try {
                Plugin pl = this.loadPluginClass(name, system);
                if (pl == null) continue;
                plugins.add(pl);
                continue;
            }
            catch (Throwable t) {
                Logging.errorPrint("Error while starting plugin " + t.getMessage(), t);
                this.jar.addPlugin(new Plugin.Broken(name));
                Object[] args = new String[]{t.toString()};
                PluginLoader.pluginError(this.jar.getPath(), "plugin-error.start-error", args);
            }
        }
        Collections.sort(plugins, new Plugin.PluginComperator());
        for (i = 0; i < plugins.size(); ++i) {
            Plugin pl = (Plugin)plugins.get(i);
            Logging.debugPrint("Starting " + system + " plugin " + pl.getName() + " (version " + MiscUtilities.buildToVersion(pl.getVersion()) + ")");
            this.jar.addPlugin(pl);
        }
    }

    private Class _loadClass(String clazz, boolean resolveIt) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(clazz);
        if (cls != null) {
            if (resolveIt) {
                this.resolveClass(cls);
            }
            return cls;
        }
        String name = MiscUtilities.classToFile(clazz);
        try {
            ZipEntry entry = this.zipFile.getEntry(name);
            if (entry == null) {
                throw new ClassNotFoundException(clazz);
            }
            InputStream in = this.zipFile.getInputStream(entry);
            int len = (int)entry.getSize();
            byte[] data = new byte[len];
            int success = 0;
            int offset = 0;
            while (success < len) {
                if ((success = in.read(data, offset += success, len -= success)) != -1) continue;
                Logging.debugPrint("Failed to load class " + clazz + " from " + this.zipFile.getName());
                throw new ClassNotFoundException(clazz);
            }
            cls = this.defineClass(clazz, data, 0, data.length);
            if (resolveIt) {
                this.resolveClass(cls);
            }
            return cls;
        }
        catch (IOException io) {
            Logging.errorPrint(io.getMessage(), io);
            throw new ClassNotFoundException(clazz);
        }
    }

    private boolean checkDependencies(String name) {
        String dep;
        int i = 0;
        while ((dep = SettingsHandler.getGMGenOption("plugin." + name + ".depend." + i++, null)) != null) {
            Object[] args;
            int index = dep.indexOf(32);
            if (index == -1) {
                Logging.debugPrint(name + " has an invalid" + " dependency: " + dep);
                return false;
            }
            String what = dep.substring(0, index);
            String arg = dep.substring(index + 1);
            if (what.equals("jdk")) {
                if (MiscUtilities.compareStrings(System.getProperty("java.version"), arg, false) >= 0) continue;
                Object[] args2 = new String[]{arg, System.getProperty("java.version")};
                PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-jdk", args2);
                return false;
            }
            if (what.equals("gmgen")) {
                if (arg.length() != 11) {
                    Logging.debugPrint("Invalid GMGen version number: " + arg);
                    return false;
                }
                if (MiscUtilities.compareStrings(GMGenSystem.getBuild(), arg, false) >= 0) continue;
                String needs = MiscUtilities.buildToVersion(arg);
                args = new String[]{needs, GMGenSystem.getVersion()};
                PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-jedit", args);
                return false;
            }
            if (what.equals("plugin")) {
                int index2 = arg.indexOf(32);
                if (index2 == -1) {
                    Logging.debugPrint(name + " has an invalid dependency: " + dep + " (version is missing)");
                    return false;
                }
                String plugin = arg.substring(0, index2);
                String needVersion = arg.substring(index2 + 1);
                String currVersion = SettingsHandler.getGMGenOption("plugin." + plugin + ".version", null);
                if (currVersion == null) {
                    Object[] args3 = new String[]{needVersion, plugin};
                    PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-plugin.no-version", args3);
                    return false;
                }
                if (MiscUtilities.compareStrings(currVersion, needVersion, false) < 0) {
                    Object[] args4 = new String[]{needVersion, plugin, currVersion};
                    PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-plugin", args4);
                    return false;
                }
                if (!(PluginLoader.getPlugin(plugin) instanceof Plugin.Broken)) continue;
                Object[] args5 = new String[]{plugin};
                PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-plugin.broken", args5);
                return false;
            }
            if (what.equals("class")) {
                try {
                    this.loadClass(arg, false);
                    continue;
                }
                catch (Exception e) {
                    args = new String[]{arg};
                    PluginLoader.pluginError(this.jar.getPath(), "plugin-error.dep-class", args);
                    return false;
                }
            }
            Logging.debugPrint(name + " has unknown" + " dependency: " + dep);
            return false;
        }
        return true;
    }

    private Plugin loadPluginClass(String name, String system) throws Exception {
        Plugin pl;
        Plugin[] plugins = PluginLoader.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            if (!plugins[i].getClass().getName().equals(name)) continue;
            PluginLoader.pluginError(this.jar.getPath(), "plugin-error.already-loaded", null);
            return null;
        }
        if (!this.checkDependencies(name)) {
            this.jar.addPlugin(new Plugin.Broken(name));
            return null;
        }
        Class clazz = this.loadClass(name, true);
        int modifiers = clazz.getModifiers();
        if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers) && (class$gmgen$pluginmgr$Plugin == null ? (class$gmgen$pluginmgr$Plugin = JARClassLoader.class$("gmgen.pluginmgr.Plugin")) : class$gmgen$pluginmgr$Plugin).isAssignableFrom(clazz) && (pl = (Plugin)clazz.newInstance()).getPluginSystem().equals(system)) {
            if (pl.getVersion() == null || pl.getName() == null) {
                Logging.debugPrint("Plugin " + name + " needs" + " 'name' and 'version' properties.");
                this.jar.addPlugin(new Plugin.Broken(name));
                return null;
            }
            return pl;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

