/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.JARClassLoader;
import java.io.File;
import java.util.Comparator;
import java.util.Vector;
import pcgen.core.SettingsHandler;

public abstract class Plugin {
    private JAR jar;

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getDataDir() {
        String pluginDirectory = SettingsHandler.getGmgenPluginDir().toString();
        return pluginDirectory + File.separator + this.getName();
    }

    public JAR getJAR() {
        return this.jar;
    }

    public String getName() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public abstract String getPluginSystem();

    public abstract int getPluginLoadOrder();

    public static class PluginComperator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Plugin p1 = (Plugin)o1;
            Plugin p2 = (Plugin)o2;
            Integer load1 = new Integer(p1.getPluginLoadOrder());
            Integer load2 = new Integer(p2.getPluginLoadOrder());
            System.out.println(p1.getName() + ": " + p1.getPluginLoadOrder() + " - " + p2.getName() + ": " + p2.getPluginLoadOrder());
            return load2.compareTo(load1);
        }
    }

    public static class JAR {
        private JARClassLoader classLoader;
        private String path;
        private Vector plugins;

        public JAR(String path, JARClassLoader classLoader) {
            this.path = path;
            this.classLoader = classLoader;
            this.plugins = new Vector();
        }

        public JARClassLoader getClassLoader() {
            return this.classLoader;
        }

        public String getPath() {
            return this.path;
        }

        public Plugin[] getPlugins() {
            Object[] array = new Plugin[this.plugins.size()];
            this.plugins.copyInto(array);
            return array;
        }

        public void getPlugins(Vector vector) {
            for (int i = 0; i < this.plugins.size(); ++i) {
                vector.addElement(this.plugins.elementAt(i));
            }
        }

        public void addPlugin(Plugin plugin) {
            plugin.jar = this;
            plugin.start();
            if (plugin instanceof GMBPlugin) {
                GMBus.addToBus((GMBPlugin)plugin);
            }
            this.plugins.addElement(plugin);
        }
    }

    public static class Broken
    extends Plugin {
        private String clazz;

        Broken(String clazz) {
            this.clazz = clazz;
        }

        public String getClassName() {
            return this.clazz;
        }

        public String getPluginSystem() {
            return "Broken";
        }

        public int getPluginLoadOrder() {
            return 0;
        }
    }
}

