/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.ErrorListDialog;
import gmgen.pluginmgr.JARClassLoader;
import gmgen.pluginmgr.Plugin;
import gmgen.util.MiscUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;

public class PluginLoader {
    private static Vector jars = new Vector();
    private static Vector pluginErrors;
    private static PluginLoader inst;

    protected PluginLoader() {
        File _pluginDirectory;
        if (SettingsHandler.getGmgenPluginDir().toString().equals("")) {
            SettingsHandler.setGmgenPluginDir(new File(Globals.getDefaultPath() + File.separator + "plugins"));
        }
        if (!(_pluginDirectory = SettingsHandler.getGmgenPluginDir()).exists()) {
            _pluginDirectory.mkdirs();
        }
        PluginLoader.loadPlugins(_pluginDirectory);
    }

    public static PluginLoader inst() {
        if (inst == null) {
            inst = new PluginLoader();
        }
        return inst;
    }

    public void startSystemPlugins(String system) {
        for (int i = 0; i < jars.size(); ++i) {
            ((Plugin.JAR)jars.elementAt(i)).getClassLoader().startAllPlugins(system);
        }
    }

    public static Plugin getPlugin(String name) {
        Plugin[] plugins = PluginLoader.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            if (!plugins[i].getClassName().equals(name)) continue;
            return plugins[i];
        }
        return null;
    }

    public static Plugin[] getPlugins() {
        Vector vector = new Vector();
        for (int i = 0; i < jars.size(); ++i) {
            ((Plugin.JAR)jars.elementAt(i)).getPlugins(vector);
        }
        Object[] array = new Plugin[vector.size()];
        vector.copyInto(array);
        return array;
    }

    public static void addPluginJAR(Plugin.JAR plugin) {
        jars.addElement(plugin);
    }

    static void pluginError(String path, String messageProp, Object[] args) {
        if (pluginErrors == null) {
            pluginErrors = new Vector();
        }
        pluginErrors.addElement(new ErrorListDialog.ErrorEntry(path, messageProp, args));
    }

    private static void loadPlugins(File directory) {
        Logging.debugPrint("Loading plugins from " + directory);
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        String[] plugins = directory.list();
        if (plugins == null) {
            return;
        }
        for (int i = 0; i < plugins.length; ++i) {
            String plugin = plugins[i];
            if (!plugin.toLowerCase().endsWith(".jar")) continue;
            String path = MiscUtilities.constructPath(directory.toString(), plugin);
            try {
                Logging.debugPrint("Scanning JAR file: " + path);
                new JARClassLoader(path);
                continue;
            }
            catch (IOException io) {
                Logging.errorPrint("Cannot load plugin " + plugin + ": " + io.getMessage(), io);
                Object[] args = new String[]{io.toString()};
                PluginLoader.pluginError(path, "plugin-error.load-error", args);
            }
        }
    }
}

