/*
 * Decompiled with CFR 0.152.
 */
package gmgen.util;

import gmgen.util.LogReceiver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogUtilities
implements LogReceiver {
    private static LogUtilities singleton = null;
    private List receivers = new ArrayList();
    private boolean loggingOn = false;

    private LogUtilities() {
    }

    public static LogUtilities inst() {
        if (singleton == null) {
            singleton = new LogUtilities();
        }
        return singleton;
    }

    public void setLoggingOn(boolean on) {
        this.loggingOn = on;
    }

    public void addReceiver(LogReceiver rcvr) {
        this.receivers.add(rcvr);
    }

    public void logMessage(String owner, String message) {
        if (this.loggingOn) {
            Iterator itr = this.receivers.iterator();
            while (itr.hasNext()) {
                LogReceiver rcvr = (LogReceiver)itr.next();
                rcvr.logMessage(owner, message);
            }
        }
    }

    public void logMessage(String message) {
        if (this.loggingOn) {
            Iterator itr = this.receivers.iterator();
            while (itr.hasNext()) {
                LogReceiver rcvr = (LogReceiver)itr.next();
                rcvr.logMessage(message);
            }
        }
    }

    public void removeReceiver(LogReceiver rcvr) {
        this.receivers.remove(rcvr);
    }
}

