/*
 * Decompiled with CFR 0.152.
 */
package gmgen.util;

import gmgen.GMGenSystem;
import gmgen.util.OperatingSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import pcgen.core.Globals;
import pcgen.util.Logging;

public class MiscUtilities {
    private static MiscUtilities inst = new MiscUtilities();
    private static Properties options;
    private static Properties localization;

    private MiscUtilities() {
        localization = new Properties();
    }

    public static boolean isAbsolutePath(String path) {
        if (MiscUtilities.isURL(path)) {
            return true;
        }
        if (path.startsWith("~/") || path.startsWith("~" + File.separator) || path.equals("~")) {
            return true;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (path.length() == 2 && path.charAt(1) == ':') {
                return true;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '\\') {
                return true;
            }
            if (path.startsWith("\\\\")) {
                return true;
            }
        } else if (OperatingSystem.isUnix() && path.length() > 0 && path.charAt(0) == '/') {
            return true;
        }
        return false;
    }

    public static String getFileName(String path) {
        int index;
        if (path.equals("/")) {
            return path;
        }
        if (path.endsWith("/") || path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar))) == -1) {
            index = path.indexOf(58);
        }
        if (index == -1 || index == path.length() - 1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static final String getLocalization(String name, Object[] args) {
        if (name == null) {
            return null;
        }
        if (args == null) {
            return localization.getProperty(name);
        }
        String value = localization.getProperty(name);
        if (value == null) {
            return null;
        }
        return MessageFormat.format(value, args);
    }

    public static Cursor setBusyCursor(Component component) {
        Cursor old = component.getCursor();
        component.setCursor(Cursor.getPredefinedCursor(3));
        return old;
    }

    public static void setCursor(Component component, Cursor cursor) {
        component.setCursor(cursor);
    }

    public static void setOptionsProperties() {
    }

    public static String getParentOfPath(String path) {
        int count = Math.max(0, path.length() - 2);
        int index = path.lastIndexOf(File.separatorChar, count);
        if (index == -1) {
            index = path.lastIndexOf(47, count);
        }
        if (index == -1) {
            index = path.lastIndexOf(58);
        }
        return path.substring(0, index + 1);
    }

    public static boolean isURL(String str) {
        int fsIndex = Math.max(str.indexOf(File.separatorChar), str.indexOf(47));
        if (fsIndex == 0) {
            return false;
        }
        if (fsIndex == 2) {
            return false;
        }
        int cIndex = str.indexOf(58);
        if (cIndex <= 1) {
            return false;
        }
        return fsIndex == -1 || cIndex <= fsIndex;
    }

    public static String buildToVersion(String build) {
        StringTokenizer bt = new StringTokenizer(build, ".");
        int major = 0;
        if (bt.hasMoreTokens()) {
            major = Integer.parseInt(bt.nextToken());
        }
        int minor = 0;
        if (bt.hasMoreTokens()) {
            minor = Integer.parseInt(bt.nextToken());
        }
        int beta = 0;
        if (bt.hasMoreTokens()) {
            beta = Integer.parseInt(bt.nextToken());
        }
        int rc = 0;
        if (bt.hasMoreTokens()) {
            rc = Integer.parseInt(bt.nextToken());
        }
        int bugfix = 0;
        if (bt.hasMoreTokens()) {
            bugfix = Integer.parseInt(bt.nextToken());
        }
        return "" + major + "." + minor + (beta != 99 ? "pre" + beta : (rc != 99 ? "rc" + rc : (bugfix != 0 ? "." + bugfix : "final")));
    }

    public static String canonPath(String path) {
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        } else if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        } else if (MiscUtilities.isURL(path)) {
            return path;
        }
        if (File.separatorChar == '\\') {
            path = path.replace('/', '\\');
        }
        if (path.startsWith("~" + File.separator)) {
            path = path.substring(2);
            String home = System.getProperty("user.home");
            if (home.endsWith(File.separator)) {
                return home + path;
            }
            return home + File.separator + path;
        }
        if (path.equals("~")) {
            return System.getProperty("user.home");
        }
        return path;
    }

    public static String classToFile(String name) {
        return name.replace('.', '/').concat(".class");
    }

    public static int compareStrings(String str1, String str2, boolean ignoreCase) {
        char[] char1 = str1.toCharArray();
        char[] char2 = str2.toCharArray();
        int len = Math.min(char1.length, char2.length);
        int i = 0;
        for (int j = 0; i < len && j < len; ++i, ++j) {
            char ch1 = char1[i];
            char ch2 = char2[j];
            if (Character.isDigit(ch1) && Character.isDigit(ch2) && ch1 != '0' && ch2 != '0') {
                int _i;
                int _j = j + 1;
                for (_i = i + 1; _i < char1.length && Character.isDigit(char1[_i]); ++_i) {
                }
                while (_j < char2.length && Character.isDigit(char2[_j])) {
                    ++_j;
                }
                int len1 = _i - i;
                int len2 = _j - j;
                if (len1 > len2) {
                    return 1;
                }
                if (len1 < len2) {
                    return -1;
                }
                for (int k = 0; k < len1; ++k) {
                    ch1 = char1[i + k];
                    ch2 = char2[j + k];
                    if (ch1 == ch2) continue;
                    return ch1 - ch2;
                }
                i = _i - 1;
                j = _j - 1;
                continue;
            }
            if (ignoreCase) {
                ch1 = Character.toLowerCase(ch1);
                ch2 = Character.toLowerCase(ch2);
            }
            if (ch1 == ch2) continue;
            return ch1 - ch2;
        }
        return char1.length - char2.length;
    }

    public static String constructPath(String parent, String path) {
        if (MiscUtilities.isAbsolutePath(path)) {
            return MiscUtilities.canonPath(path);
        }
        if (OperatingSystem.isDOSDerived()) {
            if (path.length() == 2 && path.charAt(1) == ':') {
                return path;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) != '\\') {
                path = path.substring(0, 2) + '\\' + path.substring(2);
                return MiscUtilities.canonPath(path);
            }
        }
        String dd = ".." + File.separator;
        String d = "." + File.separator;
        if (parent == null) {
            parent = Globals.getDefaultPath();
        }
        while (true) {
            if (path.equals(".")) {
                return parent;
            }
            if (path.equals("..")) {
                return MiscUtilities.getParentOfPath(parent);
            }
            if (path.startsWith(dd) || path.startsWith("../")) {
                parent = MiscUtilities.getParentOfPath(parent);
                path = path.substring(3);
                continue;
            }
            if (!path.startsWith(d)) break;
            path = path.substring(2);
        }
        if (OperatingSystem.isDOSDerived() && path.startsWith("\\")) {
            parent = parent.substring(0, 2);
        }
        if (!path.endsWith("\\") && !path.endsWith("/")) {
            parent = parent + File.separator;
        }
        return parent + path;
    }

    public static String constructPath(String parent, String path1, String path2) {
        return MiscUtilities.constructPath(MiscUtilities.constructPath(parent, path1), path2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from_file, File to_file) throws IOException {
        IOException e22;
        FileOutputStream to;
        block24: {
            if (!from_file.exists()) {
                throw new IOException("FileCopy: no such source file: " + from_file.getPath());
            }
            if (!from_file.isFile()) {
                throw new IOException("FileCopy: can't copy directory: " + from_file.getPath());
            }
            if (!from_file.canRead()) {
                throw new IOException("FileCopy: source file is unreadable: " + from_file.getPath());
            }
            if (to_file.isDirectory()) {
                to_file = new File(to_file, from_file.getName());
            }
            if (to_file.exists()) {
                if (!to_file.canWrite()) {
                    throw new IOException("FileCopy: destination file is unwriteable: " + to_file.getPath());
                }
                int choice = JOptionPane.showConfirmDialog(GMGenSystem.inst, "Overwrite existing file " + to_file.getPath(), "File Exists", 0, 3);
                if (choice != 0) {
                    throw new IOException("FileCopy: existing file was not overwritten.");
                }
            } else {
                File dir;
                String parent = to_file.getParent();
                if (parent == null) {
                    parent = Globals.getDefaultPath();
                }
                if (!(dir = new File(parent)).exists()) {
                    throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
                }
                if (dir.isFile()) {
                    throw new IOException("FileCopy: destination is not a directory: " + parent);
                }
                if (!dir.canWrite()) {
                    throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
                }
            }
            FileInputStream from = null;
            to = null;
            try {
                int bytes_read;
                from = new FileInputStream(from_file);
                to = new FileOutputStream(to_file);
                byte[] buffer = new byte[4096];
                while ((bytes_read = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytes_read);
                }
                Object var7_8 = null;
                if (from == null) break block24;
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var7_9 = null;
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                from.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (to != null) {
            try {
                to.close();
            }
            catch (IOException e22) {}
        }
    }

    public static String expandRelativePath(String path) {
        if (path.startsWith("@")) {
            path = Globals.getDefaultPath() + File.separator + path.substring(1);
        }
        return path;
    }

    public static String fileToClass(String name) {
        char[] clsName = name.toCharArray();
        for (int i = clsName.length - 6; i >= 0; --i) {
            if (clsName[i] != '/') continue;
            clsName[i] = 46;
        }
        return new String(clsName, 0, clsName.length - 6);
    }

    public static void readLocalizationProperties() {
        try {
            FileInputStream in = new FileInputStream("/pcgen/gui/prop/LanguageBundle.properties");
            localization.load(in);
        }
        catch (IOException e) {
            Logging.errorPrint("No localization file found.");
        }
    }

    public static String retractRelativePath(String path) {
        File systemDir = new File(Globals.getDefaultPath());
        if (path.startsWith(systemDir.getAbsolutePath())) {
            path = "@" + path.substring(systemDir.getAbsolutePath().length());
        }
        return path;
    }

    public static String colorToHex(Color c) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = c.getRGB();
        char[] buf7 = new char[7];
        buf7[0] = 35;
        for (int pos = 6; pos >= 1; --pos) {
            buf7[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf7);
    }
}

