/*
 * Decompiled with CFR 0.152.
 */
package gmgen.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.UIManager;

public class OperatingSystem {
    private static final int UNIX = 201527;
    private static final int WINDOWS_9x = 1600;
    private static final int WINDOWS_NT = 1638;
    private static final int OS2 = 57005;
    private static final int MAC_OS_X = 2748;
    private static final int VMS = 912082;
    private static final int UNKNOWN = 2989;
    private static int os;
    private static boolean java14;
    private static int hasScreenMenuBar;

    public static final boolean isDOSDerived() {
        return OperatingSystem.isWindows() || OperatingSystem.isOS2();
    }

    public static final boolean isMacOS() {
        return os == 2748;
    }

    public static final boolean isMacOSLF() {
        return OperatingSystem.isMacOS() && UIManager.getLookAndFeel().isNativeLookAndFeel();
    }

    public static final boolean isOS2() {
        return os == 57005;
    }

    public static final Rectangle getScreenBounds() {
        int h;
        int w;
        int y;
        int x;
        int screenX = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int screenY = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (OperatingSystem.isMacOS()) {
            x = 0;
            y = 22;
            w = screenX;
            h = screenY - y - 4;
        } else if (OperatingSystem.isWindows()) {
            x = -4;
            y = -4;
            w = screenX - 2 * x;
            h = screenY - 2 * y;
        } else {
            x = 0;
            y = 0;
            w = screenX;
            h = screenY;
        }
        return new Rectangle(x, y, w, h);
    }

    public static final Rectangle getScreenBounds(Rectangle window) {
        int h;
        int w;
        int y;
        int x;
        GraphicsDevice[] gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Vector<GraphicsConfiguration> intersects = new Vector<GraphicsConfiguration>();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration[] gc = gd[i].getConfigurations();
            block1: for (int j = 0; j < gc.length; ++j) {
                if (!window.intersects(gc[j].getBounds())) continue;
                Enumeration e = intersects.elements();
                while (e.hasMoreElements()) {
                    GraphicsConfiguration gcc = (GraphicsConfiguration)e.nextElement();
                    if (!gcc.getBounds().equals(gc[j].getBounds())) continue;
                    continue block1;
                }
                intersects.add(gc[j]);
            }
        }
        GraphicsConfiguration choice = null;
        Rectangle bounds = choice.getBounds();
        if (intersects.size() > 0) {
            Enumeration e = intersects.elements();
            while (e.hasMoreElements()) {
                GraphicsConfiguration gcc = (GraphicsConfiguration)e.nextElement();
                if (choice == null) {
                    choice = gcc;
                    continue;
                }
                Rectangle int1 = bounds.intersection(window);
                Rectangle int2 = gcc.getBounds().intersection(window);
                int area2 = int2.width * int2.height;
                int area1 = int1.width * int1.height;
                if (area2 <= area1) continue;
                choice = gcc;
            }
        } else {
            choice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        int screenX = (int)bounds.getX();
        int screenY = (int)bounds.getY();
        int screenW = (int)bounds.getWidth();
        int screenH = (int)bounds.getHeight();
        if (OperatingSystem.isMacOS()) {
            x = screenX;
            y = screenY + 22;
            w = screenW;
            h = screenH - y - 4;
        } else if (OperatingSystem.isWindows()) {
            x = screenX - 4;
            y = screenY - 4;
            w = screenW - 2 * x;
            h = screenH - 2 * y;
        } else {
            x = screenX;
            y = screenY;
            w = screenW;
            h = screenH;
        }
        return new Rectangle(x, y, w, h);
    }

    public static final boolean isUnix() {
        return os == 201527 || os == 2748;
    }

    public static final boolean isVMS() {
        return os == 912082;
    }

    public static final boolean isWindows() {
        return os == 1600 || os == 1638;
    }

    public static final boolean isWindows9x() {
        return os == 1600;
    }

    public static final boolean isWindowsNT() {
        return os == 1638;
    }

    public static final boolean hasJava14() {
        return java14;
    }

    public static final boolean hasScreenMenuBar() {
        if (!OperatingSystem.isMacOS()) {
            return false;
        }
        if (hasScreenMenuBar == -1) {
            String result = System.getProperty("apple.laf.useScreenMenuBar");
            if (result == null) {
                result = System.getProperty("com.apple.macos.useScreenMenuBar");
            }
            hasScreenMenuBar = result.equals("true") ? 1 : 0;
        }
        return hasScreenMenuBar == 1;
    }

    static {
        String osName;
        hasScreenMenuBar = -1;
        os = System.getProperty("mrj.version") != null ? 2748 : ((osName = System.getProperty("os.name")).indexOf("Windows 9") != -1 || osName.indexOf("Windows M") != -1 ? 1600 : (osName.indexOf("Windows") != -1 ? 1638 : (osName.indexOf("OS/2") != -1 ? 57005 : (osName.indexOf("VMS") != -1 ? 912082 : (File.separatorChar == '/' ? 201527 : 2989)))));
        if (System.getProperty("java.version").compareTo("1.4") >= 0 && System.getProperty("jedit.nojava14") == null) {
            java14 = true;
        }
    }
}

