/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.RollingMethods;
import pcgen.util.Logging;

public final class BioSet
extends PObject {
    private Map ageMap = new HashMap();
    private Map raceMap = new HashMap();
    private Map userMap = new HashMap();
    private PlayerCharacter aPC;
    private String raceName = "";
    private String regionName = "None";

    public Map getAgeMap() {
        return this.ageMap;
    }

    public String getAgeMapIndex(String region, int index) {
        String retVal = (String)this.ageMap.get(region + "." + String.valueOf(index));
        if (retVal == null || retVal.indexOf("BONUS:") < 0) {
            retVal = (String)this.ageMap.get("None." + String.valueOf(index));
        }
        return retVal;
    }

    public String getAgeSetLine(PlayerCharacter pc) {
        this.aPC = pc;
        this.regionName = this.aPC.getRegion() + ".";
        this.raceName = this.aPC.getRace().getName().trim();
        int ageSet = this.getPCAgeSet(pc);
        return this.getAgeMapIndex(pc.getRegion(), ageSet);
    }

    public int getAgeSetNamed(String ageCategory) {
        Iterator e = this.ageMap.entrySet().iterator();
        while (e.hasNext()) {
            int idx;
            Map.Entry entry = e.next();
            String aString = entry.getValue().toString();
            if (!aString.equals(ageCategory) && !aString.startsWith(ageCategory + "\t") || (idx = (aString = entry.getKey().toString()).indexOf(46)) < 0) continue;
            return Integer.parseInt(aString.substring(idx + 1));
        }
        return -1;
    }

    public int getPCAgeSet(PlayerCharacter pc) {
        int setBaseAge;
        ArrayList values = this.getValueInMaps(".BASEAGE");
        if (values == null) {
            return 0;
        }
        int pcAge = pc.getAge();
        int ageSet = -1;
        Iterator i = values.iterator();
        while (i.hasNext() && pcAge >= (setBaseAge = Integer.parseInt((String)i.next()))) {
            ++ageSet;
        }
        if (ageSet < 0) {
            ageSet = 0;
        }
        return ageSet;
    }

    public String getRacePCCText(String region, String race) {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("REGION:").append(region).append("\n\n");
        SortedMap ageSets = this.getRaceTagsByAge(region, race, false);
        return this.appendAgesetInfo(ageSets, sb);
    }

    public ArrayList getTagForRace(String region, String race, String tag) {
        return this.getValueInMaps(region, "." + race, "." + tag);
    }

    public int addToAgeMap(String region, String line, int currentAgeSetIndex) {
        int x = line.indexOf(124);
        if (x >= 0) {
            currentAgeSetIndex = Integer.parseInt(line.substring(0, x));
            this.ageMap.put(region + "." + currentAgeSetIndex, line.substring(x + 1));
        } else {
            this.ageMap.put(region + "." + line, null);
        }
        return currentAgeSetIndex;
    }

    public void addToRaceMap(String region, String race, String tag, int ageSetIndex) {
        int x = tag.indexOf(58);
        if (x < 0) {
            Logging.errorPrint("Invalid value sent to map: " + tag + " (for " + race + ")");
            return;
        }
        String key = region + "." + race + "." + tag.substring(0, x);
        String value = tag.substring(x + 1);
        ArrayList<String> r = (ArrayList<String>)this.raceMap.get(key);
        if (r == null) {
            r = new ArrayList<String>();
        }
        while (r.size() < ageSetIndex + 1) {
            r.add("0");
        }
        r.set(ageSetIndex, value);
        this.raceMap.put(key, r);
    }

    public void addToUserMap(String region, String race, String tag, int ageSetIndex) {
        int x = tag.indexOf(58);
        if (x < 0) {
            Logging.errorPrint("Invalid value sent to map: " + tag + " (for " + race + ")");
            return;
        }
        String key = region + "." + race + "." + tag.substring(0, x);
        String value = tag.substring(x + 1);
        ArrayList<String> r = (ArrayList<String>)this.userMap.get(key);
        if (r == null) {
            r = new ArrayList<String>();
        }
        while (r.size() < ageSetIndex + 1) {
            r.add("0");
        }
        r.set(ageSetIndex, value);
        this.userMap.put(key, r);
    }

    public void clearUserMap() {
        this.userMap.clear();
    }

    public void copyRaceTags(String origRegion, String origRace, String copyRegion, String copyRace) {
        SortedMap ageSets = this.getRaceTagsByAge(origRegion, origRace, true);
        Iterator it = ageSets.keySet().iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            SortedMap races = (SortedMap)ageSets.get(key);
            Iterator raceIt = races.keySet().iterator();
            while (raceIt.hasNext()) {
                String aRaceName = (String)raceIt.next();
                int currentAgeSetIndex = key;
                if ("AGESET".equals(aRaceName)) continue;
                SortedMap tags = (SortedMap)races.get(aRaceName);
                Iterator tagIt = tags.keySet().iterator();
                while (tagIt.hasNext()) {
                    String tagName = (String)tagIt.next();
                    String value = (String)tags.get(tagName);
                    this.addToUserMap(copyRegion, copyRace, tagName + ":" + value, currentAgeSetIndex);
                }
            }
        }
    }

    public void makeKitSelectionFor(PlayerCharacter pc) {
        this.regionName = pc.getRegion() + ".";
        this.raceName = pc.getRace().getName().trim();
        int ageSet = this.getPCAgeSet(pc);
        if (pc.hasMadeKitSelectionForAgeSet(ageSet)) {
            return;
        }
        String ageSetLine = this.getAgeMapIndex(pc.getRegion(), ageSet);
        if (ageSetLine == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(ageSetLine, "\t", false);
        tok.nextToken();
        PObject temporaryPObject = new PObject();
        while (tok.hasMoreTokens()) {
            String aString = tok.nextToken();
            if (!aString.startsWith("KIT:")) continue;
            temporaryPObject.setKitString("0|" + aString.substring(4));
        }
        temporaryPObject.makeKitSelection(pc);
        pc.setHasMadeKitSelectionForAgeSet(ageSet, true);
    }

    public void randomize(String randomizeStr, PlayerCharacter pc) {
        this.aPC = pc;
        if (this.aPC == null || this.aPC.getRace() == null) {
            return;
        }
        this.raceName = this.aPC.getRace().getName();
        this.regionName = this.aPC.getRegion() + '.';
        ArrayList<String> ranList = new ArrayList<String>();
        StringTokenizer lineTok = new StringTokenizer(randomizeStr, ".", false);
        while (lineTok.hasMoreTokens()) {
            String aString = lineTok.nextToken();
            if (aString.startsWith("AGECAT")) {
                this.generateAge(Integer.parseInt(aString.substring(6)), false);
                continue;
            }
            ranList.add(aString);
        }
        if (ranList.contains("AGE")) {
            this.generateAge(0, true);
        }
        if (ranList.contains("HT") || ranList.contains("WT")) {
            this.generateHeightWeight();
        }
        if (ranList.contains("EYES")) {
            this.aPC.setEyeColor(this.generateBioValue(".EYES"));
        }
        if (ranList.contains("HAIR")) {
            this.aPC.setHairColor(this.generateBioValue(".HAIR"));
        }
        if (ranList.contains("SKIN")) {
            this.aPC.setSkinColor(this.generateBioValue(".SKINTONE"));
        }
    }

    public void removeFromUserMap(String region, String race, String tag) {
        int x = tag.indexOf(58);
        String key = x < 0 ? region + "." + race + "." + tag : region + "." + race + "." + tag.substring(0, x);
        this.userMap.remove(key);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("race name: ").append(this.raceName);
        sb.append(", regionName: ");
        sb.append(this.regionName);
        return sb.toString();
    }

    private static String replaceString(String argInput, String replacement, int value) {
        String input = argInput;
        int x = input.indexOf(replacement);
        if (x >= 0) {
            String output = input.substring(0, x);
            String appendage = input.substring(x + replacement.length());
            input = output + value + appendage;
        }
        return input;
    }

    private SortedMap getRaceTagsByAge(String region, String race, boolean includeGenericMatches) {
        Object value;
        String key;
        String otherRace = "";
        if (includeGenericMatches) {
            int idx = race.indexOf(40);
            otherRace = idx >= 0 ? race.substring(0, idx).trim() + '%' : race + '%';
        }
        SortedMap ageSets = this.setupAgeSet(region);
        Iterator it = this.raceMap.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!key.startsWith(region + "." + race + ".") && !key.startsWith(region + "." + otherRace + ".")) continue;
            value = this.raceMap.get(key);
            this.addTagToAgeSet(ageSets, key, value);
        }
        it = this.userMap.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!key.startsWith(region + "." + race + ".") && !key.startsWith(region + "." + otherRace + ".")) continue;
            value = this.userMap.get(key);
            this.addTagToAgeSet(ageSets, key, value);
        }
        return ageSets;
    }

    private String getTokenNumberInMaps(String addKey, int tokenNum) {
        ArrayList r = this.getValueInMaps(addKey);
        if (r == null) {
            return null;
        }
        if (r.size() <= tokenNum) {
            return "0";
        }
        return (String)r.get(tokenNum);
    }

    private ArrayList getValueInMaps(String addKey) {
        return this.getValueInMaps(this.regionName, this.raceName, addKey);
    }

    private ArrayList getValueInMaps(String argRegionName, String argRaceName, String addKey) {
        String anotherRaceName = argRaceName.indexOf(40) >= 0 ? argRaceName.substring(0, argRaceName.indexOf(40)).trim() + '%' : argRaceName + '%';
        ArrayList r = this.mapFind(this.userMap, argRegionName, argRaceName, addKey, anotherRaceName);
        if (r != null) {
            return r;
        }
        return this.mapFind(this.raceMap, argRegionName, argRaceName, addKey, anotherRaceName);
    }

    private void addTagToAgeSet(SortedMap ageSets, String key, Object value) {
        StringTokenizer tok = new StringTokenizer(key, ".");
        if (tok.countTokens() >= 3) {
            tok.nextToken();
            String aRaceName = tok.nextToken();
            String tagName = tok.nextToken();
            if (value instanceof List) {
                List valueList = (List)value;
                Iterator iter = valueList.iterator();
                for (int ageBracket = 0; ageBracket < ageSets.size() && iter.hasNext(); ++ageBracket) {
                    String tagValue = (String)iter.next();
                    SortedMap races = (SortedMap)ageSets.get(new Integer(ageBracket));
                    TreeMap<String, String> tags = (TreeMap<String, String>)races.get(aRaceName);
                    if (tags == null) {
                        tags = new TreeMap<String, String>();
                        races.put(aRaceName, tags);
                    }
                    tags.put(tagName, tagValue);
                }
            } else {
                SortedMap races = (SortedMap)ageSets.get(new Integer(0));
                TreeMap<String, Object> tags = (TreeMap<String, Object>)races.get(aRaceName);
                if (tags == null) {
                    tags = new TreeMap<String, Object>();
                    races.put(aRaceName, tags);
                }
                tags.put(tagName, value);
            }
        }
    }

    private String appendAgesetInfo(SortedMap ageSets, StringBuffer sb) {
        Iterator it = ageSets.keySet().iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            SortedMap races = (SortedMap)ageSets.get(key);
            sb.append("AGESET:").append(key).append("|");
            sb.append(races.get("AGESET")).append("\n");
            Iterator raceIt = races.keySet().iterator();
            while (raceIt.hasNext()) {
                String aRaceName = (String)raceIt.next();
                if ("AGESET".equals(aRaceName)) continue;
                SortedMap tags = (SortedMap)races.get(aRaceName);
                Iterator tagIt = tags.keySet().iterator();
                while (tagIt.hasNext()) {
                    String tagName = (String)tagIt.next();
                    sb.append("RACENAME:").append(aRaceName).append("\t\t");
                    sb.append(tagName).append(':').append(tags.get(tagName)).append("\n");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void generateAge(int ageCategory, boolean useClassOnly) {
        String age = this.getTokenNumberInMaps(".BASEAGE", ageCategory);
        if (age == null) {
            return;
        }
        int baseAge = Integer.parseInt(age);
        int ageAdd = -1;
        String aClass = this.getTokenNumberInMaps(".CLASS", ageCategory);
        if (aClass != null && !aClass.equals("0")) {
            StringTokenizer aTok = new StringTokenizer(aClass, "|");
            while (aTok.hasMoreTokens()) {
                int end;
                int start;
                String aString = aTok.nextToken();
                String dieString = aString.substring((start = aString.indexOf("[")) + 1, end = aString.indexOf("]"));
                if (dieString.startsWith("BASEAGEADD:")) {
                    dieString = dieString.substring(11);
                }
                aString = aString.substring(0, start);
                StringTokenizer bTok = new StringTokenizer(aString, ",");
                while (bTok.hasMoreTokens() && ageAdd < 0) {
                    String tClass = bTok.nextToken();
                    if (this.aPC.getClassNamed(tClass) == null) continue;
                    ageAdd = RollingMethods.roll(dieString);
                }
            }
        }
        if (ageAdd < 0 && !useClassOnly && (aClass = this.getTokenNumberInMaps(".AGEDIEROLL", ageCategory)) != null) {
            ageAdd = RollingMethods.roll(aClass);
        }
        if (ageAdd >= 0 && baseAge > 0) {
            this.aPC.setAge(baseAge + ageAdd);
        }
    }

    private String generateBioValue(String addKey) {
        String rv;
        String line = this.getTokenNumberInMaps(addKey, 0);
        if (line != null) {
            StringTokenizer aTok = new StringTokenizer(line, "|");
            ArrayList<String> aList = new ArrayList<String>();
            while (aTok.hasMoreTokens()) {
                aList.add(aTok.nextToken());
            }
            int roll = RollingMethods.roll(1, aList.size()) - 1;
            rv = (String)aList.get(roll);
        } else {
            rv = "";
        }
        return rv;
    }

    private void generateHeightWeight() {
        int baseHeight = 0;
        int baseWeight = 0;
        int htAdd = 0;
        int wtAdd = 0;
        String totalWeight = null;
        String htwt = this.getTokenNumberInMaps(".SEX", 0);
        if (htwt == null) {
            return;
        }
        StringTokenizer genderTok = new StringTokenizer(htwt, "[]", false);
        while (genderTok.hasMoreTokens()) {
            if (genderTok.nextToken().equals(this.aPC.getGender())) {
                String htWtLine = genderTok.nextToken();
                StringTokenizer htwtTok = new StringTokenizer(htWtLine, "|", false);
                while (htwtTok.hasMoreTokens()) {
                    String tag = htwtTok.nextToken();
                    if (tag.startsWith("BASEHT:")) {
                        baseHeight = Integer.parseInt(tag.substring(7));
                        continue;
                    }
                    if (tag.startsWith("BASEWT:")) {
                        baseWeight = Integer.parseInt(tag.substring(7));
                        continue;
                    }
                    if (tag.startsWith("HTDIEROLL:")) {
                        htAdd = RollingMethods.roll(tag.substring(10));
                        continue;
                    }
                    if (tag.startsWith("WTDIEROLL:")) {
                        wtAdd = RollingMethods.roll(tag.substring(10));
                        continue;
                    }
                    if (!tag.startsWith("TOTALWT:")) continue;
                    totalWeight = tag.substring(8);
                }
                if (baseHeight != 0 && htAdd != 0) {
                    this.aPC.setHeight(baseHeight + htAdd);
                }
                if (totalWeight == null || baseWeight == 0 || wtAdd == 0) break;
                totalWeight = BioSet.replaceString(totalWeight, "HTDIEROLL", htAdd);
                totalWeight = BioSet.replaceString(totalWeight, "BASEWT", baseWeight);
                totalWeight = BioSet.replaceString(totalWeight, "WTDIEROLL", wtAdd);
                this.aPC.setWeight(this.aPC.getVariableValue(totalWeight, "").intValue());
                break;
            }
            genderTok.nextToken();
        }
    }

    private ArrayList mapFind(Map argMap, String argRegionName, String argRaceName, String addKey, String altRaceName) {
        ArrayList r = (ArrayList)argMap.get(argRegionName + argRaceName + addKey);
        if (r != null) {
            return r;
        }
        int altRaceLength = altRaceName.length();
        if (altRaceLength != 0 && (r = (ArrayList)argMap.get(argRegionName + altRaceName + addKey)) != null) {
            return r;
        }
        if (!argRegionName.equals("None")) {
            r = (ArrayList)argMap.get("None." + argRaceName + addKey);
            if (r != null) {
                return r;
            }
            if (altRaceLength != 0) {
                r = (ArrayList)argMap.get("None." + altRaceName + addKey);
            }
        }
        return r;
    }

    private SortedMap setupAgeSet(String region) {
        TreeMap ageSets = new TreeMap();
        Iterator it = this.ageMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(region + ".")) continue;
            Integer setNum = new Integer(key.substring(region.length() + 1));
            String value = (String)this.ageMap.get(key);
            TreeMap<String, String> races = new TreeMap<String, String>();
            races.put("AGESET", value);
            ageSets.put(setNum, races);
        }
        return ageSets;
    }
}

