/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.Collections;
import java.util.Set;
import pcgen.core.Domain;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;

public final class CharacterDomain {
    public static final String PC_CLASS_TYPE = "PCClass";
    public static final String FEAT_CLASS_TYPE = "Feat";
    private Domain domain;
    private String domainName = "";
    private String domainType = "";
    private boolean fromFeat;
    private boolean fromPCClass;
    private int level;

    public Domain setDomain(Domain aDomain, PlayerCharacter pc) {
        CharacterDomain.setSpecialAbilities(this.domain, false, pc);
        if (aDomain == null) {
            this.domain = null;
        } else {
            this.domain = (Domain)aDomain.clone();
            CharacterDomain.setSpecialAbilities(this.domain, true, pc);
        }
        return this.domain;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public String getDomainSourcePcgString() {
        StringBuffer buff = new StringBuffer(30);
        buff.append(this.domainType);
        buff.append('|');
        buff.append(this.domainName);
        if (this.level > 0) {
            buff.append('|');
            buff.append(this.level);
        }
        return buff.toString();
    }

    public boolean isFromFeat() {
        return this.fromFeat;
    }

    public void setFromPCClass(boolean isPCClass) {
        this.fromPCClass = isPCClass;
        this.domainType = PC_CLASS_TYPE;
    }

    public boolean isFromPCClass() {
        return this.fromPCClass;
    }

    public boolean isFromPCClass(String pcClassName) {
        if (this.fromPCClass) {
            return this.domainName.equalsIgnoreCase(pcClassName);
        }
        return false;
    }

    public void setObjectName(String aName) {
        this.domainName = aName;
    }

    public String getObjectName() {
        return this.domainName;
    }

    public Set getVariableNamesAsUnmodifiableSet() {
        if (this.domain != null) {
            return this.domain.getVariableNamesAsUnmodifiableSet();
        }
        return Collections.EMPTY_SET;
    }

    public String toString() {
        String string = "";
        if (this.domain != null) {
            Feat aFeat;
            StringBuffer name = new StringBuffer(this.domain.getName());
            if (this.fromPCClass) {
                PCClass aClass = Globals.getClassNamed(this.domainName);
                if (aClass != null) {
                    name.insert(0, aClass.getName() + ":");
                }
            } else if (this.fromFeat && (aFeat = Globals.getFeatNamed(this.domainName)) != null) {
                name.insert(0, aFeat.getName() + ":");
            }
            string = name.toString();
        }
        return string;
    }

    boolean isDomainValidFor(PlayerCharacter aPC) {
        boolean valid = false;
        if (this.domain == null) {
            valid = false;
        }
        if (this.fromPCClass) {
            PCClass aClass = aPC.getClassNamed(this.domainName);
            boolean bl = valid = aClass != null && aClass.getLevel() >= this.level;
        }
        if (this.fromFeat) {
            valid = aPC.hasFeat(this.domainName) || aPC.hasFeatAutomatic(this.domainName) || aPC.hasFeatVirtual(this.domainName);
        }
        return valid;
    }

    public void setLevel(int argLevel) {
        this.level = argLevel;
    }

    private static void setSpecialAbilities(Domain aDomain, boolean addIt, PlayerCharacter pc) {
        PlayerCharacter aPC = pc;
        if (aPC != null && aDomain != null) {
            String aString = "DOMAIN:" + aDomain.getName() + '|';
            for (int i = 0; i < aDomain.getVariableCount(); ++i) {
                String aVar = aString + aDomain.getVariableDefinition(i);
                if (addIt) {
                    aPC.addVariable(aVar);
                    continue;
                }
                aPC.removeVariable(aVar);
            }
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String argDomainName) {
        this.domainName = argDomainName;
    }

    public String getDomainType() {
        return this.domainType;
    }

    public void setDomainType(String argDomainType) {
        this.domainType = argDomainType;
        if (this.domainType.equalsIgnoreCase(PC_CLASS_TYPE)) {
            this.fromPCClass = true;
        } else if (this.domainType.equalsIgnoreCase(FEAT_CLASS_TYPE)) {
            this.fromFeat = true;
        }
    }
}

