/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import pcgen.core.Campaign;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PointBuyMethod;
import pcgen.core.SettingsHandler;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceManager;
import pcgen.persistence.lst.CampaignOutput;
import pcgen.util.Logging;

public final class CustomData {
    private CustomData() {
    }

    public static BufferedReader getCustomEquipmentReader() {
        return CustomData.getReader(CustomData.customEquipmentFilePath());
    }

    public static String customBioSetFilePath(boolean usePath) {
        return CustomData.getCustomPath("BioSet", usePath);
    }

    public static String customClassFilePath(boolean usePath) {
        return CustomData.getCustomPath("Classes", usePath);
    }

    public static String customDeityFilePath(boolean usePath) {
        return CustomData.getCustomPath("Deities", usePath);
    }

    public static String customDomainFilePath(boolean usePath) {
        return CustomData.getCustomPath("Domains", usePath);
    }

    public static String customFeatFilePath(boolean usePath) {
        return CustomData.getCustomPath("Feats", usePath);
    }

    public static String customLanguageFilePath(boolean usePath) {
        return CustomData.getCustomPath("Languages", usePath);
    }

    public static String customRaceFilePath(boolean usePath) {
        return CustomData.getCustomPath("Races", usePath);
    }

    public static String customSkillFilePath(boolean usePath) {
        return CustomData.getCustomPath("Skills", usePath);
    }

    public static String customSpellFilePath(boolean usePath) {
        return CustomData.getCustomPath("Spells", usePath);
    }

    public static String customTemplateFilePath(boolean usePath) {
        return CustomData.getCustomPath("Templates", usePath);
    }

    public static void writeCustomFiles(PlayerCharacter aPC) {
        CustomData.writePurchaseModeConfiguration();
        if (!PersistenceManager.getInstance().isCustomItemsLoaded()) {
            return;
        }
        CustomData.writeCustomBioSet();
        CustomData.writeCustomClasses(aPC);
        CustomData.writeCustomDeities(aPC);
        CustomData.writeCustomDomains(aPC);
        CustomData.writeCustomFeats(aPC);
        CustomData.writeCustomItems();
        CustomData.writeCustomLanguages(aPC);
        CustomData.writeCustomRaces(aPC);
        CustomData.writeCustomSkills(aPC);
        CustomData.writeCustomSpells(aPC);
        CustomData.writeCustomTemplates(aPC);
        CustomData.writeCustomSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCustomItems() {
        if (!PersistenceManager.getInstance().isCustomItemsLoaded()) {
            return;
        }
        BufferedWriter bw = CustomData.getCustomEquipmentWriter();
        if (bw == null) {
            return;
        }
        try {
            bw.write("#This file auto-generated by PCGen. Do not edit manually.");
            bw.newLine();
            Iterator e = EquipmentList.getEquipmentList().iterator();
            while (e.hasNext()) {
                Equipment aEq = (Equipment)e.next();
                if (!aEq.isType("CUSTOM") || aEq.isType("AUTO_GEN")) continue;
                aEq.save(bw);
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writeCustomItems", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writeCustomItems while closing", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePurchaseModeConfiguration() {
        BufferedWriter bw = CustomData.getPurchaseModeWriter();
        if (bw == null) {
            return;
        }
        try {
            bw.write("#");
            bw.newLine();
            bw.write("#This file auto-generated by PCGen. Do not edit manually.");
            bw.newLine();
            bw.write("#");
            bw.newLine();
            bw.write("# Point-buy ability score costs");
            bw.newLine();
            bw.write("#");
            bw.newLine();
            int statMin = SettingsHandler.getPurchaseScoreMin();
            if (statMin >= 0) {
                int statMax = SettingsHandler.getPurchaseScoreMax();
                int[] statCosts = SettingsHandler.getAbilityScoreCost();
                for (int i = statMin; i <= statMax; ++i) {
                    bw.write("STAT:" + Integer.toString(i) + "\t\tCOST:" + Integer.toString(statCosts[i - statMin]));
                    bw.newLine();
                }
            }
            bw.write("#");
            bw.newLine();
            bw.write("# Point-buy methods");
            bw.newLine();
            bw.write("#");
            bw.newLine();
            int x = SettingsHandler.getPurchaseMethodCount();
            for (int i = 0; i < x; ++i) {
                PointBuyMethod pbm = SettingsHandler.getPurhaseMethod(i);
                bw.write("METHOD:" + pbm.getMethodName() + "\t\tPOINTS:" + Integer.toString(pbm.getPoints()));
                bw.newLine();
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writePurchaseModeConfiguration", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writePurchaseModeConfiguration while closing", ex);
            }
        }
    }

    private static BufferedWriter getCustomEquipmentWriter() {
        return CustomData.getWriter(CustomData.customEquipmentFilePath());
    }

    private static String getCustomPath(String type, boolean usePath) {
        String aString = "";
        if (usePath) {
            aString = SettingsHandler.getPcgenCustomDir().getAbsolutePath();
        }
        return aString + File.separator + "custom" + type + ".lst";
    }

    private static BufferedWriter getPurchaseModeWriter() {
        String modeFile = SettingsHandler.getPcgenSystemDir() + File.separator + "pointbuymethods.lst";
        return CustomData.getWriter(modeFile);
    }

    private static BufferedReader getReader(String path) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
        }
        catch (IOException e) {
            Logging.debugPrint("Could not get a reader to read from " + path, e);
            return null;
        }
    }

    private static BufferedWriter getWriter(String path) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
        }
        catch (IOException e) {
            Logging.errorPrint("Could not get a writer to write to " + path + " \nThis means that your custom files won't be written. Please check the path.", e);
            return null;
        }
    }

    private static String customEquipmentFilePath() {
        return CustomData.getCustomPath("Equipment", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomBioSet() {
        BufferedWriter bw = CustomData.getWriter(CustomData.customBioSetFilePath(true));
        if (bw == null) {
            return;
        }
        try {
            bw.write("#");
            bw.newLine();
            bw.write("#This file auto-generated by PCGen. Do not edit manually.");
            bw.newLine();
            bw.write("#");
            bw.newLine();
            Iterator it = Globals.getRaceMap().values().iterator();
            while (it.hasNext()) {
                PObject pobj = (PObject)it.next();
                if (!pobj.isType("CUSTOM")) continue;
                String region = pobj.getRegionString();
                if (region == null) {
                    region = "None";
                }
                String name = pobj.getName();
                bw.write(Globals.getBioSet().getRacePCCText(region, name));
                bw.newLine();
            }
            bw.newLine();
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writeCustomBioSet", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writeCustomBioSet while closing", ex);
            }
        }
    }

    private static void writeCustomClasses(PlayerCharacter aPC) {
        CustomData.writeCustomPObjects(CustomData.customClassFilePath(true), Globals.getClassList().iterator(), aPC);
    }

    private static void writeCustomDeities(PlayerCharacter aPC) {
        CustomData.writeCustomPObjects(CustomData.customDeityFilePath(true), Globals.getDeityList().iterator(), aPC);
    }

    private static void writeCustomDomains(PlayerCharacter aPC) {
        CustomData.writeCustomPObjects(CustomData.customDomainFilePath(true), Globals.getDomainList().iterator(), aPC);
    }

    private static void writeCustomFeats(PlayerCharacter aPC) {
        CustomData.writeCustomPObjects(CustomData.customFeatFilePath(true), Globals.getFeatList().iterator(), aPC);
    }

    private static void writeCustomHeader(BufferedWriter bw) throws IOException {
        bw.write("#");
        bw.newLine();
        bw.write("#This file auto-generated by PCGen. Do not edit manually.");
        bw.newLine();
        bw.write("#");
        bw.newLine();
        bw.write("SOURCELONG:Custom|SOURCESHORT:Custom");
        bw.newLine();
    }

    private static void writeCustomLanguages(PlayerCharacter aPC) {
        CustomData.writeCustomPObjects(CustomData.customLanguageFilePath(true), Globals.getLanguageList().iterator(), aPC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomPObjects(String filename, Iterator it, PlayerCharacter aPC) {
        BufferedWriter bw = CustomData.getWriter(filename);
        if (bw == null) {
            return;
        }
        try {
            CustomData.writeCustomHeader(bw);
            while (it.hasNext()) {
                PObject pobj = (PObject)it.next();
                if (!pobj.isType("CUSTOM")) continue;
                bw.write(pobj.getPCCText(aPC));
                bw.newLine();
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writeCustomPObjects", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writeCustomPObjects while closing", ex);
            }
        }
    }

    private static void writeCustomRaces(PlayerCharacter aPC) {
        CustomData.writeCustomPObjects(CustomData.customRaceFilePath(true), Globals.getRaceMap().values().iterator(), aPC);
    }

    private static void writeCustomSkills(PlayerCharacter aPC) {
        CustomData.writeCustomPObjects(CustomData.customSkillFilePath(true), Globals.getSkillList().iterator(), aPC);
    }

    private static void writeCustomSources() {
        Iterator i = Globals.getCampaignList().iterator();
        while (i.hasNext()) {
            Campaign c = (Campaign)i.next();
            if (c.getDestination().length() <= 0) continue;
            CampaignOutput.output(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCustomSpells(PlayerCharacter aPC) {
        BufferedWriter bw = CustomData.getWriter(CustomData.customSpellFilePath(true));
        if (bw == null) {
            return;
        }
        try {
            CustomData.writeCustomHeader(bw);
            Iterator e = Globals.getSpellMap().values().iterator();
            while (e.hasNext()) {
                Object obj = e.next();
                if (obj instanceof ArrayList) {
                    Iterator e2 = ((ArrayList)obj).iterator();
                    while (e2.hasNext()) {
                        Spell aSpell = (Spell)e2.next();
                        if (!aSpell.isType("CUSTOM")) continue;
                        bw.write(aSpell.getPCCText(aPC));
                        bw.newLine();
                    }
                    continue;
                }
                if (!((Spell)obj).isType("CUSTOM")) continue;
                bw.write(((Spell)obj).getPCCText(aPC));
                bw.newLine();
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Error in writeCustomSpells", e);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logging.errorPrint("Error in writeCustomSpells while closing", ex);
            }
        }
    }

    private static void writeCustomTemplates(PlayerCharacter aPC) {
        CustomData.writeCustomPObjects(CustomData.customTemplateFilePath(true), Globals.getTemplateList().iterator(), aPC);
    }
}

