/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

public final class Deity
extends PObject {
    private List domainList = null;
    private List pantheonList = new ArrayList();
    private List raceList = new ArrayList();
    private String alignment = "";
    private String domainListPIString = null;
    private String favoredWeapon = "";
    private String followerAlignments = "";
    private String holyItem = "None";
    private boolean d_allDomains = false;
    private String title = "";
    private String appearance = "";
    private String worshippers = "";

    public Deity() {
        this.buildDomainList(null);
    }

    public void setAlignment(String aString) {
        this.alignment = aString;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public List getDomainList() {
        return this.domainList;
    }

    public void setAppearance(String aString) {
        this.appearance = aString;
    }

    public String getAppearance() {
        return this.appearance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDomainListPIString() {
        if (this.domainListPIString == null) {
            Deity deity = this;
            synchronized (deity) {
                if (this.domainListPIString == null) {
                    StringBuffer piString = new StringBuffer(100);
                    piString.append("<html>");
                    if (this.d_allDomains) {
                        piString.append("ALL");
                    } else {
                        Iterator iter = this.getDomainList().iterator();
                        boolean started = false;
                        while (iter.hasNext()) {
                            Domain aDomain = (Domain)iter.next();
                            if (aDomain == null) continue;
                            if (started) {
                                piString.append(',');
                            } else {
                                started = piString.length() > 0;
                            }
                            piString.append(aDomain.piSubString());
                        }
                    }
                    piString.append("</html>");
                    this.domainListPIString = piString.toString();
                }
            }
        }
        return this.domainListPIString;
    }

    public void setDomainList(List argDomainList) {
        this.domainList = argDomainList == null ? new ArrayList() : argDomainList;
        this.domainListPIString = null;
    }

    public void setDomainNameList(List aDomainStringList) {
        this.domainListPIString = null;
        this.d_allDomains = false;
        this.buildDomainList(aDomainStringList);
    }

    public void setFavoredWeapon(String aString) {
        this.favoredWeapon = aString;
    }

    public String getFavoredWeapon() {
        return this.favoredWeapon;
    }

    public void setFollowerAlignments(String alignmentString) {
        this.followerAlignments = alignmentString;
    }

    public String getFollowerAlignments() {
        return this.followerAlignments;
    }

    public void setHolyItem(String aString) {
        this.holyItem = aString;
    }

    public String getHolyItem() {
        return this.holyItem;
    }

    public String getPCCText(PlayerCharacter aPC) {
        StringBuffer txt = new StringBuffer(200);
        txt.append(this.getName());
        if (this.domainList != null && this.domainList.size() != 0) {
            txt.append("\tDOMAINS:");
            Iterator iter = this.domainList.iterator();
            while (iter.hasNext()) {
                Domain domain = (Domain)iter.next();
                txt.append(domain.getName());
                if (!iter.hasNext()) continue;
                txt.append(",");
            }
        }
        if (this.followerAlignments.length() != 0) {
            txt.append("\tFOLLOWERALIGN:").append(this.followerAlignments);
        }
        if (this.holyItem.length() != 0) {
            txt.append("\tSYMBOL:").append(this.holyItem);
        }
        if (this.favoredWeapon.length() != 0) {
            txt.append("\tDEITYWEAP:").append(this.favoredWeapon);
        }
        txt.append("\tALIGN:").append(this.alignment);
        if (this.pantheonList.size() != 0) {
            txt.append("\tPANTHEON:").append(CoreUtility.join((Collection)this.pantheonList, "|"));
        }
        if (this.raceList.size() != 0) {
            txt.append("\tRACE:").append(CoreUtility.join((Collection)this.raceList, "|"));
        }
        txt.append(super.getPCCText(false, aPC));
        return txt.toString();
    }

    public void setPantheonList(List pantheons) {
        this.pantheonList = pantheons;
    }

    public List getPantheonList() {
        return this.pantheonList;
    }

    public void setRaceNameList(List stringList) {
        this.raceList = stringList;
    }

    public List getRaceList() {
        return this.raceList;
    }

    public void setTitle(String aString) {
        this.title = aString;
    }

    public String getTitle() {
        return this.title;
    }

    public void setWorshippers(String aString) {
        this.worshippers = aString;
    }

    public String getWorshippers() {
        return this.worshippers;
    }

    public void addPantheonToList(String aString) {
        aString = aString.trim();
        this.pantheonList.add(aString);
        Globals.getPantheons().add(aString);
    }

    public boolean canBeSelectedBy(List classList, int anAlignment, PlayerCharacter pc) {
        boolean result;
        try {
            result = this.acceptableClass(classList.iterator()) && this.allowsAlignment(anAlignment, pc) && PrereqHandler.passesAll(this.getPreReqList(), pc, this);
        }
        catch (NumberFormatException nfe) {
            result = false;
        }
        return result;
    }

    public Object clone() {
        Deity d = null;
        try {
            d = (Deity)super.clone();
            d.domainList = new ArrayList(this.getDomainList());
            d.pantheonList = new ArrayList(this.pantheonList);
            d.raceList = new ArrayList(this.raceList);
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return d;
    }

    public boolean hasDomain(Domain aDomain) {
        return this.d_allDomains || this.getDomainList().contains(aDomain);
    }

    public boolean hasDomainNamed(String domainName) {
        Domain testDomain = Globals.getDomainNamed(domainName);
        return this.hasDomain(testDomain);
    }

    public String preReqHTMLStrings(PlayerCharacter aPC, boolean includeHeader) {
        ArrayList prereqs = new ArrayList();
        this.addPreReqTo(prereqs);
        ArrayList<Prerequisite> alignPrereqs = new ArrayList<Prerequisite>();
        if (this.followerAlignments.length() != 0) {
            Logging.debugPrint("preReqHTMLStrings: " + this.followerAlignments);
            for (int i = 0; i < this.followerAlignments.length(); ++i) {
                Prerequisite prereq = new Prerequisite();
                prereq.setKind("align");
                prereq.setOperator(PrerequisiteComparator.EQ);
                prereq.setKey(this.followerAlignments.substring(i, i + 1));
                alignPrereqs.add(prereq);
            }
        }
        String alignText = "One of (" + this.preReqHTMLStringsForList(aPC, null, alignPrereqs, includeHeader) + ")";
        String prereqText = this.preReqHTMLStringsForList(aPC, null, prereqs, includeHeader);
        String text = alignText;
        if (!prereqText.equals("")) {
            text = text + ", " + prereqText;
        }
        return text;
    }

    protected List addSpecialAbilitiesToList(List aList, PlayerCharacter aPC) {
        ArrayList specialAbilityList = this.getSpecialAbilityList();
        if (specialAbilityList == null || specialAbilityList.isEmpty()) {
            return aList;
        }
        Iterator i = specialAbilityList.iterator();
        while (i.hasNext()) {
            SpecialAbility sa = (SpecialAbility)i.next();
            if (!sa.pcQualifiesFor(aPC)) continue;
            aList.add(sa);
        }
        return aList;
    }

    private boolean acceptableClass(Iterator classList) {
        boolean flag;
        boolean bl = flag = !classList.hasNext();
        while (classList.hasNext() && !flag) {
            PCClass aClass = (PCClass)classList.next();
            List deityList = aClass.getDeityList();
            Iterator iter = deityList.iterator();
            while (iter.hasNext()) {
                String deity = (String)iter.next();
                if (!"ANY".equals(deity) && !"ALL".equals(deity) && !this.getName().equals(deity)) continue;
                flag = true;
            }
        }
        return flag;
    }

    private boolean allowsAlignment(int index, PlayerCharacter pc) {
        String subPre;
        StringTokenizer pTok;
        int idxEnd;
        int idxStart;
        String aligns = this.followerAlignments;
        while ((idxStart = aligns.indexOf(91)) >= 0 && (idxEnd = aligns.indexOf(93, idxStart)) >= 0 && (pTok = new StringTokenizer(subPre = aligns.substring(idxStart + 1, idxEnd), "=", false)).countTokens() == 3) {
            PlayerCharacter aPC;
            String cond = pTok.nextToken();
            String vName = pTok.nextToken();
            String condAlignment = pTok.nextToken();
            boolean hasCond = false;
            if ("VARDEFINED".equals(cond) && (aPC = pc) != null && aPC.hasVariable(vName)) {
                hasCond = true;
            }
            if (hasCond) {
                aligns = aligns.substring(0, idxStart) + condAlignment + aligns.substring(idxEnd + 1);
                continue;
            }
            aligns = aligns.substring(0, idxStart) + aligns.substring(idxEnd + 1);
        }
        return aligns.lastIndexOf(String.valueOf(index)) > -1;
    }

    private void buildDomainList(List stringList) {
        if (this.domainList == null) {
            this.domainList = new ArrayList();
        }
        if (stringList == null || stringList.size() == 0) {
            return;
        }
        if (stringList.contains("ALL") || stringList.contains("ANY")) {
            this.domainList = new ArrayList(Globals.getDomainList());
        } else {
            Iterator iter = stringList.iterator();
            while (iter.hasNext()) {
                Domain aDomain;
                String domainString = (String)iter.next();
                boolean add = true;
                if (domainString.equals(".CLEAR")) {
                    this.domainList = new ArrayList();
                    continue;
                }
                if (domainString.startsWith(".CLEAR.")) {
                    domainString = domainString.substring(7);
                    add = false;
                }
                if ((aDomain = Globals.getDomainKeyed(domainString)) != null) {
                    if (add) {
                        this.domainList.add(aDomain);
                        continue;
                    }
                    this.domainList.remove(aDomain);
                    continue;
                }
                Logging.debugPrint("Can not find domain: '" + domainString + "'.");
            }
        }
    }
}

