/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.CharacterDomain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

public final class Domain
extends PObject {
    private ArrayList featList = new ArrayList();
    private boolean isLocked;

    public void addFeatToList(String aString) {
        if (".CLEAR".equals(aString)) {
            if (this.featList != null) {
                this.featList.clear();
            }
            return;
        }
        StringTokenizer aTok = new StringTokenizer(aString, "|,", false);
        while (aTok.hasMoreTokens()) {
            String fs = aTok.nextToken();
            if (this.featList == null) {
                this.featList = new ArrayList();
            }
            this.featList.add(fs);
        }
    }

    public void setIsLocked(boolean aBool, PlayerCharacter pc) {
        if (this.isLocked == aBool) {
            return;
        }
        this.isLocked = aBool;
        if (aBool) {
            PlayerCharacter aPC = pc;
            CharacterDomain aCD = aPC.getCharacterDomainForDomain(this.name);
            PCClass aClass = null;
            if (aCD != null && aCD.isFromPCClass() && (aClass = aPC.getClassNamed(aCD.getObjectName())) != null) {
                int maxLevel;
                for (maxLevel = 0; maxLevel < 10 && aClass.getCastForLevel(aClass.getLevel(), maxLevel, aPC) != 0; ++maxLevel) {
                }
                if (maxLevel > 0) {
                    this.addSpellsToClassForLevels(aClass, 0, maxLevel - 1);
                }
                if (maxLevel > 1 && aClass.getNumSpellsFromSpecialty() == 0) {
                    List aList = Globals.getSpellsIn(-1, "", this.name);
                    Iterator i = aList.iterator();
                    while (i.hasNext()) {
                        Spell gcs = (Spell)i.next();
                        if (gcs.levelForKey("DOMAIN", this.name, aPC) >= maxLevel || aClass.getNumSpellsFromSpecialty() != 0) continue;
                        aClass.setNumSpellsFromSpecialty(1);
                    }
                }
            }
            List spellList = this.getSpellList();
            if (aClass != null && spellList != null && !spellList.isEmpty()) {
                Iterator ri = spellList.iterator();
                while (ri.hasNext()) {
                    List aList;
                    PCSpell pcSpell = (PCSpell)ri.next();
                    Spell aSpell = Globals.getSpellNamed(pcSpell.getKeyName());
                    if (aSpell == null) {
                        return;
                    }
                    int times = Integer.parseInt(pcSpell.getTimesPerDay());
                    String book = pcSpell.getSpellbook();
                    if (!PrereqHandler.passesAll(pcSpell.getPreReqList(), aPC, this) || !(aList = aClass.getCharacterSpell(aSpell, book, -1)).isEmpty()) continue;
                    CharacterSpell cs = new CharacterSpell(this, aSpell);
                    cs.addInfo(1, times, book);
                    aClass.addCharacterSpell(cs);
                }
            }
            if (this.choiceString.length() > 0 && !aPC.isImporting() && !this.choiceString.startsWith("FEAT|")) {
                Domain.modChoices(this, new ArrayList(), new ArrayList(), true, aPC);
            }
            if (!aPC.isImporting()) {
                this.globalChecks(aPC);
                this.activateBonuses(aPC);
            }
        }
    }

    public String getSpellKey() {
        return "DOMAIN|" + this.name;
    }

    public Object clone() {
        Domain aObj = null;
        try {
            aObj = (Domain)super.clone();
            aObj.featList = this.featList;
            aObj.isLocked = false;
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aObj;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            return ((Domain)o).getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        return result;
    }

    public boolean qualifiesForDomain(PlayerCharacter pc) {
        return PrereqHandler.passesAll(this.getPreReqList(), pc, this);
    }

    ArrayList getFeatList() {
        return this.featList;
    }

    void addSpellsToClassForLevels(PCClass aClass, int minLevel, int maxLevel) {
        if (aClass == null) {
            return;
        }
        for (int aLevel = minLevel; aLevel <= maxLevel; ++aLevel) {
            List domainSpells = Globals.getSpellsIn(aLevel, "", this.name);
            if (domainSpells.isEmpty()) continue;
            Iterator di = domainSpells.iterator();
            while (di.hasNext()) {
                CharacterSpell cs1;
                Spell aSpell = (Spell)di.next();
                List slist = aClass.getCharacterSpell(aSpell, Globals.getDefaultSpellBook(), aLevel);
                boolean flag = true;
                Iterator si = slist.iterator();
                while (si.hasNext() && (flag = !(cs1 = (CharacterSpell)si.next()).getOwner().equals(this))) {
                }
                if (!flag) continue;
                CharacterSpell cs = new CharacterSpell(this, aSpell);
                cs.addInfo(aLevel, 1, Globals.getDefaultSpellBook());
                aClass.addCharacterSpell(cs);
            }
        }
    }
}

