/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentCollection;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.RollInfo;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.SpecialProperty;
import pcgen.core.SystemCollections;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.BonusObj;
import pcgen.core.money.DenominationList;
import pcgen.core.money.Denominations;
import pcgen.core.money.Purse;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.EmptyIterator;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.FileAccess;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Delta;
import pcgen.util.JEPResourceChecker;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;

public final class Equipment
extends PObject
implements Serializable,
EquipmentCollection,
Comparable {
    private static final String EQMOD_WEIGHT = "_WEIGHTADD";
    private static final String EQMOD_DAMAGE = "_DAMAGE";
    public static final int EQUIPPED_NEITHER = 0;
    public static final String EQUIPPED_NEITHER_STR = "Equipped";
    public static final int EQUIPPED_PRIMARY = 1;
    public static final String EQUIPPED_PRIMARY_STR = "Hand (Primary)";
    public static final int EQUIPPED_SECONDARY = 2;
    public static final String EQUIPPED_SECONDARY_STR = "Hand (Off-hand)";
    public static final int EQUIPPED_BOTH = 3;
    public static final String EQUIPPED_BOTH_STR = "Hand (Both)";
    public static final int EQUIPPED_TWO_HANDS = 4;
    public static final String EQUIPPED_TWO_HANDS_STR = "Hand (Two-Weapons)";
    public static final int EQUIPPED_TEMPBONUS = 5;
    public static final String EQUIPPED_TEMPBONUS_STR = "Temp Bonus";
    public static final int CARRIED_NEITHER = 6;
    public static final String CARRIED_NEITHER_STR = "Carried";
    public static final int CONTAINED = 7;
    public static final String CONTAINED_STR = "Contained";
    public static final int NOT_CARRIED = 8;
    public static final String NOT_CARRIED_STR = "Not Carried";
    private static final String[] locationStringList = new String[9];
    private static final SortedSet s_equipmentTypes = new TreeSet();
    private static final long serialVersionUID = 1L;
    private BigDecimal baseCost = BigDecimalHelper.ZERO;
    private BigDecimal cost = BigDecimalHelper.ZERO;
    private BigDecimal costMod = BigDecimalHelper.ZERO;
    private BigDecimal weightMod = BigDecimalHelper.ZERO;
    private EquipmentCollection d_parent = null;
    private Float carried = new Float(0.0f);
    private Float containerWeightCapacity = new Float(0.0f);
    private Integer acCheck = new Integer(0);
    private Integer containerReduceWeight = new Integer(0);
    private Integer eDR = new Integer(-1);
    private Integer maxDex = new Integer(100);
    private Integer range = new Integer(0);
    private Integer spellFailure = new Integer(0);
    private List altEqModifierList = new ArrayList();
    private List altTypeList = null;
    private List d_containedEquipment = null;
    private List eqModifierList = new ArrayList();
    private List specialPropertyList = new ArrayList();
    private List vFeatList = null;
    private Map d_acceptsTypes = null;
    private Map d_childTypes = null;
    private Map treasureList = null;
    private Purse baseCoinCost;
    private Purse coinCost;
    private String altCritRange = "";
    private String altDamage = "";
    private String appliedBonusName = "";
    private String baseItem = "";
    private String bonusType = null;
    private String containerCapacityString = "";
    private String containerContentsString = "";
    private String critRange = "";
    private String damage = "";
    private String damageMod = "";
    private String indexedUnderType = "";
    private String longName = "";
    private String modifiedName = "";
    private String moveString = "";
    private String noteString = "";
    private String profName = "";
    private String rateOfFire = "";
    private String size = SystemCollections.getDefaultSizeAdjustment().getAbbreviation();
    private String sizeBase = "";
    private String wieldString = "";
    private boolean attacksProgress = true;
    private boolean automatic = false;
    private boolean bonusPrimary = true;
    private boolean calculatingCost = false;
    private boolean containerConstantWeight = false;
    private boolean d_acceptsChildren = false;
    private boolean equipped = false;
    private boolean hasWield = false;
    private boolean isOnlyNaturalWeapon = false;
    private boolean modifiersAllowed = true;
    private boolean modifiersRequired = false;
    private boolean weightAlreadyUsed = false;
    private double qty = 0.0;
    private double weightInPounds = 0.0;
    private int altCritMult = 0;
    private int critMult = 0;
    private int location = 8;
    private int memberKit = -1;
    private int numberEquipped = 0;
    private int outputIndex = 0;
    private int reach = 0;
    private int slots = 1;
    private List typeListCachePrimary = null;
    private List typeListCacheSecondary = null;
    private static int cacheMiss;
    private static int cacheHit;
    private boolean dirty;
    private String cachedNameWithoutCharges;
    private String cachedNameWithCharges;

    public Equipment() {
        Denominations d;
        DenominationList dl = Globals.getDenominationList();
        if (dl != null && (d = dl.getGlobalDenominations()) != null) {
            this.coinCost = new Purse(d);
            this.baseCoinCost = new Purse(d);
        }
    }

    public Integer getACBonus(PlayerCharacter aPC) {
        int dbon = (int)this.bonusTo(aPC, "COMBAT", "AC", true);
        return new Integer(dbon += (int)this.bonusTo(aPC, "EQMARMOR", "ACBONUS", true));
    }

    public void setACCheck(String aString) {
        try {
            this.acCheck = new Integer(aString);
        }
        catch (NumberFormatException nfe) {
            this.acCheck = new Integer(0);
        }
    }

    public Integer getACMod(PlayerCharacter aPC) {
        int mod = (int)this.bonusTo(aPC, "EQMARMOR", "AC", true) + (int)this.bonusTo(aPC, "COMBAT", "AC", true);
        return new Integer(mod);
    }

    public List getActiveBonuses(PlayerCharacter aPC) {
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (!aBonus.isApplied()) continue;
            aList.add(aBonus);
        }
        List eqModList = this.getEqModifierList(true);
        if (!eqModList.isEmpty()) {
            Iterator e = eqModList.iterator();
            while (e.hasNext()) {
                EquipmentModifier aEqMod = (EquipmentModifier)e.next();
                aList.addAll(aEqMod.getActiveBonuses(this, aPC));
            }
        }
        return aList;
    }

    public void setAltCritMult(String aString) {
        this.altCritMult = this.parseCritMult(aString);
    }

    public String getAltCritMult() {
        if (this.altCritMult == 0) {
            return this.getCritMult();
        }
        return Equipment.multAsString(this.getCritMultiplier(false));
    }

    public int getAltCritMultiplier() {
        if (this.altCritMult == 0) {
            return this.getCritMultiplier();
        }
        return Equipment.multAsInt(this.getCritMultiplier(false));
    }

    public void setAltCritRange(String aString) {
        this.altCritRange = aString;
    }

    public String getAltCritRange(PlayerCharacter aPC) {
        return this.getCritRange(aPC, false);
    }

    public void setAltDamage(String aString) {
        this.altDamage = aString;
    }

    public String getAltDamage(PlayerCharacter aPC) {
        return this.getDamage(aPC, false);
    }

    public boolean isAmmunition() {
        return this.isType("AMMUNITION");
    }

    public void setAppliedName(String aString) {
        this.appliedBonusName = aString;
    }

    public String getAppliedName() {
        if (this.appliedBonusName.length() > 0) {
            StringBuffer aString = new StringBuffer();
            aString.append(" [").append(this.appliedBonusName).append("]");
            return aString.toString();
        }
        return "";
    }

    public boolean isArmor() {
        return this.isType("ARMOR");
    }

    public void setAttacksProgress(boolean argAttacksProgress) {
        this.attacksProgress = argAttacksProgress;
    }

    public boolean isAttacksProgress() {
        return this.attacksProgress;
    }

    public void setAutomatic(boolean arg) {
        this.automatic = arg;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public Purse getBaseCoinCost() {
        if (this.baseCoinCost != null) {
            BigDecimal dbCost = this.getBaseCost();
            this.baseCoinCost.setAmount(dbCost.doubleValue());
        }
        return this.baseCoinCost;
    }

    public void setBaseItem(String argBaseItem) {
        this.baseItem = argBaseItem;
    }

    public String getBaseItemName() {
        if (this.baseItem.length() == 0) {
            return this.getKeyName();
        }
        return this.baseItem;
    }

    public List getBonusListOfType(String aType, String aName, boolean bPrimary) {
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (aBonus.getTypeOfBonus().indexOf(aType) < 0 || aBonus.getBonusInfo().indexOf(aName) < 0) continue;
            aList.add(aBonus);
        }
        List eqModList = this.getEqModifierList(bPrimary);
        if (!eqModList.isEmpty()) {
            Iterator e = eqModList.iterator();
            while (e.hasNext()) {
                EquipmentModifier aEqMod = (EquipmentModifier)e.next();
                aList.addAll(aEqMod.getBonusListOfType(aType, aName));
            }
        }
        return aList;
    }

    public int getBonusToDamage(PlayerCharacter aPC, boolean bPrimary) {
        return (int)this.bonusTo(aPC, "WEAPON", "DAMAGE", bPrimary);
    }

    public int getBonusToHit(PlayerCharacter aPC, boolean bPrimary) {
        return (int)this.bonusTo(aPC, "WEAPON", "TOHIT", bPrimary);
    }

    public void setBonusType(String aString) {
        this.bonusType = aString;
    }

    public String getBonusType() {
        return this.bonusType;
    }

    public void setCarried(Float argCarried) {
        this.carried = argCarried;
    }

    public Float getCarried() {
        return this.carried;
    }

    public Object getChild(int childIndex) {
        return this.getContainedEquipment(childIndex);
    }

    public int getChildCount() {
        return this.getContainedEquipmentCount();
    }

    public void setChildType(String parameter, Float childType) {
        if (this.d_childTypes == null) {
            this.d_childTypes = new HashMap();
        }
        this.d_childTypes.put(parameter, childType);
    }

    public Purse getCoinCost(PlayerCharacter aPC) {
        if (this.coinCost != null) {
            BigDecimal dbCost = this.getCost(aPC);
            this.coinCost.setAmount(dbCost.doubleValue());
        }
        return this.coinCost;
    }

    public Equipment getContainedByIndex(int index) {
        ArrayList contents = new ArrayList(this.getContents());
        if (contents.size() > 0 && index <= contents.size()) {
            return (Equipment)contents.get(index);
        }
        return null;
    }

    public Equipment getContainedEquipment(int i) {
        return (Equipment)this.d_containedEquipment.get(i);
    }

    public int getContainedEquipmentCount() {
        if (this.d_containedEquipment == null) {
            return 0;
        }
        return this.d_containedEquipment.size();
    }

    public double getContainedValue(PlayerCharacter aPC) {
        double total = 0.0;
        if (this.getChildCount() == 0) {
            return total;
        }
        for (int e = 0; e < this.getContainedEquipmentCount(); ++e) {
            Equipment anEquip = this.getContainedEquipment(e);
            if (anEquip.getContainedEquipmentCount() > 0) {
                total += anEquip.getContainedValue(aPC);
                continue;
            }
            total += (double)anEquip.getCost(aPC).floatValue();
        }
        return total;
    }

    public Float getContainedWeight(PlayerCharacter aPC) {
        return this.getContainedWeight(aPC, false);
    }

    public Float getBaseContainedWeight() {
        return this.getBaseContainedWeight(false);
    }

    public Float getBaseContainedWeight(boolean effective) {
        Float total = new Float(0.0f);
        if (this.containerConstantWeight && !effective || this.getChildCount() == 0) {
            return total;
        }
        for (int e = 0; e < this.getContainedEquipmentCount(); ++e) {
            Equipment anEquip = this.getContainedEquipment(e);
            total = anEquip.getContainedEquipmentCount() > 0 ? new Float((double)total.floatValue() + anEquip.getBaseWeightAsDouble() + (double)anEquip.getBaseContainedWeight().floatValue()) : new Float((double)total.floatValue() + anEquip.getBaseWeightAsDouble() * (double)anEquip.getCarried().floatValue());
        }
        if (this.containerReduceWeight > 0) {
            total = new Float(total.floatValue() * (this.containerReduceWeight.floatValue() / 100.0f));
        }
        return total;
    }

    public Float getContainedWeight(PlayerCharacter aPC, boolean effective) {
        Float total = new Float(0.0f);
        if (this.containerConstantWeight && !effective || this.getChildCount() == 0) {
            return total;
        }
        for (int e = 0; e < this.getContainedEquipmentCount(); ++e) {
            Equipment anEquip = this.getContainedEquipment(e);
            total = anEquip.getContainedEquipmentCount() > 0 ? new Float((double)total.floatValue() + anEquip.getWeightAsDouble(aPC) + (double)anEquip.getContainedWeight(aPC).floatValue()) : new Float((double)total.floatValue() + anEquip.getWeightAsDouble(aPC) * (double)anEquip.getCarried().floatValue());
        }
        if (this.containerReduceWeight > 0) {
            total = new Float(total.floatValue() * (this.containerReduceWeight.floatValue() / 100.0f));
        }
        return total;
    }

    public void setContainer(String aString) {
        this.setContainer(null, aString);
    }

    public void setContainer(PlayerCharacter aPC, String aString) {
        boolean limited = true;
        Float aFloat = new Float(0.0f);
        this.d_acceptsChildren = true;
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        if (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if (bString != null && bString.charAt(0) == '*') {
                this.containerConstantWeight = true;
                bString = bString.substring(1);
            }
            if (bString != null && bString.indexOf(37) > 0) {
                int pos = bString.indexOf(37);
                String redString = bString.substring(0, pos);
                bString = bString.substring(pos + 1);
                try {
                    this.containerReduceWeight = new Integer(redString);
                }
                catch (NumberFormatException ex) {
                    Logging.errorPrint("Error in CONTAINS line: " + aString);
                    this.containerReduceWeight = new Integer(0);
                }
            }
            try {
                this.containerWeightCapacity = new Float(bString);
            }
            catch (NumberFormatException ex) {
                Logging.errorPrint("Error in CONTAINS line: " + aString);
                this.containerWeightCapacity = new Float(-1.0f);
            }
        } else {
            this.containerWeightCapacity = new Float(-1.0f);
        }
        if (!aTok.hasMoreTokens()) {
            limited = false;
            this.setAcceptsType("Any", new Float(-1.0f));
        }
        while (aTok.hasMoreTokens()) {
            Float itemNumber;
            StringTokenizer typeTok = new StringTokenizer(aTok.nextToken(), "=");
            String itemType = typeTok.nextToken();
            if (typeTok.hasMoreTokens()) {
                itemNumber = new Float(typeTok.nextToken());
                if (limited) {
                    aFloat = new Float(aFloat.floatValue() + itemNumber.floatValue());
                }
            } else {
                limited = false;
                itemNumber = new Float(-1.0f);
            }
            if (!"Any".equals(itemType) && !"Total".equals(itemType)) {
                this.setAcceptsType(itemType, itemNumber);
                continue;
            }
            this.setAcceptsType(itemType, itemNumber);
        }
        if (!this.acceptsType("Total")) {
            if (!limited) {
                aFloat = new Float(-1.0f);
            }
            this.setAcceptsType("Total", aFloat);
        }
        this.updateContainerCapacityString();
        this.updateContainerContentsString(aPC);
    }

    public boolean isContainer() {
        return this.acceptsChildren();
    }

    public String getContainerByType(String aType, String aSubTag) {
        ArrayList contents = new ArrayList(this.getContents());
        int typeIndex = -1;
        int numCharToRemove = 0;
        for (int i = aType.length() - 1; i > 0; --i) {
            if (aType.charAt(i) >= '0' && aType.charAt(i) <= '9') {
                if (typeIndex == -1) {
                    typeIndex = 0;
                }
                typeIndex = Integer.parseInt(aType.substring(i));
                ++numCharToRemove;
                continue;
            }
            i = 0;
        }
        if (numCharToRemove > 0) {
            aType = aType.substring(0, aType.length() - numCharToRemove);
        }
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            if (((Equipment)it.next()).isType(aType)) continue;
            it.remove();
        }
        if (typeIndex < contents.size()) {
            if ("SPROP".equals(aSubTag)) {
                return ((Equipment)contents.get(typeIndex)).getRawSpecialProperties();
            }
            return ((Equipment)contents.get(typeIndex)).getName();
        }
        return " ";
    }

    public String getContainerCapacityString() {
        return this.containerCapacityString;
    }

    public String getContainerContentsString() {
        return this.containerContentsString;
    }

    public Collection getContents() {
        ArrayList<Equipment> contents = new ArrayList<Equipment>();
        for (int it = 0; it < this.getContainedEquipmentCount(); ++it) {
            Equipment aEquip = this.getContainedEquipment(it);
            if (!(aEquip.getCarried().floatValue() > 0.0f)) continue;
            contents.add(aEquip);
        }
        return contents;
    }

    public void setCost(String aString) {
        this.setCost(aString, false);
    }

    public void setCost(String aString, boolean bBase) {
        try {
            this.cost = new BigDecimal(aString);
            if (bBase) {
                this.baseCost = this.cost;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public BigDecimal getCost(PlayerCharacter aPC) {
        int iCount;
        EquipmentModifier aEqMod;
        BigDecimal eqModCost;
        int iCount2;
        EquipmentModifier aEqMod2;
        BigDecimal c = BigDecimalHelper.ZERO;
        Iterator e = this.eqModifierList.iterator();
        while (e.hasNext()) {
            aEqMod2 = (EquipmentModifier)e.next();
            iCount2 = aEqMod2.getAssociatedCount();
            if (iCount2 < 1) {
                iCount2 = 1;
            }
            eqModCost = new BigDecimal(this.getVariableValue(aEqMod2.getPreCost(), "", "", true, aPC).toString());
            c = c.add(eqModCost.multiply(new BigDecimal(Integer.toString(this.getBaseQty() * iCount2))));
            c = c.add(aEqMod2.addItemCosts(aPC, "ITEMCOST", iCount2, this));
        }
        e = this.altEqModifierList.iterator();
        while (e.hasNext()) {
            aEqMod2 = (EquipmentModifier)e.next();
            iCount2 = aEqMod2.getAssociatedCount();
            if (iCount2 < 1) {
                iCount2 = 1;
            }
            eqModCost = new BigDecimal(this.getVariableValue(aEqMod2.getPreCost(), "", "", false, aPC).toString());
            c = c.add(eqModCost.multiply(new BigDecimal(Integer.toString(this.getBaseQty() * iCount2))));
            c = c.add(aEqMod2.addItemCosts(aPC, "ITEMCOST", iCount2, this));
        }
        double mult = 1.0;
        SizeAdjustment newSA = SystemCollections.getSizeAdjustmentNamed(this.getSize());
        SizeAdjustment currSA = SystemCollections.getSizeAdjustmentNamed(this.getBaseSize());
        if (newSA != null && currSA != null) {
            mult = newSA.getBonusTo(aPC, "ITEMCOST", this.typeList(), 1.0) / currSA.getBonusTo(aPC, "ITEMCOST", this.typeList(), 1.0);
        }
        c = c.multiply(new BigDecimal(mult));
        BigDecimal itemCost = this.cost.add(c);
        ArrayList<BigDecimal> modifierCosts = new ArrayList<BigDecimal>();
        BigDecimal nonDoubleCost = BigDecimalHelper.ZERO;
        c = BigDecimalHelper.ZERO;
        int iPlus = 0;
        int altPlus = 0;
        this.calculatingCost = true;
        this.weightAlreadyUsed = false;
        Iterator e2 = this.eqModifierList.iterator();
        while (e2.hasNext()) {
            BigDecimal eqModCost2;
            aEqMod = (EquipmentModifier)e2.next();
            iCount = aEqMod.getAssociatedCount();
            if (iCount < 1) {
                iCount = 1;
            }
            String costFormula = aEqMod.getCost();
            if (aEqMod.getAssociatedCount() > 0 && !costFormula.equals(aEqMod.getCost(0))) {
                eqModCost2 = BigDecimalHelper.ZERO;
                for (int idx = 0; idx < aEqMod.getAssociatedCount(); ++idx) {
                    costFormula = aEqMod.getCost(idx);
                    BigDecimal thisModCost = new BigDecimal(this.getVariableValue(costFormula, "", "", true, aPC).toString());
                    eqModCost2 = eqModCost2.add(thisModCost);
                    if (!aEqMod.getCostDouble()) {
                        nonDoubleCost = nonDoubleCost.add(thisModCost);
                        continue;
                    }
                    modifierCosts.add(thisModCost);
                }
                iCount = 1;
            } else {
                eqModCost2 = new BigDecimal(this.getVariableValue(costFormula, "", "", true, aPC).toString());
                if (!aEqMod.getCostDouble()) {
                    nonDoubleCost = nonDoubleCost.add(eqModCost2);
                } else {
                    modifierCosts.add(eqModCost2);
                }
            }
            c = c.add(eqModCost2.multiply(new BigDecimal(Integer.toString(this.getBaseQty() * iCount))));
            iPlus += aEqMod.getPlus() * iCount;
        }
        if (modifierCosts.size() > 1) {
            Collections.sort(modifierCosts);
        }
        e2 = this.altEqModifierList.iterator();
        while (e2.hasNext()) {
            aEqMod = (EquipmentModifier)e2.next();
            iCount = aEqMod.getAssociatedCount();
            if (iCount < 1) {
                iCount = 1;
            }
            String costFormula = aEqMod.getCost();
            BigDecimal eqModCost3 = new BigDecimal(this.getVariableValue(costFormula, "", "", false, aPC).toString());
            c = c.add(eqModCost3.multiply(new BigDecimal(Integer.toString(this.getBaseQty() * iCount))));
            altPlus += aEqMod.getPlus() * iCount;
        }
        this.calculatingCost = false;
        if ((c = c.add(this.getCostFromPluses(iPlus, altPlus))).compareTo(BigDecimalHelper.ZERO) != 0) {
            int baseQ = this.getBaseQty();
            itemCost = new BigDecimal(Math.ceil(itemCost.doubleValue() / (double)baseQ) * (double)baseQ);
        }
        if (!(this.isAmmunition() || this.isArmor() || this.isShield() || this.isWeapon())) {
            if (!this.isMagicLimitedType()) {
                if (!this.ignoresCostDouble()) {
                    c = c.subtract(nonDoubleCost).multiply(new BigDecimal("2"));
                    c = c.add(nonDoubleCost);
                }
            } else {
                for (int i = modifierCosts.size() - 2; i >= 0; --i) {
                    c = c.add((BigDecimal)modifierCosts.get(i));
                }
            }
        }
        return c.add(itemCost).add(this.costMod);
    }

    public void setCritMult(String aString) {
        this.critMult = this.parseCritMult(aString);
    }

    public String getCritMult() {
        return Equipment.multAsString(this.getCritMultiplier(true));
    }

    public void setCritRange(String aString) {
        this.critRange = aString;
    }

    public String getCritRange(PlayerCharacter aPC) {
        return this.getCritRange(aPC, true);
    }

    public int getCritRangeAdd(PlayerCharacter aPC, boolean bPrimary) {
        return (int)this.bonusTo(aPC, "EQMWEAPON", "CRITRANGEADD", bPrimary);
    }

    public int getCritRangeDouble(PlayerCharacter aPC, boolean bPrimary) {
        return (int)this.bonusTo(aPC, "EQMWEAPON", "CRITRANGEDOUBLE", bPrimary);
    }

    public void setDamage(String aString) {
        this.damage = aString;
    }

    public String getDamage(PlayerCharacter aPC) {
        return this.getDamage(aPC, true);
    }

    public boolean isDouble() {
        return this.isType("DOUBLE");
    }

    public static SortedSet getEquipmentTypes() {
        return s_equipmentTypes;
    }

    public void setCostMod(String aString) {
        try {
            this.costMod = new BigDecimal(aString);
        }
        catch (NumberFormatException e) {
            this.costMod = BigDecimalHelper.ZERO;
        }
    }

    public void setCostMod(BigDecimal aCost) {
        this.costMod = aCost;
    }

    public BigDecimal getCostMod() {
        return this.costMod;
    }

    public boolean isEitherType(String aType) {
        return this.isType(aType, true) | this.isType(aType, false);
    }

    public Iterator getEqModifierIterator(boolean bPrimary) {
        if (bPrimary) {
            if (this.eqModifierList == null) {
                return EmptyIterator.EMPTY_ITERATOR;
            }
            return this.eqModifierList.iterator();
        }
        if (this.altEqModifierList == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.altEqModifierList.iterator();
    }

    public EquipmentModifier getEqModifierKeyed(String eqModKey, boolean bPrimary) {
        List eqModList = this.getEqModifierList(bPrimary);
        if (eqModList.size() != 0) {
            Iterator e = eqModList.iterator();
            while (e.hasNext()) {
                EquipmentModifier aEqMod = (EquipmentModifier)e.next();
                if (!aEqMod.getKeyName().equals(eqModKey)) continue;
                return aEqMod;
            }
        }
        return null;
    }

    public List getEqModifierList(boolean bPrimary) {
        if (bPrimary) {
            return this.eqModifierList;
        }
        return this.altEqModifierList;
    }

    public void addToEqModifierList(EquipmentModifier eqMod) {
        this.typeListCachePrimary = null;
        this.eqModifierList.add(eqMod);
        this.setDirty(true);
    }

    public boolean isEquipped() {
        return this.equipped;
    }

    public boolean isExtra() {
        return this.isType("EXTRA");
    }

    public void setHands(int argHands) {
        this.slots = argHands;
    }

    public int getHands(PlayerCharacter aPC) {
        return this.getSlots(aPC);
    }

    public static String getLocationName(int slotNumber) {
        if (slotNumber < 0 || slotNumber > locationStringList.length) {
            return locationStringList[0];
        }
        return locationStringList[slotNumber];
    }

    public static int getLocationNum(String locDesc) {
        for (int i = 0; i < locationStringList.length; ++i) {
            if (!locationStringList[i].equals(locDesc)) continue;
            return i;
        }
        if (locDesc.equals("None")) {
            return 8;
        }
        if (locDesc.startsWith(CONTAINED_STR)) {
            return 7;
        }
        try {
            return Integer.parseInt(locDesc);
        }
        catch (NumberFormatException nfe) {
            return 7;
        }
    }

    public boolean isHeavy() {
        return this.isType("HEAVY");
    }

    public String getInterestingDisplayString(PlayerCharacter aPC) {
        StringBuffer s = new StringBuffer();
        String t = this.getSpecialProperties(aPC);
        if (t == null) {
            t = "";
        }
        Iterator mI = this.getActiveBonuses(aPC).iterator();
        while (mI.hasNext()) {
            BonusObj aBonus = (BonusObj)mI.next();
            String eqBonus = aBonus.toString();
            if (eqBonus.length() <= 0 || eqBonus.startsWith("EQM")) continue;
            if (s.length() != 0) {
                s.append(", ");
            }
            s.append(eqBonus);
        }
        if (t.length() != 0) {
            if (s.length() != 0) {
                s.append('|');
            }
            s.append(t);
        }
        return s.toString();
    }

    public void setIsEquipped(boolean aFlag, PlayerCharacter aPC) {
        this.equipped = aFlag;
        if (this.equipped) {
            this.activateBonuses(aPC);
        } else {
            this.deactivateBonuses();
        }
    }

    public String getItemNameFromModifiers() {
        ArrayList modList = new ArrayList(this.eqModifierList);
        ArrayList altModList = new ArrayList(this.altEqModifierList);
        ArrayList commonList = new ArrayList();
        if (this.baseItem.length() == 0) {
            return this.getName();
        }
        Equipment baseEquipment = EquipmentList.getEquipmentKeyed(this.baseItem);
        if (baseEquipment != null) {
            int idx;
            Iterator e = baseEquipment.getEqModifierList(true).iterator();
            while (e.hasNext()) {
                idx = modList.indexOf(e.next());
                if (idx < 0) continue;
                modList.remove(idx);
            }
            e = baseEquipment.getEqModifierList(false).iterator();
            while (e.hasNext()) {
                idx = altModList.indexOf(e.next());
                if (idx < 0) continue;
                altModList.remove(idx);
            }
        }
        for (int i = modList.size() - 1; i >= 0; --i) {
            EquipmentModifier eqMod = (EquipmentModifier)modList.get(i);
            if (eqMod.getVisible() != 0) continue;
            modList.remove(i);
        }
        Equipment.extractListFromCommon(commonList, modList);
        this.removeCommonFromList(altModList, commonList, "eqMod expected but not found: ");
        String eqMaster = "";
        Iterator e = commonList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            if (!"MASTERWORK".equalsIgnoreCase(eqMod.getName())) continue;
            eqMaster = eqMod.getName();
            break;
        }
        String magic1 = Equipment.getMagicBonus(this.eqModifierList);
        String desc1 = Equipment.getNameFromModifiers(modList, magic1, "");
        String magic2 = "";
        String desc2 = "";
        if (this.isDouble()) {
            magic2 = Equipment.getMagicBonus(this.altEqModifierList);
            desc2 = Equipment.getNameFromModifiers(altModList, magic2, "");
        }
        StringBuffer common = new StringBuffer(Equipment.getNameFromModifiers(commonList, magic1 + magic2, eqMaster));
        String baseName = this.getBaseItemName().trim();
        int idx = baseName.indexOf(40);
        StringBuffer itemName = idx >= 0 ? new StringBuffer(baseName.substring(0, idx - 1).trim()) : new StringBuffer(baseName);
        if (magic1.length() != 0 || magic2.length() != 0) {
            itemName.append(' ');
            if (magic1.length() != 0) {
                itemName.append(magic1);
            } else {
                itemName.append('-');
            }
            if (this.isDouble()) {
                itemName.append('/');
                if (magic2.length() != 0) {
                    itemName.append(magic2);
                } else {
                    itemName.append('-');
                }
            }
        }
        if (idx >= 0) {
            itemName.append(' ');
            itemName.append(baseName.substring(idx));
        }
        if ((idx = itemName.toString().lastIndexOf(41)) >= 0) {
            itemName.setLength(idx);
            itemName.append('/');
        } else {
            itemName.append(" (");
        }
        int iSize = Globals.sizeInt(this.getSize(), 4);
        if (Globals.sizeInt(this.getBaseSize(), 4) != iSize) {
            if (common.length() != 0) {
                common.append('/');
            }
            common.append(SystemCollections.getSizeAdjustmentAtIndex(iSize).getName());
        }
        if (desc1.length() == 0 && desc2.length() == 0) {
            itemName.append(String.valueOf(common));
        } else if (!this.isDouble()) {
            itemName.append(desc1).append('/').append(String.valueOf(common));
        } else {
            if (common.length() != 0) {
                itemName.append(String.valueOf(common)).append(';');
            }
            if (desc1.length() != 0) {
                itemName.append(desc1);
            } else {
                itemName.append('-');
            }
            itemName.append(';');
            if (desc2.length() != 0) {
                itemName.append(desc2);
            } else {
                itemName.append('-');
            }
        }
        if (itemName.toString().endsWith("/") || itemName.toString().endsWith(";")) {
            itemName.setLength(itemName.length() - 1);
        }
        itemName.append(')');
        idx = itemName.toString().indexOf(" ()");
        if (idx >= 0) {
            itemName.setLength(idx);
        }
        return itemName.toString();
    }

    public boolean isLight() {
        return this.isType("LIGHT");
    }

    public void setLocation(int newLocation) {
        if (newLocation < 0 || newLocation > 8) {
            ShowMessageDelegate.showMessageDialog("Location " + newLocation + " unknown.", "PCGen", MessageType.INFORMATION);
            return;
        }
        if (newLocation == 5) {
            this.location = newLocation;
            this.equipped = true;
        } else if (newLocation >= 0 && newLocation <= 4) {
            this.location = newLocation;
            this.equipped = true;
        } else if (newLocation == 8) {
            this.location = 8;
            this.equipped = false;
        } else {
            this.location = 6;
            this.equipped = false;
        }
    }

    public int getLocation() {
        return this.location;
    }

    public void setLongName(String aString) {
        this.longName = aString;
    }

    public boolean isMagic() {
        return this.isType("MAGIC");
    }

    public int getMaxCharges() {
        Iterator e = this.getEqModifierIterator(true);
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            int maxCharges = eqMod.getMaxCharges();
            if (maxCharges <= 0) continue;
            return maxCharges;
        }
        return 0;
    }

    public void setMaxDex(String aString) {
        try {
            this.maxDex = Delta.decode(aString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Integer getMaxDex(PlayerCharacter aPC) {
        int mdex = this.maxDex + (int)this.bonusTo(aPC, "EQMARMOR", "MAXDEX", true);
        if (mdex > 100) {
            mdex = 100;
        }
        if (mdex < 0) {
            mdex = 0;
        }
        return new Integer(mdex);
    }

    public boolean isMedium() {
        return this.isType("MEDIUM");
    }

    public boolean isMelee() {
        return this.isType("MELEE");
    }

    public void setMemberOfKit(int kitNo) {
        this.memberKit = kitNo;
    }

    public int getMemberOfKit() {
        return this.memberKit;
    }

    public int getMinCharges() {
        Iterator e = this.getEqModifierIterator(true);
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            int minCharges = eqMod.getMinCharges();
            if (minCharges <= 0) continue;
            return minCharges;
        }
        return 0;
    }

    public void setName(String aString) {
        super.setName(aString);
        this.setDirty(true);
    }

    public void setModifiedName(String nameString) {
        this.modifiedName = nameString;
        this.setDirty(true);
    }

    public void setModifiersAllowed(boolean argModifiersAllowed) {
        this.modifiersAllowed = argModifiersAllowed;
    }

    public void setModifiersRequired(boolean argModifiersRequired) {
        this.modifiersRequired = argModifiersRequired;
    }

    public boolean getModifiersRequired() {
        return this.modifiersRequired;
    }

    public boolean isMonk() {
        return this.isType("MONK");
    }

    public void setMoveString(String aString) {
        this.moveString = aString;
    }

    public String getName() {
        return this.toString();
    }

    public boolean isNatural() {
        return this.isType("NATURAL");
    }

    public void setNote(String aString) {
        this.noteString = aString;
    }

    public String getNote() {
        return this.noteString;
    }

    public void setNumberCarried(Float aNumber) {
        this.carried = aNumber;
    }

    public void setNumberEquipped(int num) {
        this.numberEquipped = num;
        if (num > 0) {
            this.equipped = true;
        }
    }

    public int getNumberEquipped() {
        return this.numberEquipped;
    }

    public void setOnlyNaturalWeapon(boolean onlyNaturalWeapon) {
        this.isOnlyNaturalWeapon = onlyNaturalWeapon;
    }

    public boolean isOnlyNaturalWeapon() {
        return this.isOnlyNaturalWeapon;
    }

    public void setOutputIndex(int newIndex) {
        this.outputIndex = newIndex;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public void setParent(EquipmentCollection parent) {
        this.d_parent = parent;
    }

    public EquipmentCollection getParent() {
        return this.d_parent;
    }

    public String getParentName() {
        Equipment anEquip = (Equipment)this.getParent();
        if (anEquip != null) {
            return anEquip.toString();
        }
        if (this.isEquipped()) {
            return EQUIPPED_NEITHER_STR;
        }
        if (this.numberCarried().intValue() > 0) {
            return CARRIED_NEITHER_STR;
        }
        return "";
    }

    public boolean isPreType(String aType) {
        if (aType.startsWith(".IF.TYPE=")) {
            StringTokenizer aTok = new StringTokenizer(aType.substring(9), ".");
            boolean typeFound = false;
            String falsePart = "";
            int idx = aType.indexOf(".THEN.");
            if (idx < 0) {
                return false;
            }
            String truePart = aType.substring(idx + 6);
            aType = aType.substring(0, idx);
            idx = truePart.indexOf(".ELSE.");
            if (idx >= 0) {
                falsePart = truePart.substring(idx + 6);
                truePart = truePart.substring(0, idx);
            }
            while (aTok.hasMoreTokens()) {
                String aString = aTok.nextToken();
                if (!this.isType(aString, this.bonusPrimary)) continue;
                typeFound = true;
                break;
            }
            if ((aType = typeFound ? truePart : falsePart).length() == 0) {
                return true;
            }
        }
        if (aType.startsWith("EQMODTYPE=") || aType.startsWith("EQMODTYPE.")) {
            aType = aType.substring(10);
            Iterator e = this.getEqModifierList(this.bonusPrimary).iterator();
            while (e.hasNext()) {
                EquipmentModifier eqMod = (EquipmentModifier)e.next();
                if (!eqMod.isType(aType)) continue;
                return true;
            }
            return false;
        }
        if (aType.startsWith("EQMOD=") || aType.startsWith("EQMOD.")) {
            return this.getEqModifierKeyed(aType = aType.substring(6), this.bonusPrimary) != null;
        }
        return this.isType(aType, this.bonusPrimary);
    }

    public void setProfName(String aString) {
        this.profName = aString;
    }

    public void setQty(String aString) {
        try {
            this.setQty(Double.parseDouble(aString));
        }
        catch (NumberFormatException nfe) {
            this.qty = 0.0;
        }
    }

    public void setQty(Float aFloat) {
        this.setQty(aFloat.doubleValue());
    }

    public Float getQty() {
        return new Float(this.qty);
    }

    public void setRange(String aString) {
        try {
            this.range = Delta.decode(aString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Integer getRange(PlayerCharacter aPC) {
        String aRange;
        Integer myRange = this.range;
        if (myRange == 0 && (aRange = this.getWeaponInfo("RANGE", true)).length() != 0) {
            myRange = new Integer(aRange);
        }
        int r = myRange + (int)this.bonusTo(aPC, "EQMWEAPON", "RANGEADD", true);
        int i = (int)this.bonusTo(aPC, "EQMWEAPON", "RANGEMULT", true);
        double rangeMult = 1.0;
        if (i > 0) {
            rangeMult += (double)(i - 1);
        }
        int postAdd = 0;
        if (aPC != null) {
            if (this.isThrown()) {
                r += (int)aPC.getTotalBonusTo("RANGEADD", "THROWN");
                postAdd = (int)aPC.getTotalBonusTo("POSTRANGEADD", "THROWN");
                rangeMult += (double)((int)aPC.getTotalBonusTo("RANGEMULT", "THROWN")) / 100.0;
            } else if (this.isProjectile()) {
                r += (int)aPC.getTotalBonusTo("RANGEADD", "PROJECTILE");
                postAdd = (int)aPC.getTotalBonusTo("POSTRANGEADD", "PROJECTILE");
                rangeMult += (double)((int)aPC.getTotalBonusTo("RANGEMULT", "PROJECTILE")) / 100.0;
            }
        }
        r = (int)((double)r * rangeMult);
        if ((this.isRanged() || this.isThrown() || this.isProjectile()) && (r += postAdd) <= 0) {
            r = 10;
        }
        return new Integer(r);
    }

    public List getRangeList(boolean addShortRange, PlayerCharacter aPC) {
        int baseRange;
        ArrayList<String> aList = new ArrayList<String>();
        int aRange = baseRange = this.getRange(aPC).intValue();
        int maxIncrements = 0;
        if (this.isRanged()) {
            maxIncrements = this.isThrown() ? 5 : 10;
        }
        for (int numIncrements = 0; numIncrements < maxIncrements; ++numIncrements) {
            if (aRange == SettingsHandler.getGame().getShortRangeDistance()) {
                addShortRange = false;
            }
            if (aRange > SettingsHandler.getGame().getShortRangeDistance() && addShortRange) {
                aList.add(Integer.toString(SettingsHandler.getGame().getShortRangeDistance()));
                addShortRange = false;
            }
            aList.add(Integer.toString(aRange));
            aRange += baseRange;
        }
        return aList;
    }

    public boolean isRanged() {
        return this.isType("RANGED");
    }

    public void setRateOfFire(String rateOfFire) {
        this.rateOfFire = rateOfFire;
    }

    public String getRateOfFire() {
        return this.rateOfFire;
    }

    public int getRawCritRange() {
        return this.getRawCritRange(true);
    }

    public int getRawCritRange(boolean bPrimary) {
        String cr;
        String string = cr = bPrimary ? this.critRange : this.altCritRange;
        if (cr.length() == 0) {
            cr = this.getWeaponInfo("CRITRANGE", true);
        }
        if (cr.length() != 0) {
            try {
                return Integer.parseInt(cr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getRawSpecialProperties() {
        StringBuffer retString = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.specialPropertyList.size(); ++i) {
            SpecialProperty sprop = (SpecialProperty)this.specialPropertyList.get(i);
            if (!first) {
                retString.append(", ");
            }
            first = false;
            retString.append(sprop.getParsedText());
        }
        return retString.toString();
    }

    public void setReach(int newReach) {
        this.reach = newReach;
    }

    public int getReach() {
        return this.reach;
    }

    public void setRemainingCharges(int remainingCharges) {
        Iterator e = this.getEqModifierIterator(true);
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            if (eqMod.getMinCharges() <= 0) continue;
            eqMod.setRemainingCharges(remainingCharges);
        }
    }

    public int getRemainingCharges() {
        Iterator e = this.getEqModifierIterator(true);
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            if (eqMod.getMinCharges() <= 0) continue;
            return eqMod.getRemainingCharges();
        }
        return -1;
    }

    public boolean isShield() {
        return this.isType("SHIELD");
    }

    public String getSimpleName() {
        return this.name;
    }

    public void setSize(String sizeString, boolean bBase) {
        if (sizeString.length() > 1) {
            sizeString = sizeString.toUpperCase().substring(0, 1);
        }
        this.size = sizeString;
        if (bBase) {
            this.sizeBase = sizeString;
        }
    }

    public String getSize() {
        return this.size;
    }

    public void setSlots(int i) {
        this.slots = i;
    }

    public int getSlots(PlayerCharacter aPC) {
        int iSlots = this.slots;
        Iterator e = this.eqModifierList.iterator();
        while (e.hasNext()) {
            EquipmentModifier aEqMod = (EquipmentModifier)e.next();
            iSlots += (int)aEqMod.bonusTo(aPC, "EQM", "HANDS", this);
            iSlots += (int)aEqMod.bonusTo(aPC, "EQM", "SLOTS", this);
        }
        if (iSlots < 0) {
            iSlots = 0;
        }
        return iSlots;
    }

    public String getSource() {
        String aString = super.getSource();
        if (this.isType("CUSTOM")) {
            aString = "Custom - " + aString;
        }
        return aString;
    }

    public void addSpecialProperty(SpecialProperty sprop) {
        this.specialPropertyList.add(sprop);
    }

    public String getSpecialProperties(PlayerCharacter aPC) {
        ArrayList list1 = new ArrayList(this.eqModifierList);
        ArrayList list2 = new ArrayList(this.altEqModifierList);
        ArrayList comn = new ArrayList();
        Equipment.extractListFromCommon(comn, list1);
        this.removeCommonFromList(list2, comn, "SPROP: eqMod expected but not found: ");
        String common = CoreUtility.commaDelimit(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(comn, aPC), true, aPC));
        String saList1 = CoreUtility.commaDelimit(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(list1, aPC), true, aPC));
        String saList2 = CoreUtility.commaDelimit(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(list2, aPC), false, aPC));
        StringBuffer sp = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.specialPropertyList.size(); ++i) {
            SpecialProperty sprop = (SpecialProperty)this.specialPropertyList.get(i);
            String text = sprop.getParsedText(aPC);
            if (text.equals("")) continue;
            if (!first) {
                sp.append(", ");
            }
            first = false;
            sp.append(text);
        }
        if (common.length() != 0) {
            if (!first) {
                sp.append(", ");
            }
            first = false;
            sp.append(common);
        }
        if (saList1.length() != 0) {
            if (!first) {
                sp.append(", ");
            }
            first = false;
            if (this.isDouble()) {
                sp.append("Head1: ");
            }
            sp.append(saList1);
        }
        if (this.isDouble() && saList2.length() != 0) {
            if (!first) {
                sp.append(", ");
            }
            first = false;
            sp.append("Head2: ").append(saList2);
        }
        return sp.toString();
    }

    public void setSpellFailure(String aString) {
        try {
            this.spellFailure = Delta.decode(aString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isSuit() {
        return this.isType("SUIT");
    }

    public boolean isThrown() {
        return this.isType("THROWN");
    }

    public String getType() {
        return this.getType(true);
    }

    public boolean isType(String aType) {
        return this.isType(aType, true);
    }

    public boolean isType(String aType, boolean bPrimary) {
        if (!bPrimary && !this.isDouble()) {
            return false;
        }
        List tList = this.typeList(bPrimary);
        return tList.contains(aType.toUpperCase());
    }

    public Equipment getUberParent() {
        if (this.getParent() == null) {
            return this;
        }
        Equipment anEquip = (Equipment)this.getParent();
        while (anEquip.getParent() != null) {
            anEquip = (Equipment)anEquip.getParent();
        }
        return anEquip;
    }

    public boolean isUnarmed() {
        return this.isType("UNARMED");
    }

    public int getUsedCharges() {
        Iterator e = this.getEqModifierIterator(true);
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            if (eqMod.getMinCharges() <= 0) continue;
            return eqMod.getUsedCharges();
        }
        return -1;
    }

    public Float getVariableValue(String aString, String src, String subSrc, PlayerCharacter aPC) {
        return this.getVariableValue(aString, src, subSrc, this.bonusPrimary, aPC);
    }

    public Float getVariableValue(String aString, String src, String subSrc, boolean bPrimary, PlayerCharacter aPC) {
        Float total = new Float(0.0);
        Float total1 = null;
        while (aString.lastIndexOf(40) >= 0) {
            int x = CoreUtility.innerMostStringStart(aString);
            int y = CoreUtility.innerMostStringEnd(aString);
            if (y < x) {
                Logging.errorPrint("Missing closing parenthesis: " + aString);
                return total;
            }
            String bString = aString.substring(x + 1, y);
            aString = aString.substring(0, x) + this.getVariableValue(bString, src, subSrc, bPrimary, aPC) + aString.substring(y + 1);
        }
        String delimiter = "+-/*";
        String valString = "";
        int mode = 0;
        int nextMode = 0;
        int endMode = 0;
        if (aString.startsWith(".IF.")) {
            StringTokenizer aTok = new StringTokenizer(aString.substring(4), ".", true);
            StringBuffer bString = new StringBuffer();
            Float val1 = null;
            Float val2 = null;
            Float valt = null;
            int comp = 0;
            while (aTok.hasMoreTokens()) {
                String cString = aTok.nextToken();
                if ("GT".equals(cString) || "GTEQ".equals(cString) || "EQ".equals(cString) || "LTEQ".equals(cString) || "LT".equals(cString)) {
                    val1 = this.getVariableValue(bString.substring(0, bString.length() - 1), src, subSrc, bPrimary, aPC);
                    aTok.nextToken();
                    bString = new StringBuffer();
                    if ("LT".equals(cString)) {
                        comp = 1;
                        continue;
                    }
                    if ("LTEQ".equals(cString)) {
                        comp = 2;
                        continue;
                    }
                    if ("EQ".equals(cString)) {
                        comp = 3;
                        continue;
                    }
                    if ("GT".equals(cString)) {
                        comp = 4;
                        continue;
                    }
                    if (!"GTEQ".equals(cString)) continue;
                    comp = 5;
                    continue;
                }
                if ("THEN".equals(cString)) {
                    val2 = this.getVariableValue(bString.substring(0, bString.length() - 1), src, subSrc, bPrimary, aPC);
                    aTok.nextToken();
                    bString = new StringBuffer();
                    continue;
                }
                if ("ELSE".equals(cString)) {
                    valt = this.getVariableValue(bString.substring(0, bString.length() - 1), src, subSrc, bPrimary, aPC);
                    aTok.nextToken();
                    bString = new StringBuffer();
                    continue;
                }
                bString.append(cString);
            }
            if (val1 != null && val2 != null && valt != null) {
                Float valf = this.getVariableValue(bString.toString(), src, subSrc, bPrimary, aPC);
                total = valt;
                switch (comp) {
                    case 1: {
                        if (!(val1.doubleValue() >= val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    case 2: {
                        if (!(val1.doubleValue() > val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    case 3: {
                        if (CoreUtility.doublesEqual(val1.doubleValue(), val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    case 4: {
                        if (!(val1.doubleValue() <= val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    case 5: {
                        if (!(val1.doubleValue() < val2.doubleValue())) break;
                        total = valf;
                        break;
                    }
                    default: {
                        Logging.errorPrint("ERROR - badly formed statement:" + aString + ":" + val1.toString() + ":" + val2.toString() + ":" + comp);
                        return new Float(0.0);
                    }
                }
                return total;
            }
        }
        for (int i = 0; i < aString.length(); ++i) {
            block77: {
                block79: {
                    RollInfo aRollInfo;
                    block80: {
                        block81: {
                            block78: {
                                valString = valString + aString.substring(i, i + 1);
                                if (i != aString.length() - 1 && ("+-/*".lastIndexOf(aString.charAt(i)) <= -1 || valString.length() <= 1) && (valString.length() <= 3 || !valString.endsWith("MIN") && !valString.endsWith("MAX") && !valString.endsWith("REQ"))) continue;
                                if ("+-/*".lastIndexOf(aString.charAt(i)) > -1) {
                                    valString = valString.substring(0, valString.length() - 1);
                                }
                                if (!"SIZE".equals(valString)) break block78;
                                valString = String.valueOf(this.sizeInt());
                                break block79;
                            }
                            if (!valString.startsWith("EQUIP.SIZE")) break block80;
                            if (!valString.equals("EQUIP.SIZE")) break block81;
                            valString = this.getSize();
                            break block79;
                        }
                        if (!valString.substring(11).equals("INT")) break block79;
                        valString = String.valueOf(this.sizeInt());
                        break block79;
                    }
                    if ("WT".equals(valString)) {
                        if (this.calculatingCost && this.weightAlreadyUsed) {
                            valString = "0";
                        } else {
                            if (this.calculatingCost && this.isAmmunition()) {
                                Float unitWeight = new Float(this.weightInPounds / (double)this.getBaseQty());
                                valString = unitWeight.toString();
                            } else {
                                valString = String.valueOf(this.weightInPounds);
                            }
                            this.weightAlreadyUsed = true;
                        }
                    } else if ("BASECOST".equals(valString)) {
                        valString = this.getBaseCost().toString();
                    } else if ("DMGDIE".equals(valString)) {
                        aRollInfo = new RollInfo(this.getDamage(aPC));
                        valString = Integer.toString(aRollInfo.sides);
                    } else if ("DMGDICE".equals(valString)) {
                        aRollInfo = new RollInfo(this.getDamage(aPC));
                        valString = Integer.toString(aRollInfo.times);
                    } else if ("EQACCHECK".equals(valString)) {
                        valString = this.acCheck.toString();
                    } else if ("EQHANDS".equals(valString)) {
                        valString = Integer.toString(this.slots);
                    } else if ("EQSPELLFAIL".equals(valString)) {
                        valString = this.spellFailure.toString();
                    } else if ("RANGE".equals(valString)) {
                        valString = this.range.toString();
                    } else if ("CRITMULT".equals(valString)) {
                        valString = bPrimary ? String.valueOf(this.getCritMultiplier()) : String.valueOf(this.getAltCritMultiplier());
                    } else {
                        for (int j = 0; j < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++j) {
                            if (!valString.equals(SettingsHandler.getGame().s_ATTRIBSHORT[j])) continue;
                            valString = String.valueOf(aPC.getStatList().getStatModFor(SettingsHandler.getGame().s_ATTRIBSHORT[j]));
                            break;
                        }
                    }
                }
                if (i < aString.length()) {
                    if (valString.endsWith(".TRUNC")) {
                        valString = String.valueOf(this.getVariableValue(valString.substring(0, valString.length() - 6), "", "", bPrimary, aPC).intValue());
                    }
                    if (valString.endsWith(".INTVAL")) {
                        valString = this.getVariableValue(valString.substring(0, valString.length() - 7), "", "", bPrimary, aPC).toString();
                        endMode += 10;
                    }
                    if (valString.endsWith("MIN")) {
                        valString = this.getVariableValue(valString.substring(0, valString.length() - 3), "", "", bPrimary, aPC).toString();
                        nextMode = 0;
                        ++endMode;
                    } else if (valString.endsWith("MAX")) {
                        valString = this.getVariableValue(valString.substring(0, valString.length() - 3), "", "", bPrimary, aPC).toString();
                        nextMode = 0;
                        endMode += 2;
                    } else if (valString.endsWith("REQ")) {
                        valString = this.getVariableValue(valString.substring(0, valString.length() - 3), "", "", bPrimary, aPC).toString();
                        nextMode = 0;
                        endMode += 3;
                    } else if (aString.charAt(i) == '+') {
                        nextMode = 0;
                    } else if (aString.charAt(i) == '-') {
                        nextMode = 1;
                    } else if (aString.charAt(i) == '*') {
                        nextMode = 2;
                    } else if (aString.charAt(i) == '/') {
                        nextMode = 3;
                    }
                }
                try {
                    Double.parseDouble(valString);
                }
                catch (NumberFormatException nfe) {
                    if (aPC == null) break block77;
                    valString = aPC.getVariableValue(valString, src).toString();
                }
            }
            try {
                if (valString.length() > 0) {
                    switch (mode) {
                        case 0: {
                            total = new Float(total.doubleValue() + Double.parseDouble(valString));
                            break;
                        }
                        case 1: {
                            total = new Float(total.doubleValue() - Double.parseDouble(valString));
                            break;
                        }
                        case 2: {
                            total = new Float(total.doubleValue() * Double.parseDouble(valString));
                            break;
                        }
                        case 3: {
                            total = new Float(total.doubleValue() / Double.parseDouble(valString));
                            break;
                        }
                    }
                }
            }
            catch (NumberFormatException exc) {
                if (aPC != null) {
                    return aPC.getVariableValue(aString, src);
                }
                Logging.errorPrint("Equipment:Math error determining value for " + aString + " " + src + " " + subSrc + "(" + valString + ")", exc);
            }
            mode = nextMode;
            nextMode = 0;
            valString = "";
            if (total1 != null || endMode % 10 == 0) continue;
            total1 = total;
            total = new Float(0.0);
        }
        if (total1 != null) {
            if (endMode % 10 == 1) {
                total = new Float(Math.min(total.doubleValue(), total1.doubleValue()));
            }
            if (endMode % 10 == 2) {
                total = new Float(Math.max(total.doubleValue(), total1.doubleValue()));
            }
            if (endMode % 10 == 3) {
                total = total1.doubleValue() < total.doubleValue() ? new Float(0.0) : total1;
            }
        }
        if (endMode / 10 > 0) {
            total = new Float(total.intValue());
        }
        return total;
    }

    public List getVirtualFeatList() {
        List vFeats = new ArrayList(super.getVirtualFeatList());
        boolean bPrimary = true;
        vFeats = this.addEqModList(bPrimary, vFeats);
        bPrimary = false;
        vFeats = this.addEqModList(bPrimary, vFeats);
        return vFeats;
    }

    public boolean isVisible(EquipmentModifier eqMod) {
        int vis = eqMod.getVisible();
        if (vis == 2) {
            return eqMod.passesPreReqToGain(this);
        }
        return vis == 1;
    }

    public boolean isWeapon() {
        return this.isType("WEAPON");
    }

    public void setWeight(String aString) {
        try {
            this.weightInPounds = Double.parseDouble(aString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Float getWeight(PlayerCharacter aPC) {
        return new Float(this.getWeightAsDouble(aPC));
    }

    public double getBaseWeightAsDouble() {
        double aWeight = this.weightInPounds;
        return Globals.convertWeightToUnitSet(aWeight += this.weightMod.doubleValue());
    }

    public double getWeightAsDouble(PlayerCharacter aPC) {
        double f = this.bonusTo(aPC, "EQM", "WEIGHTMULT", true);
        if (CoreUtility.doublesEqual(f, 0.0)) {
            f = 1.0;
        }
        double aWeight = this.weightInPounds * f;
        f = this.bonusTo(aPC, "EQM", "WEIGHTDIV", true);
        if (CoreUtility.doublesEqual(f, 0.0)) {
            f = 1.0;
        }
        aWeight /= f;
        aWeight += this.bonusTo(aPC, "EQM", "WEIGHTADD", true);
        return Globals.convertWeightToUnitSet(aWeight += this.weightMod.doubleValue());
    }

    public void setWeightMod(String aString) {
        try {
            this.weightMod = new BigDecimal(aString);
        }
        catch (NumberFormatException e) {
            this.weightMod = BigDecimalHelper.ZERO;
        }
    }

    public void setDamageMod(String aString) {
        this.damageMod = aString;
    }

    public String getDamageMod() {
        return this.damageMod;
    }

    public void setWield(String aString) {
        this.wieldString = aString;
        this.hasWield = true;
    }

    public String getWield() {
        return this.wieldString;
    }

    public Integer acCheck(PlayerCharacter aPC) {
        int check = this.acCheck + (int)this.bonusTo(aPC, "EQMARMOR", "ACCHECK", true);
        if (check > 0) {
            check = 0;
        }
        return new Integer(check);
    }

    public boolean acceptsChildren() {
        return this.d_acceptsChildren;
    }

    public void addEqModifier(String aString, boolean bPrimary) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        String eqModKey = aTok.nextToken();
        EquipmentModifier eqMod = this.getEqModifierKeyed(eqModKey, bPrimary);
        if (eqMod == null) {
            if (eqModKey.equals(EQMOD_WEIGHT)) {
                if (aTok.hasMoreTokens()) {
                    this.setWeightMod(aTok.nextToken().replace(',', '.'));
                }
                return;
            }
            if (eqModKey.equals(EQMOD_DAMAGE)) {
                if (aTok.hasMoreTokens()) {
                    this.setDamageMod(aTok.nextToken());
                }
                return;
            }
            eqMod = EquipmentList.getModifierKeyed(eqModKey);
            if (eqMod == null) {
                Logging.errorPrint("Could not find EquipmentModifier: " + eqModKey);
                return;
            }
            if (eqMod.getChoiceString().length() != 0) {
                eqMod = (EquipmentModifier)eqMod.clone();
            }
            this.addToEqModifierList(eqMod);
        }
        if (eqMod.getChoiceString().length() != 0) {
            while (aTok.hasMoreTokens()) {
                String x = aTok.nextToken();
                eqMod.addAssociated(x.replace('=', '|'));
            }
        }
    }

    public void addEqModifier(EquipmentModifier eqMod, boolean bPrimary, PlayerCharacter aPC) {
        this.addEqModifier(eqMod, bPrimary, aPC, null, null);
    }

    public void addEqModifier(EquipmentModifier eqMod, boolean bPrimary, PlayerCharacter aPC, String selectedChoice, EquipmentChoice equipChoice) {
        EquipmentModifier aMod;
        EquipmentModifier aMod2;
        int i;
        boolean bImporting = false;
        if (aPC != null && aPC.isImporting()) {
            bImporting = true;
        }
        if (!bImporting && !this.canAddModifier(eqMod, bPrimary)) {
            return;
        }
        List eqModList = this.getEqModifierList(bPrimary);
        for (i = eqModList.size() - 1; i >= 0; --i) {
            aMod2 = (EquipmentModifier)eqModList.get(i);
            if (!eqMod.willReplace(aMod2.getKeyName())) continue;
            eqModList.remove(i);
            if (bPrimary) {
                this.typeListCachePrimary = null;
            } else {
                this.typeListCacheSecondary = null;
            }
            this.setDirty(true);
        }
        if (eqMod.isType("BaseMaterial")) {
            for (i = eqModList.size() - 1; i >= 0; --i) {
                aMod2 = (EquipmentModifier)eqModList.get(i);
                if (!aMod2.isType("BaseMaterial")) continue;
                eqModList.remove(i);
                if (bPrimary) {
                    this.typeListCachePrimary = null;
                } else {
                    this.typeListCacheSecondary = null;
                }
                this.setDirty(true);
            }
        } else if (eqMod.isType("MagicalEnhancement")) {
            for (i = eqModList.size() - 1; i >= 0; --i) {
                aMod2 = (EquipmentModifier)eqModList.get(i);
                if (!aMod2.isType("MagicalEnhancement")) continue;
                eqModList.remove(i);
                if (bPrimary) {
                    this.typeListCachePrimary = null;
                    continue;
                }
                this.typeListCacheSecondary = null;
            }
        }
        if ((aMod = this.getEqModifierKeyed(eqMod.getKeyName(), bPrimary)) == null) {
            if (eqMod.getChoiceString().length() != 0) {
                aMod = (EquipmentModifier)eqMod.clone();
                if (aMod == null) {
                    return;
                }
            } else {
                aMod = eqMod;
            }
            eqModList.add(aMod);
            if (bPrimary) {
                this.typeListCachePrimary = null;
            } else {
                this.typeListCacheSecondary = null;
            }
        }
        if (!bImporting) {
            boolean allRemoved = false;
            if (selectedChoice != null && selectedChoice.length() > 0) {
                if (!eqMod.getChoiceString().startsWith("EQBUILDER.")) {
                    aMod.setChoice(selectedChoice, equipChoice);
                    allRemoved = aMod.getAssociatedCount() == 0;
                }
            } else if (aMod.getChoice(1, this, true) == 0) {
                allRemoved = true;
            }
            if (allRemoved) {
                eqModList.remove(aMod);
                if (bPrimary) {
                    this.typeListCachePrimary = null;
                } else {
                    this.typeListCacheSecondary = null;
                }
            }
        }
        Globals.sortPObjectList(eqModList);
        this.setBase(aPC);
    }

    public void addEqModifiers(String aString, boolean bPrimary) {
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        while (aTok.hasMoreTokens()) {
            String aEqModName = aTok.nextToken();
            if (aEqModName.equalsIgnoreCase("None")) continue;
            this.addEqModifier(aEqModName, bPrimary);
        }
        List eqModList = this.getEqModifierList(bPrimary);
        Globals.sortPObjectList(eqModList);
    }

    public void addToAltTypeList(String argAltType) {
        String altType = argAltType.toUpperCase();
        StringTokenizer aTok = new StringTokenizer(altType, ".");
        while (aTok.hasMoreTokens()) {
            String type = aTok.nextToken();
            this.addAltType(type);
            this.typeListCachePrimary = null;
            this.typeListCacheSecondary = null;
        }
    }

    public void addTreasureList(String listName, int argWeight) {
        if (this.treasureList == null) {
            this.treasureList = new HashMap();
        }
        this.treasureList.put(listName, new Integer(argWeight));
    }

    public void addVFeatList(String vList) {
        StringTokenizer aTok = new StringTokenizer(vList, "|");
        while (aTok.hasMoreTokens()) {
            if (this.vFeatList == null) {
                this.vFeatList = new ArrayList();
            }
            this.vFeatList.add(aTok.nextToken());
        }
    }

    public double bonusTo(PlayerCharacter aPC, String aType, String aName, boolean bPrimary) {
        return this.bonusTo(aPC, aType, aName, this, bPrimary);
    }

    public double bonusTo(PlayerCharacter aPC, String aType, String aName, Object anObj, boolean bPrimary) {
        List eqModList;
        String aBonusKey = aType.toUpperCase() + '.' + aName.toUpperCase() + '.';
        Iterator e = this.getBonusMap().keySet().iterator();
        while (e.hasNext()) {
            String aKey = e.next().toString();
            if (!aKey.startsWith(aBonusKey)) continue;
            this.putBonusMap(aKey, "0");
        }
        double iBonus = 0.0;
        this.bonusPrimary = bPrimary;
        if (bPrimary) {
            super.bonusTo(aType, aName, this, aPC);
            ArrayList<BonusObj> tbList = new ArrayList<BonusObj>();
            Iterator b = this.getTempBonusList().iterator();
            while (b.hasNext()) {
                BonusObj aBonus = (BonusObj)b.next();
                if (tbList.contains(aBonus)) continue;
                tbList.add(aBonus);
            }
            super.bonusTo(aType, aName, anObj, tbList, aPC);
        }
        if (Globals.checkRule("SYS_35WP")) {
            List aList = GameMode.getEqSizePenaltyObj().getBonusList();
            super.bonusTo(aType, aName, this, aList, aPC);
        }
        if ((eqModList = this.getEqModifierList(bPrimary)).size() != 0) {
            Iterator e2 = eqModList.iterator();
            while (e2.hasNext()) {
                EquipmentModifier aEqMod = (EquipmentModifier)e2.next();
                if (this.willIgnore(aEqMod.getKeyName(), bPrimary)) continue;
                aEqMod.bonusTo(aPC, aType, aName, this);
            }
        }
        Iterator i = this.getBonusMap().keySet().iterator();
        while (i.hasNext()) {
            String aKey = i.next().toString();
            if (!aKey.startsWith(aBonusKey)) continue;
            iBonus += (double)Float.parseFloat((String)this.getBonusMap().get(aKey));
        }
        return iBonus;
    }

    public int calcPlusForCosting() {
        int iCount;
        EquipmentModifier aEqMod;
        int iPlus = 0;
        Iterator e = this.eqModifierList.iterator();
        while (e.hasNext()) {
            aEqMod = (EquipmentModifier)e.next();
            iCount = aEqMod.getAssociatedCount();
            if (iCount < 1) {
                iCount = 1;
            }
            iPlus += iCount * aEqMod.getPlus();
        }
        e = this.altEqModifierList.iterator();
        while (e.hasNext()) {
            aEqMod = (EquipmentModifier)e.next();
            iCount = aEqMod.getAssociatedCount();
            if (iCount < 1) {
                iCount = 1;
            }
            iPlus += iCount * aEqMod.getPlus();
        }
        return iPlus;
    }

    public boolean canAddModifier(EquipmentModifier eqMod, boolean bPrimary) {
        this.bonusPrimary = bPrimary;
        if (!this.modifiersAllowed || !eqMod.passesPreReqToGain(this)) {
            return false;
        }
        return bPrimary || eqMod.getCost().indexOf("%CHOICE") < 0;
    }

    public int canContain(PlayerCharacter aPC, Object obj) {
        if (obj instanceof Equipment) {
            Equipment anEquip = (Equipment)obj;
            if (this.checkChildWeight(aPC, new Float(anEquip.getWeightAsDouble(aPC) * (double)anEquip.numberCarried().floatValue()))) {
                if (this.checkContainerCapacity(anEquip.eqTypeList(), anEquip.numberCarried())) {
                    return 1;
                }
                return 4;
            }
            return 2;
        }
        return 0;
    }

    public void clearChildTypes() {
        this.d_childTypes = null;
    }

    public void clearContainedEquipment() {
        this.d_containedEquipment = null;
    }

    public Object clone() {
        Equipment eq = null;
        try {
            eq = (Equipment)super.clone();
            eq.cost = this.cost;
            eq.size = this.size;
            eq.baseCost = this.baseCost;
            eq.sizeBase = this.sizeBase;
            eq.baseItem = this.baseItem;
            eq.seteDR(this.eDR.toString());
            eq.setACCheck(this.acCheck.toString());
            eq.setCritRange(this.critRange);
            eq.setRange(this.range.toString());
            eq.setSpellFailure(this.spellFailure.toString());
            eq.weightInPounds = this.weightInPounds;
            eq.setMaxDex(this.maxDex.toString());
            eq.setDamage(this.damage);
            eq.setAltDamage(this.altDamage);
            eq.setDamageMod(this.damageMod);
            eq.setMoveString(this.moveString());
            eq.critMult = this.critMult;
            eq.isSpecified = this.isSpecified;
            eq.profName = this.profName;
            eq.carried = this.carried;
            eq.equipped = this.equipped;
            eq.location = this.location;
            eq.altCritMult = this.altCritMult;
            eq.altCritRange = this.altCritRange;
            eq.slots = this.slots;
            eq.bonusType = this.bonusType;
            eq.numberEquipped = this.numberEquipped;
            eq.reach = this.reach;
            eq.qty = this.qty;
            eq.outputIndex = this.outputIndex;
            eq.containerWeightCapacity = this.containerWeightCapacity;
            eq.containerReduceWeight = this.containerReduceWeight;
            eq.d_acceptsChildren = this.d_acceptsChildren;
            eq.wieldString = this.wieldString;
            eq.hasWield = this.hasWield;
            if (this.d_acceptsTypes != null) {
                eq.d_acceptsTypes = new HashMap(this.d_acceptsTypes);
            }
            eq.containerConstantWeight = this.containerConstantWeight;
            if (this.d_childTypes != null) {
                eq.d_childTypes = new HashMap(this.d_childTypes);
            }
            eq.containerContentsString = this.containerContentsString;
            eq.containerCapacityString = this.containerCapacityString;
            if (this.d_containedEquipment != null) {
                eq.d_containedEquipment = new ArrayList(this.d_containedEquipment);
            }
            eq.eqModifierList = this.cloneEqModList(true);
            eq.altEqModifierList = this.cloneEqModList(false);
            eq.modifiersAllowed = this.modifiersAllowed;
            eq.modifiersRequired = this.modifiersRequired;
        }
        catch (CloneNotSupportedException e) {
            ShowMessageDelegate.showMessageDialog(e.getMessage(), "PCGen", MessageType.ERROR);
        }
        return eq;
    }

    public int compareTo(Object o) {
        Equipment e = (Equipment)o;
        return this.getName().compareToIgnoreCase(e.getName());
    }

    public boolean containsContainedEquipment(Equipment e) {
        if (this.d_containedEquipment == null) {
            return false;
        }
        return this.d_containedEquipment.contains(e);
    }

    public Integer eDR(PlayerCharacter aPC) {
        int check = this.eDR + (int)this.bonusTo(aPC, "EQMARMOR", "EDR", true);
        if (check < 0) {
            check = 0;
        }
        return new Integer(check);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Equipment && (o == this || this.getName().equals(((Equipment)o).getName()));
    }

    public String formatSaveLine(String sep, String endPart) {
        String aString;
        Equipment base;
        StringBuffer sbuf = new StringBuffer(100);
        if (this.baseItem.length() != 0) {
            base = EquipmentList.getEquipmentNamed(this.baseItem);
            sbuf.append(this.baseItem);
            sbuf.append(sep).append("NAME").append(endPart).append(this.toString(false));
        } else {
            base = this;
            sbuf.append(this.getBaseItemName());
        }
        if (base == null) {
            return sbuf.toString();
        }
        if (!this.size.equals(base.getSize())) {
            sbuf.append(sep).append("SIZE").append(endPart).append(this.size);
        }
        if ((aString = this.getEqModifierString(true)).length() > 0) {
            sbuf.append(sep).append("EQMOD").append(endPart).append(aString);
        }
        if ((aString = this.getEqModifierString(false)).length() > 0) {
            sbuf.append(sep).append("ALTEQMOD").append(endPart).append(aString);
        }
        if ((aString = this.getRawSpecialProperties()).length() > 0 && !aString.equals(base.getRawSpecialProperties())) {
            sbuf.append(sep).append("SPROP").append(endPart).append(aString);
        }
        if (!this.costMod.equals(BigDecimalHelper.ZERO)) {
            sbuf.append(sep).append("COSTMOD").append(endPart).append(this.costMod.toString());
        }
        return sbuf.toString();
    }

    public boolean hasVFeats() {
        List vFeats = this.getVirtualFeatList();
        return vFeats != null && vFeats.size() > 0;
    }

    public boolean hasWield() {
        return this.hasWield;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int indexOfChild(Object child) {
        if (!(child instanceof Equipment)) {
            return -1;
        }
        return this.getContainedEquipmentIndexOf((Equipment)child);
    }

    public void insertChild(PlayerCharacter aPC, Object child) {
        Float aFloat;
        if (child == null) {
            return;
        }
        Equipment anEquip = (Equipment)child;
        Float bFloat = aFloat = anEquip.numberCarried();
        String aString = this.pickChildType(anEquip.eqTypeList(), aFloat);
        if (this.containsChildType(aString)) {
            aFloat = new Float(this.getChildType(aString).floatValue() + aFloat.floatValue());
        }
        bFloat = new Float(this.getChildType("Total").floatValue() + bFloat.floatValue());
        this.setChildType(aString, aFloat);
        this.setChildType("Total", bFloat);
        this.addContainedEquipment(anEquip);
        anEquip.setIndexedUnderType(aString);
        anEquip.setParent(this);
        this.updateContainerContentsString(aPC);
        while (anEquip.getParent() != null) {
            anEquip = (Equipment)anEquip.getParent();
            anEquip.updateContainerContentsString(aPC);
        }
    }

    public int itemDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        int i = 1;
        Equipment anEquip = (Equipment)this.getParent();
        while (anEquip.getParent() != null) {
            anEquip = (Equipment)anEquip.getParent();
            ++i;
        }
        return i;
    }

    public void load(String aLine) {
        this.load(aLine, "\t", ":");
    }

    public void load(String aLine, String sep, String endPart) {
        this.load(aLine, sep, endPart, null);
    }

    public void load(String aLine, String sep, String endPart, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(aLine, sep);
        int endPartLen = endPart.length();
        String newSize = this.size;
        this.baseItem = this.getKeyName();
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (aString.startsWith("NAME" + endPart)) {
                this.setName(aString.substring(4 + endPartLen));
                continue;
            }
            if (aString.startsWith("SIZE" + endPart)) {
                newSize = aString.substring(4 + endPartLen);
                continue;
            }
            if (aString.startsWith("EQMOD" + endPart)) {
                this.addEqModifiers(aString.substring(5 + endPartLen), true);
                continue;
            }
            if (aString.startsWith("ALTEQMOD" + endPart)) {
                this.addEqModifiers(aString.substring(8 + endPartLen), false);
                continue;
            }
            if (aString.startsWith("SPROP" + endPart)) {
                this.addSpecialProperty(SpecialProperty.createFromLst(aString.substring(5 + endPartLen)));
                continue;
            }
            if (aString.startsWith("COSTMOD" + endPart)) {
                this.setCostMod(aString.substring(7 + endPartLen));
                continue;
            }
            if (!aString.startsWith("WEIGHTMOD" + endPart)) continue;
            this.setWeightMod(aString.substring(9 + endPartLen));
        }
        this.resizeItem(aPC, newSize);
    }

    public String longName() {
        if (this.longName.length() == 0) {
            return this.toString();
        }
        return this.longName;
    }

    public boolean meetsPreReqs() {
        return PrereqHandler.passesAll(this.getPreReqList(), this);
    }

    public String modifiedName() {
        return this.modifiedName;
    }

    public String moveString() {
        if (this.moveString.length() > 0) {
            int eqLoad = this.isHeavy() ? 2 : (this.isMedium() ? 1 : (this.isLight() ? 0 : 3));
            StringTokenizer aTok = new StringTokenizer(this.moveString, ",");
            int baseMove = -1;
            int tokenCount = aTok.countTokens();
            switch (tokenCount) {
                case 2: {
                    baseMove = 30;
                    break;
                }
                case 3: {
                    baseMove = 60;
                    break;
                }
                default: {
                    tokenCount = -1;
                }
            }
            if (tokenCount > 0) {
                StringBuffer retString = new StringBuffer(this.moveString.length());
                for (int i = 0; i < tokenCount; ++i) {
                    if (i != 0) {
                        retString.append(',');
                    }
                    retString.append(Globals.calcEncumberedMove(eqLoad, baseMove, true));
                    baseMove -= 10;
                }
                return retString.toString();
            }
        }
        return this.moveString;
    }

    public String nameItemFromModifiers(PlayerCharacter aPC) {
        String itemName = this.getItemNameFromModifiers();
        this.cleanTypes(aPC);
        this.setName(itemName);
        this.setOutputName("");
        return this.getName();
    }

    public Float numberCarried() {
        Equipment eqParent;
        if (this.isEquipped() || eqParent == null) {
            return this.carried;
        }
        for (eqParent = (Equipment)this.getParent(); eqParent != null; eqParent = (Equipment)eqParent.getParent()) {
            if (!eqParent.isEquipped() && (eqParent.getParent() != null || eqParent.numberCarried().intValue() == 0)) continue;
            return this.carried;
        }
        return new Float(0.0f);
    }

    public String profName(PlayerCharacter aPC) {
        return this.profName(2, aPC);
    }

    public String profName(int hands, PlayerCharacter aPC) {
        int iOffs;
        String aWProf = this.profName;
        if (aWProf.length() == 0) {
            aWProf = this.getName();
        }
        if ((iOffs = aWProf.indexOf("[Hands]")) >= 0) {
            String sExotic = aWProf.substring(0, iOffs) + "Exotic" + aWProf.substring(iOffs + 7);
            String sMartial = aWProf.substring(0, iOffs) + "Martial" + aWProf.substring(iOffs + 7);
            WeaponProf wpExotic = Globals.getWeaponProfNamed(sExotic);
            WeaponProf wpMartial = Globals.getWeaponProfNamed(sMartial);
            if (wpMartial == null) {
                return sExotic;
            }
            if (wpExotic == null || hands == 0) {
                return sMartial;
            }
            if (Globals.handsRequired(aPC, this, wpMartial) == hands) {
                return sMartial;
            }
            if (Globals.handsRequired(aPC, this, wpExotic) == hands) {
                return sExotic;
            }
            return sMartial;
        }
        return aWProf;
    }

    public double qty() {
        return this.qty;
    }

    public void removeChild(PlayerCharacter aPC, Object child) {
        int i = this.indexOfChild(child);
        Equipment anEquip = (Equipment)child;
        Float qtyRemoved = anEquip.numberCarried();
        this.setChildType("Total", new Float(this.getChildType("Total").floatValue() - qtyRemoved.floatValue()));
        String aString = anEquip.isIndexedUnderType();
        this.setChildType(aString, new Float(this.getChildType(aString).floatValue() - qtyRemoved.floatValue()));
        anEquip.setParent(null);
        this.removeContainedEquipment(i);
        this.updateContainerContentsString(aPC);
        anEquip = this;
        while (anEquip.getParent() != null) {
            anEquip = (Equipment)anEquip.getParent();
            anEquip.updateContainerContentsString(aPC);
        }
    }

    public void removeChild(PlayerCharacter aPC, int childIndex) {
        this.removeChild(aPC, this.getChild(childIndex));
    }

    public void removeEqModifier(EquipmentModifier eqMod, boolean bPrimary) {
        List eqModList = this.getEqModifierList(bPrimary);
        EquipmentModifier aMod = this.getEqModifierKeyed(eqMod.getKeyName(), bPrimary);
        if (aMod == null) {
            return;
        }
        if (aMod.getAssociatedCount() == 0 || aMod.getChoice(0, this, false) == 0) {
            eqModList.remove(aMod);
            if (bPrimary) {
                this.typeListCachePrimary = null;
            } else {
                this.typeListCacheSecondary = null;
            }
            this.setDirty(true);
        }
    }

    public void removeEqModifiers(String aString, boolean bPrimary) {
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        while (aTok.hasMoreTokens()) {
            String aEqModName = aTok.nextToken();
            if (aEqModName.equalsIgnoreCase("None")) continue;
            this.removeEqModifier(aEqModName, bPrimary);
        }
    }

    public void resizeItem(PlayerCharacter aPC, String newSize) {
        this.setBase(aPC);
        int iOldSize = this.sizeInt();
        int iNewSize = Globals.sizeInt(newSize);
        if (iNewSize != iOldSize) {
            this.setSize(newSize);
            Equipment eq = EquipmentList.getEquipmentKeyed(this.baseItem);
            if (eq != null) {
                this.setCost(eq.getCostAdjustedForSize(aPC, newSize).toString());
                this.setWeight(eq.getWeightAdjustedForSize(aPC, newSize).toString());
                this.adjustACForSize(aPC, eq, newSize);
                this.setDamage(eq.getDamageAdjustedForSize(newSize));
                this.setAltDamage(eq.getAltDamageAdjustedForSize(newSize));
                if (this.containerCapacityString.length() > 0) {
                    double mult = 1.0;
                    SizeAdjustment newSA = SystemCollections.getSizeAdjustmentNamed(newSize);
                    if (newSA != null) {
                        mult = newSA.getBonusTo(aPC, "ITEMCAPACITY", eq.typeList(), 1.0);
                    }
                    if (this.containerWeightCapacity.intValue() != -1) {
                        this.containerWeightCapacity = new Float(eq.containerWeightCapacity.doubleValue() * mult);
                    }
                    if (this.getAcceptsTypeCount() > 0) {
                        Iterator e = eq.d_acceptsTypes.keySet().iterator();
                        while (e.hasNext()) {
                            String aString = (String)e.next();
                            Float aWeight = eq.getAcceptsType(aString);
                            if (aWeight.intValue() == -1) continue;
                            aWeight = new Float(aWeight.doubleValue() * mult);
                            this.setAcceptsType(aString, aWeight);
                        }
                    }
                    this.updateContainerCapacityString();
                }
            }
            for (int i = 0; i < this.getPreReqCount(); ++i) {
                int iOldPre;
                Prerequisite aBonus = this.getPreReq(i);
                if (!"SIZE".equalsIgnoreCase(aBonus.getKind()) || (iNewSize += (iOldPre = Globals.sizeInt(aBonus.getOperand())) - iOldSize) < 0 || iNewSize > SystemCollections.getSizeAdjustmentListSize() - 1) continue;
                aBonus.setOperand(SystemCollections.getSizeAdjustmentAtIndex(iNewSize).getAbbreviation());
                this.setPreReq(i, aBonus);
            }
        }
    }

    public void seteDR(String aString) {
        try {
            this.eDR = new Integer(aString);
        }
        catch (NumberFormatException nfe) {
            this.eDR = new Integer(0);
        }
    }

    public int sizeInt() {
        return Globals.sizeInt(this.getSize());
    }

    public Integer spellFailure(PlayerCharacter aPC) {
        int fail = this.spellFailure + (int)this.bonusTo(aPC, "EQMARMOR", "SPELLFAILURE", true);
        if (fail < 0) {
            fail = 0;
        }
        return new Integer(fail);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean addCharges) {
        if (this.isDirty() || this.cachedNameWithCharges == null && this.cachedNameWithoutCharges == null) {
            StringBuffer buffer = new StringBuffer(this.name);
            if (this.modifiedName.length() > 0) {
                buffer.append(" (").append(this.modifiedName).append(")");
            }
            this.cachedNameWithoutCharges = buffer.toString();
            if (addCharges && this.getRemainingCharges() > this.getMinCharges() && this.getRemainingCharges() < this.getMaxCharges()) {
                buffer.append("(").append(this.getRemainingCharges()).append(")");
            }
            this.cachedNameWithCharges = buffer.toString();
            this.setDirty(false);
        }
        if (addCharges) {
            return this.cachedNameWithCharges;
        }
        return this.cachedNameWithoutCharges;
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String typeIndex(int index) {
        List tList = this.typeList();
        if (index < 0 || index >= tList.size()) {
            return "";
        }
        return (String)tList.get(index);
    }

    public List typeList() {
        return this.typeList(true);
    }

    public void updateContainerContentsString() {
        this.containerContentsString = "";
        StringBuffer tempStringBuffer = new StringBuffer(this.getChildCount() * 20);
        if (this.acceptsChildren() && this.getBaseContainedWeight(true).floatValue() >= 0.0f) {
            tempStringBuffer.append(this.getBaseContainedWeight(true)).append(' ').append(Globals.getWeightUnit());
        } else {
            tempStringBuffer.append("0.0 ");
            tempStringBuffer.append(Globals.getWeightUnit());
        }
        for (int e = 0; e < this.getChildCount(); ++e) {
            Equipment anEquip = (Equipment)this.getChild(e);
            if (!(anEquip.getQty().floatValue() > 0.0f)) continue;
            tempStringBuffer.append(", ");
            tempStringBuffer.append(BigDecimalHelper.trimZeros(anEquip.getQty().toString()));
            tempStringBuffer.append(" ");
            tempStringBuffer.append(anEquip);
        }
        this.containerContentsString = tempStringBuffer.toString();
    }

    public void updateContainerContentsString(PlayerCharacter aPC) {
        this.containerContentsString = "";
        StringBuffer tempStringBuffer = new StringBuffer(this.getChildCount() * 20);
        if (aPC != null && this.acceptsChildren() && this.getContainedWeight(aPC, true).floatValue() >= 0.0f) {
            tempStringBuffer.append(this.getContainedWeight(aPC, true)).append(' ').append(Globals.getWeightUnit());
        } else {
            tempStringBuffer.append("0.0 ");
            tempStringBuffer.append(Globals.getWeightUnit());
        }
        for (int e = 0; e < this.getChildCount(); ++e) {
            Equipment anEquip = (Equipment)this.getChild(e);
            if (!(anEquip.getQty().floatValue() > 0.0f)) continue;
            tempStringBuffer.append(", ");
            tempStringBuffer.append(BigDecimalHelper.trimZeros(anEquip.getQty().toString()));
            tempStringBuffer.append(" ");
            tempStringBuffer.append(anEquip);
        }
        this.containerContentsString = tempStringBuffer.toString();
    }

    protected void doGlobalTypeUpdate(String aString) {
        s_equipmentTypes.add(aString);
    }

    private void setDefaultCrit(PlayerCharacter aPC) {
        if (this.isWeapon()) {
            if (this.getCritRange(aPC).length() == 0) {
                this.setCritRange("1");
            }
            if (this.getCritMult().length() == 0) {
                this.setCritMult("x2");
            }
        }
    }

    boolean isMasterwork() {
        return this.isType("MASTERWORK");
    }

    void setQty(double argQty) {
        this.qty = argQty;
    }

    static void clearEquipmentTypes() {
        s_equipmentTypes.clear();
    }

    boolean getModifiersAllowed() {
        return this.modifiersAllowed;
    }

    String getType(boolean bPrimary) {
        List typeList = this.typeList(bPrimary);
        int typeSize = typeList.size();
        StringBuffer aType = new StringBuffer(typeSize * 5);
        Iterator e = typeList.iterator();
        while (e.hasNext()) {
            if (aType.length() != 0) {
                aType.append('.');
            }
            aType.append((String)e.next());
        }
        return aType.toString();
    }

    boolean equalTo(Object o) {
        return super.equals(o);
    }

    String rawProfName() {
        return this.profName;
    }

    boolean save(BufferedWriter output) {
        FileAccess.write(output, "BASEITEM:" + this.formatSaveLine("\t", ":"));
        FileAccess.newLine(output);
        return true;
    }

    boolean typeStringContains(String aString) {
        return this.isType(aString);
    }

    private void setAcceptsType(String parameter, Float acceptsType) {
        if (this.d_acceptsTypes == null) {
            this.d_acceptsTypes = new HashMap();
        }
        this.d_acceptsTypes.put(parameter.toUpperCase(), acceptsType);
    }

    private Float getAcceptsType(String aString) {
        if (this.d_acceptsTypes == null) {
            return null;
        }
        return (Float)this.d_acceptsTypes.get(aString.toUpperCase());
    }

    private int getAcceptsTypeCount() {
        if (this.d_acceptsTypes == null) {
            return 0;
        }
        return this.d_acceptsTypes.size();
    }

    private String getAltDamageAdjustedForSize(String aSize) {
        return this.getDamageAdjustedForSize(aSize, false);
    }

    private int getAltTypeCount() {
        if (this.altTypeList == null) {
            return 0;
        }
        return this.altTypeList.size();
    }

    private void setBase(PlayerCharacter aPC) {
        List profTypeInfo;
        String aString;
        EquipmentModifier aEqMod;
        Equipment eq;
        if (this.baseItem.length() == 0) {
            this.baseItem = this.getKeyName();
        }
        if (this.profName.length() == 0 && (eq = EquipmentList.getEquipmentKeyed(this.baseItem)) != null) {
            this.profName = eq.rawProfName();
            if (this.profName.length() == 0) {
                this.profName = eq.getName();
            }
        }
        EquipmentModifier profType = null;
        Iterator e = this.eqModifierList.iterator();
        while (e.hasNext()) {
            aEqMod = (EquipmentModifier)e.next();
            aString = aEqMod.getProficiency();
            if (aString.length() == 0) continue;
            profType = aEqMod;
            break;
        }
        if (profType == null) {
            e = this.altEqModifierList.iterator();
            while (e.hasNext()) {
                aEqMod = (EquipmentModifier)e.next();
                aString = aEqMod.getProficiency();
                if (aString.length() == 0) continue;
                profType = aEqMod;
                break;
            }
        }
        if (profType != null && (profTypeInfo = CoreUtility.split(profType.getProficiency(), '.')).size() == 2) {
            WeaponProf wp;
            StringBuffer proficiencyName = new StringBuffer(this.profName);
            if (this.profName.endsWith(")")) {
                proficiencyName.setLength(proficiencyName.length() - 1);
                proficiencyName.append('/');
            } else {
                proficiencyName.append(" (");
            }
            if (!proficiencyName.toString().endsWith((String)profTypeInfo.get(1) + '/')) {
                proficiencyName.append((String)profTypeInfo.get(1));
            } else {
                proficiencyName.setLength(proficiencyName.length() - 1);
            }
            proficiencyName.append(')');
            this.profName = proficiencyName.toString();
            int iOffs = this.profName.indexOf("[Hands]");
            if (iOffs >= 0) {
                this.profName = this.profName.substring(0, iOffs) + this.profName.substring(iOffs + 7);
            }
            if ((wp = Globals.getWeaponProfNamed(this.profName)) == null) {
                wp = new WeaponProf();
                wp.setName(this.profName);
                wp.setKeyName(this.profName);
                wp.setTypeInfo((String)profTypeInfo.get(0));
                this.setDefaultCrit(aPC);
                Globals.addWeaponProf(wp);
            }
        }
        if (this.getSize().length() == 0) {
            this.setSize("M");
        }
    }

    private BigDecimal getBaseCost() {
        return this.baseCost;
    }

    private String getBaseSize() {
        return this.sizeBase;
    }

    private Float getChildType(String aString) {
        if (this.d_childTypes == null) {
            return null;
        }
        return (Float)this.d_childTypes.get(aString);
    }

    private int getContainedEquipmentIndexOf(Equipment e) {
        if (this.d_containedEquipment == null) {
            return -1;
        }
        return this.d_containedEquipment.indexOf(e);
    }

    private BigDecimal getCostAdjustedForSize(PlayerCharacter aPC, String aSize) {
        BigDecimal c = this.getBaseCost();
        SizeAdjustment saSize = SystemCollections.getSizeAdjustmentNamed(aSize);
        SizeAdjustment saBase = SystemCollections.getSizeAdjustmentNamed(this.getBaseSize());
        if (saSize == null || saBase == null) {
            return c;
        }
        double saDbl = saSize.getBonusTo(aPC, "ITEMCOST", this.typeList(), 1.0);
        double saBaseDbl = saBase.getBonusTo(aPC, "ITEMCOST", this.typeList(), 1.0);
        double mult = saDbl / saBaseDbl;
        c = c.multiply(new BigDecimal(mult));
        return c;
    }

    private String getCritRange(PlayerCharacter aPC, boolean bPrimary) {
        String cr;
        String string = cr = bPrimary ? this.critRange : this.altCritRange;
        if (cr.length() == 0) {
            cr = this.getWeaponInfo("CRITRANGE", bPrimary);
        }
        if (cr.length() == 0 || !bPrimary && !this.isDouble()) {
            return "";
        }
        return Integer.toString(this.getRawCritRange(bPrimary) * (this.getCritRangeDouble(aPC, bPrimary) + 1) + this.getCritRangeAdd(aPC, bPrimary));
    }

    private String getDamage(PlayerCharacter aPC, boolean bPrimary) {
        String baseDamage;
        String string = baseDamage = bPrimary ? this.damage : this.altDamage;
        if (!this.isWeapon() || !bPrimary && !this.isDouble()) {
            return baseDamage;
        }
        if (bPrimary && this.damageMod.length() != 0) {
            baseDamage = this.damageMod;
        }
        if (baseDamage.length() == 0) {
            baseDamage = this.getWeaponInfo("DAMAGE", bPrimary);
        }
        int iSize = this.sizeInt();
        int iMod = iSize + (int)this.bonusTo(aPC, "EQMWEAPON", "DAMAGESIZE", bPrimary);
        if ((iMod += (int)this.bonusTo(aPC, "WEAPON", "DAMAGESIZE", bPrimary)) < 0) {
            iMod = 0;
        } else if (iMod >= SystemCollections.getSizeAdjustmentListSize() - 1) {
            iMod = SystemCollections.getSizeAdjustmentListSize() - 1;
        }
        return this.adjustDamage(baseDamage, SystemCollections.getSizeAdjustmentAtIndex(iMod).getAbbreviation());
    }

    private String getDamageAdjustedForSize(String aSize, boolean bPrimary) {
        String baseDamage;
        String string = baseDamage = bPrimary ? this.damage : this.altDamage;
        if (this.isWeapon()) {
            if (baseDamage.length() == 0) {
                baseDamage = this.getWeaponInfo("DAMAGE", bPrimary);
            }
            if (baseDamage.length() != 0) {
                return this.adjustDamage(baseDamage, aSize);
            }
        }
        return baseDamage;
    }

    private String getDamageAdjustedForSize(String aSize) {
        return this.getDamageAdjustedForSize(aSize, true);
    }

    private String getEqModifierString(boolean bPrimary) {
        List eqModList = this.getEqModifierList(bPrimary);
        StringBuffer aString = new StringBuffer(eqModList.size() * 10);
        Iterator e = eqModList.iterator();
        while (e.hasNext()) {
            if (aString.length() != 0) {
                aString.append('.');
            }
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            aString.append(eqMod.getKeyName());
            for (int e2 = 0; e2 < eqMod.getAssociatedCount(); ++e2) {
                String strMod = eqMod.getAssociated(e2);
                aString.append('|').append(strMod.replace('|', '='));
            }
        }
        if (bPrimary && this.weightMod.compareTo(BigDecimalHelper.ZERO) != 0) {
            if (aString.length() != 0) {
                aString.append('.');
            }
            aString.append(EQMOD_WEIGHT).append('|').append(this.weightMod.toString().replace('.', ','));
        }
        if (this.damageMod.length() != 0) {
            if (aString.length() != 0) {
                aString.append('.');
            }
            aString.append(EQMOD_DAMAGE).append('|').append(this.damageMod.replace('.', ','));
        }
        return aString.toString();
    }

    private void setIndexedUnderType(String aString) {
        this.indexedUnderType = aString;
    }

    private String isIndexedUnderType() {
        return this.indexedUnderType;
    }

    private static String getMagicBonus(List eqModList) {
        Iterator e = eqModList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            if (!eqMod.isType("MagicalEnhancement")) continue;
            return eqMod.getName();
        }
        return "";
    }

    private static String getNameFromModifiers(List eqModList, String eqMagic, String eqMaster) {
        ArrayList eqList = new ArrayList(eqModList);
        Globals.sortPObjectList(eqList);
        StringBuffer sMod = new StringBuffer(70);
        if (eqMagic.length() == 0 && eqMaster.length() != 0) {
            sMod.append(eqMaster);
        }
        Iterator e = eqList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            if (eqMod.getName().equals(eqMagic) || eqMod.getName().equals(eqMaster)) continue;
            if (sMod.length() != 0) {
                sMod.append('/');
            }
            sMod.append(eqMod.toString());
        }
        return sMod.toString();
    }

    private boolean isProjectile() {
        return this.isRanged() && !this.isThrown();
    }

    private void setSize(String sizeString) {
        this.setSize(sizeString, false);
    }

    private List getSpecialAbilityList(List eqModList, PlayerCharacter pc) {
        ArrayList saList = new ArrayList();
        Iterator e = eqModList.iterator();
        while (e.hasNext()) {
            EquipmentModifier aEqMod = (EquipmentModifier)e.next();
            saList.addAll(aEqMod.getSpecialProperties(this, pc));
        }
        return saList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getCostFromPluses(int iPlus, int altPlus) {
        if ((iPlus != 0 || altPlus != 0) && JEPResourceChecker.getMissingResourceCount() == 0) {
            PJEP myParser = null;
            try {
                String costExpr;
                String typeMatched;
                myParser = PjepPool.getInstance().aquire();
                myParser.addVariable("PLUS", iPlus);
                myParser.addVariable("ALTPLUS", altPlus);
                myParser.addVariable("BASECOST", this.getBaseCost().doubleValue());
                if (this.isAmmunition()) {
                    myParser.addVariable("BASEQTY", this.getBaseQty());
                }
                BigDecimal maxCost = null;
                List itemTypes = this.typeList();
                for (int idx = 0; idx < itemTypes.size(); ++idx) {
                    typeMatched = (String)itemTypes.get(idx);
                    costExpr = SettingsHandler.getGame().getPlusCalculation(typeMatched);
                    if (costExpr == null) continue;
                    BigDecimal thisCost = this.evaluateCost(myParser, costExpr);
                    if (maxCost != null && thisCost.compareTo(maxCost) <= 1) continue;
                    maxCost = thisCost;
                }
                if (maxCost != null) {
                    BigDecimal bigDecimal = maxCost;
                    return bigDecimal;
                }
                typeMatched = "ANY";
                costExpr = SettingsHandler.getGame().getPlusCalculation(typeMatched);
                if (costExpr != null) {
                    BigDecimal bigDecimal = this.evaluateCost(myParser, costExpr);
                    return bigDecimal;
                }
            }
            finally {
                PjepPool.getInstance().release(myParser);
            }
        }
        return BigDecimalHelper.ZERO;
    }

    private boolean isMagicLimitedType() {
        boolean limited = false;
        if (this.isType("HEADGEAR") || this.isType("EYEGEAR") || this.isType("CAPE") || this.isType("AMULET") || this.isSuit() || this.isType("ROBE") || this.isType("SHIRT") || this.isType("BRACER") || this.isType("GLOVE") || this.isType("RING") || this.isType("BELT") || this.isType("BOOT")) {
            limited = true;
        }
        return limited;
    }

    private List getSpecialAbilityTimesList(List abilityList, boolean bPrimary, PlayerCharacter aPC) {
        ArrayList<String> sortList = new ArrayList<String>();
        int[] numTimes = new int[abilityList.size()];
        for (int i = 0; i < abilityList.size(); ++i) {
            String ability = (String)abilityList.get(i);
            if (!sortList.contains(ability)) {
                sortList.add(ability);
                numTimes[i] = 1;
                continue;
            }
            for (int j = 0; j < sortList.size(); ++j) {
                String testAbility = (String)sortList.get(j);
                if (!testAbility.equals(ability)) continue;
                int n = j;
                numTimes[n] = numTimes[n] + 1;
            }
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < sortList.size(); ++i) {
            String ability = (String)sortList.get(i);
            if (numTimes[i] > 1) {
                ability = ability + " (" + numTimes[i] + ")";
            }
            retList.add(ability);
        }
        return retList;
    }

    private String getWeaponInfo(String infoType, boolean bPrimary) {
        String it = infoType + "|";
        EquipmentModifier eqMod = this.getEqModifierKeyed("PCGENi_WEAPON", bPrimary);
        if (eqMod != null) {
            for (int i = 0; i < eqMod.getAssociatedCount(); ++i) {
                String aString = eqMod.getAssociated(i);
                if (!aString.startsWith(it)) continue;
                return aString.substring(it.length());
            }
        }
        return "";
    }

    private Float getWeightAdjustedForSize(PlayerCharacter aPC, String aSize) {
        SizeAdjustment newSA = SystemCollections.getSizeAdjustmentNamed(aSize);
        SizeAdjustment currSA = SystemCollections.getSizeAdjustmentNamed(this.getSize());
        if (newSA == null || currSA == null) {
            return new Float(this.getWeightAsDouble(aPC));
        }
        double mult = newSA.getBonusTo(aPC, "ITEMWEIGHT", this.typeList(), 1.0) / currSA.getBonusTo(aPC, "ITEMWEIGHT", this.typeList(), 1.0);
        return new Float(this.getWeightAsDouble(aPC) * mult);
    }

    private boolean acceptsType(String aString) {
        if (this.d_acceptsTypes == null) {
            return false;
        }
        return this.d_acceptsTypes.containsKey(aString.toUpperCase());
    }

    private void addAltType(String type) {
        if (this.altTypeList == null) {
            this.altTypeList = new ArrayList(1);
        }
        this.altTypeList.add(type);
        this.typeListCachePrimary = null;
        this.typeListCacheSecondary = null;
    }

    private void addContainedEquipment(Equipment e) {
        if (this.d_containedEquipment == null) {
            this.d_containedEquipment = new ArrayList();
        }
        this.d_containedEquipment.add(e);
    }

    private List addEqModList(boolean bPrimary, List argVFeats) {
        List eqModList = this.getEqModifierList(bPrimary);
        List vFeats = argVFeats;
        if (eqModList.size() != 0) {
            Iterator e = eqModList.iterator();
            while (e.hasNext()) {
                EquipmentModifier aEqMod = (EquipmentModifier)e.next();
                vFeats.addAll(aEqMod.getVirtualFeatList());
            }
        }
        return vFeats;
    }

    private void adjustACForSize(PlayerCharacter aPC, Equipment baseEq, String aSize) {
        if (this.getBonusList() != null && this.isArmor()) {
            double mult = 1.0;
            SizeAdjustment newSA = SystemCollections.getSizeAdjustmentNamed(aSize);
            SizeAdjustment currSA = SystemCollections.getSizeAdjustmentNamed(baseEq.getSize());
            if (newSA != null && currSA != null) {
                mult = newSA.getBonusTo(aPC, "ACVALUE", baseEq.typeList(), 1.0) / currSA.getBonusTo(aPC, "ACVALUE", baseEq.typeList(), 1.0);
            }
            List baseEqBonusList = baseEq.getBonusList();
            for (int i = 0; i < baseEqBonusList.size(); ++i) {
                int iOffs;
                BonusObj aBonus = (BonusObj)baseEqBonusList.get(i);
                String aString = aBonus.toString();
                if (!aString.startsWith("COMBAT|AC|") || (iOffs = aString.indexOf(124, 10)) <= 10) continue;
                Integer acCombatBonus = new Integer(aString.substring(10, iOffs));
                acCombatBonus = new Integer(new Float(acCombatBonus.doubleValue() * mult).intValue());
                aString = aString.substring(0, 10) + acCombatBonus.toString() + aString.substring(iOffs);
                this.removeBonusList(aBonus);
                this.addBonusList(aString, this);
            }
        }
    }

    private String adjustDamage(String aDamage, String aSize) {
        if (!aDamage.equalsIgnoreCase("special") && !aDamage.equals("-")) {
            return Globals.adjustDamage(aDamage, this.getSize(), aSize);
        }
        return aDamage;
    }

    private boolean checkChildWeight(PlayerCharacter aPC, Float aFloat) {
        if (this.containerWeightCapacity.intValue() == -1) {
            return true;
        }
        return aFloat.floatValue() + this.getContainedWeight(aPC).floatValue() <= this.containerWeightCapacity.floatValue();
    }

    private boolean checkContainerCapacity(SortedSet aTypeList, Float aQuant) {
        if (this.acceptsType("Any") && this.getAcceptsType("Any").intValue() == -1) {
            return true;
        }
        return !"".equals(this.pickChildType(aTypeList, aQuant));
    }

    private List cloneEqModList(boolean primary) {
        ArrayList<EquipmentModifier> clonedList = new ArrayList<EquipmentModifier>();
        Iterator e = this.getEqModifierList(primary).iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod = (EquipmentModifier)e.next();
            if (eqMod.getChoiceString().length() != 0) {
                eqMod = (EquipmentModifier)eqMod.clone();
            }
            clonedList.add(eqMod);
        }
        return clonedList;
    }

    private boolean containsChildType(String aString) {
        if (this.d_childTypes == null) {
            return false;
        }
        return this.d_childTypes.containsKey(aString);
    }

    private static int multAsInt(int mult) {
        if (mult < 0) {
            return 0;
        }
        return mult;
    }

    private static String multAsString(int mult) {
        if (mult == 0) {
            return "";
        }
        if (mult < 0) {
            return "-";
        }
        return "x" + Integer.toString(mult);
    }

    private int getCritMultiplier(boolean bPrimary) {
        String cm;
        int mult;
        int n = mult = bPrimary ? this.critMult : this.altCritMult;
        if (mult == 0 && (cm = this.getWeaponInfo("CRITMULT", bPrimary)).length() != 0) {
            mult = Integer.parseInt(cm);
        }
        return mult;
    }

    private int getCritMultiplier() {
        return Equipment.multAsInt(this.getCritMultiplier(true));
    }

    private SortedSet eqTypeList() {
        return new TreeSet(this.typeList());
    }

    private static void extractListFromCommon(List commonList, List extractList) {
        for (int i = extractList.size() - 1; i >= 0; --i) {
            EquipmentModifier eqMod = (EquipmentModifier)extractList.get(i);
            if (!eqMod.getAssignToAll()) continue;
            commonList.add(0, eqMod);
            extractList.remove(i);
        }
    }

    private void cleanTypes(PlayerCharacter aPC) {
        String aType = super.getType();
        StringTokenizer aTok = new StringTokenizer(aType, ".");
        StringBuffer aCleaned = new StringBuffer(aType.length());
        aCleaned.append(".CLEAR");
        while (aTok.hasMoreTokens()) {
            SizeAdjustment sa;
            int i;
            String aString = aTok.nextToken();
            for (i = 0; i <= SystemCollections.getSizeAdjustmentListSize() - 1 && !aString.equalsIgnoreCase(SystemCollections.getSizeAdjustmentAtIndex(i).getName()); ++i) {
            }
            if ("Standard".equalsIgnoreCase(aString) || i < SystemCollections.getSizeAdjustmentListSize() && (!(sa = SystemCollections.getSizeAdjustmentAtIndex(i)).isDefaultSize() || !aCleaned.toString().toUpperCase().endsWith("ARMOR"))) continue;
            if ("Magic".equalsIgnoreCase(aString)) {
                if (aCleaned.length() > 0) {
                    aCleaned.insert(0, '.');
                }
                aCleaned.insert(0, aString);
                continue;
            }
            if (aCleaned.length() > 0) {
                aCleaned.append('.');
            }
            aCleaned.append(aString);
        }
        this.setTypeInfo(aCleaned.toString());
        this.setDefaultCrit(aPC);
    }

    private BigDecimal evaluateCost(PJEP myParser, String costExpr) {
        Object result;
        myParser.parseExpression(costExpr);
        if (!myParser.hasError() && (result = myParser.getValueAsObject()) != null) {
            return new BigDecimal(result.toString());
        }
        Logging.errorPrint("Bad equipment cost expression: " + costExpr);
        return BigDecimalHelper.ZERO;
    }

    private boolean ignoresCostDouble() {
        boolean noDouble = false;
        if (this.isType("MANTLE") || this.isType("POTION") || this.isType("SCROLL") || this.isType("STAFF") || this.isType("WAND")) {
            noDouble = true;
        }
        return noDouble;
    }

    private int parseCritMult(String aString) {
        if (aString.length() > 0 && aString.charAt(0) == 'x') {
            try {
                return Integer.parseInt(aString.substring(1));
            }
            catch (NumberFormatException nfe) {
                Logging.errorPrint("parseCritMult:" + this.getName() + ":" + aString);
            }
        }
        return -1;
    }

    private String pickChildType(SortedSet aTypeList, Float aQuant) {
        String canContain = "";
        Float acceptsType = this.getAcceptsType("TOTAL");
        if (acceptsType == null) {
            acceptsType = new Float(0.0f);
        }
        if (this.getChildType("Total") == null) {
            this.setChildType("Total", new Float(0.0f));
        }
        if (this.getChildType("Total").floatValue() + aQuant.floatValue() <= acceptsType.floatValue()) {
            Iterator e = aTypeList.iterator();
            while (e.hasNext() && "".equals(canContain)) {
                String aString = (String)e.next();
                if (!this.acceptsType(aString)) continue;
                if (this.containsChildType(aString) && this.getChildType(aString).floatValue() + aQuant.floatValue() <= this.getAcceptsType(aString).floatValue()) {
                    canContain = aString;
                    continue;
                }
                if (!(aQuant.floatValue() <= this.getAcceptsType(aString).floatValue())) continue;
                canContain = aString;
            }
            if ("".equals(canContain) && this.acceptsType("Any")) {
                if (!this.containsChildType("Any")) {
                    this.setChildType("Any", new Float(0.0f));
                }
                if (this.getChildType("Any").floatValue() + aQuant.floatValue() <= this.getAcceptsType("Any").floatValue()) {
                    canContain = "Any";
                }
            }
        }
        return canContain;
    }

    private void removeCommonFromList(List altList, List commonList, String errMsg) {
        for (int i = altList.size() - 1; i >= 0; --i) {
            EquipmentModifier eqMod = (EquipmentModifier)altList.get(i);
            if (!eqMod.getAssignToAll()) continue;
            int j = commonList.indexOf(eqMod);
            if (j >= 0) {
                altList.remove(i);
                continue;
            }
            Logging.errorPrint(errMsg + eqMod.getName());
        }
    }

    private void removeContainedEquipment(int i) {
        this.d_containedEquipment.remove(i);
    }

    private void removeEqModifier(String aString, boolean bPrimary) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        String eqModKey = aTok.nextToken();
        EquipmentModifier eqMod = this.getEqModifierKeyed(eqModKey, bPrimary);
        if (eqMod == null) {
            return;
        }
        while (aTok.hasMoreTokens()) {
            String x = aTok.nextToken().replace('=', '|');
            for (int i = eqMod.getAssociatedCount() - 1; i >= 0; --i) {
                String aChoice = eqMod.getAssociated(i);
                if (!aChoice.startsWith(x)) continue;
                eqMod.removeAssociated(i);
            }
        }
        if (eqMod.getAssociatedCount() == 0) {
            this.removeEqModifier(eqMod, bPrimary);
        }
    }

    private void removeUnqualified(boolean bPrimary) {
        boolean bRemoved;
        List eqModList = this.getEqModifierList(bPrimary);
        do {
            bRemoved = false;
            for (int i = eqModList.size() - 1; i >= 0; --i) {
                EquipmentModifier eqMod = (EquipmentModifier)eqModList.get(i);
                if (eqMod.passesPreReqToGain(this)) continue;
                Logging.errorPrint("reUnq:Removing: " + eqMod.getName());
                Logging.errorPrint("reUnq:preReqs: " + eqMod.preReqStrings());
            }
        } while (bRemoved);
    }

    final void addMyType(String myType) {
        this.typeListCachePrimary = null;
        this.typeListCacheSecondary = null;
        super.addMyType(myType);
    }

    protected void clearMyType() {
        this.typeListCachePrimary = null;
        this.typeListCacheSecondary = null;
        super.clearMyType();
    }

    protected void removeMyType(String myType) {
        this.typeListCachePrimary = null;
        this.typeListCacheSecondary = null;
        super.removeMyType(myType);
    }

    private List typeList(boolean bPrimary) {
        ArrayList calculatedTypeList;
        if (bPrimary && this.typeListCachePrimary != null) {
            ++cacheHit;
            return this.typeListCachePrimary;
        }
        if (!bPrimary && this.typeListCacheSecondary != null) {
            ++cacheHit;
            return this.typeListCacheSecondary;
        }
        ++cacheMiss;
        if (bPrimary || this.getAltTypeCount() == 0) {
            calculatedTypeList = new ArrayList();
            this.addMyTypeTo(calculatedTypeList);
        } else {
            if (!this.isDouble()) {
                return new ArrayList();
            }
            calculatedTypeList = new ArrayList(this.getAltTypeCount());
            if (this.altTypeList != null) {
                calculatedTypeList.addAll(this.altTypeList);
            }
        }
        ArrayList<String> modTypeList = new ArrayList<String>();
        EquipmentModifier aEqMod = this.getEqModifierKeyed("ADDTYPE", bPrimary);
        if (aEqMod != null) {
            for (int e = 0; e < aEqMod.getAssociatedCount(); ++e) {
                String aType = aEqMod.getAssociated(e);
                if (calculatedTypeList.contains(aType = aType.toUpperCase())) continue;
                modTypeList.add(aType);
            }
        }
        List eqModList = this.getEqModifierList(bPrimary);
        Iterator e = eqModList.iterator();
        while (e.hasNext()) {
            int idx;
            aEqMod = (EquipmentModifier)e.next();
            if (this.willIgnore(aEqMod.getKeyName(), bPrimary)) continue;
            String armorType = aEqMod.replaceArmorType(calculatedTypeList);
            if (armorType != null && (idx = modTypeList.indexOf(armorType)) >= 0) {
                modTypeList.remove(idx);
            }
            List eqModTypeList = aEqMod.getItemType();
            Iterator e2 = eqModTypeList.iterator();
            while (e2.hasNext()) {
                String aType = (String)e2.next();
                aType = aType.toUpperCase();
                if (calculatedTypeList.contains("BOTH") && calculatedTypeList.contains("MELEE") && ("RANGED".equals(aType) || "THROWN".equals(aType)) || calculatedTypeList.contains(aType) || modTypeList.contains(aType)) continue;
                modTypeList.add(aType);
            }
        }
        calculatedTypeList.addAll(modTypeList);
        int idx = calculatedTypeList.indexOf("MAGIC");
        if (idx > 0) {
            calculatedTypeList.remove(idx);
            calculatedTypeList.add(0, "MAGIC");
        }
        if (bPrimary) {
            this.typeListCachePrimary = calculatedTypeList;
        } else {
            this.typeListCacheSecondary = calculatedTypeList;
        }
        return calculatedTypeList;
    }

    private void updateContainerCapacityString() {
        StringBuffer tempStringBuffer = new StringBuffer();
        boolean comma = false;
        if (this.containerWeightCapacity.intValue() != -1) {
            tempStringBuffer.append(this.containerWeightCapacity).append(' ').append(Globals.getWeightUnit());
            comma = true;
        }
        if (this.getAcceptsTypeCount() > 0) {
            Iterator e = this.d_acceptsTypes.keySet().iterator();
            while (e.hasNext()) {
                String aString;
                if (comma) {
                    tempStringBuffer.append(", ");
                    comma = false;
                }
                if (this.getAcceptsType(aString = (String)e.next()).intValue() != -1) {
                    tempStringBuffer.append(this.getAcceptsType(aString).floatValue()).append(' ');
                    tempStringBuffer.append(aString);
                    comma = true;
                    continue;
                }
                if ("TOTAL".equals(aString)) continue;
                comma = true;
                tempStringBuffer.append(aString);
            }
        }
        this.containerCapacityString = tempStringBuffer.toString();
    }

    private boolean willIgnore(String eqModKey, boolean bPrimary) {
        List eqModList = this.getEqModifierList(bPrimary);
        if (eqModList.size() != 0) {
            Iterator e = eqModList.iterator();
            while (e.hasNext()) {
                EquipmentModifier aEqMod = (EquipmentModifier)e.next();
                if (!aEqMod.willIgnore(eqModKey)) continue;
                return true;
            }
        }
        return false;
    }

    public void activateBonuses(PlayerCharacter aPC) {
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            aBonus.setApplied(false);
            if (aBonus.hasPreReqs()) {
                if (PrereqHandler.passesAll(aBonus.getPrereqList(), this)) {
                    aBonus.setApplied(true);
                    continue;
                }
                aBonus.setApplied(false);
                continue;
            }
            aBonus.setApplied(true);
        }
    }

    static {
        Equipment.locationStringList[0] = EQUIPPED_NEITHER_STR;
        Equipment.locationStringList[1] = EQUIPPED_PRIMARY_STR;
        Equipment.locationStringList[2] = EQUIPPED_SECONDARY_STR;
        Equipment.locationStringList[3] = EQUIPPED_BOTH_STR;
        Equipment.locationStringList[4] = EQUIPPED_TWO_HANDS_STR;
        Equipment.locationStringList[5] = EQUIPPED_TEMPBONUS_STR;
        Equipment.locationStringList[6] = CARRIED_NEITHER_STR;
        Equipment.locationStringList[7] = CONTAINED_STR;
        Equipment.locationStringList[8] = NOT_CARRIED_STR;
        cacheMiss = 0;
        cacheHit = 0;
    }
}

