/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.SystemCollections;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class EquipmentList {
    private static final int EQUIPMENTLISTSIZE = 4000;
    private static final int MODIFIERLISTSIZE = 230;
    private static boolean bAutoGeneration = false;
    private static List equipmentList = new ArrayList(4000);
    private static List modifierList = new ArrayList(230);

    private EquipmentList() {
    }

    public static void setAutoGeneration(boolean auto) {
        EquipmentList.setbAutoGeneration(auto);
    }

    public static Equipment getEquipmentFromName(String baseName, PlayerCharacter aPC) {
        Equipment eq;
        ArrayList<String> modList = new ArrayList<String>();
        ArrayList<String> namList = new ArrayList<String>();
        ArrayList<String> sizList = new ArrayList<String>();
        String aName = baseName;
        int i = aName.indexOf(40);
        if (i >= 0) {
            StringTokenizer aTok = new StringTokenizer(aName.substring(i + 1), "/)", false);
            while (aTok.hasMoreTokens()) {
                int iSize;
                String cString = aTok.nextToken();
                for (iSize = 0; iSize <= SystemCollections.getSizeAdjustmentListSize() - 1 && !cString.equalsIgnoreCase(SystemCollections.getSizeAdjustmentAtIndex(iSize).getAbbreviation()); ++iSize) {
                }
                if (iSize <= SystemCollections.getSizeAdjustmentListSize() - 1) {
                    sizList.add(cString);
                    continue;
                }
                if ("Mighty Composite".equalsIgnoreCase(cString)) {
                    modList.add("Mighty");
                    modList.add("Composite");
                    continue;
                }
                modList.add(cString);
            }
            aName = aName.substring(0, i).trim();
        }
        if (i >= 0) {
            for (i = modList.size() - 1; i >= 0; --i) {
                String namePart = (String)modList.get(i);
                if (EquipmentList.getModifierNamed(namePart) != null) continue;
                namList.add(0, namePart);
                modList.remove(i);
            }
        }
        int[] bonuses = null;
        int bonusCount = 0;
        i = aName.indexOf(43);
        if (i >= 0) {
            StringTokenizer aTok = new StringTokenizer(aName.substring(i), "/", false);
            bonusCount = aTok.countTokens();
            bonuses = new int[bonusCount];
            int idx = 0;
            while (aTok.hasMoreTokens()) {
                String cString = aTok.nextToken();
                bonuses[idx++] = Delta.decode(cString);
            }
            aName = aName.substring(0, i).trim();
            if (bonusCount > 0) {
                for (int idx1 = 0; idx1 < namList.size(); ++idx1) {
                    String aString = (String)namList.get(idx1);
                    if (!"Mighty".equalsIgnoreCase(aString)) continue;
                    aString = Delta.toString(bonuses[bonusCount - 1]) + " " + aString;
                    namList.set(idx1, aString);
                    --bonusCount;
                }
            }
        }
        String omitString = "";
        String bonusString = "";
        while (true) {
            String eqName;
            if ((eq = EquipmentList.findEquipment(eqName = aName + bonusString, null, namList, sizList, omitString)) != null) {
                if (sizList.size() <= 1) break;
                sizList.remove(0);
                break;
            }
            eq = EquipmentList.findEquipment(eqName, namList, null, sizList, omitString);
            if (eq != null) {
                if (sizList.size() <= 1) break;
                sizList.remove(0);
                break;
            }
            eq = EquipmentList.findEquipment(eqName, namList, null, null, omitString);
            if (eq != null) break;
            if (sizList.size() == 1) {
                eq = EquipmentList.findEquipment(eqName, sizList, namList, null, omitString);
                if (eq == null) {
                    eq = EquipmentList.findEquipment(eqName, namList, sizList, null, omitString);
                }
                if (eq != null) {
                    sizList.clear();
                    break;
                }
            }
            if (baseName.indexOf("Thrown") >= 0 && omitString.length() == 0) {
                omitString = "Thrown";
                continue;
            }
            if (bonusCount <= 0 || bonuses == null || bonusString.length() != 0) break;
            omitString = "";
            bonusString = " " + Delta.toString(bonuses[0]);
        }
        if (eq != null) {
            boolean bModified = false;
            boolean bError = false;
            eq = (Equipment)eq.clone();
            Iterator e = modList.iterator();
            while (e.hasNext()) {
                String namePart = (String)e.next();
                EquipmentModifier eqMod = EquipmentList.getQualifiedModifierNamed(namePart, eq);
                if (eqMod != null) {
                    eq.addEqModifier(eqMod, true, aPC);
                    if (!eqMod.getAssignToAll() || !eq.isDouble()) continue;
                    eq.addEqModifier(eqMod, false, aPC);
                    bModified = true;
                    continue;
                }
                Logging.errorPrint("Could not find a qualified modifier named: " + namePart + " for " + eq.getName() + ":" + eq.typeList());
                bError = true;
            }
            if (bError) {
                return null;
            }
            if (sizList.size() != 0) {
                eq.resizeItem(aPC, (String)sizList.get(0));
                bModified = true;
                if (sizList.size() > 1) {
                    Logging.errorPrint("Too many sizes in item name, used only 1st of: " + sizList);
                }
            }
            if (bModified) {
                eq.nameItemFromModifiers(aPC);
                if (!EquipmentList.addEquipment(eq)) {
                    eq = EquipmentList.getEquipmentNamed(eq.getName());
                }
            }
        }
        return eq;
    }

    public static Equipment getEquipmentKeyed(String aKey) {
        return (Equipment)Globals.searchPObjectList(EquipmentList.getEquipmentList(), aKey);
    }

    public static Equipment getEquipmentKeyedNoCustom(String aKey) {
        ArrayList<Equipment> aList = new ArrayList<Equipment>();
        Iterator e = EquipmentList.getEquipmentList().iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (eq.isType("CUSTOM")) continue;
            aList.add(eq);
        }
        return (Equipment)Globals.searchPObjectList(aList, aKey);
    }

    public static List getEquipmentList() {
        return equipmentList;
    }

    public static Equipment getEquipmentNamed(String name) {
        return EquipmentList.getEquipmentNamed(name, EquipmentList.getEquipmentList());
    }

    public static Equipment getEquipmentNamed(String name, List aList) {
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!eq.getName().equalsIgnoreCase(name)) continue;
            return eq;
        }
        return null;
    }

    public static List getEquipmentOfType(List eqList, String desiredTypes, String excludedTypes) {
        List desiredTypeList = CoreUtility.split(desiredTypes, '.');
        List excludedTypeList = CoreUtility.split(excludedTypes, '.');
        ArrayList<Equipment> typeList = new ArrayList<Equipment>(100);
        if (desiredTypeList.size() != 0) {
            Iterator e = eqList.iterator();
            while (e.hasNext()) {
                Equipment eq = (Equipment)e.next();
                boolean addIt = true;
                Iterator e2 = desiredTypeList.iterator();
                while (e2.hasNext()) {
                    if (eq.isType((String)e2.next())) continue;
                    addIt = false;
                    break;
                }
                if (addIt && excludedTypeList.size() != 0) {
                    Iterator e3 = excludedTypeList.iterator();
                    while (e3.hasNext()) {
                        if (!eq.isType((String)e3.next())) continue;
                        addIt = false;
                        break;
                    }
                }
                if (!addIt) continue;
                typeList.add(eq);
            }
        }
        return typeList;
    }

    public static EquipmentModifier getModifierKeyed(String aKey) {
        return (EquipmentModifier)Globals.searchPObjectList(EquipmentList.getModifierList(), aKey);
    }

    public static List getModifierList() {
        return modifierList;
    }

    public static boolean addEquipment(Equipment aEq) {
        if (EquipmentList.getEquipmentKeyed(aEq.getKeyName()) != null) {
            return false;
        }
        if (!aEq.isType("CUSTOM")) {
            aEq.addMyType("CUSTOM");
        }
        Equipment.getEquipmentTypes().addAll(aEq.typeList());
        EquipmentList.getEquipmentList().add(aEq);
        if (!EquipmentList.isbAutoGeneration()) {
            Globals.sortPObjectList(EquipmentList.getEquipmentList());
        }
        return true;
    }

    public static void autoGenerateEquipment() {
        EquipmentList.setbAutoGeneration(true);
        EquipmentList.autogenerateRacialEquipment();
        EquipmentList.autogenerateMasterWorkEquipment();
        EquipmentList.autogenerateMagicEquipment();
        EquipmentList.autogenerateExoticMaterialsEquipment();
        EquipmentList.setbAutoGeneration(false);
        Globals.sortPObjectList(EquipmentList.getEquipmentList());
    }

    protected static void clearEquipmentList() {
        equipmentList = new ArrayList(4000);
    }

    protected static void clearModifierList() {
        modifierList = new ArrayList(230);
    }

    static EquipmentModifier getQualifiedModifierNamed(String aName, List aType) {
        Iterator e = EquipmentList.getModifierList().iterator();
        while (e.hasNext()) {
            EquipmentModifier aEqMod = (EquipmentModifier)e.next();
            if (!aEqMod.getName().equals(aName)) continue;
            if (aEqMod.isType("All")) {
                return aEqMod;
            }
            Iterator e2 = aType.iterator();
            while (e2.hasNext()) {
                String t = (String)e2.next();
                if (!aEqMod.isType(t)) continue;
                return aEqMod;
            }
        }
        return null;
    }

    private static EquipmentModifier getModifierNamed(String aName) {
        Iterator e = EquipmentList.getModifierList().iterator();
        while (e.hasNext()) {
            EquipmentModifier aEqMod = (EquipmentModifier)e.next();
            if (!aEqMod.getName().equals(aName)) continue;
            return aEqMod;
        }
        return null;
    }

    private static EquipmentModifier getQualifiedModifierNamed(String aName, Equipment eq) {
        Iterator e = EquipmentList.getModifierList().iterator();
        while (e.hasNext()) {
            EquipmentModifier aEqMod = (EquipmentModifier)e.next();
            if (!aEqMod.getName().startsWith(aName)) continue;
            Iterator e2 = eq.typeList().iterator();
            while (e2.hasNext()) {
                String t = (String)e2.next();
                if (!aEqMod.isType(t) || !aEqMod.passesPreReqToGain(eq)) continue;
                return aEqMod;
            }
        }
        return null;
    }

    private static void appendNameParts(List nameList, String omitString, StringBuffer newName) {
        Iterator e = nameList.iterator();
        while (e.hasNext()) {
            String namePart = (String)e.next();
            if (omitString.length() != 0 && namePart.equals(omitString)) continue;
            if (newName.length() > 2) {
                newName.append('/');
            }
            newName.append(namePart);
        }
    }

    private static void autogenerateExoticMaterialsEquipment() {
        if (SettingsHandler.isAutogenExoticMaterial()) {
            for (int i = EquipmentList.getEquipmentList().size() - 1; i >= 0; --i) {
                Equipment eq = (Equipment)EquipmentList.getEquipmentList().get(i);
                if (eq.isMagic() || eq.isUnarmed() || eq.isMasterwork() || !eq.isAmmunition() && !eq.isArmor() && !eq.isShield() && !eq.isWeapon()) continue;
                EquipmentModifier eqDarkwood = EquipmentList.getQualifiedModifierNamed("Darkwood", eq);
                EquipmentModifier eqAdamantine = EquipmentList.getQualifiedModifierNamed("Adamantine", eq);
                EquipmentModifier eqMithral = EquipmentList.getQualifiedModifierNamed("Mithral", eq);
                EquipmentList.createItem(eq, eqDarkwood, null, null, null);
                EquipmentList.createItem(eq, eqAdamantine, null, null, null);
                EquipmentList.createItem(eq, eqMithral, null, null, null);
            }
        }
    }

    private static void autogenerateMagicEquipment() {
        if (SettingsHandler.isAutogenMagic()) {
            for (int iPlus = 1; iPlus <= 5; ++iPlus) {
                String aBonus = Delta.toString(iPlus);
                for (int i = EquipmentList.getEquipmentList().size() - 1; i >= 0; --i) {
                    Equipment eq = (Equipment)EquipmentList.getEquipmentList().get(i);
                    if (eq.isMagic() || eq.isMasterwork() || !eq.isAmmunition() && !eq.isArmor() && !eq.isShield() && !eq.isWeapon()) continue;
                    EquipmentModifier eqMod = EquipmentList.getQualifiedModifierNamed("Masterwork", eq);
                    if (eqMod == null) {
                        Logging.errorPrint("Can't find modifier named: Masterwork");
                        continue;
                    }
                    EquipmentChoice equipChoice = eqMod.buildEquipmentChoice(0, eq, false, false, 0);
                    Iterator equipIter = equipChoice.getChoiceIterator(true);
                    while (equipIter.hasNext()) {
                        String mwChoice = (String)equipIter.next();
                        eq = (Equipment)eq.clone();
                        eq.addEqModifier(eqMod, true, null, mwChoice, equipChoice);
                        if (eq.isWeapon() && eq.isDouble()) {
                            eq.addEqModifier(eqMod, false, null, mwChoice, equipChoice);
                        }
                        if ((eqMod = EquipmentList.getQualifiedModifierNamed(aBonus, eq)) == null) {
                            Logging.errorPrint("Can't find modifier named: " + aBonus);
                            continue;
                        }
                        EquipmentList.createItem(eq, eqMod, null, null, null);
                    }
                }
            }
        }
    }

    private static void autogenerateMasterWorkEquipment() {
        if (SettingsHandler.isAutogenMasterwork()) {
            for (int i = EquipmentList.getEquipmentList().size() - 1; i >= 0; --i) {
                Equipment eq = (Equipment)EquipmentList.getEquipmentList().get(i);
                if (eq.isMagic() || eq.isUnarmed() || eq.isMasterwork() || !eq.isAmmunition() && !eq.isArmor() && !eq.isShield() && !eq.isWeapon()) continue;
                EquipmentModifier eqMasterwork = EquipmentList.getQualifiedModifierNamed("Masterwork", eq);
                EquipmentChoice equipChoice = eqMasterwork.buildEquipmentChoice(0, eq, false, false, 0);
                Iterator equipIter = equipChoice.getChoiceIterator(true);
                while (equipIter.hasNext()) {
                    String choice = (String)equipIter.next();
                    EquipmentList.createItem(eq, eqMasterwork, null, choice, equipChoice);
                }
            }
        }
    }

    private static void autogenerateRacialEquipment() {
        if (SettingsHandler.isAutogenRacial()) {
            int[] gensizes = new int[9];
            ArrayList races = new ArrayList(Globals.getRaceMap().values());
            Iterator e = races.iterator();
            while (e.hasNext()) {
                Race race = (Race)e.next();
                int iSize = Globals.sizeInt(race.getSize());
                boolean flag = true;
                int n = iSize;
                gensizes[n] = gensizes[n] | 1;
            }
            int x = -1;
            for (int i = EquipmentList.getEquipmentList().size() - 1; i >= 0; --i) {
                Equipment eq = (Equipment)EquipmentList.getEquipmentList().get(i);
                if (eq.isMagic() || eq.isUnarmed() || eq.isMasterwork() || !eq.isArmor() && !eq.isShield() && !eq.isType("RESIZABLE")) continue;
                for (int j = 0; j <= SystemCollections.getSizeAdjustmentListSize() - 1; ++j) {
                    SizeAdjustment s;
                    if (x == -1 && (s = SystemCollections.getSizeAdjustmentAtIndex(j)).isDefaultSize()) {
                        x = j;
                    }
                    if (j == x || (gensizes[j] & 1) == 0) continue;
                    EquipmentList.createItem(eq, j, null);
                }
            }
        }
    }

    private static void createItem(Equipment eq, int iSize, PlayerCharacter aPC) {
        EquipmentList.createItem(eq, null, iSize, aPC, "", null);
    }

    private static void createItem(Equipment eq, EquipmentModifier eqMod, PlayerCharacter aPC, String choice, EquipmentChoice equipChoice) {
        EquipmentList.createItem(eq, eqMod, -1, aPC, choice, equipChoice);
    }

    private static void createItem(Equipment eq, EquipmentModifier eqMod, int iSize, PlayerCharacter aPC, String choice, EquipmentChoice equipChoice) {
        if (eq == null) {
            return;
        }
        try {
            String sName;
            Equipment eqExists;
            if (!eq.getModifiersAllowed() || eq.isArmor() && eq.getACMod(aPC) == 0 && eqMod != null && !eqMod.getName().equalsIgnoreCase("MASTERWORK")) {
                return;
            }
            if ((eq = (Equipment)eq.clone()) == null) {
                Logging.errorPrint("could not clone item");
                return;
            }
            if (eqMod != null) {
                eq.addEqModifier(eqMod, true, aPC, choice, equipChoice);
                if (eq.isWeapon() && eq.isDouble()) {
                    eq.addEqModifier(eqMod, false, aPC, choice, equipChoice);
                }
            }
            if (iSize >= 0 && iSize <= SystemCollections.getSizeAdjustmentListSize() - 1) {
                eq.resizeItem(aPC, SystemCollections.getSizeAdjustmentAtIndex(iSize).getName());
            }
            if ((eqExists = EquipmentList.getEquipmentKeyed(sName = eq.nameItemFromModifiers(aPC))) != null) {
                return;
            }
            String newType = EquipmentList.isbAutoGeneration() ? "AUTO_GEN" : "CUSTOM";
            if (!eq.isType(newType)) {
                eq.addMyType(newType);
            }
            Equipment.getEquipmentTypes().addAll(eq.typeList());
            EquipmentList.getEquipmentList().add(eq);
        }
        catch (NumberFormatException exception) {
            Logging.errorPrint("createItem: exception: " + eq.getName());
        }
    }

    private static Equipment findEquipment(String aName, List preNameList, List postNameList, List sizList, String omitString) {
        StringBuffer newName = new StringBuffer(80);
        newName.append(" (");
        if (preNameList != null) {
            List nameList = preNameList;
            EquipmentList.appendNameParts(nameList, omitString, newName);
        }
        if (sizList != null && sizList.size() > 1) {
            newName.append((String)sizList.get(0));
        }
        if (postNameList != null) {
            EquipmentList.appendNameParts(postNameList, omitString, newName);
        }
        if (newName.length() == 2) {
            newName.setLength(0);
        } else {
            newName.append(')');
        }
        Equipment eq = EquipmentList.getEquipmentKeyed(aName + newName);
        return eq;
    }

    private static boolean isbAutoGeneration() {
        return bAutoGeneration;
    }

    private static void setbAutoGeneration(boolean argbAutoGeneration) {
        bAutoGeneration = argbAutoGeneration;
    }
}

