/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentList;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialProperty;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public final class EquipmentModifier
extends PObject {
    protected static final int VISIBLE_NO = 0;
    protected static final int VISIBLE_YES = 1;
    protected static final int VISIBLE_QUALIFIED = 2;
    private static final int NAMINGOPTION_NORMAL = 0;
    private static final int NAMINGOPTION_NONAME = 1;
    private static final int NAMINGOPTION_NOLIST = 2;
    private static final int NAMINGOPTION_NOTHING = 3;
    private static final int NAMINGOPTION_SPELL = 4;
    private static final String s_CHARGES = "CHARGES";
    private List ignores = new ArrayList();
    private List itemType = new ArrayList();
    private List replaces = new ArrayList();
    private List specialPropertyList = new ArrayList();
    private List vFeatList = null;
    private List armorType = new ArrayList();
    private String cost = "0";
    private String preCost = "0";
    private String proficiency = "";
    private boolean assignToAll = false;
    private int costDouble = -1;
    private int equipmentVisible = 1;
    private int maxCharges = 0;
    private int minCharges = 0;
    private int namingOption = 0;
    private int plus = 0;

    public List getActiveBonuses(PObject caller, PlayerCharacter aPC) {
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (this.willIgnore(this.getKeyName())) continue;
            if (caller instanceof Equipment) {
                if (!PrereqHandler.passesAll(aBonus.getPrereqList(), (Equipment)caller)) continue;
                aBonus.setApplied(true);
                aList.add(aBonus);
                continue;
            }
            if (!PrereqHandler.passesAll(aBonus.getPrereqList(), aPC, caller)) continue;
            aBonus.setApplied(true);
            aList.add(aBonus);
        }
        return aList;
    }

    public void setArmorType(String aString) {
        this.armorType.add(aString.toUpperCase().trim());
    }

    public boolean getAssignToAll() {
        return this.assignToAll;
    }

    public void setAssignment(String aString) {
        this.assignToAll = aString.length() > 0 && aString.charAt(0) == 'Y';
    }

    public List getBonusList() {
        ArrayList<BonusObj> myBonusList = new ArrayList<BonusObj>(super.getBonusList());
        for (int i = myBonusList.size() - 1; i > -1; --i) {
            BonusObj aBonus = (BonusObj)myBonusList.get(i);
            String aString = aBonus.toString();
            int idx = aString.indexOf("%CHOICE");
            if (idx < 0) continue;
            for (int j = this.getAssociatedCount() - 1; j >= 0; --j) {
                BonusObj newBonus = Bonus.newBonus(aString.substring(0, idx) + this.getAssociated(j) + aString.substring(idx + 7));
                newBonus.setCreatorObject(this);
                if (aBonus.hasPreReqs()) {
                    try {
                        newBonus.setPrereqList(aBonus.getClonePrereqList());
                    }
                    catch (CloneNotSupportedException e) {
                        // empty catch block
                    }
                }
                newBonus.expandToken("%CHOICE", this.getAssociated(j));
                myBonusList.add(newBonus);
                myBonusList.remove(aBonus);
            }
        }
        return myBonusList;
    }

    public List getBonusListOfType(String aType, String aName) {
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (aBonus.getTypeOfBonus().indexOf(aType) < 0 || aBonus.getBonusInfo().indexOf(aName) < 0 || this.willIgnore(this.getKeyName())) continue;
            aList.add(aBonus);
        }
        return aList;
    }

    public boolean getBonusListString(String aString) {
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (!aBonus.getBonusInfo().equalsIgnoreCase(aString)) continue;
            return true;
        }
        return false;
    }

    public void setChargeInfo(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        try {
            this.minCharges = Integer.parseInt(aTok.nextToken());
            if (this.minCharges < 0) {
                this.minCharges = 0;
            }
            this.maxCharges = this.minCharges;
            if (aTok.hasMoreTokens()) {
                this.maxCharges = Integer.parseInt(aTok.nextToken());
            }
            if (this.maxCharges < this.minCharges) {
                this.maxCharges = this.minCharges;
            }
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Invalid CHARGES tag value: " + aString);
        }
    }

    public void setCost(String aString) {
        this.cost = aString;
    }

    public String getCost() {
        return this.cost;
    }

    public void setCostDouble(boolean costDoubles) {
        this.costDouble = costDoubles ? 1 : 0;
    }

    public void setIgnores(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString.toUpperCase().trim(), ",");
        this.ignores.clear();
        while (aTok.hasMoreTokens()) {
            String aReplace = aTok.nextToken();
            if (this.ignores.contains(aReplace)) continue;
            this.ignores.add(aReplace);
        }
    }

    public void setItemType(String aString) {
        String typeString = aString.toUpperCase().trim();
        StringTokenizer aTok = new StringTokenizer(typeString, ".");
        this.itemType.clear();
        while (aTok.hasMoreTokens()) {
            String aType = aTok.nextToken();
            if (this.itemType.contains(aType)) continue;
            this.itemType.add(aType);
        }
    }

    public List getItemType() {
        return this.itemType;
    }

    public int getMaxCharges() {
        return this.maxCharges;
    }

    public int getMinCharges() {
        return this.minCharges;
    }

    public void setNamingOption(String argNamingOption) {
        this.namingOption = "NOLIST".equalsIgnoreCase(argNamingOption) ? 2 : ("NONAME".equalsIgnoreCase(argNamingOption) ? 1 : ("NOTHING".equalsIgnoreCase(argNamingOption) ? 3 : ("SPELL".equalsIgnoreCase(argNamingOption) ? 4 : 0)));
    }

    public void setPlus(String aString) {
        try {
            this.plus = Integer.parseInt(aString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getPlus() {
        return this.plus;
    }

    public void setPreCost(String aString) {
        this.preCost = aString;
    }

    public String getPreCost() {
        return this.preCost;
    }

    public void setProficiency(String prof) {
        this.proficiency = prof;
    }

    public void setReplacement(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString.toUpperCase().trim(), ",");
        this.replaces.clear();
        while (aTok.hasMoreTokens()) {
            String aReplace = aTok.nextToken();
            if (this.replaces.contains(aReplace)) continue;
            this.replaces.add(aReplace);
        }
    }

    public void addSpecialProperty(SpecialProperty sprop) {
        this.specialPropertyList.add(sprop);
    }

    public List getRawSpecialProperties() {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < this.specialPropertyList.size(); ++i) {
            SpecialProperty sprop = (SpecialProperty)this.specialPropertyList.get(i);
            retList.add(sprop.getText());
        }
        return retList;
    }

    public List getSpecialProperties(Equipment caller, PlayerCharacter pc) {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < this.specialPropertyList.size(); ++i) {
            SpecialProperty sprop = (SpecialProperty)this.specialPropertyList.get(i);
            String spropText = sprop.getParsedText(pc);
            for (int j = 0; j < this.getAssociatedCount(); ++j) {
                spropText = spropText.replaceFirst("%CHOICE", this.getAssociated(j));
            }
            if (spropText == null || spropText.equals("")) continue;
            retList.add(spropText);
        }
        return retList;
    }

    public void setSpellInfo(PObject spellCastingClass, Spell theSpell, String spellVariant, String spellType, int spellLevel, int spellCasterLevel, Object[] spellMetamagicFeats, int charges) {
        StringBuffer spellInfo = new StringBuffer(100);
        spellInfo.append("SPELLNAME[").append(theSpell.getName()).append("] ");
        spellInfo.append("CASTER[").append(spellCastingClass.getName()).append("] ");
        if (spellVariant.length() != 0) {
            spellInfo.append("VARIANT[").append(spellVariant).append("] ");
        }
        spellInfo.append("SPELLTYPE[").append(spellType).append("] ");
        spellInfo.append("SPELLLEVEL[").append(spellLevel).append("] ");
        spellInfo.append("CASTERLEVEL[").append(spellCasterLevel).append("] ");
        if (charges > 0) {
            spellInfo.append(s_CHARGES).append('[').append(charges).append("] ");
        }
        if (spellMetamagicFeats != null && spellMetamagicFeats.length > 0) {
            spellInfo.append("METAFEATS[");
            for (int i = 0; i < spellMetamagicFeats.length; ++i) {
                Feat aFeat = (Feat)spellMetamagicFeats[i];
                if (i != 0) {
                    spellInfo.append(", ");
                }
                spellInfo.append(aFeat.getKeyName());
            }
            spellInfo.append("] ");
        }
        this.addAssociated(spellInfo.toString());
    }

    public void setVisible(String aString) {
        this.equipmentVisible = aString.length() > 0 && aString.charAt(0) == 'Y' ? 1 : (aString.length() > 0 && aString.charAt(0) == 'Q' ? 2 : 0);
    }

    public void addVFeatList(String vList) {
        StringTokenizer aTok = new StringTokenizer(vList, "|", false);
        while (aTok.hasMoreTokens()) {
            if (this.vFeatList == null) {
                this.vFeatList = new ArrayList();
            }
            this.vFeatList.add(aTok.nextToken());
        }
    }

    public double bonusTo(PlayerCharacter aPC, String aType, String aName, Object obj) {
        return super.bonusTo(aType, aName, obj, this.getBonusList(), aPC);
    }

    public void calcBonuses() {
        LinkedList<BonusObj> addList = new LinkedList<BonusObj>();
        LinkedList<BonusObj> delList = new LinkedList<BonusObj>();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            String aString = aBonus.toString();
            int idx = aString.indexOf("%CHOICE");
            if (idx < 0) continue;
            delList.add(aBonus);
            for (int j = 0; j < this.getAssociatedCount(); ++j) {
                BonusObj newBonus = Bonus.newBonus(aString.substring(0, idx) + this.getAssociated(j) + aString.substring(idx + 7));
                newBonus.setCreatorObject(this);
                addList.add(newBonus);
            }
        }
        if (delList.size() > 0) {
            ab = delList.iterator();
            while (ab.hasNext()) {
                this.removeBonusList((BonusObj)ab.next());
            }
            ab = addList.iterator();
            while (ab.hasNext()) {
                this.addBonusList((BonusObj)ab.next());
            }
        }
    }

    public Object clone() {
        EquipmentModifier aObj = null;
        try {
            aObj = (EquipmentModifier)super.clone();
            aObj.itemType = (List)((ArrayList)this.itemType).clone();
            aObj.specialPropertyList = (List)((ArrayList)this.specialPropertyList).clone();
            aObj.replaces = (List)((ArrayList)this.replaces).clone();
            aObj.ignores = (List)((ArrayList)this.ignores).clone();
            aObj.armorType = (List)((ArrayList)this.armorType).clone();
            aObj.cost = this.cost;
            aObj.preCost = this.preCost;
            aObj.proficiency = this.proficiency;
            aObj.equipmentVisible = this.equipmentVisible;
            aObj.plus = this.plus;
            aObj.assignToAll = this.assignToAll;
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aObj;
    }

    public boolean hasVFeats() {
        return this.vFeatList != null && this.vFeatList.size() > 0;
    }

    public String toString() {
        if (this.namingOption == 3) {
            return "";
        }
        StringBuffer aString = new StringBuffer(this.getName().length());
        if (this.namingOption == 4) {
            if (this.getAssociatedCount() > 0) {
                Spell aSpell;
                String listEntry = this.getAssociated(0);
                List metaFeats = EquipmentModifier.getSpellMetafeats(listEntry);
                String spellName = EquipmentModifier.getSpellName(listEntry);
                if (SettingsHandler.guiUsesOutputName() && (aSpell = Globals.getSpellNamed(spellName)) != null) {
                    spellName = aSpell.getOutputName();
                }
                aString.append(spellName);
                String info = EquipmentModifier.getSpellVariant(listEntry);
                if (info.length() != 0) {
                    aString.append(" (").append(info).append(')');
                }
                if (metaFeats.size() != 0) {
                    aString.append('/').append(CoreUtility.join((Collection)metaFeats, "/"));
                }
                aString.append('/').append(EquipmentModifier.getSpellCaster(listEntry));
                aString.append('/').append(CoreUtility.ordinal(EquipmentModifier.getSpellCasterLevel(listEntry)));
            }
        } else {
            if (this.namingOption != 1) {
                aString.append(this.getName());
            }
            if (this.namingOption != 2 && this.getAssociatedCount() > 0) {
                if (this.namingOption != 1) {
                    aString.append(" (");
                }
                boolean bFirst = true;
                for (int e = 0; e < this.getAssociatedCount(); ++e) {
                    if (!bFirst) {
                        aString.append(", ");
                    }
                    aString.append(this.getAssociated(e));
                    bFirst = false;
                }
                if (this.namingOption != 1) {
                    aString.append(")");
                }
            }
        }
        return aString.toString().trim().replace('|', ' ');
    }

    protected int getSR(PlayerCharacter aPC) {
        if (this.SR == null) {
            return 0;
        }
        if ("%CHOICE".equals(this.SR) && this.getAssociatedCount() > 0) {
            return Delta.parseInt(this.associatedList.get(0).toString());
        }
        return super.getSR(aPC);
    }

    int getChoice(int pool, Equipment parent, boolean bAdd) {
        if (this.choiceString.length() == 0) {
            return 1;
        }
        boolean forEqBuilder = this.choiceString.startsWith("EQBUILDER.");
        if (bAdd && forEqBuilder) {
            return 1;
        }
        ArrayList selectedList = new ArrayList();
        ChooserInterface chooser = ChooserFactory.getChooserInstance();
        chooser.setPoolFlag(false);
        chooser.setVisible(false);
        this.addAssociatedTo(selectedList);
        EquipmentChoice equipChoice = this.buildEquipmentChoice(pool, parent, bAdd, forEqBuilder, selectedList.size());
        if (!equipChoice.isBAdd()) {
            chooser.setPool(0);
        } else {
            chooser.setPool(equipChoice.getPool());
        }
        chooser.setAllowsDups(equipChoice.isAllowDuplicates());
        chooser.setSelectedListTerminator("|");
        chooser.setTitle("Select " + equipChoice.getTitle() + " (" + this.getName() + ")");
        Globals.sortChooserLists(equipChoice.getAvailableList(), selectedList);
        chooser.setAvailableList(equipChoice.getAvailableList());
        chooser.setSelectedList(selectedList);
        chooser.setVisible(true);
        selectedList = chooser.getSelectedList();
        this.setChoice(selectedList, equipChoice);
        return this.getAssociatedCount();
    }

    void setChoice(String choice, EquipmentChoice equipChoice) {
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(choice);
        this.setChoice(tempList, equipChoice);
    }

    void setChoice(List selectedList, EquipmentChoice equipChoice) {
        this.clearAssociated();
        for (int i = 0; i < selectedList.size(); ++i) {
            int idx;
            String aString = (String)selectedList.get(i);
            if (equipChoice.getMinValue() < equipChoice.getMaxValue() && (idx = aString.indexOf(124)) < 0) {
                ArrayList<String> secondaryChoice = new ArrayList<String>();
                for (int j = equipChoice.getMinValue(); j <= equipChoice.getMaxValue(); j += equipChoice.getIncValue()) {
                    if (j == 0) continue;
                    secondaryChoice.add(Delta.toString(j));
                }
                ChooserInterface chooser = ChooserFactory.getChooserInstance();
                chooser.setPoolFlag(false);
                chooser.setVisible(false);
                chooser.setTitle("Select modifier (" + aString + ")");
                chooser.setAvailableList(secondaryChoice);
                chooser.setSelectedList(new ArrayList());
                chooser.setPool(1);
                chooser.setVisible(true);
                if (chooser.getSelectedList().size() == 0) continue;
                aString = aString + '|' + (String)chooser.getSelectedList().get(0);
            }
            if (!equipChoice.isAllowDuplicates() && this.containsAssociated(aString)) continue;
            this.addAssociated(aString);
        }
    }

    EquipmentChoice buildEquipmentChoice(int pool, Equipment parent, boolean bAdd, boolean forEqBuilder, int numSelected) {
        EquipmentChoice equipChoice = new EquipmentChoice(bAdd, pool);
        if (this.choiceString.length() == 0) {
            return equipChoice;
        }
        StringTokenizer aTok = new StringTokenizer(this.choiceString, "|", false);
        String choiceType = aTok.nextToken();
        if (choiceType.startsWith("COUNT=")) {
            if (choiceType.substring(6).equalsIgnoreCase("ALL")) {
                equipChoice.setMaxSelect(Integer.MAX_VALUE);
            } else {
                try {
                    equipChoice.setMaxSelect(Integer.parseInt(choiceType.substring(6)));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            choiceType = aTok.nextToken();
        }
        while (!forEqBuilder && aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (equipChoice.getMaxSelect() > 0 && equipChoice.getMaxSelect() != Integer.MAX_VALUE && pool > 0) {
                equipChoice.setPool(equipChoice.getMaxSelect() - numSelected);
            }
            if (aString.startsWith("TITLE=")) {
                equipChoice.setTitle(aString.substring(6));
                continue;
            }
            if (aString.startsWith("TYPE=") || aString.startsWith("TYPE.")) {
                Iterator e;
                if (pool > 0 && equipChoice.getMaxSelect() == 0) {
                    equipChoice.setPool(pool - numSelected);
                }
                aString = aString.substring(5);
                boolean bAll = false;
                if (aString.equalsIgnoreCase("ALL")) {
                    bAll = true;
                }
                if (aString.startsWith("LASTCHOICE")) {
                    e = parent.getEqModifierList(true).iterator();
                    while (e.hasNext()) {
                        EquipmentModifier sibling = (EquipmentModifier)e.next();
                        if (sibling.equals(this) || !sibling.getChoiceString().startsWith(choiceType)) continue;
                        sibling.addAssociatedTo(equipChoice.getAvailableList());
                    }
                    continue;
                }
                if ("SKILL".equalsIgnoreCase(choiceType)) {
                    e = Globals.getSkillList().iterator();
                    while (e.hasNext()) {
                        Skill aSkill = (Skill)e.next();
                        if (!bAll && !aSkill.isType(aString) || equipChoice.getAvailableList().contains(aSkill.getName())) continue;
                        equipChoice.getAvailableList().add(aSkill.getName());
                    }
                    continue;
                }
                if ("EQUIPMENT".equalsIgnoreCase(choiceType)) {
                    e = EquipmentList.getEquipmentList().iterator();
                    while (e.hasNext()) {
                        Equipment aEquip = (Equipment)e.next();
                        if (!aEquip.isType(aString) || equipChoice.getAvailableList().contains(aEquip.getName())) continue;
                        equipChoice.getAvailableList().add(aEquip.getName());
                    }
                    continue;
                }
                if ("FEAT".equalsIgnoreCase(choiceType)) {
                    e = Globals.getFeatList().iterator();
                    while (e.hasNext()) {
                        Feat aFeat = (Feat)e.next();
                        if (aFeat.isVisible() != 1 || equipChoice.getAvailableList().contains(aFeat.getName()) || !bAll && !aFeat.isType(aString) || aFeat.getChoiceString().length() != 0) continue;
                        equipChoice.getAvailableList().add(aFeat.getName());
                    }
                    continue;
                }
                if ("EQTYPES".equalsIgnoreCase(aString)) {
                    equipChoice.getAvailableList().addAll(Equipment.getEquipmentTypes());
                    continue;
                }
                Logging.errorPrint("Unknown option in CHOOSE '" + aString + "'");
                continue;
            }
            if ("STAT".equals(aString)) {
                for (int x = 0; x < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++x) {
                    equipChoice.getAvailableList().add(SettingsHandler.getGame().s_ATTRIBSHORT[x]);
                }
                continue;
            }
            if ("SKILL".equals(aString)) {
                Iterator e = Globals.getSkillList().iterator();
                while (e.hasNext()) {
                    Skill aSkill = (Skill)e.next();
                    equipChoice.getAvailableList().add(aSkill.getName());
                }
                continue;
            }
            if ("MULTIPLE".equals(aString)) {
                equipChoice.setAllowDuplicates(true);
                continue;
            }
            if ("NOSIGN".equals(aString)) {
                equipChoice.setNoSign(true);
                continue;
            }
            if (aString.startsWith("MIN=")) {
                try {
                    equipChoice.setMinValue(Delta.parseInt(aString.substring(4)));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (aString.startsWith("MAX=")) {
                try {
                    equipChoice.setMaxValue(Delta.parseInt(aString.substring(4)));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (aString.startsWith("INCREMENT=")) {
                try {
                    equipChoice.setIncValue(Delta.parseInt(aString.substring(10)));
                    if (equipChoice.getIncValue() >= 1) continue;
                    equipChoice.setIncValue(1);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (equipChoice.getAvailableList().contains(aString)) continue;
            equipChoice.getAvailableList().add(aString);
        }
        if (equipChoice.getMaxSelect() == Integer.MAX_VALUE) {
            equipChoice.setPool(equipChoice.getAvailableList().size() - numSelected);
            equipChoice.setBAdd(true);
        }
        if (equipChoice.getAvailableList().size() == 0 && equipChoice.getMinValue() < equipChoice.getMaxValue()) {
            for (int j = equipChoice.getMinValue(); j <= equipChoice.getMaxValue(); j += equipChoice.getIncValue()) {
                if (j == 0) continue;
                if (equipChoice.isNoSign() && j > 0) {
                    equipChoice.getAvailableList().add(Integer.toString(j));
                    continue;
                }
                equipChoice.getAvailableList().add(Delta.toString(j));
            }
            equipChoice.setMinValue(equipChoice.getMaxValue());
        }
        if (equipChoice.getTitle() == null) {
            equipChoice.setTitle(choiceType);
        }
        return equipChoice;
    }

    private String replaceCostSpellLevel(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%SPELLLEVEL") >= 0) {
            int idx = costFormula.indexOf("%SPELLLEVEL");
            if (modChoice.length() == 0) {
                int iLevel = EquipmentModifier.getSpellLevel(listEntry);
                modChoice = iLevel == 0 ? "0.5" : Integer.toString(iLevel);
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 11);
        }
        return costFormula;
    }

    private String replaceCostCasterLevel(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%CASTERLEVEL") >= 0) {
            int idx = costFormula.indexOf("%CASTERLEVEL");
            if (modChoice.length() == 0) {
                PCClass castClass;
                int iCasterLevel = EquipmentModifier.getSpellCasterLevel(listEntry);
                modChoice = Integer.toString(iCasterLevel);
                String castClassName = EquipmentModifier.getSpellCaster(listEntry);
                if (castClassName.length() != 0 && (castClass = Globals.getClassNamed(castClassName)) != null) {
                    StringBuffer multiple = new StringBuffer(200);
                    String aString = castClass.getItemCreationMultiplier();
                    if (aString.length() != 0) {
                        StringTokenizer aTok = new StringTokenizer(aString, "+-*/()", true);
                        if (aTok.countTokens() == 1) {
                            multiple.append(iCasterLevel).append('*').append(aString);
                        } else {
                            while (aTok.hasMoreTokens()) {
                                aString = aTok.nextToken();
                                if (aString.equals("CL")) {
                                    multiple.append(iCasterLevel);
                                    continue;
                                }
                                multiple.append(aString);
                            }
                        }
                        modChoice = multiple.toString();
                    }
                }
            }
            costFormula = costFormula.substring(0, idx) + "(" + modChoice + ")" + costFormula.substring(idx + 12);
        }
        return costFormula;
    }

    private String replaceCostCharges(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%CHARGES") >= 0) {
            int idx = costFormula.indexOf("%CHARGES");
            if (modChoice.length() == 0) {
                modChoice = Integer.toString(this.getSpellCharges(listEntry));
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 8);
        }
        return costFormula;
    }

    private String replaceCostSpellCost(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%SPELLCOST") >= 0) {
            String spellName;
            Spell aSpell;
            int idx = costFormula.indexOf("%SPELLCOST");
            if (modChoice.length() == 0 && (aSpell = Globals.getSpellNamed(spellName = EquipmentModifier.getSpellName(listEntry))) != null) {
                modChoice = aSpell.getCost().toString();
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 10);
        }
        return costFormula;
    }

    private String replaceCostChoice(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%CHOICE") >= 0) {
            int idx = costFormula.indexOf("%CHOICE");
            if (modChoice.length() == 0) {
                int offs = listEntry.lastIndexOf(124);
                int modValue = 0;
                try {
                    modValue = Delta.parseInt(listEntry.substring(offs + 1));
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                modChoice = Integer.toString(modValue);
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 7);
        }
        return costFormula;
    }

    private String replaceCostSpellXPCost(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%SPELLXPCOST") >= 0) {
            String spellName;
            Spell aSpell;
            int idx = costFormula.indexOf("%SPELLXPCOST");
            if (modChoice.length() == 0 && (aSpell = Globals.getSpellNamed(spellName = EquipmentModifier.getSpellName(listEntry))) != null) {
                modChoice = aSpell.getXPCost() + "";
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 12);
        }
        return costFormula;
    }

    protected String getCost(int eqIdx) {
        String listEntry = this.getAssociated(eqIdx);
        String costFormula = this.cost;
        costFormula = this.replaceCostSpellLevel(costFormula, listEntry);
        costFormula = this.replaceCostSpellCost(costFormula, listEntry);
        costFormula = this.replaceCostSpellXPCost(costFormula, listEntry);
        costFormula = this.replaceCostCasterLevel(costFormula, listEntry);
        costFormula = this.replaceCostCharges(costFormula, listEntry);
        costFormula = this.replaceCostChoice(costFormula, listEntry);
        return costFormula;
    }

    boolean getCostDouble() {
        if (this.costDouble < 0) {
            if (this.isType("MagicalEnhancement") || this.isType("BaseMaterial")) {
                return false;
            }
            if (this.itemType.contains("MAGIC")) {
                return true;
            }
            for (int i = 0; i < this.getPreReqCount(); ++i) {
                Prerequisite preReq = this.getPreReq(i);
                if (!"TYPE".equalsIgnoreCase(preReq.getKind()) || !preReq.getKey().equalsIgnoreCase("EQMODTYPE=MagicalEnhancement") && !preReq.getKey().equalsIgnoreCase("EQMODTYPE.MagicalEnhancement")) continue;
                return true;
            }
        }
        return this.costDouble == 1;
    }

    String getProficiency() {
        return this.proficiency;
    }

    void setRemainingCharges(int remainingCharges) {
        String listEntry;
        String chargeInfo;
        if (this.getAssociatedCount() > 0 && (chargeInfo = EquipmentModifier.getSpellInfoString(listEntry = this.getAssociated(0), s_CHARGES)).length() != 0) {
            chargeInfo = "CHARGES[" + chargeInfo + ']';
            int idx = listEntry.indexOf(chargeInfo);
            listEntry = listEntry.substring(0, idx) + listEntry.substring(idx + chargeInfo.length());
            listEntry = listEntry + "CHARGES[" + Integer.toString(remainingCharges) + ']';
            this.setAssociated(0, listEntry);
        }
    }

    int getRemainingCharges() {
        if (this.getAssociatedCount() > 0) {
            return this.getSpellCharges(this.getAssociated(0));
        }
        return 0;
    }

    int getUsedCharges() {
        return this.maxCharges - this.getRemainingCharges();
    }

    List getVFeatList() {
        if (this.vFeatList != null && (this.choiceString.startsWith("FEAT") || this.choiceString.indexOf("|FEAT") >= 0)) {
            ArrayList<String> vFeats = new ArrayList<String>();
            Iterator e = this.vFeatList.iterator();
            while (e.hasNext()) {
                String aString = (String)e.next();
                if (aString.equals("%CHOICE")) {
                    for (int i = 0; i < this.getAssociatedCount(); ++i) {
                        vFeats.add(this.getAssociated(i));
                    }
                    continue;
                }
                vFeats.add(aString);
            }
            return vFeats;
        }
        return this.vFeatList;
    }

    int getVisible() {
        return this.equipmentVisible;
    }

    String replaceArmorType(List aTypes) {
        for (int z = 0; z < this.armorType.size(); ++z) {
            int idx;
            StringTokenizer aTok = new StringTokenizer((String)this.armorType.get(z), "|");
            if (!aTok.hasMoreTokens() || (idx = aTypes.indexOf(aTok.nextToken())) < 0) continue;
            if (aTok.hasMoreTokens()) {
                String newArmorType = aTok.nextToken();
                aTypes.set(idx, newArmorType);
                return newArmorType;
            }
            aTypes.remove(idx);
        }
        return null;
    }

    boolean willIgnore(String aString) {
        return this.ignores.contains(aString.toUpperCase().trim());
    }

    boolean willReplace(String aString) {
        return this.replaces.contains(aString.toUpperCase().trim());
    }

    private static String getSpellCaster(String listEntry) {
        return EquipmentModifier.getSpellInfoString(listEntry, "CASTER");
    }

    private static int getSpellCasterLevel(String listEntry) {
        return EquipmentModifier.getSpellInfo(listEntry, "CASTERLEVEL");
    }

    private static int getSpellInfo(String listEntry, String desiredInfo) {
        int modValue = 0;
        String info = EquipmentModifier.getSpellInfoString(listEntry, desiredInfo);
        if (info.length() > 0) {
            try {
                modValue = Delta.parseInt(info);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        return modValue;
    }

    private static String getSpellInfoString(String listEntry, String desiredInfo) {
        int offs = listEntry.indexOf(desiredInfo + "[");
        int offs2 = listEntry.indexOf(93, offs + 1);
        if (offs >= 0 && offs2 > offs) {
            return listEntry.substring(offs + desiredInfo.length() + 1, offs2);
        }
        return "";
    }

    private static int getSpellLevel(String listEntry) {
        return EquipmentModifier.getSpellInfo(listEntry, "SPELLLEVEL");
    }

    private int getSpellCharges(String listEntry) {
        return EquipmentModifier.getSpellInfo(listEntry, s_CHARGES);
    }

    private static List getSpellMetafeats(String listEntry) {
        String metaFeat = EquipmentModifier.getSpellInfoString(listEntry, "METAFEATS");
        return CoreUtility.split(metaFeat, ',');
    }

    private static String getSpellName(String listEntry) {
        return EquipmentModifier.getSpellInfoString(listEntry, "SPELLNAME");
    }

    private static String getSpellVariant(String listEntry) {
        return EquipmentModifier.getSpellInfoString(listEntry, "VARIANT");
    }

    public BigDecimal addItemCosts(PlayerCharacter aPC, String bonusType, int qty, Equipment parent) {
        double val = 0.0;
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            String sub_type;
            BonusObj aBonus = (BonusObj)ab.next();
            boolean meetsAll = true;
            if (!aBonus.getBonusName().equals(bonusType)) continue;
            StringTokenizer aTok = new StringTokenizer(aBonus.toString().substring(bonusType.length()), "|", false);
            String bType = aTok.nextToken();
            aTok = new StringTokenizer(bType.substring(5), ".", false);
            String typeString = "TYPE";
            while (aTok.hasMoreTokens() && (meetsAll = parent.isType(sub_type = aTok.nextToken()))) {
                typeString = typeString + "." + sub_type;
            }
            if (!meetsAll) continue;
            val += this.bonusTo(aPC, bonusType, typeString, parent);
        }
        return new BigDecimal(val * (double)qty);
    }
}

