/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.HasCost;
import pcgen.core.LevelAbility;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

public final class Feat
extends PObject
implements HasCost {
    public static final int VISIBILITY_HIDDEN = 0;
    public static final int VISIBILITY_DEFAULT = 1;
    public static final int VISIBILITY_OUTPUT_ONLY = 2;
    public static final int VISIBILITY_DISPLAY_ONLY = 3;
    public static final int FEAT_NORMAL = 0;
    public static final int FEAT_AUTOMATIC = 1;
    public static final int FEAT_VIRTUAL = 2;
    private String addString = "";
    private String benefit = "";
    private String cost = "1";
    private boolean multiples = false;
    private boolean needsSaving = false;
    private boolean stacks = false;
    private int addSpellLevel = 0;
    private int featType = 0;
    private int featVisible = 1;
    private int levelsPerRepIncrease = 0;

    public void setAddSpellLevel(int argAddSpellLevel) {
        this.addSpellLevel = argAddSpellLevel;
    }

    public int getAddSpellLevel() {
        return this.addSpellLevel;
    }

    public void setAddString(String aString) {
        this.addString = aString;
    }

    public void setBenefit(String arg) {
        this.benefit = arg;
    }

    public String getBenefit() {
        return this.benefit;
    }

    public String getBenefitDescription() {
        if (SettingsHandler.useFeatBenefits() && this.benefit != null && this.benefit.length() > 1) {
            return this.benefit;
        }
        return this.getDescription();
    }

    public void setCost(String argCost) {
        this.cost = argCost;
    }

    public double getCost() {
        return Double.parseDouble(this.cost);
    }

    public double getCost(PlayerCharacter aPC) {
        return aPC.getVariableValue(this.cost, "").doubleValue();
    }

    public int getFeatType() {
        return this.featType;
    }

    public void setLevelsPerRepIncrease(Integer argLevelsPerRepIncrease) {
        this.levelsPerRepIncrease = argLevelsPerRepIncrease;
    }

    public void setMultiples(String aString) {
        this.multiples = aString.length() > 0 && aString.charAt(0) == 'Y';
    }

    public boolean isMultiples() {
        return this.multiples;
    }

    public void setNeedsSaving(boolean arg) {
        this.needsSaving = arg;
    }

    public String getPCCText(PlayerCharacter aPC) {
        StringBuffer txt = new StringBuffer(200);
        txt.append(this.getName());
        txt.append("\tCOST:").append(String.valueOf(this.getCost()));
        if (this.isMultiples()) {
            txt.append("\tMULT:Y");
        }
        if (this.isStacks()) {
            txt.append("\tSTACK:Y");
        }
        if (this.getAddSpellLevel() != 0) {
            txt.append("\tADDSPELLLEVEL:").append(this.getAddSpellLevel());
        }
        if (this.getAddString().length() != 0) {
            txt.append("\tADD:").append(this.getAddString());
        }
        txt.append("\tVISIBLE:");
        switch (this.isVisible()) {
            case 0: {
                txt.append("EXPORT");
                break;
            }
            case 2: {
                txt.append("EXPORT");
                break;
            }
            case 3: {
                txt.append("DISPLAY");
                break;
            }
            default: {
                txt.append("YES");
            }
        }
        txt.append(super.getPCCText(false, aPC));
        return txt.toString();
    }

    public void setStacks(String aString) {
        this.stacks = aString.length() > 0 && aString.charAt(0) == 'Y';
    }

    public boolean isStacks() {
        return this.stacks;
    }

    public void setVisible(int argVisible) {
        this.featVisible = argVisible;
    }

    public int isVisible() {
        return this.featVisible;
    }

    public boolean isWeaponProficiency() {
        if (this.getName() != null) {
            int weaponProfLoc = this.getName().toUpperCase().indexOf("WEAPON PROFICIENCY");
            return weaponProfLoc >= 0;
        }
        return false;
    }

    public Object clone() {
        Feat aFeat = null;
        try {
            aFeat = (Feat)super.clone();
            aFeat.visible = this.visible;
            aFeat.featVisible = this.featVisible;
            aFeat.multiples = this.isMultiples();
            aFeat.stacks = this.isStacks();
            aFeat.addString = this.getAddString();
            aFeat.levelsPerRepIncrease = this.levelsPerRepIncrease;
            aFeat.isSpecified = this.isSpecified;
            aFeat.addSpellLevel = this.addSpellLevel;
        }
        catch (CloneNotSupportedException e) {
            ShowMessageDelegate.showMessageDialog(e.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aFeat;
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    public String qualifiedName() {
        StringBuffer aStrBuf = new StringBuffer(this.name);
        if (this.getAssociatedCount() > 0 && !this.name.endsWith("Weapon Proficiency") && !this.name.startsWith("Armor Proficiency")) {
            aStrBuf.append(" (");
            int i = 0;
            if (this.getChoiceString().length() == 0 || this.multiples && this.stacks) {
                aStrBuf.append((int)((double)this.getAssociatedCount() * this.getCost()));
                aStrBuf.append("x)");
            } else {
                for (int e = 0; e < this.getAssociatedCount(true); ++e) {
                    if (i > 0) {
                        aStrBuf.append(", ");
                    }
                    aStrBuf.append(this.getAssociated(e, true));
                    ++i;
                }
                aStrBuf.append(')');
            }
        }
        return aStrBuf.toString();
    }

    protected List addSpecialAbilitiesToList(List aList, PlayerCharacter aPC) {
        ArrayList specialAbilityList = this.getSpecialAbilityList();
        if (specialAbilityList != null) {
            StringBuffer sb = new StringBuffer();
            Iterator it = specialAbilityList.iterator();
            while (it.hasNext()) {
                SpecialAbility sa = (SpecialAbility)it.next();
                String aName = sa.getName();
                int idx = aName.indexOf("%CHOICE");
                if (idx >= 0) {
                    sb.setLength(0);
                    sb.append(aName.substring(0, idx));
                    if (this.getAssociatedCount() != 0) {
                        for (int i = 0; i < this.getAssociatedCount(); ++i) {
                            if (i != 0) {
                                sb.append(" ,");
                            }
                            sb.append(this.getAssociated(i));
                        }
                    } else {
                        sb.append("<undefined>");
                    }
                    sb.append(aName.substring(idx + 7));
                    sa = new SpecialAbility(sb.toString(), sa.getSASource(), sa.getSADesc());
                }
                aList.add(sa);
            }
        }
        return aList;
    }

    String getAddString() {
        return this.addString;
    }

    public void setFeatType(int argFeatType) {
        switch (argFeatType) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
        this.featType = argFeatType;
    }

    boolean canBeSelectedBy(PlayerCharacter pc) {
        return PrereqHandler.passesAll(this.getPreReqList(), pc, this);
    }

    boolean matchesType(String argFeatType) {
        return this.isType(argFeatType);
    }

    void modAdds(boolean addIt, PlayerCharacter pc) {
        if (this.addString.length() == 0) {
            return;
        }
        PlayerCharacter aPC = pc;
        if (aPC == null) {
            return;
        }
        StringTokenizer aTok = new StringTokenizer(this.addString, "|", false);
        if (aTok.countTokens() < 2) {
            Logging.errorPrint("Badly formed ADD. " + this.addString);
            return;
        }
        String addType = aTok.nextToken();
        String addSec = aTok.nextToken();
        if ("WEAPONPROFS".equals(addType)) {
            aPC.setAutomaticFeatsStable(false);
        } else if ("FAVOREDCLASS".equals(addType)) {
            if ("LIST".equals(addSec)) {
                for (int e = 0; e < this.getAssociatedCount(); ++e) {
                    if (addIt) {
                        aPC.addFavoredClass(this.getAssociated(e));
                        continue;
                    }
                    aPC.removeFavoredClass(this.getAssociated(e));
                }
            } else if (addIt) {
                aPC.addFavoredClass(addSec);
                while (aTok.countTokens() > 0) {
                    aPC.addFavoredClass(aTok.nextToken());
                }
            } else {
                aPC.removeFavoredClass(addSec);
                while (aTok.countTokens() > 0) {
                    aPC.removeFavoredClass(aTok.nextToken());
                }
            }
        } else if ("SPECIAL".equals(addType)) {
            List saList = aPC.getSpecialAbilityList();
            if ("LIST".equals(addSec)) {
                for (int e = 0; e < this.getAssociatedCount(); ++e) {
                    SpecialAbility sa;
                    if (addIt) {
                        sa = new SpecialAbility(this.getAssociated(e));
                        saList.add(sa);
                        continue;
                    }
                    sa = new SpecialAbility(this.getAssociated(e));
                    saList.remove(sa);
                }
            } else if (addIt) {
                SpecialAbility sa = new SpecialAbility(addSec);
                saList.add(sa);
                while (aTok.countTokens() > 0) {
                    SpecialAbility sa2 = new SpecialAbility(aTok.nextToken());
                    saList.add(sa2);
                }
            } else {
                SpecialAbility sa = new SpecialAbility(addSec);
                saList.remove(sa);
                while (aTok.countTokens() > 0) {
                    SpecialAbility sa2 = new SpecialAbility(aTok.nextToken());
                    saList.remove(sa2);
                }
            }
        } else if ("TEMPLATE".equals(addType)) {
            if (addIt) {
                aPC.addTemplateNamed(addSec);
            } else {
                PCTemplate aTemplate = Globals.getTemplateNamed(addSec);
                aPC.removeTemplate(aTemplate);
            }
            while (aTok.countTokens() > 0) {
                String templateName = aTok.nextToken();
                if (addIt) {
                    aPC.addTemplateNamed(templateName);
                    continue;
                }
                PCTemplate aTemplate = Globals.getTemplateNamed(templateName);
                aPC.removeTemplate(aTemplate);
            }
        } else {
            Logging.debugPrint("WARNING: ADD:" + addType + "|" + addSec + " not handled for feat " + this.name);
        }
    }

    boolean modChoices(PlayerCharacter aPC) {
        ArrayList availableList = new ArrayList();
        ArrayList selectedList = new ArrayList();
        return Feat.modChoices(this, availableList, selectedList, true, aPC);
    }

    boolean modChoices(PlayerCharacter aPC, boolean addIt, List availableList, List selectedList, boolean process) {
        return Feat.modChoices(this, availableList, selectedList, process, aPC);
    }

    int numberInList(String aType) {
        String aString;
        int iCount = 0;
        String numString = "0123456789";
        if (aType.lastIndexOf(61) > -1) {
            aType = aType.substring(aType.lastIndexOf(61) + 1);
        }
        if (aType.lastIndexOf(43) > -1 && "0123456789".lastIndexOf((aString = aType.substring(aType.lastIndexOf(43) + 1)).substring(0, 1)) > 0) {
            aType = aType.substring(0, aType.lastIndexOf(43));
        }
        if (aType.lastIndexOf(45) > -1 && "0123456789".lastIndexOf((aString = aType.substring(aType.lastIndexOf(45) + 1)).substring(0, 1)) > 0) {
            aType = aType.substring(0, aType.lastIndexOf(45));
        }
        for (int i = 0; i < this.getAssociatedCount(); ++i) {
            if (!this.getAssociated(i).equalsIgnoreCase(aType)) continue;
            ++iCount;
        }
        return iCount;
    }

    public LevelAbility addAddList(int aLevel, String aString) {
        if (aString.startsWith("TEMPLATE|")) {
            this.setAddString(aString);
            return null;
        }
        return super.addAddList(aLevel, aString);
    }
}

