/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import pcgen.core.ClassType;
import pcgen.core.Constants;
import pcgen.core.LevelInfo;
import pcgen.core.PCAlignment;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.RuleCheck;
import pcgen.core.character.WieldCategory;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class GameMode
implements Comparable {
    private static PObject eqSizePenalty = new PObject();
    private List allowedModes;
    private List bonusFeatLevels = new ArrayList();
    private List bonusStatLevels = new ArrayList();
    private List classTypeList = new ArrayList();
    private List defaultDeityList = new ArrayList();
    private HashMap levelInfo = new HashMap();
    private List loadStrings = new ArrayList();
    private List skillMultiplierLevels = new ArrayList();
    private List wcStepsList = new ArrayList();
    private List wieldCategoryList = new ArrayList();
    private Map ACTypeAddMap = new HashMap();
    private Map ACTypeRemoveMap = new HashMap();
    private Map damageDownMap = new HashMap();
    private Map damageUpMap = new HashMap();
    private Map plusCalcs;
    private Map spellRangeMap = new HashMap();
    private String acAbbrev = "";
    private String acFlatBonus = "";
    private String acName = "";
    private String acTouchBonus = "";
    private String alignmentName = "";
    private String althpAbbrev = "";
    private String althpName = "";
    private String currencyUnit = "";
    private String currencyUnitAbbrev = "";
    private String damageResistance = "";
    private String defaultSpellBook = "Known Spells";
    private String displayVariable2Name = "";
    private String displayVariable2Text = "";
    private String displayVariable3Name = "";
    private String displayVariable3Text = "";
    private String displayVariableName = "";
    private String displayVariableText = "";
    private String hpAbbrev = "";
    private String hpName = "";
    private String levelDownMessage = "";
    private String levelUpMessage = "";
    private String menuEntry = "";
    private String menuToolTip = "";
    private String name = "";
    private String spellBaseDC = "0";
    private String wcStepsFormula = "";
    private String weaponCategories = "";
    private String weaponTypes = "";
    private TreeMap ruleCheckMap = new TreeMap();
    private TabInfo[] tInfo;
    private boolean showClassDefense;
    private int babAttCyc = 5;
    private int babMaxAtt = Integer.MAX_VALUE;
    private int babMaxLvl = Integer.MAX_VALUE;
    private int babMinVal = 1;
    private int checksMaxLvl = Integer.MAX_VALUE;
    private int displayOrder = Integer.MAX_VALUE;
    private List statList = new ArrayList();
    public boolean[] s_ATTRIBROLL;
    public String[] s_ATTRIBLONG;
    public String[] s_ATTRIBSHORT;
    private final List checkList = new ArrayList();
    private final List alignmentList = new ArrayList(15);
    private int shortRangeDistance;

    public GameMode(String modeName) {
        this.name = modeName;
        this.tInfo = new TabInfo[Constants.tabNames.length];
        for (int i = 0; i < this.tInfo.length; ++i) {
            this.tInfo[i] = new TabInfo();
        }
        this.tInfo[0].tabName = "in_abilities";
        this.tInfo[2].tabName = "in_class";
        this.tInfo[3].tabName = "in_descrip";
        this.tInfo[4].tabName = "in_domains";
        this.tInfo[5].tabName = "in_feats";
        this.tInfo[6].tabName = "in_inventory";
        this.tInfo[7].tabName = "in_race";
        this.tInfo[8].tabName = "in_skills";
        this.tInfo[9].tabName = "in_spells";
        this.tInfo[10].tabName = "in_summary";
        this.tInfo[1].tabName = "Source Materials";
    }

    public void setACAbbrev(String aString) {
        this.acAbbrev = aString;
    }

    public void setACText(String aString) {
        this.acName = aString;
    }

    public List getACTypeAddString(String ACType) {
        if (this.ACTypeAddMap == null) {
            return new ArrayList();
        }
        return (ArrayList)this.ACTypeAddMap.get(ACType);
    }

    public List getACTypeRemoveString(String ACType) {
        if (this.ACTypeRemoveMap == null) {
            return new ArrayList();
        }
        return (ArrayList)this.ACTypeRemoveMap.get(ACType);
    }

    public void setAcFlatBonus(String arg) {
        this.acFlatBonus = arg;
    }

    public String getAcFlatBonus() {
        return this.acFlatBonus;
    }

    public void setAcTouchBonus(String arg) {
        this.acTouchBonus = arg;
    }

    public String getAcTouchBonus() {
        return this.acTouchBonus;
    }

    public void setAlignmentText(String aString) {
        this.alignmentName = aString;
    }

    public void setAllowedModes(String argAllowedModes) {
        StringTokenizer aTok = new StringTokenizer(argAllowedModes, "|", false);
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (this.allowedModes == null) {
                this.allowedModes = new ArrayList();
            }
            this.allowedModes.add(aString);
        }
    }

    public void setAltHPAbbrev(String aString) {
        this.althpAbbrev = aString;
    }

    public void setAltHPText(String aString) {
        this.althpName = aString;
    }

    public void setBabMinVal(int arg) {
        this.babMinVal = arg;
    }

    public int getBabMinVal() {
        return this.babMinVal;
    }

    public void setBonusStatLevels(String aString) {
        this.bonusStatLevels.add(aString);
    }

    public void setChecksMaxLvl(int arg) {
        this.checksMaxLvl = arg;
    }

    public int getChecksMaxLvl() {
        return this.checksMaxLvl;
    }

    public ClassType getClassTypeByName(String aClassName) {
        Iterator i = this.classTypeList.iterator();
        while (i.hasNext()) {
            ClassType aClassType = (ClassType)i.next();
            if (!aClassType.getName().equalsIgnoreCase(aClassName)) continue;
            return aClassType;
        }
        return null;
    }

    public String getContextPath(int iTab) {
        if (iTab >= 0 && iTab < this.tInfo.length) {
            return this.tInfo[iTab].contextPath;
        }
        return "";
    }

    public void setCurrencyUnit(String aString) {
        this.currencyUnit = aString;
    }

    public void setCurrencyUnitAbbrev(String aString) {
        this.currencyUnitAbbrev = aString;
    }

    public Map getDamageDownMap() {
        return this.damageDownMap;
    }

    public void setDamageResistanceText(String aString) {
        this.damageResistance = aString;
    }

    public Map getDamageUpMap() {
        return this.damageUpMap;
    }

    public void setDefaultSpellBook(String aString) {
        this.defaultSpellBook = aString;
    }

    public void setDisplayOrder(String aString) {
        try {
            this.displayOrder = Integer.parseInt(aString);
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("Will use default for displayOrder: " + this.displayOrder, exc);
        }
    }

    public void setEqSizePenaltyObj(PObject anOb) {
        eqSizePenalty = anOb;
    }

    public static PObject getEqSizePenaltyObj() {
        return eqSizePenalty;
    }

    public void setBonusFeatLevels(String aString) {
        this.bonusFeatLevels.add(aString);
    }

    public void setHPAbbrev(String aString) {
        this.hpAbbrev = aString;
    }

    public void setHPText(String aString) {
        this.hpName = aString;
    }

    public void setLevelDownMessage(String aString) {
        this.levelDownMessage = aString;
    }

    public HashMap getLevelInfo() {
        return this.levelInfo;
    }

    public void addLevelInfo(LevelInfo levInfo) {
        this.levelInfo.put(levInfo.getLevelString(), levInfo);
    }

    public void setLevelUpMessage(String aString) {
        this.levelUpMessage = aString;
    }

    public String getLevelUpMessage() {
        return this.levelUpMessage;
    }

    public String getMenuEntry() {
        if (this.menuEntry == null) {
            return this.name;
        }
        return this.menuEntry;
    }

    public String getMenuToolTip() {
        if (this.menuToolTip == null) {
            return "";
        }
        return this.menuToolTip;
    }

    public void setModeName(String aString) {
        this.menuEntry = aString;
    }

    public void setModeToolTip(String aString) {
        this.menuToolTip = aString;
    }

    public String getName() {
        return this.name;
    }

    public String getPlusCalculation(String type) {
        String aString = null;
        if (this.plusCalcs != null) {
            aString = (String)this.plusCalcs.get(type);
        }
        return aString;
    }

    public RuleCheck getRuleByKey(String aKey) {
        return (RuleCheck)this.ruleCheckMap.get(aKey);
    }

    public boolean getRuleCheck(String aKey) {
        if (this.ruleCheckMap.containsKey(aKey)) {
            RuleCheck aRule = (RuleCheck)this.ruleCheckMap.get(aKey);
            return aRule.getDefault();
        }
        return false;
    }

    public List getRuleCheckList() {
        return new ArrayList(this.ruleCheckMap.values());
    }

    public void setShortRangeDistance(int aShortRange) {
        this.shortRangeDistance = aShortRange;
    }

    public int getShortRangeDistance() {
        return this.shortRangeDistance;
    }

    public void setShowClassDefense(boolean argShowDef) {
        this.showClassDefense = argShowDef;
    }

    public void setSkillMultiplierLevels(String pipeList) {
        StringTokenizer aTok = new StringTokenizer(pipeList, "|", false);
        this.skillMultiplierLevels.clear();
        while (aTok.hasMoreTokens()) {
            this.skillMultiplierLevels.add(aTok.nextToken());
        }
    }

    public void setSpellBaseDC(String arg) {
        this.spellBaseDC = arg;
    }

    public String getSpellBaseDC() {
        return this.spellBaseDC;
    }

    public void setSpellRangeFormula(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        if (aTok.countTokens() < 2) {
            return;
        }
        String aRange = aTok.nextToken().toUpperCase();
        String aFormula = aTok.nextToken();
        this.spellRangeMap.put(aRange, aFormula);
    }

    public String getSpellRangeFormula(String aRange) {
        String aString = null;
        if (this.spellRangeMap != null) {
            aString = (String)this.spellRangeMap.get(aRange);
        }
        return aString;
    }

    public void setTabContext(int iTab, String argTabContext) {
        this.tInfo[iTab].contextPath = argTabContext;
    }

    public void setTabName(int iTab, String argTabName) {
        this.tInfo[iTab].tabName = argTabName;
    }

    public String getTabName(int iTab) {
        String temp = this.tInfo[iTab].tabName;
        if (temp.startsWith("in_")) {
            temp = PropertyFactory.getString(temp);
        }
        return temp;
    }

    public static int getTabNumber(String tabName) {
        for (int i = 0; i < Constants.tabNames.length; ++i) {
            if (!tabName.equalsIgnoreCase(Constants.tabNames[i])) continue;
            return i;
        }
        return -1;
    }

    public void setBabAttCyc(int arg) {
        this.babAttCyc = arg;
    }

    public int getBabAttCyc() {
        return this.babAttCyc;
    }

    public void setBabMaxAtt(int arg) {
        this.babMaxAtt = arg;
    }

    public int getBabMaxAtt() {
        return this.babMaxAtt;
    }

    public void setBabMaxLvl(int arg) {
        this.babMaxLvl = arg;
    }

    public int getBabMaxLvl() {
        return this.babMaxLvl;
    }

    public boolean getTabShown(int iTab) {
        if (iTab >= 0 && iTab < this.tInfo.length) {
            return this.tInfo[iTab].visible;
        }
        return false;
    }

    public void setTabVisible(int iTab, String argTabVisible) {
        this.tInfo[iTab].visible = argTabVisible.startsWith("Y");
    }

    public void setVariableDisplay2Name(String aString) {
        this.displayVariable2Name = aString;
    }

    public void setVariableDisplay2Text(String aString) {
        this.displayVariable2Text = aString;
    }

    public void setVariableDisplay3Name(String aString) {
        this.displayVariable3Name = aString;
    }

    public void setVariableDisplay3Text(String aString) {
        this.displayVariable3Text = aString;
    }

    public void setVariableDisplayName(String aString) {
        this.displayVariableName = aString;
    }

    public void setVariableDisplayText(String aString) {
        this.displayVariableText = aString;
    }

    public void setWCStepsFormula(String aString) {
        this.wcStepsFormula = aString;
    }

    public String getWCStepsFormula() {
        return this.wcStepsFormula;
    }

    public String getWeaponCategories() {
        return this.weaponCategories;
    }

    public String getWeaponTypes() {
        return this.weaponTypes;
    }

    public WieldCategory getWieldCategory(String aName) {
        Iterator wc = this.wieldCategoryList.iterator();
        while (wc.hasNext()) {
            WieldCategory wCat = (WieldCategory)wc.next();
            if (!wCat.getName().equals(aName)) continue;
            return wCat;
        }
        return null;
    }

    public String getWieldCategoryStep(String startWC, int aBump) {
        int newInt = -1;
        for (int i = 0; i < this.wcStepsList.size(); ++i) {
            String wcName = (String)this.wcStepsList.get(i);
            if (!wcName.equals(startWC)) continue;
            newInt = i;
        }
        if (newInt < 0) {
            return startWC;
        }
        if ((newInt += aBump) > this.wcStepsList.size()) {
            newInt = this.wcStepsList.size();
        } else if (newInt < 0) {
            newInt = 0;
        }
        return (String)this.wcStepsList.get(newInt);
    }

    public void addACType(String ACTypeLine) {
        StringTokenizer aTok = new StringTokenizer(ACTypeLine, "\t");
        if (!aTok.hasMoreTokens()) {
            Logging.errorPrint("Empty tag in miscinfo.ACTYPE");
            return;
        }
        String ACType = aTok.nextToken();
        while (aTok.hasMoreTokens()) {
            ArrayList aList;
            String aString = aTok.nextToken();
            if (aString.startsWith("ADD:")) {
                aList = this.ACTypeAddMap.containsKey(ACType) ? (ArrayList)this.ACTypeAddMap.get(ACType) : new ArrayList();
                aList.add(aString.substring(4));
                this.ACTypeAddMap.put(ACType, aList);
                continue;
            }
            if (aString.startsWith("REMOVE:")) {
                aList = this.ACTypeRemoveMap.containsKey(ACType) ? (ArrayList)this.ACTypeRemoveMap.get(ACType) : new ArrayList();
                aList.add(aString.substring(7));
                this.ACTypeRemoveMap.put(ACType, aList);
                continue;
            }
            Logging.errorPrint("Incorrect tag in miscinfo.ACTYPE: " + aString);
        }
    }

    public void addClassType(String aString) {
        if (".CLEAR".equals(aString)) {
            this.classTypeList = null;
            return;
        }
        if (this.classTypeList == null) {
            this.classTypeList = new ArrayList();
        }
        ClassType aClassType = new ClassType();
        StringTokenizer aTok = new StringTokenizer(aString, "\t");
        aClassType.setName(aTok.nextToken());
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if (bString.startsWith("CRFORMULA:")) {
                aClassType.setCRFormula(bString.substring(10));
                continue;
            }
            if (bString.startsWith("XPPENALTY:")) {
                aClassType.setXPPenalty(bString.substring(10).equals("YES"));
                continue;
            }
            if (bString.startsWith("ISMONSTER:")) {
                aClassType.setIsMonster(bString.substring(10).equals("YES"));
                continue;
            }
            Logging.errorPrint("Incorrect tag in miscinfo.CLASSTYPE: " + bString);
        }
        this.classTypeList.add(aClassType);
    }

    public void addDeityList(String argDeityLine) {
        if (".CLEAR".equals(argDeityLine)) {
            this.defaultDeityList = null;
            return;
        }
        if (this.defaultDeityList == null) {
            this.defaultDeityList = new ArrayList();
        }
        this.defaultDeityList.add(argDeityLine);
    }

    public void addLoadString(String aString) {
        this.loadStrings.add(aString);
    }

    public void addPlusCalculation(String aString) {
        int idx = aString.indexOf(124);
        if (idx > 0) {
            if (this.plusCalcs == null) {
                this.plusCalcs = new HashMap();
            }
            this.plusCalcs.put(aString.substring(0, idx).toUpperCase(), aString.substring(idx + 1));
        }
    }

    public void addRule(RuleCheck aRule) {
        String aKey = aRule.getKey();
        this.ruleCheckMap.put(aKey, aRule);
    }

    public void addWeaponCategory(String aString) {
        this.weaponCategories = this.weaponCategories + '|' + aString;
    }

    public void addWeaponType(String aString) {
        this.weaponTypes = this.weaponTypes + '|' + aString;
    }

    public void addWieldCategory(WieldCategory wCat) {
        this.wieldCategoryList.add(wCat);
    }

    public void addWieldCategorySteps(String aLine) {
        this.wcStepsList.clear();
        StringTokenizer aTok = new StringTokenizer(aLine, "|");
        while (aTok.hasMoreTokens()) {
            String aName = aTok.nextToken();
            this.wcStepsList.add(aName);
        }
    }

    public int compareTo(Object obj) {
        if (obj != null) {
            int iOrder = ((GameMode)obj).getDisplayOrder();
            if (iOrder < this.displayOrder) {
                return 1;
            }
            if (iOrder > this.displayOrder) {
                return -1;
            }
            return this.name.compareToIgnoreCase(((GameMode)obj).name);
        }
        return 1;
    }

    public boolean hasRuleCheck(String aKey) {
        return this.ruleCheckMap.containsKey(aKey);
    }

    String getACAbbrev() {
        return this.acAbbrev;
    }

    String getACText() {
        return this.acName;
    }

    String getAlignmentText() {
        return this.alignmentName;
    }

    List getAllowedModes() {
        if (this.allowedModes == null) {
            ArrayList<String> modes = new ArrayList<String>(1);
            modes.add(this.name);
            return modes;
        }
        return this.allowedModes;
    }

    String getAltHPAbbrev() {
        return this.althpAbbrev;
    }

    String getAltHPText() {
        return this.althpName;
    }

    List getBonusFeatLevels() {
        return this.bonusFeatLevels;
    }

    List getBonusStatLevels() {
        return this.bonusStatLevels;
    }

    String getCurrencyDisplay() {
        return this.currencyUnitAbbrev;
    }

    String getDamageResistanceText() {
        return this.damageResistance;
    }

    String getDefaultSpellBook() {
        return this.defaultSpellBook;
    }

    List getDeityList() {
        return this.defaultDeityList;
    }

    int getDisplayOrder() {
        return this.displayOrder;
    }

    String getHPAbbrev() {
        return this.hpAbbrev;
    }

    String getHPText() {
        return this.hpName;
    }

    List getLoadStrings() {
        return this.loadStrings;
    }

    String getLongCurrencyDisplay() {
        return this.currencyUnit;
    }

    boolean getShowClassDefense() {
        return this.showClassDefense;
    }

    List getSkillMultiplierLevels() {
        return this.skillMultiplierLevels;
    }

    String getVariableDisplay2Name() {
        return this.displayVariable2Name;
    }

    String getVariableDisplay2Text() {
        return this.displayVariable2Text;
    }

    String getVariableDisplay3Name() {
        return this.displayVariable3Name;
    }

    String getVariableDisplay3Text() {
        return this.displayVariable3Text;
    }

    String getVariableDisplayName() {
        return this.displayVariableName;
    }

    String getVariableDisplayText() {
        return this.displayVariableText;
    }

    public List getUnmodifiableStatList() {
        return Collections.unmodifiableList(this.statList);
    }

    public void addToStatList(PCStat stat) {
        this.statList.add(stat);
    }

    public void clearStatList() {
        this.statList.clear();
    }

    public void setAttribLong(String[] s) {
        this.s_ATTRIBLONG = s;
    }

    public void setAttribLong(int index, String s) {
        this.s_ATTRIBLONG[index] = s;
    }

    public void setAttribRoll(boolean[] b) {
        this.s_ATTRIBROLL = b;
    }

    public void setAttribRoll(int index, boolean b) {
        this.s_ATTRIBROLL[index] = b;
    }

    public void setAttribShort(String[] s) {
        this.s_ATTRIBSHORT = s;
    }

    public void setAttribShort(int index, String s) {
        this.s_ATTRIBSHORT[index] = s;
    }

    public int getStatFromAbbrev(String attributeAbbreviation) {
        if (this.s_ATTRIBSHORT != null) {
            for (int stat = 0; stat < this.s_ATTRIBSHORT.length; ++stat) {
                if (!attributeAbbreviation.equalsIgnoreCase(this.s_ATTRIBSHORT[stat])) continue;
                return stat;
            }
        }
        return -1;
    }

    public void addToCheckList(PObject obj) {
        this.checkList.add(obj);
    }

    public void clearCheckList() {
        this.checkList.clear();
    }

    public PObject getCheckNamed(String name) {
        int index = this.getIndexOfCheck(name);
        PObject check = index == -1 ? null : (PObject)this.checkList.get(index);
        return check;
    }

    public int getIndexOfCheck(String check) {
        for (int i = 0; i < this.checkList.size(); ++i) {
            if (!this.checkList.get(i).toString().equalsIgnoreCase(check)) continue;
            return i;
        }
        return -1;
    }

    public List getUnmodifiableCheckList() {
        return Collections.unmodifiableList(this.checkList);
    }

    public void addToAlignmentList(PCAlignment alignment) {
        this.alignmentList.add(alignment);
    }

    public void clearAlignmentList() {
        this.alignmentList.clear();
    }

    public PCAlignment getAlignmentAtIndex(int index) {
        PCAlignment align = index < 0 || index >= this.alignmentList.size() ? null : (PCAlignment)this.alignmentList.get(index);
        return align;
    }

    public String[] getAlignmentListStrings(boolean useLongForm) {
        String[] al = new String[this.alignmentList.size()];
        int x = 0;
        Iterator i = this.alignmentList.iterator();
        while (i.hasNext()) {
            PCAlignment alignment = (PCAlignment)i.next();
            if (useLongForm) {
                al[x++] = alignment.getName();
                continue;
            }
            al[x++] = alignment.getKeyName();
        }
        return al;
    }

    public int getIndexOfAlignment(String alignmentName) {
        for (int i = 0; i < this.alignmentList.size(); ++i) {
            PCAlignment alignment = (PCAlignment)this.alignmentList.get(i);
            if (!alignment.getName().equalsIgnoreCase(alignmentName) && !alignment.getKeyName().equalsIgnoreCase(alignmentName)) continue;
            return i;
        }
        return -1;
    }

    public String getLongAlignmentAtIndex(int index) {
        PCAlignment al = this.getAlignmentAtIndex(index);
        String alName = al == null ? "" : al.getName();
        return alName;
    }

    public String getShortAlignmentAtIndex(int index) {
        PCAlignment al = this.getAlignmentAtIndex(index);
        if (al == null) {
            return "";
        }
        return al.getKeyName();
    }

    public List getUnmodifiableAlignmentList() {
        return Collections.unmodifiableList(this.alignmentList);
    }

    private static class TabInfo {
        String contextPath = "";
        String tabName = "";
        boolean visible = true;

        private TabInfo() {
        }
    }
}

