/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import pcgen.core.BioSet;
import pcgen.core.Campaign;
import pcgen.core.Constants;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Feat;
import pcgen.core.GameMode;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PaperInfo;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.RollInfo;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.core.WeaponProf;
import pcgen.core.WeaponProfDataStore;
import pcgen.core.character.CompanionMod;
import pcgen.core.character.EquipSlot;
import pcgen.core.character.WieldCategory;
import pcgen.core.money.DenominationList;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.persistence.PersistenceManager;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public final class Globals {
    private static PlayerCharacter currentPC;
    private static List pcList;
    public static Race s_EMPTYRACE;
    private static boolean d_sorted;
    public static final String javaVersion;
    private static String pcGenVersion;
    public static final int javaVersionMajor;
    public static final int javaVersionMinor;
    private static final String defaultPath;
    private static final String defaultPcgPath;
    private static final int[] dieSizes;
    private static String language;
    private static String country;
    private static BioSet bioSet;
    private static final List custColumnWidth;
    private static int sourceDisplay;
    private static int selectedPaper;
    private static int selectedUnitSet;
    private static Map campaignMap;
    private static Map domainMap;
    private static SortedMap raceMap;
    private static Map spellMap;
    private static Map eqSlotMap;
    private static Map visionMap;
    private static List armorProfList;
    private static List campaignList;
    private static List classList;
    private static List companionModList;
    private static List deityList;
    private static List domainList;
    private static List featList;
    private static List kitList;
    private static List languageList;
    private static List pcClassTypeList;
    private static List skillList;
    private static List templateList;
    private static DenominationList denominationList;
    private static SortedSet saSet;
    private static final WeaponProfDataStore weaponProfs;
    private static final Random random;
    private static SortedSet pantheonsSet;
    private static SortedSet raceTypesSet;
    private static SortedSet subschoolsSet;
    private static SortedSet weaponTypes;
    private static SortedSet castingTimesSet;
    private static SortedSet componentSet;
    private static SortedSet descriptorSet;
    private static SortedSet durationSet;
    private static SortedSet typeForSpellsSet;
    private static SortedSet rangesSet;
    private static SortedSet saveInfoSet;
    private static SortedSet srSet;
    private static SortedSet statSet;
    private static SortedSet targetSet;
    private static JFrame rootFrame;
    private static JFrame currentFrame;
    private static final StringBuffer section15;
    private static final String spellPoints = "0";
    private static boolean useGUI;
    private static Map bonusSpellMap;
    private static final Comparator pObjectComp;
    private static final Comparator pObjectNameComp;

    public static Collection getAllWeaponProfsOfType(String type) {
        return weaponProfs.getAllOfType(type);
    }

    public static List getAllowedGameModes() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getAllowedModes();
        }
        return new ArrayList();
    }

    public static void setBioSet(BioSet aBioSet) {
        bioSet = aBioSet;
    }

    public static BioSet getBioSet() {
        return bioSet;
    }

    public static Map getBonusSpellMap() {
        return bonusSpellMap;
    }

    public static Campaign getCampaignByFilename(String aName) {
        return Globals.getCampaignByFilename(aName, true);
    }

    public static Campaign getCampaignByFilename(String aName, boolean complainOnError) {
        Campaign campaign = (Campaign)campaignMap.get(aName);
        if (campaign == null && complainOnError) {
            Logging.errorPrint("Could not find campaign by filename: " + aName);
        }
        return campaign;
    }

    public static List getCampaignList() {
        return campaignList;
    }

    public static Campaign getCampaignNamed(String aName) {
        Iterator e = Globals.getCampaignList().iterator();
        while (e.hasNext()) {
            Campaign currCampaign = (Campaign)e.next();
            if (!currCampaign.getName().equalsIgnoreCase(aName)) continue;
            return currCampaign;
        }
        Logging.errorPrint("Could not find campaign: " + aName);
        return null;
    }

    public static SortedSet getCastingTimesSet() {
        return castingTimesSet;
    }

    public static PCClass getClassKeyed(String aKey) {
        return (PCClass)Globals.searchPObjectList(Globals.getClassList(), aKey);
    }

    public static List getClassList() {
        return classList;
    }

    public static PCClass getClassNamed(String aName) {
        return Globals.getClassNamed(aName, Globals.getClassList());
    }

    public static PCClass getClassNamed(String aName, List aList) {
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            PCClass currClass = (PCClass)e.next();
            if (!currClass.getName().equalsIgnoreCase(aName)) continue;
            return currClass;
        }
        return null;
    }

    public static CompanionMod getCompanionMod(String aString) {
        if (aString.length() <= 0) {
            return null;
        }
        StringTokenizer aTok = new StringTokenizer(aString.substring(9), "=", false);
        String classes = aTok.nextToken();
        int level = Integer.parseInt(aTok.nextToken());
        Iterator e = Globals.getCompanionModList().iterator();
        while (e.hasNext()) {
            CompanionMod aComp = (CompanionMod)e.next();
            aTok = new StringTokenizer(classes, ",", false);
            while (aTok.hasMoreTokens()) {
                String cString = aTok.nextToken();
                if (aComp.getLevel(cString) != level) continue;
                return aComp;
            }
        }
        return null;
    }

    public static List getCompanionModList() {
        return companionModList;
    }

    public static SortedSet getComponentSet() {
        return componentSet;
    }

    public static void setCountry(String aString) {
        country = aString;
    }

    public static String getCountry() {
        return country;
    }

    public static String getCurrencyDisplay() {
        return SettingsHandler.getGame().getCurrencyDisplay();
    }

    public static void setCurrentPC(PlayerCharacter aCurrentPC) {
        currentPC = aCurrentPC;
    }

    public static PlayerCharacter getCurrentPC() {
        return currentPC;
    }

    public static void setCustColumnWidth(String fromTab, int col, int value) {
        boolean found = false;
        String cName = fromTab.concat(Integer.toString(col));
        String addMe = cName.concat("|").concat(Integer.toString(value));
        if (Globals.getCustColumnWidth().isEmpty()) {
            Globals.getCustColumnWidth().add(addMe);
        }
        int loopMax = Globals.getCustColumnWidth().size();
        for (int i = 0; i < loopMax; ++i) {
            StringTokenizer tTok = new StringTokenizer((String)Globals.getCustColumnWidth().get(i), "|", false);
            String tabName = tTok.nextToken();
            if (!cName.equals(tabName)) continue;
            Globals.getCustColumnWidth().set(i, addMe);
            found = true;
        }
        if (!found) {
            Globals.getCustColumnWidth().add(addMe);
        }
    }

    public static int getCustColumnWidth(String fromTab, int col) {
        int colSize = 0;
        String cName = fromTab.concat(Integer.toString(col));
        int loopMax = Globals.getCustColumnWidth().size();
        for (int i = 0; i < loopMax; ++i) {
            StringTokenizer tTok = new StringTokenizer((String)Globals.getCustColumnWidth().get(i), "|", false);
            String tabName = tTok.nextToken();
            if (!tabName.equals(cName)) continue;
            colSize = Integer.parseInt(tTok.nextToken());
        }
        return colSize;
    }

    public static String getDefaultPath() {
        return Globals.expandRelativePath(defaultPath);
    }

    public static String getDefaultSpellBook() {
        String book = null;
        if (SettingsHandler.getGame() != null) {
            book = SettingsHandler.getGame().getDefaultSpellBook();
        }
        return book;
    }

    public static Deity getDeityKeyed(String aKey) {
        return (Deity)Globals.searchPObjectList(Globals.getDeityList(), aKey);
    }

    public static List getDeityList() {
        return deityList;
    }

    public static Deity getDeityNamed(String name) {
        return Globals.getDeityNamed(name, Globals.getDeityList());
    }

    public static Deity getDeityNamed(String name, List aList) {
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            Deity currDeity = (Deity)e.next();
            if (!currDeity.getName().equalsIgnoreCase(name)) continue;
            return currDeity;
        }
        return null;
    }

    public static DenominationList getDenominationList() {
        return denominationList;
    }

    public static SortedSet getDescriptorSet() {
        return descriptorSet;
    }

    public static String getDistanceUnit() {
        return Globals.getUnit(Globals.getUnitSet().getDistanceUnit());
    }

    public static Domain getDomainKeyed(String aKey) {
        return (Domain)domainMap.get(aKey);
    }

    public static List getDomainList() {
        return domainList;
    }

    public static Map getDomainMap() {
        return domainMap;
    }

    public static Domain getDomainNamed(String name) {
        return (Domain)domainMap.get(name);
    }

    public static SortedSet getDurationSet() {
        return durationSet;
    }

    public static EquipSlot getEquipSlotByName(String aName) {
        Iterator eI = SystemCollections.getUnmodifiableEquipSlotList().iterator();
        while (eI.hasNext()) {
            EquipSlot es = (EquipSlot)eI.next();
            if (!es.getSlotName().equals(aName)) continue;
            return es;
        }
        return null;
    }

    public static Map getEquipSlotMap() {
        return eqSlotMap;
    }

    public static void setEquipSlotTypeCount(String aString, String aNum) {
        Globals.getEquipSlotMap().put(aString, aNum);
    }

    public static int getEquipSlotTypeCount(String aType) {
        String aNum = (String)Globals.getEquipSlotMap().get(aType);
        if (aNum != null) {
            return Integer.parseInt(aNum);
        }
        return 0;
    }

    public static Feat getFeatKeyed(String aKey) {
        return (Feat)Globals.searchPObjectList(Globals.getFeatList(), aKey);
    }

    public static List getFeatList() {
        return featList;
    }

    public static Feat getFeatListFeat(int featNo) {
        return (Feat)Globals.getFeatList().get(featNo);
    }

    public static Feat getFeatNamed(String name) {
        Feat f;
        int i = name.indexOf(40);
        if (i >= 0 && (f = Globals.getFeatNamed(name.substring(0, i).trim())) != null) {
            return f;
        }
        Iterator e = Globals.getFeatList().iterator();
        while (e.hasNext()) {
            Feat f2 = (Feat)e.next();
            if (!f2.getName().equalsIgnoreCase(name)) continue;
            return f2;
        }
        return null;
    }

    public static boolean isFinessable(Equipment eq, PlayerCharacter aPC) {
        WieldCategory wCat;
        if (eq.isType("Finesseable")) {
            return true;
        }
        if (eq.hasWield() && (wCat = Globals.effectiveWieldCategory(aPC, eq)) != null) {
            return wCat.isFinessable();
        }
        return false;
    }

    public static String getGameModeACAbbrev() {
        return SettingsHandler.getGame().getACAbbrev();
    }

    public static String getGameModeACText() {
        return SettingsHandler.getGame().getACText();
    }

    public static String getGameModeAlignmentText() {
        return SettingsHandler.getGame().getAlignmentText();
    }

    public static String getGameModeAltHPAbbrev() {
        return SettingsHandler.getGame().getAltHPAbbrev();
    }

    public static String getGameModeAltHPText() {
        return SettingsHandler.getGame().getAltHPText();
    }

    public static String getGameModeBaseSpellDC() {
        return SettingsHandler.getGame().getSpellBaseDC();
    }

    public static String getGameModeDamageResistanceText() {
        return SettingsHandler.getGame().getDamageResistanceText();
    }

    public static String getGameModeHPAbbrev() {
        return SettingsHandler.getGame().getHPAbbrev();
    }

    public static String getGameModeHitPointText() {
        return SettingsHandler.getGame().getHPText();
    }

    public static boolean getGameModeShowClassDefense() {
        return SettingsHandler.getGame().getShowClassDefense();
    }

    public static boolean getGameModeShowSpellTab() {
        return SettingsHandler.getGame().getTabShown(9);
    }

    public static String getGameModeSpellRangeFormula(String aRange) {
        return SettingsHandler.getGame().getSpellRangeFormula(aRange);
    }

    public static String getGameModeVariableDisplay2Name() {
        return SettingsHandler.getGame().getVariableDisplay2Name();
    }

    public static String getGameModeVariableDisplay2Text() {
        return SettingsHandler.getGame().getVariableDisplay2Text();
    }

    public static String getGameModeVariableDisplay3Name() {
        return SettingsHandler.getGame().getVariableDisplay3Name();
    }

    public static String getGameModeVariableDisplay3Text() {
        return SettingsHandler.getGame().getVariableDisplay3Text();
    }

    public static String getGameModeVariableDisplayName() {
        return SettingsHandler.getGame().getVariableDisplayName();
    }

    public static String getGameModeVariableDisplayText() {
        return SettingsHandler.getGame().getVariableDisplayText();
    }

    public static List getGlobalDeityList() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getDeityList();
        }
        return new ArrayList();
    }

    public static String getHeightUnit() {
        return Globals.getUnit(Globals.getUnitSet().getHeightUnit());
    }

    public static boolean isInGameMode(String gameMode) {
        return gameMode.length() == 0 || SettingsHandler.getGame() != null && gameMode.equalsIgnoreCase(SettingsHandler.getGame().getName());
    }

    public static List getKitInfo() {
        return kitList;
    }

    public static Kit getKitKeyed(String aKey) {
        Iterator e = kitList.iterator();
        while (e.hasNext()) {
            Kit aKit = (Kit)e.next();
            if (!aKit.getKeyName().equals(aKey)) continue;
            return aKit;
        }
        return null;
    }

    public static void setLanguage(String aString) {
        language = aString;
    }

    public static String getLanguage() {
        return language;
    }

    public static List getLanguageList() {
        return languageList;
    }

    public static Language getLanguageNamed(String name) {
        Iterator i = Globals.getLanguageList().iterator();
        while (i.hasNext()) {
            Language aLang = (Language)i.next();
            if (!aLang.getName().equalsIgnoreCase(name)) continue;
            return aLang;
        }
        return null;
    }

    public static HashMap getLevelInfo() {
        return SettingsHandler.getGame().getLevelInfo();
    }

    public static List getLoadStrings() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getLoadStrings();
        }
        return new ArrayList();
    }

    public static String getLongCurrencyDisplay() {
        return SettingsHandler.getGame().getLongCurrencyDisplay();
    }

    public static List getPCClassTypeList() {
        return pcClassTypeList;
    }

    public static void setPCList(List argPcList) {
        pcList = argPcList;
    }

    public static List getPCList() {
        return pcList;
    }

    public static SortedSet getPantheons() {
        return Globals.getPantheonsSet();
    }

    public static int getPaperCount() {
        return SystemCollections.getUnmodifiablePaperInfo().size();
    }

    public static String getPaperInfo(int infoType) {
        return Globals.getPaperInfo(Globals.getSelectedPaper(), infoType);
    }

    public static String getPaperInfo(int idx, int infoType) {
        if (idx < 0 || idx >= SystemCollections.getUnmodifiablePaperInfo().size()) {
            return null;
        }
        PaperInfo pi = (PaperInfo)SystemCollections.getUnmodifiablePaperInfo().get(idx);
        return pi.getPaperInfo(infoType);
    }

    public static Race getRaceKeyed(String aKey) {
        return (Race)Globals.getRaceMap().get(aKey);
    }

    public static Map getRaceMap() {
        return raceMap;
    }

    public static Race getRaceNamed(String aName) {
        return (Race)Globals.getRaceMap().get(aName);
    }

    public static SortedSet getRaceTypes() {
        return raceTypesSet;
    }

    public static int getRandomInt() {
        return Globals.getRandom().nextInt();
    }

    public static SortedSet getRangesSet() {
        return rangesSet;
    }

    public static void setRootFrame(JFrame frame) {
        rootFrame = frame;
    }

    public static JFrame getRootFrame() {
        return rootFrame;
    }

    public static void setCurrentFrame(JFrame frame) {
        currentFrame = frame;
    }

    public static JFrame getCurrentFrame() {
        if (currentFrame == null) {
            return rootFrame;
        }
        return currentFrame;
    }

    public static SortedSet getSASet() {
        return saSet;
    }

    public static SortedSet getSaveInfoSet() {
        return saveInfoSet;
    }

    public static StringBuffer getSection15() {
        return section15;
    }

    public static int getSelectedPaper() {
        return selectedPaper;
    }

    public static int getSelectedUnitSet() {
        return selectedUnitSet;
    }

    public static Skill getSkillKeyed(String aKey) {
        return (Skill)Globals.searchPObjectList(Globals.getSkillList(), aKey);
    }

    public static List getSkillList() {
        return skillList;
    }

    public static Skill getSkillNamed(String name) {
        Iterator skillIter = Globals.getSkillList().iterator();
        while (skillIter.hasNext()) {
            Skill currSkill = (Skill)skillIter.next();
            if (!currSkill.getName().equalsIgnoreCase(name)) continue;
            return currSkill;
        }
        return null;
    }

    public static void setSorted(boolean sorted) {
        Globals.setD_sorted(sorted);
    }

    public static void setSourceDisplay(int sourceType) {
        sourceDisplay = sourceType;
    }

    public static int getSourceDisplay() {
        return sourceDisplay;
    }

    public static Spell getSpellKeyed(String aKey) {
        Object obj = Globals.getSpellMap().get(aKey);
        if (obj != null) {
            if (obj instanceof Spell) {
                return (Spell)Globals.getSpellMap().get(aKey);
            }
            if (obj instanceof ArrayList) {
                return (Spell)((ArrayList)obj).get(0);
            }
        }
        return null;
    }

    public static Map getSpellMap() {
        return spellMap;
    }

    public static Spell getSpellNamed(String name) {
        return Globals.getSpellKeyed(name);
    }

    public static String getSpellPoints() {
        return spellPoints;
    }

    public static List getSpellsIn(int level, String className, String domainName) {
        ArrayList<Spell> aList = new ArrayList<Spell>();
        StringBuffer aBuf = new StringBuffer();
        String spellType = "";
        if (className.length() > 0) {
            PCClass aClass;
            if (className.indexOf(124) < 0) {
                aClass = Globals.getClassNamed(className);
                aBuf.append("CLASS|").append(className);
            } else {
                aClass = Globals.getClassNamed(className.substring(className.indexOf("|") + 1));
                aBuf.append(className);
            }
            if (aClass != null) {
                spellType = aClass.getSpellType();
            }
        }
        if (domainName.length() > 0) {
            if (aBuf.length() > 0) {
                aBuf.append('|');
            }
            if (domainName.indexOf(124) < 0) {
                aBuf.append("DOMAIN|").append(domainName);
            } else {
                aBuf.append(domainName);
            }
            spellType = "DIVINE";
        }
        Iterator i = spellMap.keySet().iterator();
        while (i.hasNext()) {
            Spell aSpell;
            String aKey = (String)i.next();
            Object obj = spellMap.get(aKey);
            if (obj instanceof ArrayList) {
                Iterator j = ((ArrayList)obj).iterator();
                while (j.hasNext()) {
                    Spell aSpell2 = (Spell)j.next();
                    if (!aSpell2.levelForKeyContains(aBuf.toString(), level, Globals.getCurrentPC()) || aSpell2.getType().indexOf(spellType.toUpperCase()) < 0) continue;
                    aList.add(aSpell2);
                }
                continue;
            }
            if (!(obj instanceof Spell) || !(aSpell = (Spell)obj).levelForKeyContains(aBuf.toString(), level, Globals.getCurrentPC())) continue;
            aList.add(aSpell);
        }
        return aList;
    }

    public static SortedSet getSrSet() {
        return srSet;
    }

    public static SortedSet getStatSet() {
        return statSet;
    }

    public static SortedSet getSubschools() {
        return Globals.getSubschoolsSet();
    }

    public static SortedSet getTargetSet() {
        return targetSet;
    }

    public static PCTemplate getTemplateKeyed(String aKey) {
        return (PCTemplate)Globals.searchPObjectList(Globals.getTemplateList(), aKey);
    }

    public static List getTemplateList() {
        return templateList;
    }

    public static PCTemplate getTemplateNamed(String name) {
        Iterator e = Globals.getTemplateList().iterator();
        while (e.hasNext()) {
            PCTemplate currTemp = (PCTemplate)e.next();
            if (!currTemp.getName().equalsIgnoreCase(name)) continue;
            return currTemp;
        }
        return null;
    }

    public static SortedSet getTypeForSpells() {
        return typeForSpellsSet;
    }

    public static void addTypeForSpells(String arg) {
        typeForSpellsSet.add(arg);
    }

    public static UnitSet getUnitSet() {
        return Globals.getUnitSet(Globals.getSelectedUnitSet());
    }

    public static UnitSet getUnitSet(int idx) {
        if (idx < 0 || idx >= SystemCollections.getUnmodifiableUnitSet().size()) {
            return null;
        }
        return (UnitSet)SystemCollections.getUnmodifiableUnitSet().get(idx);
    }

    public static int getUnitSetCount() {
        return SystemCollections.getUnmodifiableUnitSet().size();
    }

    public static void setUseGUI(boolean aBool) {
        useGUI = aBool;
    }

    public static boolean getUseGUI() {
        return Globals.isUseGUI();
    }

    public static Map getVisionMap() {
        return visionMap;
    }

    public static boolean isWeaponLightForPC(PlayerCharacter pc, Equipment weapon) {
        if (pc == null || weapon == null) {
            return false;
        }
        if (weapon.hasWield()) {
            if (Globals.checkRule("SIZECAT")) {
                WieldCategory wCat = Globals.effectiveWieldCategory(pc, weapon);
                if (wCat != null) {
                    return wCat.getName().equals("Light");
                }
            } else if (Globals.checkRule("SIZEOBJ")) {
                WieldCategory wCat = Globals.effectiveWieldCategory(pc, weapon);
                if (wCat != null) {
                    return pc.sizeInt() > wCat.getObjectSizeInt(weapon);
                }
                return pc.sizeInt() > weapon.sizeInt();
            }
        } else {
            return pc.sizeInt() > weapon.sizeInt();
        }
        return false;
    }

    public static boolean isWeaponOneHanded(PlayerCharacter pc, Equipment weapon, WeaponProf wp) {
        return Globals.isWeaponOneHanded(pc, weapon, wp, false);
    }

    public static boolean isWeaponOneHanded(PlayerCharacter pc, Equipment weapon, WeaponProf wp, boolean baseOnly) {
        if (pc == null || weapon == null || wp == null) {
            return false;
        }
        if (Globals.handsRequired(pc, weapon, wp) == 1) {
            if (weapon.hasWield()) {
                WieldCategory wCat;
                if (Globals.checkRule("SIZECAT")) {
                    return true;
                }
                if (Globals.checkRule("SIZEOBJ") && (wCat = Globals.effectiveWieldCategory(pc, weapon)) != null) {
                    return pc.sizeInt() >= wCat.getObjectSizeInt(weapon);
                }
            } else {
                int pcSize = pc.sizeInt();
                if (!baseOnly) {
                    pcSize = (int)((double)pcSize + pc.getTotalBonusTo("WEAPONPROF=" + wp.getName(), "PCSIZE"));
                }
                return pcSize >= weapon.sizeInt();
            }
        }
        return false;
    }

    public static boolean isWeaponOutsizedForPC(PlayerCharacter pc, Equipment weapon) {
        if (pc == null || weapon == null) {
            return true;
        }
        int overSize = pc.sizeInt() + 1;
        int underSize = pc.sizeInt() - 1;
        if (weapon.hasWield()) {
            if (Globals.checkRule("SIZECAT")) {
                WieldCategory wCat = Globals.effectiveWieldCategory(pc, weapon);
                if (wCat != null) {
                    return wCat.getHands() > 2;
                }
            } else if (Globals.checkRule("SIZEOBJ")) {
                WieldCategory wCat = Globals.effectiveWieldCategory(pc, weapon);
                if (wCat != null) {
                    if (wCat.getObjectSizeInt(weapon) > overSize) {
                        return true;
                    }
                    if (wCat.getObjectSizeInt(weapon) < underSize) {
                        return true;
                    }
                } else {
                    if (weapon.sizeInt() > overSize) {
                        return true;
                    }
                    if (weapon.sizeInt() < underSize) {
                        return true;
                    }
                }
            }
        } else {
            if (weapon.sizeInt() > overSize) {
                return true;
            }
            if (weapon.sizeInt() < underSize - 1) {
                return true;
            }
        }
        return false;
    }

    public static List getWeaponProfArrayCopy() {
        return weaponProfs.getArrayCopy();
    }

    public static WeaponProf getWeaponProfKeyed(String aKey) {
        return weaponProfs.getKeyed(aKey);
    }

    public static WeaponProf getWeaponProfNamed(String name) {
        return weaponProfs.getNamed(name);
    }

    public static String getWeaponProfNames(String delim, boolean addArrayMarkers) {
        return weaponProfs.getNames(delim, addArrayMarkers);
    }

    public static int getWeaponProfSize() {
        return weaponProfs.size();
    }

    public static boolean isWeaponTooLargeForPC(PlayerCharacter pc, Equipment weapon) {
        if (pc == null || weapon == null) {
            return false;
        }
        if (weapon.hasWield()) {
            if (Globals.checkRule("SIZECAT")) {
                WieldCategory wCat = Globals.effectiveWieldCategory(pc, weapon);
                if (wCat != null) {
                    return wCat.getHands() > 2;
                }
            } else if (Globals.checkRule("SIZEOBJ")) {
                WieldCategory wCat = Globals.effectiveWieldCategory(pc, weapon);
                int overSize = pc.sizeInt() + 1;
                if (wCat != null) {
                    return wCat.getObjectSizeInt(weapon) > overSize;
                }
                return weapon.sizeInt() > overSize;
            }
        } else {
            return weapon.sizeInt() > pc.sizeInt() + 1;
        }
        return false;
    }

    public static boolean isWeaponTwoHanded(PlayerCharacter pc, Equipment weapon, WeaponProf wp) {
        return Globals.isWeaponTwoHanded(pc, weapon, wp, false);
    }

    public static Iterator getWeaponTypesIterator() {
        return weaponTypes.iterator();
    }

    public static String getWeightUnit() {
        return Globals.getUnit(Globals.getUnitSet().getWeightUnit());
    }

    public static void addCampaign(Campaign campaign) {
        campaignMap.put(campaign.getSourceFile(), campaign);
        campaignList.add(campaign);
    }

    public static void addDomain(Domain nextDomain) {
        domainMap.put(nextDomain.getKeyName(), nextDomain);
        domainList.add(nextDomain);
    }

    public static void addDurationSet(String aString) {
        durationSet.add(aString);
    }

    public static void addSpellCastingTimesSet(String aString) {
        castingTimesSet.add(aString);
    }

    public static void addSpellComponentSet(String aString) {
        componentSet.add(aString);
    }

    public static void addSpellDescriptorSet(String aString) {
        descriptorSet.add(aString);
    }

    public static void addSpellRangesSet(String aString) {
        rangesSet.add(aString);
    }

    public static void addSpellSaveInfoSet(String aString) {
        saveInfoSet.add(aString);
    }

    public static void addSpellSrSet(String aString) {
        srSet.add(aString);
    }

    public static void addSpellStatSet(String aString) {
        statSet.add(aString);
    }

    public static void addSpellTargetSet(String aString) {
        targetSet.add(aString);
    }

    public static void addToSASet(SpecialAbility sa) {
        saSet.add(sa);
    }

    public static void addUniqueWeaponProfsAsStringTo(List dest) {
        weaponProfs.addUniqueAsStringTo(dest);
    }

    public static void addWeaponProf(WeaponProf wp) {
        weaponProfs.add(wp);
    }

    public static String adjustDamage(String aDamage, int baseSize, int finalSize) {
        String downString;
        String result = aDamage;
        int multiplier = 1;
        if (baseSize < finalSize) {
            String upString = Globals.getDamageUpKey(aDamage);
            if (upString != null) {
                StringTokenizer aTok = new StringTokenizer(upString, "|");
                multiplier = Integer.parseInt(aTok.nextToken());
                upString = aTok.nextToken();
                aTok = new StringTokenizer(upString, ",");
                while (baseSize < finalSize && aTok.hasMoreTokens()) {
                    result = aTok.nextToken();
                    ++baseSize;
                }
            }
        } else if (baseSize > finalSize && (downString = Globals.getDamageDownKey(aDamage)) != null) {
            StringTokenizer aTok = new StringTokenizer(downString, "|");
            multiplier = Integer.parseInt(aTok.nextToken());
            downString = aTok.nextToken();
            aTok = new StringTokenizer(downString, ",");
            while (baseSize > finalSize && aTok.hasMoreTokens()) {
                result = aTok.nextToken();
                --baseSize;
            }
        }
        if (multiplier > 1) {
            RollInfo aRollInfo = new RollInfo(result);
            aRollInfo.times *= multiplier;
            result = aRollInfo.toString();
        }
        return result;
    }

    public static boolean canResizeHaveEffect(PlayerCharacter aPC, Equipment aEq, List typeList) {
        if (typeList == null) {
            typeList = aEq.typeList();
        }
        for (int iSize = 0; iSize < SystemCollections.getSizeAdjustmentListSize(); ++iSize) {
            SizeAdjustment sadj = SystemCollections.getSizeAdjustmentAtIndex(iSize);
            if (!(!CoreUtility.doublesEqual(sadj.getBonusTo(aPC, "ITEMCOST", typeList, 1.0), 1.0) || aEq.isArmor() || aEq.isShield() && !CoreUtility.doublesEqual(sadj.getBonusTo(aPC, "ACVALUE", typeList, 1.0), 1.0) || !CoreUtility.doublesEqual(aEq.getWeightAsDouble(aPC), 0.0) && !CoreUtility.doublesEqual(sadj.getBonusTo(aPC, "ITEMWEIGHT", typeList, 1.0), 1.0)) && (!aEq.isContainer() || CoreUtility.doublesEqual(sadj.getBonusTo(aPC, "ITEMCAPACITY", typeList, 1.0), 1.0))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRule(String aKey) {
        boolean aBool = false;
        GameMode gameMode = SettingsHandler.getGame();
        if (gameMode.hasRuleCheck(aKey)) {
            aBool = gameMode.getRuleCheck(aKey);
            if (SettingsHandler.hasRuleCheck(aKey)) {
                aBool = SettingsHandler.getRuleCheck(aKey);
            }
        }
        return aBool;
    }

    public static String chooseFromList(String title, List choiceList, List selectedList, int pool) {
        return Globals.chooseFromList(title, choiceList, selectedList, pool, false);
    }

    public static String chooseFromList(String title, List choiceList, List selectedList, int pool, boolean forceChoice) {
        List justSelectedList = Globals.getChoiceFromList(title, choiceList, selectedList, pool, forceChoice);
        if (justSelectedList.size() != 0) {
            return (String)justSelectedList.get(0);
        }
        return null;
    }

    public static void clearCampaignsForRefresh() {
        Globals.emptyLists();
        campaignMap.clear();
        campaignList.clear();
    }

    public static void clearSASet() {
        saSet.clear();
    }

    public static double convertDistanceToUnitSet(double distanceInFeet) {
        double distance = distanceInFeet * Globals.getUnitSet().getDistanceFactor();
        return distance;
    }

    public static int convertHeightFromUnitSet(double height) {
        double heightInInches = height / Globals.getUnitSet().getHeightFactor();
        return (int)heightInInches;
    }

    public static double convertHeightToUnitSet(int heightInInches) {
        double height = (double)heightInInches * Globals.getUnitSet().getHeightFactor();
        return height;
    }

    public static int convertWeightFromUnitSet(double weight) {
        double weightInPounds = weight / Globals.getUnitSet().getWeightFactor();
        return (int)weightInPounds;
    }

    public static double convertWeightToUnitSet(double weightInPounds) {
        double weight = weightInPounds * Globals.getUnitSet().getWeightFactor();
        return weight;
    }

    public static int convertWeightToUnitSet(int weightInPounds) {
        double weight = (double)weightInPounds * Globals.getUnitSet().getWeightFactor();
        return (int)weight;
    }

    public static String displayDistanceInUnitSet(double distance) {
        String output = new DecimalFormat(Globals.getUnitSet().getDistanceDisplayPattern()).format(distance);
        return output;
    }

    public static String displayHeightInUnitSet(double height) {
        String output = new DecimalFormat(Globals.getUnitSet().getHeightDisplayPattern()).format(height);
        return output;
    }

    public static boolean displayListsHappy() {
        Logging.debugPrint("Number of objects loaded. The following should all be greater than 0:");
        Logging.debugPrint("Races=" + Globals.getRaceMap().size());
        Logging.debugPrint("Classes=" + Globals.getClassList().size());
        Logging.debugPrint("Skills=" + Globals.getSkillList().size());
        Logging.debugPrint("Feats=" + Globals.getFeatList().size());
        Logging.debugPrint("Equipment=" + EquipmentList.getEquipmentList().size());
        Logging.debugPrint("WeaponProfs=" + Globals.getWeaponProfSize());
        Logging.debugPrint("Kits=" + kitList.size());
        Logging.debugPrint("Templates=" + templateList.size());
        return Globals.getRaceMap().size() != 0 && Globals.getClassList().size() != 0 && Globals.getSkillList().size() != 0 && Globals.getFeatList().size() != 0 && EquipmentList.getEquipmentList().size() != 0 && Globals.getWeaponProfSize() != 0;
    }

    public static String displayWeightInUnitSet(double weight) {
        String output = new DecimalFormat(Globals.getUnitSet().getWeightDisplayPattern()).format(weight);
        return output;
    }

    public static WieldCategory effectiveWieldCategory(PlayerCharacter aPC, Equipment eq) {
        int sizeDiff;
        WieldCategory wCat = SettingsHandler.getGame().getWieldCategory(eq.getWield());
        if (wCat == null) {
            return null;
        }
        String ewName = wCat.getWieldCategory(aPC, eq);
        WieldCategory bonusCat = wCat = SettingsHandler.getGame().getWieldCategory(ewName);
        String valString = SettingsHandler.getGame().getWCStepsFormula();
        String eqVar = "EQ:" + eq.profName(0, aPC);
        int aBump = sizeDiff = eq.getVariableValue(valString, eqVar, "", aPC).intValue();
        aBump += (int)aPC.getTotalBonusTo("WEAPONPROF=" + eq.profName(0, aPC), "WIELDCATEGORY");
        aBump += (int)eq.bonusTo(aPC, "WEAPON", "WIELDCATEGORY", true);
        if (aPC.sizeInt() != eq.sizeInt()) {
            aBump += (int)aPC.getTotalBonusTo("WIELDCATEGORY", ewName);
            aBump += (int)aPC.getTotalBonusTo("WIELDCATEGORY", "ALL");
        }
        if (bonusCat != null) {
            ewName = bonusCat.getWieldCategoryStep(aBump);
            bonusCat = SettingsHandler.getGame().getWieldCategory(ewName);
        }
        if (bonusCat != null && bonusCat.getHands() <= wCat.getHands()) {
            return bonusCat;
        }
        return wCat;
    }

    public static void emptyLists() {
        armorProfList = new ArrayList();
        classList = new ArrayList();
        companionModList = new ArrayList();
        deityList = new ArrayList();
        domainList = new ArrayList();
        EquipmentList.clearEquipmentList();
        featList = new ArrayList();
        kitList = new ArrayList();
        languageList = new ArrayList();
        EquipmentList.clearModifierList();
        pcClassTypeList = new ArrayList();
        skillList = new ArrayList();
        templateList = new ArrayList();
        saSet = new TreeSet();
        Globals.clearWeaponProfs();
        bonusSpellMap = new HashMap();
        domainMap = new HashMap();
        raceMap = new TreeMap();
        spellMap = new HashMap();
        visionMap = new HashMap();
        Globals.clearSpellSets();
        pantheonsSet = new TreeSet();
        raceTypesSet = new TreeSet();
        subschoolsSet = new TreeSet();
        weaponTypes = new TreeSet();
        Globals.createEmptyRace();
        Equipment.clearEquipmentTypes();
        PersistenceManager.getInstance().emptyLists();
    }

    public static void executePostExportCommand(String fileName) {
        String aString = SettingsHandler.getPostExportCommand();
        int x = 100;
        while (aString.indexOf("%") >= 0) {
            String beforeString = aString.substring(0, aString.indexOf("%"));
            String afterString = aString.substring(aString.indexOf("%") + 1);
            aString = beforeString + fileName + afterString;
            if (--x > 0) continue;
            break;
        }
        if (!"".equals(aString)) {
            try {
                Runtime.getRuntime().exec(aString);
            }
            catch (IOException ex) {
                Logging.errorPrint("Could not execute " + aString + " after exporting " + fileName, ex);
            }
        }
    }

    public static int handsRequired(PlayerCharacter pc, Equipment weapon, WeaponProf wp) {
        WieldCategory wCat;
        if (wp == null) {
            return 1;
        }
        int iHands = wp.getHands();
        if (iHands == -1) {
            iHands = pc.sizeInt() > weapon.sizeInt() ? 1 : 2;
        }
        if (Globals.checkRule("SIZECAT") && weapon.hasWield() && (wCat = Globals.effectiveWieldCategory(pc, weapon)) != null) {
            iHands = wCat.getHands();
            if (wp.getHands() < wCat.getHands()) {
                iHands = wp.getHands();
            }
        }
        return iHands;
    }

    public static boolean hasWeaponProfVariableNamed(Collection collectionOfNames, String variableString) {
        return weaponProfs.hasVariableNamed(collectionOfNames, variableString);
    }

    public static void loadAttributeNames() {
        Globals.createEmptyRace();
    }

    public static int loadTypeForLoadScore(int loadScoreValue, Float weight, PlayerCharacter aPC) {
        double dbl;
        if (loadScoreValue < 0) {
            loadScoreValue = 0;
        }
        if ((dbl = weight.doubleValue() / Globals.maxLoadForLoadScore(loadScoreValue, aPC).doubleValue()) <= 0.3333333333333333) {
            return 0;
        }
        if (dbl <= 0.6666666666666666) {
            return 1;
        }
        if (dbl <= 1.0) {
            return 2;
        }
        return 3;
    }

    public static Float maxLoadForLoadScore(int loadScoreValue, PlayerCharacter aPC) {
        double x = 0.0;
        double dbl = 0.0;
        int y = loadScoreValue;
        int loadStringSize = Globals.getLoadStrings().size();
        if (loadStringSize <= 0) {
            return new Float(spellPoints);
        }
        if (loadScoreValue >= loadStringSize - 2) {
            String bString = (String)Globals.getLoadStrings().get(loadStringSize - 1);
            dbl = Double.parseDouble(bString.substring(bString.lastIndexOf(9) + 1));
            for (y = loadScoreValue; y >= loadStringSize - 2; y -= 10) {
                x += 1.0;
            }
        }
        String aString = (String)Globals.getLoadStrings().get(y + 1);
        int beginIndex = aString.lastIndexOf(9) + 1;
        Float aFloat = new Float(aString.substring(beginIndex));
        if (x > 0.0) {
            aFloat = new Float(aFloat.doubleValue() * Math.pow(dbl, x));
        }
        return new Float(aFloat.doubleValue() * Globals.getLoadMultForSize(aPC));
    }

    public static int minLevelForSpellLevel(PCClass castingClass, int spellLevel, boolean allowBonus) {
        int j;
        int maxCastable;
        StringTokenizer bTok;
        int minLevel = 9999;
        Map castMap = castingClass.getCastMap();
        int loopMax = castMap.keySet().size();
        for (int i = 0; i < loopMax; ++i) {
            String aLevel = Integer.toString(i);
            String castPerDay = (String)castMap.get(aLevel);
            if (castPerDay == null || castPerDay.length() <= 0) continue;
            bTok = new StringTokenizer(castPerDay, ",");
            maxCastable = -1;
            if (allowBonus) {
                maxCastable = bTok.countTokens() - 1;
            } else {
                j = 0;
                while (bTok.hasMoreTokens()) {
                    try {
                        if (Integer.parseInt(bTok.nextToken()) != 0) {
                            maxCastable = j;
                        }
                    }
                    catch (NumberFormatException ignore) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            if (maxCastable < spellLevel) continue;
            minLevel = i;
            break;
        }
        if (minLevel < 9999) {
            return minLevel;
        }
        List knownList = castingClass.getKnownList();
        loopMax = knownList.size();
        for (int i = 0; i < loopMax; ++i) {
            String knownSpells = knownList.get(i).toString();
            if (spellPoints.equals(knownSpells)) continue;
            bTok = new StringTokenizer(knownSpells, ",");
            maxCastable = -1;
            if (allowBonus) {
                maxCastable = bTok.countTokens() - 1;
            } else {
                j = 0;
                while (bTok.hasMoreTokens()) {
                    try {
                        if (Integer.parseInt(bTok.nextToken()) != 0) {
                            maxCastable = j;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            if (maxCastable < spellLevel) continue;
            minLevel = i + 1;
            break;
        }
        return minLevel;
    }

    public static void putVisionMap(String aKey) {
        visionMap.put(aKey, spellPoints);
    }

    public static void removeWeaponProfNamed(String name) {
        weaponProfs.removeNamed(name);
    }

    public static int rollHP(int min, int max, String name, int level) {
        int roll;
        block9: {
            InputInterface ii;
            Object selectedValue;
            switch (SettingsHandler.getHPRollMethod()) {
                case 4: {
                    roll = -1;
                    break;
                }
                case 2: {
                    roll = max - min;
                    if ((level & 1) == 0 && (roll & 1) != 0) {
                        ++roll;
                    }
                    roll = min + roll / 2;
                    break;
                }
                case 1: {
                    roll = max;
                    break;
                }
                case 3: {
                    roll = min - 1 + (int)((double)(SettingsHandler.getHPPct() * (max - min + 1)) / 100.0);
                    break;
                }
                default: {
                    roll = Math.abs(Globals.getRandomInt(max - min + 1)) + min;
                }
            }
            if (!SettingsHandler.getShowHPDialogAtLevelUp()) break block9;
            Object[] rollChoices = new Object[max - min + 2];
            rollChoices[0] = "<none selected>";
            for (int i = min; i <= max; ++i) {
                rollChoices[i - min + 1] = new Integer(i);
            }
            while ((selectedValue = (ii = InputFactory.getInputInstance()).showInputDialog(Globals.getRootFrame(), "Randomly generate a number between " + min + " and " + max + "." + Constants.s_LINE_SEP + "Select it from the box below.", Globals.getGameModeHitPointText() + " for " + CoreUtility.ordinal(level) + " level of " + name, MessageType.INFORMATION, rollChoices, new Integer(roll))) == null || !(selectedValue instanceof Integer)) {
            }
            roll = (Integer)selectedValue;
        }
        return roll;
    }

    public static boolean selectPaper(String paperName) {
        for (int i = 0; i < SystemCollections.getUnmodifiablePaperInfo().size(); ++i) {
            PaperInfo pi = (PaperInfo)SystemCollections.getUnmodifiablePaperInfo().get(i);
            if (!pi.getName().equals(paperName)) continue;
            Globals.setSelectedPaper(i);
            return true;
        }
        Globals.setSelectedPaper(-1);
        return false;
    }

    public static boolean selectUnitSet(String unitName) {
        for (int i = 0; i < SystemCollections.getUnmodifiableUnitSet().size(); ++i) {
            UnitSet ui = (UnitSet)SystemCollections.getUnmodifiableUnitSet().get(i);
            if (!ui.getName().equals(unitName)) continue;
            Globals.setSelectedUnitSet(i);
            return true;
        }
        Globals.setSelectedUnitSet(-1);
        return false;
    }

    public static int sizeInt(String aSize) {
        return Globals.sizeInt(aSize, 0);
    }

    public static int sizeInt(String aSize, int defaultValue) {
        for (int iSize = 0; iSize <= SystemCollections.getSizeAdjustmentListSize() - 1; ++iSize) {
            if (!aSize.startsWith(SystemCollections.getSizeAdjustmentAtIndex(iSize).getAbbreviation())) continue;
            return iSize;
        }
        return defaultValue;
    }

    public static void sortCampaigns() {
        Globals.sortPObjectList(Globals.getClassList());
        Globals.sortPObjectList(Globals.getSkillList());
        Globals.sortPObjectList(Globals.getFeatList());
        Globals.sortPObjectList(Globals.getDeityList());
        Globals.sortPObjectList(Globals.getDomainList());
        Globals.sortPObjectList(EquipmentList.getEquipmentList());
        Globals.sortPObjectList(Globals.getArmorProfList());
        Globals.sortPObjectList(Globals.getTemplateList());
        Globals.sortPObjectList(EquipmentList.getModifierList());
        Globals.sortPObjectList(Globals.getLanguageList());
        Globals.setD_sorted(true);
    }

    public static void sortChooserLists(List availableList, List selectedList) {
        boolean stringsInList = availableList.size() > 0 ? availableList.get(0) instanceof String : (selectedList.size() > 0 ? selectedList.get(0) instanceof String : false);
        if (stringsInList) {
            Collections.sort(availableList);
            Collections.sort(selectedList);
        } else {
            Globals.sortPObjectList(availableList);
            Globals.sortPObjectList(selectedList);
        }
    }

    public static List sortPObjectList(List aList) {
        Collections.sort(aList, pObjectComp);
        return aList;
    }

    public static List sortPObjectListByName(List aList) {
        Collections.sort(aList, pObjectNameComp);
        return aList;
    }

    protected static PObject searchPObjectList(List aList, String keyName) {
        if (keyName == null || keyName.length() <= 0) {
            return null;
        }
        if (Globals.isD_sorted()) {
            return Globals.binarySearchPObject(aList, keyName);
        }
        Object[] pobjArray = aList.toArray();
        int upper = pobjArray.length;
        for (int i = upper - 1; i >= 0; --i) {
            PObject obj = (PObject)pobjArray[i];
            if (!keyName.equals(obj.getKeyName())) continue;
            return obj;
        }
        return null;
    }

    static int getBonusFeatsForLevel(int level) {
        int num = 0;
        Iterator i = SettingsHandler.getGame().getBonusFeatLevels().iterator();
        while (i.hasNext()) {
            num = Globals.bonusParsing(i, level, num);
        }
        return num;
    }

    static int getBonusStatsForLevel(int level) {
        int num = 0;
        Iterator i = SettingsHandler.getGame().getBonusStatLevels().iterator();
        while (i.hasNext()) {
            num = Globals.bonusParsing(i, level, num);
        }
        return num;
    }

    static List getChoiceFromList(String title, List choiceList, List selectedList, int pool) {
        return Globals.getChoiceFromList(title, choiceList, selectedList, pool, false);
    }

    static List getChoiceFromList(String title, List choiceList, List selectedList, int pool, boolean forceChoice) {
        ChooserInterface c = ChooserFactory.getChooserInstance();
        c.setPool(pool);
        c.setPoolFlag(forceChoice);
        c.setAllowsDups(false);
        c.setTitle(title);
        c.setAvailableList(choiceList);
        if (selectedList != null) {
            c.setSelectedList(selectedList);
        }
        c.setVisible(true);
        return c.getSelectedList();
    }

    static List getCustColumnWidth() {
        return custColumnWidth;
    }

    static String getDefaultPcgPath() {
        return Globals.expandRelativePath(defaultPcgPath);
    }

    static int[] getDieSizes() {
        return dieSizes;
    }

    static String getFeatListFeatString(int featNo) {
        return Globals.getFeatList().get(featNo).toString();
    }

    static String getFilterPath() {
        String aPath = System.getProperty("pcgen.filter");
        if (aPath == null) {
            aPath = Globals.getFilePath("filter.ini");
        }
        return Globals.expandRelativePath(aPath);
    }

    static Kit getKitNamed(String aName) {
        Iterator e = kitList.iterator();
        while (e.hasNext()) {
            Kit aKit = (Kit)e.next();
            if (!aKit.getName().equals(aName)) continue;
            return aKit;
        }
        return null;
    }

    static List getLanguagesFromListOfType(List langList, String aType) {
        ArrayList<Language> retSet = new ArrayList<Language>();
        Iterator i = langList.iterator();
        while (i.hasNext()) {
            Language aLang = (Language)i.next();
            if (aLang == null || !aLang.isType(aType) && (aType.length() <= 0 || aType.charAt(0) != '!' || aLang.isType(aType))) continue;
            retSet.add(aLang);
        }
        return retSet;
    }

    static String getOptionsPath() {
        String aPath = System.getProperty("pcgen.options");
        if (aPath == null) {
            aPath = Globals.getFilePath("options.ini");
        }
        return Globals.expandRelativePath(aPath);
    }

    static int getRandomInt(int high) {
        return Globals.getRandom().nextInt(high);
    }

    static int getSkillMultiplierForLevel(int level) {
        List sml = SettingsHandler.getGame().getSkillMultiplierLevels();
        if (level > sml.size() || level <= 0) {
            return 1;
        }
        return Integer.parseInt(sml.get(level - 1).toString());
    }

    static List getWeaponProfs(String type, PlayerCharacter aPC) {
        WeaponProf tempProf;
        StringTokenizer aTok;
        String aString;
        ArrayList<WeaponProf> aList = new ArrayList<WeaponProf>();
        ArrayList<WeaponProf> bList = new ArrayList<WeaponProf>();
        Iterator e = aPC.getRace().getWeaponProfs().iterator();
        while (e.hasNext()) {
            aString = (String)e.next();
            aTok = new StringTokenizer(aString, "|");
            String typeString = aTok.nextToken();
            String wpString = aTok.nextToken();
            tempProf = Globals.getWeaponProfNamed(wpString);
            if (tempProf == null) continue;
            if (typeString.equalsIgnoreCase(type)) {
                aList.add(tempProf);
                continue;
            }
            bList.add(tempProf);
        }
        e = aPC.getChangeProfList().iterator();
        while (e.hasNext()) {
            aString = (String)e.next();
            aTok = new StringTokenizer(aString, "|");
            String eqName = aTok.nextToken();
            String wpType = aTok.nextToken();
            tempProf = Globals.getWeaponProfNamed(eqName);
            if (tempProf == null) continue;
            if (wpType.equalsIgnoreCase(type)) {
                aList.add(tempProf);
                continue;
            }
            bList.add(tempProf);
        }
        Collection weaponProfsOfType = Globals.getAllWeaponProfsOfType(type);
        if (weaponProfsOfType == null) {
            return aList;
        }
        Iterator e2 = weaponProfsOfType.iterator();
        while (e2.hasNext()) {
            WeaponProf tempProf2 = (WeaponProf)e2.next();
            if (bList.contains(tempProf2)) continue;
            aList.add(tempProf2);
        }
        return aList;
    }

    static void addWeaponType(String weaponType) {
        weaponTypes.add(weaponType);
    }

    static String adjustDamage(String aDamage, String sBaseSize, String sNewSize) {
        if (aDamage.length() == 0) {
            return aDamage;
        }
        return Globals.adjustDamage(aDamage, Globals.sizeInt(sBaseSize), Globals.sizeInt(sNewSize));
    }

    static PObject binarySearchPObject(List aList, String keyName) {
        if (keyName == null || keyName.length() <= 0) {
            return null;
        }
        Object[] pobjArray = aList.toArray();
        int lower = 0;
        int upper = pobjArray.length;
        while (lower < upper) {
            int mid = (lower + upper) / 2;
            PObject obj = (PObject)pobjArray[mid];
            int cmp = keyName.compareToIgnoreCase(obj.getKeyName());
            if (cmp == 0) {
                return obj;
            }
            if (cmp > 0) {
                lower = mid + 1;
                continue;
            }
            upper = mid;
        }
        return null;
    }

    static double calcEncumberedMove(int load, double moveInt, boolean checkLoad) {
        return Globals.calcEncumberedMove(load, moveInt, checkLoad, null);
    }

    static double calcEncumberedMove(int load, double unencumberedMove, boolean checkLoad, PlayerCharacter aPC) {
        double encumberedMove;
        block8: {
            block7: {
                if (!checkLoad) break block7;
                switch (load) {
                    case 0: {
                        encumberedMove = unencumberedMove;
                        break;
                    }
                    case 1: 
                    case 2: {
                        encumberedMove = unencumberedMove == 5.0 ? 5.0 : (unencumberedMove == 10.0 ? 5.0 : Math.floor(unencumberedMove / 15.0) * 10.0 + (double)((int)unencumberedMove % 15));
                        if (aPC != null && aPC.ignoreEncumberedLoadMove(load)) {
                            encumberedMove = unencumberedMove;
                            break;
                        }
                        break block8;
                    }
                    case 3: {
                        encumberedMove = 0.0;
                        if (aPC != null && aPC.ignoreEncumberedLoadMove(3)) {
                            encumberedMove = unencumberedMove;
                            break;
                        }
                        break block8;
                    }
                    default: {
                        Logging.errorPrint("The load " + load + " is not possible.");
                        encumberedMove = 0.0;
                        break;
                    }
                }
                break block8;
            }
            encumberedMove = unencumberedMove;
        }
        return encumberedMove;
    }

    static String chooseFromList(String title, String choiceList, List selectedList, int pool) {
        StringTokenizer tokens = new StringTokenizer(choiceList, "|");
        if (tokens.countTokens() != 0) {
            ArrayList<String> choices = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                choices.add(tokens.nextToken());
            }
            return Globals.chooseFromList(title, choices, selectedList, pool);
        }
        return null;
    }

    static SortedSet extractLanguageListNames(SortedSet langNames) {
        TreeSet<String> newSet = new TreeSet<String>();
        Iterator bI = langNames.iterator();
        while (bI.hasNext()) {
            String aLang = (String)bI.next();
            if ("ALL".equals(aLang)) {
                newSet.addAll(Globals.getLanguageSetNames());
                continue;
            }
            if (aLang.startsWith("TYPE=") || aLang.startsWith("TYPE.")) {
                newSet.addAll(Globals.getLanguageNamesFromListOfType(Globals.getLanguageList(), aLang.substring(5)));
                continue;
            }
            newSet.add(aLang);
        }
        return newSet;
    }

    static void initCustColumnWidth(List l) {
        Globals.getCustColumnWidth().clear();
        Globals.getCustColumnWidth().addAll(l);
    }

    static boolean weaponTypesContains(String weaponType) {
        return weaponTypes.contains(weaponType.toUpperCase());
    }

    private static List getArmorProfList() {
        return armorProfList;
    }

    private static void setD_sorted(boolean argD_sorted) {
        d_sorted = argD_sorted;
    }

    private static boolean isD_sorted() {
        return d_sorted;
    }

    private static String getDamageDownKey(String aDamage) {
        if (SettingsHandler.getGame().getDamageDownMap().containsKey(aDamage)) {
            return "1|" + (String)SettingsHandler.getGame().getDamageDownMap().get(aDamage);
        }
        RollInfo aRollInfo = new RollInfo(aDamage);
        String baseDice = "1d" + Integer.toString(aRollInfo.sides);
        if (SettingsHandler.getGame().getDamageDownMap().containsKey(baseDice)) {
            return Integer.toString(aRollInfo.times) + "|" + (String)SettingsHandler.getGame().getDamageDownMap().get(baseDice);
        }
        return null;
    }

    private static String getDamageUpKey(String aDamage) {
        if (SettingsHandler.getGame().getDamageUpMap().containsKey(aDamage)) {
            return "1|" + (String)SettingsHandler.getGame().getDamageUpMap().get(aDamage);
        }
        RollInfo aRollInfo = new RollInfo(aDamage);
        String baseDice = "1d" + Integer.toString(aRollInfo.sides);
        if (SettingsHandler.getGame().getDamageUpMap().containsKey(baseDice)) {
            return Integer.toString(aRollInfo.times) + "|" + (String)SettingsHandler.getGame().getDamageUpMap().get(baseDice);
        }
        return null;
    }

    private static String getFilePath(String aString) {
        String fType = SettingsHandler.getFilePaths();
        if (fType == null || fType.equals("pcgen")) {
            return System.getProperty("user.dir") + File.separator + aString;
        }
        if (fType.equals("user")) {
            return System.getProperty("user.home") + File.separator + ".pcgen" + File.separator + aString;
        }
        return fType + File.separator + aString;
    }

    private static List getLanguageNamesFromListOfType(List langList, String aType) {
        ArrayList<String> retSet = new ArrayList<String>();
        Iterator i = langList.iterator();
        while (i.hasNext()) {
            Language aLang = (Language)i.next();
            if (aLang == null || (aType.length() <= 0 || aType.charAt(0) != '!' || aLang.isType(aType)) && !aLang.isType(aType)) continue;
            retSet.add(aLang.getName());
        }
        return retSet;
    }

    private static List getLanguageSetNames() {
        ArrayList<String> aList = new ArrayList<String>();
        Iterator i = Globals.getLanguageList().iterator();
        while (i.hasNext()) {
            Language aLang = (Language)i.next();
            aList.add(aLang.getName());
        }
        return aList;
    }

    private static double getLoadMultForSize(PlayerCharacter aPC) {
        double mult = 1.0;
        SizeAdjustment sadj = null;
        if (Globals.getLoadStrings().size() != 0) {
            String aString = aPC.getSize();
            String bString = (String)Globals.getLoadStrings().get(0);
            StringTokenizer aTok = new StringTokenizer(bString, ",", false);
            while (aTok.hasMoreTokens()) {
                String cString = aTok.nextToken();
                if (aString.charAt(0) != cString.charAt(0)) continue;
                sadj = SystemCollections.getSizeAdjustmentAtIndex(Globals.sizeInt(aString));
                mult = Double.parseDouble(cString.substring(cString.lastIndexOf(124) + 1));
                break;
            }
        }
        if (sadj == null) {
            sadj = SystemCollections.getDefaultSizeAdjustment();
        }
        return mult += sadj.bonusTo("LOADMULT", "TYPE=SIZE", aPC, aPC);
    }

    private static SortedSet getPantheonsSet() {
        return pantheonsSet;
    }

    private static Random getRandom() {
        return random;
    }

    private static void setSelectedPaper(int argSelectedPaper) {
        selectedPaper = argSelectedPaper;
    }

    private static void setSelectedUnitSet(int argSelectedUnitSet) {
        selectedUnitSet = argSelectedUnitSet;
    }

    private static SortedSet getSubschoolsSet() {
        return subschoolsSet;
    }

    private static String getUnit(String unitString) {
        if (unitString.startsWith("~")) {
            return unitString.substring(1);
        }
        return " " + unitString;
    }

    private static boolean isUseGUI() {
        return useGUI;
    }

    private static boolean isWeaponTwoHanded(PlayerCharacter pc, Equipment weapon, WeaponProf wp, boolean baseOnly) {
        if (pc == null || weapon == null || wp == null) {
            return false;
        }
        int pcSize = pc.sizeInt();
        if (weapon.hasWield()) {
            WieldCategory wCat;
            if (Globals.checkRule("SIZECAT")) {
                if (Globals.handsRequired(pc, weapon, wp) == 2) {
                    return true;
                }
            } else if (Globals.checkRule("SIZEOBJ") && (wCat = Globals.effectiveWieldCategory(pc, weapon)) != null) {
                return wCat.getObjectSizeInt(weapon) > pcSize;
            }
        } else {
            if (!baseOnly) {
                pcSize = (int)((double)pcSize + pc.getTotalBonusTo("WEAPONPROF=" + wp.getName(), "PCSIZE"));
            }
            if (Globals.handsRequired(pc, weapon, wp) == 2) {
                return true;
            }
            if (weapon.sizeInt() > pcSize) {
                return true;
            }
        }
        return false;
    }

    private static int bonusParsing(Iterator i, int level, int num) {
        String l = i.next().toString();
        StringTokenizer aTok = new StringTokenizer(l, "|", false);
        int startLevel = Integer.parseInt(aTok.nextToken());
        int rangeLevel = Integer.parseInt(aTok.nextToken());
        if (level == startLevel || level > startLevel && rangeLevel > 0 && (level - startLevel) % rangeLevel == 0) {
            ++num;
        }
        return num;
    }

    private static void clearSpellSets() {
        castingTimesSet.clear();
        componentSet.clear();
        descriptorSet.clear();
        durationSet.clear();
        rangesSet.clear();
        saveInfoSet.clear();
        srSet.clear();
        statSet.clear();
        targetSet.clear();
    }

    private static void clearWeaponProfs() {
        weaponProfs.clear();
    }

    private static void createEmptyRace() {
        if (s_EMPTYRACE == null) {
            s_EMPTYRACE = new Race();
            s_EMPTYRACE.setName("<none selected>");
            s_EMPTYRACE.setTypeInfo("HUMANOID");
        }
        Globals.getRaceMap().put("<none selected>", s_EMPTYRACE);
    }

    private static String expandRelativePath(String path) {
        if (path.startsWith("@")) {
            path = System.getProperty("user.dir") + File.separator + path.substring(1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        pcList = new ArrayList();
        javaVersion = System.getProperty("java.version");
        javaVersionMajor = Integer.valueOf(javaVersion.substring(0, javaVersion.indexOf(46)));
        javaVersionMinor = Integer.valueOf(javaVersion.substring(javaVersion.indexOf(46) + 1, javaVersion.lastIndexOf(46)));
        defaultPath = System.getProperty("user.dir");
        defaultPcgPath = Globals.getDefaultPath() + File.separator + "characters";
        dieSizes = new int[]{1, 2, 3, 4, 6, 8, 10, 12, 20, 100, 1000};
        language = "en";
        country = "US";
        bioSet = new BioSet();
        custColumnWidth = new ArrayList();
        sourceDisplay = 0;
        selectedPaper = -1;
        selectedUnitSet = -1;
        campaignMap = new HashMap();
        domainMap = new TreeMap();
        raceMap = new TreeMap();
        spellMap = new TreeMap();
        eqSlotMap = new HashMap();
        visionMap = new HashMap();
        armorProfList = new ArrayList();
        campaignList = new ArrayList(85);
        classList = new ArrayList(380);
        companionModList = new ArrayList();
        deityList = new ArrayList(275);
        domainList = new ArrayList(100);
        featList = new ArrayList(1200);
        kitList = new ArrayList();
        languageList = new ArrayList(200);
        pcClassTypeList = new ArrayList();
        skillList = new ArrayList(400);
        templateList = new ArrayList(350);
        denominationList = DenominationList.getInstance();
        saSet = new TreeSet();
        weaponProfs = new WeaponProfDataStore();
        random = new Random(System.currentTimeMillis());
        pantheonsSet = new TreeSet();
        raceTypesSet = new TreeSet();
        subschoolsSet = new TreeSet();
        weaponTypes = new TreeSet();
        castingTimesSet = new TreeSet();
        componentSet = new TreeSet();
        descriptorSet = new TreeSet();
        durationSet = new TreeSet();
        typeForSpellsSet = new TreeSet();
        rangesSet = new TreeSet();
        saveInfoSet = new TreeSet();
        srSet = new TreeSet();
        statSet = new TreeSet();
        targetSet = new TreeSet();
        section15 = new StringBuffer(30000);
        useGUI = true;
        bonusSpellMap = new HashMap();
        pObjectComp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((PObject)o1).getKeyName().compareToIgnoreCase(((PObject)o2).getKeyName());
            }
        };
        pObjectNameComp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((PObject)o1).getName().compareToIgnoreCase(((PObject)o2).getName());
            }
        };
        try {
            ResourceBundle globalProperties = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
            pcGenVersion = globalProperties.getString("VersionNumber");
        }
        catch (MissingResourceException mrex) {
            Logging.errorPrint("Can't find the VersionNumber property.", mrex);
        }
        finally {
            Object globalProperties = null;
        }
    }
}

