/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.WeaponProf;
import pcgen.core.character.CharacterSpell;
import pcgen.core.kit.KitFeat;
import pcgen.core.kit.KitGear;
import pcgen.core.kit.KitProf;
import pcgen.core.kit.KitSchool;
import pcgen.core.kit.KitSkill;
import pcgen.core.kit.KitSkillAdd;
import pcgen.core.kit.KitSpells;
import pcgen.core.kit.KitWrapper;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;

public final class Kit
extends PObject
implements Comparable {
    private KitSchool school = null;
    private List featList = null;
    private List gearList = null;
    private List profList = null;
    private List skillList = null;
    private List spellsList = null;
    private String buyRate = null;
    private String region = "";
    private String sellRate = null;
    private String templateString = null;

    public Kit(String argRegion) {
        String aString;
        StringTokenizer aTok = new StringTokenizer(argRegion, "\t", false);
        this.region = aTok.nextToken();
        if (aTok.hasMoreTokens() && (aString = aTok.nextToken()).startsWith("LANGAUTO:")) {
            this.addLanguageAutos(aString.substring(9));
        }
    }

    public void setBuyRate(String argRate) {
        this.buyRate = argRate;
    }

    public List getFeats() {
        return this.featList;
    }

    public List getGear() {
        return this.gearList;
    }

    public String getMyType(int i) {
        this.setMyType();
        return super.getMyType(i);
    }

    public int getMyTypeCount() {
        this.setMyType();
        return super.getMyTypeCount();
    }

    public void setName(String argName) {
        if (!argName.endsWith(".MOD")) {
            this.name = argName;
            this.keyName = this.region + "|" + argName;
        }
    }

    public List getProfs() {
        return this.profList;
    }

    public String getRegion() {
        return this.region;
    }

    public void setSchool(KitSchool kSchool) {
        this.school = kSchool;
    }

    public void setSellRate(String argRate) {
        this.sellRate = argRate;
    }

    public List getSkill() {
        return this.skillList;
    }

    public List getSpells() {
        return this.spellsList;
    }

    public void setTemplateString(String arg) {
        this.templateString = arg;
    }

    public String getTemplateString() {
        return this.templateString;
    }

    public String getType() {
        this.setMyType();
        return super.getType();
    }

    public boolean isType(String aType) {
        this.setMyType();
        return super.isType(aType);
    }

    public void addFeat(KitFeat kFeat) {
        if (kFeat != null) {
            if (this.featList == null) {
                this.featList = new ArrayList();
            }
            this.featList.add(kFeat);
        }
    }

    public void addGear(KitGear kGear) {
        if (kGear != null) {
            if (this.gearList == null) {
                this.gearList = new ArrayList();
            }
            this.gearList.add(kGear);
        }
    }

    public void addKitFeats(PlayerCharacter pc, List thingsToAdd, List warnings) {
        List aList = this.getFeats();
        if (aList != null && aList.size() != 0) {
            boolean tooManyFeats = false;
            int featsChosen = 0;
            int x = aList.size();
            for (int i = 0; i < x; ++i) {
                List xs;
                KitFeat kFeat = (KitFeat)aList.get(i);
                if (!PrereqHandler.passesAll(kFeat.getPrereqs(), pc, this)) continue;
                ArrayList<String> aFeatList = new ArrayList<String>();
                Iterator e = kFeat.getFeatList().iterator();
                while (e.hasNext()) {
                    String featName = this.itemPassesPrereqs((String)e.next(), pc);
                    if (featName == null) continue;
                    Feat aFeat = Globals.getFeatNamed(featName);
                    if (aFeat != null) {
                        aFeatList.add(featName);
                        continue;
                    }
                    warnings.add("FEAT: Non-existant feat \"" + featName + "\"");
                }
                int choiceCount = kFeat.getChoiceCount();
                if (choiceCount > aFeatList.size()) {
                    choiceCount = aFeatList.size();
                }
                if (choiceCount > (int)pc.getFeats() - featsChosen) {
                    choiceCount = (int)pc.getFeats() - featsChosen;
                    tooManyFeats = true;
                }
                if (choiceCount == 0) continue;
                if (choiceCount == aFeatList.size()) {
                    xs = aFeatList;
                } else {
                    while ((xs = Globals.getChoiceFromList("Choose feat(s)", aFeatList, new ArrayList(), choiceCount)).size() == 0) {
                    }
                }
                Iterator e2 = xs.iterator();
                while (e2.hasNext()) {
                    String featName = (String)e2.next();
                    Feat aFeat = Globals.getFeatNamed(featName);
                    if (aFeat != null) {
                        KitWrapper tta = new KitWrapper((Object)featName, false);
                        tta.setPObject(aFeat);
                        thingsToAdd.add(tta);
                        ++featsChosen;
                        continue;
                    }
                    warnings.add("FEAT: Non-existant feat \"" + featName + "\"");
                }
            }
            if (tooManyFeats) {
                warnings.add("FEAT: Some feats were not granted--not enough remaining feats");
            }
        }
    }

    public void addKitGear(PlayerCharacter pc, List thingsToAdd, List warnings) {
        boolean outOfFunds = false;
        List aList = this.getGear();
        if (aList != null && aList.size() != 0) {
            String costFormula;
            int aBuyRate = SettingsHandler.getGearTab_BuyRate();
            String purchaseFormula = this.getBuyRate();
            if (purchaseFormula != null && purchaseFormula.length() != 0 && (costFormula = this.getCostFromFormula(pc, purchaseFormula)) != null) {
                aBuyRate = pc.getVariableValue(costFormula, "").intValue();
            }
            BigDecimal pcGold = pc.getGold();
            BigDecimal goldSpent = BigDecimalHelper.ZERO;
            int x = aList.size();
            for (int i = 0; i < x; ++i) {
                Equipment eq;
                String eqName;
                KitGear kGear = (KitGear)aList.get(i);
                if (!PrereqHandler.passesAll(kGear.getPrereqs(), pc, this) || (eqName = this.itemPassesPrereqs(kGear.getName(), pc)) == null) continue;
                if (eqName.startsWith("TYPE=") || eqName.startsWith("TYPE.")) {
                    List eqList = EquipmentList.getEquipmentOfType(EquipmentList.getEquipmentList(), eqName.substring(5), "");
                    int maxCost = kGear.getMaxCost();
                    if (maxCost != 0) {
                        BigDecimal bdMaxCost = new BigDecimal(Integer.toString(maxCost));
                        for (int idx = eqList.size() - 1; idx >= 0; --idx) {
                            if (((Equipment)eqList.get(idx)).getCost(pc).compareTo(bdMaxCost) <= 0) continue;
                            eqList.remove(idx);
                        }
                        eqName = Globals.chooseFromList("Choose equipment", eqList, new ArrayList(), 1);
                    }
                }
                if ((eq = EquipmentList.getEquipmentNamed(eqName)) == null) {
                    warnings.add("GEAR: Non-existant gear \"" + eqName + "\"");
                    continue;
                }
                List eqMods = kGear.getEqMods();
                List eqTypeList = eq.typeList();
                eq = (Equipment)eq.clone();
                boolean tryResize = false;
                if (eq.isType("Natural") || !eq.isWeapon() && !eq.isAmmunition()) {
                    tryResize = Globals.canResizeHaveEffect(pc, eq, null);
                }
                if (tryResize) {
                    eq.resizeItem(pc, SystemCollections.getSizeAdjustmentAtIndex(pc.sizeInt()).getAbbreviation());
                }
                if (eqMods != null) {
                    for (int j = 0; j < eqMods.size(); ++j) {
                        String eqModName = (String)eqMods.get(j);
                        int idxPipe = eqModName.indexOf(124);
                        EquipmentModifier eqMod = idxPipe < 0 ? EquipmentList.getQualifiedModifierNamed(eqModName, eqTypeList) : EquipmentList.getQualifiedModifierNamed(eqModName.substring(0, idxPipe), eqTypeList);
                        if (eqMod == null) {
                            warnings.add("GEAR: " + eqName + ": non-existant equipment modifier \"" + eqModName + "\"");
                            continue;
                        }
                        if (idxPipe > 0) {
                            eq.addEqModifier(eqMod.getKeyName() + eqModName.substring(idxPipe), true);
                            continue;
                        }
                        eq.addEqModifier(eqMod, true, pc);
                    }
                }
                if (tryResize || eqMods != null) {
                    eq.nameItemFromModifiers(pc);
                }
                int qty = kGear.getQty();
                BigDecimal eqCost = eq.getCost(pc);
                BigDecimal extendedCost = BigDecimalHelper.ZERO;
                if (aBuyRate != 0) {
                    BigDecimal bdBuyRate = new BigDecimal(Integer.toString(aBuyRate)).multiply(new BigDecimal("0.01"));
                    extendedCost = eqCost.multiply(new BigDecimal(Integer.toString(qty))).multiply(bdBuyRate);
                    while (qty > 0 && extendedCost.add(goldSpent).compareTo(pcGold) > 0) {
                        extendedCost = eqCost.multiply(new BigDecimal(Integer.toString(--qty))).multiply(bdBuyRate);
                    }
                    goldSpent = goldSpent.add(extendedCost);
                }
                if (qty != kGear.getQty()) {
                    outOfFunds = true;
                }
                if (qty == 0) continue;
                KitWrapper tta = new KitWrapper((Object)eq, qty);
                tta.setCost(extendedCost);
                thingsToAdd.add(tta);
            }
        }
        if (outOfFunds) {
            warnings.add("GEAR: Some or all equipment not added--not enough funds.");
        }
    }

    public void addKitProfs(PlayerCharacter pc, List thingsToAdd, List warnings) {
        List aList = this.getProfs();
        if (aList != null && aList.size() != 0) {
            int x = aList.size();
            for (int i = 0; i < x; ++i) {
                List xs;
                ArrayList aBonusList;
                PObject aPObject;
                KitProf kProf = (KitProf)aList.get(i);
                if (!PrereqHandler.passesAll(kProf.getPrereqs(), pc, this)) continue;
                if (kProf.isRacial()) {
                    Race pcRace = pc.getRace();
                    if (pcRace == null) {
                        warnings.add("PROF: PC has no race");
                        continue;
                    }
                    if (pcRace.getSelectedWeaponProfBonusCount() != 0) {
                        warnings.add("PROF: Race has already selected bonus weapon proficiency");
                        continue;
                    }
                    aPObject = pcRace;
                    aBonusList = pcRace.getWeaponProfBonus();
                } else {
                    PCClass pcClass = this.getPCClass(pc, false);
                    if (pcClass == null) {
                        warnings.add("PROF: No owning class found. Kit needs PRECLASS");
                        continue;
                    }
                    if (pcClass.getSelectedWeaponProfBonusCount() != 0) {
                        warnings.add("PROF: Class has already selected bonus weapon proficiency");
                        continue;
                    }
                    aPObject = pcClass;
                    aBonusList = pcClass.getWeaponProfBonus();
                }
                if (aBonusList == null || aBonusList.size() == 0) {
                    warnings.add("PROF: No optional weapon proficiencies");
                    continue;
                }
                ArrayList<String> aProfList = new ArrayList<String>();
                Iterator e = kProf.getProfList().iterator();
                while (e.hasNext()) {
                    WeaponProf aProf;
                    String profName = this.itemPassesPrereqs((String)e.next(), pc);
                    if (profName == null) continue;
                    if (!aBonusList.contains(profName)) {
                        warnings.add("PROF: Weapon proficiency \"" + profName + "\" is not in list of choices");
                    }
                    if ((aProf = Globals.getWeaponProfNamed(profName)) != null) {
                        aProfList.add(profName);
                        continue;
                    }
                    warnings.add("PROF: Non-existant proficiency \"" + profName + "\"");
                }
                int choiceCount = kProf.getChoiceCount();
                if (choiceCount > aProfList.size()) {
                    choiceCount = aProfList.size();
                }
                if (choiceCount == 0) continue;
                if (choiceCount == aProfList.size()) {
                    xs = aProfList;
                } else {
                    while ((xs = Globals.getChoiceFromList("Choose Proficiencies", aProfList, new ArrayList(), choiceCount)).size() == 0) {
                    }
                }
                Iterator e2 = xs.iterator();
                while (e2.hasNext()) {
                    String profName = (String)e2.next();
                    WeaponProf aProf = Globals.getWeaponProfNamed(profName);
                    if (aProf != null) {
                        KitWrapper tta = new KitWrapper((Object)aProf, false);
                        tta.setPObject(aPObject);
                        thingsToAdd.add(tta);
                        continue;
                    }
                    warnings.add("PROF: Non-existant proficiency \"" + profName + "\"");
                }
            }
        }
    }

    public void addKitSkills(PlayerCharacter pc, List thingsToAdd, List warnings) {
        List aList = this.getSkill();
        if (aList != null && aList.size() != 0) {
            KitSkillAdd sta;
            PCClass pcClass = this.getPCClass(pc, false);
            if (pcClass == null) {
                warnings.add("SKILL: No owning class found. Kit needs PRECLASS");
                return;
            }
            ArrayList<KitSkillAdd> aSkillList = new ArrayList<KitSkillAdd>();
            int x = aList.size();
            for (int i = 0; i < x; ++i) {
                Skill aSkill;
                String skillName;
                KitSkill kSkill = (KitSkill)aList.get(i);
                if (!PrereqHandler.passesAll(kSkill.getPrereqs(), pc, this) || (skillName = this.itemPassesPrereqs(kSkill.getSkillName(), pc)) == null) continue;
                if (skillName.startsWith("TYPE=") || skillName.startsWith("TYPE.")) {
                    String skillType = skillName.substring(5);
                    ArrayList<String> skillsOfType = new ArrayList<String>();
                    Iterator e = Globals.getSkillList().iterator();
                    while (e.hasNext()) {
                        aSkill = (Skill)e.next();
                        if (!aSkill.isType(skillType)) continue;
                        skillsOfType.add(aSkill.getName());
                    }
                    if (skillsOfType.size() == 0) continue;
                    if (skillsOfType.size() == 1) {
                        skillName = (String)skillsOfType.get(0);
                    } else {
                        skillName = Globals.chooseFromList("Select " + skillType + " skill", skillsOfType, new ArrayList(), 1);
                        if (skillName == null) continue;
                    }
                }
                if ((aSkill = Globals.getSkillNamed(skillName)) == null) {
                    warnings.add("SKILL: Non-existant skill \"" + skillName + "\"");
                    continue;
                }
                sta = new KitSkillAdd(aSkill, Math.min(kSkill.getRank(), pc.getMaxRank(skillName, pcClass).doubleValue()), aSkill.costForPCClass(pcClass, pc), kSkill.isFree(), pc);
                aSkillList.add(sta);
            }
            int skillPool = pcClass.skillPool();
            if (aSkillList.size() == 0 || skillPool == 0) {
                return;
            }
            int skillsUsed = 0;
            int x2 = aSkillList.size();
            while (skillsUsed < skillPool) {
                boolean bModified = false;
                for (int i = 0; i < x2; ++i) {
                    sta = (KitSkillAdd)aSkillList.get(i);
                    if (!sta.addRank()) continue;
                    bModified = true;
                    if (++skillsUsed == skillPool) break;
                }
                if (bModified) continue;
            }
            for (int i = 0; i < x2; ++i) {
                sta = (KitSkillAdd)aSkillList.get(i);
                if (!sta.wasModified()) continue;
                KitWrapper tta = new KitWrapper((Object)sta, false);
                tta.setPObject(pcClass);
                thingsToAdd.add(tta);
            }
        }
    }

    public void addKitSpells(PlayerCharacter pc, List thingsToAdd, List warnings) {
        List aList = this.getSpells();
        if (aList != null && aList.size() != 0) {
            PCClass pcClass = this.getPCClass(pc, true);
            if (pcClass == null) {
                warnings.add("SPELLS: No owning class found. Kit needs PRECLASS");
                return;
            }
            int x = aList.size();
            for (int i = 0; i < x; ++i) {
                List xs;
                KitSpells kSpells = (KitSpells)aList.get(i);
                if (!PrereqHandler.passesAll(kSpells.getPrereqs(), pc, this)) continue;
                List<Spell> aSpellList = new ArrayList<Spell>();
                Iterator e = kSpells.getSpellList().iterator();
                while (e.hasNext()) {
                    String spellName = this.itemPassesPrereqs((String)e.next(), pc);
                    if (spellName == null) continue;
                    if (spellName.startsWith("LEVEL=")) {
                        aSpellList = Globals.getSpellsIn(Integer.parseInt(spellName.substring(6)), pcClass.getName(), "");
                        continue;
                    }
                    Spell aSpell = Globals.getSpellNamed(spellName);
                    if (aSpell != null) {
                        aSpellList.add(aSpell);
                        continue;
                    }
                    warnings.add("SPELLS: Non-existant spell \"" + spellName + "\"");
                }
                String choiceFormula = kSpells.getCountFormula();
                int choiceCount = choiceFormula.length() == 0 ? aSpellList.size() : pc.getVariableValue(choiceFormula, "").intValue();
                if (choiceCount > aSpellList.size()) {
                    choiceCount = aSpellList.size();
                }
                if (choiceCount == 0) continue;
                if (choiceCount == aSpellList.size()) {
                    xs = aSpellList;
                } else {
                    while ((xs = Globals.getChoiceFromList("Choose spell(s)", aSpellList, new ArrayList(), choiceCount)).size() == 0) {
                    }
                }
                Iterator e2 = xs.iterator();
                while (e2.hasNext()) {
                    Object obj = e2.next();
                    Spell aSpell = obj instanceof Spell ? (Spell)obj : Globals.getSpellNamed((String)obj);
                    if (aSpell != null) {
                        KitWrapper tta = new KitWrapper((Object)aSpell, false);
                        tta.setPObject(pcClass);
                        thingsToAdd.add(tta);
                        continue;
                    }
                    warnings.add("SPELLS: Non-existant spell \"" + obj.toString() + "\"");
                }
            }
        }
    }

    public void addProf(KitProf kProf) {
        if (kProf != null) {
            if (this.profList == null) {
                this.profList = new ArrayList();
            }
            this.profList.add(kProf);
        }
    }

    public void addSkill(KitSkill kSkill) {
        if (kSkill != null) {
            if (this.skillList == null) {
                this.skillList = new ArrayList();
            }
            this.skillList.add(kSkill);
        }
    }

    public void addSpells(KitSpells kSpells) {
        if (kSpells != null) {
            if (this.spellsList == null) {
                this.spellsList = new ArrayList();
            }
            this.spellsList.add(kSpells);
        }
    }

    public int compareTo(Object o) {
        Kit oKit = (Kit)o;
        int retVal = this.region.compareToIgnoreCase(oKit.getRegion());
        if (retVal == 0) {
            retVal = this.getName().compareToIgnoreCase(oKit.getName());
        }
        return retVal;
    }

    public void processKit(PlayerCharacter pc, List thingsToAdd) {
        this.processKit(pc, thingsToAdd, -1);
    }

    public void processKit(PlayerCharacter pc, List thingsToAdd, int kitNo) {
        BigDecimal goldSpent = BigDecimalHelper.ZERO;
        Iterator e = thingsToAdd.iterator();
        while (e.hasNext()) {
            KitWrapper tta = (KitWrapper)e.next();
            Object obj = tta.getObject();
            if (obj instanceof String) {
                if (!(tta.getPObject() instanceof Feat)) continue;
                pc.modFeat((String)obj, true, false);
                if (!tta.isFree()) continue;
                pc.setFeats(pc.getFeats() + 1.0);
                continue;
            }
            if (obj instanceof Equipment) {
                Equipment existing = pc.getEquipmentNamed(((Equipment)obj).getName());
                if (existing == null) {
                    ((Equipment)obj).setQty(new Float(tta.getQty()));
                    pc.addEquipment((Equipment)obj);
                    EquipmentList.addEquipment((Equipment)obj);
                } else {
                    existing.setQty(existing.qty() + (double)tta.getQty());
                }
                if (((Equipment)obj).getMemberOfKit() == -1) {
                    ((Equipment)obj).setMemberOfKit(kitNo);
                }
                goldSpent = goldSpent.add(tta.getCost());
                continue;
            }
            if (obj instanceof Spell) {
                this.updatePCSpells(pc, (Spell)obj, (PCClass)tta.getPObject());
                continue;
            }
            if (obj instanceof KitSkillAdd) {
                this.updatePCSkills(pc, (KitSkillAdd)obj, (PCClass)tta.getPObject());
                continue;
            }
            if (obj instanceof WeaponProf) {
                PObject pobj = tta.getPObject();
                pobj.addSelectedWeaponProfBonus(((WeaponProf)obj).getName());
                continue;
            }
            Logging.errorPrint("Unknown object type: " + obj.getClass().getName());
        }
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoInventory());
        pane.refresh();
        pc.setGold(pc.getGold().subtract(goldSpent).toString());
        pc.addKit(this);
    }

    private String getBuyRate() {
        return this.buyRate;
    }

    private String getCostFromFormula(PlayerCharacter pc, String formula) {
        StringTokenizer aTok = new StringTokenizer(formula, "[]", true);
        String costFormula = null;
        while (aTok.hasMoreTokens()) {
            String tok = aTok.nextToken();
            if ("]".equals(tok)) {
                costFormula = null;
                continue;
            }
            if (costFormula == null) {
                costFormula = tok;
                continue;
            }
            ArrayList<String> al = new ArrayList<String>();
            al.add(tok);
            if (PrereqHandler.passesAll(al, pc, this)) break;
            costFormula = null;
        }
        return costFormula;
    }

    private void setMyType() {
        if (super.getMyTypeCount() == 0) {
            if (this.gearList != null) {
                this.addMyType("GEAR");
            }
            if (this.featList != null) {
                this.addMyType("FEAT");
            }
            if (this.spellsList != null) {
                this.addMyType("SPELL");
            }
            if (this.skillList != null) {
                this.addMyType("SKILL");
            }
            if (this.school != null) {
                this.addMyType("SCHOOL");
            }
        }
    }

    private PCClass getPCClass(PlayerCharacter pc, boolean spells) {
        ArrayList prereqList = this.getPreReqList();
        if (prereqList != null) {
            ArrayList<String> preR = new ArrayList<String>();
            int x = prereqList.size();
            for (int i = 0; i < x; ++i) {
                int j;
                String prereq = (String)prereqList.get(i);
                if (!prereq.startsWith("PRECLASS:") || (j = prereq.lastIndexOf(61)) <= 0) continue;
                String reqLevel = prereq.substring(j);
                StringTokenizer aTok = new StringTokenizer(prereq.substring(9, j), ",", false);
                while (aTok.hasMoreTokens()) {
                    String className = aTok.nextToken();
                    PCClass aClass = pc.getClassNamed(className);
                    if (aClass == null) continue;
                    String baseStat = aClass.getSpellBaseStat();
                    if (spells && (baseStat == null || baseStat.length() <= 0 || baseStat.equalsIgnoreCase("None"))) continue;
                    preR.clear();
                    preR.add("PRECLASS:" + className + reqLevel);
                    if (!PrereqHandler.passesAll(preR, pc, this)) continue;
                    return aClass;
                }
            }
        }
        return null;
    }

    private String itemPassesPrereqs(String aString, PlayerCharacter aPC) {
        int idxStart = aString.indexOf(91);
        if (idxStart < 0 || !aString.endsWith("]")) {
            return aString;
        }
        String itemName = aString.substring(0, idxStart);
        List prereqList = CoreUtility.split(aString = aString.substring(idxStart + 1, aString.length() - 1), '|');
        if (PrereqHandler.passesAll(prereqList, aPC, this)) {
            return itemName;
        }
        return null;
    }

    private void updatePCSkills(PlayerCharacter pc, KitSkillAdd obj, PCClass pcClass) {
        Skill aSkill = pc.addSkill(obj.getSkill());
        String aString = aSkill.modRanks(obj.getDelta(), pcClass, pc);
        if (aString.length() > 0) {
            Logging.errorPrint("SKILL: " + aString);
        }
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoSkills());
        pane.refresh();
    }

    private void updatePCSpells(PlayerCharacter pc, Spell obj, PCClass pcClass) {
        int spLevel = obj.getFirstLevelForKey(pcClass.getSpellKey(), pc);
        if (spLevel < 0) {
            Logging.errorPrint("SPELLS: " + pcClass.getName() + " cannot cast spell \"" + obj.getName() + "\"");
            return;
        }
        CharacterSpell cs = new CharacterSpell(pcClass, obj);
        cs.addInfo(spLevel, 1, null);
        String aString = pc.addSpell(cs, null, pcClass.getName(), Globals.getDefaultSpellBook(), spLevel, spLevel);
        if (aString.length() != 0) {
            return;
        }
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoSpells());
        pane.refresh();
    }
}

