/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.LevelAbilityClassSkills;
import pcgen.core.LevelAbilityEquipment;
import pcgen.core.LevelAbilityFeat;
import pcgen.core.LevelAbilityLanguage;
import pcgen.core.LevelAbilityList;
import pcgen.core.LevelAbilitySkill;
import pcgen.core.LevelAbilitySpecial;
import pcgen.core.LevelAbilityWeaponBonus;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public class LevelAbility
extends PObject {
    protected PObject owner;
    protected String list;
    private String aText;
    private String eString = "";
    private int level;
    private int type;
    private static final int SKILL = 2;
    private static final int DOMAIN = 4;
    private static final int SPELLCASTER = 6;
    private static final int SPELLLEVEL = 7;
    private static final int TYPE = 8;

    LevelAbility(PObject aOwner, int aLevel, String aList) {
        this.owner = aOwner;
        this.level = aLevel;
        this.list = aList;
    }

    public final String getList() {
        return this.list;
    }

    public final int level() {
        return this.level;
    }

    public final void process(PlayerCharacter aPC) {
        this.process(null, aPC);
    }

    public final void process(List availableList, PlayerCharacter aPC) {
        String bString;
        this.aText = bString = this.list;
        this.type = 4;
        if (bString.startsWith("SKILL")) {
            this.type = 2;
        } else if (bString.startsWith("SPELLCASTER")) {
            this.type = 6;
        } else if (bString.startsWith("SPELLLEVEL")) {
            ArrayList<String> aBonusList = new ArrayList<String>();
            StringTokenizer cTok = new StringTokenizer(bString, "[]", false);
            String choices = cTok.nextToken();
            while (cTok.hasMoreTokens()) {
                aBonusList.add(cTok.nextToken());
            }
            this.getChoices(choices, aBonusList, aPC);
            this.type = 7;
        } else if (bString.startsWith("TYPE=") || bString.startsWith("TYPE.")) {
            this.type = 8;
        }
        ChooserInterface c = ChooserFactory.getChooserInstance();
        bString = this.prepareChooser(c);
        List aArrayList = this.getChoicesList(bString, aPC);
        if (availableList != null) {
            availableList.addAll(aArrayList);
        } else if (c.getPool() == Integer.MIN_VALUE) {
            this.processChoice(aArrayList, aArrayList, this.eString, aPC);
        } else {
            c.setAvailableList(aArrayList);
            c.setVisible(false);
            if (aArrayList.size() > 0 && this.type != 7) {
                c.setVisible(true);
                this.processChoice(aArrayList, c.getSelectedList(), this.eString, aPC);
            }
        }
    }

    public void processChoice(List aArrayList, List selectedList, String aString, PlayerCharacter aPC) {
        int index = 0;
        switch (this.type) {
            case 4: {
                if (this.aText.startsWith("DOMAIN")) {
                    int aLevel = -9;
                    String domainSource = "";
                    String className = null;
                    boolean fromClass = false;
                    int dnum = aPC.getMaxCharacterDomains() - aPC.getCharacterDomainUsed();
                    if (dnum <= 0) {
                        dnum = (int)this.owner.bonusTo("DOMAIN", "NUMBER", aPC, aPC);
                    }
                    if (this.owner instanceof PCClass) {
                        fromClass = true;
                        className = this.owner.getName();
                        aLevel = ((PCClass)this.owner).getLevel();
                        if (dnum <= 0) {
                            dnum = (int)((PCClass)this.owner).getBonusTo("DOMAIN", "NUMBER", aLevel, aPC);
                        }
                        domainSource = "PCClass|" + className + "|1";
                    }
                    if (dnum <= 0) {
                        dnum = 1;
                    }
                    Iterator i = selectedList.iterator();
                    while (dnum > 0 && i.hasNext()) {
                        Domain aDom;
                        String domName = (String)i.next();
                        if (aPC.getCharacterDomainIndex(domName) != -1 || (aDom = Globals.getDomainNamed(domName)) == null) continue;
                        aDom = (Domain)aDom.clone();
                        CharacterDomain aCD = aPC.getNewCharacterDomain(className);
                        aCD.setDomain(aDom, aPC);
                        aPC.addCharacterDomain(aCD);
                        aDom.setIsLocked(true, aPC);
                        --dnum;
                    }
                } else {
                    String zText = this.aText + '(';
                    int listSize = selectedList.size();
                    for (index = 0; index < listSize; ++index) {
                        String sString = selectedList.get(index).toString();
                        if (sString.startsWith("TYPE=") || sString.startsWith("TYPE.")) {
                            LevelAbility la = new LevelAbility(this.owner, this.level, sString);
                            la.process(aPC);
                            sString = la.list;
                        }
                        String zString = zText + sString + ')' + aString;
                        SpecialAbility sa = new SpecialAbility(zString, "PCCLASS|" + this.owner.getName() + '|' + this.level);
                        this.owner.addSpecialAbilityToList(sa);
                        this.owner.addSave(zString);
                    }
                }
                break;
            }
            case 6: {
                if (selectedList.size() <= 0) break;
                String cString = selectedList.get(index).toString();
                PCClass bClass = aPC.getClassNamed(cString);
                if (bClass == null) {
                    bClass = Globals.getClassNamed(cString);
                    if (bClass == null) {
                        Logging.errorPrint("ERROR:Expected PC to have a class named " + cString);
                        break;
                    }
                    aPC.incrementClassLevel(0, bClass);
                }
                this.owner.addBonusList("0|PCLEVEL|" + bClass.getKeyName() + "|1");
                bClass.setLevel(bClass.getLevel(), aPC);
                this.addAllToAssociated(selectedList);
                break;
            }
            case 8: {
                String cString;
                if (selectedList.size() <= 0) break;
                this.list = cString = selectedList.get(index).toString();
                break;
            }
            default: {
                Logging.errorPrint("In LevelAbility.processChoice the type " + this.type + " is not supported.");
            }
        }
    }

    final void setOwner(PObject aOwner) {
        this.owner = aOwner;
    }

    static LevelAbility createAbility(PObject aowner, int aLevel, String aString) {
        if (aString.startsWith("SPECIAL")) {
            return new LevelAbilitySpecial(aowner, aLevel, aString);
        }
        if (aString.startsWith("FEAT")) {
            return new LevelAbilityFeat(aowner, aLevel, aString, false);
        }
        if (aString.startsWith("VFEAT")) {
            return new LevelAbilityFeat(aowner, aLevel, aString, true);
        }
        if (aString.startsWith("CLASSSKILLS")) {
            return new LevelAbilityClassSkills(aowner, aLevel, aString);
        }
        if (aString.startsWith("WEAPONBONUS")) {
            return new LevelAbilityWeaponBonus(aowner, aLevel, aString);
        }
        if (aString.startsWith("EQUIP")) {
            return new LevelAbilityEquipment(aowner, aLevel, aString);
        }
        if (aString.startsWith("LIST")) {
            return new LevelAbilityList(aowner, aLevel, aString);
        }
        if (aString.startsWith("Language")) {
            return new LevelAbilityLanguage(aowner, aLevel, aString);
        }
        if (aString.startsWith("SKILL")) {
            return new LevelAbilitySkill(aowner, aLevel, aString);
        }
        return new LevelAbility(aowner, aLevel, aString);
    }

    final boolean canProcess() {
        StringTokenizer aTok = new StringTokenizer(this.list, "(", false);
        return aTok.countTokens() > 1;
    }

    final void subForLevel(PlayerCharacter aPC) {
        StringTokenizer aStrTok = new StringTokenizer(this.list, ",");
        while (aStrTok.hasMoreTokens()) {
            String thisString = aStrTok.nextToken();
            if ("FEAT".equals(thisString)) {
                aPC.setFeats(aPC.getFeats() - 1.0);
                continue;
            }
            if (!thisString.startsWith("INIT|") || !(this.owner instanceof PCClass)) continue;
            ((PCClass)this.owner).addInitMod(-Integer.parseInt(thisString.substring(5)));
        }
    }

    List getChoicesList(String bString, PlayerCharacter aPC) {
        int idx;
        ArrayList<String> aArrayList = new ArrayList<String>();
        if (this.type == 8) {
            String aString = bString.substring(5);
            ArrayList races = new ArrayList(Globals.getRaceMap().values());
            Iterator e = races.iterator();
            while (e.hasNext()) {
                Race race = (Race)e.next();
                if (!race.getType().equalsIgnoreCase(aString)) continue;
                aArrayList.add(race.getName());
            }
            e = Globals.getClassList().iterator();
            while (e.hasNext()) {
                PCClass aClass = (PCClass)e.next();
                if (!aClass.isType(aString) || aArrayList.contains(aClass.getName())) continue;
                aArrayList.add(aClass.getName());
            }
            return aArrayList;
        }
        int iOpenParen = 0;
        for (idx = 0; idx < bString.length(); ++idx) {
            switch (bString.charAt(idx)) {
                case '(': {
                    ++iOpenParen;
                    break;
                }
                case ')': {
                    --iOpenParen;
                    break;
                }
            }
            if (iOpenParen < 0) break;
        }
        if (iOpenParen >= 0) {
            this.eString = "";
        } else {
            this.eString = bString.substring(idx + 1);
            this.eString = this.eString.replace('{', '(').replace('}', ')').replace('~', '|');
            bString = bString.substring(0, idx);
        }
        StringTokenizer aTok = new StringTokenizer(bString, ",", false);
        boolean flag = true;
        while (aTok.hasMoreTokens() && flag) {
            String aString = aTok.nextToken();
            ArrayList<String> preReqArray = new ArrayList<String>();
            if (aString.lastIndexOf(60) > -1) {
                StringTokenizer bTok = new StringTokenizer(bString, "<>|", true);
                int len = 0;
                String pString = "";
                while (bTok.hasMoreTokens() && !">".equals(pString)) {
                    pString = bTok.nextToken();
                    if (len == 0) {
                        aString = pString;
                    }
                    if (len > 0 && (pString.startsWith("PRE") || pString.startsWith("!PRE"))) {
                        preReqArray.add(pString);
                    }
                    len += pString.length();
                }
                if (len < bString.length()) {
                    bString = bString.substring(len + 1);
                    aTok = new StringTokenizer(bString, ",", false);
                } else {
                    flag = false;
                }
            }
            if (!PrereqHandler.passesAll(preReqArray, aPC, null)) continue;
            this.processToken(aString, aArrayList, bString, aPC);
        }
        return aArrayList;
    }

    String prepareChooser(ChooserInterface c) {
        int i = this.list.lastIndexOf(41);
        if (i >= 0 && i < this.list.length() - 1) {
            try {
                c.setPool(Integer.parseInt(this.list.substring(i + 1)));
                this.list = this.list.substring(0, i + 1);
            }
            catch (NumberFormatException nfe) {
                c.setPool(1);
            }
        } else {
            c.setPool(1);
        }
        String bString = this.list;
        switch (this.type) {
            case 2: {
                c.setTitle("Skill Choice");
                bString = this.list.substring(6);
                break;
            }
            case 4: {
                int a = this.list.lastIndexOf(40);
                if (a > 0) {
                    this.aText = this.list.substring(0, a);
                    bString = this.list.substring(a + 1);
                } else {
                    this.aText = this.list;
                    bString = this.list;
                }
                c.setTitle(this.aText);
                break;
            }
            case 6: {
                c.setTitle("Spell Caster Class Choice");
                break;
            }
            case 8: {
                c.setTitle("Type Selection");
                break;
            }
            default: {
                Logging.errorPrint("In LevelAbility.prepareChooser the type " + this.type + " is not supported.");
            }
        }
        return bString;
    }

    void processToken(String aChoice, List aArrayList, String bString, PlayerCharacter aPC) {
        switch (this.type) {
            case 4: {
                if (aPC.hasSpecialAbility(this.aText + '(' + aChoice + ')')) break;
                aArrayList.add(aChoice);
                break;
            }
            case 6: {
                PCClass bClass;
                String cString = bString.substring(bString.lastIndexOf(40) + 1, bString.lastIndexOf(41));
                PCClass aClass = Globals.getClassNamed(cString);
                if (aClass != null) {
                    bString = aClass.getName();
                }
                Iterator e1 = aPC.getClassList().iterator();
                while (e1.hasNext()) {
                    bClass = (PCClass)e1.next();
                    if ("Domain".equals(bClass.getKeyName()) || "".equals(bClass.getSpellType()) || "None".equals(bClass.getSpellType()) || bClass.getKeyName().equals(this.owner.getKeyName()) || bString.lastIndexOf("ANY") <= -1 && bString.lastIndexOf(bClass.getSpellType()) <= -1) continue;
                    aArrayList.add(bClass.getKeyName());
                }
                if (bString.startsWith("SPELLCASTER(")) {
                    bString = bString.substring(12, bString.length() - 1);
                }
                StringTokenizer aTok = new StringTokenizer(bString, "|", false);
                while (aTok.hasMoreTokens()) {
                    String aString = aTok.nextToken();
                    if (aArrayList.contains(aString)) continue;
                    if (aString.startsWith("EXCLUDE=") && aArrayList.contains(aString.substring(8))) {
                        aArrayList.remove(aString.substring(8));
                    }
                    if ((bClass = Globals.getClassNamed(aString)) == null) continue;
                    aArrayList.add(bClass.getKeyName());
                }
                break;
            }
            case 2: {
                aArrayList.add(aChoice);
                break;
            }
            default: {
                Logging.errorPrint("In LevelAbility.processToken the type " + this.type + " is not supported.");
            }
        }
    }
}

