/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.LevelAbility;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserInterface;

final class LevelAbilityClassSkills
extends LevelAbility {
    private static final int CHOICETYPE_ANY = -1;
    private static final int CHOICETYPE_NONE = 0;
    private static final int CHOICETYPE_UNTRAINED = 1;
    private static final int CHOICETYPE_TRAINED = 2;
    private static final int CHOICETYPE_EXCLUSIVE = 3;
    private static final int CHOICETYPE_NONEXCLUSIVE = 4;
    private static final int CHOICETYPE_CROSSCLASS = 5;
    private static final int CHOICETYPE_BYTYPE = 6;
    private int autoRank = 0;

    LevelAbilityClassSkills(PObject aOwner, int aLevel, String aList) {
        super(aOwner, aLevel, aList);
    }

    public List getChoicesList(String bString, PlayerCharacter aPC) {
        ArrayList<String> aArrayList = new ArrayList<String>();
        StringTokenizer aTok = new StringTokenizer(this.list.substring(this.list.lastIndexOf(40) + 1, this.list.lastIndexOf(41)), ",", false);
        String skillType = "";
        this.autoRank = 0;
        PCClass theClass = this.owner instanceof PCClass ? (PCClass)this.owner : new PCClass();
        while (aTok.hasMoreTokens()) {
            Skill aSkill;
            int choiceType = 0;
            String aText = aTok.nextToken();
            if ("UNTRAINED".equals(aText)) {
                choiceType = 1;
            } else if ("TRAINED".equals(aText)) {
                choiceType = 2;
            } else if ("EXCLUSIVE".equals(aText)) {
                choiceType = 3;
            } else if ("NONEXCLUSIVE".equals(aText)) {
                choiceType = 4;
            } else if ("CROSSCLASSSKILLS".equals(aText)) {
                choiceType = 5;
            } else if ("ANY".equals(aText)) {
                choiceType = -1;
            } else if (aText.startsWith("TYPE=") || aText.startsWith("TYPE.")) {
                skillType = aText.substring(5);
                choiceType = 6;
            } else if (aText.startsWith("AUTORANK=") || aText.startsWith("AUTORANK.")) {
                try {
                    this.autoRank = Integer.parseInt(aText.substring(9));
                }
                catch (NumberFormatException exc) {
                    Logging.errorPrint("Will use default for autoRank: " + this.autoRank, exc);
                }
            } else {
                aSkill = Globals.getSkillNamed(aText);
                if (aSkill != null && !aSkill.isClassSkill(theClass, aPC)) {
                    aArrayList.add(aSkill.getKeyName());
                }
            }
            if (choiceType == 0) continue;
            int x = Globals.getSkillList().size();
            block12: for (int index = 0; index < x; ++index) {
                aSkill = (Skill)Globals.getSkillList().get(index);
                if (aSkill.isClassSkill(theClass, aPC)) continue;
                switch (choiceType) {
                    case 1: {
                        if (!"Y".equals(aSkill.getUntrained())) continue block12;
                        break;
                    }
                    case 2: {
                        if (!"N".equals(aSkill.getUntrained())) continue block12;
                        break;
                    }
                    case 3: {
                        if (!aSkill.isExclusive()) continue block12;
                        break;
                    }
                    case 4: {
                        if (aSkill.isExclusive()) continue block12;
                        break;
                    }
                    case 5: {
                        if (aSkill.isExclusive()) continue block12;
                        break;
                    }
                    case -1: {
                        break;
                    }
                    case 6: {
                        if (!aSkill.isType(skillType)) continue block12;
                        break;
                    }
                    default: {
                        Logging.errorPrint("Impossible choice in LevelAbilityClassSkills.getChoicesList() :" + choiceType);
                    }
                }
                aArrayList.add(aSkill.getKeyName());
            }
        }
        return aArrayList;
    }

    public String prepareChooser(ChooserInterface c) {
        super.prepareChooser(c);
        StringTokenizer aTok = new StringTokenizer(this.list, "|", false);
        try {
            c.setTitle(aTok.nextToken());
        }
        catch (NoSuchElementException ignore) {
            // empty catch block
        }
        if (aTok.hasMoreTokens()) {
            String s = aTok.nextToken();
            if (s.equalsIgnoreCase("ALL")) {
                c.setPool(Integer.MIN_VALUE);
            } else {
                c.setPool(Integer.parseInt(s));
            }
        }
        return this.list;
    }

    public void processChoice(List aArrayList, List selectedList, String eString, PlayerCharacter aPC) {
        for (int index = 0; index < selectedList.size(); ++index) {
            Skill aSkill;
            String nString = selectedList.get(index).toString() + eString;
            if (!(this.owner instanceof PCClass) || ((PCClass)this.owner).hasSkill(nString)) continue;
            ((PCClass)this.owner).addSkillToList(nString);
            if (this.autoRank == 0 || (aSkill = Globals.getSkillKeyed(nString)) == null || aPC == null) continue;
            aSkill = aPC.addSkill(aSkill);
            aSkill.modRanks(1.0, (PCClass)this.owner, true, aPC);
        }
        this.addAllToAssociated(selectedList);
    }
}

