/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.Collections;
import java.util.List;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.LevelAbility;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserInterface;

final class LevelAbilityEquipment
extends LevelAbility {
    LevelAbilityEquipment(PObject aowner, int aLevel, String aString) {
        super(aowner, aLevel, aString);
    }

    public List getChoicesList(String bString, PlayerCharacter aPC) {
        List aList = super.getChoicesList(bString.substring(6), aPC);
        Collections.sort(aList);
        return aList;
    }

    public String prepareChooser(ChooserInterface c) {
        super.prepareChooser(c);
        c.setTitle("Equipment Choice");
        return this.list;
    }

    public void processChoice(List aArrayList, List selectedList, String extraString, PlayerCharacter aPC) {
        for (int n = 0; n < selectedList.size(); ++n) {
            String equipmentName = selectedList.get(n).toString();
            Equipment aEquipment = EquipmentList.getEquipmentNamed(equipmentName);
            if (aEquipment == null) {
                Logging.errorPrint("LevelAbilityEquipment: Equipment not found: " + equipmentName);
                return;
            }
            Equipment bEquipment = (Equipment)aEquipment.clone();
            bEquipment.setQty(1.0);
            aPC.addEquipment(bEquipment);
        }
    }

    void processToken(String aChoice, List aArrayList, String bString, PlayerCharacter aPC) {
        if (aChoice.startsWith("TYPE=") || aChoice.startsWith("TYPE.")) {
            String eqType = aChoice.substring(5);
            aArrayList.addAll(EquipmentList.getEquipmentOfType(EquipmentList.getEquipmentList(), eqType, ""));
        } else {
            String equipmentName = aChoice;
            Equipment aEquipment = EquipmentList.getEquipmentNamed(equipmentName);
            if (aEquipment == null) {
                Logging.errorPrint("LevelAbilityEquipment: Equipment not found: " + equipmentName);
                return;
            }
            if (!aPC.getEquipmentMasterList().contains(aEquipment) && PrereqHandler.passesAll(aEquipment.getPreReqList(), aPC, aEquipment)) {
                aArrayList.add(aChoice);
            }
        }
    }
}

