/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.LevelAbility;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserInterface;

final class LevelAbilityFeat
extends LevelAbility {
    private boolean isVFeat = false;
    private int numFeats = 1;

    LevelAbilityFeat(PObject aowner, int aLevel, String aString, boolean aVFeat) {
        super(aowner, aLevel, aString);
        this.isVFeat = aVFeat;
    }

    public List getChoicesList(String bString, PlayerCharacter aPC) {
        List aList = this.isVFeat ? super.getChoicesList(bString.substring(6), aPC) : super.getChoicesList(bString.substring(5), aPC);
        Collections.sort(aList);
        return aList;
    }

    public String prepareChooser(ChooserInterface c) {
        super.prepareChooser(c);
        this.numFeats = c.getPool();
        if (this.isVFeat) {
            c.setTitle("Virtual Feat Selection");
        } else {
            c.setTitle("Feat Choice");
        }
        c.setPoolFlag(true);
        return this.list;
    }

    public void processChoice(List aArrayList, List selectedList, String extraString, PlayerCharacter aPC) {
        if (this.isVFeat) {
            int listSize = selectedList.size();
            for (int index = 0; index < listSize; ++index) {
                String featName = selectedList.get(index).toString();
                List aList = aPC.getVirtualFeatList();
                Feat aFeat = PlayerCharacter.getFeatNamedInList(aList = aPC.addVirtualFeat(featName, aList), featName);
                if (aFeat != null) {
                    if (aFeat.isMultiples()) {
                        double x = aPC.getFeats();
                        aPC.setFeats(1.0);
                        aFeat.modChoices(aPC);
                        aPC.setFeats(x);
                    }
                    aFeat.setNeedsSaving(true);
                    continue;
                }
                Logging.errorPrint("Error:" + featName + " not added, aPC.getFeatNamedInList() == NULL");
            }
        } else {
            aPC.setFeats(aPC.getFeats() + (double)this.numFeats);
            for (int n = 0; n < selectedList.size(); ++n) {
                String chosenItem = selectedList.get(n).toString();
                String featString = chosenItem + extraString;
                ArrayList<String> aBonusList = new ArrayList<String>();
                Feat aFeat = Globals.getFeatNamed(featString);
                boolean spellLevelProcess = false;
                if (aFeat != null && aFeat.getChoiceString().startsWith("SPELLLEVEL")) {
                    spellLevelProcess = true;
                    StringTokenizer sTok = new StringTokenizer(aFeat.getChoiceString(), "[]", false);
                    sTok.nextToken();
                    while (sTok.hasMoreTokens()) {
                        aBonusList.add(sTok.nextToken());
                    }
                }
                aPC.modFeat(featString, true, false);
                if (!spellLevelProcess || aFeat == null) continue;
                if (chosenItem.indexOf("(") > 0) {
                    StringTokenizer cTok = new StringTokenizer(chosenItem, "()", false);
                    aFeat = aPC.getFeatNamed(cTok.nextToken());
                    chosenItem = cTok.nextToken();
                }
                Iterator bonii = aBonusList.iterator();
                while (bonii.hasNext()) {
                    if (aFeat == null) continue;
                    aFeat.applyBonus((String)bonii.next(), chosenItem, aPC);
                }
            }
        }
    }

    void processToken(String aChoice, List aArrayList, String bString, PlayerCharacter aPC) {
        if (aChoice.startsWith("TYPE=") || aChoice.startsWith("TYPE.")) {
            String featType = aChoice.substring(5);
            if ("REGION".equals(featType)) {
                featType = LevelAbilityFeat.findFeatType(aPC, featType);
            } else if ("SUBREGION".equals(featType)) {
                Iterator iterator;
                Iterator e = iterator = aPC.getTemplateList().iterator();
                while (e.hasNext()) {
                    PCTemplate t = (PCTemplate)e.next();
                    String subregionType = t.getSubRegion();
                    if (subregionType.equals("None")) continue;
                    featType = subregionType;
                }
            } else if ("ALLREGION".equals(featType)) {
                Iterator iterator2;
                featType = LevelAbilityFeat.findFeatType(aPC, featType);
                aArrayList.addAll(aPC.getAvailableFeatNames(featType));
                Iterator e = iterator2 = aPC.getTemplateList().iterator();
                while (e.hasNext()) {
                    PCTemplate t = (PCTemplate)e.next();
                    String subregionType = t.getSubRegion();
                    if (subregionType.equals("None")) continue;
                    featType = subregionType;
                }
            }
            aArrayList.addAll(aPC.getAvailableFeatNames(featType, this.isVFeat));
        } else {
            StringTokenizer aTok = new StringTokenizer(aChoice, ",", false);
            String featName = aTok.nextToken().trim();
            String subName = "";
            Feat aFeat = Globals.getFeatNamed(featName);
            if (aFeat == null) {
                Logging.errorPrint("LevelAbilityFeat: Feat not found: " + featName);
                return;
            }
            if (!featName.equalsIgnoreCase(aFeat.getName())) {
                subName = featName.substring(aFeat.getName().length());
                featName = aFeat.getName();
                int i = subName.indexOf(40);
                if (i > -1) {
                    subName = subName.substring(i + 1);
                }
            }
            if (this.isVFeat || PrereqHandler.passesAll(aFeat.getPreReqList(), aPC, aFeat)) {
                if (aFeat.isMultiples()) {
                    int idx;
                    int percIdx;
                    Feat pcFeat = aPC.getFeatNamed(featName);
                    if (pcFeat != null) {
                        aFeat = pcFeat;
                    }
                    if ((percIdx = subName.indexOf(37)) > -1) {
                        subName = subName.substring(0, percIdx);
                    } else if (subName.length() != 0 && (idx = subName.lastIndexOf(41)) > -1) {
                        subName = subName.substring(0, idx);
                    }
                    ArrayList<String> availableList = new ArrayList<String>();
                    ArrayList selectedList = new ArrayList();
                    aFeat.modChoices(aPC, true, availableList, selectedList, false);
                    if (subName.length() != 0) {
                        for (int n = availableList.size() - 1; n >= 0; --n) {
                            String aString = (String)availableList.get(n);
                            if (aString.startsWith(subName)) continue;
                            availableList.remove(n);
                        }
                        if (percIdx == -1 && availableList.size() == 0) {
                            availableList.add(subName);
                        }
                    }
                    if (!aFeat.isStacks()) {
                        Iterator e = selectedList.iterator();
                        while (e.hasNext()) {
                            int idx2 = availableList.indexOf(e.next());
                            if (idx2 <= -1) continue;
                            availableList.remove(idx2);
                        }
                    }
                    if (!aFeat.getChoiceString().startsWith("SPELLLIST|")) {
                        Iterator e = availableList.iterator();
                        while (e.hasNext()) {
                            aArrayList.add(featName + "(" + (String)e.next() + ")");
                        }
                    } else {
                        aArrayList.add(featName);
                    }
                    return;
                }
                if (!aPC.hasFeat(featName) && !aPC.hasFeatAutomatic(featName)) {
                    aArrayList.add(aChoice);
                }
            }
        }
    }

    private static String findFeatType(PlayerCharacter aPC, String featType) {
        Iterator iterator;
        Iterator e = iterator = aPC.getTemplateList().iterator();
        while (e.hasNext()) {
            PCTemplate t = (PCTemplate)e.next();
            String regionType = t.getRegion();
            if (regionType.equals("None")) continue;
            featType = regionType;
        }
        return featType;
    }
}

