/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.LevelAbility;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.util.chooser.ChooserInterface;

final class LevelAbilityWeaponBonus
extends LevelAbility {
    private String bonusMod;
    private String bonusTag;

    LevelAbilityWeaponBonus(PObject aowner, int aLevel, String aList) {
        super(aowner, aLevel, aList);
    }

    public List getChoicesList(String bString, PlayerCharacter aPC) {
        ArrayList<String> aArrayList = new ArrayList<String>();
        StringTokenizer bTok = new StringTokenizer(bString.substring(12), "|", false);
        this.bonusTag = bTok.nextToken();
        this.bonusMod = bTok.nextToken();
        while (bTok.hasMoreTokens()) {
            Feat aFeat;
            String cString = bTok.nextToken();
            if (cString.startsWith("PCFEAT=") || cString.startsWith("PCFEAT.")) {
                aFeat = aPC.getFeatNamed(cString.substring(7));
                if (aFeat == null) continue;
                for (int ii = 0; ii < aFeat.getAssociatedCount(); ++ii) {
                    if (aArrayList.contains(aFeat.getAssociated(ii))) continue;
                    aArrayList.add(aFeat.getAssociated(ii));
                }
                continue;
            }
            if (cString.startsWith("FEAT=") || cString.startsWith("FEAT.")) {
                aFeat = Globals.getFeatNamed(cString.substring(5));
                if (aFeat == null) continue;
                StringTokenizer aTok = new StringTokenizer(aFeat.getName(), " ", false);
                String aName = aTok.nextToken();
                Collection weaponProfsOfType = Globals.getAllWeaponProfsOfType(aName);
                Iterator ii = weaponProfsOfType.iterator();
                while (ii.hasNext()) {
                    WeaponProf wp = (WeaponProf)ii.next();
                    if (aArrayList.contains(wp.getName())) continue;
                    aArrayList.add(wp.getName());
                }
                continue;
            }
            if (cString.startsWith("ALL")) {
                Globals.addUniqueWeaponProfsAsStringTo(aArrayList);
                continue;
            }
            if (cString.startsWith("PCPROFLIST")) {
                Iterator ii = aPC.getWeaponProfList().iterator();
                while (ii.hasNext()) {
                    String prof = (String)ii.next();
                    if (aArrayList.contains(prof)) continue;
                    aArrayList.add(prof);
                }
                continue;
            }
            WeaponProf wp = Globals.getWeaponProfNamed(cString);
            if (wp == null || aArrayList.contains(cString)) continue;
            aArrayList.add(cString);
        }
        return aArrayList;
    }

    public String prepareChooser(ChooserInterface c) {
        super.prepareChooser(c);
        c.setTitle("Select Weapon Prof");
        this.bonusTag = "";
        this.bonusMod = "";
        return this.list;
    }

    public void processChoice(List aArrayList, List selectedList, String eString, PlayerCharacter aPC) {
        String bonusString = '|' + this.bonusTag + '|' + this.bonusMod;
        for (int index = 0; index < selectedList.size(); ++index) {
            String cString = selectedList.get(index).toString() + eString;
            String weaponProfString = "WEAPONPROF=" + cString + bonusString;
            this.owner.addBonusList("0|" + weaponProfString);
            this.owner.addSave("BONUS|0|" + weaponProfString);
        }
    }
}

