/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import pcgen.core.PlayerCharacter;
import pcgen.util.BigDecimalHelper;

public final class LevelInfo {
    private String maxClassSkillString = "0";
    private String maxCrossClassSkillString = "0";
    private String levelString = "0";
    private String minXPString = "0";

    public void setLevelString(String arg) {
        this.levelString = arg;
    }

    public String getLevelString() {
        return this.levelString;
    }

    public void setMaxClassSkillString(String arg) {
        this.maxClassSkillString = arg;
    }

    public void setMaxCrossClassSkillString(String arg) {
        this.maxCrossClassSkillString = arg;
    }

    public void setMinXPString(String arg) {
        this.minXPString = arg;
    }

    public String toString() {
        return "Level: " + this.levelString + " MinXP: " + this.minXPString + " MaxClassSkill: " + this.maxClassSkillString + " MaxCrossClassSkill: " + this.maxCrossClassSkillString + ".";
    }

    public int getMinXP(int levelArg, PlayerCharacter calcPC) {
        int xp = 0;
        if (calcPC == null) {
            return 0;
        }
        try {
            xp = calcPC.getVariableValue(this.minXPString.replaceAll(this.levelString, String.valueOf(levelArg)), "").intValue();
        }
        catch (Exception e) {
            String minString = this.minXPString.replaceAll(this.levelString, String.valueOf(levelArg));
            xp = calcPC.getVariableValue(minString, "").intValue();
        }
        return xp;
    }

    public BigDecimal getMaxClassSkillRank(int levelArg, PlayerCharacter calcPC) {
        return this.getMaxSkillRank(levelArg, calcPC, this.maxClassSkillString);
    }

    public BigDecimal getMaxCrossClassSkillRank(int levelArg, PlayerCharacter calcPC) {
        return this.getMaxSkillRank(levelArg, calcPC, this.maxCrossClassSkillString);
    }

    private BigDecimal getMaxSkillRank(int levelArg, PlayerCharacter calcPC, String maxSkillString) {
        double ranks = 0.0;
        if (calcPC == null) {
            return BigDecimalHelper.ZERO;
        }
        try {
            ranks = calcPC.getVariableValue(maxSkillString.replaceAll(this.levelString, String.valueOf(levelArg)), "").doubleValue();
        }
        catch (Exception e) {
            String rankString = maxSkillString.replaceAll(this.levelString, String.valueOf(levelArg));
            ranks = calcPC.getVariableValue(rankString, "").doubleValue();
        }
        return new BigDecimal(ranks);
    }
}

