/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.NameRule;
import pcgen.core.PlayerCharacter;
import pcgen.core.RollingMethods;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Logging;

public final class Names {
    private static final Names theInstance = new Names();
    private static final String TAB_CHARACTER = "\t";
    private static final String NAMES_DIRECTORY = SettingsHandler.getPcgenSystemDir() + File.separator + "bio" + File.separator + "names" + File.separator;
    private final List ruleDefinitions = new ArrayList();
    private final Map allTheSyllablesForEachRule = new HashMap();
    private PlayerCharacter aPC = null;

    private Names() {
    }

    public static Names getInstance() {
        return theInstance;
    }

    public static String[] findAllNamesFiles() {
        File directory = new File(NAMES_DIRECTORY);
        String[] fileNames = directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".nam");
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < fileNames.length; ++i) {
            result.add(fileNames[i].substring(0, fileNames[i].length() - 4));
        }
        return result.toArray(new String[result.size()]);
    }

    public String getRandomName() {
        NameRule ruleToUse = Names.chooseARandomRule(this.buildTheRuleSyllableMapping());
        if (ruleToUse == null) {
            Logging.errorPrint("Couldn't find a name rule to use.");
            throw new RuntimeException("No random name available. Try again.");
        }
        return this.constructTheName(ruleToUse);
    }

    public void init(String fileName, PlayerCharacter pc) {
        this.aPC = pc;
        this.clearAllRules();
        this.parseFile(NAMES_DIRECTORY + fileName + ".nam");
    }

    String[] getRuleDefinitions() {
        return this.ruleDefinitions.toArray(new String[this.ruleDefinitions.size()]);
    }

    String[] getSyllablesByName(String name) {
        List syllables = (List)this.allTheSyllablesForEachRule.get(name);
        return syllables.toArray(new String[syllables.size()]);
    }

    private List buildTheRuleSyllableMapping() {
        ArrayList<NameRule> rules = new ArrayList<NameRule>();
        if (this.getRuleDefinitions().length > 0) {
            for (int i = 0; i < this.getRuleDefinitions().length; ++i) {
                String rule = this.getRuleDefinitions()[i];
                StringTokenizer newlineStr = new StringTokenizer(rule, TAB_CHARACTER, false);
                NameRule newRule = new NameRule(Integer.parseInt(newlineStr.nextToken()));
                while (newlineStr.hasMoreTokens()) {
                    String syllableName = newlineStr.nextToken();
                    newRule.addSyllable(syllableName);
                }
                rules.add(newRule);
            }
        }
        return rules;
    }

    private static NameRule chooseARandomRule(List rules) {
        NameRule ruleToUse = null;
        int roll = RollingMethods.roll(1, 100);
        for (int y = 0; y < rules.size(); ++y) {
            if (roll > ((NameRule)rules.get(y)).getChance()) continue;
            ruleToUse = (NameRule)rules.get(y);
            break;
        }
        return ruleToUse;
    }

    private String getRandomSyllableByName(String name) {
        if (this.getSyllablesByName(name) != null && this.getSyllablesByName(name).length > 0) {
            int roll = RollingMethods.roll(1, this.getSyllablesByName(name).length);
            return this.getSyllablesByName(name)[roll - 1];
        }
        return "";
    }

    private void clearAllRules() {
        this.ruleDefinitions.clear();
        this.allTheSyllablesForEachRule.clear();
    }

    private String constructTheName(NameRule ruleToUse) {
        StringBuffer buf = new StringBuffer(30);
        String[] ruleSyllables = ruleToUse.getRuleSyllables();
        for (int i = 0; i < ruleSyllables.length; ++i) {
            if (ruleSyllables[i].startsWith("[{") && ruleSyllables[i].endsWith("}]")) {
                String FileName = ruleSyllables[i].substring(2, ruleSyllables[i].length() - 2);
                Names otherFile = new Names();
                otherFile.init(FileName, this.aPC);
                String Name = otherFile.getRandomName();
                buf.append(Name);
                continue;
            }
            buf.append(this.getRandomSyllableByName(ruleSyllables[i]));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFile(String argFileName) {
        String fileName = CoreUtility.fixFilenamePath(argFileName);
        String currentLine = "";
        BufferedReader br = null;
        File namesPartSource = new File(fileName);
        String currentSyllable = null;
        boolean canWrite = true;
        boolean inRulesSection = false;
        br = new BufferedReader(new InputStreamReader(new FileInputStream(namesPartSource)));
        while ((currentLine = br.readLine()) != null) {
            if (currentLine.length() > 0 && currentLine.charAt(0) == '#' || currentLine.startsWith("//") || "".equals(currentLine.trim())) continue;
            if (currentLine.startsWith("[/PRE]")) {
                canWrite = true;
            }
            if (currentLine.startsWith("[PRE") && currentLine.indexOf(58) >= 0) {
                StringTokenizer tabTok = new StringTokenizer(currentLine.substring(1, currentLine.length() - 1), TAB_CHARACTER, false);
                ArrayList<String> aList = new ArrayList<String>();
                while (tabTok.hasMoreTokens()) {
                    aList.add(tabTok.nextToken());
                }
                canWrite = PrereqHandler.passesAll(aList, this.aPC, null);
                continue;
            }
            if (!canWrite) continue;
            if (currentLine.startsWith("[RULES]")) {
                inRulesSection = true;
                continue;
            }
            if (currentLine.length() > 0 && currentLine.charAt(0) == '[') {
                inRulesSection = false;
            }
            if (inRulesSection) {
                this.ruleDefinitions.add(currentLine);
                continue;
            }
            if (currentLine.length() > 0 && currentLine.charAt(0) == '[' && currentLine.endsWith("]")) {
                currentSyllable = currentLine;
                this.allTheSyllablesForEachRule.put(currentLine, new ArrayList());
                continue;
            }
            ((List)this.allTheSyllablesForEachRule.get(currentSyllable)).add(currentLine);
        }
        Object var12_13 = null;
        if (br == null) return;
        try {
            br.close();
            return;
        }
        catch (IOException ignore) {
            Logging.errorPrint("Couldn't close the reader for " + argFileName, ignore);
        }
        return;
        {
            catch (FileNotFoundException exception) {
                if (!"pcgen.ini".equals(fileName)) {
                    Logging.errorPrint("ERROR:" + fileName + " error " + currentLine + " Exception type:" + exception.getClass().getName() + " Message:" + exception.getMessage(), exception);
                }
                Object var12_14 = null;
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException ignore) {
                    Logging.errorPrint("Couldn't close the reader for " + argFileName, ignore);
                }
                return;
            }
            catch (IOException exception) {
                if (!"pcgen.ini".equals(fileName)) {
                    Logging.errorPrint("ERROR:" + fileName + " error " + currentLine + " Exception type:" + exception.getClass().getName() + " Message:" + exception.getMessage(), exception);
                }
                Object var12_15 = null;
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException ignore) {
                    Logging.errorPrint("Couldn't close the reader for " + argFileName, ignore);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException ignore) {
                Logging.errorPrint("Couldn't close the reader for " + argFileName, ignore);
            }
            throw throwable;
        }
    }
}

