/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.CharacterDomain;
import pcgen.core.ClassType;
import pcgen.core.Constants;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.LevelAbility;
import pcgen.core.LevelAbilityFeat;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SubClass;
import pcgen.core.SystemCollections;
import pcgen.core.Variable;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.pclevelinfo.PCLevelInfoStat;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public class PCClass
extends PObject {
    protected String bonusSpellBaseStat = "None";
    protected String spellBaseStat = "None";
    protected int level = 0;
    protected int numSpellsFromSpecialty = 0;
    private ArrayList acList = new ArrayList();
    private ArrayList domainList = new ArrayList();
    private ArrayList featAutos = new ArrayList();
    private ArrayList featList = new ArrayList();
    private ArrayList knownList = new ArrayList();
    private ArrayList knownSpellsList = new ArrayList();
    private ArrayList specialtyList = new ArrayList();
    private ArrayList specialtyknownList = new ArrayList();
    private final ArrayList templates = new ArrayList();
    private ArrayList SR = null;
    private ArrayList addDomains = new ArrayList();
    private ArrayList naturalWeapons = null;
    private ArrayList subClassList = null;
    private ArrayList templatesAdded = null;
    private ArrayList uattList = new ArrayList();
    private ArrayList weaponProfBonus = new ArrayList();
    private final HashMap castForLevelMap = new HashMap();
    private ArrayList DR = null;
    private HashMap hitPointMap = new HashMap();
    private HashMap vFeatMap = new HashMap();
    protected HashMap hitDieLockMap = new HashMap();
    private Integer skillPool = new Integer(0);
    private List classSkillList = null;
    private List classSpellList = null;
    private List skillList = new LinkedList();
    private List visionList = null;
    private Map attackCycleMap = new HashMap();
    private Map castMap = new HashMap();
    private String CRFormula = null;
    private String XPPenalty = null;
    private String abbrev = "";
    private String attackBonusType = "O";
    private String attackCycle = "";
    private String castAs = "";
    private String classSkillString = null;
    private String classSpellString = null;
    private LinkedList deityList = new LinkedList();
    private String exClass = "";
    private String itemCreationMultiplier = "";
    private String levelExchange = "";
    private String monsterFlag = null;
    private String preRaceType = null;
    private String prohibitedString = "None";
    private String specialsString = "";
    private String spellType = "None";
    private String stableSpellKey = null;
    private String subClassName = "None";
    private String subClassString = "None";
    private TreeSet languageBonus = new TreeSet();
    private boolean hasSubClass = false;
    private boolean memorizeSpells = true;
    private boolean modToSkills = true;
    private boolean multiPreReqs = false;
    private boolean usesSpellbook = false;
    private int hitDie = 0;
    private int initMod = 0;
    private int initialFeats = 0;
    private Integer levelsPerFeat = null;
    private int maxLevel = 20;
    private int skillPoints = 0;
    private int maxCastLevel = -1;
    private int maxKnownLevel = -1;

    public PCClass() {
        this.deityList.add("ANY");
    }

    public final Collection getACList() {
        return this.acList;
    }

    public final void setAbbrev(String argAbbrev) {
        this.abbrev = argAbbrev;
    }

    public final String getAbbrev() {
        return this.abbrev;
    }

    public final ArrayList getAddDomains() {
        return this.addDomains;
    }

    public final void setAttackBonusType(String aString) {
        this.attackBonusType = aString;
    }

    public final String getAttackBonusType() {
        return this.attackBonusType;
    }

    public final void setAttackCycle(String aString) {
        this.attackCycle = aString;
        if (aString.indexOf(124) == -1) {
            return;
        }
        StringTokenizer aTok = new StringTokenizer(this.attackCycle, "|");
        while (aTok.hasMoreTokens()) {
            String attackType = aTok.nextToken();
            String aVal = aTok.nextToken();
            this.attackCycleMap.put(attackType, aVal);
        }
    }

    public final String getAttackCycle() {
        return this.attackCycle;
    }

    public final void setCastAs(String aString) {
        this.castAs = aString;
    }

    public final String getCastAs() {
        if (this.castAs == null || this.castAs.equals("")) {
            return this.name;
        }
        return this.castAs;
    }

    public List getBonusListOfType(String aType, String aName, int aLevel) {
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (aBonus.getTypeOfBonus().indexOf(aType) < 0 || aBonus.getBonusInfo().indexOf(aName) < 0 || aBonus.getPCLevel() > aLevel) continue;
            aList.add(aBonus);
        }
        return aList;
    }

    public final void setBonusSpellBaseStat(String baseStat) {
        this.bonusSpellBaseStat = baseStat;
    }

    public final String getBonusSpellBaseStat() {
        return this.bonusSpellBaseStat;
    }

    public double getBonusTo(String argType, String argMname, int asLevel, PlayerCharacter aPC) {
        double i = 0.0;
        if (asLevel == 0 || this.getBonusList().isEmpty()) {
            return 0.0;
        }
        String type = argType.toUpperCase();
        String mname = argMname.toUpperCase();
        Iterator e = this.getBonusList().iterator();
        while (e.hasNext()) {
            BonusObj aBonus = (BonusObj)e.next();
            StringTokenizer breakOnPipes = new StringTokenizer(aBonus.toString().toUpperCase(), "|", false);
            int aLevel = Integer.parseInt(breakOnPipes.nextToken());
            String theType = breakOnPipes.nextToken();
            if (!theType.equals(type)) continue;
            String str = breakOnPipes.nextToken();
            StringTokenizer breakOnCommas = new StringTokenizer(str, ",", false);
            while (breakOnCommas.hasMoreTokens()) {
                String theName = breakOnCommas.nextToken();
                if (aLevel > asLevel || !theName.equals(mname)) continue;
                String aString = breakOnPipes.nextToken();
                ArrayList<Prerequisite> localPreReqList = new ArrayList<Prerequisite>();
                while (breakOnPipes.hasMoreTokens()) {
                    String bString = breakOnPipes.nextToken();
                    if (!bString.startsWith("PRE") && !bString.startsWith("!PRE")) continue;
                    Logging.debugPrint("Why is this prerequisite '" + bString + "' parsed in '" + this.getClass().getName() + ".getBonusTo(String,String,int)' rather than in the persistence layer?");
                    try {
                        PreParserFactory factory = PreParserFactory.getInstance();
                        localPreReqList.add(factory.parse(bString));
                    }
                    catch (PersistenceLayerException ple) {
                        Logging.errorPrint(ple.getMessage(), ple);
                    }
                }
                if (!PrereqHandler.passesAll(localPreReqList, aPC, this)) continue;
                double j = aPC.getVariableValue(aString, "CLASS:" + this.name).doubleValue();
                i += j;
            }
        }
        return i;
    }

    public int getCastForLevel(int pcLevel, int spellLevel, String bookName, PlayerCharacter aPC) {
        return this.getCastForLevel(pcLevel, spellLevel, bookName, true, aPC);
    }

    public int getCastForLevel(int pcLevel, int spellLevel, String bookName, boolean includeAdj, PlayerCharacter aPC) {
        return this.getCastForLevel(pcLevel, spellLevel, bookName, includeAdj, true, aPC);
    }

    public int getCastForLevel(int pcLevel, int spellLevel, String bookName, boolean includeAdj, boolean limitByStat, PlayerCharacter aPC) {
        int maxSpellLevel;
        int total = 0;
        int stat = 0;
        String classKeyName = "CLASS." + this.getKeyName();
        String levelSpellLevel = ";LEVEL." + spellLevel;
        String allSpellLevel = ";LEVEL.All";
        pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", this.name);
        if (this.getNumFromCastList(pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType()), spellLevel) < 0) {
            return 0;
        }
        total += (int)aPC.getTotalBonusTo("SPELLCAST", classKeyName + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLCAST", "TYPE." + this.getSpellType() + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLCAST", "CLASS.Any" + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLCAST", classKeyName + ";LEVEL.All");
        total += (int)aPC.getTotalBonusTo("SPELLCAST", "TYPE." + this.getSpellType() + ";LEVEL.All");
        total += (int)aPC.getTotalBonusTo("SPELLCAST", "CLASS.Any;LEVEL.All");
        int index = this.baseSpellIndex();
        if (index != -2 && index >= 0 && index < aPC.getStatList().getStats().size()) {
            PCStat aStat = (PCStat)aPC.getStatList().getStats().get(index);
            stat = aPC.getStatList().getTotalStatFor(aStat.getAbb());
        }
        String statString = "None";
        if (index >= 0) {
            statString = SettingsHandler.getGame().s_ATTRIBSHORT[index];
        }
        int bonusStat = (int)aPC.getTotalBonusTo("STAT", "CAST." + statString) + (int)aPC.getTotalBonusTo("STAT", "BASESPELLSTAT") + (int)aPC.getTotalBonusTo("STAT", "BASESPELLSTAT;CLASS." + this.name);
        if (index > -2 && limitByStat && (maxSpellLevel = aPC.getVariableValue("MAXLEVELSTAT=" + statString, "").intValue()) + bonusStat < spellLevel) {
            return total;
        }
        stat += bonusStat;
        int adj = 0;
        if (includeAdj && !bookName.equals(Globals.getDefaultSpellBook()) && (this.specialtyList.size() > 0 || aPC.getCharacterDomainList().size() > 0)) {
            for (int ix = 0; ix <= spellLevel; ++ix) {
                List aList = this.getCharacterSpell(null, "", ix);
                List bList = new ArrayList();
                if (!aList.isEmpty()) {
                    if (ix > 0 && "DIVINE".equalsIgnoreCase(this.spellType)) {
                        Iterator i = aPC.getCharacterDomainList().iterator();
                        while (i.hasNext()) {
                            CharacterDomain aCD = (CharacterDomain)i.next();
                            if (!aCD.isFromPCClass(this.getName()) || aCD.getDomain() == null) continue;
                            bList = Globals.getSpellsIn(ix, "", aCD.getDomain().getName());
                        }
                    }
                    Iterator e = aList.iterator();
                    while (e.hasNext()) {
                        int x = -1;
                        CharacterSpell cs = (CharacterSpell)e.next();
                        if (!bList.isEmpty()) {
                            if (bList.contains(cs.getSpell())) {
                                x = 0;
                            }
                        } else {
                            x = cs.getInfoIndexFor("", ix, 1);
                        }
                        if (x <= -1) continue;
                        adj = 1;
                        break;
                    }
                }
                if (adj == 1) break;
            }
        }
        int mult = (int)aPC.getTotalBonusTo("SPELLCASTMULT", classKeyName + levelSpellLevel);
        if ((mult += (int)aPC.getTotalBonusTo("SPELLCASTMULT", "TYPE." + this.getSpellType() + levelSpellLevel)) < 1) {
            mult = 1;
        }
        int t = this.getNumFromCastList(pcLevel, spellLevel);
        total += t * mult + adj;
        Object bonusSpell = Globals.getBonusSpellMap().get(String.valueOf(spellLevel));
        if (bonusSpell != null && !bonusSpell.equals("0|0")) {
            StringTokenizer s = new StringTokenizer(bonusSpell.toString(), "|");
            int base = Integer.parseInt(s.nextToken());
            int range = Integer.parseInt(s.nextToken());
            if (stat >= base) {
                total += Math.max(0, (stat - base + range) / range);
            }
        }
        return total;
    }

    public final void setClassSkillString(String aString) {
        this.classSkillString = aString;
    }

    public List getClassSpecialAbilityList(PlayerCharacter aPC) {
        ArrayList<String> aList = new ArrayList<String>();
        ArrayList<String> formattedList = new ArrayList<String>();
        ArrayList abilityList = this.getSpecialAbilityList();
        if (abilityList == null) {
            return aList;
        }
        if (!abilityList.isEmpty()) {
            Iterator i = abilityList.iterator();
            while (i.hasNext()) {
                SpecialAbility saAbility = (SpecialAbility)i.next();
                String aString = saAbility.toString();
                boolean found = false;
                Iterator ii = aList.iterator();
                while (ii.hasNext()) {
                    if (!aString.equals(ii.next())) continue;
                    found = true;
                    break;
                }
                if (found || !saAbility.pcQualifiesFor(aPC)) continue;
                aList.add(aString);
            }
        }
        int x = aList.size();
        for (int i = 0; i < x; ++i) {
            StringTokenizer varTok = new StringTokenizer((String)aList.get(i), "|", false);
            String aString = varTok.nextToken();
            int[] varValue = null;
            int varCount = varTok.countTokens();
            if (varCount != 0) {
                varValue = new int[varCount];
                for (int j = 0; j < varCount; ++j) {
                    String vString = varTok.nextToken();
                    varValue[j] = aPC.getVariable(vString, true, true, "", "").intValue();
                }
            }
            StringBuffer newAbility = new StringBuffer();
            varTok = new StringTokenizer(aString, "%", true);
            varCount = 0;
            boolean isZero = false;
            while (varTok.hasMoreTokens()) {
                String nextTok = varTok.nextToken();
                if ("%".equals(nextTok)) {
                    if (varCount == 0) {
                        isZero = true;
                    }
                    if (varValue != null && varCount < varValue.length) {
                        int thisVar;
                        isZero &= (thisVar = varValue[varCount++]) == 0;
                        newAbility.append(thisVar);
                        continue;
                    }
                    newAbility.append('%');
                    continue;
                }
                newAbility.append(nextTok);
            }
            if (isZero) continue;
            formattedList.add(newAbility.toString());
        }
        return formattedList;
    }

    public final List getClassSpellList() {
        return this.classSpellList;
    }

    public final void setDeityList(List deityList) {
        this.deityList = new LinkedList(deityList);
    }

    public final List getDeityList() {
        return this.deityList;
    }

    public final ArrayList getDomainList() {
        return this.domainList;
    }

    public final void setExClass(String aString) {
        this.exClass = aString;
    }

    public final String getExClass() {
        return this.exClass;
    }

    public final Collection getFeatAutos() {
        return this.featAutos;
    }

    public final ArrayList getFeatList() {
        return this.featList;
    }

    public final void setHitDie(int dice) {
        this.hitDie = dice;
    }

    public int getBaseHitDie() {
        return this.hitDie;
    }

    public void putHitDieLock(String hitDieLock, int level) {
        this.hitDieLockMap.put(new Integer(level), hitDieLock);
    }

    protected String getHitDieLock(int level) {
        return (String)this.hitDieLockMap.get(new Integer(level));
    }

    public final void setInitialFeats(int feats) {
        this.initialFeats = feats;
    }

    public final int getInitialFeats() {
        return this.initialFeats;
    }

    public final void setItemCreationMultiplier(String argItemCreationMultiplier) {
        this.itemCreationMultiplier = argItemCreationMultiplier;
    }

    public final String getItemCreationMultiplier() {
        return this.itemCreationMultiplier;
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevelExchange(String aString) {
        this.levelExchange = aString;
    }

    public final String getLevelExchange() {
        return this.levelExchange;
    }

    public final void setLevelWithoutConsequence(int arg) {
        this.level = arg;
    }

    public final void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final void setMemorizeSpells(boolean memorizeSpells) {
        this.memorizeSpells = memorizeSpells;
    }

    public final boolean getMemorizeSpells() {
        return this.memorizeSpells;
    }

    public final void setMultiPreReqs(boolean multiPreReqs) {
        this.multiPreReqs = multiPreReqs;
    }

    public final void setPreRaceType(String preRaceType) {
        this.preRaceType = preRaceType.toUpperCase();
    }

    public final void setSkillPool(Integer argSkillPool) {
        this.skillPool = argSkillPool;
    }

    public final Integer getSkillPool(PlayerCharacter aPC) {
        int returnValue = 0;
        for (int i = 0; i <= this.level; ++i) {
            PCLevelInfo pcl = aPC.getLevelInfoFor(this.getKeyName(), i);
            if (pcl == null || !pcl.getClassKeyName().equals(this.getKeyName())) continue;
            returnValue += pcl.getSkillPointsRemaining(aPC);
        }
        return new Integer(returnValue);
    }

    public final void setSpecialsString(String aString) {
        this.specialsString = aString;
    }

    public final Collection getSpecialtyList() {
        return this.specialtyList;
    }

    public void setAddDomains(int level, String aString, String delimiter) {
        StringTokenizer aTok = new StringTokenizer(aString, delimiter, false);
        String prefix = Integer.toString(level) + '|';
        while (aTok.hasMoreTokens()) {
            this.addDomains.add(prefix + aTok.nextToken());
        }
    }

    public String getDisplayClassName() {
        if (this.subClassName.length() > 0 && !this.subClassName.equals("None")) {
            return this.subClassName;
        }
        return this.name;
    }

    public String getFullDisplayClassName() {
        StringBuffer buf = new StringBuffer();
        if (this.subClassName.length() > 0 && !this.subClassName.equals("None")) {
            buf.append(this.subClassName);
        } else {
            buf.append(this.name);
        }
        return buf.append(" ").append(this.level).toString();
    }

    public final void setHasSubClass(boolean arg) {
        this.hasSubClass = arg;
    }

    public final void setProhibitedString(String aString) {
        this.prohibitedString = aString;
    }

    public final String getProhibitedString() {
        return this.prohibitedString;
    }

    public int getLevelHitDie(PlayerCharacter aPC, int classLevel) {
        int currHitDie = this.getLevelHitDieUnadjusted(aPC, classLevel);
        String dieLock = aPC.getRace().getHitDieLock();
        if (dieLock.length() != 0) {
            currHitDie = this.calcHitDieLock(dieLock, currHitDie);
        }
        ArrayList templateList = aPC.getTemplateList();
        Iterator e = templateList.iterator();
        while (e.hasNext()) {
            PCTemplate template = (PCTemplate)e.next();
            if (template == null || (dieLock = template.getHitDieLock()).length() == 0) continue;
            currHitDie = this.calcHitDieLock(dieLock, currHitDie);
        }
        dieLock = (String)this.hitDieLockMap.get(new Integer(classLevel));
        if (dieLock != null && dieLock.length() != 0) {
            currHitDie = this.calcHitDieLock(dieLock, currHitDie);
        }
        return currHitDie;
    }

    private int calcHitDieLock(String dieLock, int currDie) {
        int diedivide;
        int[] dieSizes = Globals.getDieSizes();
        if (dieLock.startsWith("%/")) {
            diedivide = Integer.parseInt(dieLock.substring(2));
            if (diedivide <= 0) {
                diedivide = 1;
            }
            diedivide = currDie / diedivide;
        } else if (dieLock.startsWith("%*")) {
            diedivide = Integer.parseInt(dieLock.substring(2));
            diedivide *= currDie;
        } else if (dieLock.startsWith("%+")) {
            diedivide = Integer.parseInt(dieLock.substring(2));
            diedivide += currDie;
        } else if (dieLock.startsWith("%-")) {
            diedivide = Integer.parseInt(dieLock.substring(2));
            diedivide = currDie - diedivide;
        } else if (dieLock.startsWith("%up")) {
            diedivide = Integer.parseInt(dieLock.substring(3));
            if (diedivide > 4) {
                diedivide = 4;
            }
            if (diedivide < 0) {
                diedivide = 0;
            }
            for (int i = 3; i <= 7 - diedivide; ++i) {
                if (currDie != dieSizes[i]) continue;
                return dieSizes[i + diedivide];
            }
            diedivide = dieSizes[7];
        } else if (dieLock.startsWith("%Hup")) {
            diedivide = Integer.parseInt(dieLock.substring(4));
            for (int i = 0; i < dieSizes.length - diedivide; ++i) {
                if (currDie != dieSizes[i]) continue;
                return dieSizes[i + diedivide];
            }
            diedivide = dieSizes[dieSizes.length];
        } else if (dieLock.startsWith("%down")) {
            diedivide = Integer.parseInt(dieLock.substring(5));
            if (diedivide > 4) {
                diedivide = 4;
            }
            if (diedivide < 0) {
                diedivide = 0;
            }
            for (int i = 3 + diedivide; i <= 7; ++i) {
                if (currDie != dieSizes[i]) continue;
                return dieSizes[i - diedivide];
            }
            diedivide = dieSizes[3];
        } else if (dieLock.startsWith("%Hdown")) {
            for (int i = diedivide = Integer.parseInt(dieLock.substring(5)); i < dieSizes.length; ++i) {
                if (currDie != dieSizes[i]) continue;
                return dieSizes[i - diedivide];
            }
            diedivide = dieSizes[0];
        } else {
            diedivide = Integer.parseInt(dieLock);
        }
        if (diedivide <= 0) {
            diedivide = 1;
        }
        return diedivide;
    }

    public final int getLevelHitDieUnadjusted(PlayerCharacter aPC, int classLevel) {
        if ("None".equals(this.subClassName)) {
            return this.hitDie;
        }
        SubClass aSubClass = this.getSubClassNamed(this.subClassName);
        if (aSubClass != null) {
            return aSubClass.getLevelHitDie(aPC, classLevel);
        }
        return this.hitDie;
    }

    public final void setModToSkills(boolean bool) {
        this.modToSkills = bool;
    }

    public final boolean getModToSkills() {
        return this.modToSkills;
    }

    public final void setSkillPoints(int points) {
        this.skillPoints = points;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public String getSpecialtyListString(PlayerCharacter aPC) {
        Iterator i;
        StringBuffer retString = new StringBuffer();
        if (!this.specialtyList.isEmpty()) {
            i = this.specialtyList.iterator();
            while (i.hasNext()) {
                if (retString.length() > 0) {
                    retString.append(',');
                }
                retString.append((String)i.next());
            }
        }
        if (!aPC.getCharacterDomainList().isEmpty()) {
            i = aPC.getCharacterDomainList().iterator();
            while (i.hasNext()) {
                CharacterDomain aCD = (CharacterDomain)i.next();
                if (aCD.getDomain() == null) continue;
                if (retString.length() > 0) {
                    retString.append(',');
                }
                retString.append(aCD.getDomain().getName());
            }
        }
        return retString.toString();
    }

    public final void setSpellBaseStat(String baseStat) {
        this.spellBaseStat = baseStat;
    }

    public final String getSpellBaseStat() {
        return this.spellBaseStat;
    }

    public String getSpellKey() {
        if (this.stableSpellKey != null) {
            return this.stableSpellKey;
        }
        if (this.classSpellList == null) {
            this.chooseClassSpellList();
            if (this.classSpellList == null) {
                this.stableSpellKey = "CLASS|" + this.name;
                return this.stableSpellKey;
            }
        }
        StringBuffer aBuf = new StringBuffer();
        Iterator i = this.classSpellList.iterator();
        while (i.hasNext()) {
            String aString = i.next().toString();
            if (aBuf.length() > 0) {
                aBuf.append('|');
            }
            if (aString.endsWith("(Domain)")) {
                aBuf.append("DOMAIN|").append(aString.substring(0, aString.length() - 8));
                continue;
            }
            aBuf.append("CLASS|").append(aString);
        }
        this.stableSpellKey = aBuf.toString();
        return this.stableSpellKey;
    }

    public final void setSpellLevelString(String aString) {
        this.classSpellString = aString;
    }

    public final String getSpellLevelString() {
        return this.classSpellString;
    }

    public final void setSpellType(String newType) {
        this.spellType = newType;
    }

    public final String getSpellType() {
        return this.spellType;
    }

    public void setCastMap(int index, String cast) {
        if (index > this.maxCastLevel) {
            this.maxCastLevel = index;
        }
        this.castMap.put(String.valueOf(index), cast);
    }

    public Map getCastMap() {
        if ("".equals(this.castAs) || this.getName().equals(this.castAs)) {
            return this.castMap;
        }
        PCClass aClass = Globals.getClassNamed(this.castAs);
        if (aClass != null) {
            return aClass.getCastMap();
        }
        return this.castMap;
    }

    public String getCastStringForLevel(int aInt) {
        if (aInt > this.maxCastLevel) {
            aInt = this.maxCastLevel;
        }
        String aLevel = String.valueOf(aInt);
        if (this.getCastMap().containsKey(aLevel)) {
            return (String)this.getCastMap().get(aLevel);
        }
        return "";
    }

    public int getKnownForLevel(int pcLevel, int spellLevel, PlayerCharacter aPC) {
        return this.getKnownForLevel(pcLevel, spellLevel, "null", aPC);
    }

    public void setLevelsPerFeat(Integer newLevels) {
        if (newLevels < 0) {
            return;
        }
        this.levelsPerFeat = newLevels;
    }

    public final Integer getLevelsPerFeat() {
        if (this.levelsPerFeat == null) {
            this.levelsPerFeat = new Integer(-1);
        }
        return this.levelsPerFeat;
    }

    public List getKnownList() {
        if ("".equals(this.castAs) || this.getName().equals(this.castAs)) {
            return this.knownList;
        }
        PCClass aClass = Globals.getClassNamed(this.castAs);
        if (aClass != null) {
            return aClass.getKnownList();
        }
        return this.knownList;
    }

    public final Collection getSpecialtyKnownList() {
        return this.specialtyknownList;
    }

    public int getNumFromCastList(int iCasterLevel, int iSpellLevel) {
        int aNum = -1;
        if (!this.getCastMap().containsKey(String.valueOf(iCasterLevel))) {
            return aNum;
        }
        int iCount = 0;
        String aString = this.getCastStringForLevel(iCasterLevel);
        StringTokenizer aTok = new StringTokenizer(aString, ",");
        while (aTok.hasMoreTokens()) {
            aString = aTok.nextToken();
            if (iCount == iSpellLevel) {
                try {
                    aNum = Integer.parseInt(aString);
                }
                catch (NumberFormatException ex) {
                    aNum = 0;
                }
                return aNum;
            }
            ++iCount;
        }
        return aNum;
    }

    public final void setNumSpellsFromSpecialty(int anInt) {
        this.numSpellsFromSpecialty = anInt;
    }

    public String getBonusCastForLevelString(int pcLevel, int spellLevel, String bookName, PlayerCharacter aPC) {
        if (this.getCastForLevel(pcLevel, spellLevel, bookName, aPC) > 0) {
            if (this.specialtyList.size() > 0) {
                return "+1";
            }
            if (aPC.getCharacterDomainList().isEmpty()) {
                return "";
            }
            if (spellLevel > 0 && "DIVINE".equalsIgnoreCase(this.spellType)) {
                Iterator i = aPC.getCharacterDomainList().iterator();
                while (i.hasNext()) {
                    CharacterDomain aCD = (CharacterDomain)i.next();
                    if (!aCD.isFromPCClass(this.getName())) continue;
                    return "+1";
                }
            }
        }
        return "";
    }

    public int getCastForLevel(int pcLevel, int spellLevel, PlayerCharacter aPC) {
        return this.getCastForLevel(pcLevel, spellLevel, Globals.getDefaultSpellBook(), true, aPC);
    }

    public int getSpecialtyKnownForLevel(int pcLevel, int spellLevel, PlayerCharacter aPC) {
        int total = (int)aPC.getTotalBonusTo("SPECIALTYSPELLKNOWN", "CLASS." + this.getKeyName() + ";LEVEL." + spellLevel);
        total += (int)aPC.getTotalBonusTo("SPECIALTYSPELLKNOWN", "TYPE." + this.getSpellType() + ";LEVEL." + spellLevel);
        pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", this.name);
        pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType());
        int index = this.baseSpellIndex();
        if (index != -2) {
            PCStat aStat = (PCStat)aPC.getStatList().getStats().get(index);
            int maxSpellLevel = aPC.getVariableValue("MAXLEVELSTAT=" + aStat.getAbb(), "").intValue();
            if (spellLevel > maxSpellLevel) {
                return total;
            }
        }
        int x = spellLevel;
        if (!this.specialtyknownList.isEmpty()) {
            Iterator e = this.specialtyknownList.iterator();
            while (e.hasNext()) {
                String aString = (String)e.next();
                if (pcLevel == 1) {
                    StringTokenizer aTok = new StringTokenizer(aString, ",");
                    while (aTok.hasMoreTokens()) {
                        String spells = (String)aTok.nextElement();
                        int t = Integer.parseInt(spells);
                        if (x == 0) {
                            total += t;
                            break;
                        }
                        --x;
                    }
                }
                if (--pcLevel >= 1) continue;
            }
        }
        if (total > 0 && spellLevel > 0) {
            total += this.numSpellsFromSpecialty;
        }
        return total;
    }

    public void setSubClassName(String aString) {
        SubClass a;
        this.subClassName = aString;
        if (!aString.equals(this.name) && (a = this.getSubClassNamed(aString)) != null) {
            this.inheritAttributesFrom(a);
        }
        this.stableSpellKey = null;
        this.getSpellKey();
    }

    public String getSubClassName() {
        if (this.subClassName == null) {
            this.subClassName = "";
        }
        return this.subClassName;
    }

    public final SubClass getSubClassNamed(String arg) {
        if (this.subClassList == null) {
            return null;
        }
        Iterator i = this.subClassList.iterator();
        while (i.hasNext()) {
            SubClass a = (SubClass)i.next();
            if (!a.getName().equals(arg)) continue;
            return a;
        }
        return null;
    }

    public final void setSubClassString(String aString) {
        this.subClassString = aString;
    }

    public final String getSubClassString() {
        return this.subClassString;
    }

    public ArrayList getTemplates() {
        return this.templates;
    }

    public final Collection getUattList() {
        return this.uattList;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void setFeatAutos(int aLevel, String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        String prefix = aLevel + "|";
        while (aTok.hasMoreTokens()) {
            String fName = aTok.nextToken();
            if (fName.startsWith(".CLEAR")) {
                if (fName.startsWith(".CLEAR.")) {
                    String postFix = "|" + fName.substring(7);
                    for (int i = 0; i < 45; ++i) {
                        this.featAutos.remove(i + postFix);
                    }
                    continue;
                }
                this.featAutos.clear();
                continue;
            }
            this.getFeatAutos().add(prefix + fName);
        }
    }

    public void setHitPoint(int aLevel, Integer iRoll) {
        this.hitPointMap.put(Integer.toString(aLevel), iRoll);
    }

    public Integer getHitPoint(int j) {
        Integer aHP = (Integer)this.hitPointMap.get(Integer.toString(j));
        if (aHP == null) {
            return new Integer(0);
        }
        return aHP;
    }

    public final void setHitPointMap(HashMap newMap) {
        this.hitPointMap.clear();
        this.hitPointMap.putAll(newMap);
    }

    public final HashMap getHitPointMap() {
        return this.hitPointMap;
    }

    public void setLanguageBonus(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, ",", false);
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            if (".CLEAR".equals(token)) {
                this.getLanguageBonus().clear();
                continue;
            }
            Language aLang = Globals.getLanguageNamed(token);
            if (aLang == null) continue;
            this.getLanguageBonus().add(aLang);
        }
    }

    public String getUattForLevel(int aLevel) {
        String aString = "0";
        if (this.uattList.isEmpty()) {
            return "0";
        }
        Iterator e = this.uattList.iterator();
        while (e.hasNext()) {
            String bString = (String)e.next();
            if (aLevel == 1) {
                return bString;
            }
            if (--aLevel >= 1) continue;
            break;
        }
        return null;
    }

    public final void setVision(String aString, PlayerCharacter aPC) {
        if (".CLEAR".equals(aString)) {
            this.visionList = null;
            return;
        }
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        int lvl = Integer.parseInt(aTok.nextToken());
        String newString = aString.substring(aString.indexOf(124) + 1);
        if (this.visionList == null) {
            this.visionList = new ArrayList();
        }
        LevelProperty lp = new LevelProperty(lvl, newString);
        this.visionList.add(lp);
    }

    public final ArrayList getWeaponProfBonus() {
        return this.weaponProfBonus;
    }

    public boolean isAutoKnownSpell(String spellName, int spellLevel, PlayerCharacter aPC) {
        return this.isAutoKnownSpell(spellName, spellLevel, false, aPC);
    }

    public void setDR(String drString) {
        if (".CLEAR".equals(drString)) {
            this.DR = null;
            return;
        }
        StringTokenizer aTok = new StringTokenizer(drString, "|", false);
        int lvl = Integer.parseInt(aTok.nextToken());
        String tokenDrString = aTok.nextToken();
        if (".CLEAR".equals(tokenDrString)) {
            this.DR = null;
        } else {
            if (this.DR == null) {
                this.DR = new ArrayList();
            }
            LevelProperty lp = new LevelProperty(lvl, tokenDrString);
            this.DR.add(lp);
        }
    }

    public String getDR() {
        LevelProperty lp = null;
        if (this.DR != null) {
            int lvl = this.level;
            int x = this.DR.size();
            for (int i = 0; i < x && ((LevelProperty)this.DR.get(i)).getLevel() <= lvl; ++i) {
                lp = (LevelProperty)this.DR.get(i);
            }
        }
        if (lp != null) {
            return lp.getProperty();
        }
        return null;
    }

    public String getDRListString(int index, String delimiter) {
        if (this.DR != null && this.DR.size() > index) {
            LevelProperty lp = (LevelProperty)this.DR.get(index);
            return lp.getLevel() + delimiter + lp.getProperty();
        }
        return null;
    }

    public void setLevel(int newLevel, PlayerCharacter aPC) {
        int curLevel = this.level;
        if (newLevel >= 0) {
            this.level = newLevel;
        }
        if (this.level == 1) {
            this.chooseClassSkillList();
        }
        if (!aPC.isImporting()) {
            aPC.calcActiveBonuses();
            aPC.buildSpellLevelMap(newLevel);
        }
        if (this.level == 1 && !aPC.isImporting() && curLevel == 0) {
            this.checkForSubClass(aPC);
            this.getSpellKey();
        }
        if (this.knownSpellsList.size() > 0 && !aPC.isImporting() && aPC.getAutoSpells()) {
            List cspelllist = Globals.getSpellsIn(-1, this.getSpellKey(), "");
            if (cspelllist.isEmpty()) {
                return;
            }
            this.getStableCastForLevel(aPC);
            int _maxLevel = this.getMaxCastLevel();
            Iterator s = cspelllist.iterator();
            while (s.hasNext()) {
                Spell aSpell = (Spell)s.next();
                int[] spellLevels = aSpell.levelForKey(this.getSpellKey(), aPC);
                for (int si = 0; si < spellLevels.length; ++si) {
                    CharacterSpell cs;
                    int spellLevel = spellLevels[si];
                    if (!this.isAutoKnownSpell(aSpell.getKeyName(), spellLevel, true, aPC) || (cs = this.getCharacterSpellForSpell(aSpell, this)) != null) continue;
                    cs = new CharacterSpell(this, aSpell);
                    String val = this.castForLevelMap.get(String.valueOf(spellLevel)).toString();
                    boolean addIt = false;
                    if (val != null) {
                        boolean bl = addIt = Integer.parseInt(val) > 0;
                    }
                    if (!addIt) continue;
                    cs.addInfo(spellLevel, 1, Globals.getDefaultSpellBook());
                    this.addCharacterSpell(cs);
                }
            }
            if (!aPC.getCharacterDomainList().isEmpty()) {
                Iterator i = aPC.getCharacterDomainList().iterator();
                while (i.hasNext()) {
                    CharacterDomain aCD = (CharacterDomain)i.next();
                    if (aCD.getDomain() == null || !aCD.isFromPCClass(this.getName())) continue;
                    aCD.getDomain().addSpellsToClassForLevels(this, 0, _maxLevel);
                }
            }
        }
    }

    public int getMaxCastLevel() {
        int _maxLevel;
        for (_maxLevel = 0; _maxLevel < 45; ++_maxLevel) {
            String val = (String)this.castForLevelMap.get(String.valueOf(_maxLevel));
            if (val != null && Integer.parseInt(val) != 0) continue;
            --_maxLevel;
            break;
        }
        return _maxLevel;
    }

    public boolean isMonster() {
        if (this.monsterFlag != null) {
            return "YES".equals(this.monsterFlag);
        }
        if (this.getMyTypeCount() == 0) {
            return false;
        }
        Iterator i = this.getMyTypeIterator();
        while (i.hasNext()) {
            String aType = (String)i.next();
            ClassType aClassType = SettingsHandler.getGame().getClassTypeByName(aType);
            if (aClassType == null || !aClassType.isMonster()) continue;
            return true;
        }
        return false;
    }

    public void setNaturalAttacks(PObject obj, String aString) {
        StringTokenizer attackTok = new StringTokenizer(aString, "|", false);
        int lvl = Integer.parseInt(attackTok.nextToken());
        String sNat = attackTok.nextToken();
        LevelProperty lp = new LevelProperty(lvl, sNat);
        if (this.naturalWeapons == null) {
            this.naturalWeapons = new ArrayList();
        }
        this.naturalWeapons.add(lp);
    }

    public List getNaturalWeapons() {
        ArrayList<Equipment> tempArray = new ArrayList<Equipment>();
        if (this.naturalWeapons == null || this.naturalWeapons.isEmpty()) {
            return tempArray;
        }
        Iterator li = this.naturalWeapons.iterator();
        while (li.hasNext()) {
            LevelProperty lp = (LevelProperty)li.next();
            if (lp.getLevel() > this.level) continue;
            Equipment weapon = (Equipment)lp.getObject();
            tempArray.add(weapon);
            this.addWeaponProfAutos(weapon.getName());
        }
        return tempArray;
    }

    public ArrayList getWeaponProfAutos() {
        ArrayList list = super.getWeaponProfAutos();
        if (this.naturalWeapons != null) {
            Iterator li = this.naturalWeapons.iterator();
            while (li.hasNext()) {
                LevelProperty lp = (LevelProperty)li.next();
                if (lp.getLevel() > this.level) continue;
                Equipment weapon = (Equipment)lp.getObject();
                list.add(weapon.getSimpleName());
            }
        }
        return list;
    }

    public boolean isPrestige() {
        Logging.errorPrint("IsPrestige should be deprecated.");
        return this.isType("PRESTIGE");
    }

    public boolean isQualified(PlayerCharacter aPC) {
        if (aPC == null) {
            return false;
        }
        if (this.isMonster() && this.preRaceType != null && !PCClass.contains(aPC.getCritterType(), this.preRaceType)) {
            return false;
        }
        return this.canBePrestige(aPC);
    }

    public void setSR(String srString) {
        if (".CLEAR".equals(srString)) {
            this.SR = null;
            return;
        }
        StringTokenizer aTok = new StringTokenizer(srString, "|", false);
        int lvl = Integer.parseInt(aTok.nextToken());
        String tokenSrString = aTok.nextToken();
        if (".CLEAR".equals(tokenSrString)) {
            this.SR = null;
        } else {
            if (this.SR == null) {
                this.SR = new ArrayList();
            }
            LevelProperty lp = new LevelProperty(lvl, tokenSrString);
            this.SR.add(lp);
        }
    }

    public String getSRFormula() {
        LevelProperty lp = null;
        if (this.SR != null) {
            int lvl = this.level;
            int x = this.SR.size();
            for (int i = 0; i < x && ((LevelProperty)this.SR.get(i)).getLevel() <= lvl; ++i) {
                lp = (LevelProperty)this.SR.get(i);
            }
        }
        if (lp != null) {
            return lp.getProperty();
        }
        return null;
    }

    public String getSRListString(int index, String delimiter) {
        if (this.SR != null && this.SR.size() > index) {
            LevelProperty lp = (LevelProperty)this.SR.get(index);
            return lp.getLevel() + delimiter + lp.getProperty();
        }
        return null;
    }

    public final void setSpellBookUsed(boolean argUseBook) {
        this.usesSpellbook = argUseBook;
    }

    public final boolean getSpellBookUsed() {
        return this.usesSpellbook;
    }

    public void setCRFormula(String argCRFormula) {
        this.CRFormula = argCRFormula;
    }

    public void setMonsterFlag(String monster) {
        this.monsterFlag = monster;
    }

    public String getPCCText(PlayerCharacter aPC) {
        ArrayList specialAbilityList;
        int x;
        List spellList;
        Object obj;
        String c;
        int x2;
        StringBuffer pccTxt = new StringBuffer(200);
        pccTxt.append("CLASS:").append(this.getName());
        pccTxt.append(super.getPCCText(false, aPC));
        pccTxt.append("\tABB:").append(this.getAbbrev());
        PCClass.checkAdd(pccTxt, "", "EXCLASS:", this.exClass);
        PCClass.checkAdd(pccTxt, "", "EXCHANGELEVEL:", this.levelExchange);
        if (this.hasSubClass) {
            pccTxt.append("\tHASSUBCLASS:Y");
        }
        pccTxt.append("\tHD:").append(this.hitDie);
        PCClass.checkAdd(pccTxt, "ANY", "DEITY:", CoreUtility.join((Collection)this.deityList, '|'));
        pccTxt.append("\tATTACKCYCLE:").append(this.attackCycle);
        PCClass.checkAdd(pccTxt, "", "CASTAS:", this.castAs);
        PCClass.checkAdd(pccTxt, "None", "PROHIBITED:", this.prohibitedString);
        PCClass.checkAdd(pccTxt, "None", "SPELLSTAT:", this.spellBaseStat);
        PCClass.checkAdd(pccTxt, "None", "SPELLTYPE:", this.spellType);
        if (this.usesSpellbook) {
            pccTxt.append("\tSPELLBOOK:Y");
        }
        if (this.skillPoints != 0) {
            pccTxt.append("\tSTARTSKILLPTS:").append(this.skillPoints);
        }
        if (!this.visible) {
            pccTxt.append("\tVISIBLE:N");
        }
        if (this.initialFeats != 0) {
            pccTxt.append("\tXTRAFEATS:").append(this.initialFeats);
        }
        if (this.levelsPerFeat != null) {
            pccTxt.append("\tLEVELSPERFEAT:").append(this.levelsPerFeat);
        }
        if (this.maxLevel != 20) {
            pccTxt.append("\tMAXLEVEL:").append(this.maxLevel);
        }
        if (!this.memorizeSpells) {
            pccTxt.append("\tMEMORIZE:N");
        }
        if (this.multiPreReqs) {
            pccTxt.append("\tMULTIPREREQS:Y");
        }
        if (!this.knownSpellsList.isEmpty()) {
            pccTxt.append("\tKNOWNSPELLS:");
            boolean flag = false;
            Iterator e = this.knownSpellsList.iterator();
            while (e.hasNext()) {
                if (flag) {
                    pccTxt.append('|');
                }
                flag = true;
                pccTxt.append((String)e.next());
            }
        }
        if (this.itemCreationMultiplier.length() != 0) {
            pccTxt.append("\tITEMCREATE:").append(this.itemCreationMultiplier);
        }
        if (this.classSpellString != null) {
            pccTxt.append("\tSPELLLIST:").append(this.classSpellString).append('\t');
        }
        PCClass.checkAdd(pccTxt, "", "SPECIALS:", this.specialsString);
        PCClass.checkAdd(pccTxt, "", "SKILLLIST:", this.classSkillString);
        if (this.weaponProfBonus.size() != 0) {
            pccTxt.append("\tWEAPONBONUS:");
            for (int x3 = 0; x3 < this.weaponProfBonus.size(); ++x3) {
                if (x3 != 0) {
                    pccTxt.append('|');
                }
                pccTxt.append(this.weaponProfBonus.get(x3));
            }
        }
        String lineSep = System.getProperty("line.separator");
        if (this.regionString != null && !this.regionString.startsWith("0|")) {
            int x4 = this.regionString.indexOf(124);
            pccTxt.append(lineSep).append(this.regionString.substring(0, x4)).append("\tREGION:").append(this.regionString.substring(x4 + 1));
        }
        if (this.kits != null) {
            for (int iKit = 0; iKit < this.kits.size(); ++iKit) {
                String kitString = (String)this.kits.get(iKit);
                int x5 = kitString.indexOf(124);
                if (x5 < 0) continue;
                pccTxt.append(lineSep + kitString.substring(0, x5)).append("\tKIT:").append(kitString.substring(x5 + 1));
            }
        }
        for (x2 = 0; x2 < this.specialtyknownList.size(); ++x2) {
            pccTxt.append("\tSPECIALTYKNOWN:").append(this.specialtyknownList.get(x2));
        }
        pccTxt.append(lineSep);
        for (x2 = 0; x2 < this.castMap.size(); ++x2) {
            if (!this.castMap.containsKey(String.valueOf(x2))) continue;
            c = (String)this.castMap.get(String.valueOf(x2));
            String l = lineSep + String.valueOf(x2) + "\tCAST:";
            PCClass.checkAdd(pccTxt, "0", l, c);
        }
        for (x2 = 0; x2 < this.knownList.size(); ++x2) {
            c = (String)this.knownList.get(x2);
            String l = lineSep + String.valueOf(x2 + 1) + "\tKNOWN:";
            PCClass.checkAdd(pccTxt, "0", l, c);
        }
        if (this.DR != null) {
            Iterator li = this.DR.iterator();
            while (li.hasNext()) {
                obj = li.next();
                if (!(obj instanceof LevelProperty)) continue;
                pccTxt.append(lineSep).append(((LevelProperty)obj).getLevel()).append("\tDR:").append(((LevelProperty)obj).getProperty());
            }
        }
        if (this.SR != null) {
            Iterator li = this.SR.iterator();
            while (li.hasNext()) {
                obj = li.next();
                if (!(obj instanceof LevelProperty)) continue;
                pccTxt.append(lineSep).append(((LevelProperty)obj).getLevel()).append("\tSR:").append(((LevelProperty)obj).getProperty());
            }
        }
        if ((spellList = this.getSpellList()) != null) {
            Iterator li = spellList.iterator();
            while (li.hasNext()) {
                Object obj2 = li.next();
                if (!(obj2 instanceof LevelProperty)) continue;
                pccTxt.append(lineSep).append(((LevelProperty)obj2).getLevel()).append("\tSPELL:").append(((LevelProperty)obj2).getProperty());
            }
        }
        for (x = 0; x < this.templates.size(); ++x) {
            String c2 = (String)this.templates.get(x);
            int y = c2.indexOf(124);
            pccTxt.append(lineSep).append(c2.substring(0, y)).append("\tTEMPLATE:").append(c2.substring(y + 1));
        }
        for (x = 0; x < this.getBonusList().size(); ++x) {
            BonusObj aBonus = (BonusObj)this.getBonusList().get(x);
            String bonusString = aBonus.toString();
            int levelEnd = bonusString.indexOf(124);
            String maybeLevel = bonusString.substring(0, levelEnd);
            pccTxt.append(lineSep);
            if (CoreUtility.isIntegerString(maybeLevel)) {
                pccTxt.append(maybeLevel);
                bonusString = bonusString.substring(levelEnd + 1);
            } else {
                pccTxt.append("0");
            }
            pccTxt.append("\tBONUS:").append(bonusString);
        }
        for (x = 0; x < this.getVariableCount(); ++x) {
            String c3 = this.getVariableDefinition(x);
            int y = c3.indexOf(124);
            pccTxt.append(lineSep).append(c3.substring(0, y)).append("\tDEFINE:").append(c3.substring(y + 1));
        }
        if (this.levelAbilityList != null && !this.levelAbilityList.isEmpty()) {
            Iterator e = this.levelAbilityList.iterator();
            while (e.hasNext()) {
                LevelAbility ability = (LevelAbility)e.next();
                pccTxt.append(lineSep).append(String.valueOf(ability.level())).append("\tADD:").append(ability.getList());
            }
        }
        if ((specialAbilityList = this.getSpecialAbilityList()) != null && specialAbilityList.size() != 0) {
            Iterator se = specialAbilityList.iterator();
            while (se.hasNext()) {
                SpecialAbility sa = (SpecialAbility)se.next();
                String src = sa.getSASource();
                String lev = src.substring(src.lastIndexOf(124) + 1);
                pccTxt.append(lineSep).append(lev).append("\tSA:").append(sa.toString());
            }
        }
        if (this.addDomains != null && this.addDomains.size() != 0) {
            PCClass.buildPccText(pccTxt, this.addDomains.iterator(), "|", "\tADDDOMAINS:", lineSep);
        }
        PCClass.buildPccText(pccTxt, this.domainList.iterator(), "|", "\tDOMAIN:", lineSep);
        PCClass.buildPccText(pccTxt, this.featList.iterator(), ":", "\tFEAT:", lineSep);
        PCClass.buildPccText(pccTxt, this.featAutos.iterator(), "|", "\tFEATAUTO:", lineSep);
        if (this.uattList != null && this.uattList.size() != 0) {
            for (int x6 = 0; x6 < this.uattList.size(); ++x6) {
                pccTxt.append(lineSep).append(String.valueOf(x6 + 1)).append("\tUATT:").append((String)this.uattList.get(x6));
            }
        }
        if (this.udamList != null && this.udamList.size() != 0) {
            for (int x7 = 0; x7 < this.udamList.size(); ++x7) {
                pccTxt.append(lineSep).append(String.valueOf(x7 + 1)).append("\tUDAM:").append(this.udamList.get(x7));
            }
        }
        if (this.umultList != null && this.umultList.size() != 0) {
            PCClass.buildPccText(pccTxt, this.umultList.iterator(), "|", "\tUMULT:", lineSep);
        }
        return pccTxt.toString();
    }

    public List getVirtualFeatList(int aLevel) {
        LinkedList aList = new LinkedList();
        for (int i = -9; i <= aLevel; ++i) {
            if (!this.vFeatMap.containsKey(String.valueOf(i))) continue;
            aList.addAll((List)this.vFeatMap.get(String.valueOf(i)));
        }
        return aList;
    }

    public Map getVision(PlayerCharacter aPC) {
        LevelProperty lp = null;
        if (this.visionList != null) {
            for (int i = 0; i < this.visionList.size(); ++i) {
                if (((LevelProperty)this.visionList.get(i)).getLevel() > this.level) continue;
                lp = (LevelProperty)this.visionList.get(i);
                String aString = lp.getProperty();
                super.setVision(aString, aPC);
            }
        }
        return super.getVision(aPC);
    }

    public void setWeaponProfBonus(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        while (aTok.hasMoreTokens()) {
            this.getWeaponProfBonus().add(aTok.nextToken());
        }
    }

    public void setXPPenalty(String argXPPenalty) {
        this.XPPenalty = argXPPenalty;
    }

    public void activateBonuses(PlayerCharacter aPC) {
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (aBonus.getPCLevel() > this.level) continue;
            if (aBonus.hasPreReqs()) {
                if (PrereqHandler.passesAll(aBonus.getPrereqList(), aPC, this)) {
                    aBonus.setApplied(true);
                    continue;
                }
                aBonus.setApplied(false);
                continue;
            }
            aBonus.setApplied(true);
        }
    }

    public void addClassSpellList(String tok) {
        if (this.classSpellList == null) {
            this.newClassSpellList();
        }
        this.classSpellList.add(tok);
        this.classSpellString = null;
        this.stableSpellKey = null;
    }

    public void addDomainList(String domainItem) {
        this.domainList.add(domainItem);
    }

    public final void addSubClass(SubClass sClass) {
        if (this.subClassList == null) {
            this.subClassList = new ArrayList();
        }
        sClass.setHitPointMap((HashMap)this.getHitPointMap().clone());
        sClass.setHitDie(this.hitDie);
        this.subClassList.add(sClass);
    }

    public void addFeatList(int aLevel, String aFeatList) {
        String aString = aLevel + ":" + aFeatList;
        this.featList.add(aString);
    }

    public void addKnown(int iLevel, String aString) {
        if (iLevel > this.maxKnownLevel) {
            this.maxKnownLevel = iLevel;
        }
        while (this.knownList.size() < iLevel - 1) {
            this.knownList.add("0");
        }
        if (this.knownList.size() >= iLevel) {
            this.knownList.set(iLevel - 1, aString);
        } else {
            this.knownList.add(aString);
        }
    }

    public void addKnownSpellsList(String aString) {
        StringTokenizer aTok;
        if (aString.startsWith("CLEAR.")) {
            this.knownSpellsList.clear();
            if ("CLEAR.".equals(aString)) {
                return;
            }
            aTok = new StringTokenizer(aString.substring(6), "|", false);
        } else {
            aTok = new StringTokenizer(aString, "|", false);
        }
        while (aTok.hasMoreTokens()) {
            this.knownSpellsList.add(aTok.nextToken());
        }
    }

    public void addLevel(boolean levelMax, PlayerCharacter aPC) {
        this.addLevel(levelMax, false, aPC, true);
    }

    public void addSkillToList(String aString) {
        if (!this.skillList.contains(aString)) {
            this.skillList.add(aString);
        }
    }

    public void addTemplate(String template) {
        this.templates.add(template);
    }

    public void addVirtualFeats(int aLevel, List vList) {
        String levelString = String.valueOf(aLevel);
        List vFeatsAtLevel = null;
        if (this.vFeatMap.containsKey(levelString)) {
            vFeatsAtLevel = (List)this.vFeatMap.get(levelString);
        } else {
            vFeatsAtLevel = new ArrayList();
            this.vFeatMap.put(levelString, vFeatsAtLevel);
        }
        vFeatsAtLevel.addAll(vList);
        super.addVirtualFeats(vList);
    }

    public int attackCycle(int index) {
        String aKey = null;
        if (index == 0) {
            aKey = "BAB";
        } else if (index == 1) {
            aKey = "RAB";
        } else if (index == 2) {
            aKey = "UAB";
        }
        String aString = (String)this.attackCycleMap.get(aKey);
        if (aString != null) {
            return Integer.parseInt(aString);
        }
        return SettingsHandler.getGame().getBabAttCyc();
    }

    public int baseAttackBonus(PlayerCharacter aPC) {
        if (this.level == 0) {
            return 0;
        }
        int i = (int)this.getBonusTo("COMBAT", "BAB", aPC);
        return i;
    }

    public int baseSpellIndex() {
        String tmpSpellBaseStat = this.getBonusSpellBaseStat();
        if (tmpSpellBaseStat.equals("None")) {
            tmpSpellBaseStat = this.getSpellBaseStat();
        }
        return "SPELL".equals(tmpSpellBaseStat) ? -2 : SettingsHandler.getGame().getStatFromAbbrev(tmpSpellBaseStat);
    }

    public int calcCR(PlayerCharacter aPC) {
        String wCRFormula = "0";
        if (this.CRFormula != null) {
            wCRFormula = this.CRFormula;
        } else {
            Iterator i = this.getMyTypeIterator();
            while (i.hasNext()) {
                String aType = (String)i.next();
                ClassType aClassType = SettingsHandler.getGame().getClassTypeByName(aType);
                if (aClassType == null || "0".equals(aClassType.getCRFormula())) continue;
                wCRFormula = aClassType.getCRFormula();
            }
        }
        return aPC.getVariableValue(wCRFormula, "CLASS:" + this.getName()).intValue();
    }

    public String classLevelString() {
        StringBuffer aString = new StringBuffer();
        if (!this.getSubClassName().equals("None") && !"".equals(this.getSubClassName())) {
            aString.append(this.getSubClassName());
        } else {
            aString.append(this.getName());
        }
        aString = aString.append(' ').append(this.level);
        return aString.toString();
    }

    public Object clone() {
        PCClass aClass = null;
        try {
            aClass = (PCClass)super.clone();
            aClass.setSubClassName(this.getSubClassName());
            aClass.setProhibitedString(this.getProhibitedString());
            aClass.setHitDie(this.hitDie);
            aClass.setSkillPoints(this.skillPoints);
            aClass.setInitialFeats(this.initialFeats);
            aClass.setSpellBaseStat(this.spellBaseStat);
            aClass.setBonusSpellBaseStat(this.bonusSpellBaseStat);
            aClass.setSpellType(this.spellType);
            aClass.setAttackBonusType(this.attackBonusType);
            aClass.specialtyknownList = (ArrayList)this.specialtyknownList.clone();
            aClass.knownList = (ArrayList)this.knownList.clone();
            aClass.castMap = new HashMap(this.castMap);
            aClass.uattList = (ArrayList)this.uattList.clone();
            aClass.acList = (ArrayList)this.acList.clone();
            aClass.languageBonus = (TreeSet)this.languageBonus.clone();
            aClass.weaponProfBonus = (ArrayList)this.weaponProfBonus.clone();
            aClass.featList = (ArrayList)this.featList.clone();
            aClass.vFeatMap = new HashMap(this.vFeatMap);
            aClass.hitDieLockMap = new HashMap(this.hitDieLockMap);
            aClass.featAutos = (ArrayList)this.featAutos.clone();
            aClass.skillList = new LinkedList();
            if (this.DR != null) {
                aClass.DR = (ArrayList)this.DR.clone();
            }
            aClass.classSkillString = this.classSkillString;
            aClass.classSkillList = null;
            aClass.classSpellString = this.classSpellString;
            aClass.classSpellList = null;
            aClass.stableSpellKey = null;
            aClass.setSpecialsString(this.specialsString);
            aClass.setExClass(this.exClass);
            aClass.setLevelExchange(this.levelExchange);
            aClass.maxCastLevel = this.maxCastLevel;
            aClass.maxKnownLevel = this.maxKnownLevel;
            aClass.abbrev = this.abbrev;
            aClass.memorizeSpells = this.memorizeSpells;
            aClass.multiPreReqs = this.multiPreReqs;
            aClass.isSpecified = this.isSpecified;
            aClass.deityList = (LinkedList)this.deityList.clone();
            aClass.maxLevel = this.maxLevel;
            aClass.knownSpellsList = (ArrayList)this.knownSpellsList.clone();
            aClass.attackCycle = this.attackCycle;
            aClass.attackCycleMap = new HashMap(this.attackCycleMap);
            aClass.castAs = this.castAs;
            aClass.preRaceType = this.preRaceType;
            aClass.modToSkills = this.modToSkills;
            aClass.levelsPerFeat = this.levelsPerFeat;
            aClass.initMod = this.initMod;
            aClass.specialtyList = (ArrayList)this.specialtyList.clone();
            aClass.domainList = (ArrayList)this.domainList.clone();
            aClass.addDomains = (ArrayList)this.addDomains.clone();
            aClass.hitPointMap = new HashMap(this.hitPointMap);
            aClass.hasSubClass = this.hasSubClass;
            aClass.subClassList = this.subClassList;
            if (this.naturalWeapons != null) {
                aClass.naturalWeapons = (ArrayList)this.naturalWeapons.clone();
            }
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aClass;
    }

    public final boolean hasSubClass() {
        return this.hasSubClass;
    }

    public final boolean multiPreReqs() {
        return this.multiPreReqs;
    }

    public final String toString() {
        return this.name;
    }

    public void setName(String newName) {
        super.setName(newName);
        int i = 3;
        if ("".equals(this.abbrev)) {
            if (newName.length() < 3) {
                i = newName.length();
            }
            this.abbrev = newName.substring(0, i);
        }
        this.stableSpellKey = null;
        this.getSpellKey();
    }

    public boolean isSpecialtySpell(Spell aSpell) {
        ArrayList aList = (ArrayList)this.getSpecialtyList();
        if (aList == null || aList.size() == 0) {
            return false;
        }
        return aSpell.descriptorListContains(aList) || aSpell.schoolContains(aList) || aSpell.subschoolContains(aList);
    }

    public ArrayList getSubClassList() {
        return this.subClassList;
    }

    public double calcBonusFrom(BonusObj aBonus, Object anObj) {
        double retVal = 0.0;
        int iTimes = 1;
        String aType = aBonus.getTypeOfBonus();
        if ("VAR".equals(aType)) {
            iTimes = Math.max(1, this.getAssociatedCount());
            if (this.choiceString.startsWith("SALIST|") && this.choiceString.indexOf("|VAR|") >= 0) {
                iTimes = 1;
            }
        }
        String bString = aBonus.toString();
        if (this.getAssociatedCount() != 0) {
            int span = 4;
            int idx = bString.indexOf("%VAR");
            if (idx == -1) {
                idx = bString.indexOf("%LIST");
                span = 5;
            }
            if (idx >= 0) {
                String firstPart = bString.substring(0, idx);
                String secondPart = bString.substring(idx + span);
                for (int i = 1; i < this.getAssociatedCount(); ++i) {
                    String xString = firstPart + this.getAssociated(i) + secondPart;
                    retVal += this.calcPartialBonus(xString, iTimes, aBonus, anObj);
                }
                bString = firstPart + this.getAssociated(0) + secondPart;
            }
        }
        return retVal += this.calcPartialBonus(bString, iTimes, aBonus, anObj);
    }

    public double calcBonusFrom(BonusObj aBonus, Object anObj, String listString) {
        return this.calcBonusFrom(aBonus, anObj);
    }

    public boolean hasClassSkillList(String aString) {
        if (this.classSkillList == null || this.classSkillList.isEmpty()) {
            return false;
        }
        Iterator i = this.classSkillList.iterator();
        while (i.hasNext()) {
            String aClassName = i.next().toString();
            PCClass aClass = Globals.getClassNamed(aClassName);
            if (aClass == null || !aClass.hasCSkill(aString)) continue;
            return true;
        }
        return false;
    }

    public boolean hasKnownSpells(PlayerCharacter aPC) {
        for (int i = 0; i <= 9; ++i) {
            if (this.getKnownForLevel(this.getLevel(), i, aPC) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSkill(String aString) {
        Iterator p = this.skillList.iterator();
        while (p.hasNext()) {
            String aSkillName = p.next().toString();
            if (!aSkillName.equalsIgnoreCase(aString)) continue;
            return true;
        }
        return false;
    }

    public boolean hasXPPenalty() {
        String wXPPenalty = "YES";
        if (this.XPPenalty != null) {
            return "YES".equals(this.XPPenalty);
        }
        Iterator i = this.getMyTypeIterator();
        while (i.hasNext()) {
            String aType = (String)i.next();
            ClassType aClassType = SettingsHandler.getGame().getClassTypeByName(aType);
            if (aClassType == null || aClassType.getXPPenalty()) continue;
            wXPPenalty = "NO";
        }
        return "YES".equals(wXPPenalty);
    }

    public int hitPoints(int iConMod) {
        int total = 0;
        for (int i = 0; i <= this.getLevel(); ++i) {
            if (this.getHitPoint(i) <= 0) continue;
            int iHp = this.getHitPoint(i) + iConMod;
            if (iHp < 1) {
                iHp = 1;
            }
            total += iHp;
        }
        return total;
    }

    public int recalcSkillPointMod(PlayerCharacter aPC, int total) {
        int spMod = this.isMonster() && aPC.isMonsterDefault() ? this.getMonsterSkillPointMod(aPC, total) : this.getNonMonsterSkillPointMod(aPC, total);
        return spMod;
    }

    public final Integer skillPool() {
        return this.skillPool;
    }

    public void setSkillPool(int i) {
        this.skillPool = new Integer(i);
    }

    public String specialsString() {
        return this.specialsString;
    }

    public boolean zeroCastSpells() {
        Iterator e = this.getCastMap().keySet().iterator();
        while (e.hasNext()) {
            String aKey = (String)e.next();
            String aVal = (String)this.getCastMap().get(aKey);
            StringTokenizer aTok = new StringTokenizer(aVal, ",");
            int numSpells = 0;
            while (aTok.hasMoreTokens()) {
                String spellNum = aTok.nextToken();
                try {
                    numSpells = Integer.parseInt(spellNum);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (numSpells <= 0) continue;
                return false;
            }
        }
        return true;
    }

    protected List addSpecialAbilitiesToList(List aList, PlayerCharacter aPC) {
        ArrayList specialAbilityList = this.getSpecialAbilityList();
        if (specialAbilityList == null || specialAbilityList.isEmpty()) {
            return aList;
        }
        ArrayList<SpecialAbility> bList = new ArrayList<SpecialAbility>();
        Iterator i = specialAbilityList.iterator();
        while (i.hasNext()) {
            SpecialAbility sa = (SpecialAbility)i.next();
            if (!sa.pcQualifiesFor(aPC)) continue;
            if (sa.getName().startsWith(".CLEAR")) {
                if (".CLEARALL".equals(sa.getName())) {
                    bList.clear();
                    continue;
                }
                if (!sa.getName().startsWith(".CLEAR.")) continue;
                String saToRemove = sa.getName().substring(7);
                for (int itIdx = bList.size() - 1; itIdx >= 0; --itIdx) {
                    String saName = ((SpecialAbility)bList.get(itIdx)).getName();
                    if (saName.equals(saToRemove)) {
                        bList.remove(itIdx);
                        continue;
                    }
                    if (saName.indexOf(40) < 0 || !saName.substring(0, saName.indexOf(40)).trim().equals(saToRemove)) continue;
                    bList.remove(itIdx);
                }
                continue;
            }
            bList.add(sa);
        }
        aList.addAll(bList);
        return aList;
    }

    protected void doGlobalTypeUpdate(String aString) {
        if (!Globals.getPCClassTypeList().contains(aString)) {
            Globals.getPCClassTypeList().add(aString);
        }
    }

    final List getClassSkillList() {
        return this.classSkillList;
    }

    int getKnownForLevel(int pcLevel, int spellLevel, String bookName, PlayerCharacter aPC) {
        int maxSpellLevel;
        int total = 0;
        int stat = 0;
        String classKeyName = "CLASS." + this.getKeyName();
        String levelSpellLevel = ";LEVEL." + spellLevel;
        String allSpellLevel = ";LEVEL.All";
        pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", this.name);
        if (this.getCastMap().size() > 0 && this.getNumFromCastList(pcLevel += (int)aPC.getTotalBonusTo("PCLEVEL", "TYPE." + this.getSpellType()), spellLevel) < 0) {
            return 0;
        }
        if (pcLevel > this.maxKnownLevel) {
            pcLevel = this.maxKnownLevel;
        }
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", classKeyName + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", "TYPE." + this.getSpellType() + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", "CLASS.Any" + levelSpellLevel);
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", classKeyName + ";LEVEL.All");
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", "TYPE." + this.getSpellType() + ";LEVEL.All");
        total += (int)aPC.getTotalBonusTo("SPELLKNOWN", "CLASS.Any;LEVEL.All");
        int index = this.baseSpellIndex();
        if (index != -2 && index >= 0 && index < aPC.getStatList().getStats().size()) {
            PCStat aStat = (PCStat)aPC.getStatList().getStats().get(index);
            stat = aPC.getStatList().getTotalStatFor(aStat.getAbb());
        }
        String statString = "None";
        if (index >= 0) {
            statString = SettingsHandler.getGame().s_ATTRIBSHORT[index];
        }
        int bonusStat = (int)aPC.getTotalBonusTo("STAT", "KNOWN." + statString) + (int)aPC.getTotalBonusTo("STAT", "BASESPELLKNOWNSTAT") + (int)aPC.getTotalBonusTo("STAT", "BASESPELLKNOWNSTAT;CLASS." + this.name);
        if (index > -2 && (maxSpellLevel = aPC.getVariableValue("MAXLEVELSTAT=" + statString, "").intValue()) + bonusStat < spellLevel) {
            return total;
        }
        stat += bonusStat;
        int mult = (int)aPC.getTotalBonusTo("SPELLKNOWNMULT", classKeyName + levelSpellLevel);
        if ((mult += (int)aPC.getTotalBonusTo("SPELLKNOWNMULT", "TYPE." + this.getSpellType() + levelSpellLevel)) < 1) {
            mult = 1;
        }
        boolean psiSpecialty = false;
        if (!this.getKnownList().isEmpty()) {
            if (pcLevel > this.getKnownList().size()) {
                return 0;
            }
            String aString = (String)this.getKnownList().get(pcLevel - 1);
            StringTokenizer aTok = new StringTokenizer(aString, ",");
            int iCount = 0;
            while (aTok.hasMoreTokens()) {
                String spells = aTok.nextToken();
                if (iCount == spellLevel) {
                    if (spells.endsWith("+d")) {
                        psiSpecialty = true;
                        if (spells.length() > 1) {
                            spells = spells.substring(0, spells.length() - 2);
                        }
                    }
                    int t = Integer.parseInt(spells);
                    total += t * mult;
                    Object bonusSpell = Globals.getBonusSpellMap().get(String.valueOf(spellLevel));
                    if (Globals.checkRule("BONUSSPELLKNOWN") && bonusSpell != null && !bonusSpell.equals("0|0")) {
                        StringTokenizer s = new StringTokenizer(bonusSpell.toString(), "|");
                        int base = Integer.parseInt(s.nextToken());
                        int range = Integer.parseInt(s.nextToken());
                        if (stat >= base) {
                            total += Math.max(0, (stat - base + range) / range);
                        }
                    }
                    if (psiSpecialty) {
                        total += this.numSpellsFromSpecialty;
                    }
                }
                ++iCount;
            }
        }
        if (total > 0 && spellLevel > 0 && !psiSpecialty) {
            total += this.numSpellsFromSpecialty;
        }
        return total;
    }

    final Set getLanguageBonus() {
        return this.languageBonus;
    }

    final int getNumSpellsFromSpecialty() {
        return this.numSpellsFromSpecialty;
    }

    boolean isNPC() {
        Logging.errorPrint("IsNPC should be deprecated.");
        return this.isType("NPC");
    }

    boolean isPC() {
        Logging.errorPrint("IsPC should be deprecated.");
        return this.getMyTypeCount() == 0 || this.isType("PC");
    }

    boolean isProhibited(Spell aSpell, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(this.prohibitedString, ",", false);
        if (!PrereqHandler.passesAll(aSpell.getPreReqList(), aPC, this)) {
            return true;
        }
        while (aTok.hasMoreTokens()) {
            String a = aTok.nextToken();
            if (!aSpell.getSchools().contains(a) && !aSpell.getSubschools().contains(a)) continue;
            return true;
        }
        return false;
    }

    String getUdamForLevel(int aLevel, boolean includeCrit, boolean includeStrBonus, PlayerCharacter aPC) {
        String dString;
        CharSequence aString;
        int iLevel = aLevel += (int)aPC.getTotalBonusTo("UDAM", "CLASS." + this.name);
        Equipment eq = EquipmentList.getEquipmentKeyed("Unarmed Strike");
        String aDamage = eq != null ? eq.getDamage(aPC) : "1d3";
        int iSize = Globals.sizeInt(aPC.getSize());
        aDamage = Globals.adjustDamage(aDamage, SystemCollections.getDefaultSizeAdjustment().getAbbreviation(), SystemCollections.getSizeAdjustmentAtIndex(iSize).getAbbreviation());
        this.udamList = Globals.getClassNamed(this.name).getUdamList();
        if (this.udamList != null && !this.udamList.isEmpty()) {
            if (this.udamList.size() == 1 && (((String)(aString = this.udamList.get(0).toString())).startsWith("CLASS=") || ((String)aString).startsWith("CLASS."))) {
                PCClass aClass = Globals.getClassNamed(((String)aString).substring(6));
                if (aClass != null) {
                    return aClass.getUdamForLevel(aLevel, includeCrit, includeStrBonus, aPC);
                }
                Logging.errorPrint(this.name + " refers to " + ((String)aString).substring(6) + " which isn't loaded.");
                return aDamage;
            }
            if (aLevel > this.udamList.size()) {
                iLevel = this.udamList.size();
            }
            StringTokenizer aTok = new StringTokenizer(this.udamList.get(Math.max(iLevel - 1, 0)).toString(), ",", false);
            while (iSize > -1 && aTok.hasMoreTokens()) {
                aDamage = aTok.nextToken();
                if (iSize == 0) break;
                --iSize;
            }
        }
        aString = new StringBuffer(aDamage);
        int b = (int)aPC.getStatBonusTo("DAMAGE", "TYPE.MELEE");
        if (includeStrBonus && (b += (int)aPC.getStatBonusTo("DAMAGE", "TYPE=MELEE")) > 0) {
            ((StringBuffer)aString).append('+');
        }
        if (includeStrBonus && b != 0) {
            ((StringBuffer)aString).append(String.valueOf(b));
        }
        if (includeCrit && !"0".equals(dString = this.getUMultForLevel(aLevel))) {
            ((StringBuffer)aString).append("(x").append(dString).append(')');
        }
        return ((StringBuffer)aString).toString();
    }

    void addInitMod(int initModDelta) {
        this.initMod += initModDelta;
    }

    boolean addLevel(boolean argLevelMax, boolean bSilent, PlayerCharacter aPC, boolean isLoading) {
        int newLevel = this.level + 1;
        boolean levelMax = argLevelMax;
        ++this.level;
        if (!isLoading) {
            boolean doReturn = false;
            if (!PrereqHandler.passesAll(this.getPreReqList(), aPC, this)) {
                doReturn = true;
                if (!bSilent) {
                    ShowMessageDelegate.showMessageDialog("This character does not qualify for level " + this.level, "PCGen", MessageType.ERROR);
                }
            }
            --this.level;
            if (doReturn) {
                return false;
            }
        }
        if (this.isMonster()) {
            levelMax = false;
        }
        if (newLevel > this.maxLevel && levelMax) {
            if (!bSilent) {
                ShowMessageDelegate.showMessageDialog("This class cannot be raised above level " + Integer.toString(this.maxLevel), "PCGen", MessageType.ERROR);
            }
            return false;
        }
        int total = aPC.getTotalLevels();
        if (total == 0) {
            aPC.setFeats(aPC.getInitialFeats());
        }
        this.setLevel(newLevel, aPC);
        List templateList = this.getTemplates(aPC.isImporting(), aPC);
        for (int x = 0; x < templateList.size(); ++x) {
            aPC.addTemplateNamed((String)templateList.get(x));
        }
        int dnum = aPC.getMaxCharacterDomains(this, aPC) - aPC.getCharacterDomainUsed();
        if (!aPC.hasDomainSource("PCClass", this.getName(), newLevel) && dnum > 0) {
            aPC.addDomainSource("PCClass", this.getName(), newLevel, dnum);
        }
        aPC.setAutomaticFeatsStable(false);
        this.doPlusLevelMods(newLevel, aPC);
        if (Globals.getUseGUI()) {
            this.rollHP(aPC);
        }
        if (!aPC.isImporting()) {
            this.modDomainsForLevel(newLevel, true, aPC);
        }
        int levelUpStats = 0;
        if (aPC.getTotalLevels() > total) {
            boolean processBonusStats = true;
            boolean processBonusFeats = true;
            total = aPC.getTotalLevels();
            if (this.isMonster()) {
                if (total <= aPC.getRace().getMonsterClassLevels(aPC)) {
                    processBonusStats = false;
                }
                if (aPC.isMonsterDefault() && total <= aPC.getRace().getMonsterClassLevels(aPC)) {
                    processBonusFeats = false;
                }
            }
            if (!aPC.isImporting()) {
                int bonusStats;
                double bonusFeats;
                if (processBonusFeats && (bonusFeats = aPC.getBonusFeatsForNewLevel(this)) > 0.0) {
                    aPC.setFeats(aPC.getFeats() + bonusFeats);
                }
                if (processBonusStats && (bonusStats = Globals.getBonusStatsForLevel(total)) > 0) {
                    aPC.setPoolAmount(aPC.getPoolAmount() + bonusStats);
                    if (!bSilent && SettingsHandler.getShowStatDialogAtLevelUp()) {
                        levelUpStats = this.askForStatIncrease(aPC, bonusStats, true);
                    }
                }
            }
        }
        int spMod = this.recalcSkillPointMod(aPC, total);
        PCLevelInfo pcl = null;
        if (aPC.getLevelInfoSize() > 0 && (pcl = (PCLevelInfo)aPC.getLevelInfo().get(aPC.getLevelInfoSize() - 1)) != null) {
            pcl.setSkillPointsGained(spMod);
            pcl.setSkillPointsRemaining(spMod, aPC);
            pcl.setLevel(this.level);
        }
        this.skillPool = new Integer(this.skillPool + spMod);
        aPC.setSkillPoints(spMod + aPC.getSkillPoints());
        if (!aPC.isImporting()) {
            if (levelUpStats > 0) {
                this.askForStatIncrease(aPC, levelUpStats, false);
            }
            if (newLevel == 1) {
                this.makeKitSelection(0, aPC);
                this.makeRegionSelection(0, aPC);
            }
            this.makeKitSelection(newLevel, aPC);
            this.makeRegionSelection(newLevel, aPC);
            aPC.addNaturalWeapons(this.getNaturalWeapons());
        }
        if (this.isMonster()) {
            return true;
        }
        if (!aPC.isImporting()) {
            int minxp = aPC.minXPForECL();
            if (aPC.getXP() < minxp) {
                aPC.setXP(minxp);
            } else if (aPC.getXP() >= aPC.minXPForNextECL() && !bSilent) {
                ShowMessageDelegate.showMessageDialog(SettingsHandler.getGame().getLevelUpMessage(), "PCGen", MessageType.INFORMATION);
            }
        }
        if (this.levelExchange.length() != 0 && this.getLevel() == 1 && !aPC.isImporting()) {
            this.exchangeLevels(aPC);
        }
        return true;
    }

    private void exchangeLevels(PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(this.levelExchange, "|", false);
        if (aTok.countTokens() != 4) {
            Logging.errorPrint("levelExhange: invalid token count: " + aTok.countTokens());
        } else {
            try {
                int iLevel;
                String sClass = aTok.nextToken();
                int iMinLevel = Integer.parseInt(aTok.nextToken());
                int iMaxDonation = Integer.parseInt(aTok.nextToken());
                int iLowest = Integer.parseInt(aTok.nextToken());
                PCClass aClass = aPC.getClassNamed(sClass);
                if (aClass != null && (iLevel = aClass.getLevel()) >= iMinLevel && (iMaxDonation = Math.min(Math.min(iMaxDonation, iLevel - iLowest), this.getMaxLevel() - 1)) > 0) {
                    ArrayList<String> choiceNames = new ArrayList<String>();
                    for (int i = 0; i <= iMaxDonation; ++i) {
                        choiceNames.add(Integer.toString(i));
                    }
                    ChooserInterface c = ChooserFactory.getChooserInstance();
                    c.setTitle("Select number of levels to convert from " + sClass + " to " + this.getName());
                    c.setPool(1);
                    c.setPoolFlag(false);
                    c.setAvailableList(choiceNames);
                    c.setVisible(true);
                    ArrayList selectedList = c.getSelectedList();
                    int iLevels = 0;
                    if (!selectedList.isEmpty()) {
                        iLevels = Integer.parseInt((String)selectedList.get(0));
                    }
                    if (iLevels > 0) {
                        aPC.giveClassesAway(this, aClass, iLevels);
                    }
                }
            }
            catch (NumberFormatException exc) {
                ShowMessageDelegate.showMessageDialog("levelExchange:" + Constants.s_LINE_SEP + exc.getMessage(), "PCGen", MessageType.ERROR);
            }
        }
    }

    void doMinusLevelMods(PlayerCharacter aPC, int oldLevel) {
        if (!this.isMonster()) {
            this.changeFeatsForLevel(oldLevel, false, aPC);
        }
        this.subAddsForLevel(oldLevel, aPC);
        this.changeSpecials(aPC);
        aPC.removeVariable("CLASS:" + this.getName() + "|" + Integer.toString(oldLevel));
    }

    void doPlusLevelMods(int newLevel, PlayerCharacter aPC) {
        if (!this.isMonster()) {
            this.changeFeatsForLevel(newLevel, true, aPC);
        }
        this.changeSpecials(aPC);
        this.addVariablesForLevel(newLevel, aPC);
        aPC.calcActiveBonuses();
        this.addAddsForLevel(newLevel, aPC);
    }

    void fireNameChanged(String oldClass, String newClass) {
        int idx;
        if (oldClass.equals(newClass)) {
            return;
        }
        ArrayList specialAbilityList = this.getSpecialAbilityList();
        if (specialAbilityList != null) {
            for (idx = specialAbilityList.size() - 1; idx >= 0; --idx) {
                SpecialAbility sa = (SpecialAbility)specialAbilityList.get(idx);
                if (sa.getSource().length() == 0) continue;
                sa = new SpecialAbility(sa.getName(), sa.getSASource(), sa.getSADesc());
                sa.setQualificationClass(oldClass, newClass);
                specialAbilityList.set(idx, sa);
            }
        }
        if (this.getVariableCount() > 0) {
            for (idx = this.getVariableCount() - 1; idx >= 0; --idx) {
                Variable variable = this.getVariable(idx);
                String formula = variable.getValue();
                formula = formula.replaceAll("=" + oldClass, "=" + newClass);
                variable.setValue(formula);
            }
        }
        if (this.getBonusList() != null) {
            List tempList = this.getBonusList();
            for (int idx2 = tempList.size() - 1; idx2 >= 0; --idx2) {
                BonusObj aBonus = (BonusObj)tempList.get(idx2);
                String bonus = aBonus.toString();
                int offs = -1;
                while ((offs = bonus.indexOf('=' + oldClass, offs + 1)) >= 0) {
                    this.addBonusList(bonus.substring(0, offs + 1) + newClass + bonus.substring(offs + oldClass.length() + 1));
                    this.removeBonusList(aBonus);
                }
            }
        }
    }

    String makeBonusString(String bonusString, String chooseString, PlayerCharacter aPC) {
        return "0|" + super.makeBonusString(bonusString, chooseString, aPC);
    }

    int memorizedSpecialtiesForLevelBook(int aLevel, String bookName) {
        int m = 0;
        List aList = this.getCharacterSpell(null, bookName, aLevel);
        if (aList.isEmpty()) {
            return m;
        }
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            CharacterSpell cs = (CharacterSpell)i.next();
            if (!cs.isSpecialtySpell()) continue;
            m += cs.getSpellInfoFor(bookName, aLevel, -1).getTimes();
        }
        return m;
    }

    int memorizedSpellForLevelBook(int aLevel, String bookName) {
        int m = 0;
        List aList = this.getCharacterSpell(null, bookName, aLevel);
        if (aList.isEmpty()) {
            return m;
        }
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            CharacterSpell cs = (CharacterSpell)i.next();
            m += cs.getSpellInfoFor(bookName, aLevel, -1).getTimes();
        }
        return m;
    }

    void subLevel(boolean bSilent, PlayerCharacter aPC) {
        if (aPC != null) {
            int total = aPC.getTotalLevels();
            ArrayList specialAbilityList = this.getSpecialAbilityList();
            if (specialAbilityList != null && !specialAbilityList.isEmpty()) {
                for (int i = specialAbilityList.size() - 1; i >= 0; --i) {
                    SpecialAbility sa = (SpecialAbility)specialAbilityList.get(i);
                    if (!sa.getSource().startsWith("PCCLASS|") || sa.pcQualifiesFor(aPC)) continue;
                    specialAbilityList.remove(sa);
                }
            }
            int spMod = 0;
            PCLevelInfo pcl = aPC.getLevelInfoFor(this.name, this.level);
            if (pcl != null) {
                spMod = pcl.getSkillPointsGained(aPC);
            } else {
                Logging.errorPrint("ERROR: could not find class/level info for " + this.name + "/" + this.level);
            }
            if (this.levelAbilityList != null && !this.levelAbilityList.isEmpty()) {
                Iterator e1 = this.levelAbilityList.iterator();
                while (e1.hasNext()) {
                    LevelAbility ability = (LevelAbility)e1.next();
                    if (ability.level() != this.level || !(ability instanceof LevelAbilityFeat)) continue;
                    aPC.setFeats(aPC.getFeats() - 1.0);
                }
            }
            Integer zeroInt = new Integer(0);
            int newLevel = this.level - 1;
            if (this.level > 0) {
                this.setHitPoint(this.level - 1, zeroInt);
            }
            aPC.setFeats(aPC.getFeats() - aPC.getBonusFeatsForNewLevel(this));
            this.setLevel(newLevel, aPC);
            this.doMinusLevelMods(aPC, newLevel + 1);
            this.modDomainsForLevel(newLevel, false, aPC);
            if (newLevel == 0) {
                this.setSubClassName("None");
                ArrayList aSkills = aPC.getSkillList();
                for (int i = 0; i < aSkills.size(); ++i) {
                    Skill aSkill = (Skill)aSkills.get(i);
                    aSkill.setZeroRanks(this, aPC);
                }
                spMod = this.skillPool();
            }
            if (!this.isMonster() && total > aPC.getTotalLevels()) {
                total = aPC.getTotalLevels();
                ArrayList moddedStats = new ArrayList();
                if (pcl.getModifiedStats(true) != null) {
                    moddedStats.addAll(pcl.getModifiedStats(true));
                }
                if (pcl.getModifiedStats(false) != null) {
                    moddedStats.addAll(pcl.getModifiedStats(false));
                }
                if (!moddedStats.isEmpty()) {
                    Iterator iter = moddedStats.iterator();
                    block3: while (iter.hasNext()) {
                        PCLevelInfoStat statToRollback = (PCLevelInfoStat)iter.next();
                        Iterator i = aPC.getStatList().getStats().iterator();
                        while (i.hasNext()) {
                            PCStat aStat = (PCStat)i.next();
                            if (!aStat.getAbb().equalsIgnoreCase(statToRollback.getStatAbb())) continue;
                            aStat.setBaseScore(aStat.getBaseScore() - statToRollback.getStatMod());
                            continue block3;
                        }
                    }
                }
            }
            if (!this.isMonster() && total == 0) {
                aPC.setSkillPoints(0);
                aPC.setFeats(0.0);
                aPC.getSkillList().clear();
                aPC.getFeatList().clear();
                aPC.getWeaponProfList().clear();
            } else {
                aPC.setSkillPoints(aPC.getSkillPoints() - spMod);
                this.skillPool = new Integer(this.skillPool() - spMod);
            }
            if (this.getLevel() == 0) {
                aPC.getClassList().remove(this);
            }
        } else {
            Logging.errorPrint("No current pc in subLevel()? How did this happen?");
            return;
        }
        aPC.validateCharacterDomains();
        aPC.removeNaturalWeapons(this);
    }

    private double getBonusTo(String type, String mname, PlayerCharacter aPC) {
        return this.getBonusTo(type, mname, this.level, aPC);
    }

    private static int getExtraHD(PlayerCharacter aPC, int hdTotal) {
        int ehdMod;
        int sizeInt = Globals.sizeInt(aPC.getRace().getSize());
        switch (sizeInt) {
            case 8: {
                ehdMod = 32;
                break;
            }
            case 7: {
                ehdMod = 16;
                break;
            }
            case 6: {
                ehdMod = 4;
                break;
            }
            case 5: {
                ehdMod = 2;
                break;
            }
            default: {
                ehdMod = 1;
            }
        }
        return Math.max(0, hdTotal - ehdMod);
    }

    private boolean isAutoKnownSpell(String spellName, int spellLevel, boolean useMap, PlayerCharacter aPC) {
        Object val;
        if (this.knownSpellsList.isEmpty()) {
            return false;
        }
        Spell aSpell = Globals.getSpellNamed(spellName);
        if (useMap ? (val = this.castForLevelMap.get(String.valueOf(spellLevel))) == null || Integer.parseInt(val.toString()) == 0 || aSpell == null : this.getCastForLevel(this.level, spellLevel, aPC) == 0 || aSpell == null) {
            return false;
        }
        if (this.isProhibited(aSpell, aPC) && !this.isSpecialtySpell(aSpell)) {
            return false;
        }
        boolean flag = true;
        Iterator e = this.knownSpellsList.iterator();
        while (e.hasNext()) {
            String aString = (String)e.next();
            flag = true;
            StringTokenizer spellTok = new StringTokenizer(aString, ",", false);
            while (spellTok.hasMoreTokens() && flag) {
                String bString = spellTok.nextToken();
                if (bString.startsWith("LEVEL=") || bString.startsWith("LEVEL.")) {
                    flag = Integer.parseInt(bString.substring(6)) == spellLevel;
                    continue;
                }
                if (bString.startsWith("TYPE=") || bString.startsWith("TYPE.")) {
                    flag = aSpell.isType(bString.substring(5));
                    continue;
                }
                flag = bString.equals(spellName);
            }
            if (!flag) continue;
            break;
        }
        return flag;
    }

    private int getMonsterSkillPointMod(PlayerCharacter aPC, int total) {
        int spMod = 0;
        int lockedMonsterSkillPoints = (int)aPC.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
        if (total == 0) {
            spMod = lockedMonsterSkillPoints == 0 ? (int)aPC.getTotalBonusTo("MONSKILLPTS", "NUMBER") : lockedMonsterSkillPoints;
        } else if (PCClass.getExtraHD(aPC, total) > 0) {
            spMod = this.getSkillPoints();
            spMod = lockedMonsterSkillPoints == 0 ? (spMod += (int)aPC.getTotalBonusTo("SKILLPOINTS", "NUMBER")) : (spMod += lockedMonsterSkillPoints);
            spMod = this.updateBaseSkillMod(aPC, spMod);
        }
        if (spMod < 0) {
            spMod = 0;
        }
        return spMod;
    }

    private int getNonMonsterSkillPointMod(PlayerCharacter aPC, int total) {
        int spMod = this.getSkillPoints();
        int lockedMonsterSkillPoints = 0;
        spMod += (int)aPC.getTotalBonusTo("SKILLPOINTS", "NUMBER");
        if (this.isMonster()) {
            int nonSkillHD;
            lockedMonsterSkillPoints = (int)aPC.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
            if (lockedMonsterSkillPoints > 0) {
                spMod = lockedMonsterSkillPoints;
            } else if (total == 1) {
                spMod = (int)aPC.getTotalBonusTo("MONSKILLPTS", "NUMBER");
            }
            if (total != 1 && total <= (nonSkillHD = (int)aPC.getTotalBonusTo("MONNONSKILLHD", "NUMBER"))) {
                spMod = 0;
            }
        }
        spMod = this.updateBaseSkillMod(aPC, spMod);
        if (total == 1) {
            if (SettingsHandler.isPurchaseStatMode()) {
                aPC.setPoolAmount(0);
            }
            spMod *= Math.min(Globals.getSkillMultiplierForLevel(total), aPC.getRace().getInitialSkillMultiplier());
            Globals.getBioSet().randomize("AGE", aPC);
        } else {
            spMod *= Globals.getSkillMultiplierForLevel(total);
        }
        return spMod;
    }

    private void getStableCastForLevel(PlayerCharacter aPC) {
        for (int i = 0; i < 100; ++i) {
            int s = this.getCastForLevel(this.level, i, aPC);
            this.castForLevelMap.put(String.valueOf(i), String.valueOf(s));
        }
    }

    public List getTemplates(boolean flag, PlayerCharacter aPC) {
        ArrayList<String> newTemplates = new ArrayList<String>();
        this.templatesAdded = new ArrayList();
        for (int x = 0; x < this.templates.size(); ++x) {
            String template = (String)this.templates.get(x);
            StringTokenizer aTok = new StringTokenizer(template, "|", false);
            if (this.level < Integer.parseInt(aTok.nextToken())) continue;
            String tString = aTok.nextToken();
            if (tString.startsWith("CHOOSE:") && !flag) {
                newTemplates.add(PCTemplate.chooseTemplate(template.substring(template.indexOf("CHOOSE:") + 7), aPC));
                this.templatesAdded.add(newTemplates.get(newTemplates.size() - 1));
                continue;
            }
            if (flag) continue;
            newTemplates.add(tString);
            this.templatesAdded.add(newTemplates.get(newTemplates.size() - 1));
            while (aTok.hasMoreTokens()) {
                newTemplates.add(aTok.nextToken());
                this.templatesAdded.add(newTemplates.get(newTemplates.size() - 1));
            }
        }
        return newTemplates;
    }

    private static String getToken(int tokenNum, String aList, String delim) {
        StringTokenizer aTok = new StringTokenizer(aList, delim, false);
        while (aTok.hasMoreElements() && tokenNum >= 0) {
            String aString = aTok.nextToken();
            if (tokenNum == 0) {
                return aString;
            }
            --tokenNum;
        }
        return null;
    }

    private String getUMultForLevel(int aLevel) {
        String aString = "0";
        if (this.umultList == null || this.umultList.isEmpty()) {
            return aString;
        }
        Iterator e = this.umultList.iterator();
        while (e.hasNext()) {
            String bString = (String)e.next();
            int pos = bString.lastIndexOf(124);
            if (pos < 0 || aLevel > Integer.parseInt(bString.substring(0, pos))) continue;
            aString = bString.substring(pos + 1);
        }
        return aString;
    }

    private void addVariablesForLevel(int aLevel, PlayerCharacter aPC) {
        if (this.getVariableCount() == 0) {
            return;
        }
        if (aLevel == 1) {
            this.addVariablesForLevel(0, aPC);
        }
        String prefix = "CLASS:" + this.name + '|';
        Iterator i = this.getVariableIterator();
        while (i.hasNext()) {
            Variable v = (Variable)i.next();
            if (v.getLevel() != aLevel) continue;
            aPC.addVariable(prefix + v.getDefinition());
        }
    }

    private final int askForStatIncrease(PlayerCharacter aPC, int statsToChoose, boolean isPre) {
        if (isPre && !Globals.checkRule("INTBEFORE")) {
            return statsToChoose;
        }
        String extraMsg = "";
        if (isPre) {
            extraMsg = "\nRaising a stat here may award more skill points.";
        }
        int iCount = 0;
        block0: for (int ix = 0; ix < statsToChoose; ++ix) {
            StringBuffer sStats = new StringBuffer();
            Iterator i = aPC.getStatList().getStats().iterator();
            while (i.hasNext()) {
                PCStat aStat = (PCStat)i.next();
                int iAdjStat = aPC.getStatList().getTotalStatFor(aStat.getAbb());
                int iCurStat = aPC.getStatList().getBaseStatFor(aStat.getAbb());
                sStats.append(aStat.getAbb()).append(": ").append(iCurStat);
                if (iCurStat != iAdjStat) {
                    sStats.append(" adjusted: ").append(iAdjStat);
                }
                sStats.append(" (").append(aPC.getStatList().getStatModFor(aStat.getAbb())).append(")\n");
            }
            InputInterface ii = InputFactory.getInputInstance();
            Object selectedValue = ii.showInputDialog(null, "Choose stat to increment or select Cancel to increment stat on the Summary tab." + extraMsg + "\n\n" + "Current Stats:\n" + sStats + "\n", "PCGen", MessageType.INFORMATION, SettingsHandler.getGame().s_ATTRIBLONG, SettingsHandler.getGame().s_ATTRIBLONG[0]);
            if (selectedValue == null) continue;
            Iterator i2 = aPC.getStatList().getStats().iterator();
            while (i2.hasNext()) {
                PCStat aStat = (PCStat)i2.next();
                if (!aStat.getName().equalsIgnoreCase(selectedValue.toString())) continue;
                aPC.saveStatIncrease(aStat.getAbb(), 1, isPre);
                aStat.setBaseScore(aStat.getBaseScore() + 1);
                aPC.setPoolAmount(aPC.getPoolAmount() - 1);
                ++iCount;
                continue block0;
            }
        }
        return statsToChoose - iCount;
    }

    private static void buildPccText(StringBuffer pccTxt, Iterator listIterator, String separator, String label, String lineSep) {
        while (listIterator.hasNext()) {
            String listItem = (String)listIterator.next();
            int sepPos = listItem.indexOf(separator);
            pccTxt.append(lineSep).append(listItem.substring(0, sepPos)).append(label).append(listItem.substring(sepPos + 1));
        }
    }

    private void buildSubClassChoiceList(List choiceNames, List removeNames, boolean useProhibitCost, PlayerCharacter aPC) {
        int displayedCost = 0;
        choiceNames.add("Name\tCost\tOther");
        choiceNames.add("");
        Iterator i = this.subClassList.iterator();
        while (i.hasNext()) {
            SubClass sc = (SubClass)i.next();
            if (!PrereqHandler.passesAll(sc.getPreReqList(), aPC, this)) continue;
            displayedCost = useProhibitCost ? sc.getProhibitCost() : sc.getCost();
            boolean added = false;
            StringBuffer buf = new StringBuffer();
            buf.append(sc.getName()).append('\t').append(displayedCost).append('\t');
            if (sc.getNumSpellsFromSpecialty() != 0) {
                buf.append("SPECIALTY SPELLS:").append(sc.getNumSpellsFromSpecialty());
                added = true;
            }
            if (sc.getSpellBaseStat() != null) {
                buf.append("SPELL BASE STAT:").append(sc.getSpellBaseStat());
                added = true;
            }
            if (!added) {
                buf.append(' ');
            }
            if (displayedCost == 0) {
                removeNames.add(buf.toString());
            }
            choiceNames.add(buf.toString());
        }
    }

    private double calcPartialBonus(String bString, int iTimes, BonusObj aBonus, Object anObj) {
        StringTokenizer aTok = new StringTokenizer(bString, "|", false);
        if (aBonus.getPCLevel() >= 0) {
            aTok.nextToken();
        }
        aTok.nextToken();
        String aList = aTok.nextToken();
        String aVal = aTok.nextToken();
        double iBonus = 0.0;
        if (aList.equals("ALL")) {
            return 0.0;
        }
        if (anObj instanceof PlayerCharacter) {
            iBonus = ((PlayerCharacter)anObj).getVariableValue(aVal, "CLASS:" + this.name).doubleValue();
        } else {
            try {
                iBonus = Float.parseFloat(aVal);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("PCClass calcPartialBonus NumberFormatException in BONUS: " + bString);
            }
        }
        return iBonus * (double)iTimes;
    }

    private boolean canBePrestige(PlayerCharacter aPC) {
        return PrereqHandler.passesAll(this.getPreReqList(), aPC, this);
    }

    private void changeFeatsForLevel(int aLevel, boolean addThem, PlayerCharacter aPC) {
        if (aPC == null || this.featList.isEmpty()) {
            return;
        }
        Iterator e = this.featList.iterator();
        while (e.hasNext()) {
            String feats = (String)e.next();
            if (aLevel != Integer.parseInt(PCClass.getToken(0, feats, ":"))) continue;
            double preFeatCount = aPC.getUsedFeatCount();
            aPC.modFeatsFromList(PCClass.getToken(1, feats, ":"), addThem, aLevel == 1);
            double postFeatCount = aPC.getUsedFeatCount();
            aPC.setFeats(aPC.getFeats() + postFeatCount - preFeatCount);
        }
    }

    private void changeSpecials(PlayerCharacter aPC) {
        int i;
        PCClass aClass;
        if (this.specialsString().length() == 0) {
            return;
        }
        String className = "";
        Integer adj = new Integer(0);
        String abilityName = "";
        String levelString = "";
        StringTokenizer aTok = new StringTokenizer(this.specialsString, "|", false);
        ArrayList saList = new ArrayList();
        if (aTok.hasMoreTokens()) {
            abilityName = aTok.nextToken();
        }
        if (aTok.hasMoreTokens()) {
            className = aTok.nextToken();
        }
        if (aTok.hasMoreTokens()) {
            aTok.nextToken();
        }
        if (aTok.hasMoreTokens()) {
            levelString = aTok.nextToken();
        }
        Iterator iter = aPC.getClassList().iterator();
        while (iter.hasNext()) {
            aClass = (PCClass)iter.next();
            if (aClass.specialsString().length() <= 0 || !aClass.specialsString().startsWith(abilityName)) continue;
            aTok = new StringTokenizer(aClass.specialsString(), "|", false);
            aTok.nextToken();
            aTok.nextToken();
            if (aTok.hasMoreTokens()) {
                adj = new Integer(adj + Integer.parseInt(aTok.nextToken()) + aClass.getLevel());
            }
            if (!aTok.hasMoreTokens()) continue;
            levelString = aTok.nextToken();
        }
        aClass = aPC.getClassNamed(className);
        if (aClass == null) {
            iter = Globals.getClassList().iterator();
            while (iter.hasNext()) {
                aClass = (PCClass)iter.next();
                if (aClass.getName().equals(className)) {
                    aTok = new StringTokenizer(aClass.specialsString(), "|", false);
                    aTok.nextToken();
                    aTok.nextToken();
                    aTok.nextToken();
                    levelString = aTok.nextToken();
                    break;
                }
                aClass = null;
            }
        }
        if (aClass != null && levelString.length() > 0) {
            aTok = new StringTokenizer(levelString, ",", false);
            i = 0;
            Integer aLevel = new Integer(0);
            while (aTok.hasMoreTokens() && adj >= aLevel) {
                aLevel = new Integer(aTok.nextToken());
                if (adj < aLevel || SystemCollections.getUnmodifiableSpecialsList().size() <= i) continue;
                saList.add(SystemCollections.getUnmodifiableSpecialsList().get(i++));
            }
        }
        if (!saList.isEmpty()) {
            for (i = saList.size() - 1; i >= 0; --i) {
                SpecialAbility sa1 = (SpecialAbility)saList.get(i);
                String sn1 = sa1.getSADesc();
                for (int k = 0; k < 10; ++k) {
                    sn1 = sn1.replace((char)(48 + k), ' ');
                }
                for (int j = i - 1; j >= 0; --j) {
                    SpecialAbility sa2 = (SpecialAbility)saList.get(j);
                    String sn2 = sa2.getSADesc();
                    for (int k = 0; k < 10; ++k) {
                        sn2 = sn2.replace((char)(48 + k), ' ');
                    }
                    if (!sn1.equals(sn2)) continue;
                    saList.remove(j);
                    --i;
                }
            }
        }
        if (!saList.isEmpty()) {
            String sourceName = "PCCLASS|" + this.name + "|" + this.level;
            iter = saList.iterator();
            while (iter.hasNext()) {
                SpecialAbility sa = (SpecialAbility)iter.next();
                sa.setSASource(sourceName);
                if (aClass == null || aPC.hasSpecialAbility(sa)) continue;
                aClass.addSpecialAbilityToList(sa);
            }
        }
    }

    private static void checkAdd(StringBuffer txt, String comp, String label, String value) {
        if (value != null && !comp.equals(value)) {
            txt.append('\t').append(label).append(value);
        }
    }

    private void checkForSubClass(PlayerCharacter aPC) {
        if (!this.hasSubClass || this.subClassList == null || this.subClassList.isEmpty()) {
            return;
        }
        ArrayList choiceNames = new ArrayList();
        ArrayList removeNames = new ArrayList();
        this.buildSubClassChoiceList(choiceNames, removeNames, false, aPC);
        ChooserInterface c = ChooserFactory.getChooserInstance();
        c.setTitle("School Choice (Specialisation)");
        c.setMessageText("Make a selection.  The cost column indicates the cost of that selection. If this cost is non-zero, you will be asked to also select items from this list to give up to cover that cost.");
        c.setPool(1);
        c.setPoolFlag(false);
        c.setAvailableList(choiceNames);
        if (choiceNames.size() == 1) {
            c.setSelectedList(choiceNames);
        } else if (choiceNames.size() != 0) {
            c.setVisible(true);
        }
        ArrayList selectedList = c.getSelectedList();
        if (!selectedList.isEmpty()) {
            this.setProhibitedString("");
            this.specialtyList.clear();
            StringTokenizer aTok = new StringTokenizer((String)selectedList.get(0), "\t", false);
            SubClass sc = this.getSubClassNamed(aTok.nextToken());
            choiceNames = new ArrayList();
            removeNames = new ArrayList();
            this.buildSubClassChoiceList(choiceNames, removeNames, true, aPC);
            Iterator iter = choiceNames.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                if (!element.startsWith(sc.getName())) continue;
                choiceNames.remove(element);
                break;
            }
            choiceNames.removeAll(removeNames);
            this.setSubClassName(sc.getName());
            if (sc.getChoice().length() > 0) {
                this.specialtyList.add(sc.getChoice());
            }
            if (sc.getCost() != 0) {
                ChooserInterface c1 = ChooserFactory.getChooserInstance();
                c1.setTitle("School Choice (Prohibited)");
                c1.setAvailableList(choiceNames);
                c1.setMessageText("Make a selection.  You must make as many selections necessary to cover the cost of your previous selections.");
                c1.setPool(sc.getCost());
                c1.setPoolFlag(true);
                c1.setCostColumnNumber(1);
                c1.setNegativeAllowed(true);
                c1.setVisible(true);
                selectedList = c1.getSelectedList();
                Iterator i = selectedList.iterator();
                while (i.hasNext()) {
                    aTok = new StringTokenizer((String)i.next(), "\t", false);
                    sc = this.getSubClassNamed(aTok.nextToken());
                    if (this.prohibitedString.length() > 0) {
                        this.prohibitedString = this.prohibitedString.concat(",");
                    }
                    this.prohibitedString = this.prohibitedString.concat(sc.getChoice());
                }
            }
        }
    }

    private void chooseClassSkillList() {
        if (this.classSkillString == null) {
            return;
        }
        StringTokenizer aTok = new StringTokenizer(this.classSkillString, "|", false);
        int amt = 0;
        if (this.classSkillString.indexOf(124) >= 0) {
            amt = Integer.parseInt(aTok.nextToken());
        }
        ArrayList<String> aList = new ArrayList<String>();
        while (aTok.hasMoreTokens()) {
            aList.add(aTok.nextToken());
        }
        if (aList.size() == 1) {
            this.classSkillList = aList;
            return;
        }
        ChooserInterface c = ChooserFactory.getChooserInstance();
        c.setTitle("Select class whose class-skills this class will inherit");
        c.setPool(amt);
        c.setPoolFlag(false);
        c.setAvailableList(aList);
        c.setVisible(true);
        ArrayList selectedList = c.getSelectedList();
        this.classSkillList = new ArrayList();
        Iterator i = selectedList.iterator();
        while (i.hasNext()) {
            String aString = i.next().toString();
            this.classSkillList.add(aString);
        }
    }

    private void chooseClassSpellList() {
        if (this.classSpellString == null || this.level < 1) {
            return;
        }
        StringTokenizer aTok = new StringTokenizer(this.classSpellString, "|", false);
        int amt = 0;
        if (this.classSpellString.indexOf(124) >= 0) {
            amt = Integer.parseInt(aTok.nextToken());
        }
        ArrayList<String> aList = new ArrayList<String>();
        while (aTok.hasMoreTokens()) {
            aList.add(aTok.nextToken());
        }
        if (aList.size() == amt) {
            this.classSpellList = aList;
            return;
        }
        ChooserInterface c = ChooserFactory.getChooserInstance();
        c.setTitle("Select class whose list of spells this class will use");
        c.setPool(amt);
        c.setPoolFlag(false);
        c.setAvailableList(aList);
        c.setVisible(true);
        ArrayList selectedList = c.getSelectedList();
        this.classSpellList = new ArrayList();
        Iterator i = selectedList.iterator();
        while (i.hasNext()) {
            String aString = i.next().toString();
            this.classSpellList.add(aString);
        }
    }

    private static boolean contains(String big, String little) {
        return big.indexOf(little) >= 0;
    }

    private void inheritAttributesFrom(PCClass otherClass) {
        if (otherClass.getBonusSpellBaseStat() != null) {
            this.setBonusSpellBaseStat(otherClass.getBonusSpellBaseStat());
        }
        if (otherClass.getSpellBaseStat() != null) {
            this.setSpellBaseStat(otherClass.getSpellBaseStat());
        }
        if (otherClass.classSpellString != null) {
            this.classSpellString = otherClass.classSpellString;
        }
        if (otherClass.autoArray != null) {
            this.addAutoArray(otherClass.autoArray);
        }
        if (!otherClass.getBonusList().isEmpty()) {
            this.getBonusList().addAll(otherClass.getBonusList());
        }
        if (otherClass.getVariableCount() > 0) {
            this.addAllVariablesFrom(otherClass);
        }
        if (otherClass.getCSkillList() != null) {
            this.cSkillList = otherClass.getCSkillList();
        }
        if (otherClass.getCcSkillList() != null) {
            this.ccSkillList = otherClass.getCcSkillList();
        }
        if (otherClass.kits != null) {
            otherClass.kits = (ArrayList)this.kits.clone();
        }
        if (otherClass.regionString != null) {
            this.setRegionString(otherClass.regionString);
        }
        if (otherClass.getSpecialAbilityList() != null) {
            ArrayList specialAbilityList = this.getSpecialAbilityList();
            specialAbilityList.addAll(otherClass.getSpecialAbilityList());
        }
        if (otherClass.DR != null) {
            this.DR = (ArrayList)otherClass.DR.clone();
        }
        if (otherClass.SR != null) {
            this.SR = (ArrayList)otherClass.SR.clone();
        }
        if (otherClass.vision != null) {
            this.vision = otherClass.vision;
        }
        if (otherClass instanceof SubClass) {
            ((SubClass)otherClass).applyLevelArrayModsTo(this);
        }
        if (otherClass.naturalWeapons != null) {
            this.naturalWeapons = (ArrayList)otherClass.naturalWeapons.clone();
        }
    }

    private void modDomainsForLevel(int aLevel, boolean adding, PlayerCharacter aPC) {
        if (aPC.isImporting()) {
            return;
        }
        int c = 2;
        if (aLevel > 9) {
            c = 3;
        }
        if (this.domainList.isEmpty()) {
            return;
        }
        Iterator i = this.domainList.iterator();
        while (i.hasNext()) {
            String aString = (String)i.next();
            StringTokenizer aTok = new StringTokenizer(aString, "|");
            int bLevel = Integer.parseInt(aTok.nextToken());
            int d = c;
            if (aLevel != bLevel) continue;
            StringTokenizer bTok = new StringTokenizer(aString.substring(c), "[]|", true);
            boolean addNow = true;
            String aName = "";
            boolean inPreReqs = false;
            while (bTok.hasMoreTokens()) {
                Domain aDomain;
                String bString = bTok.nextToken();
                if (!(inPreReqs || "[".equals(bString) || "|".equals(bString))) {
                    aName = bString;
                }
                d += bString.length();
                if (bTok.hasMoreTokens()) {
                    if ("[".equals(aString.substring(d, d + 1))) {
                        addNow = false;
                    }
                } else {
                    addNow = true;
                }
                if ("[".equals(bString)) {
                    inPreReqs = true;
                } else if ("]".equals(bString)) {
                    addNow = true;
                    inPreReqs = false;
                }
                if (addNow && !adding) {
                    int l = aPC.getCharacterDomainIndex(aName);
                    if (l <= -1) continue;
                    aPC.getCharacterDomainList().remove(l);
                    continue;
                }
                if (!adding || !addNow || aName.length() <= 0) continue;
                if (aPC.getCharacterDomainIndex(aName) == -1 && (aDomain = Globals.getDomainNamed(aName)) != null) {
                    aDomain = (Domain)aDomain.clone();
                    CharacterDomain aCD = aPC.getNewCharacterDomain(this.getName());
                    aCD.setDomain(aDomain, aPC);
                    aPC.addCharacterDomain(aCD);
                    aDomain.setIsLocked(true, aPC);
                }
                aName = "";
            }
        }
    }

    private void newClassSpellList() {
        if (this.classSpellList == null) {
            this.classSpellList = new ArrayList();
        } else {
            this.classSpellList.clear();
        }
    }

    private void rollHP(PlayerCharacter aPC) {
        int roll = 0;
        int min = 1 + (int)aPC.getTotalBonusTo("HD", "MIN") + (int)aPC.getTotalBonusTo("HD", "MIN;CLASS." + this.name);
        int max = this.getLevelHitDie(aPC, this.getLevel()) + (int)aPC.getTotalBonusTo("HD", "MAX") + (int)aPC.getTotalBonusTo("HD", "MAX;CLASS." + this.name);
        int totalLevels = aPC.getTotalLevels();
        if (totalLevels == 1 && SettingsHandler.isHPMaxAtFirstLevel()) {
            roll = max;
        } else if (!aPC.isImporting()) {
            roll = Globals.rollHP(min, max, this.getName(), this.level);
        }
        this.setHitPoint(this.level - 1, new Integer(roll += (int)aPC.getTotalBonusTo("HP", "CURRENTMAXPERLEVEL")));
        aPC.setCurrentHP(aPC.hitPoints());
    }

    private int updateBaseSkillMod(PlayerCharacter aPC, int spMod) {
        int skillMin;
        int n = skillMin = spMod > 0 ? 1 : 0;
        if (this.modToSkills && (spMod += (int)aPC.getStatBonusTo("MODSKILLPOINTS", "NUMBER")) < 1) {
            spMod = 1;
        }
        spMod += aPC.getRace().getBonusSkillsPerLevel();
        spMod = Math.max(skillMin, spMod);
        if (!aPC.getTemplateList().isEmpty()) {
            Iterator e = aPC.getTemplateList().iterator();
            while (e.hasNext()) {
                PCTemplate aTemplate = (PCTemplate)e.next();
                spMod += aTemplate.getBonusSkillsPerLevel();
            }
        }
        return spMod;
    }

    public void addNaturalWeapon(Equipment weapon, int level) {
        LevelProperty lp = new LevelProperty(level, weapon);
        this.naturalWeapons.add(lp);
    }

    private static class LevelProperty {
        private String property = "";
        private int propLevel = 0;
        private PObject object;

        LevelProperty(int argLevel, String argProperty) {
            this.propLevel = argLevel;
            this.property = argProperty;
        }

        LevelProperty(int argLevel, PObject argObject) {
            this.propLevel = argLevel;
            this.object = argObject;
        }

        public final int getLevel() {
            return this.propLevel;
        }

        public final String getProperty() {
            return this.property;
        }

        public final PObject getObject() {
            return this.object;
        }
    }
}

