/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

public final class PCStat
extends PObject {
    private String abbreviation = "";
    private String penaltyVar = "";
    private String statMod = "0";
    private int maxValue = 1000;
    private int minValue = 0;
    private int score = 0;

    public void setAbb(String aString) {
        this.abbreviation = aString.toUpperCase();
        if (this.abbreviation.length() != 3) {
            Logging.errorPrint("Stat with ABB:" + this.abbreviation + " should be 3 characters long!");
        }
    }

    public String getAbb() {
        return this.abbreviation;
    }

    public void setBaseScore(int x) {
        this.score = x;
    }

    public int getBaseScore() {
        return this.score;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setPenaltyVar(String aString) {
        this.penaltyVar = aString;
    }

    public String getPenaltyVar() {
        return this.penaltyVar;
    }

    public void setStatMod(String aString) {
        this.statMod = aString;
    }

    public void setStatRange(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        if (aTok.countTokens() == 2) {
            try {
                this.minValue = Integer.parseInt(aTok.nextToken());
                this.maxValue = Integer.parseInt(aTok.nextToken());
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            Logging.errorPrint("Error in specified Stat range: " + aString);
        }
    }

    public Object clone() {
        PCStat newObj = null;
        try {
            newObj = (PCStat)super.clone();
            newObj.setAbb(this.abbreviation);
            newObj.setStatMod(this.statMod);
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return newObj;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(30);
        sb.append("stat:").append(this.abbreviation).append(' ');
        sb.append("formula:").append(this.statMod).append(' ');
        sb.append("score:").append(this.score);
        return sb.toString();
    }

    String getStatMod() {
        return this.statMod;
    }
}

