/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.Globals;
import pcgen.core.HasCost;
import pcgen.core.Language;
import pcgen.core.LevelAbility;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public final class PCTemplate
extends PObject
implements HasCost {
    public static final int VISIBILITY_HIDDEN = 0;
    public static final int VISIBILITY_DEFAULT = 1;
    public static final int VISIBILITY_OUTPUT_ONLY = 2;
    public static final int VISIBILITY_DISPLAY_ONLY = 3;
    private ArrayList featStrings = null;
    private ArrayList hitDiceStrings = null;
    private ArrayList levelStrings = null;
    private ArrayList templates = new ArrayList();
    private ArrayList weaponProfBonus = null;
    private HashMap chosenFeatStrings = null;
    private List templatesAdded = null;
    private String ageString = "None";
    private String chooseLanguageAutos = "";
    private String cost = "1";
    private String favoredClass = "";
    private String gender = "None";
    private String handed = "None";
    private String heightString = "None";
    private String levelAdjustment = "0";
    private String region = "None";
    private String subRace = "None";
    private String subregion = "None";
    private String templateSize = "";
    private String weightString = "None";
    private TreeSet languageBonus = new TreeSet();
    private boolean removable = true;
    private int CR = 0;
    private int bonusInitialFeats = 0;
    private int bonusSkillsPerLevel = 0;
    private String hitDieLock = "";
    private int levelsPerFeat = 3;
    private int nonProficiencyPenalty = -4;
    private int templateVisible = 1;

    public void setAgeString(String argAgeString) {
        this.ageString = argAgeString;
    }

    public void setBonusInitialFeats(int argBonusInitialFeats) {
        this.bonusInitialFeats = argBonusInitialFeats;
    }

    public int getBonusInitialFeats() {
        return this.bonusInitialFeats;
    }

    public void setBonusSkillsPerLevel(int argBonusSkillsPerLevel) {
        this.bonusSkillsPerLevel = argBonusSkillsPerLevel;
    }

    public int getBonusSkillsPerLevel() {
        return this.bonusSkillsPerLevel;
    }

    public void setCR(int argCR) {
        this.CR = argCR;
    }

    public int getCR(int level, int hitdice) {
        int x;
        int _CR = this.CR;
        for (x = 0; x < PCTemplate.getListSize(this.levelStrings); ++x) {
            if (!PCTemplate.contains(this.levelStrings.get(x).toString(), "CR:") || !this.doesLevelQualify(level, x)) continue;
            _CR += Integer.parseInt(PCTemplate.getStringAfter("CR:", this.levelStrings.get(x).toString()));
        }
        for (x = 0; x < PCTemplate.getListSize(this.hitDiceStrings); ++x) {
            if (!PCTemplate.contains(this.hitDiceStrings.get(x).toString(), "CR:") || !this.doesHitDiceQualify(hitdice, x)) continue;
            _CR += Integer.parseInt(PCTemplate.getStringAfter("CR:", this.hitDiceStrings.get(x).toString()));
        }
        return _CR;
    }

    public void setChooseLanguageAutos(String argChooseLanguageAutos) {
        this.chooseLanguageAutos = argChooseLanguageAutos;
    }

    public String getChooseLanguageAutos() {
        return this.chooseLanguageAutos;
    }

    public HashMap getChosenFeatStrings() {
        return this.chosenFeatStrings;
    }

    public void setCost(String argCost) {
        this.cost = argCost;
    }

    public double getCost() {
        return Double.parseDouble(this.cost);
    }

    public String getDR(int level, int hitdice) {
        int x;
        StringBuffer drString = new StringBuffer();
        if (this.DR != null) {
            drString.append(this.DR.trim());
        }
        for (x = 0; x < PCTemplate.getListSize(this.levelStrings); ++x) {
            if (!PCTemplate.contains(this.levelStrings.get(x).toString(), "DR:") || !this.doesLevelQualify(level, x)) continue;
            drString.append(this.levelStrings.get(x)).append("|");
        }
        for (x = 0; x < PCTemplate.getListSize(this.hitDiceStrings); ++x) {
            if (!PCTemplate.contains(this.hitDiceStrings.get(x).toString(), "DR:") || !this.doesHitDiceQualify(hitdice, x)) continue;
            drString.append(PCTemplate.getStringAfter("DR:", this.hitDiceStrings.get(x).toString())).append("|");
        }
        return drString.toString();
    }

    public void setFavoredClass(String newClass) {
        this.favoredClass = newClass;
    }

    public String getFavoredClass() {
        return this.favoredClass;
    }

    public void setGenderLock(String genderString) {
        if ("Female".equalsIgnoreCase(genderString)) {
            this.gender = PropertyFactory.getString("in_genderFemale");
        } else if ("Male".equalsIgnoreCase(genderString)) {
            this.gender = PropertyFactory.getString("in_genderMale");
        } else if ("Neuter".equalsIgnoreCase(genderString)) {
            this.gender = PropertyFactory.getString("in_genderNeuter");
        }
    }

    public String getGenderLock() {
        return this.gender;
    }

    public void setHandedLock(String handedString) {
        this.handed = handedString;
    }

    public void setHeightString(String argHeightString) {
        this.heightString = argHeightString;
    }

    public void setHitDieLock(String hitDieLock) {
        this.hitDieLock = hitDieLock;
    }

    protected String getHitDieLock() {
        return this.hitDieLock;
    }

    public ArrayList getHitDiceStrings() {
        if (this.hitDiceStrings == null) {
            this.hitDiceStrings = new ArrayList();
        }
        return this.hitDiceStrings;
    }

    public void setLanguageBonus(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, ",", false);
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            if (".CLEAR".equals(token)) {
                this.getLanguageBonus().clear();
                continue;
            }
            Language aLang = Globals.getLanguageNamed(token);
            if (aLang == null) continue;
            this.getLanguageBonus().add(aLang);
        }
    }

    public Set getLanguageBonus() {
        return this.languageBonus;
    }

    public void setLevelAdjustment(String argLevelAdjustment) {
        this.levelAdjustment = argLevelAdjustment;
    }

    public int getLevelAdjustment(PlayerCharacter aPC) {
        int lvlAdjust;
        if (aPC != null) {
            return aPC.getVariableValue(this.levelAdjustment, "").intValue();
        }
        try {
            lvlAdjust = Integer.parseInt(this.levelAdjustment);
        }
        catch (NumberFormatException nfe) {
            lvlAdjust = 0;
        }
        return lvlAdjust;
    }

    public String getLevelAdjustmentFormula() {
        return this.levelAdjustment;
    }

    public ArrayList getLevelStrings() {
        if (this.levelStrings == null) {
            this.levelStrings = new ArrayList();
        }
        return this.levelStrings;
    }

    public void setLevelsPerFeat(int argLevelsPerFeat) {
        this.levelsPerFeat = argLevelsPerFeat;
    }

    public boolean isNonAbility(int statIdx) {
        List statList = SettingsHandler.getGame().getUnmodifiableStatList();
        if (statIdx < 0 || statIdx >= statList.size()) {
            return true;
        }
        String aStat = "|LOCK." + ((PCStat)statList.get(statIdx)).getAbb() + "|10";
        int x = this.getVariableCount();
        for (int i = 0; i < x; ++i) {
            String varString = this.getVariableDefinition(i);
            if (!varString.endsWith(aStat)) continue;
            return true;
        }
        return false;
    }

    public void setNonProficiencyPenalty(int npp) {
        if (npp <= 0) {
            this.nonProficiencyPenalty = npp;
        }
    }

    public int getNonProficiencyPenalty() {
        return this.nonProficiencyPenalty;
    }

    public String getPCCText(PlayerCharacter aPC) {
        Iterator e;
        Iterator e2;
        StringBuffer buffer;
        StringBuffer txt = new StringBuffer(200);
        txt.append(this.getName());
        if (!"None".equals(this.ageString)) {
            txt.append("\tAGE:").append(this.ageString);
        }
        if (this.bonusInitialFeats != 0) {
            txt.append("\tBONUSFEATS:").append(this.bonusInitialFeats);
        }
        if (this.bonusSkillsPerLevel != 0) {
            txt.append("\tBONUSSKILLPOINTS:").append(this.bonusSkillsPerLevel);
        }
        if (this.chooseLanguageAutos != null && this.chooseLanguageAutos.length() > 0) {
            txt.append("\tCHOOSE:LANGAUTO:").append(this.chooseLanguageAutos);
        }
        if (!CoreUtility.doublesEqual(this.getCost(), 1.0)) {
            txt.append("\tCOST:").append(String.valueOf(this.getCost()));
        }
        if (this.CR != 0) {
            txt.append("\tCR:").append(this.CR);
        }
        if (this.favoredClass != null && this.favoredClass.length() > 0) {
            txt.append("\tFAVOREDCLASS:").append(this.favoredClass);
        }
        if (PCTemplate.getListSize(this.featStrings) > 0) {
            buffer = new StringBuffer();
            e2 = this.featStrings.iterator();
            while (e2.hasNext()) {
                if (buffer.length() != 0) {
                    buffer.append('|');
                }
                buffer.append((String)e2.next());
            }
            txt.append("\tFEAT:").append(buffer.toString());
        }
        if (!"None".equals(this.gender)) {
            txt.append("\tGENDERLOCK:").append(this.gender);
        }
        if (!"None".equals(this.handed)) {
            txt.append("\tHANDEDLOCK:").append(this.handed);
        }
        if (PCTemplate.getListSize(this.hitDiceStrings) > 0) {
            e = this.hitDiceStrings.iterator();
            while (e.hasNext()) {
                txt.append("\tHD:").append((String)e.next());
            }
        }
        if (!"None".equals(this.heightString)) {
            txt.append("\tHEIGHT:").append(this.heightString);
        }
        if (!this.hitDieLock.equals("")) {
            txt.append("\tHITDIE:").append(this.hitDieLock);
        }
        if (this.languageBonus != null && !this.languageBonus.isEmpty()) {
            buffer = new StringBuffer();
            e2 = this.languageBonus.iterator();
            while (e2.hasNext()) {
                if (buffer.length() != 0) {
                    buffer.append(',');
                }
                buffer.append((String)e2.next());
            }
            txt.append("\tLANGBONUS:").append(buffer.toString());
        }
        if (PCTemplate.getListSize(this.levelStrings) > 0) {
            e = this.levelStrings.iterator();
            while (e.hasNext()) {
                txt.append("\tLEVEL:").append((String)e.next());
            }
        }
        if (!"0".equals(this.levelAdjustment)) {
            txt.append("\tLEVELADJUSTMENT:").append(this.levelAdjustment);
        }
        if (this.levelsPerFeat != 3) {
            txt.append("\tLEVELSPERFEAT:").append(this.levelsPerFeat);
        }
        if (this.getNumberOfMovements() > 0) {
            if (this.getMoveRatesFlag() == 1) {
                txt.append("\tMOVEA:");
            } else if (this.getMoveRatesFlag() == 2) {
                txt.append("\tMOVECLONE:");
            } else {
                txt.append("\tMOVE:");
            }
            for (int index = 0; index < this.getNumberOfMovements(); ++index) {
                if (index > 0) {
                    txt.append(',');
                }
                if (this.getMovementTypes()[index] != null && this.getMovementTypes()[index].length() > 0) {
                    txt.append(this.getMovementTypes()[index]).append(",");
                }
                if (this.getMovementMultOp(index).length() > 0) {
                    txt.append(this.getMovementMultOp(index)).append(this.getMovementMult(index));
                    continue;
                }
                txt.append(this.getMovement(index));
            }
        }
        if (this.nonProficiencyPenalty != -4) {
            txt.append("\tNONPP:").append(this.nonProficiencyPenalty);
        }
        if (this.templateSize != null && this.templateSize.length() > 0) {
            txt.append("\tSIZE:").append(this.templateSize);
        }
        if (!"None".equals(this.weightString)) {
            txt.append("\tWEIGHT:").append(this.weightString);
        }
        if (!"alwaysValid".equals(this.getQualifyString())) {
            txt.append("\tQUALIFY:").append(this.getQualifyString());
        }
        if (!"None".equals(this.region)) {
            txt.append("\tREGION:");
            if (this.region.equals(this.getName())) {
                txt.append("Yes");
            } else {
                txt.append(this.region);
            }
        }
        if (!this.removable) {
            txt.append("\tREMOVABLE:No");
        }
        if (!"None".equals(this.subRace)) {
            txt.append("\tSUBRACE:");
            if (this.subRace.equals(this.getName())) {
                txt.append("Yes");
            } else {
                txt.append(this.subRace);
            }
        }
        if (!"None".equals(this.subregion)) {
            txt.append("\tSUBREGION:");
            if (this.subregion.equals(this.getName())) {
                txt.append("Yes");
            } else {
                txt.append(this.subregion);
            }
        }
        if (PCTemplate.getListSize(this.templates) > 0) {
            Iterator e3 = this.templates.iterator();
            while (e3.hasNext()) {
                txt.append("\tTEMPLATE:").append((String)e3.next());
            }
        }
        switch (this.templateVisible) {
            case 3: {
                txt.append("\tVISIBLE:DISPLAY");
                break;
            }
            case 2: {
                txt.append("\tVISIBLE:EXPORT");
                break;
            }
            case 0: {
                txt.append("\tVISIBLE:NO");
                break;
            }
            default: {
                txt.append("\tVISIBLE:YES");
            }
        }
        if (PCTemplate.getListSize(this.weaponProfBonus) > 0) {
            StringBuffer buffer2 = new StringBuffer();
            e2 = this.weaponProfBonus.iterator();
            while (e2.hasNext()) {
                if (buffer2.length() != 0) {
                    buffer2.append('|');
                }
                buffer2.append((String)e2.next());
            }
            txt.append("\tWEAPONBONUS:").append(buffer2.toString());
        }
        txt.append(super.getPCCText(false, aPC));
        return txt.toString();
    }

    public boolean isQualified(PlayerCharacter aPC) {
        if (aPC == null) {
            return false;
        }
        return PrereqHandler.passesAll(this.getPreReqList(), aPC, this);
    }

    public void setRegion(String argRegion) {
        this.region = argRegion;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRemovable(boolean argRemovable) {
        this.removable = argRemovable;
    }

    public boolean isRemovable() {
        boolean result = false;
        if (this.templateVisible == 1 || this.templateVisible == 3) {
            result = this.removable;
        }
        return result;
    }

    public int getSR(int level, int hitdice, PlayerCharacter aPC) {
        int x;
        int aSR = this.getSR(aPC);
        for (x = 0; x < PCTemplate.getListSize(this.levelStrings); ++x) {
            if (!PCTemplate.contains(this.levelStrings.get(x).toString(), "SR:") || !this.doesLevelQualify(level, x)) continue;
            aSR = Math.max(Integer.parseInt(PCTemplate.getStringAfter("SR:", this.levelStrings.get(x).toString())), aSR);
        }
        for (x = 0; x < PCTemplate.getListSize(this.hitDiceStrings); ++x) {
            if (!PCTemplate.contains(this.hitDiceStrings.get(x).toString(), "SR:") || !this.doesHitDiceQualify(hitdice, x)) continue;
            aSR = Math.max(Integer.parseInt(PCTemplate.getStringAfter("SR:", this.hitDiceStrings.get(x).toString())), aSR);
        }
        return aSR;
    }

    public List getSpecialAbilityList(int level, int hitdice) {
        SpecialAbility sa;
        String saString;
        int x;
        ArrayList specialAbilityList = super.getSpecialAbilityList();
        if (specialAbilityList == null || specialAbilityList.isEmpty()) {
            return specialAbilityList;
        }
        ArrayList aList = (ArrayList)specialAbilityList.clone();
        for (x = 0; x < PCTemplate.getListSize(this.levelStrings); ++x) {
            if (!PCTemplate.contains(this.levelStrings.get(x).toString(), "SA:") || !this.doesLevelQualify(level, x)) continue;
            saString = PCTemplate.getStringAfter("SA:", this.levelStrings.get(x).toString());
            sa = new SpecialAbility(saString);
            aList.add(sa);
        }
        for (x = 0; x < PCTemplate.getListSize(this.hitDiceStrings); ++x) {
            if (!PCTemplate.contains(this.hitDiceStrings.get(x).toString(), "SA:") || !this.doesHitDiceQualify(hitdice, x)) continue;
            saString = PCTemplate.getStringAfter("SA:", this.hitDiceStrings.get(x).toString());
            sa = new SpecialAbility(saString);
            aList.add(sa);
        }
        return aList;
    }

    public void setSubRace(String argSubRace) {
        this.subRace = argSubRace;
    }

    public String getSubRace() {
        return this.subRace;
    }

    public void setSubRegion(String argSubregion) {
        this.subregion = argSubregion;
    }

    public String getSubRegion() {
        return this.subregion;
    }

    public List getTemplateList() {
        return this.templates;
    }

    public void setTemplateSize(String argSize) {
        this.templateSize = argSize;
    }

    public String getTemplateSize() {
        return this.templateSize;
    }

    public void setVisible(int argTemplateVisible) {
        this.templateVisible = argTemplateVisible;
    }

    public int isVisible() {
        return this.templateVisible;
    }

    public void setWeaponProfBonus(String aString) {
        if (this.weaponProfBonus == null) {
            this.weaponProfBonus = new ArrayList();
        }
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        while (aTok.hasMoreTokens()) {
            this.weaponProfBonus.add(aTok.nextToken());
        }
    }

    public ArrayList getWeaponProfBonus() {
        if (this.weaponProfBonus == null) {
            return new ArrayList();
        }
        return this.weaponProfBonus;
    }

    public int getWeaponProfBonusSize() {
        return PCTemplate.getListSize(this.weaponProfBonus);
    }

    public void setWeightString(String argWeightString) {
        this.weightString = argWeightString;
    }

    public void addChosenFeat(String mapKey, String mapValue) {
        if (this.chosenFeatStrings == null) {
            this.chosenFeatStrings = new HashMap();
        }
        this.chosenFeatStrings.put(mapKey, mapValue);
    }

    public void addFeatString(String featString) {
        if (".CLEAR".equals(featString)) {
            if (this.featStrings != null) {
                this.featStrings.clear();
            }
            return;
        }
        StringTokenizer aTok = new StringTokenizer(featString, "|", false);
        while (aTok.hasMoreTokens()) {
            String fs = aTok.nextToken();
            if (this.featStrings == null) {
                this.featStrings = new ArrayList();
            }
            this.featStrings.add(fs);
        }
    }

    public void addHitDiceString(String hitDiceString) {
        if (".CLEAR".equals(hitDiceString)) {
            if (this.hitDiceStrings != null) {
                this.hitDiceStrings.clear();
            }
            return;
        }
        if (this.hitDiceStrings == null) {
            this.hitDiceStrings = new ArrayList();
        }
        this.hitDiceStrings.add(hitDiceString);
    }

    public void addLevelString(String levelString) {
        if (".CLEAR".equals(levelString)) {
            if (this.levelStrings != null) {
                this.levelStrings.clear();
            }
            return;
        }
        if (this.levelStrings == null) {
            this.levelStrings = new ArrayList();
        }
        this.levelStrings.add(levelString);
    }

    public void addTemplate(String argTemplate) {
        if (".CLEAR".equals(argTemplate)) {
            this.templates.clear();
        } else if (argTemplate.startsWith("ADDCHOICE:")) {
            String template = argTemplate.substring(10);
            for (int i = 0; i < this.templates.size(); ++i) {
                String aString = (String)this.templates.get(i);
                if (!aString.startsWith("CHOOSE:")) continue;
                aString = aString + "|" + template;
                this.templates.set(i, aString);
                break;
            }
        } else {
            this.templates.add(argTemplate);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PCTemplate aTemp = (PCTemplate)super.clone();
        aTemp.templateVisible = this.templateVisible;
        aTemp.templates = (ArrayList)this.templates.clone();
        aTemp.languageBonus = (TreeSet)this.languageBonus.clone();
        if (PCTemplate.getListSize(this.levelStrings) != 0) {
            aTemp.levelStrings = (ArrayList)this.levelStrings.clone();
        }
        if (PCTemplate.getListSize(this.hitDiceStrings) != 0) {
            aTemp.hitDiceStrings = (ArrayList)this.hitDiceStrings.clone();
        }
        if (PCTemplate.getListSize(this.weaponProfBonus) != 0) {
            aTemp.weaponProfBonus = (ArrayList)this.weaponProfBonus.clone();
        }
        if (PCTemplate.getListSize(this.featStrings) != 0) {
            aTemp.featStrings = (ArrayList)this.featStrings.clone();
        }
        if (this.chosenFeatStrings != null) {
            aTemp.chosenFeatStrings = (HashMap)this.chosenFeatStrings.clone();
        }
        return aTemp;
    }

    public List feats(int level, int hitdice, PlayerCharacter aPC) {
        String featName;
        String featKey;
        int x;
        ArrayList feats = PCTemplate.getListSize(this.featStrings) != 0 ? (ArrayList)this.featStrings.clone() : new ArrayList();
        if (this.chosenFeatStrings != null) {
            feats.addAll(this.chosenFeatStrings.values());
        }
        for (x = 0; x < PCTemplate.getListSize(this.levelStrings); ++x) {
            featKey = "L" + Integer.toString(x);
            featName = null;
            if (this.chosenFeatStrings != null) {
                featName = (String)this.chosenFeatStrings.get(featKey);
            }
            if (featName != null || !this.doesLevelQualify(level, x)) continue;
            this.getLevelFeat(this.levelStrings.get(x).toString(), level, featKey, aPC);
        }
        for (x = 0; x < PCTemplate.getListSize(this.hitDiceStrings); ++x) {
            featKey = "H" + Integer.toString(x);
            featName = null;
            if (this.chosenFeatStrings != null) {
                featName = (String)this.chosenFeatStrings.get(featKey);
            }
            if (featName != null || !this.doesHitDiceQualify(hitdice, x)) continue;
            this.getLevelFeat(this.hitDiceStrings.get(x).toString(), -1, featKey, aPC);
        }
        return feats;
    }

    public String modifierString(PlayerCharacter aPC) {
        int x;
        StringBuffer mods = new StringBuffer(50);
        for (x = 0; x < SettingsHandler.getGame().getUnmodifiableStatList().size(); ++x) {
            if (this.isNonAbility(x)) {
                mods.append(PCTemplate.statName(x)).append(":nonability ");
                continue;
            }
            int statMod = this.getStatMod(x, aPC);
            if (statMod == 0) continue;
            mods.append(PCTemplate.statName(x)).append(':').append(statMod).append(' ');
        }
        if (!this.hitDieLock.equals("")) {
            mods.append("HITDIE:" + this.hitDieLock);
        }
        if (aPC == null) {
            if (this.CR != 0) {
                mods.append("CR:").append(this.CR).append(' ');
            }
            if ((x = this.getSR(aPC)) != 0) {
                mods.append("SR:").append(x).append(' ');
            }
            if (this.DR != null && !"".equals(this.DR)) {
                mods.append("DR:").append(this.DR).append(' ');
            }
            return mods.toString();
        }
        int nat = (int)this.bonusTo("COMBAT", "AC", aPC, aPC);
        if (nat != 0) {
            mods.append("AC BONUS:").append(nat);
        }
        if (this.getCR(aPC.getTotalLevels(), aPC.totalHitDice()) != 0) {
            mods.append("CR:").append(this.getCR(aPC.getTotalLevels(), aPC.totalHitDice())).append(' ');
        }
        if (this.getSR(aPC.getTotalLevels(), aPC.totalHitDice(), aPC) != 0) {
            mods.append("SR:").append(this.getSR(aPC.getTotalLevels(), aPC.totalHitDice(), aPC)).append(' ');
        }
        if (!this.getDR(aPC.getTotalLevels(), aPC.totalHitDice()).equals("")) {
            mods.append("DR:").append(this.getDR(aPC.getTotalLevels(), aPC.totalHitDice())).append(' ');
        }
        return mods.toString();
    }

    List getTemplates(boolean isImporting, PlayerCharacter aPC) {
        ArrayList<String> newTemplates = new ArrayList<String>();
        this.templatesAdded = new ArrayList();
        if (!isImporting) {
            Iterator e = this.templates.iterator();
            while (e.hasNext()) {
                String templateName = (String)e.next();
                if (templateName.startsWith("CHOOSE:")) {
                    templateName = PCTemplate.chooseTemplate(templateName.substring(7), true, aPC);
                }
                if (templateName.length() == 0) continue;
                newTemplates.add(templateName);
                this.templatesAdded.add(templateName);
            }
        }
        return newTemplates;
    }

    List addSpecialAbilitiesToList(List aList, int level, int hitdice) {
        ArrayList specialAbilityList = this.getSpecialAbilityList();
        if (specialAbilityList != null) {
            aList.addAll(this.getSpecialAbilityList(level, hitdice));
        }
        return aList;
    }

    void chooseLanguageAutos(boolean flag, PlayerCharacter aPC) {
        if (!flag && !"".equals(this.chooseLanguageAutos)) {
            StringTokenizer tokens = new StringTokenizer(this.chooseLanguageAutos, "|", false);
            ChooserInterface c = ChooserFactory.getChooserInstance();
            c.setPool(1);
            c.setPoolFlag(false);
            c.setTitle("Pick a Language: ");
            SortedSet<String> list = new TreeSet<String>();
            while (tokens.hasMoreTokens()) {
                list.add(tokens.nextToken());
            }
            list = Globals.extractLanguageListNames(list);
            c.setAvailableList(new ArrayList(list));
            c.setVisible(true);
            ArrayList selectedList = c.getSelectedList();
            if (selectedList != null && selectedList.size() != 0) {
                aPC.addFreeLanguage((String)selectedList.get(0));
            }
        }
    }

    static String chooseTemplate(String templateList, PlayerCharacter aPC) {
        return PCTemplate.chooseTemplate(templateList, false, aPC);
    }

    static String chooseTemplate(String templateList, boolean forceChoice, PlayerCharacter aPC) {
        List choiceTemplates = CoreUtility.split(templateList, '|');
        for (int i = choiceTemplates.size() - 1; i >= 0; --i) {
            String templateName = (String)choiceTemplates.get(i);
            PCTemplate template = Globals.getTemplateNamed(templateName);
            if (template != null && PrereqHandler.passesAll(template.getPreReqList(), aPC, template)) continue;
            choiceTemplates.remove(i);
        }
        if (choiceTemplates.size() == 1) {
            return (String)choiceTemplates.get(0);
        }
        if (choiceTemplates.size() > 0) {
            return Globals.chooseFromList("Template Choice", choiceTemplates, null, 1, forceChoice);
        }
        return "";
    }

    List templatesAdded() {
        if (this.templatesAdded == null) {
            return new ArrayList();
        }
        return this.templatesAdded;
    }

    private static int getListSize(List al) {
        int result = 0;
        if (al != null) {
            result = al.size();
        }
        return result;
    }

    private static String getStringAfter(String stuff, String string) {
        int index = string.indexOf(stuff) + stuff.length();
        return string.substring(index);
    }

    private static boolean contains(String string, String stuff) {
        return string.indexOf(stuff) > -1;
    }

    private static String statName(int x) {
        return SettingsHandler.getGame().s_ATTRIBSHORT[x];
    }

    private void getLevelFeat(String levelString, int lvl, String featKey, PlayerCharacter aPC) {
        if (PCTemplate.contains(levelString, "FEAT:")) {
            String featName = PCTemplate.getStringAfter("FEAT:", levelString);
            block4: while (true) {
                ArrayList featList = new ArrayList();
                LevelAbility la = LevelAbility.createAbility(this, lvl, "FEAT(" + featName + ")");
                la.process(featList, aPC);
                switch (featList.size()) {
                    case 1: {
                        featName = featList.get(0).toString();
                        break block4;
                    }
                    default: {
                        if (!aPC.isImporting()) {
                            Collections.sort(featList);
                            ChooserInterface c = ChooserFactory.getChooserInstance();
                            c.setPool(1);
                            c.setTitle("Feat Choice");
                            c.setAvailableList(featList);
                            c.setVisible(true);
                            featList = c.getSelectedList();
                            if (featList != null && featList.size() != 0) {
                                featName = featList.get(0).toString();
                                continue block4;
                            }
                        }
                    }
                    case 0: {
                        return;
                    }
                }
                break;
            }
            this.addChosenFeat(featKey, featName);
        }
    }

    private boolean doesHitDiceQualify(int hitdice, int x) {
        if (x >= PCTemplate.getListSize(this.hitDiceStrings)) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer((String)this.hitDiceStrings.get(x), ":");
        String hitDiceString = tokens.nextToken();
        if (hitDiceString.endsWith("+")) {
            return Integer.parseInt(hitDiceString.substring(0, hitDiceString.length() - 1)) <= hitdice;
        }
        tokens = new StringTokenizer(hitDiceString, "-");
        return hitdice >= Integer.parseInt(tokens.nextToken()) && hitdice <= Integer.parseInt(tokens.nextToken());
    }

    private boolean doesLevelQualify(int level, int x) {
        if (x >= PCTemplate.getListSize(this.levelStrings)) {
            return false;
        }
        StringTokenizer stuff = new StringTokenizer((String)this.levelStrings.get(x), ":");
        return level >= Integer.parseInt(stuff.nextToken());
    }
}

