/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.Campaign;
import pcgen.core.Constants;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Feat;
import pcgen.core.FeatMultipleChoice;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.LevelAbility;
import pcgen.core.LevelAbilityFeat;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SystemCollections;
import pcgen.core.Variable;
import pcgen.core.VariableList;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.EmptyIterator;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.EntityEncoder;
import pcgen.io.PCGIOHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Delta;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public class PObject
implements Cloneable,
Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private static boolean dontRecurse = false;
    protected ArrayList associatedList = null;
    protected ArrayList autoArray = null;
    protected ArrayList bonusList = new ArrayList();
    protected ArrayList cSkillList = null;
    protected ArrayList ccSkillList = null;
    protected ArrayList kits = null;
    protected ArrayList levelAbilityList = null;
    protected ArrayList udamList = null;
    protected ArrayList umultList = null;
    protected ArrayList weaponProfAutos = null;
    protected Campaign sourceCampaign = null;
    protected HashMap preReqSpellLevelMap = null;
    protected HashMap sourceMap = new HashMap();
    protected HashMap spellInfoMap = null;
    protected HashMap spellLevelMap = null;
    protected Map vision = null;
    protected String DR = null;
    protected String SR = null;
    protected String choiceString = "";
    protected String classSkillString = null;
    protected String keyName = "";
    protected String name = "";
    protected String outputName = "";
    protected String regionString = null;
    protected boolean isSpecified = false;
    protected boolean visible = true;
    String sourceFile = null;
    private ArrayList characterSpellList = null;
    private ArrayList myTypeList = null;
    private ArrayList preReqList = null;
    private ArrayList saveList = null;
    private ArrayList selectedArmorProfs = null;
    private ArrayList selectedShieldProfs = null;
    private ArrayList selectedWeaponProfBonus = null;
    private ArrayList specialAbilityList = null;
    private ArrayList tempBonusList = new ArrayList();
    private HashMap bonusMap = null;
    private HashMap changeProfMap = new HashMap();
    private HashMap spellMap;
    private Double movement;
    private List naturalWeapons = new ArrayList();
    private List virtualFeatList = new LinkedList();
    private String description = "";
    private String qualifyString = "alwaysValid";
    private String source = "";
    private String sourcePage = "";
    private String tempDesc = "";
    private TreeSet languageAutos = null;
    private VariableList variableList = null;
    private Double[] movementMult;
    private String[] movementMultOp;
    private String[] movementTypes;
    private Double[] movements;
    private boolean descIsPI = false;
    private boolean isApplied = false;
    private boolean isNewItem = true;
    private boolean nameIsPI = false;
    private int baseQuantity = 1;
    private int encumberedArmorMoveInt = 0;
    private int encumberedLoadMoveInt = 0;
    private int moveRatesFlag;
    protected List templates = new ArrayList();
    protected List templatesAdded = null;

    public final void setAssociated(int index, String aString) {
        this.associatedList.set(index, aString);
    }

    public final String getAssociated(int idx) {
        return this.getAssociated(idx, false);
    }

    public final String getAssociated(int idx, boolean expand) {
        if (expand && this.associatedList.get(0) instanceof FeatMultipleChoice) {
            for (int i = 0; i < this.associatedList.size(); ++i) {
                FeatMultipleChoice fmc = (FeatMultipleChoice)this.associatedList.get(i);
                int iCount = fmc.getChoiceCount();
                if (idx < iCount) {
                    return fmc.getChoice(idx);
                }
                idx -= iCount;
            }
            return "";
        }
        return this.associatedList.get(idx).toString();
    }

    public final int getAssociatedCount() {
        return this.getAssociatedCount(false);
    }

    public final int getAssociatedCount(boolean expand) {
        if (this.associatedList == null) {
            return 0;
        }
        if (expand && this.associatedList.get(0) instanceof FeatMultipleChoice) {
            int iCount = 0;
            for (int i = 0; i < this.associatedList.size(); ++i) {
                iCount += ((FeatMultipleChoice)this.associatedList.get(i)).getChoiceCount();
            }
            return iCount;
        }
        return this.associatedList.size();
    }

    public final Object getAssociatedObject(int idx) {
        return this.associatedList.get(idx);
    }

    public final ArrayList getAutoArray() {
        return this.autoArray;
    }

    public final Set getAutoLanguageNames() {
        Set aSet = this.getAutoLanguages();
        TreeSet<String> bSet = new TreeSet<String>();
        Iterator i = aSet.iterator();
        while (i.hasNext()) {
            bSet.add(i.next().toString());
        }
        return bSet;
    }

    public final Set getAutoLanguages() {
        TreeSet aSet = new TreeSet();
        if (this.languageAutos == null || this.languageAutos.isEmpty()) {
            return aSet;
        }
        aSet.addAll(this.languageAutos);
        return aSet;
    }

    public final void setBaseQty(String aString) {
        try {
            this.baseQuantity = Integer.parseInt(aString);
        }
        catch (NumberFormatException e) {
            this.baseQuantity = 0;
            Logging.errorPrint("Badly formed BaseQty string: " + aString);
        }
    }

    public final int getBaseQty() {
        return this.baseQuantity;
    }

    public final void setCcSkillList(String aString) {
        if (aString == null || aString.length() <= 0) {
            return;
        }
        if (this.ccSkillList == null) {
            this.ccSkillList = new ArrayList();
        }
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        boolean isClearing = false;
        while (aTok.hasMoreTokens()) {
            Iterator e1;
            String bString = aTok.nextToken();
            if (bString.startsWith(".CLEAR") || isClearing) {
                isClearing = true;
                if (".CLEAR".equals(bString)) {
                    this.ccSkillList.clear();
                    continue;
                }
                if (bString.startsWith(".CLEAR")) {
                    bString = bString.substring(7);
                }
                if (bString.startsWith("TYPE.") || bString.startsWith("TYPE=")) {
                    String typeString = bString.substring(5);
                    e1 = Globals.getSkillList().iterator();
                    while (e1.hasNext()) {
                        Skill aSkill = (Skill)e1.next();
                        boolean toClear = true;
                        StringTokenizer cTok = new StringTokenizer(typeString, ".");
                        while (cTok.hasMoreTokens() && toClear) {
                            if (aSkill.isType(cTok.nextToken())) continue;
                            toClear = false;
                        }
                        if (!toClear) continue;
                        this.ccSkillList.remove(aSkill.getName());
                    }
                    continue;
                }
                this.ccSkillList.remove(bString);
                continue;
            }
            if (bString.startsWith("TYPE.") || bString.startsWith("TYPE=")) {
                e1 = Globals.getSkillList().iterator();
                while (e1.hasNext()) {
                    Skill aSkill = (Skill)e1.next();
                    if (!aSkill.isType(bString.substring(5))) continue;
                    this.ccSkillList.add(aSkill.getName());
                }
                continue;
            }
            this.ccSkillList.add(bString);
        }
    }

    public final ArrayList getCcSkillList() {
        return this.ccSkillList;
    }

    public final List getCharacterSpell(Spell aSpell, String book, int level) {
        return this.getCharacterSpell(aSpell, book, level, null);
    }

    public final ArrayList getCharacterSpell(Spell aSpell, String book, int level, ArrayList fList) {
        ArrayList<CharacterSpell> aList = new ArrayList<CharacterSpell>();
        if (this.getCharacterSpellCount() == 0) {
            return aList;
        }
        Iterator i = this.characterSpellList.iterator();
        while (i.hasNext()) {
            SpellInfo si;
            CharacterSpell cs = (CharacterSpell)i.next();
            if (aSpell != null && !cs.getSpell().equals(aSpell) || (si = cs.getSpellInfoFor(book, level, -1, fList)) == null) continue;
            aList.add(cs);
        }
        return aList;
    }

    public final int getCharacterSpellCount() {
        if (this.characterSpellList == null) {
            return 0;
        }
        return this.characterSpellList.size();
    }

    public final CharacterSpell getCharacterSpellForSpell(Spell aSpell, PObject anOwner) {
        if (aSpell == null || this.characterSpellList == null) {
            return null;
        }
        Iterator i = this.characterSpellList.iterator();
        while (i.hasNext()) {
            CharacterSpell cs = (CharacterSpell)i.next();
            Spell bSpell = cs.getSpell();
            if (!aSpell.equals(bSpell) || anOwner != null && !cs.getOwner().equals(anOwner)) continue;
            return cs;
        }
        return null;
    }

    public List getCharacterSpellList() {
        return this.characterSpellList;
    }

    public final void setDescIsPI(boolean a) {
        this.descIsPI = a;
    }

    public final boolean getDescIsPI() {
        return this.descIsPI;
    }

    public final void setDescription(String a) {
        this.description = a;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setKitString(String arg) {
        if (arg.equals(".CLEAR")) {
            this.kits = null;
        } else {
            if (this.kits == null) {
                this.kits = new ArrayList();
            }
            if (!this.kits.contains(arg)) {
                this.kits.add(arg);
            }
        }
    }

    public final String getKitString(int idx) {
        if (this.kits == null || idx < 0 || idx >= this.kits.size()) {
            return null;
        }
        return (String)this.kits.get(idx);
    }

    public final ArrayList getLevelAbilityList() {
        return this.levelAbilityList;
    }

    public final void setNameIsPI(boolean a) {
        this.nameIsPI = a;
    }

    public final boolean getNameIsPI() {
        return this.nameIsPI;
    }

    public List getBonusList() {
        return this.bonusList;
    }

    public List getBonusListOfType(String aType, String aName) {
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (!aBonus.getTypeOfBonus().startsWith(aType)) continue;
            if (aBonus.getBonusInfoList().size() > 1) {
                StringTokenizer aTok = new StringTokenizer(aBonus.getBonusInfo(), ",");
                while (aTok.hasMoreTokens()) {
                    String aBI = aTok.nextToken();
                    if (!aBI.equals(aName)) continue;
                    aList.add(aBonus);
                }
                continue;
            }
            if (!aBonus.getBonusInfo().equals(aName)) continue;
            aList.add(aBonus);
        }
        return aList;
    }

    public HashMap getBonusMap() {
        if (this.bonusMap == null) {
            this.bonusMap = new HashMap();
        }
        return this.bonusMap;
    }

    public final void setCSkillList(String aString) {
        this.classSkillString = aString;
        this.refreshCSkillList();
    }

    public final ArrayList getCSkillList() {
        return this.cSkillList;
    }

    public final void setMoveRatesFlag(int i) {
        this.moveRatesFlag = i;
    }

    public final int getMoveRatesFlag() {
        return this.moveRatesFlag;
    }

    public final Double getMovement() {
        return this.movement;
    }

    public final Double getMovement(int i) {
        if (this.movements != null && i < this.movements.length) {
            return this.movements[i];
        }
        return new Double(0.0);
    }

    public void setMovement(Double anInt) {
        this.movement = new Double(anInt.toString());
    }

    public void setMovement(int anInt) {
        this.movement = new Double(anInt);
    }

    public final Double getMovementMult(int index) {
        return this.movementMult[index];
    }

    public final String getMovementMultOp(int index) {
        return this.movementMultOp[index];
    }

    public int getEncumberedArmorMove() {
        return this.encumberedArmorMoveInt;
    }

    public int getEncumberedLoadMove() {
        return this.encumberedLoadMoveInt;
    }

    public void setMoveRates(String moveparse) {
        StringTokenizer moves = new StringTokenizer(moveparse, ",");
        int newmove = 0;
        if (moves.countTokens() == 1) {
            String tok = moves.nextToken();
            if (tok.length() > 0 && (tok.charAt(0) == '*' || tok.charAt(0) == '/')) {
                this.setMovement(newmove);
                this.movements = new Double[1];
                this.movements[0] = this.getMovement();
                this.movementTypes = new String[1];
                this.movementMult = new Double[1];
                this.movementMult[0] = new Double(tok.substring(1));
                this.movementMultOp = new String[1];
                this.movementMultOp[0] = tok.substring(0, 1);
            } else if (tok.length() > 0) {
                try {
                    newmove = Integer.parseInt(tok);
                }
                catch (NumberFormatException e) {
                    Logging.errorPrint("Badly formed movement string: " + tok);
                    newmove = 0;
                }
                this.setMovement(newmove);
                this.movements = new Double[1];
                this.movements[0] = this.getMovement();
                this.movementTypes = new String[1];
                this.movementMult = new Double[1];
                this.movementMult[0] = new Double(0.0);
                this.movementMultOp = new String[1];
                this.movementMultOp[0] = "";
            }
            this.movementTypes[0] = "Walk";
        } else {
            int arraySize = moves.countTokens() / 2;
            this.movements = new Double[arraySize];
            this.movementTypes = new String[arraySize];
            this.movementMult = new Double[arraySize];
            this.movementMultOp = new String[arraySize];
            int x = 0;
            while (moves.countTokens() > 1) {
                this.movementTypes[x] = moves.nextToken();
                this.movementMult[x] = new Double(0.0);
                this.movementMultOp[x] = "";
                String tok = moves.nextToken();
                if (tok.length() > 0 && (tok.charAt(0) == '*' || tok.charAt(0) == '/')) {
                    this.movementMult[x] = new Double(tok.substring(1));
                    this.movementMultOp[x] = tok.substring(0, 1);
                    this.movements[x] = new Double(0.0);
                } else if (tok.length() > 0) {
                    this.movementMult[x] = new Double(0.0);
                    this.movementMultOp[x] = "";
                    try {
                        newmove = Integer.parseInt(tok);
                    }
                    catch (NumberFormatException e) {
                        Logging.errorPrint("Badly formed MOVE token: " + tok);
                        newmove = 0;
                    }
                    this.movements[x] = new Double(newmove);
                    if ("Walk".equals(this.movementTypes[x])) {
                        this.setMovement(this.movements[x]);
                    }
                }
                ++x;
            }
        }
    }

    public String getMovementType(int i) {
        if (this.movementTypes != null && i < this.movementTypes.length) {
            return this.movementTypes[i];
        }
        return "";
    }

    public void setMovementTypes(String[] arrayString) {
        this.movementTypes = arrayString;
    }

    public void setNaturalWeapons(List aList) {
        this.naturalWeapons = aList;
    }

    public List getNaturalWeapons() {
        return this.naturalWeapons;
    }

    public int getNumberOfMovementTypes() {
        return this.movementTypes != null ? this.movementTypes.length : 0;
    }

    public int getNumberOfMovements() {
        return this.movements != null ? this.movements.length : 0;
    }

    public ArrayList getTempBonusList() {
        return this.tempBonusList;
    }

    public final void setTempDescription(String aString) {
        this.tempDesc = aString;
    }

    public final String getTempDescription() {
        return this.tempDesc;
    }

    public final ArrayList getUmultList() {
        return this.umultList;
    }

    public void setUnencumberedMove(String aString) {
        this.encumberedLoadMoveInt = 0;
        this.encumberedArmorMoveInt = 0;
        StringTokenizer st = new StringTokenizer(aString, "|");
        while (st.hasMoreTokens()) {
            String loadString = st.nextToken();
            if (loadString.equalsIgnoreCase("MediumLoad")) {
                this.encumberedLoadMoveInt = 1;
                continue;
            }
            if (loadString.equalsIgnoreCase("HeavyLoad")) {
                this.encumberedLoadMoveInt = 2;
                continue;
            }
            if (loadString.equalsIgnoreCase("Overload")) {
                this.encumberedLoadMoveInt = 3;
                continue;
            }
            if (loadString.equalsIgnoreCase("MediumArmor")) {
                this.encumberedArmorMoveInt = 1;
                continue;
            }
            if (loadString.equalsIgnoreCase("HeavyArmor")) {
                this.encumberedArmorMoveInt = 3;
                continue;
            }
            if (loadString.equalsIgnoreCase("LightLoad") || loadString.equalsIgnoreCase("LightArmor")) continue;
            ShowMessageDelegate.showMessageDialog("Invalid value of \"" + loadString + "\" for UNENCUMBEREDMOVE in \"" + this.getName() + "\".", "PCGen", MessageType.ERROR);
        }
    }

    public final int getVariableCount() {
        if (this.variableList == null) {
            return 0;
        }
        return this.variableList.size();
    }

    public final Set getVariableNamesAsUnmodifiableSet() {
        if (this.variableList == null) {
            this.variableList = new VariableList();
        }
        return this.variableList.getVariableNamesAsUnmodifiableSet();
    }

    public List getVirtualFeatList() {
        return this.virtualFeatList;
    }

    public final void addWeaponProfAutos(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        if (this.weaponProfAutos == null) {
            this.weaponProfAutos = new ArrayList();
        }
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if (".CLEAR".equals(bString)) {
                this.weaponProfAutos.clear();
                continue;
            }
            if (this.weaponProfAutos.contains(bString)) continue;
            this.weaponProfAutos.add(bString);
        }
    }

    public ArrayList getWeaponProfAutos() {
        return this.weaponProfAutos;
    }

    public final void addAllToAssociated(Collection collection) {
        if (this.associatedList == null) {
            this.associatedList = new ArrayList();
        }
        this.associatedList.addAll(collection);
    }

    public final void addAssociated(String aString) {
        if (this.associatedList == null) {
            this.associatedList = new ArrayList();
        }
        this.associatedList.add(aString);
    }

    public final void addAssociated(FeatMultipleChoice aFeatChoices) {
        if (this.associatedList == null) {
            this.associatedList = new ArrayList();
        }
        this.associatedList.add(aFeatChoices);
    }

    public final void addAssociatedTo(Collection collection) {
        if (this.associatedList != null) {
            collection.addAll(this.associatedList);
        }
    }

    public final boolean addBonusList(String aString) {
        return this.addBonusList(aString, this);
    }

    public final boolean addBonusList(String aString, Object obj) {
        BonusObj aBonus;
        if (this.bonusList == null) {
            this.bonusList = new ArrayList();
        }
        if ((aBonus = Bonus.newBonus(aString)) != null) {
            aBonus.setCreatorObject(obj);
            this.bonusList.add(aBonus);
        }
        return aBonus != null;
    }

    public List getActiveBonuses(PlayerCharacter aPC) {
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (!aBonus.isApplied()) continue;
            aList.add(aBonus);
        }
        return aList;
    }

    public boolean getBonusListString(String aString) {
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            if (!aBonus.getBonusInfo().equalsIgnoreCase(aString)) continue;
            return true;
        }
        return false;
    }

    public void activateBonuses(PlayerCharacter aPC) {
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            aBonus.setApplied(false);
            if (aBonus.hasPreReqs()) {
                if (PrereqHandler.passesAll(aBonus.getPrereqList(), aPC, this)) {
                    aBonus.setApplied(true);
                    continue;
                }
                aBonus.setApplied(false);
                continue;
            }
            aBonus.setApplied(true);
        }
    }

    public void addBonusList(BonusObj aBonus) {
        this.bonusList.add(aBonus);
    }

    public final void addCharacterSpell(CharacterSpell spell) {
        if (this.characterSpellList == null) {
            this.characterSpellList = new ArrayList();
        }
        this.characterSpellList.add(spell);
    }

    public final void clearPreReq() {
        this.preReqList = null;
    }

    public final void addPreReq(Prerequisite preReq) {
        this.addPreReq(preReq, -1);
    }

    public final void addPreReq(Prerequisite preReq, int anInt) {
        if ("clear".equals(preReq.getKind())) {
            this.preReqList = null;
        } else {
            if (this.preReqList == null) {
                this.preReqList = new ArrayList();
            }
            if (anInt > 0) {
                preReq.setLevelQualifier(anInt);
            }
            this.preReqList.add(preReq);
        }
    }

    public final void addSave(String aString) {
        if (this.saveList == null) {
            this.saveList = new ArrayList();
        }
        this.saveList.add(aString);
    }

    public final void addSelectedWeaponProfBonus(String entry) {
        if (this.selectedWeaponProfBonus == null) {
            this.selectedWeaponProfBonus = new ArrayList();
        }
        this.selectedWeaponProfBonus.add(entry);
    }

    public final void addSpecialAbilityToList(SpecialAbility sa) {
        if (this.specialAbilityList == null) {
            this.specialAbilityList = new ArrayList();
        }
        this.specialAbilityList.add(sa);
    }

    public void addTempBonus(BonusObj aBonus) {
        this.getTempBonusList().add(aBonus);
    }

    public final void addUdamList(String addString) {
        if (this.udamList == null) {
            this.udamList = new ArrayList();
        }
        if (".CLEAR".equals(addString)) {
            this.udamList.clear();
        } else {
            this.udamList.add(addString);
        }
    }

    public final void addUmult(String mult) {
        if (this.umultList == null) {
            this.umultList = new ArrayList();
        }
        if (".CLEAR".equals(mult)) {
            this.umultList.clear();
        } else {
            this.umultList.add(mult);
        }
    }

    public final void addVariable(int level, String variableName, String defaultFormula) {
        if (this.variableList == null) {
            this.variableList = new VariableList();
        }
        this.variableList.add(level, variableName, defaultFormula);
    }

    public final void addVirtualFeat(Feat aFeat) {
        if (this.virtualFeatList == null) {
            this.virtualFeatList = new LinkedList();
        }
        this.virtualFeatList.add(aFeat);
    }

    public final void addVirtualFeats(List aFeatList) {
        if (this.virtualFeatList == null) {
            this.virtualFeatList = new LinkedList();
        }
        this.virtualFeatList.addAll(aFeatList);
    }

    public final void clearVariableList() {
        if (this.variableList != null) {
            this.variableList.clear();
        }
    }

    public List getChangeProfList(PlayerCharacter character) {
        LinkedList<String> aList = new LinkedList<String>();
        Iterator e = this.changeProfMap.keySet().iterator();
        while (e.hasNext()) {
            String aName;
            String aKey = e.next().toString();
            String newProfType = this.changeProfMap.get(aKey).toString();
            if (aKey.startsWith("TYPE.")) {
                Iterator eq = EquipmentList.getEquipmentOfType(EquipmentList.getEquipmentList(), aKey.substring(5), "").iterator();
                while (eq.hasNext()) {
                    aName = ((Equipment)eq.next()).profName(character);
                    aList.add(aName + "|" + newProfType);
                }
                continue;
            }
            Equipment aEq = EquipmentList.getEquipmentNamed(aKey);
            if (aEq == null) continue;
            aName = aEq.profName(character);
            aList.add(aName + "|" + newProfType);
            String aName2 = aEq.profName(1, character);
            if (aName2.equals(aName) || aName2.equals(aEq.getName())) continue;
            aList.add(aName2 + "|" + newProfType);
        }
        return aList;
    }

    public HashMap getSpellInfoMapPassesPrereqs(String aKey, PlayerCharacter aPC) {
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        if (this.spellInfoMap == null) {
            return tempMap;
        }
        if (this.spellInfoMap.containsKey(aKey)) {
            String wType = aKey.substring(0, aKey.indexOf("|"));
            String wName = (String)this.spellInfoMap.get(aKey);
            String spellName = aKey.substring(aKey.indexOf("|") + 1);
            int wLevel = Integer.parseInt(wName.substring(wName.indexOf("|") + 1));
            wName = wName.substring(0, wName.indexOf("|"));
            if (this.preReqSpellLevelMap != null && this.preReqSpellLevelMap.containsKey(wType + "|" + wName + "|" + spellName)) {
                if (wName.startsWith("SPELLCASTER")) {
                    String spellType = wName.substring(12);
                    if (("ALL".equals(spellType) || aPC.isSpellCaster(spellType, 1)) && PrereqHandler.passesAll((List)this.preReqSpellLevelMap.get(wType + "|" + wName + "|" + spellName), aPC, null)) {
                        Iterator iClass = aPC.getClassList().iterator();
                        while (iClass.hasNext()) {
                            PCClass aClass = (PCClass)iClass.next();
                            if (!aClass.getSpellType().equals(spellType) && !"ALL".equals(spellType)) continue;
                            tempMap.put(aClass.getSpellKey(), new Integer(wLevel));
                        }
                    }
                } else if (PrereqHandler.passesAll((List)this.preReqSpellLevelMap.get(wType + "|" + wName + "|" + spellName), aPC, null)) {
                    tempMap.put(wType + "|" + wName, new Integer(wLevel));
                }
            }
        }
        return tempMap;
    }

    public HashMap getSpellMapPassesPrereqs(PlayerCharacter character, int levelMatch) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        if (this.spellLevelMap == null) {
            return tempMap;
        }
        Iterator sm = this.spellLevelMap.keySet().iterator();
        while (sm.hasNext()) {
            String key = sm.next().toString();
            int levelInt = -1;
            try {
                levelInt = Integer.parseInt((String)this.spellLevelMap.get(key));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if ((levelMatch != -1 || levelInt < 0) && (levelMatch < 0 || levelInt != levelMatch) || this.preReqSpellLevelMap == null || !this.preReqSpellLevelMap.containsKey(key)) continue;
            if (key.startsWith("CLASS|SPELLCASTER")) {
                String spellType = key.substring(18);
                if (!"ALL".equals(spellType = spellType.substring(0, spellType.indexOf("|"))) && !character.isSpellCaster(spellType, 1) || !PrereqHandler.passesAll((List)this.preReqSpellLevelMap.get(key), character, null)) continue;
                Iterator iClass = character.getClassList().iterator();
                while (iClass.hasNext()) {
                    PCClass aClass = (PCClass)iClass.next();
                    if (!aClass.getSpellType().equals(spellType) && !"ALL".equals(spellType)) continue;
                    tempMap.put(aClass.getSpellKey() + "|" + key.substring(key.lastIndexOf("|") + 1), Integer.toString(levelInt));
                }
                continue;
            }
            if (!PrereqHandler.passesAll((List)this.preReqSpellLevelMap.get(key), character, null)) continue;
            tempMap.put(key, Integer.toString(levelInt));
        }
        return tempMap;
    }

    public void setVision(String aString, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        while (aTok.hasMoreTokens()) {
            Object bObj;
            String aVal;
            String aKey;
            StringTokenizer cTok;
            String dString;
            String cString;
            String bString = aTok.nextToken();
            if (".CLEAR".equals(bString)) {
                this.vision = null;
                continue;
            }
            if (bString.indexOf(44) < 0) {
                cString = bString;
                dString = bString;
            } else {
                StringTokenizer bTok = new StringTokenizer(bString, ",");
                cString = bTok.nextToken();
                dString = bTok.nextToken();
            }
            if (cString.startsWith(".CLEAR.") || "2".equals(cString)) {
                Object aKey2;
                if (this.vision == null) continue;
                if (cString.startsWith(".CLEAR.")) {
                    dString = dString.substring(7);
                }
                if ((aKey2 = this.vision.get(dString)) == null) continue;
                this.vision.remove(dString);
                continue;
            }
            if (cString.startsWith(".SET.") || "0".equals(cString)) {
                if (this.vision == null) {
                    this.vision = new HashMap();
                }
                this.vision.clear();
                if (cString.startsWith(".SET.")) {
                    dString = dString.substring(5);
                }
                cTok = new StringTokenizer(dString, "(')");
                aKey = cTok.nextToken().trim();
                aVal = cTok.nextToken();
                this.vision.put(aKey, aVal);
                continue;
            }
            if (this.vision == null) {
                this.vision = new HashMap();
            }
            cTok = new StringTokenizer(dString, "(')");
            aKey = cTok.nextToken().trim();
            Globals.putVisionMap(aKey);
            aVal = "0";
            if (cTok.hasMoreTokens()) {
                aVal = cTok.nextToken();
            }
            if ((bObj = this.vision.get(aKey)) == null) {
                this.vision.put(aKey, aVal);
                continue;
            }
            if (aPC != null) {
                int b = aPC.getVariableValue(bObj.toString(), "").intValue();
                if (b >= aPC.getVariableValue(aVal, "").intValue()) continue;
                this.vision.put(aKey, aVal);
                continue;
            }
            this.vision.put(aKey, aVal);
        }
    }

    public Map getVision(PlayerCharacter aPC) {
        return this.vision;
    }

    public void addChangeProf(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        while (aTok.hasMoreTokens()) {
            String nPart = aTok.nextToken();
            String newProf = "";
            int indx = nPart.indexOf(61);
            if (indx <= 1) {
                Logging.errorPrint("Malformed CHANGEPROF tag: " + nPart);
                continue;
            }
            newProf = nPart.substring(indx + 1);
            nPart = nPart.substring(0, indx);
            StringTokenizer bTok = new StringTokenizer(nPart, ",");
            while (bTok.hasMoreTokens()) {
                String eqString = bTok.nextToken();
                this.changeProfMap.put(eqString, newProf);
            }
        }
    }

    public void addSpellLevel(String line) {
        String nameList;
        StringTokenizer aTok = new StringTokenizer(line, "|");
        if (aTok.countTokens() < 3) {
            Logging.errorPrint("Badly formed SPELLLEVEL tag1: " + line);
            return;
        }
        String tagType = aTok.nextToken();
        ArrayList<String> preList = new ArrayList<String>();
        ArrayList<String> wNameList = new ArrayList<String>();
        ArrayList<String> wSpellList = new ArrayList<String>();
        while (aTok.hasMoreTokens()) {
            nameList = aTok.nextToken();
            if (nameList.startsWith("PRE") || nameList.startsWith("!PRE")) {
                preList.add(nameList);
                break;
            }
            if (nameList.indexOf("=") < 0) {
                Logging.errorPrint("Badly formed SPELLLEVEL tag2: " + line);
                return;
            }
            wNameList.add(nameList);
            if (!aTok.hasMoreTokens()) {
                Logging.errorPrint("Badly formed SPELLLEVEL tag3: " + line);
                return;
            }
            wSpellList.add(aTok.nextToken());
        }
        while (aTok.hasMoreTokens()) {
            nameList = aTok.nextToken();
            if (nameList.startsWith("PRE") || nameList.startsWith("!PRE")) {
                preList.add(nameList);
                continue;
            }
            Logging.errorPrint("Badly formed SPELLLEVEL PRE tag: " + line);
            return;
        }
        Iterator iSpell = wSpellList.iterator();
        Iterator iName = wNameList.iterator();
        while (iSpell.hasNext() || iName.hasNext()) {
            if (!iSpell.hasNext() || !iName.hasNext()) {
                Logging.errorPrint("Badly formed SPELLLEVEL tag4: " + line);
                return;
            }
            StringTokenizer bTok = new StringTokenizer((String)iSpell.next(), ",");
            String classList = (String)iName.next();
            while (bTok.hasMoreTokens()) {
                String spellLevel = classList.substring(classList.indexOf("=") + 1);
                String spellName = bTok.nextToken();
                StringTokenizer cTok = new StringTokenizer(classList.substring(0, classList.indexOf("=")), ",");
                while (cTok.hasMoreTokens()) {
                    String className = cTok.nextToken();
                    if (this.spellLevelMap == null) {
                        this.spellLevelMap = new HashMap();
                        this.spellInfoMap = new HashMap();
                        this.preReqSpellLevelMap = new HashMap();
                    }
                    if (className.startsWith("SPELLCASTER.")) {
                        this.preReqSpellLevelMap.put(tagType + "|" + className + "|" + spellName, preList);
                        this.spellLevelMap.put(tagType + "|" + className + "|" + spellName, spellLevel);
                        this.spellInfoMap.put(tagType + "|" + spellName, className + "|" + spellLevel);
                        continue;
                    }
                    if (this.spellLevelMap.containsKey(tagType + "|" + className + "|" + spellName)) continue;
                    this.preReqSpellLevelMap.put(tagType + "|" + className + "|" + spellName, preList);
                    this.spellLevelMap.put(tagType + "|" + className + "|" + spellName, spellLevel);
                    this.spellInfoMap.put(tagType + "|" + spellName, className + "|" + spellLevel);
                }
            }
        }
    }

    public void addSpells(List aSpellList) {
        this.addSpells(0, aSpellList);
    }

    public void addSpells(int level, List aSpellList) {
        String aLevel = Integer.toString(level);
        if (this.spellMap == null) {
            this.spellMap = new HashMap();
        }
        Iterator iter = aSpellList.iterator();
        while (iter.hasNext()) {
            ArrayList aList;
            Object spell = iter.next();
            if (!this.spellMap.containsKey(aLevel)) {
                aList = new ArrayList();
                this.spellMap.put(aLevel, aList);
            }
            if ((aList = (ArrayList)this.spellMap.get(aLevel)).contains(spell)) continue;
            aList.add(spell);
        }
    }

    public final boolean containsAssociated(String associated) {
        if (this.associatedList == null) {
            return false;
        }
        if (this.associatedList.get(0) instanceof FeatMultipleChoice) {
            for (int i = 0; i < this.associatedList.size(); ++i) {
                FeatMultipleChoice fmc = (FeatMultipleChoice)this.associatedList.get(i);
                String aString = fmc.toString().toUpperCase();
                if (aString.indexOf(associated) < 0) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.associatedList.size(); ++i) {
                String aString = (String)this.associatedList.get(i);
                if (!aString.equalsIgnoreCase(associated)) continue;
                return true;
            }
        }
        return this.associatedList.contains(associated);
    }

    public final boolean containsSave(String save) {
        if (this.saveList == null) {
            return false;
        }
        return this.saveList.contains(save);
    }

    public void addNaturalWeapon(Equipment weapon, int level) {
        this.naturalWeapons.add(weapon);
        this.addWeaponProfAutos(weapon.getSimpleName());
    }

    public void deactivateBonuses() {
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            aBonus.setApplied(false);
        }
    }

    public final boolean hasPreReqTypeOf(String matchType) {
        if (this.getPreReqCount() == 0) {
            return false;
        }
        for (int i = 0; i < this.getPreReqCount(); ++i) {
            Prerequisite prereq = this.getPreReq(i);
            if (prereq == null) continue;
            if (matchType == null && prereq.getKind() == null) {
                return true;
            }
            if (!matchType.equalsIgnoreCase(prereq.getKind())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasVariableNamed(String variableName) {
        if (this.variableList == null) {
            return false;
        }
        return this.variableList.hasVariableNamed(variableName);
    }

    public double bonusTo(String aType, String aName, Object obj, PlayerCharacter aPC) {
        return this.bonusTo(aType, aName, obj, this.getBonusList(), aPC);
    }

    public double bonusTo(String aType, String aName, Object obj, List aBonusList, PlayerCharacter aPC) {
        if (aBonusList == null || aBonusList.size() == 0) {
            return 0.0;
        }
        double retVal = 0.0;
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        String aTypePlusName = aType + '.' + aName + '.';
        if (!dontRecurse && this instanceof Feat && !Globals.checkRule("FEATPRE")) {
            dontRecurse = true;
            boolean returnZero = false;
            if (!PrereqHandler.passesAll(this.getPreReqList(), aPC, this)) {
                returnZero = true;
            }
            dontRecurse = false;
            if (returnZero) {
                return 0.0;
            }
        }
        int iTimes = 1;
        if ("VAR".equals(aType)) {
            iTimes = Math.max(1, this.getAssociatedCount());
            if (this.choiceString.startsWith("SALIST|") && this.choiceString.indexOf("|VAR|") >= 0) {
                iTimes = 1;
            }
        }
        Iterator b = aBonusList.iterator();
        while (b.hasNext()) {
            BonusObj aBonus = (BonusObj)b.next();
            String bString = aBonus.toString().toUpperCase();
            if (this.getAssociatedCount() != 0) {
                int span = 4;
                int idx = bString.indexOf("%VAR");
                if (idx == -1) {
                    idx = bString.indexOf("%LIST|");
                    span = 5;
                }
                if (idx >= 0) {
                    String firstPart = bString.substring(0, idx);
                    String secondPart = bString.substring(idx + span);
                    for (int i = 1; i < this.getAssociatedCount(); ++i) {
                        String xString = (firstPart + this.getAssociated(i) + secondPart).toUpperCase();
                        retVal += this.calcBonus(xString, aType, aName, aTypePlusName, obj, iTimes, aBonus, aPC);
                    }
                    bString = (firstPart + this.getAssociated(0) + secondPart).toUpperCase();
                }
            }
            retVal += this.calcBonus(bString, aType, aName, aTypePlusName, obj, iTimes, aBonus, aPC);
        }
        return retVal;
    }

    public double calcBonusFrom(BonusObj aBonus, Object anObj) {
        return this.calcBonusFrom(aBonus, anObj, null);
    }

    public double calcBonusFrom(BonusObj aBonus, Object anObj, String listString) {
        int iTimes = 1;
        String aType = aBonus.getTypeOfBonus();
        if ("VAR".equals(aType)) {
            iTimes = Math.max(1, this.getAssociatedCount());
            if (this.choiceString.startsWith("SALIST|") && this.choiceString.indexOf("|VAR|") >= 0) {
                iTimes = 1;
            }
        }
        return this.calcPartialBonus(iTimes, aBonus, anObj, listString, Globals.getCurrentPC());
    }

    public final void clearAssociated() {
        this.associatedList = null;
    }

    public Object clone() throws CloneNotSupportedException {
        PObject retVal = (PObject)super.clone();
        retVal.setName(this.name);
        retVal.outputName = new String(this.outputName);
        retVal.description = this.description;
        retVal.tempDesc = this.tempDesc;
        retVal.sourceFile = this.sourceFile;
        retVal.visible = this.visible;
        retVal.source = this.source;
        retVal.sourcePage = this.sourcePage;
        retVal.qualifyString = this.qualifyString;
        retVal.setKeyName(this.keyName);
        retVal.choiceString = this.choiceString;
        retVal.isSpecified = this.isSpecified;
        retVal.baseQuantity = this.baseQuantity;
        retVal.SR = this.SR;
        retVal.DR = this.DR;
        if (this.sourceMap != null) {
            retVal.sourceMap = new HashMap();
            retVal.sourceMap.putAll(this.sourceMap);
        }
        retVal.changeProfMap = new HashMap(this.changeProfMap);
        if (this.virtualFeatList != null) {
            retVal.virtualFeatList = new LinkedList(this.virtualFeatList);
        }
        if (this.preReqList != null) {
            retVal.preReqList = (ArrayList)this.preReqList.clone();
        }
        if (this.associatedList != null) {
            retVal.associatedList = (ArrayList)this.associatedList.clone();
        }
        if (this.myTypeList != null) {
            retVal.myTypeList = (ArrayList)this.myTypeList.clone();
        }
        if (this.selectedWeaponProfBonus != null) {
            retVal.selectedWeaponProfBonus = (ArrayList)this.selectedWeaponProfBonus.clone();
        }
        if (this.characterSpellList != null) {
            retVal.characterSpellList = (ArrayList)this.characterSpellList.clone();
        }
        if (this.udamList != null) {
            retVal.udamList = (ArrayList)this.udamList.clone();
        }
        if (this.umultList != null) {
            retVal.umultList = (ArrayList)this.umultList.clone();
        }
        if (this.bonusList != null) {
            retVal.bonusList = (ArrayList)this.bonusList.clone();
            retVal.ownBonuses();
        }
        if (this.tempBonusList != null) {
            retVal.tempBonusList = (ArrayList)this.tempBonusList.clone();
        }
        if (this.variableList != null) {
            retVal.variableList = (VariableList)this.variableList.clone();
        }
        if (this.cSkillList != null) {
            retVal.cSkillList = (ArrayList)this.cSkillList.clone();
        }
        if (this.ccSkillList != null) {
            retVal.ccSkillList = (ArrayList)this.ccSkillList.clone();
        }
        if (this.spellMap != null) {
            retVal.spellMap = new HashMap(this.spellMap);
        }
        if (this.weaponProfAutos != null) {
            retVal.weaponProfAutos = (ArrayList)this.weaponProfAutos.clone();
        }
        if (this.specialAbilityList != null) {
            retVal.specialAbilityList = (ArrayList)this.specialAbilityList.clone();
        }
        if (this.bonusMap != null) {
            retVal.bonusMap = new HashMap(this.bonusMap);
        }
        if (this.autoArray != null) {
            retVal.autoArray = (ArrayList)this.autoArray.clone();
        }
        if (this.kits != null) {
            retVal.kits = (ArrayList)this.kits.clone();
        }
        if (this.selectedArmorProfs != null) {
            retVal.selectedArmorProfs = (ArrayList)this.selectedArmorProfs.clone();
        }
        if (this.selectedShieldProfs != null) {
            retVal.selectedShieldProfs = (ArrayList)this.selectedShieldProfs.clone();
        }
        retVal.saveList = null;
        retVal.languageAutos = this.languageAutos;
        retVal.vision = this.vision;
        retVal.regionString = this.regionString;
        retVal.moveRatesFlag = this.moveRatesFlag;
        retVal.movement = this.movement;
        retVal.movements = this.movements;
        retVal.movementTypes = this.movementTypes;
        retVal.movementMult = this.movementMult;
        retVal.movementMultOp = this.movementMultOp;
        if (this.levelAbilityList != null && !this.levelAbilityList.isEmpty()) {
            retVal.levelAbilityList = new ArrayList();
            Iterator it = this.levelAbilityList.iterator();
            while (it.hasNext()) {
                LevelAbility ab = (LevelAbility)it.next();
                ab = (LevelAbility)ab.clone();
                ab.setOwner(retVal);
                retVal.levelAbilityList.add(ab);
            }
        }
        return retVal;
    }

    public int compareTo(Object obj) {
        if (obj != null) {
            return this.name.compareToIgnoreCase(((PObject)obj).name);
        }
        return 1;
    }

    public void ownBonuses() {
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            aBonus.setCreatorObject(this);
        }
    }

    public final String preReqHTMLStrings(PlayerCharacter aPC) {
        if (this.getPreReqCount() == 0) {
            return "";
        }
        return this.preReqHTMLStringsForList(aPC, this.preReqList);
    }

    public String preReqHTMLStrings(PlayerCharacter aPC, boolean includeHeader) {
        if (this.getPreReqCount() == 0) {
            return "";
        }
        return this.preReqHTMLStringsForList(aPC, null, this.preReqList, includeHeader);
    }

    public final String preReqHTMLStrings(PlayerCharacter aPC, PObject p) {
        if (this.getPreReqCount() == 0) {
            return "";
        }
        return this.preReqHTMLStringsForList(aPC, p, this.preReqList);
    }

    public final String preReqHTMLStringsForList(PlayerCharacter aPC, PObject aObj, List aList, boolean includeHeader) {
        if (aList == null || aList.isEmpty()) {
            return "";
        }
        StringBuffer pString = new StringBuffer(aList.size() * 20);
        ArrayList<Prerequisite> newList = new ArrayList<Prerequisite>();
        int iter = 0;
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            newList.clear();
            Prerequisite p = (Prerequisite)e.next();
            newList.add(p);
            if (iter++ > 0) {
                pString.append(" and ");
            }
            String bString = PrereqHandler.toHtmlString(newList);
            boolean flag = aPC != null ? PrereqHandler.passesAll(newList, aPC, this) : (aObj instanceof Equipment ? PrereqHandler.passesAll(newList, (Equipment)aObj) : PrereqHandler.passesAll(newList, aPC, null));
            if (!flag) {
                pString.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                pString.append("<i>");
            }
            StringTokenizer aTok = new StringTokenizer(bString, "&<>", true);
            while (aTok.hasMoreTokens()) {
                String aString = aTok.nextToken();
                if (aString.equals("<")) {
                    pString.append("&lt;");
                    continue;
                }
                if (aString.equals(">")) {
                    pString.append("&gt;");
                    continue;
                }
                if (aString.equals("&")) {
                    pString.append("&amp;");
                    continue;
                }
                pString.append(aString);
            }
            if (flag) continue;
            pString.append("</i>");
            pString.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
        }
        if (pString.toString().indexOf(60) >= 0) {
            pString.insert(0, "<font>");
            pString.append("</font>");
            if (includeHeader && pString.toString().indexOf(60) >= 0) {
                pString.insert(0, "<html>");
                pString.append("</html>");
            }
        }
        return pString.toString();
    }

    public final String preReqStrings() {
        if (this.getPreReqCount() == 0) {
            return "";
        }
        return PrereqHandler.toHtmlString(this.preReqList);
    }

    public void putBonusMap(String aKey, String aVal) {
        this.getBonusMap().put(aKey, aVal);
    }

    public final void refreshCSkillList() {
        if (this.classSkillString == null || this.classSkillString.length() <= 0) {
            return;
        }
        if (this.cSkillList == null) {
            this.cSkillList = new ArrayList();
        }
        StringTokenizer aTok = new StringTokenizer(this.classSkillString, "|");
        boolean isClearing = false;
        while (aTok.hasMoreTokens()) {
            Iterator e1;
            String bString = aTok.nextToken();
            if (bString.startsWith(".CLEAR") || isClearing) {
                isClearing = true;
                if (".CLEAR".equals(bString)) {
                    this.cSkillList.clear();
                    continue;
                }
                if (bString.startsWith(".CLEAR")) {
                    bString = bString.substring(7);
                }
                if (bString.startsWith("TYPE.") || bString.startsWith("TYPE=")) {
                    String typeString = bString.substring(5);
                    e1 = Globals.getSkillList().iterator();
                    while (e1.hasNext()) {
                        Skill aSkill = (Skill)e1.next();
                        boolean toClear = true;
                        StringTokenizer cTok = new StringTokenizer(typeString, ".");
                        while (cTok.hasMoreTokens() && toClear) {
                            if (aSkill.isType(cTok.nextToken())) continue;
                            toClear = false;
                        }
                        if (!toClear) continue;
                        this.cSkillList.remove(aSkill.getName());
                    }
                    continue;
                }
                this.cSkillList.remove(bString);
                continue;
            }
            if (bString.startsWith("TYPE.") || bString.startsWith("TYPE=")) {
                e1 = Globals.getSkillList().iterator();
                while (e1.hasNext()) {
                    Skill aSkill = (Skill)e1.next();
                    if (!aSkill.isType(bString.substring(5))) continue;
                    this.cSkillList.add(aSkill.getName());
                }
                continue;
            }
            this.cSkillList.add(bString);
        }
    }

    public void setChoiceString(String aString) {
        this.choiceString = aString;
    }

    public final String getChoiceString() {
        return this.choiceString;
    }

    public final void getChoices(String aChoice, List selectedBonusList, PlayerCharacter aPC) {
        ArrayList availableList = new ArrayList();
        ArrayList selectedList = new ArrayList();
        this.getChoices(aChoice, selectedBonusList, this, availableList, selectedList, true, aPC);
    }

    public void setDR(String drString) {
        this.DR = ".CLEAR".equals(drString) ? null : (this.DR == null || this.DR.length() == 0 ? drString : '|' + drString);
    }

    public String getDR() {
        return this.DR;
    }

    public final void setKeyName(String aString) {
        this.keyName = aString;
    }

    public final String getKeyName() {
        return this.keyName;
    }

    public void setName(String aString) {
        if (!aString.endsWith(".MOD")) {
            this.fireNameChanged(this.name, aString);
            this.name = aString;
            this.keyName = aString;
        }
    }

    public String getName() {
        return this.name;
    }

    public final void setNewItem(boolean newItem) {
        this.isNewItem = newItem;
    }

    public final boolean isNewItem() {
        return this.isNewItem;
    }

    public final void setOutputName(String aString) {
        String newName = aString;
        int nameIndex = newName.indexOf("[NAME]");
        if (nameIndex >= 0) {
            StringBuffer sb = new StringBuffer(newName.substring(0, nameIndex));
            sb.append(this.getPreFormatedOutputName());
            if (newName.length() > nameIndex + 6) {
                sb.append(newName.substring(nameIndex + 6));
            }
            newName = sb.toString();
        }
        this.outputName = newName;
    }

    public final String getOutputName() {
        if (this.outputName.length() == 0) {
            return this.name;
        }
        return this.outputName;
    }

    public final Prerequisite getPreReq(int i) {
        return (Prerequisite)this.preReqList.get(i);
    }

    public final int getPreReqCount() {
        if (this.preReqList == null) {
            return 0;
        }
        return this.preReqList.size();
    }

    public final ArrayList getPreReqList() {
        return this.preReqList;
    }

    public final void setQualifyString(String aString) {
        this.qualifyString = aString;
    }

    public final String getQualifyString() {
        return this.qualifyString;
    }

    public void setSR(String newSR) {
        this.SR = ".CLEAR".equals(newSR) ? null : newSR;
    }

    public String getSRFormula() {
        return this.SR;
    }

    public final String getSave(int i) {
        return (String)this.saveList.get(i);
    }

    public final int getSaveCount() {
        if (this.saveList == null) {
            return 0;
        }
        return this.saveList.size();
    }

    public final String getSelectedWeaponProfBonus(int i) {
        return (String)this.selectedWeaponProfBonus.get(i);
    }

    public final int getSelectedWeaponProfBonusCount() {
        if (this.selectedWeaponProfBonus == null) {
            return 0;
        }
        return this.selectedWeaponProfBonus.size();
    }

    public final void setSource(String aSource) {
        StringTokenizer aTok = new StringTokenizer(aSource, "|");
        while (aTok.hasMoreTokens()) {
            String arg = aTok.nextToken();
            if (arg.equals(".CLEAR")) {
                this.sourceMap.clear();
                continue;
            }
            String key = arg.substring(6, arg.indexOf(":"));
            String val = arg.substring(arg.indexOf(":") + 1);
            this.sourceMap.put(key, val);
        }
    }

    public final void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public final String getSourceFile() {
        return this.sourceFile;
    }

    public final String getSourceInForm(int sourceDisplay) {
        return this.returnSourceInForm(sourceDisplay, true);
    }

    public final void setSourceMap(Map arg) {
        Iterator i = arg.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (this.sourceMap.get(key) != null) continue;
            this.sourceMap.put(key, arg.get(key));
        }
    }

    public final String getSourceShort(int maxNumberofChars) {
        String shortString = this.returnSourceInForm(1, false);
        if (shortString.length() > maxNumberofChars) {
            shortString = shortString.substring(0, maxNumberofChars);
        }
        return shortString;
    }

    public final String getSourceWeb() {
        return this.returnSourceInForm(3, false);
    }

    public final String getSourceWithKey(String key) {
        return (String)this.sourceMap.get(key);
    }

    public String getSource() {
        return this.getSourceInForm(Globals.getSourceDisplay());
    }

    public final String getSourceNoPage() {
        return this.returnSourceInForm(0, false);
    }

    public final String getSourcePage() {
        return this.returnSourceInForm(2, false);
    }

    public final ArrayList getSpecialAbilityList() {
        if (this.specialAbilityList == null) {
            this.specialAbilityList = new ArrayList();
        }
        return this.specialAbilityList;
    }

    public final SpecialAbility getSpecialAbilityNamed(String aName) {
        if (this.specialAbilityList != null) {
            Iterator i = this.specialAbilityList.iterator();
            while (i.hasNext()) {
                SpecialAbility sa = (SpecialAbility)i.next();
                if (!sa.getName().equalsIgnoreCase(aName)) continue;
                return sa;
            }
        }
        return null;
    }

    public String getSpellKey() {
        return "POBJECT|" + this.name;
    }

    public final void addLanguageAutos(String aString) {
        if (this.languageAutos == null) {
            this.languageAutos = new TreeSet();
        }
        StringTokenizer aTok = new StringTokenizer(aString, ",");
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if (".CLEAR".equals(bString)) {
                this.languageAutos.clear();
                continue;
            }
            if ("ALL".equals(bString)) {
                this.languageAutos.addAll(Globals.getLanguageList());
                continue;
            }
            if (bString.startsWith("TYPE=") || bString.startsWith("TYPE.")) {
                String aType = bString.substring(5);
                List bList = Globals.getLanguageList();
                bList = Globals.getLanguagesFromListOfType(bList, aType);
                this.languageAutos.addAll(bList);
                continue;
            }
            Language aLang = Globals.getLanguageNamed(bString);
            if (aLang == null) continue;
            this.languageAutos.add(aLang);
        }
    }

    public String getMyType(int i) {
        if (i < this.getMyTypeCount()) {
            return (String)this.myTypeList.get(i);
        }
        return null;
    }

    public int getMyTypeCount() {
        if (this.myTypeList == null) {
            return 0;
        }
        return this.myTypeList.size();
    }

    public Iterator getMyTypeIterator() {
        Iterator result = EmptyIterator.EMPTY_ITERATOR;
        if (this.myTypeList != null) {
            result = this.myTypeList.iterator();
        }
        return result;
    }

    public List getSpellList() {
        ArrayList aList = new ArrayList();
        if (this instanceof PCClass && this.spellMap != null) {
            int classLevel = ((PCClass)this).getLevel();
            Iterator e = this.spellMap.keySet().iterator();
            while (e.hasNext()) {
                int level;
                String aString = e.next().toString();
                try {
                    level = Integer.parseInt(aString);
                }
                catch (NumberFormatException nfe) {
                    Logging.errorPrint("NFE on getSpellList. Shouldn't happen.");
                    continue;
                }
                if (classLevel < level) continue;
                aList.addAll((List)this.spellMap.get(aString));
            }
            return aList;
        }
        if (this.spellMap != null) {
            Iterator e = this.spellMap.keySet().iterator();
            while (e.hasNext()) {
                String aString = e.next().toString();
                aList.addAll((List)this.spellMap.get(aString));
            }
            return aList;
        }
        return null;
    }

    public final void clearSpecialAbilityList() {
        this.specialAbilityList = null;
    }

    public final void clearSpellList() {
        this.spellMap = null;
    }

    public String getType() {
        int x = this.getMyTypeCount();
        if (x == 0) {
            return "";
        }
        StringBuffer aType = new StringBuffer(x * 5);
        for (int i = 0; i < x; ++i) {
            aType.append(i == 0 ? "" : ".").append(this.getMyType(i));
        }
        return aType.toString();
    }

    public boolean isType(String aType) {
        String myType = aType.length() > 0 && aType.charAt(0) == '!' ? aType.substring(1).toUpperCase() : aType.toUpperCase();
        return this.containsMyType(myType);
    }

    public void setTypeInfo(String aString) {
        boolean bRemove = false;
        StringTokenizer aTok = new StringTokenizer(aString.toUpperCase().trim(), ".");
        while (aTok.hasMoreTokens()) {
            String aType = aTok.nextToken();
            if (bRemove) {
                this.removeMyType(aType);
                bRemove = false;
                continue;
            }
            if ("ADD".equals(aType)) {
                bRemove = false;
                continue;
            }
            if ("REMOVE".equals(aType)) {
                bRemove = true;
                continue;
            }
            if ("CLEAR".equals(aType)) {
                this.clearMyType();
                continue;
            }
            if (this.containsMyType(aType)) continue;
            this.doGlobalTypeUpdate(aType);
            this.addMyType(aType);
        }
    }

    public final ArrayList getUdamList() {
        return this.udamList;
    }

    public final Variable getVariable(int i) {
        if (this.variableList != null) {
            return this.variableList.getVariable(i);
        }
        return null;
    }

    public final String getVariableDefinition(int i) {
        if (this.variableList != null) {
            return this.variableList.getDefinition(i);
        }
        return null;
    }

    public final Iterator getVariableIterator() {
        if (this.variableList == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.variableList.iterator();
    }

    public String parseOutputName(String aString, PlayerCharacter aPC) {
        int varIndex = aString.indexOf(124);
        if (varIndex <= 0) {
            return aString;
        }
        StringTokenizer varTokenizer = new StringTokenizer(aString, "|");
        String preVarStr = varTokenizer.nextToken();
        ArrayList<Float> varArray = new ArrayList<Float>();
        ArrayList<String> tokenList = new ArrayList<String>();
        while (varTokenizer.hasMoreElements()) {
            String token = varTokenizer.nextToken();
            tokenList.add(token.toUpperCase());
            varArray.add(aPC.getVariableValue(token, ""));
        }
        StringBuffer result = new StringBuffer();
        int varCount = 0;
        int subIndex = preVarStr.indexOf(37);
        int lastIndex = 0;
        while (subIndex >= 0) {
            if (subIndex > 0) {
                result.append(preVarStr.substring(lastIndex, subIndex));
            }
            String token = (String)tokenList.get(varCount);
            Float val = (Float)varArray.get(varCount);
            if (token.endsWith(".INTVAL")) {
                result.append(String.valueOf(val.intValue()));
            } else {
                result.append(val.toString());
            }
            lastIndex = subIndex + 1;
            ++varCount;
            subIndex = preVarStr.indexOf(37, lastIndex);
        }
        if (preVarStr.length() > lastIndex) {
            result.append(preVarStr.substring(lastIndex));
        }
        return result.toString();
    }

    public final boolean removeAssociated(String associated) {
        if (this.associatedList == null) {
            return false;
        }
        boolean ret = this.associatedList.remove(associated);
        if (this.associatedList.size() == 0) {
            this.associatedList = null;
        }
        return ret;
    }

    public void removeBonusList(BonusObj aBonus) {
        this.getBonusList().remove(aBonus);
    }

    public final void removeSave(String bonusString) {
        if (this.saveList != null) {
            int index = this.saveList.indexOf(bonusString);
            if (index >= 0) {
                this.saveList.remove(index);
            } else {
                Logging.errorPrint("removeSave: Could not find bonus: " + bonusString + " in saveList.");
            }
        } else {
            Logging.errorPrint("removeSave: Could not find bonus: " + bonusString + " in saveList.");
        }
    }

    public final void removeType(String aString) {
        String typeString = aString.toUpperCase().trim();
        StringTokenizer aTok = new StringTokenizer(typeString, ".");
        while (aTok.hasMoreTokens()) {
            String aType = aTok.nextToken();
            this.removeMyType(aType);
        }
    }

    public void resetTempBonusList() {
        this.tempBonusList = new ArrayList();
    }

    public final void sortCharacterSpellList() {
        if (this.characterSpellList != null) {
            Collections.sort(this.characterSpellList);
        }
    }

    public String getPCCText(PlayerCharacter aPC) {
        return this.getPCCText(true, aPC);
    }

    public final void setRegionString(String arg) {
        this.regionString = arg;
    }

    public final String getRegionString() {
        return this.regionString;
    }

    public final ArrayList getSelectedArmorProfs() {
        return this.selectedArmorProfs;
    }

    public final ArrayList getSelectedShieldProfs() {
        return this.selectedShieldProfs;
    }

    public final void addAutoArray(List aList) {
        if (this.autoArray == null) {
            this.autoArray = new ArrayList();
        }
        this.autoArray.addAll(aList);
    }

    public final void addAutoArray(String arg) {
        if (arg == null) {
            if (this.autoArray != null) {
                this.autoArray.clear();
            }
            return;
        }
        if (this.autoArray == null) {
            this.autoArray = new ArrayList();
        }
        this.autoArray.add(arg);
    }

    public final void addSelectedArmorProfs(List aList) {
        if (this.selectedArmorProfs == null) {
            this.selectedArmorProfs = new ArrayList();
        }
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            String aString = (String)i.next();
            if (this.selectedArmorProfs.contains(aString)) continue;
            this.selectedArmorProfs.add(aString);
        }
    }

    public final void addSelectedShieldProfs(List aList) {
        if (this.selectedShieldProfs == null) {
            this.selectedShieldProfs = new ArrayList();
        }
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            String aString = (String)i.next();
            if (this.selectedShieldProfs.contains(aString)) continue;
            this.selectedShieldProfs.add(aString);
        }
    }

    public final void clearAutoList() {
        this.autoArray = null;
    }

    public final void makeKitSelection(PlayerCharacter aPC) {
        aPC.setArmorProfListStable(false);
        this.makeKitSelection(0, aPC);
    }

    public void setSourceCampaign(String arg) {
        this.sourceCampaign = Globals.getCampaignByFilename(arg, true);
    }

    public void setSourceCampaign(Campaign arg) {
        this.sourceCampaign = arg;
    }

    public Campaign getSourceCampaign() {
        return this.sourceCampaign;
    }

    public String getSpellListItemAsString(int idx, PlayerCharacter aPC) {
        List sList = this.getSpellList();
        if (sList == null || idx >= sList.size()) {
            return null;
        }
        PCSpell spell = (PCSpell)sList.get(idx);
        return spell.getPCCText(aPC);
    }

    public int getStatMod(int statIdx, PlayerCharacter aPC) {
        List statList = SettingsHandler.getGame().getUnmodifiableStatList();
        if (statIdx < 0 || statIdx >= statList.size()) {
            return 0;
        }
        String aStat = ((PCStat)statList.get(statIdx)).getAbb();
        return (int)this.bonusTo("STAT", aStat, aPC, aPC);
    }

    public LevelAbility addAddList(int aLevel, String aString) {
        if (this.levelAbilityList == null) {
            this.levelAbilityList = new ArrayList();
        }
        if (aString.startsWith(".CLEAR")) {
            if (".CLEAR".equals(aString)) {
                this.levelAbilityList.clear();
            } else if (aString.indexOf(".LEVEL") >= 0) {
                int level;
                try {
                    level = Integer.parseInt(aString.substring(12));
                }
                catch (NumberFormatException e) {
                    Logging.errorPrint("Badly formed addAddList attribute: " + aString.substring(12));
                    level = -1;
                }
                if (level >= 0) {
                    for (int x = this.levelAbilityList.size() - 1; x >= 0; --x) {
                        LevelAbility ability = (LevelAbility)this.levelAbilityList.get(x);
                        if (ability.level() != level) continue;
                        this.levelAbilityList.remove(x);
                    }
                }
            }
        } else {
            LevelAbility la = LevelAbility.createAbility(this, aLevel, aString);
            this.levelAbilityList.add(la);
            return la;
        }
        return null;
    }

    public void makeChoices(PlayerCharacter aPC) {
        this.getChoices(this.choiceString, null, aPC);
    }

    public static boolean modChoices(PObject obj, List availableList, List selectedList, boolean process, PlayerCharacter aPC) {
        int i;
        Iterator iter;
        int maxNewSelections;
        ChooserInterface chooser;
        String choiceType;
        ArrayList<String> rootArrayList;
        ArrayList<String> aBonusList;
        int totalPossibleSelections;
        boolean multiples;
        boolean stacks;
        Feat aFeat;
        double cost;
        int numChoices;
        block232: {
            block230: {
                double x;
                block231: {
                    availableList.clear();
                    selectedList.clear();
                    String aChoiceString = obj.getChoiceString();
                    if (aChoiceString.startsWith("WEAPONPROF|") || aChoiceString.startsWith("ARMORPROF|") || aChoiceString.startsWith("SHIELDPROF|")) {
                        obj.getChoices(aChoiceString, null, availableList, selectedList, aPC);
                        return false;
                    }
                    StringTokenizer aTok = new StringTokenizer(aChoiceString, "|");
                    if (aTok.countTokens() < 1 || aPC == null || aPC.isImporting()) {
                        return false;
                    }
                    numChoices = -1;
                    cost = 1.0;
                    aFeat = null;
                    stacks = false;
                    multiples = false;
                    if (obj instanceof Feat) {
                        aFeat = (Feat)obj;
                        cost = aFeat.getCost();
                        stacks = aFeat.isStacks();
                        multiples = aFeat.isMultiples();
                    }
                    totalPossibleSelections = (int)((aPC.getFeats() + (double)obj.getAssociatedCount()) / cost);
                    if (cost <= 0.0) {
                        totalPossibleSelections = (int)(aPC.getFeats() + (double)obj.getAssociatedCount());
                    }
                    ArrayList uniqueList = new ArrayList();
                    aBonusList = new ArrayList<String>();
                    rootArrayList = new ArrayList<String>();
                    choiceType = aTok.nextToken();
                    String choiceSec = obj.getName();
                    chooser = ChooserFactory.getChooserInstance();
                    chooser.setPoolFlag(false);
                    chooser.setAllowsDups(stacks);
                    chooser.setVisible(false);
                    String title = "Choices";
                    int idxSelected = -1;
                    maxNewSelections = (int)(aPC.getFeats() / cost);
                    if (cost <= 0.0) {
                        maxNewSelections = (int)aPC.getFeats();
                    }
                    int requestedSelections = -1;
                    while (true) {
                        if (choiceType.startsWith("COUNT=")) {
                            requestedSelections = aPC.getVariableValue(choiceType.substring(6), "").intValue();
                        } else {
                            if (!choiceType.startsWith("NUMCHOICES=")) break;
                            numChoices = aPC.getVariableValue(choiceType.substring(11), "").intValue();
                        }
                        if (!aTok.hasMoreTokens()) {
                            Logging.errorPrint("not enough tokens: " + aChoiceString);
                            return false;
                        }
                        choiceType = aTok.nextToken();
                    }
                    if (Globals.weaponTypesContains(choiceType)) {
                        title = choiceType + " Weapon Choice";
                        List tArrayList = Globals.getWeaponProfs(choiceType, aPC);
                        iter = tArrayList.iterator();
                        while (iter.hasNext()) {
                            WeaponProf tempProf = (WeaponProf)iter.next();
                            availableList.add(tempProf.getName());
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("STAT".equals(choiceType)) {
                        title = "Stat Choice";
                        ArrayList<String> excludeList = new ArrayList<String>();
                        while (aTok.hasMoreTokens()) {
                            String sExclude = aTok.nextToken();
                            int iStat = SettingsHandler.getGame().getStatFromAbbrev(sExclude);
                            if (iStat < 0) continue;
                            excludeList.add(SettingsHandler.getGame().s_ATTRIBSHORT[iStat]);
                        }
                        for (int x2 = 0; x2 < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++x2) {
                            if (excludeList.contains(SettingsHandler.getGame().s_ATTRIBSHORT[x2])) continue;
                            availableList.add(SettingsHandler.getGame().s_ATTRIBSHORT[x2]);
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("SCHOOLS".equals(choiceType)) {
                        title = "School Choice";
                        availableList.addAll(SystemCollections.getUnmodifiableSchoolsList());
                        obj.addAssociatedTo(selectedList);
                    } else if ("SPELLLIST".equals(choiceType)) {
                        PObject aClass;
                        boolean needSpellbook;
                        if (process && aFeat != null) {
                            Object selectedValue;
                            ArrayList<String> aList = new ArrayList<String>();
                            aList.add("New");
                            StringBuffer sb = new StringBuffer(100);
                            for (int j = 0; j < aFeat.getAssociatedCount(); ++j) {
                                FeatMultipleChoice fmc = (FeatMultipleChoice)aFeat.getAssociatedList().get(j);
                                sb.append(aFeat.getName()).append(" (");
                                sb.append(fmc.getChoiceCount());
                                sb.append(" of ").append(fmc.getMaxChoices()).append(") ");
                                for (i = 0; i < fmc.getChoiceCount(); ++i) {
                                    if (i != 0) {
                                        sb.append(',');
                                    }
                                    sb.append(fmc.getChoice(i));
                                }
                                aList.add(sb.toString());
                                sb.setLength(0);
                            }
                            if (aList.size() > 1) {
                                InputInterface ii = InputFactory.getInputInstance();
                                selectedValue = ii.showInputDialog(null, "Please select the instance of the feat you wish to" + Constants.s_LINE_SEP + "modify, or New, from the list below.", "PCGen", MessageType.INFORMATION, aList.toArray(), aList.get(0));
                            } else {
                                selectedValue = aList.get(0);
                            }
                            if (selectedValue == null) {
                                return false;
                            }
                            idxSelected = aList.indexOf(selectedValue) - 1;
                        }
                        switch (aTok.nextToken().charAt(0)) {
                            case '1': 
                            case 'Y': {
                                needSpellbook = true;
                                break;
                            }
                            default: {
                                needSpellbook = false;
                            }
                        }
                        title = "Spell Choice";
                        ArrayList<PObject> classes = null;
                        int j = 0;
                        while ((aClass = aPC.getSpellClassAtIndex(j)) != null) {
                            if (aClass instanceof PCClass && ((PCClass)aClass).getSpellBookUsed() == needSpellbook) {
                                if (classes == null) {
                                    classes = new ArrayList<PObject>();
                                }
                                classes.add(aClass);
                            }
                            ++j;
                        }
                        if (classes != null) {
                            maxNewSelections = 0;
                            for (j = 0; j < classes.size(); ++j) {
                                aClass = (PObject)classes.get(j);
                                List aList = aClass.getCharacterSpell(null, Globals.getDefaultSpellBook(), -1);
                                iter = aList.iterator();
                                while (iter.hasNext()) {
                                    CharacterSpell cs = (CharacterSpell)iter.next();
                                    Spell aSpell = cs.getSpell();
                                    if (obj.containsAssociated(aSpell.getKeyName()) || availableList.contains(aSpell.getName())) continue;
                                    availableList.add(aSpell.getName());
                                }
                                i = aPC.getStatList().getStatModFor(((PCClass)aClass).getSpellBaseStat());
                                if (i <= maxNewSelections) continue;
                                maxNewSelections = i;
                            }
                            ArrayList assocList = obj.getAssociatedList();
                            if (assocList != null) {
                                for (int j2 = 0; j2 < assocList.size(); ++j2) {
                                    FeatMultipleChoice fmc = (FeatMultipleChoice)assocList.get(j2);
                                    List choices = fmc.getChoices();
                                    if (choices == null) continue;
                                    for (int k = 0; k < choices.size(); ++k) {
                                        if (j2 == idxSelected) {
                                            selectedList.add(choices.get(k));
                                            continue;
                                        }
                                        availableList.remove(choices.get(k));
                                    }
                                }
                            }
                            if (idxSelected >= 0) {
                                FeatMultipleChoice fmc = (FeatMultipleChoice)obj.getAssociatedObject(idxSelected);
                                requestedSelections = maxNewSelections = fmc.getMaxChoices();
                            }
                        }
                    } else if ("SALIST".equals(choiceType)) {
                        title = "Special Ability Choice";
                        PCGIOHandler.buildSALIST(aChoiceString, availableList, aBonusList);
                        obj.addAssociatedTo(selectedList);
                    } else if ("SKILLS".equals(choiceType)) {
                        title = "Skill Choice";
                        iter = aPC.getSkillList().iterator();
                        while (iter.hasNext()) {
                            Skill aSkill = (Skill)iter.next();
                            availableList.add(aSkill.getName());
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("CSKILLS".equals(choiceType)) {
                        title = "Skill Choice";
                        iter = Globals.getSkillList().iterator();
                        while (iter.hasNext()) {
                            Skill aSkill = (Skill)iter.next();
                            if (aSkill.costForPCClassList(aPC.getClassList(), aPC) != 1) continue;
                            availableList.add(aSkill.getName());
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("SKILLSNAMED".equals(choiceType) || "SKILLSNAMEDTOCSKILL".equals(choiceType) || "SKILLSNAMEDTOCCSKILL".equals(choiceType)) {
                        title = "Skill Choice";
                        while (aTok.hasMoreTokens()) {
                            Skill aSkill;
                            Iterator e1;
                            String aString = aTok.nextToken();
                            boolean startsWith = false;
                            if (aString.startsWith("TYPE.") || aString.startsWith("TYPE=")) {
                                e1 = Globals.getSkillList().iterator();
                                while (e1.hasNext()) {
                                    aSkill = (Skill)e1.next();
                                    if (!aSkill.isType(aString.substring(5))) continue;
                                    availableList.add(aSkill.getName());
                                }
                            }
                            if ("ALL".equals(aString)) {
                                e1 = Globals.getSkillList().iterator();
                                while (e1.hasNext()) {
                                    aSkill = (Skill)e1.next();
                                    availableList.add(aSkill.getName());
                                }
                            }
                            if ("CLASS".equals(aString)) {
                                e1 = Globals.getSkillList().iterator();
                                while (e1.hasNext()) {
                                    aSkill = (Skill)e1.next();
                                    if (aSkill.costForPCClassList(aPC.getClassList(), aPC) != 1) continue;
                                    availableList.add(aSkill.getName());
                                }
                            }
                            if ("CROSSCLASS".equals(aString)) {
                                e1 = Globals.getSkillList().iterator();
                                while (e1.hasNext()) {
                                    aSkill = (Skill)e1.next();
                                    if (aSkill.costForPCClassList(aPC.getClassList(), aPC) <= 1) continue;
                                    availableList.add(aSkill.getName());
                                }
                            }
                            if ("EXCLUSIVE".equals(aString)) {
                                e1 = Globals.getSkillList().iterator();
                                while (e1.hasNext()) {
                                    aSkill = (Skill)e1.next();
                                    if (aSkill.costForPCClassList(aPC.getClassList(), aPC) != 0) continue;
                                    availableList.add(aSkill.getName());
                                }
                            }
                            if (aString.endsWith("%")) {
                                startsWith = true;
                                aString = aString.substring(0, aString.length() - 1);
                            }
                            e1 = Globals.getSkillList().iterator();
                            while (e1.hasNext()) {
                                aSkill = (Skill)e1.next();
                                if (!aSkill.getKeyName().equals(aString) && (!startsWith || !aSkill.getKeyName().startsWith(aString))) continue;
                                availableList.add(aSkill.getName());
                            }
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("SKILLLIST".equals(choiceType) || "CCSKILLLIST".equals(choiceType) || "NONCLASSSKILLLIST".equals(choiceType)) {
                        title = "Skill Choice";
                        if (aTok.hasMoreTokens()) {
                            choiceSec = aTok.nextToken();
                        }
                        if (choiceSec.length() > 0 && !"LIST".equals(choiceSec)) {
                            aTok = new StringTokenizer(choiceSec, ",");
                            while (aTok.hasMoreTokens()) {
                                availableList.add(aTok.nextToken());
                            }
                        } else {
                            iter = Globals.getSkillList().iterator();
                            while (iter.hasNext()) {
                                Skill aSkill = (Skill)iter.next();
                                if ("NONCLASSSKILLLIST".equals(choiceType) && (aSkill.costForPCClassList(aPC.getClassList(), aPC) == 1 || aSkill.isExclusive())) continue;
                                int rootNameLength = aSkill.getRootName().length();
                                if (rootNameLength == 0 || aSkill.getRootName().equals(aSkill.getName())) {
                                    availableList.add(aSkill.getName());
                                }
                                boolean rootArrayContainsRootName = rootArrayList.contains(aSkill.getRootName());
                                if (rootNameLength > 0 && !rootArrayContainsRootName) {
                                    rootArrayList.add(aSkill.getRootName());
                                }
                                if (rootNameLength <= 0 || !rootArrayContainsRootName) continue;
                                availableList.add(aSkill.getName());
                            }
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("SPELLLEVEL".equals(choiceType)) {
                        StringTokenizer cTok = new StringTokenizer(aChoiceString, "[]");
                        String choices = cTok.nextToken();
                        while (cTok.hasMoreTokens()) {
                            aBonusList.add(cTok.nextToken());
                        }
                        PObject.getSpellTypeChoices(choices, availableList, uniqueList, aPC);
                        obj.addAssociatedTo(selectedList);
                        if (!process) {
                            availableList = aBonusList;
                        }
                    } else if ("SPELLS".equals(choiceType)) {
                        obj.addAssociatedTo(selectedList);
                        while (aTok.hasMoreTokens()) {
                            String line = aTok.nextToken();
                            String domainName = "";
                            String className = "";
                            if (line.startsWith("DOMAIN=") || line.startsWith("DOMAIN.")) {
                                domainName = line.substring(7);
                            } else if (line.startsWith("CLASS=") || line.startsWith("CLASS.")) {
                                className = line.substring(7);
                            }
                            for (int lvl = 0; lvl < 20; ++lvl) {
                                List aList = Globals.getSpellsIn(lvl, className, domainName);
                                availableList.addAll(aList);
                            }
                        }
                    } else if ("WEAPONFOCUS".equals(choiceType)) {
                        title = "Weapon Focus Choice";
                        Feat wfFeat = aPC.getFeatNamed("Weapon Focus");
                        if (aTok.hasMoreTokens()) {
                            String aString = aTok.nextToken();
                            if (aString.startsWith("TYPE.")) {
                                ArrayList aList = wfFeat.getAssociatedList();
                                String aType = aString.substring(5);
                                Iterator e = aList.iterator();
                                while (e.hasNext()) {
                                    Equipment eq;
                                    Object aObj = e.next();
                                    WeaponProf wp = Globals.getWeaponProfNamed(aObj.toString());
                                    if (wp == null || (eq = EquipmentList.getEquipmentKeyed(wp.getKeyName())) == null || !eq.isType(aType)) continue;
                                    availableList.add((String)aObj);
                                }
                            }
                        } else {
                            wfFeat.addAssociatedTo(availableList);
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("WEAPONPROFS".equals(choiceType)) {
                        title = "Weapon Prof Choice";
                        while (aTok.hasMoreTokens()) {
                            String bString;
                            String aString = aTok.nextToken();
                            if ("LIST".equals(aString)) {
                                Iterator setIter = aPC.getWeaponProfList().iterator();
                                while (setIter.hasNext()) {
                                    bString = (String)setIter.next();
                                    if (availableList.contains(bString)) continue;
                                    availableList.add(bString);
                                }
                                continue;
                            }
                            if (aString.equals("DEITYWEAPON")) {
                                if (aPC.getDeity() == null) continue;
                                String weaponList = aPC.getDeity().getFavoredWeapon();
                                if ("ALL".equalsIgnoreCase(weaponList) || "ANY".equalsIgnoreCase(weaponList)) {
                                    weaponList = Globals.getWeaponProfNames("|", false);
                                }
                                StringTokenizer bTok = new StringTokenizer(weaponList, "|");
                                while (bTok.hasMoreTokens()) {
                                    String bString2 = bTok.nextToken();
                                    availableList.add(bString2);
                                }
                                continue;
                            }
                            if (aString.startsWith("Size.")) {
                                if (aPC.sizeInt() < Globals.sizeInt(aString.substring(5, 6)) || !aPC.getWeaponProfList().contains(aString.substring(7)) || availableList.contains(aString.substring(7))) continue;
                                availableList.add(aString.substring(7));
                                continue;
                            }
                            if (aString.startsWith("WSize.")) {
                                StringTokenizer bTok = new StringTokenizer(aString, ".");
                                bTok.nextToken();
                                String sString = bTok.nextToken();
                                ArrayList<String> typeList = new ArrayList<String>();
                                while (bTok.hasMoreTokens()) {
                                    String dString = bTok.nextToken().toUpperCase();
                                    typeList.add(dString);
                                }
                                Iterator setIter = aPC.getWeaponProfList().iterator();
                                while (setIter.hasNext()) {
                                    bString = (String)setIter.next();
                                    WeaponProf wp = Globals.getWeaponProfNamed(bString);
                                    if (wp == null) continue;
                                    Equipment eq = EquipmentList.getEquipmentNamed(wp.getName());
                                    if (eq == null) {
                                        int len = 0;
                                        if (bString.endsWith("Exotic)")) {
                                            len = 7;
                                        }
                                        if (len == 0 && bString.endsWith("Martial)")) {
                                            len = 8;
                                        }
                                        if (len != 0) {
                                            String tempString;
                                            if (bString.charAt(bString.length() - len - 1) == '/') {
                                                ++len;
                                            }
                                            if ((tempString = bString.substring(0, bString.length() - len) + ")").endsWith("()")) {
                                                tempString = tempString.substring(0, tempString.length() - 3).trim();
                                            }
                                            eq = EquipmentList.getEquipmentNamed(tempString);
                                        } else {
                                            Iterator eqIter = EquipmentList.getEquipmentList().iterator();
                                            while (eqIter.hasNext()) {
                                                Equipment tempEq = (Equipment)eqIter.next();
                                                if (!tempEq.isWeapon() || !tempEq.profName(aPC).equals(wp.getName())) continue;
                                                eq = tempEq;
                                                break;
                                            }
                                        }
                                    }
                                    boolean isValid = false;
                                    if (eq != null) {
                                        if (typeList.size() == 0) {
                                            isValid = true;
                                        } else {
                                            Iterator wpi = typeList.iterator();
                                            while (wpi.hasNext()) {
                                                String wpString = (String)wpi.next();
                                                if (!eq.isType(wpString)) continue;
                                                isValid = true;
                                                break;
                                            }
                                        }
                                    }
                                    if (!isValid || availableList.contains(bString)) continue;
                                    if ("Light".equals(sString) && Globals.isWeaponLightForPC(aPC, eq)) {
                                        availableList.add(bString);
                                    }
                                    if ("1 handed".equals(sString) && Globals.isWeaponOneHanded(aPC, eq, wp)) {
                                        availableList.add(bString);
                                    }
                                    if (!"2 handed".equals(sString) || !Globals.isWeaponTwoHanded(aPC, eq, wp)) continue;
                                    availableList.add(bString);
                                }
                                continue;
                            }
                            if (aString.startsWith("SpellCaster.")) {
                                if (!aPC.isSpellCaster(1) || availableList.contains(aString.substring(12))) continue;
                                availableList.add(aString.substring(12));
                                continue;
                            }
                            if (aString.startsWith("ADD.")) {
                                if (availableList.contains(aString.substring(4))) continue;
                                availableList.add(aString.substring(4));
                                continue;
                            }
                            if (aString.startsWith("TYPE.") || aString.startsWith("TYPE=")) {
                                String sString = aString.substring(5);
                                boolean adding = true;
                                Iterator setIter = aPC.getWeaponProfList().iterator();
                                if (sString.startsWith("Not.")) {
                                    sString = sString.substring(4);
                                    setIter = availableList.iterator();
                                    adding = false;
                                }
                                while (setIter.hasNext()) {
                                    String bString3 = (String)setIter.next();
                                    WeaponProf wp = Globals.getWeaponProfNamed(bString3);
                                    if (wp == null) continue;
                                    Equipment eq = EquipmentList.getEquipmentKeyed(wp.getKeyName());
                                    if (eq == null) {
                                        if (!wp.isType("Natural") || !adding || availableList.contains(wp.getName())) continue;
                                        availableList.add(wp.getName());
                                        continue;
                                    }
                                    if (eq.typeStringContains(sString)) {
                                        if (adding && !availableList.contains(wp.getName())) {
                                            availableList.add(wp.getName());
                                            continue;
                                        }
                                        if (adding || !availableList.contains(wp.getName())) continue;
                                        availableList.remove(wp.getName());
                                        setIter = availableList.iterator();
                                        continue;
                                    }
                                    if (!sString.equalsIgnoreCase("LIGHT")) continue;
                                    if (adding && !availableList.contains(wp.getName()) && Globals.isWeaponLightForPC(aPC, eq)) {
                                        availableList.add(wp.getName());
                                        continue;
                                    }
                                    if (adding || !availableList.contains(wp.getName()) || !Globals.isWeaponLightForPC(aPC, eq)) continue;
                                    availableList.remove(wp.getName());
                                    setIter = availableList.iterator();
                                }
                                continue;
                            }
                            if (!aPC.getWeaponProfList().contains(aString) || availableList.contains(aString)) continue;
                            availableList.add(aString);
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("HP".equals(choiceType)) {
                        if (aTok.hasMoreTokens()) {
                            choiceSec = aTok.nextToken();
                        }
                        availableList.add(choiceSec);
                        for (int e1 = 0; e1 < obj.getAssociatedCount(); ++e1) {
                            selectedList.add(choiceSec);
                        }
                    } else if (choiceType.startsWith("FEAT=") || choiceType.startsWith("FEAT.")) {
                        Feat theFeat = aPC.getFeatNamed(choiceType.substring(5));
                        if (theFeat != null) {
                            theFeat.addAssociatedTo(availableList);
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("FEATLIST".equals(choiceType)) {
                        obj.addAssociatedTo(selectedList);
                        while (aTok.hasMoreTokens()) {
                            String aString = aTok.nextToken();
                            if (aString.startsWith("TYPE=") || aString.startsWith("TYPE.")) {
                                aString = aString.substring(5);
                                if (!stacks && availableList.contains(aString)) continue;
                                Iterator e1 = aPC.aggregateFeatList().iterator();
                                while (e1.hasNext()) {
                                    Feat theFeat = (Feat)e1.next();
                                    if (!theFeat.isType(aString) || !stacks && (stacks || availableList.contains(theFeat.getName()))) continue;
                                    availableList.add(theFeat.getName());
                                }
                                continue;
                            }
                            if (aPC.getFeatNamed(aString) == null || !stacks && (stacks || availableList.contains(aString))) continue;
                            availableList.add(aString);
                        }
                    } else if ("FEATSELECT".equals(choiceType)) {
                        obj.addAssociatedTo(selectedList);
                        while (aTok.hasMoreTokens()) {
                            String aString = aTok.nextToken();
                            if (aString.startsWith("TYPE=") || aString.startsWith("TYPE.")) {
                                aString = aString.substring(5);
                                if (!stacks && availableList.contains(aString)) continue;
                                for (int z = 0; z < Globals.getFeatList().size(); ++z) {
                                    Feat theFeat = Globals.getFeatListFeat(z);
                                    if (!theFeat.isType(aString) || !stacks && (stacks || availableList.contains(theFeat.getName()))) continue;
                                    availableList.add(theFeat.getName());
                                }
                                continue;
                            }
                            Feat theFeat = Globals.getFeatNamed(aString);
                            if (theFeat == null) continue;
                            String subName = "";
                            if (!aString.equalsIgnoreCase(theFeat.getName())) {
                                subName = aString.substring(theFeat.getName().length());
                                aString = theFeat.getName();
                                int idx = subName.indexOf(40);
                                if (idx > -1) {
                                    subName = subName.substring(idx + 1);
                                }
                            }
                            if (theFeat.isMultiples()) {
                                int idx;
                                int percIdx;
                                Feat pcFeat = aPC.getFeatNamed(aString);
                                if (pcFeat != null) {
                                    theFeat = pcFeat;
                                }
                                if ((percIdx = subName.indexOf(37)) > -1) {
                                    subName = subName.substring(0, percIdx);
                                } else if (subName.length() != 0 && (idx = subName.lastIndexOf(41)) > -1) {
                                    subName = subName.substring(0, idx);
                                }
                                ArrayList<String> xavailableList = new ArrayList<String>();
                                ArrayList xselectedList = new ArrayList();
                                theFeat.modChoices(aPC, true, xavailableList, xselectedList, false);
                                if (subName.length() != 0) {
                                    for (int n = xavailableList.size() - 1; n >= 0; --n) {
                                        String xString = (String)xavailableList.get(n);
                                        if (xString.startsWith(subName)) continue;
                                        xavailableList.remove(n);
                                    }
                                    if (percIdx == -1 && xavailableList.size() == 0) {
                                        xavailableList.add(aString + "(" + subName + ")");
                                    }
                                }
                                if (!theFeat.isStacks()) {
                                    Iterator e = xselectedList.iterator();
                                    while (e.hasNext()) {
                                        int idx2 = xavailableList.indexOf(e.next().toString());
                                        if (idx2 <= -1) continue;
                                        xavailableList.remove(idx2);
                                    }
                                }
                                Iterator e = xavailableList.iterator();
                                while (e.hasNext()) {
                                    availableList.add(aString + "(" + (String)e.next() + ")");
                                }
                                continue;
                            }
                            availableList.add(aString);
                        }
                    } else if ("FEATADD".equals(choiceType)) {
                        title = "Add a Feat";
                        while (aTok.hasMoreTokens()) {
                            String aString = aTok.nextToken();
                            if (aString.startsWith("TYPE=") || aString.startsWith("TYPE.")) {
                                String featType = aString.substring(5);
                                for (int z = 0; z < Globals.getFeatList().size(); ++z) {
                                    Feat featToTest;
                                    Feat theFeat = Globals.getFeatListFeat(z);
                                    if (!theFeat.isType(featType) || !stacks && (stacks || availableList.contains(theFeat.getName())) || !PrereqHandler.passesAll((featToTest = Globals.getFeatNamed(theFeat.getName())).getPreReqList(), aPC, featToTest) || !Globals.getFeatNamed(theFeat.getName()).isStacks() && aPC.getFeatNamed(theFeat.getName()) != null) continue;
                                    availableList.add(theFeat.getName());
                                }
                                continue;
                            }
                            StringTokenizer bTok = new StringTokenizer(aString, ",");
                            String featName = bTok.nextToken().trim();
                            String subName = "";
                            aFeat = Globals.getFeatNamed(featName);
                            if (aFeat == null) {
                                Logging.errorPrint("Feat not found: " + featName);
                                return false;
                            }
                            if (!featName.equalsIgnoreCase(aFeat.getName())) {
                                subName = featName.substring(aFeat.getName().length());
                                featName = aFeat.getName();
                                int si = subName.indexOf(40);
                                if (si > -1) {
                                    subName = subName.substring(si + 1);
                                }
                            }
                            if (!PrereqHandler.passesAll(aFeat.getPreReqList(), aPC, aFeat)) continue;
                            if (aFeat.isMultiples()) {
                                int idx;
                                int percIdx;
                                Feat pcFeat = aPC.getFeatNamed(featName);
                                if (pcFeat != null) {
                                    aFeat = pcFeat;
                                }
                                if ((percIdx = subName.indexOf(37)) > -1) {
                                    subName = subName.substring(0, percIdx);
                                } else if (subName.length() != 0 && (idx = subName.lastIndexOf(41)) > -1) {
                                    subName = subName.substring(0, idx);
                                }
                                ArrayList<String> aavailableList = new ArrayList<String>();
                                ArrayList sselectedList = new ArrayList();
                                aFeat.modChoices(aPC, true, availableList, selectedList, false);
                                if (subName.length() != 0) {
                                    for (int n = aavailableList.size() - 1; n >= 0; --n) {
                                        String bString = (String)aavailableList.get(n);
                                        if (bString.startsWith(subName)) continue;
                                        aavailableList.remove(n);
                                    }
                                    if (percIdx == -1 && aavailableList.size() == 0) {
                                        aavailableList.add(subName);
                                    }
                                }
                                if (!aFeat.isStacks()) {
                                    Iterator e = sselectedList.iterator();
                                    while (e.hasNext()) {
                                        int idx3 = aavailableList.indexOf(e.next().toString());
                                        if (idx3 <= -1) continue;
                                        aavailableList.remove(idx3);
                                    }
                                }
                                Iterator e = aavailableList.iterator();
                                while (e.hasNext()) {
                                    availableList.add(featName + "(" + (String)e.next() + ")");
                                }
                                return false;
                            }
                            if (aPC.hasFeat(featName) || aPC.hasFeatAutomatic(featName)) continue;
                            availableList.add(aString);
                        }
                    } else if ("SPELLCLASSES".equals(choiceType)) {
                        title = "Spellcaster Classes";
                        iter = aPC.getClassList().iterator();
                        while (iter.hasNext()) {
                            PCClass aClass = (PCClass)iter.next();
                            if (aClass.getSpellBaseStat().equals("None")) continue;
                            availableList.add(aClass.getName());
                        }
                        obj.addAssociatedTo(selectedList);
                    } else if ("ARMORTYPE".equals(choiceType)) {
                        title = "Armor Type Choice";
                        for (int z = 0; z < Globals.getFeatList().size(); ++z) {
                            Feat theFeat = Globals.getFeatListFeat(z);
                            if (!theFeat.getName().startsWith("Armor Proficiency (")) continue;
                            int idxbegin = theFeat.getName().indexOf("(");
                            int idxend = theFeat.getName().indexOf(")");
                            String temptype = theFeat.getName().substring(idxbegin + 1, idxend);
                            if (aPC.getFeatNamed(theFeat.getName()) == null) continue;
                            availableList.add(temptype);
                        }
                        obj.addAssociatedTo(selectedList);
                    } else {
                        title = "Selections";
                        availableList.add(choiceType);
                        while (aTok.hasMoreTokens()) {
                            String aString = aTok.nextToken();
                            if (!stacks && (stacks || availableList.contains(aString))) continue;
                            availableList.add(aString);
                        }
                        obj.addAssociatedTo(selectedList);
                    }
                    if (!process) {
                        return false;
                    }
                    if (requestedSelections < 0) {
                        requestedSelections = maxNewSelections;
                    } else {
                        requestedSelections -= selectedList.size();
                        requestedSelections = Math.min(requestedSelections, maxNewSelections);
                    }
                    int preSelectedSize = selectedList.size();
                    if (numChoices > 0) {
                        requestedSelections = numChoices = Math.min(numChoices, availableList.size() - preSelectedSize);
                    }
                    chooser.setPool(requestedSelections);
                    title = title + " (" + obj.getName() + ')';
                    chooser.setTitle(title);
                    Globals.sortChooserLists(availableList, selectedList);
                    while (true) {
                        chooser.setAvailableList(availableList);
                        chooser.setSelectedList(selectedList);
                        chooser.setVisible(true);
                        int selectedSize = chooser.getSelectedList().size() - preSelectedSize;
                        if (numChoices <= 0 || selectedSize == numChoices) break;
                        ShowMessageDelegate.showMessageDialog("You must make " + (numChoices - selectedSize) + " more selection(s).", "PCGen", MessageType.INFORMATION);
                    }
                    if (!"SPELLLIST".equals(choiceType)) break block230;
                    x = aPC.getFeats();
                    if (idxSelected < 0) break block231;
                    obj.removeAssociated(idxSelected);
                    if (chooser.getSelectedList().size() == 0) {
                        aPC.setFeats(x + 1.0);
                    }
                    break block232;
                }
                if (chooser.getSelectedList().size() == 0) break block232;
                aPC.setFeats(x - 1.0);
                break block232;
            }
            if ("SALIST".equals(choiceType)) {
                block54: for (int e = 0; e < obj.getAssociatedCount(); ++e) {
                    String aString = obj.getAssociated(e);
                    String prefix = aString + "|";
                    for (int x = 0; x < aBonusList.size(); ++x) {
                        String bString = (String)aBonusList.get(x);
                        if (!bString.startsWith(prefix)) continue;
                        obj.removeBonus(bString.substring(bString.indexOf(124) + 1), "", aPC);
                        continue block54;
                    }
                }
            }
        }
        if ("SKILLSNAMEDTOCSKILL".equals(choiceType)) {
            iter = aFeat.getCSkillList().iterator();
            while (iter.hasNext()) {
                Feat bFeat;
                String tempString = (String)iter.next();
                if ("LIST".equals(tempString) || (bFeat = Globals.getFeatNamed(obj.getName())) == null || bFeat.getCSkillList() == null || !bFeat.getCSkillList().contains(tempString)) continue;
                iter.remove();
            }
            aFeat.setCcSkillList(".CLEAR");
        }
        if (!"SPELLLIST".equals(choiceType)) {
            obj.clearAssociated();
        }
        String objPrefix = "";
        if (obj instanceof Domain) {
            objPrefix = choiceType + '?';
        }
        FeatMultipleChoice fmc = null;
        for (i = 0; i < chooser.getSelectedList().size(); ++i) {
            Iterator e;
            String chosenItem = (String)chooser.getSelectedList().get(i);
            if ("HP".equals(choiceType)) {
                obj.addAssociated(objPrefix + chosenItem);
            } else if ("SPELLLEVEL".equals(choiceType)) {
                e = aBonusList.iterator();
                while (e.hasNext()) {
                    String bString = (String)e.next();
                    obj.addAssociated(objPrefix + chosenItem);
                    obj.applyBonus(bString, chosenItem, aPC);
                }
            } else if ("SPELLLIST".equals(choiceType)) {
                if (fmc == null) {
                    fmc = new FeatMultipleChoice();
                    fmc.setMaxChoices(maxNewSelections);
                    obj.addAssociated(fmc);
                }
                fmc.addChoice(chosenItem);
            } else if ("ARMORTYPE".equals(choiceType)) {
                e = aBonusList.iterator();
                while (e.hasNext()) {
                    String bString = (String)e.next();
                    obj.addAssociated(objPrefix + chosenItem);
                    obj.applyBonus("ARMORPROF=" + bString, chosenItem, aPC);
                }
            } else if (multiples && !stacks) {
                if (!obj.containsAssociated(objPrefix + chosenItem)) {
                    obj.addAssociated(objPrefix + chosenItem);
                }
            } else {
                String prefix = chosenItem + "|";
                obj.addAssociated(objPrefix + chosenItem);
                for (int x = 0; x < aBonusList.size(); ++x) {
                    String bString = (String)aBonusList.get(x);
                    if (!bString.startsWith(prefix)) continue;
                    obj.addBonusList(bString.substring(bString.indexOf(124) + 1));
                    break;
                }
            }
            if (aFeat != null) {
                Iterator e2;
                if ("SKILLLIST".equals(choiceType) || "SKILLSNAMEDTOCSKILL".equals(choiceType) || "NONCLASSSKILLLIST".equals(choiceType)) {
                    if (rootArrayList.contains(chosenItem)) {
                        e2 = Globals.getSkillList().iterator();
                        while (e2.hasNext()) {
                            Skill aSkill = (Skill)e2.next();
                            if (!aSkill.getRootName().equalsIgnoreCase(chosenItem)) continue;
                            aFeat.setCSkillList(aSkill.getName());
                        }
                    } else {
                        aFeat.setCSkillList(chosenItem);
                    }
                } else if ("CCSKILLLIST".equals(choiceType) || "SKILLSNAMEDTOCCSKILL".equals(choiceType)) {
                    if (rootArrayList.contains(chosenItem)) {
                        e2 = Globals.getSkillList().iterator();
                        while (e2.hasNext()) {
                            Skill aSkill = (Skill)e2.next();
                            if (!aSkill.getRootName().equalsIgnoreCase(chosenItem)) continue;
                            aFeat.setCcSkillList(aSkill.getName());
                        }
                    } else {
                        aFeat.setCcSkillList(chosenItem);
                    }
                } else if ("FEATADD".equals(choiceType)) {
                    if (!aPC.hasFeat(chosenItem)) {
                        aPC.setFeats(aPC.getFeats() + 1.0);
                    }
                    aPC.modFeat(chosenItem, true, false);
                }
            }
            if (!Globals.weaponTypesContains(choiceType)) continue;
            aPC.addWeaponProf(objPrefix + chosenItem);
        }
        if (!"SPELLLIST".equals(choiceType)) {
            double featCount = aPC.getFeats();
            if (numChoices > 0) {
                if (cost > 0.0) {
                    featCount -= cost;
                }
            } else if (cost > 0.0) {
                featCount = (double)(totalPossibleSelections - selectedList.size()) * cost;
            }
            aPC.setFeats(featCount);
        }
        if (objPrefix.length() != 0) {
            aPC.setAutomaticFeatsStable(false);
        }
        return true;
    }

    public boolean passesPreApplied(PlayerCharacter aPC, PObject anObj) {
        if (!aPC.getUseTempMods()) {
            return false;
        }
        if (anObj == null) {
            Iterator aB = this.getTempBonusList().iterator();
            while (aB.hasNext()) {
                BonusObj aBonus = (BonusObj)aB.next();
                Object abT = aBonus.getTargetObject();
                if (!(abT instanceof PlayerCharacter)) continue;
                PlayerCharacter bPC = (PlayerCharacter)abT;
                if (!aBonus.isApplied() || bPC != aPC) continue;
                return true;
            }
            return false;
        }
        Iterator aB = anObj.getTempBonusList().iterator();
        while (aB.hasNext()) {
            BonusObj aBonus = (BonusObj)aB.next();
            Object abT = aBonus.getTargetObject();
            if (!(abT instanceof Equipment)) continue;
            Equipment aTarget = (Equipment)abT;
            if (!aBonus.isApplied() || !aTarget.equals(anObj)) continue;
            return true;
        }
        return false;
    }

    public String piDescString() {
        return this.piDescString(true);
    }

    public String piDescSubString() {
        return this.piDescString(false);
    }

    public String piString() {
        return this.piString(true);
    }

    public String piSubString() {
        return this.piString(false);
    }

    public boolean removeLevelAbility(int aLevel, String aString) {
        for (int x = this.levelAbilityList.size() - 1; x >= 0; --x) {
            LevelAbility ability = (LevelAbility)this.levelAbilityList.get(x);
            if (ability.level() != aLevel || !ability.getList().equals(aString)) continue;
            this.levelAbilityList.remove(x);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    protected final Double[] getMovementMult() {
        return this.movementMult;
    }

    protected final String[] getMovementMultOp() {
        return this.movementMultOp;
    }

    protected final String[] getMovementTypes() {
        return this.movementTypes;
    }

    protected final Double[] getMovements() {
        return this.movements;
    }

    protected int getSR(PlayerCharacter aPC) {
        String srFormula = this.getSRFormula();
        if (srFormula != null && aPC != null) {
            return aPC.getVariableValue(srFormula, "").intValue();
        }
        return 0;
    }

    protected final void setVariable(int idx, int level, String variableName, String defaultFormula) {
        if (this.variableList == null) {
            this.variableList = new VariableList();
        }
        this.variableList.set(idx, level, variableName, defaultFormula);
    }

    protected final void addAllVariablesFrom(PObject other) {
        if (other.getVariableCount() > 0) {
            if (this.variableList == null) {
                this.variableList = new VariableList();
            }
            this.variableList.addAll(other.variableList);
        }
    }

    protected String getPCCText(boolean saveName, PlayerCharacter aPC) {
        Set langSet;
        Iterator<Object> e;
        String aString;
        StringBuffer txt = new StringBuffer(200);
        if (saveName) {
            txt.append(this.getName());
        }
        if (this.getNameIsPI()) {
            txt.append("\tNAMEISPI:Y");
        }
        if (this.outputName != null && this.outputName.length() > 0 && !this.outputName.equals(this.getName())) {
            txt.append("\tOUTPUTNAME:").append(this.outputName);
        }
        if ((aString = this.getDescription()).length() != 0) {
            txt.append("\tDESC:").append(EntityEncoder.encode(aString));
            if (this.getDescIsPI()) {
                txt.append("\tDESCISPI:Yes");
            }
        }
        if (!this.getName().equals(this.getKeyName())) {
            txt.append("\tKEY:").append(this.getKeyName());
        }
        if (this.autoArray != null && this.autoArray.size() != 0) {
            e = this.autoArray.iterator();
            while (e.hasNext()) {
                txt.append("\tAUTO:").append(e.next().toString());
            }
        }
        if (!(this instanceof PCClass) && this.getBonusList().size() != 0) {
            e = this.getBonusList().iterator();
            while (e.hasNext()) {
                txt.append("\tBONUS:").append(e.next().toString());
            }
        }
        if (this.ccSkillList != null && this.ccSkillList.size() != 0) {
            txt.append("\tCCSKILL:").append(CoreUtility.join((Collection)this.ccSkillList, "|"));
        }
        if (this.cSkillList != null && this.cSkillList.size() != 0) {
            txt.append("\tCSKILL:").append(CoreUtility.join((Collection)this.cSkillList, "|"));
        }
        if ((aString = this.getChoiceString()) != null && aString.length() != 0) {
            txt.append("\tCHOOSE:").append(aString);
        }
        int iCount = this.getVariableCount();
        if (!(this instanceof PCClass) && iCount != 0) {
            for (int i = 0; i < iCount; ++i) {
                aString = this.getVariableDefinition(i);
                if (aString.startsWith("-9|")) {
                    aString = aString.substring(3);
                }
                txt.append("\tDEFINE:").append(aString);
            }
        }
        if (!(this instanceof PCClass) && this.DR != null && this.DR.length() != 0) {
            txt.append("\tDR:").append(this.DR);
        }
        if ((langSet = this.getAutoLanguageNames()).size() != 0) {
            txt.append("\tLANGAUTO:").append(CoreUtility.join((Collection)langSet, ","));
        }
        if ((iCount = this.getPreReqCount()) != 0) {
            StringWriter writer = new StringWriter();
            for (int i = 0; i < iCount; ++i) {
                Prerequisite prereq = this.getPreReq(i);
                PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
                try {
                    writer.write("\t");
                    prereqWriter.write(writer, prereq);
                    continue;
                }
                catch (PersistenceLayerException e1) {
                    e1.printStackTrace();
                }
            }
            txt.append(writer);
        }
        if (!(this instanceof PCClass) && this.specialAbilityList != null && this.specialAbilityList.size() != 0) {
            e = this.specialAbilityList.iterator();
            while (e.hasNext()) {
                SpecialAbility sa = (SpecialAbility)e.next();
                txt.append("\tSA:").append(sa.toString());
            }
        }
        if (!(aString = this.getQualifyString()).equals("alwaysValid")) {
            txt.append("\tQUALIFY:").append(aString);
        }
        if (!(this instanceof PCClass)) {
            iCount = 0;
            while ((aString = this.getSpellListItemAsString(iCount, aPC)) != null) {
                txt.append("\tSPELL:").append(aString);
                ++iCount;
            }
        }
        if (!(this instanceof PCClass) && this.SR != null && this.SR.length() != 0) {
            txt.append("\tSR:").append(this.SR);
        }
        if (this.vision != null && this.vision.size() != 0) {
            StringBuffer sb = new StringBuffer();
            e = this.vision.keySet().iterator();
            while (e.hasNext()) {
                String key = (String)e.next();
                String val = (String)this.vision.get(key);
                if (val.length() <= 0 || "0".equals(val)) continue;
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(key).append(" (");
                sb.append(val).append("')");
            }
            if (sb.length() > 0) {
                txt.append("\tVISION:").append(sb.toString());
            }
        }
        if (this.weaponProfAutos != null && this.weaponProfAutos.size() != 0) {
            txt.append("\tWEAPONAUTO:").append(CoreUtility.join((Collection)this.weaponProfAutos, "|"));
        }
        if (this.getMyTypeCount() != 0) {
            txt.append('\t').append("TYPE:").append(this.getType());
        }
        if ((aString = this.getSourcePage()).length() != 0) {
            txt.append("\tSOURCEPAGE:").append(aString);
        }
        if (this.regionString != null && this.regionString.startsWith("0|")) {
            txt.append("\tREGION:").append(this.regionString.substring(2));
        }
        if (this.kits != null) {
            for (int iKit = 0; iKit < this.kits.size(); ++iKit) {
                aString = (String)this.kits.get(iKit);
                if (!aString.startsWith("0|")) continue;
                txt.append("\tKIT:").append(aString.substring(2));
            }
        }
        return txt.toString();
    }

    protected void addAddsForLevel(int aLevel, PlayerCharacter aPC) {
        if (aPC == null || this.levelAbilityList == null || this.levelAbilityList.isEmpty() || aPC.isImporting()) {
            return;
        }
        Iterator e = this.levelAbilityList.iterator();
        while (e.hasNext()) {
            LevelAbility ability = (LevelAbility)e.next();
            ability.setOwner(this);
            if (this instanceof PCClass && (ability.level() != aLevel || !ability.canProcess())) continue;
            boolean canProcess = true;
            if (ability instanceof LevelAbilityFeat && !SettingsHandler.getShowFeatDialogAtLevelUp()) {
                Logging.errorPrint("PObject addAddsForLevel");
                canProcess = false;
                ArrayList featList = new ArrayList();
                ability.process(featList, aPC);
                Iterator fe = featList.iterator();
                block4: while (fe.hasNext()) {
                    Feat aFeat = Globals.getFeatNamed((String)fe.next());
                    if (aFeat == null) continue;
                    switch (aFeat.isVisible()) {
                        case 0: 
                        case 2: {
                            canProcess = true;
                            break block4;
                        }
                    }
                }
            }
            if (canProcess) {
                ability.process(aPC);
                continue;
            }
            aPC.setFeats(aPC.getFeats() + 1.0);
        }
    }

    protected List addSpecialAbilitiesToList(List aList, PlayerCharacter aPC) {
        if (this.specialAbilityList != null) {
            Iterator i = this.specialAbilityList.iterator();
            while (i.hasNext()) {
                aList.add(i.next());
            }
        }
        return aList;
    }

    protected void doGlobalTypeUpdate(String type) {
    }

    protected void globalChecks(PlayerCharacter aPC) {
        this.globalChecks(false, aPC);
    }

    protected void globalChecks(boolean flag, PlayerCharacter aPC) {
        this.makeKitSelection(aPC);
        this.makeRegionSelection(aPC);
        if (flag) {
            this.makeChoices(aPC);
        }
        if (this instanceof PCClass) {
            this.addAddsForLevel(((PCClass)this).level, aPC);
        } else {
            this.addAddsForLevel(0, aPC);
        }
        this.activateBonuses(aPC);
    }

    protected void subAddsForLevel(int aLevel, PlayerCharacter aPC) {
        if (aPC == null || this.levelAbilityList == null || this.levelAbilityList.isEmpty()) {
            return;
        }
        Iterator e = this.levelAbilityList.iterator();
        while (e.hasNext()) {
            LevelAbility ability = (LevelAbility)e.next();
            if (ability.level() != aLevel) continue;
            ability.subForLevel(aPC);
        }
    }

    final ArrayList getAssociatedList() {
        return this.associatedList;
    }

    final void setBonusStackFor(double bonus, String bonusType) {
        String aVal;
        if (bonusType != null) {
            bonusType = bonusType.toUpperCase();
        }
        int index = -1;
        StringTokenizer aTok = new StringTokenizer(bonusType, ".");
        if (bonusType != null && aTok.countTokens() >= 2) {
            aTok.nextToken();
            String aString = aTok.nextToken();
            if (aString.equals("BASE")) {
                if (aTok.hasMoreTokens()) {
                    aTok.nextToken();
                }
                aString = aTok.hasMoreTokens() ? aTok.nextToken() : null;
            } else {
                aString = aTok.hasMoreTokens() ? aTok.nextToken() : null;
            }
            if (aString != null) {
                index = SystemCollections.getUnmodifiableBonusStackList().indexOf(aString);
            }
            if (aString == null) {
                index = 1;
            } else if (aString.equals("NULL")) {
                index = 1;
            }
        }
        if (bonusType != null && (bonusType.endsWith(".STACK") || bonusType.endsWith(".REPLACE"))) {
            index = 1;
        }
        if (bonus < 0.0) {
            index = 1;
        }
        if (index == -1) {
            aVal = (String)this.getBonusMap().get(bonusType);
            if (aVal == null) {
                this.putBonusMap(bonusType, String.valueOf(bonus));
            } else {
                this.putBonusMap(bonusType, String.valueOf(Math.max(bonus, (double)Float.parseFloat(aVal))));
            }
        } else {
            if (bonusType == null) {
                bonusType = "";
            } else if (bonusType.endsWith(".REPLACE.STACK")) {
                bonusType = bonusType.substring(0, bonusType.length() - 6);
            }
            aVal = (String)this.getBonusMap().get(bonusType);
            if (aVal == null) {
                this.putBonusMap(bonusType, String.valueOf(bonus));
            } else {
                this.putBonusMap(bonusType, String.valueOf(bonus + (double)Float.parseFloat(aVal)));
            }
        }
    }

    final void getChoices(String aChoice, List selectedBonusList, List availableList, List selectedList, PlayerCharacter aPC) {
        this.getChoices(aChoice, selectedBonusList, this, availableList, selectedList, true, aPC);
    }

    final void setPreReq(int index, Prerequisite aString) {
        this.preReqList.set(index, aString);
    }

    static final void getSpellTypeChoices(String aChoice, List availList, List uniqueList, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(aChoice, "|");
        aTok.nextToken();
        while (aTok.hasMoreTokens()) {
            String bString;
            String aString = aTok.nextToken();
            while (!(aString.startsWith("CLASS=") || aString.startsWith("CLASS.") || aString.startsWith("TYPE=") || aString.startsWith("TYPE.") || !aTok.hasMoreTokens())) {
                aString = aTok.nextToken();
            }
            if (!aTok.hasMoreTokens()) break;
            boolean endIsUnique = false;
            int minLevel = 1;
            try {
                minLevel = Integer.parseInt(aTok.nextToken());
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Badly formed minLevel token: " + aString);
            }
            String mString = aTok.nextToken();
            if (mString.endsWith(".A")) {
                endIsUnique = true;
                mString = mString.substring(0, mString.lastIndexOf(".A"));
            }
            int maxLevel = minLevel;
            if (aString.startsWith("CLASS=") || aString.startsWith("CLASS.")) {
                PCClass aClass = aPC.getClassKeyed(aString.substring(6));
                for (int i = 0; i < mString.length(); ++i) {
                    if (mString.length() <= 7 + i || !"MAXLEVEL".equals(mString.substring(i, i + 8))) continue;
                    int j = -1;
                    int aLevel = aClass.getLevel() - 1;
                    if (aLevel >= 0) {
                        String tempString = aClass.getCastStringForLevel(aLevel);
                        StringTokenizer bTok = new StringTokenizer(tempString, ",");
                        j = bTok.countTokens() - 1;
                    }
                    bString = "";
                    if (mString.length() > i + 8) {
                        bString = mString.substring(i + 8);
                    }
                    mString = mString.substring(0, i) + String.valueOf(j) + bString;
                    --i;
                }
                maxLevel = aPC.getVariableValue(mString, "").intValue();
                if (aClass != null) {
                    String prefix = aClass.getName() + " ";
                    for (int j = minLevel; j <= maxLevel; ++j) {
                        bString = prefix + j;
                        if (!availList.contains(bString)) {
                            availList.add(bString);
                        }
                        if (j != maxLevel || !endIsUnique) continue;
                        uniqueList.add(bString);
                    }
                }
            }
            if (!aString.startsWith("TYPE=") && !aString.startsWith("TYPE.")) continue;
            aString = aString.substring(5);
            Iterator e = aPC.getClassList().iterator();
            while (e.hasNext()) {
                PCClass aClass = (PCClass)e.next();
                if (!aClass.getSpellType().equals(aString)) continue;
                if (mString.startsWith("MAXLEVEL")) {
                    int aLevel = aClass.getLevel() - 1;
                    aLevel += (int)aPC.getTotalBonusTo("PCLEVEL", aClass.getName());
                    String bString2 = "0";
                    if ((aLevel += (int)aPC.getTotalBonusTo("PCLEVEL", "TYPE." + aString)) >= 0) {
                        bString2 = aClass.getCastStringForLevel(aLevel);
                    }
                    if ("0".equals(bString2)) {
                        maxLevel = -1;
                    } else {
                        StringTokenizer bTok = new StringTokenizer(bString2, ",");
                        maxLevel = bTok.countTokens() - 1;
                    }
                    if (mString.length() > 8) {
                        mString = mString.substring(8);
                        maxLevel += Delta.decode(mString).intValue();
                    }
                }
                String prefix = aClass.getName() + " ";
                for (int i = minLevel; i <= maxLevel; ++i) {
                    bString = prefix + i;
                    if (!availList.contains(bString)) {
                        availList.add(bString);
                    }
                    if (i != maxLevel || !endIsUnique) continue;
                    uniqueList.add(bString);
                }
            }
        }
    }

    final String getUdamFor(boolean includeCrit, boolean includeStrBonus, PlayerCharacter aPC) {
        String dString;
        if (this.udamList == null || this.udamList.isEmpty()) {
            return "";
        }
        StringBuffer aString = new StringBuffer(this.udamList.get(0).toString());
        StringTokenizer aTok = new StringTokenizer(aString.toString(), ",", false);
        for (int iSize = Globals.sizeInt(aPC.getSize()); iSize > -1 && aTok.hasMoreTokens(); --iSize) {
            aString.replace(0, aString.length(), aTok.nextToken());
            if (iSize == 0) break;
        }
        int b = (int)aPC.getStatBonusTo("DAMAGE", "TYPE=MELEE");
        if (includeStrBonus && b > 0) {
            aString.append('+');
        }
        if (includeStrBonus && b != 0) {
            aString.append(String.valueOf(b));
        }
        if (includeCrit && this.umultList != null && !this.umultList.isEmpty() && !"0".equals(dString = this.umultList.get(0).toString())) {
            aString.append("(x").append(dString).append(')');
        }
        return aString.toString();
    }

    final void addAutoTagsToList(String tag, AbstractCollection aList, PlayerCharacter aPC) {
        if (this.autoArray == null) {
            return;
        }
        Iterator i = this.autoArray.iterator();
        while (i.hasNext()) {
            String aString = (String)i.next();
            if (!aString.startsWith(tag)) continue;
            String preReqTag = null;
            ArrayList<String> preReqList = new ArrayList<String>();
            int j1 = aString.lastIndexOf(91);
            int j2 = aString.lastIndexOf(93);
            if (j2 < j1) {
                j2 = tag.length();
            }
            if (j1 >= 0) {
                preReqTag = aString.substring(j1 + 1, j2);
                preReqList.add(preReqTag);
                if (!PrereqHandler.passesAll(preReqList, aPC, null)) {
                    return;
                }
                aString = aString.substring(0, j1);
            }
            StringTokenizer aTok = new StringTokenizer(aString, "|");
            aTok.nextToken();
            while (aTok.hasMoreTokens()) {
                String tok = aTok.nextToken();
                if ((tok.startsWith("TYPE=") || tok.startsWith("TYPE.")) && tag.startsWith("WEAPON")) {
                    StringTokenizer bTok = new StringTokenizer(tok.substring(5), ".");
                    ArrayList<String> xList = null;
                    while (bTok.hasMoreTokens()) {
                        String wprof;
                        String bString = bTok.nextToken();
                        List bList = Globals.getWeaponProfs(bString, aPC);
                        if (bList.size() == 0) {
                            bList.addAll(EquipmentList.getEquipmentOfType(EquipmentList.getEquipmentList(), "Weapon." + bString, ""));
                        }
                        if (xList == null) {
                            xList = new ArrayList<String>();
                            Iterator e = bList.iterator();
                            while (e.hasNext()) {
                                Object obj = e.next();
                                wprof = obj instanceof Equipment ? ((Equipment)obj).profName(aPC) : obj.toString();
                                if (xList.contains(wprof)) continue;
                                xList.add(wprof);
                            }
                            continue;
                        }
                        ArrayList<String> removeList = new ArrayList<String>();
                        Iterator e = xList.iterator();
                        while (e.hasNext()) {
                            wprof = (String)e.next();
                            boolean contains = false;
                            Iterator f = bList.iterator();
                            while (f.hasNext()) {
                                Object obj = f.next();
                                String wprof2 = obj instanceof Equipment ? ((Equipment)obj).profName(aPC) : obj.toString();
                                if (!wprof.equals(wprof2)) continue;
                                contains = true;
                                break;
                            }
                            if (contains) continue;
                            removeList.add(wprof);
                        }
                        e = removeList.iterator();
                        while (e.hasNext()) {
                            wprof = (String)e.next();
                            xList.remove(wprof);
                        }
                    }
                    aList.addAll(xList);
                    continue;
                }
                if ((tok.startsWith("TYPE=") || tok.startsWith("TYPE.")) && tag.startsWith("ARMOR")) {
                    aList.add(tok);
                    continue;
                }
                if (tag.startsWith("EQUIP")) {
                    Equipment aEq = EquipmentList.getEquipmentFromName(tok, aPC);
                    if (aEq == null) continue;
                    Equipment newEq = (Equipment)aEq.clone();
                    newEq.setQty(1.0);
                    newEq.setAutomatic(true);
                    newEq.setOutputIndex(aList.size());
                    aList.add(newEq);
                    continue;
                }
                if ("%LIST".equals(tok)) {
                    Iterator e = this.getAssociatedList().iterator();
                    while (e.hasNext()) {
                        String wString = (String)e.next();
                        aList.add(wString);
                    }
                    continue;
                }
                aList.add(tok);
            }
        }
    }

    void addMyType(String myType) {
        if (this.myTypeList == null) {
            this.myTypeList = new ArrayList();
        }
        this.myTypeList.add(myType);
    }

    final void addMyTypeTo(Collection collection) {
        if (this.myTypeList != null) {
            collection.addAll(this.myTypeList);
        }
    }

    final void addPreReqTo(Collection collection) {
        if (this.preReqList != null) {
            collection.addAll(this.preReqList);
        }
    }

    final void addSelectedWeaponProfBonusTo(Collection collection) {
        if (this.selectedWeaponProfBonus != null) {
            collection.addAll(this.selectedWeaponProfBonus);
        }
    }

    final void applyBonus(String bonusString, String chooseString, PlayerCharacter aPC) {
        bonusString = this.makeBonusString(bonusString, chooseString, aPC);
        this.addBonusList(bonusString);
        this.addSave("BONUS|" + bonusString);
    }

    final void clearCharacterSpells() {
        if (this.characterSpellList != null && !this.characterSpellList.isEmpty()) {
            this.characterSpellList.clear();
        }
    }

    void fireNameChanged(String oldName, String newName) {
    }

    final boolean hasCCSkill(String aName) {
        if (this.ccSkillList == null || this.ccSkillList.isEmpty()) {
            return false;
        }
        if (this.ccSkillList.contains(aName)) {
            return true;
        }
        Iterator e = this.getCcSkillList().iterator();
        while (e.hasNext()) {
            String aString = (String)e.next();
            if (aString.lastIndexOf(37) < 0 || !aName.startsWith(aString = aString.substring(0, aString.length() - 1))) continue;
            return true;
        }
        return false;
    }

    final boolean hasCSkill(String aName) {
        String aString;
        if (this.cSkillList == null || this.cSkillList.isEmpty()) {
            return false;
        }
        if (this.cSkillList.contains(aName)) {
            return true;
        }
        if (this.cSkillList.contains("LIST")) {
            for (int e = 0; e < this.getAssociatedCount(); ++e) {
                aString = this.getAssociated(e);
                if (!aName.startsWith(aString) && !aString.startsWith(aName)) continue;
                return true;
            }
        }
        Iterator e = this.cSkillList.iterator();
        while (e.hasNext()) {
            aString = (String)e.next();
            if (aString.lastIndexOf(37) >= 0 && aName.startsWith(aString = aString.substring(0, aString.length() - 1))) {
                return true;
            }
            if (!aName.equalsIgnoreCase(aString)) continue;
            return true;
        }
        return false;
    }

    String makeBonusString(String bonusString, String chooseString, PlayerCharacter aPC) {
        boolean lockIt;
        int i = chooseString.lastIndexOf(32);
        String classString = "";
        String levelString = "";
        if (bonusString.startsWith("BONUS:")) {
            bonusString = bonusString.substring(6);
        }
        if (lockIt = bonusString.endsWith(".LOCK")) {
            bonusString = bonusString.substring(0, bonusString.lastIndexOf(".LOCK"));
        }
        if (i >= 0) {
            classString = chooseString.substring(0, i);
            if (i < chooseString.length()) {
                levelString = chooseString.substring(i + 1);
            }
        }
        while (bonusString.lastIndexOf("TYPE=%") >= 0) {
            i = bonusString.lastIndexOf("TYPE=%");
            bonusString = bonusString.substring(0, i + 5) + classString + bonusString.substring(i + 6);
        }
        while (bonusString.lastIndexOf("CLASS=%") >= 0) {
            i = bonusString.lastIndexOf("CLASS=%");
            bonusString = bonusString.substring(0, i + 6) + classString + bonusString.substring(i + 7);
        }
        while (bonusString.lastIndexOf("LEVEL=%") >= 0) {
            i = bonusString.lastIndexOf("LEVEL=%");
            bonusString = bonusString.substring(0, i + 6) + levelString + bonusString.substring(i + 7);
        }
        if (lockIt) {
            i = bonusString.lastIndexOf(124);
            Float val = aPC.getVariableValue(bonusString.substring(i + 1), "");
            bonusString = bonusString.substring(0, i) + "|" + val;
        }
        return bonusString;
    }

    final void makeKitSelection(int arg, PlayerCharacter aPC) {
        String kitString;
        int iKit = 0;
        while ((kitString = this.getKitString(iKit)) != null) {
            this.makeKitSelections(arg, kitString, iKit, aPC);
            ++iKit;
        }
    }

    final void makeRegionSelection(PlayerCharacter aPC) {
        this.makeRegionSelection(0, aPC);
    }

    final void makeRegionSelection(int arg, PlayerCharacter aPC) {
        int num;
        int aLevel;
        if (this.regionString == null) {
            return;
        }
        StringTokenizer aTok = new StringTokenizer(this.regionString, "|");
        String tok = aTok.nextToken();
        try {
            aLevel = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            Logging.errorPrint("Badly formed preLevel attribute in makeRegionSelection: " + tok);
            aLevel = 0;
        }
        if (aLevel > arg) {
            return;
        }
        tok = aTok.nextToken();
        try {
            num = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            Logging.errorPrint("Badly formed number of selection attribute in makeRegionSelection: " + tok);
            num = -1;
        }
        ArrayList aList = new ArrayList();
        while (aTok.hasMoreTokens()) {
            aList.add(aTok.nextToken());
        }
        if (num != aList.size()) {
            ChooserInterface c = ChooserFactory.getChooserInstance();
            c.setTitle("Region Selection");
            c.setPool(num);
            c.setPoolFlag(false);
            c.setAvailableList(aList);
            c.setVisible(true);
            aList = c.getSelectedList();
        }
        if (aList.size() > 0) {
            Iterator i = aList.iterator();
            while (i.hasNext()) {
                String aString = (String)i.next();
                if (aPC.getRegion().equalsIgnoreCase(aString)) continue;
                aPC.setRegion(aString);
            }
        }
    }

    int numberInList(String aType) {
        return 0;
    }

    final boolean passesPreReqToGain(PObject p) {
        if (this.getPreReqCount() == 0) {
            return true;
        }
        return PrereqHandler.passesAll(this.preReqList, (Equipment)p);
    }

    final Object removeAssociated(int i) {
        if (this.associatedList == null) {
            throw new IndexOutOfBoundsException("size is 0, i=" + i);
        }
        return this.associatedList.remove(i);
    }

    final void removeBonus(String bonusString, String chooseString, PlayerCharacter aPC) {
        bonusString = this.makeBonusString(bonusString, chooseString, aPC);
        int index = -1;
        if (this.getBonusList() != null) {
            index = this.getBonusList().indexOf(bonusString);
        }
        if (index >= 0) {
            this.getBonusList().remove(index);
        } else {
            Logging.errorPrint("removeBonus: Could not find bonus: " + bonusString + " in bonusList.");
        }
        this.removeSave("BONUS|" + bonusString);
    }

    final boolean removeCharacterSpell(CharacterSpell spell) {
        if (this.characterSpellList == null) {
            return false;
        }
        return this.characterSpellList.remove(spell);
    }

    final void sortAssociated() {
        if (this.associatedList != null) {
            Collections.sort(this.associatedList);
        }
    }

    private void getChoices(String aChoice, List selectedBonusList, PObject theObj, List availableList, List selectedList, boolean process, PlayerCharacter aPC) {
        Iterator e;
        String aString;
        int index;
        Equipment eq;
        Iterator i;
        String bString;
        if (!(this.choiceString.startsWith("FEAT|") || this.choiceString.startsWith("ARMORPROF") || this.choiceString.startsWith("SPELLLEVEL") || aChoice.startsWith("SPELLLEVEL") || aChoice.startsWith("WEAPONPROF") || aChoice.startsWith("SHIELDPROF"))) {
            return;
        }
        if (aChoice.length() == 0) {
            aChoice = this.choiceString;
        }
        StringTokenizer aTok = new StringTokenizer(aChoice, "|");
        aTok.nextToken();
        String tempString = aTok.nextToken();
        int pool = aPC.getVariableValue(tempString, "").intValue();
        boolean dupsAllowed = true;
        String title = "";
        ArrayList<String> otherArrayList = new ArrayList<String>();
        ArrayList cArrayList = new ArrayList();
        if (aChoice.startsWith("FEAT")) {
            if (this.associatedList != null) {
                selectedList.addAll(this.associatedList);
            }
            while (aTok.hasMoreTokens()) {
                tempString = aTok.nextToken();
                Feat f = Globals.getFeatNamed(tempString);
                if (f == null || !PrereqHandler.passesAll(f.getPreReqList(), aPC, f)) continue;
                availableList.add(tempString);
                if (!aPC.hasFeat(tempString) || selectedList.contains(tempString)) continue;
                selectedList.add(tempString);
            }
        } else if (aChoice.startsWith("SPELLLEVEL")) {
            PObject.getSpellTypeChoices(aChoice, availableList, cArrayList, aPC);
        } else if (aChoice.startsWith("WEAPONPROF")) {
            dupsAllowed = false;
            title = "Weapon Choice(s)";
            theObj.addSelectedWeaponProfBonusTo(selectedList);
            while (aTok.hasMoreTokens()) {
                String bString2;
                Equipment aEq;
                ArrayList<String> typeList;
                StringTokenizer bTok;
                String aString2 = aTok.nextToken();
                boolean adding = false;
                String cString = aString2;
                if (aString2.lastIndexOf(91) >= 0) {
                    bTok = new StringTokenizer(aString2, "[]");
                    bString = bTok.nextToken();
                    adding = true;
                    while (bTok.hasMoreTokens()) {
                        otherArrayList.add(bString + "|" + bTok.nextToken());
                    }
                    aString2 = bString;
                }
                if ("DEITYWEAPON".equals(aString2)) {
                    if (aPC.getDeity() == null) continue;
                    String weaponList = aPC.getDeity().getFavoredWeapon();
                    if ("ALL".equalsIgnoreCase(weaponList) || "ANY".equalsIgnoreCase(weaponList)) {
                        weaponList = Globals.getWeaponProfNames("|", false);
                    }
                    StringTokenizer bTok2 = new StringTokenizer(weaponList, "|");
                    while (bTok2.hasMoreTokens()) {
                        String bString3 = bTok2.nextToken();
                        availableList.add(bString3);
                        if (!adding) continue;
                        StringTokenizer cTok = new StringTokenizer(cString, "[]");
                        cTok.nextToken();
                        while (cTok.hasMoreTokens()) {
                            otherArrayList.add(bString3 + "|" + cTok.nextToken());
                        }
                    }
                    continue;
                }
                if (aString2.startsWith("TYPE=") || aString2.startsWith("TYPE.")) {
                    bTok = new StringTokenizer(aString2.substring(5), ".");
                    typeList = new ArrayList<String>();
                    int iSize = -1;
                    while (bTok.hasMoreTokens()) {
                        String bString4 = bTok.nextToken();
                        if (bString4.startsWith("SIZE=") || aString2.startsWith("SIZE.")) {
                            iSize = Globals.sizeInt(bString4.substring(5));
                            continue;
                        }
                        typeList.add(bString4);
                    }
                    Iterator ei = EquipmentList.getEquipmentList().iterator();
                    while (ei.hasNext()) {
                        Equipment aEq2 = (Equipment)ei.next();
                        if (!aEq2.isWeapon()) continue;
                        boolean bOk = true;
                        Iterator ti = typeList.iterator();
                        while (ti.hasNext() && aEq2.isType((String)ti.next())) {
                            WeaponProf wp;
                            if (iSize >= 0) {
                                bOk &= Globals.sizeInt(aEq2.getSize()) == iSize;
                            }
                            if (!bOk || (wp = Globals.getWeaponProfNamed(aEq2.profName(aPC))) == null || availableList.contains(wp.getName())) continue;
                            String bString5 = wp.getName();
                            availableList.add(bString5);
                            StringTokenizer cTok = new StringTokenizer(cString, "[]");
                            if (!cTok.hasMoreTokens()) continue;
                            cTok.nextToken();
                            while (cTok.hasMoreTokens()) {
                                otherArrayList.add(bString5 + "|" + cTok.nextToken());
                            }
                        }
                    }
                    continue;
                }
                if (aString2.startsWith("WIELD=") || aString2.startsWith("WIELD.")) {
                    bTok = new StringTokenizer(aString2.substring(6), ".");
                    ArrayList<String> wieldList = new ArrayList<String>();
                    while (bTok.hasMoreTokens()) {
                        wieldList.add(bTok.nextToken());
                    }
                    Iterator ei = EquipmentList.getEquipmentList().iterator();
                    while (ei.hasNext()) {
                        aEq = (Equipment)ei.next();
                        if (!aEq.isWeapon()) continue;
                        Iterator wi = wieldList.iterator();
                        while (wi.hasNext() && aEq.hasWield() && aEq.getWield().equalsIgnoreCase((String)wi.next())) {
                            WeaponProf wp = Globals.getWeaponProfNamed(aEq.profName(aPC));
                            if (wp == null || availableList.contains(wp.getName())) continue;
                            bString2 = wp.getName();
                            availableList.add(bString2);
                            StringTokenizer cTok = new StringTokenizer(cString, "[]");
                            if (!cTok.hasMoreTokens()) continue;
                            cTok.nextToken();
                            while (cTok.hasMoreTokens()) {
                                otherArrayList.add(bString2 + "|" + cTok.nextToken());
                            }
                        }
                    }
                    continue;
                }
                if (aString2.startsWith("!TYPE=") || aString2.startsWith("!TYPE.")) {
                    bTok = new StringTokenizer(aString2.substring(6), ".");
                    typeList = new ArrayList();
                    while (bTok.hasMoreTokens()) {
                        typeList.add(bTok.nextToken());
                    }
                    Iterator ei = EquipmentList.getEquipmentList().iterator();
                    while (ei.hasNext()) {
                        aEq = (Equipment)ei.next();
                        if (!aEq.isWeapon()) continue;
                        Iterator ti = typeList.iterator();
                        while (ti.hasNext() && aEq.isType((String)ti.next())) {
                            WeaponProf wp = Globals.getWeaponProfNamed(aEq.profName(aPC));
                            if (wp == null || !availableList.contains(wp.getName())) continue;
                            bString2 = wp.getName();
                            availableList.remove(bString2);
                        }
                    }
                    continue;
                }
                availableList.add(aString2);
            }
        } else if (aChoice.startsWith("ARMORPROF")) {
            if (theObj.getSelectedArmorProfs() != null) {
                selectedList.addAll(theObj.getSelectedArmorProfs());
            }
            while (aTok.hasMoreTokens()) {
                tempString = aTok.nextToken();
                if (tempString.startsWith("TYPE=") || tempString.startsWith("TYPE.")) {
                    tempString = tempString.substring(5);
                    i = EquipmentList.getEquipmentList().iterator();
                    while (i.hasNext()) {
                        Equipment eq2 = (Equipment)i.next();
                        if (!eq2.isArmor() || !eq2.isType(tempString) || availableList.contains(eq2.profName(aPC))) continue;
                        availableList.add(eq2.profName(aPC));
                    }
                    continue;
                }
                eq = EquipmentList.getEquipmentNamed(tempString);
                if (eq == null || !eq.isArmor() || availableList.contains(eq.profName(aPC))) continue;
                availableList.add(eq.profName(aPC));
            }
        } else if (aChoice.startsWith("SHIELDPROF")) {
            if (theObj.getSelectedShieldProfs() != null) {
                selectedList.addAll(theObj.getSelectedShieldProfs());
            }
            while (aTok.hasMoreTokens()) {
                tempString = aTok.nextToken();
                if (tempString.startsWith("TYPE=") || tempString.startsWith("TYPE.")) {
                    tempString = tempString.substring(5);
                    i = EquipmentList.getEquipmentList().iterator();
                    while (i.hasNext()) {
                        Equipment eq3 = (Equipment)i.next();
                        if (!eq3.isShield() || !eq3.isType(tempString) || availableList.contains(eq3.profName(aPC))) continue;
                        availableList.add(eq3.profName(aPC));
                    }
                    continue;
                }
                eq = EquipmentList.getEquipmentNamed(tempString);
                if (eq == null || !eq.isShield() || availableList.contains(eq.profName(aPC))) continue;
                availableList.add(eq.profName(aPC));
            }
        }
        if (!process || availableList.size() + selectedList.size() + cArrayList.size() == 0) {
            return;
        }
        ChooserInterface c = ChooserFactory.getChooserInstance();
        c.setAllowsDups(dupsAllowed);
        if (title.length() != 0) {
            c.setTitle(title);
        }
        Globals.sortChooserLists(availableList, selectedList);
        c.setAvailableList(availableList);
        c.setSelectedList(selectedList);
        c.setUniqueList(cArrayList);
        c.setPool(Math.max(0, pool -= c.getSelectedList().size()));
        c.setPoolFlag(false);
        c.setVisible(true);
        if (aChoice.startsWith("WEAPONPROF")) {
            theObj.clearSelectedWeaponProfBonus();
            aPC.setAutomaticFeatsStable(false);
            for (index = 0; index < c.getSelectedList().size(); ++index) {
                if (otherArrayList.isEmpty()) continue;
                aString = (String)c.getSelectedList().get(index);
                e = otherArrayList.iterator();
                while (e.hasNext()) {
                    Feat aFeat;
                    bString = (String)e.next();
                    aTok = new StringTokenizer(bString, "|");
                    if (!aTok.nextToken().equals(aString)) continue;
                    String cString = aTok.nextToken();
                    if (cString.startsWith("WEAPONPROF")) {
                        theObj.addSelectedWeaponProfBonus(aString);
                        continue;
                    }
                    if (!cString.startsWith("FEAT=") && !cString.startsWith("FEAT.")) continue;
                    if (theObj instanceof Domain) {
                        theObj.clearAssociated();
                        aFeat = (Feat)Globals.getFeatKeyed(cString.substring(5)).clone();
                        if (aFeat == null) continue;
                        theObj.addAssociated("FEAT?" + aFeat.getName() + "(" + aString + ")");
                        continue;
                    }
                    aFeat = aPC.getFeatNamed(cString.substring(5));
                    if (aFeat == null && (aFeat = (Feat)Globals.getFeatKeyed(cString.substring(5)).clone()) != null) {
                        aPC.addFeat(aFeat);
                    }
                    if (aFeat == null || aFeat.containsAssociated(aString)) continue;
                    aFeat.addAssociated(aString);
                }
            }
            aPC.getWeaponProfList();
        } else if (aChoice.startsWith("ARMORPROF")) {
            theObj.addSelectedArmorProfs(c.getSelectedList());
        } else if (aChoice.startsWith("SHIELDPROF")) {
            theObj.addSelectedShieldProfs(c.getSelectedList());
        } else if (aChoice.startsWith("FEAT")) {
            Iterator i2 = c.getSelectedList().iterator();
            while (i2.hasNext()) {
                tempString = (String)i2.next();
                aPC.modFeat(tempString, true, false);
                theObj.addAssociated(tempString);
            }
        } else {
            for (index = 0; index < c.getSelectedList().size(); ++index) {
                aString = (String)c.getSelectedList().get(index);
                if (selectedBonusList.isEmpty()) continue;
                e = selectedBonusList.iterator();
                while (e.hasNext()) {
                    bString = (String)e.next();
                    this.applyBonus(bString, aString, aPC);
                }
            }
        }
    }

    private String getPreFormatedOutputName() {
        if (this.name.indexOf(40) < 0 || this.name.indexOf(41) < 0) {
            return this.name;
        }
        String subName = this.name.substring(this.name.indexOf(40) + 1, this.name.indexOf(41));
        StringTokenizer tok = new StringTokenizer(subName, "/");
        StringBuffer newNameBuff = new StringBuffer();
        while (tok.hasMoreTokens()) {
            newNameBuff.insert(0, tok.nextToken());
            if (!tok.hasMoreTokens()) continue;
            newNameBuff.insert(0, " ");
        }
        return newNameBuff.toString();
    }

    private double calcBonus(String bString, String aType, String aName, String aTypePlusName, Object obj, int iTimes, BonusObj aBonusObj, PlayerCharacter aPC) {
        int iCount;
        StringTokenizer aTok = new StringTokenizer(bString, "|");
        if (aTok.countTokens() < 3) {
            Logging.errorPrint("Badly formed BONUS:" + bString);
            return 0.0;
        }
        String aString = aTok.nextToken();
        if (!aString.equalsIgnoreCase(aType) && !aString.endsWith("%LIST") || aString.endsWith("%LIST") && this.numberInList(aType) == 0 || aName.equals("ALL")) {
            return 0.0;
        }
        String aList = aTok.nextToken();
        if (!aList.equals("LIST") && !aList.equals("ALL") && aList.toUpperCase().indexOf(aName.toUpperCase()) < 0) {
            return 0.0;
        }
        if (aList.equals("ALL") && (aName.indexOf("STAT=") >= 0 || aName.indexOf("TYPE=") >= 0 || aName.indexOf("LIST") >= 0 || aName.indexOf("VAR") >= 0)) {
            return 0.0;
        }
        if (aTok.hasMoreTokens()) {
            aString = aTok.nextToken();
        }
        double iBonus = 0.0;
        if (obj instanceof PlayerCharacter) {
            iBonus = ((PlayerCharacter)obj).getVariableValue(aString, "").doubleValue();
        } else if (obj instanceof Equipment) {
            iBonus = ((Equipment)obj).getVariableValue(aString, "", "", aPC).doubleValue();
        } else {
            try {
                iBonus = Float.parseFloat(aString);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("calcBonus NumberFormatException in BONUS: " + aString, e);
            }
        }
        List bonusPreReqList = aBonusObj.getPrereqList();
        String possibleBonusTypeString = aBonusObj.getTypeString();
        if (obj instanceof PlayerCharacter ? !PrereqHandler.passesAll(bonusPreReqList, (PlayerCharacter)obj, null) : !PrereqHandler.passesAll(bonusPreReqList, (Equipment)obj)) {
            return 0.0;
        }
        double bonus = 0.0;
        if ("LIST".equalsIgnoreCase(aList) && (iCount = this.numberInList(aName)) != 0) {
            bonus += iBonus * (double)iCount;
        }
        String bonusTypeString = null;
        StringTokenizer bTok = new StringTokenizer(aList, ",");
        if (aList.equalsIgnoreCase("LIST")) {
            bTok.nextToken();
        } else if (aList.equalsIgnoreCase("ALL")) {
            aTypePlusName = aType + '.' + aName + '.';
            bonus = iBonus;
            bonusTypeString = possibleBonusTypeString;
        }
        while (bTok.hasMoreTokens()) {
            if (!bTok.nextToken().equalsIgnoreCase(aName)) continue;
            bonus += iBonus;
            bonusTypeString = possibleBonusTypeString;
        }
        if (obj instanceof Equipment) {
            ((Equipment)obj).setBonusStackFor(bonus * (double)iTimes, aTypePlusName + bonusTypeString);
        } else {
            this.setBonusStackFor(bonus * (double)iTimes, aTypePlusName + bonusTypeString);
        }
        if (aList.equals("ALL")) {
            return 0.0;
        }
        return bonus * (double)iTimes;
    }

    private double calcPartialBonus(int iTimes, BonusObj aBonus, Object anObj, PlayerCharacter aPC) {
        return this.calcPartialBonus(iTimes, aBonus, anObj, null, aPC);
    }

    private double calcPartialBonus(int iTimes, BonusObj aBonus, Object anObj, String listString, PlayerCharacter aPC) {
        String aList = aBonus.getBonusInfo();
        String aVal = aBonus.getValue();
        double iBonus = 0.0;
        if (aList.equals("ALL")) {
            return 0.0;
        }
        if (listString != null) {
            int listIndex = aVal.indexOf("%LIST");
            while (listIndex >= 0) {
                boolean found = false;
                for (int i = 0; i < this.getAssociatedCount(); ++i) {
                    String associatedStr = this.getAssociated(i).toUpperCase();
                    if (listString.indexOf(associatedStr) < 0) continue;
                    StringBuffer sb = new StringBuffer();
                    if (listIndex > 0) {
                        sb.append(aVal.substring(0, listIndex));
                    }
                    sb.append(associatedStr);
                    if (aVal.length() > listIndex + 5) {
                        sb.append(aVal.substring(listIndex + 5));
                    }
                    aVal = sb.toString();
                    found = true;
                    break;
                }
                listIndex = found ? aVal.indexOf("%LIST") : -1;
            }
        }
        if (aBonus.isValueStatic()) {
            iBonus = aBonus.getValueAsdouble();
        } else if (anObj instanceof PlayerCharacter) {
            iBonus = ((PlayerCharacter)anObj).getVariableValue(aVal, "").doubleValue();
        } else if (anObj instanceof Equipment) {
            iBonus = ((Equipment)anObj).getVariableValue(aVal, "", "", aPC).doubleValue();
        } else {
            try {
                iBonus = Float.parseFloat(aVal);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("calcPartialBonus NumberFormatException in BONUS: " + aVal);
            }
        }
        return iBonus * (double)iTimes;
    }

    protected void clearMyType() {
        this.myTypeList = null;
    }

    private void clearSelectedWeaponProfBonus() {
        this.selectedWeaponProfBonus = null;
    }

    private boolean containsMyType(String myType) {
        if (this.myTypeList == null) {
            return false;
        }
        return this.myTypeList.contains(myType);
    }

    private final void makeKitSelections(int arg, String kitString, int iKit, PlayerCharacter aPC) {
        int num;
        int aLevel;
        StringTokenizer aTok = new StringTokenizer(kitString, "|", false);
        String tok = aTok.nextToken();
        try {
            aLevel = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            Logging.errorPrint("Badly formed kitString: " + tok);
            aLevel = 0;
        }
        if (aLevel > arg) {
            return;
        }
        tok = aTok.nextToken();
        try {
            num = Integer.parseInt(tok);
        }
        catch (NumberFormatException e) {
            Logging.errorPrint("Badly formed number of kit selections attribute: " + tok);
            num = 0;
        }
        ArrayList aList = new ArrayList();
        while (aTok.hasMoreTokens()) {
            String kitName = aTok.nextToken();
            Kit aKit = Globals.getKitNamed(kitName);
            if (!PrereqHandler.passesAll(aKit.getPreReqList(), aPC, aKit)) continue;
            aList.add(kitName);
        }
        if (num != aList.size()) {
            ChooserInterface c = ChooserFactory.getChooserInstance();
            c.setTitle("Kit Selection");
            c.setPool(num);
            c.setPoolFlag(false);
            c.setAvailableList(aList);
            c.setVisible(true);
            aList = c.getSelectedList();
        }
        if (aList.size() > 0) {
            Iterator i = aList.iterator();
            while (i.hasNext()) {
                String aString = (String)i.next();
                Kit theKit = Globals.getKitNamed(aString);
                if (theKit == null || aPC.getKitInfo() != null && aPC.getKitInfo().indexOf(theKit) >= 0) continue;
                ArrayList thingsToAdd = new ArrayList();
                ArrayList warnings = new ArrayList();
                theKit.addKitFeats(aPC, thingsToAdd, warnings);
                theKit.addKitProfs(aPC, thingsToAdd, warnings);
                theKit.addKitGear(aPC, thingsToAdd, warnings);
                theKit.addKitSpells(aPC, thingsToAdd, warnings);
                theKit.addKitSkills(aPC, thingsToAdd, warnings);
                theKit.processKit(aPC, thingsToAdd, iKit);
                aPC.addTemplateNamed(theKit.getTemplateString());
            }
        }
    }

    private String piDescString(boolean useHeader) {
        String aString = this.description;
        if (this instanceof Feat) {
            aString = ((Feat)this).getBenefitDescription();
        }
        if (this.descIsPI) {
            StringBuffer sb = new StringBuffer(aString.length() + 30);
            if (useHeader) {
                sb.append("<html>");
            }
            sb.append("<b><i>").append(aString).append("</i></b>");
            if (useHeader) {
                sb.append("</html>");
            }
            return sb.toString();
        }
        return aString;
    }

    private String piString(boolean useHeader) {
        String aString = this.toString();
        if (SettingsHandler.guiUsesOutputName()) {
            aString = this.getOutputName();
        }
        if (this.nameIsPI) {
            StringBuffer sb = new StringBuffer(aString.length() + 30);
            if (useHeader) {
                sb.append("<html>");
            }
            sb.append("<b><i>").append(aString).append("</i></b>");
            if (useHeader) {
                sb.append("</html>");
            }
            return sb.toString();
        }
        return aString;
    }

    private final String preReqHTMLStringsForList(PlayerCharacter aPC, List anArrayList) {
        return this.preReqHTMLStringsForList(aPC, null, anArrayList);
    }

    private final String preReqHTMLStringsForList(PlayerCharacter aPC, PObject aObj, List anArrayList) {
        return this.preReqHTMLStringsForList(aPC, aObj, anArrayList, true);
    }

    protected void removeMyType(String myType) {
        this.myTypeList.remove(myType);
    }

    private String returnSourceInForm(int sourceDisplay, boolean includePage) {
        StringBuffer buf = new StringBuffer();
        Campaign _sourceCampaign = this.getSourceCampaign();
        String key = null;
        String publisher = "";
        switch (sourceDisplay) {
            case 0: {
                key = "LONG";
                break;
            }
            case 1: {
                key = "SHORT";
                break;
            }
            case 3: {
                key = "WEB";
                break;
            }
            case 2: {
                key = "PAGE";
                break;
            }
            default: {
                Logging.errorPrint("Unknown source display form in returnSourceInForm: " + sourceDisplay);
                key = "LONG";
            }
        }
        String aSource = this.getSourceWithKey(key);
        if (_sourceCampaign != null) {
            publisher = _sourceCampaign.getPublisherWithKey(key);
            if (aSource == null) {
                aSource = _sourceCampaign.getSourceWithKey(key);
            }
        }
        if (aSource == null) {
            aSource = "";
        }
        if (sourceDisplay == 1) {
            buf.append(aSource);
        } else {
            if (publisher.length() > 0) {
                buf.append(publisher);
                buf.append(" - ");
            }
            buf.append(aSource);
        }
        if (includePage && sourceDisplay != 3 && (aSource = this.getSourceWithKey("PAGE")) != null) {
            buf.append(", ").append(aSource);
        }
        return buf.toString();
    }

    public List getTemplateList() {
        return this.templates;
    }

    public void addTemplate(String template) {
        if (".CLEAR".equals(template)) {
            this.templates.clear();
        } else {
            this.templates.add(template);
        }
    }

    List getTemplates(boolean isImporting, PlayerCharacter aPC) {
        ArrayList<String> newTemplates = new ArrayList<String>();
        this.templatesAdded = new ArrayList();
        if (!isImporting) {
            Iterator e = this.templates.iterator();
            while (e.hasNext()) {
                String templateName = (String)e.next();
                if (templateName.startsWith("CHOOSE:")) {
                    String newTemplate;
                    while ((newTemplate = Globals.chooseFromList("Template Choice (" + this.getName() + ")", templateName.substring(7), null, 1)) == null) {
                    }
                    templateName = newTemplate;
                }
                if (templateName.length() == 0) continue;
                newTemplates.add(templateName);
                this.templatesAdded.add(templateName);
                aPC.addTemplateNamed(templateName);
            }
        }
        return newTemplates;
    }

    List templatesAdded() {
        if (this.templatesAdded == null) {
            return new ArrayList();
        }
        return this.templatesAdded;
    }
}

