/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import pcgen.core.PObject;
import pcgen.util.Logging;

public class PObjectDataStore {
    private Map byKey = new HashMap(100);
    private Map byType = new HashMap(4);
    private Set nameSet;
    private SortedMap byUpperName = new TreeMap();
    private String containedType;

    public PObjectDataStore(String inContainedType) {
        this.containedType = inContainedType;
    }

    public Collection getAllOfType(String type) {
        String upperType = type.toUpperCase();
        ArrayList list = null;
        TreeMap typedByName = (TreeMap)this.byType.get(upperType);
        if (typedByName != null) {
            list = new ArrayList(typedByName.values());
        }
        return list;
    }

    public List getArrayCopy() {
        return new ArrayList(this.byUpperName.values());
    }

    public PObject getKeyed(String aKey) {
        return (PObject)this.byKey.get(aKey.toUpperCase());
    }

    public PObject getNamed(String name) {
        return (PObject)this.byUpperName.get(name.toUpperCase());
    }

    public String getNames(String delim, boolean addArrayMarkers) {
        StringBuffer ret = new StringBuffer();
        boolean first = true;
        if (addArrayMarkers) {
            ret.append("[");
        }
        Iterator ii = this.byUpperName.values().iterator();
        while (ii.hasNext()) {
            if (first) {
                first = false;
            } else {
                ret.append(delim);
            }
            PObject object = (PObject)ii.next();
            ret.append(object.getName());
        }
        if (addArrayMarkers) {
            ret.append("]");
        }
        return ret.toString();
    }

    public void add(PObject obj) {
        String key = obj.getKeyName().toUpperCase();
        this.byKey.put(key, obj);
        String upperName = obj.getName().toUpperCase();
        this.byUpperName.put(upperName, obj);
        Iterator e = obj.getMyTypeIterator();
        while (e.hasNext()) {
            String aString = (String)e.next();
            TreeMap<String, PObject> typedByName = (TreeMap<String, PObject>)this.byType.get(aString);
            if (typedByName == null) {
                typedByName = new TreeMap<String, PObject>();
                this.byType.put(aString, typedByName);
            }
            typedByName.put(upperName, obj);
        }
        this.clearVariableNameCache();
    }

    public void addUniqueAsStringTo(List dest) {
        Iterator ii = this.byUpperName.values().iterator();
        while (ii.hasNext()) {
            PObject object = (PObject)ii.next();
            if (dest.contains(object.toString())) continue;
            dest.add(object.toString());
        }
        this.clearVariableNameCache();
    }

    public void clear() {
        this.byKey.clear();
        this.byType.clear();
        this.byUpperName.clear();
        this.clearVariableNameCache();
    }

    public boolean hasVariableNamed(Collection collectionOfNames, String variableName) {
        if (collectionOfNames.isEmpty()) {
            return false;
        }
        if (!this.hasVariableNamed(variableName)) {
            return false;
        }
        Iterator e = collectionOfNames.iterator();
        while (e.hasNext()) {
            String wpName = (String)e.next();
            PObject obj = this.getNamed(wpName);
            if (obj == null) {
                Logging.debugPrint("No PObject for " + this.containedType + " " + wpName);
                continue;
            }
            if (!obj.hasVariableNamed(variableName)) continue;
            return true;
        }
        return false;
    }

    public void removeNamed(String name) {
        PObject object = this.getNamed(name);
        this.byUpperName.remove(object.getName().toUpperCase());
        this.byKey.remove(object.getKeyName().toUpperCase());
        TreeMap typedByName = (TreeMap)this.byType.get(object.getType().toUpperCase());
        if (typedByName != null) {
            typedByName.remove(object.getName().toUpperCase());
        }
        this.clearVariableNameCache();
    }

    public int size() {
        return this.byUpperName.size();
    }

    private final void cacheVariableNames() {
        this.nameSet = new HashSet();
        Iterator i = this.byUpperName.values().iterator();
        while (i.hasNext()) {
            PObject object = (PObject)i.next();
            Set variableNames = object.getVariableNamesAsUnmodifiableSet();
            if (variableNames == null) continue;
            this.nameSet.addAll(variableNames);
        }
    }

    private final void clearVariableNameCache() {
        this.nameSet = null;
    }

    private boolean hasVariableNamed(String variableName) {
        String upperName = variableName.toUpperCase();
        if (this.nameSet == null) {
            this.cacheVariableNames();
        }
        return this.nameSet.contains(upperName);
    }
}

