/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import pcgen.core.ArmorProf;
import pcgen.core.CharacterDomain;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.HasCost;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.LevelAbilityLanguage;
import pcgen.core.LevelInfo;
import pcgen.core.NoteItem;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SkillComparator;
import pcgen.core.SpecialAbility;
import pcgen.core.StatList;
import pcgen.core.SystemCollections;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.CachedVariable;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.CompanionMod;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellInfo;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteComparator;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.BonusToken;
import pcgen.io.exporttoken.EqTypeToken;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;

public final class PlayerCharacter
extends Observable {
    public static final int ATTACKBONUS = 0;
    public static final int MONKBONUS = 4;
    private static final BigDecimal BIG_ONE = new BigDecimal("1.00");
    private static final int nonProficiencyPenalty = -4;
    private static String lastVariable = null;
    private static String loopVariable = "";
    private static int loopValue = 0;
    private static int decrement;
    private final ArrayList armorProfList = new ArrayList();
    private final ArrayList featList = new ArrayList();
    private final ArrayList miscList = new ArrayList(3);
    private final ArrayList notesList = new ArrayList();
    private final ArrayList primaryWeapons = new ArrayList();
    private final ArrayList secondaryWeapons = new ArrayList();
    private final ArrayList shieldProfList = new ArrayList();
    private final ArrayList skillList = new ArrayList();
    private final ArrayList specialAbilityList = new ArrayList();
    private final ArrayList templateList = new ArrayList();
    private final ArrayList variableList = new ArrayList();
    private BigDecimal gold = new BigDecimal("0.00");
    private Deity deity = null;
    private HashMap domainSourceMap = new HashMap();
    private List activeBonusList = new LinkedList();
    private final List characterDomainList = new ArrayList();
    private ArrayList classList = new ArrayList();
    private final ArrayList companionModList = new ArrayList();
    private final List followerList = new ArrayList();
    private ArrayList qualifyArrayList = new ArrayList();
    private Follower followerMaster = null;
    private final List equipSetList = new ArrayList();
    private List equipmentList = new ArrayList();
    private List equipmentMasterList = new ArrayList();
    private List pcLevelInfo = new ArrayList();
    private List processedBonusList = new LinkedList();
    private final List spellBooks = new ArrayList();
    private List tempBonusItemList = new LinkedList();
    private List tempBonusList = new LinkedList();
    private Map activeBonusMap = new TreeMap();
    private Race race = null;
    private final SortedSet favoredClasses = new TreeSet();
    private final StatList statList = new StatList(this);
    private HashMap spellInfoMap = new HashMap();
    private HashMap spellLevelMap = new HashMap();
    private List kitList = null;
    private List stableAggregateFeatList = null;
    private List stableAutomaticFeatList = null;
    private List stableVirtualFeatList = null;
    private final List templateAutoLanguages = new ArrayList();
    private final SortedSet templateLanguages = new TreeSet();
    private String bio = "";
    private String birthplace = "";
    private String calcEquipSetId = "0.1";
    private String catchPhrase = "";
    private String currentEquipSetName = "";
    private String description = "";
    private String descriptionLst = "EMPTY";
    private String eyeColor = "";
    private String fileName = "";
    private String gender = "Male";
    private String hairColor = "";
    private String hairStyle = "";
    private String handed = "Right";
    private String interests = "";
    private String location = "";
    private String name = "";
    private String phobias = "";
    private String playersName = "";
    private String portraitPath = "";
    private String racialFavoredClass = "";
    private String region = null;
    private String residence = "";
    private String skinColor = "";
    private String speechTendency = "";
    private String subRegion = null;
    private String tabName = "";
    private String trait1 = "";
    private String trait2 = "";
    private final TreeSet languages = new TreeSet();
    private HashSet variableSet = new HashSet();
    private final TreeSet weaponProfList = new TreeSet();
    private Double[] movementMult = new Double[0];
    private String[] movementMultOp = new String[0];
    private String[] movementTypes = new String[0];
    private Double[] movements = new Double[0];
    private boolean aggregateFeatsStable = false;
    private boolean armorProfListStable = false;
    private boolean autoKnownSpells = true;
    private boolean autoLoadCompanion = false;
    private boolean autoSortGear = true;
    private boolean automaticFeatsStable = false;
    private boolean qualifyListStable = false;
    private final boolean useMonsterDefault = SettingsHandler.isMonsterDefault();
    private String outputSheetHTML = "";
    private String outputSheetPDF = "";
    private boolean[] ageSetKitSelections = new boolean[10];
    private boolean dirtyFlag = false;
    private int serial = 0;
    private boolean displayUpdate = false;
    private boolean importing = false;
    private boolean useTempMods = false;
    private boolean virtualFeatsStable = false;
    private double feats = 0.0;
    private int age = 0;
    private int alignment = 9;
    private int costPool = 0;
    private int currentEquipSetNumber = 0;
    private int currentHP = 0;
    private int earnedXP = 0;
    private int equipOutputOrder = 0;
    private int freeLangs = 0;
    private int heightInInches = 0;
    private int poolAmount = 0;
    private int skillPoints = 0;
    private int skillsOutputOrder = 0;
    private int spellLevelTemp = 0;
    private int weightInPounds = 0;
    private String jepIndent = "";
    private Map variableCache = new HashMap();
    private int cachePaused;

    public PlayerCharacter() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.ageSetKitSelections[i] = false;
        }
        Globals.setCurrentPC(this);
        int x = SettingsHandler.getGame().s_ATTRIBLONG.length;
        for (i = 0; i < x; ++i) {
            PCStat stat = (PCStat)SettingsHandler.getGame().getUnmodifiableStatList().get(i);
            this.statList.getStats().add(stat.clone());
        }
        this.setRace((Race)Globals.getRaceMap().get("<none selected>"));
        this.setName("");
        this.skillPoints = 0;
        this.feats = 0.0;
        this.rollStats(SettingsHandler.getRollMethod());
        this.miscList.add("");
        this.miscList.add("");
        this.miscList.add("");
        this.addSpellBook(Globals.getDefaultSpellBook());
        this.addSpellBook("Innate");
        this.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills(), 1);
    }

    public Map getActiveBonusMap() {
        return this.activeBonusMap;
    }

    public void setAge(int i) {
        this.age = i;
        this.setDirty(true);
        this.calcActiveBonuses();
        if (!this.importing) {
            Globals.getBioSet().makeKitSelectionFor(this);
        }
    }

    public int getAge() {
        return this.age;
    }

    public void setAggregateFeatsStable(boolean stable) {
        this.aggregateFeatsStable = stable;
    }

    public boolean isAggregateFeatsStable() {
        return this.automaticFeatsStable && this.virtualFeatsStable && this.aggregateFeatsStable;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public ArrayList getAllSkillList(boolean checkBonus) {
        if (!checkBonus) {
            return this.skillList;
        }
        Iterator i = Globals.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            if (this.hasSkill(aSkill.getName()) || CoreUtility.doublesEqual(this.getTotalBonusTo("SKILLRANK", aSkill.getName()), 0.0)) continue;
            this.addSkill(aSkill);
        }
        return this.skillList;
    }

    public ArrayList getArmorProfList() {
        if (this.armorProfListStable) {
            return this.armorProfList;
        }
        List autoArmorProfList = this.getAutoArmorProfList();
        this.addArmorProfs(autoArmorProfList);
        ArrayList selectedProfList = this.getSelectedArmorProfList();
        this.addArmorProfs(selectedProfList);
        this.armorProfListStable = true;
        return this.armorProfList;
    }

    public void setArmorProfListStable(boolean arg) {
        this.armorProfListStable = arg;
        this.setDirty(true);
    }

    public void setAutomaticFeatsStable(boolean stable) {
        this.automaticFeatsStable = stable;
    }

    public int getBaseSpellStatBonus(PCClass aClass) {
        int statIndex;
        if (aClass == null) {
            return 0;
        }
        int baseSpellStat = 0;
        String statString = aClass.getSpellBaseStat();
        if (!statString.equals("None") && (statIndex = this.getStatList().getIndexOfStatFor(statString)) >= 0) {
            baseSpellStat = this.getStatList().getTotalStatFor(statString);
            baseSpellStat += (int)this.getTotalBonusTo("STAT", "BASESPELLSTAT");
            baseSpellStat += (int)this.getTotalBonusTo("STAT", "BASESPELLSTAT;CLASS." + aClass.getName());
            baseSpellStat += (int)this.getTotalBonusTo("STAT", "CAST." + statString);
            baseSpellStat = this.getStatList().getModForNumber(baseSpellStat, statIndex);
        }
        return baseSpellStat;
    }

    public void setBio(String aString) {
        this.bio = aString;
        this.setDirty(true);
    }

    public String getBio() {
        return this.bio;
    }

    public void setBirthplace(String aString) {
        this.birthplace = aString;
        this.setDirty(true);
    }

    public String getBirthplace() {
        return this.birthplace;
    }

    public void setCalcEquipSetId(String eqSetId) {
        this.calcEquipSetId = eqSetId;
        this.setDirty(true);
    }

    public String getCalcEquipSetId() {
        if (this.equipSetList.isEmpty()) {
            return this.calcEquipSetId;
        }
        if (this.getEquipSetByIdPath(this.calcEquipSetId) == null) {
            Iterator e = this.equipSetList.iterator();
            while (e.hasNext()) {
                EquipSet eSet = (EquipSet)e.next();
                if (!eSet.getParentIdPath().equals("0")) continue;
                this.calcEquipSetId = eSet.getIdPath();
                return this.calcEquipSetId;
            }
        }
        return this.calcEquipSetId;
    }

    public void setCalcEquipmentList() {
        this.setCalcEquipmentList(false);
    }

    public void setCalcEquipmentList(boolean useTempBonuses) {
        Equipment anEquip;
        Equipment eq;
        String calcId = this.getCalcEquipSetId();
        EquipSet eSet = this.getEquipSetByIdPath(calcId);
        if (eSet == null) {
            Logging.errorPrint("Error: No EquipSet selected for output");
            return;
        }
        ArrayList eqList = new ArrayList();
        this.setEquipmentList(eqList);
        List pcEquipSetList = this.getEquipSet();
        if (pcEquipSetList.isEmpty()) {
            return;
        }
        Collections.sort(pcEquipSetList);
        Iterator e = pcEquipSetList.iterator();
        while (e.hasNext()) {
            Equipment eqI;
            EquipSet es = (EquipSet)e.next();
            String abCalcId = calcId + ".";
            String abParentId = es.getParentIdPath() + ".";
            if (!abParentId.startsWith(abCalcId) || (eqI = es.getItem()) == null) continue;
            Equipment eq2 = es.getItem();
            String aLoc = es.getName();
            String aNote = es.getNote();
            Float num = es.getQty();
            StringTokenizer aTok = new StringTokenizer(es.getIdPath(), ".");
            if (aTok.countTokens() > 3) {
                eq2.setLocation(7);
                eq2.setIsEquipped(false, this);
                eq2.setNumberCarried(num);
                eq2.setQty(num);
            } else if (aLoc.startsWith("Carried")) {
                eq2.setLocation(6);
                eq2.setIsEquipped(false, this);
                eq2.setNumberCarried(num);
                eq2.setQty(num);
            } else if (aLoc.startsWith("Not Carried")) {
                eq2.setLocation(8);
                eq2.setIsEquipped(false, this);
                eq2.setNumberCarried(new Float(0.0f));
                eq2.setQty(num);
            } else if (eq2.isWeapon()) {
                if (aLoc.equals("Primary Hand") || aLoc.equals("Natural-Primary")) {
                    eq2.setQty(num);
                    eq2.setNumberCarried(num);
                    eq2.setNumberEquipped(num.intValue());
                    eq2.setLocation(1);
                    eq2.setIsEquipped(true, this);
                } else if (aLoc.startsWith("Secondary Hand") || aLoc.equals("Natural-Secondary")) {
                    eq2.setQty(num);
                    eq2.setNumberCarried(num);
                    eq2.setNumberEquipped(num.intValue());
                    eq2.setLocation(2);
                    eq2.setIsEquipped(true, this);
                } else if (aLoc.equals("Both Hands")) {
                    eq2.setQty(num);
                    eq2.setNumberCarried(num);
                    eq2.setNumberEquipped(num.intValue());
                    eq2.setLocation(3);
                    eq2.setIsEquipped(true, this);
                } else if (aLoc.equals("Double Weapon")) {
                    eq2.setQty(num);
                    eq2.setNumberCarried(num);
                    eq2.setNumberEquipped(2);
                    eq2.setLocation(4);
                    eq2.setIsEquipped(true, this);
                } else if (aLoc.equals("Unarmed")) {
                    eq2.setLocation(0);
                    eq2.setNumberEquipped(num.intValue());
                } else if (aLoc.equals("Two Weapons")) {
                    if (num.doubleValue() < 2.0) {
                        num = new Float(2.0);
                    }
                    es.setQty(num);
                    eq2.setQty(num);
                    eq2.setNumberCarried(num);
                    eq2.setNumberEquipped(2);
                    eq2.setLocation(4);
                    eq2.setIsEquipped(true, this);
                } else if (aLoc.equals("Shield")) {
                    eq2.setLocation(0);
                    eq2.setNumberEquipped(num.intValue());
                }
            } else {
                eq2.setLocation(0);
                eq2.setIsEquipped(true, this);
                eq2.setNumberCarried(num);
                eq2.setQty(num);
            }
            if (aNote != null && aNote.length() > 0) {
                eq2.setNote(aNote);
            }
            this.addLocalEquipment(eq2);
        }
        e = this.getEquipmentList().iterator();
        while (e.hasNext()) {
            eq = (Equipment)e.next();
            if (eq.isContainer()) {
                eq.updateContainerContentsString(this);
            }
            if ((anEquip = this.getEquipmentNamed(eq.getName())) == null) continue;
            eq.setOutputIndex(anEquip.getOutputIndex());
        }
        if (useTempBonuses) {
            e = this.getTempBonusItemList().iterator();
            while (e.hasNext()) {
                eq = (Equipment)e.next();
                anEquip = this.getEquipmentNamed(eq.getName(), this.getEquipmentList());
                if (anEquip == null) continue;
                eq.setQty(anEquip.getQty());
                eq.setNumberCarried(anEquip.getCarried());
                if (anEquip.isEquipped()) {
                    if (eq.isWeapon()) {
                        eq.setSlots(0);
                        eq.setCost("0");
                        eq.setWeight("0");
                        eq.setLocation(anEquip.getLocation());
                    } else {
                        eq.setLocation(anEquip.getLocation());
                        this.removeLocalEquipment(anEquip);
                        anEquip.setIsEquipped(false, this);
                        anEquip.setLocation(8);
                        anEquip.setNumberCarried(new Float(0.0f));
                    }
                    eq.setIsEquipped(true, this);
                    eq.setNumberEquipped(1);
                } else {
                    eq.setCost("0");
                    eq.setWeight("0");
                    eq.setLocation(5);
                    eq.setIsEquipped(false, this);
                }
                eq.setTypeInfo("TEMPORARY");
                this.addLocalEquipment(eq);
            }
        }
    }

    public void setCalcFollowerBonus(PlayerCharacter aPC) {
        List aList = this.getFollowerList();
        this.setDirty(true);
        if (aList.isEmpty()) {
            return;
        }
        Iterator fm = aList.iterator();
        while (fm.hasNext()) {
            Follower aF = (Follower)fm.next();
            String rType = aF.getType().toUpperCase();
            String rName = aF.getRace().toUpperCase();
            Iterator cm = Globals.getCompanionModList().iterator();
            while (cm.hasNext()) {
                CompanionMod aComp = (CompanionMod)cm.next();
                String aType = aComp.getType().toUpperCase();
                int iRace = aComp.getLevel(rName);
                if (!aType.equals(rType) || iRace != 1) continue;
                this.companionModList.add(aComp);
                aComp.activateBonuses(aPC);
            }
        }
    }

    public void setCatchPhrase(String aString) {
        this.catchPhrase = aString;
        this.setDirty(true);
    }

    public String getCatchPhrase() {
        return this.catchPhrase;
    }

    public PCClass getClassKeyed(String aString) {
        Iterator classIter = this.classList.iterator();
        while (classIter.hasNext()) {
            PCClass aClass = (PCClass)classIter.next();
            if (!aClass.getKeyName().equalsIgnoreCase(aString)) continue;
            return aClass;
        }
        return null;
    }

    public ArrayList getClassList() {
        return this.classList;
    }

    public PCClass getClassNamed(String aString) {
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            if (!aClass.getName().equalsIgnoreCase(aString)) continue;
            return aClass;
        }
        return null;
    }

    public void setCostPool(int i) {
        this.costPool = i;
    }

    public int getCostPool() {
        return this.costPool;
    }

    public List getTypes() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.race != null) {
            list.add(this.race.getType());
        } else {
            list.add("Humanoid");
        }
        Iterator e = this.templateList.iterator();
        while (e.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)e.next();
            String aType = aTemplate.getType();
            list.add(aType);
        }
        return list;
    }

    public String getCritterType() {
        StringBuffer critterType = new StringBuffer();
        if (this.race != null) {
            critterType.append(this.race.getType());
        } else {
            critterType.append("Humanoid");
        }
        if (!this.templateList.isEmpty()) {
            Iterator e = this.templateList.iterator();
            while (e.hasNext()) {
                PCTemplate aTemplate = (PCTemplate)e.next();
                String aType = aTemplate.getType();
                if ("".equals(aType)) continue;
                critterType.append('|').append(aType);
            }
        }
        return critterType.toString();
    }

    public void setCurrentEquipSetName(String aName) {
        this.currentEquipSetName = aName;
        this.setDirty(true);
    }

    public String getCurrentEquipSetName() {
        return this.currentEquipSetName;
    }

    public Deity getDeity() {
        return this.deity;
    }

    public void setDescription(String aString) {
        this.description = aString;
        this.setDirty(true);
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLst() {
        return this.descriptionLst;
    }

    public void setDirty(boolean dirtyState) {
        this.displayUpdate = true;
        if (dirtyState) {
            ++this.serial;
        }
        if (this.dirtyFlag != dirtyState) {
            this.dirtyFlag = dirtyState;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public int getSerial() {
        return this.serial;
    }

    public String getDisplayName() {
        String custom = this.getTabName();
        if (!"".equals(custom)) {
            return custom;
        }
        StringBuffer displayName = new StringBuffer().append(this.getName());
        switch (SettingsHandler.getNameDisplayStyle()) {
            case 0: {
                break;
            }
            case 1: {
                displayName.append(" the ").append(this.getDisplayClassName());
                break;
            }
            case 2: {
                displayName.append(" the ").append(this.getDisplayRaceName());
                break;
            }
            case 3: {
                displayName.append(" the ").append(this.getDisplayRaceName()).append(' ').append(this.getDisplayClassName());
                break;
            }
            case 4: {
                return this.getFullDisplayName();
            }
        }
        return displayName.toString();
    }

    public void setDisplayUpdate(boolean displayUpdate) {
        this.displayUpdate = displayUpdate;
    }

    public boolean isDisplayUpdate() {
        return this.displayUpdate;
    }

    public List getEquipSet() {
        return this.equipSetList;
    }

    public EquipSet getEquipSetByIdPath(String id) {
        if (this.equipSetList.isEmpty()) {
            return null;
        }
        Iterator e = this.equipSetList.iterator();
        while (e.hasNext()) {
            EquipSet eSet = (EquipSet)e.next();
            if (!eSet.getIdPath().equals(id)) continue;
            return eSet;
        }
        return null;
    }

    public EquipSet getEquipSetByName(String aName) {
        if (this.equipSetList.isEmpty()) {
            return null;
        }
        Iterator e = this.equipSetList.iterator();
        while (e.hasNext()) {
            EquipSet eSet = (EquipSet)e.next();
            if (!eSet.getName().equals(aName)) continue;
            return eSet;
        }
        return null;
    }

    public void setEquipSetNumber(int anInt) {
        this.currentEquipSetNumber = anInt;
        this.setDirty(true);
    }

    public int getEquipSetNumber() {
        return this.currentEquipSetNumber;
    }

    public String getEquipSetWeight(String idPath) {
        if (this.equipSetList.isEmpty()) {
            return "";
        }
        double totalWeight = 0.0;
        Iterator eSet = this.equipSetList.iterator();
        while (eSet.hasNext()) {
            Equipment eqI;
            EquipSet es = (EquipSet)eSet.next();
            String abIdPath = idPath + ".";
            String esIdPath = es.getIdPath() + ".";
            if (!esIdPath.startsWith(abIdPath) || (eqI = es.getItem()) == null || !(eqI.getCarried().floatValue() > 0.0f) || eqI.getParent() != null) continue;
            if (eqI.getChildCount() > 0) {
                totalWeight += eqI.getWeightAsDouble(this) + (double)eqI.getContainedWeight(this).floatValue();
                continue;
            }
            totalWeight += eqI.getWeightAsDouble(this) * (double)eqI.getCarried().floatValue();
        }
        BigDecimal d = new BigDecimal(String.valueOf(totalWeight));
        return BigDecimalHelper.formatBigDecimal(d, 2).toString();
    }

    public Float getEquipSetCount(String idPath, String aName) {
        float count = 0.0f;
        Iterator es = this.getEquipSet().iterator();
        while (es.hasNext()) {
            String abID;
            EquipSet eSet = (EquipSet)es.next();
            String esID = eSet.getIdPath() + ".";
            if (!esID.startsWith(abID = idPath + ".") || !eSet.getValue().equals(aName)) continue;
            count += eSet.getQty().floatValue();
        }
        return new Float(count);
    }

    public void setEquipmentList(List eqList) {
        this.equipmentList = eqList;
    }

    public List getEquipmentList() {
        return this.equipmentList;
    }

    public List getEquipmentListInOutputOrder() {
        return this.sortEquipmentList(this.getEquipmentList());
    }

    public List getEquipmentListInOutputOrder(int merge) {
        return this.sortEquipmentList(this.getEquipmentList(), merge);
    }

    public List getEquipmentMasterList() {
        ArrayList aList = new ArrayList(this.equipmentMasterList);
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            PObject aPObj = (PObject)i.next();
            if (aPObj == null) continue;
            aPObj.addAutoTagsToList("EQUIP", aList, this);
        }
        return aList;
    }

    public List getEquipmentMasterListInOutputOrder() {
        return PlayerCharacter.mergeEquipmentList(this.getEquipmentMasterList(), 1);
    }

    public Equipment getEquipmentNamed(String aString, List aList) {
        if (aList.isEmpty()) {
            return null;
        }
        Equipment match = null;
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!aString.equalsIgnoreCase(eq.getName())) continue;
            match = eq;
        }
        if (match != null) {
            return match;
        }
        return null;
    }

    public void setEyeColor(String aString) {
        this.eyeColor = aString;
        this.setDirty(true);
    }

    public String getEyeColor() {
        return this.eyeColor;
    }

    public ArrayList getFeatList() {
        return this.featList;
    }

    public void setFeats(double arg) {
        this.feats = arg;
        this.setDirty(true);
    }

    public double getFeats() {
        return this.feats + this.getBonusFeatPool();
    }

    private double getBonusFeatPool() {
        return this.getTotalBonusTo("FEAT", "POOL");
    }

    public void setFileName(String newFileName) {
        this.fileName = newFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List getFollowerList() {
        return this.followerList;
    }

    public String getFullDisplayName() {
        int levels = this.getTotalLevels();
        return this.getName() + " the " + levels + this.getOrdinal(levels) + " level " + this.getDisplayRaceName() + ' ' + (this.classList.size() < 2 ? this.getDisplayClassName() : this.getFullDisplayClassName());
    }

    public String getFullRegion() {
        String sub = this.getSubRegion();
        StringBuffer tempRegName = new StringBuffer().append(this.getRegion());
        if (!sub.equals("None")) {
            tempRegName.append(" (").append(sub).append(')');
        }
        return tempRegName.toString();
    }

    public void setGender(String argGender) {
        String templateGender = this.findTemplateGender();
        this.gender = templateGender.equals("None") ? argGender : templateGender;
        this.setDirty(true);
    }

    public String getGender() {
        String tGender = this.findTemplateGender();
        return tGender.equals("None") ? this.gender : tGender;
    }

    public void setGold(String aString) {
        this.gold = new BigDecimal(aString);
        this.setDirty(true);
    }

    public BigDecimal getGold() {
        return this.gold;
    }

    public void setHairColor(String aString) {
        this.hairColor = aString;
        this.setDirty(true);
    }

    public String getHairColor() {
        return this.hairColor;
    }

    public void setHairStyle(String aString) {
        this.hairStyle = aString;
        this.setDirty(true);
    }

    public String getHairStyle() {
        return this.hairStyle;
    }

    public void setHanded(String aString) {
        this.handed = aString;
        this.setDirty(true);
    }

    public String getHanded() {
        return this.handed;
    }

    public void setHeight(double i) {
        this.heightInInches = Globals.convertHeightFromUnitSet(i);
        this.setDirty(true);
    }

    public double getHeight() {
        return Globals.convertHeightToUnitSet(this.heightInInches);
    }

    public void setHeightInInches(int i) {
        this.heightInInches = i;
        this.setDirty(true);
    }

    public int getHeightInInches() {
        return this.heightInInches;
    }

    public void setImporting(boolean newIsImporting) {
        this.importing = newIsImporting;
    }

    public double getInitialFeats() {
        ArrayList aList;
        double initFeats = 0.0;
        String monsterRace = this.getRace().getMonsterClass(this, false);
        if (monsterRace == null || !this.isMonsterDefault()) {
            initFeats = this.getRace().getBonusInitialFeats();
        }
        if (!(aList = this.getTemplateList()).isEmpty() && PlayerCharacter.canReassignTemplateFeats()) {
            Iterator e = aList.iterator();
            while (e.hasNext()) {
                PCTemplate template = (PCTemplate)e.next();
                if (template == null) continue;
                initFeats += (double)template.getBonusInitialFeats();
            }
        }
        return initFeats;
    }

    public void setInterests(String aString) {
        this.interests = aString;
        this.setDirty(true);
    }

    public String getInterests() {
        return this.interests;
    }

    public TreeSet getLanguagesList() {
        return this.languages;
    }

    public String getLanguagesListNames() {
        TreeSet aSet = this.getLanguagesList();
        StringBuffer b = new StringBuffer();
        Iterator i = aSet.iterator();
        while (i.hasNext()) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(i.next().toString());
        }
        return b.toString();
    }

    public void setLocation(String aString) {
        this.location = aString;
        this.setDirty(true);
    }

    public String getLocation() {
        return this.location;
    }

    public void setMaster(Follower aM, PlayerCharacter aPC) {
        PCClass newClass;
        String aType;
        CompanionMod aComp;
        this.followerMaster = aM;
        PlayerCharacter mPC = this.getMasterPC();
        if (mPC == null) {
            return;
        }
        if (!aM.getFileName().equals(mPC.getFileName())) {
            aM.setFileName(mPC.getFileName());
            this.setDirty(true);
        }
        if (!aM.getName().equals(mPC.getName())) {
            aM.setName(mPC.getName());
            this.setDirty(true);
        }
        int mTotalLevel = 0;
        int addHD = 0;
        Iterator c = mPC.getClassList().iterator();
        while (c.hasNext()) {
            PCClass mClass = (PCClass)c.next();
            boolean found = false;
            Iterator cm = Globals.getCompanionModList().iterator();
            while (cm.hasNext()) {
                CompanionMod aComp2 = (CompanionMod)cm.next();
                String aType2 = aComp2.getType().toUpperCase();
                if (!aType2.equalsIgnoreCase(aM.getType()) || aComp2.getLevel(mClass.getName()) <= 0 || found) continue;
                mTotalLevel += mClass.getLevel();
                found = true;
            }
        }
        this.companionModList.clear();
        String newRaceType = "";
        String oldRaceType = this.race.getType();
        Iterator cm = Globals.getCompanionModList().iterator();
        while (cm.hasNext()) {
            aComp = (CompanionMod)cm.next();
            aType = aComp.getType().toUpperCase();
            if (!aType.equalsIgnoreCase(aM.getType())) continue;
            Iterator iType = aComp.getVarMap().keySet().iterator();
            while (iType.hasNext()) {
                String varName = (String)iType.next();
                if (mPC.getVariableValue(varName, "").intValue() < aComp.getLevel(varName) || this.companionModList.contains(aComp)) continue;
                this.companionModList.add(aComp);
                addHD += aComp.getHitDie();
                if (aComp.getCompanionSwitch(oldRaceType) == null) continue;
                newRaceType = aComp.getCompanionSwitch(oldRaceType);
            }
        }
        cm = Globals.getCompanionModList().iterator();
        while (cm.hasNext()) {
            aComp = (CompanionMod)cm.next();
            aType = aComp.getType().toUpperCase();
            if (!aType.equalsIgnoreCase(aM.getType())) continue;
            Iterator c2 = mPC.getClassList().iterator();
            while (c2.hasNext()) {
                PCClass mClass = (PCClass)c2.next();
                int mLev = mClass.getLevel();
                int compLev = aComp.getLevel(mClass.getName());
                if (compLev < 0 || compLev > mLev && compLev > mTotalLevel || this.companionModList.contains(aComp)) continue;
                this.companionModList.add(aComp);
                addHD += aComp.getHitDie();
                if (aComp.getCompanionSwitch(oldRaceType) == null) continue;
                newRaceType = aComp.getCompanionSwitch(oldRaceType);
            }
        }
        if (newRaceType != null && newRaceType.length() > 0) {
            newClass = Globals.getClassNamed(newRaceType);
            this.race.setTypeInfo(".CLEAR." + newRaceType);
            this.setDirty(true);
            PCClass oldClass = this.getClassNamed(oldRaceType);
            int oldLevel = 0;
            if (oldClass != null) {
                oldLevel = oldClass.getLevel();
            }
            if (oldLevel > 0 && newClass != null) {
                int negLevel = oldLevel * -1;
                this.incrementClassLevel(negLevel, oldClass, true);
                this.incrementClassLevel(oldLevel, newClass, true);
            }
        }
        newClass = Globals.getClassNamed(this.race.getType());
        int usedHD = this.followerMaster.getUsedHD();
        if (newClass != null && (addHD -= usedHD) > 0) {
            this.incrementClassLevel(addHD, newClass, true);
            this.followerMaster.setUsedHD(addHD);
            this.setDirty(true);
        }
        if (this.getUseMasterSkill()) {
            ArrayList mList = mPC.getSkillList();
            ArrayList<String> sNameList = new ArrayList<String>();
            Iterator a = this.getAllSkillList(true).iterator();
            while (a.hasNext()) {
                Skill fSkill = (Skill)a.next();
                Iterator b = mList.iterator();
                while (b.hasNext()) {
                    Skill mSkill = (Skill)b.next();
                    if (mSkill.getName().equals(fSkill.getName()) && mSkill.getRank().intValue() > fSkill.getRank().intValue()) {
                        fSkill.setZeroRanks(newClass, aPC);
                        fSkill.modRanks(mSkill.getRank().doubleValue(), newClass, true, aPC);
                    }
                    if (this.hasSkill(mSkill.getName()) || sNameList.contains(mSkill.getName())) continue;
                    sNameList.add(mSkill.getName());
                }
            }
            Iterator sn = sNameList.iterator();
            while (sn.hasNext()) {
                String skillName = (String)sn.next();
                Skill newSkill = (Skill)Globals.getSkillNamed(skillName).clone();
                double sr = mPC.getSkillNamed(skillName).getRank().doubleValue();
                if (newSkill.getChoiceString() != null && newSkill.getChoiceString().length() > 0) continue;
                newSkill.modRanks(sr, newClass, true, aPC);
                this.getSkillList().add(newSkill);
            }
        }
        this.setDirty(true);
    }

    public Follower getMaster() {
        return this.followerMaster;
    }

    public PlayerCharacter getMasterPC() {
        PlayerCharacter nPC;
        if (this.followerMaster == null) {
            return null;
        }
        Iterator p = Globals.getPCList().iterator();
        while (p.hasNext()) {
            nPC = (PlayerCharacter)p.next();
            if (!this.followerMaster.getFileName().equals(nPC.getFileName())) continue;
            return nPC;
        }
        p = Globals.getPCList().iterator();
        while (p.hasNext()) {
            nPC = (PlayerCharacter)p.next();
            if (!this.followerMaster.getName().equals(nPC.getName())) continue;
            return nPC;
        }
        return null;
    }

    public boolean isMonsterDefault() {
        return this.useMonsterDefault;
    }

    public void setName(String aString) {
        this.name = aString;
        this.setDirty(true);
    }

    public String getName() {
        return this.name;
    }

    public List getNamedTempBonusList() {
        LinkedList<String> aList = new LinkedList<String>();
        Iterator ab = this.getTempBonusList().iterator();
        while (ab.hasNext()) {
            String aName;
            PObject aCreator;
            BonusObj aBonus = (BonusObj)ab.next();
            if (aBonus == null || !aBonus.isApplied() || (aCreator = (PObject)aBonus.getCreatorObject()) == null || aList.contains(aName = aCreator.getName())) continue;
            aList.add(aName);
        }
        return aList;
    }

    public int getNonProficiencyPenalty() {
        int npp = -4;
        Iterator e = this.templateList.iterator();
        while (e.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)e.next();
            npp = aTemplate.getNonProficiencyPenalty();
        }
        if (npp != -4 && npp <= 0) {
            return npp;
        }
        return -4;
    }

    public ArrayList getNotesList() {
        return this.notesList;
    }

    public void setPhobias(String aString) {
        this.phobias = aString;
        this.setDirty(true);
    }

    public String getPhobias() {
        return this.phobias;
    }

    public void setPlayersName(String aString) {
        this.playersName = aString;
        this.setDirty(true);
    }

    public String getPlayersName() {
        return this.playersName;
    }

    public void setPoolAmount(int anInt) {
        this.poolAmount = anInt;
    }

    public int getPoolAmount() {
        return this.poolAmount;
    }

    public void setPortraitPath(String newPortraitPath) {
        this.portraitPath = newPortraitPath;
        this.setDirty(true);
    }

    public String getPortraitPath() {
        return this.portraitPath;
    }

    public List getPrimaryWeapons() {
        return this.primaryWeapons;
    }

    public Race getRace() {
        return this.race;
    }

    public void setRegion(String arg) {
        this.region = arg;
        this.setDirty(true);
    }

    public String getRegion() {
        return this.getRegion(true);
    }

    public String getRegion(boolean useTemplates) {
        if (this.region != null || !useTemplates) {
            return this.region;
        }
        String r = "None";
        int x = this.templateList.size();
        for (int i = 0; i < x; ++i) {
            PCTemplate template = (PCTemplate)this.templateList.get(i);
            String tempRegion = template.getRegion();
            if (tempRegion.equals("None")) continue;
            r = tempRegion;
        }
        return r;
    }

    public void setResidence(String aString) {
        this.residence = aString;
        this.setDirty(true);
    }

    public String getResidence() {
        return this.residence;
    }

    public List getSecondaryWeapons() {
        return this.secondaryWeapons;
    }

    public void setSelectedCharacterHTMLOutputSheet(String aString) {
        this.outputSheetHTML = aString;
    }

    public String getSelectedCharacterHTMLOutputSheet() {
        return this.outputSheetHTML;
    }

    public void setSelectedCharacterPDFOutputSheet(String aString) {
        this.outputSheetPDF = aString;
    }

    public String getSelectedCharacterPDFOutputSheet() {
        return this.outputSheetPDF;
    }

    public ArrayList getShieldProfList() {
        this.shieldProfList.clear();
        List autoShieldProfList = this.getAutoShieldProfList();
        this.addShieldProfs(autoShieldProfList);
        ArrayList selectedProfList = this.getSelectedShieldProfList();
        this.addShieldProfs(selectedProfList);
        return this.shieldProfList;
    }

    public String getSize() {
        SizeAdjustment sa = this.getSizeAdjustment();
        if (sa != null) {
            return sa.getAbbreviation();
        }
        return " ";
    }

    public ArrayList getSkillList() {
        return this.getAllSkillList(false);
    }

    public ArrayList getSkillListInOutputOrder() {
        ArrayList sortedList = (ArrayList)this.getSkillList().clone();
        Collections.sort(sortedList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                int obj1Index = ((Skill)obj1).getOutputIndex();
                int obj2Index = ((Skill)obj2).getOutputIndex();
                if (obj1Index == 0) {
                    obj1Index = 999;
                }
                if (obj2Index == 0) {
                    obj2Index = 999;
                }
                if (obj1Index > obj2Index) {
                    return 1;
                }
                if (obj1Index < obj2Index) {
                    return -1;
                }
                return ((Skill)obj1).getName().compareToIgnoreCase(((Skill)obj2).getName());
            }
        });
        Iterator i = sortedList.iterator();
        while (i.hasNext()) {
            Skill bSkill = (Skill)i.next();
            if (bSkill.getOutputIndex() != -1) continue;
            i.remove();
        }
        return sortedList;
    }

    public void setSkillPoints(int anInt) {
        this.skillPoints = anInt;
        this.setDirty(true);
    }

    public int getSkillPoints() {
        int returnValue = 0;
        Iterator e = this.getLevelInfo().iterator();
        while (e.hasNext()) {
            PCLevelInfo pcli = (PCLevelInfo)e.next();
            returnValue += pcli.getSkillPointsGained(this);
        }
        e = this.getSkillList().iterator();
        while (e.hasNext()) {
            Skill aSkill = (Skill)e.next();
            for (int idx = 0; idx < aSkill.getRankList().size(); ++idx) {
                String bSkill = (String)aSkill.getRankList().get(idx);
                int iOffs = bSkill.indexOf(58);
                double curRank = Double.parseDouble(bSkill.substring(iOffs + 1));
                PCClass pcClass = this.getClassKeyed(bSkill.substring(0, iOffs));
                if (pcClass == null) continue;
                double cost = aSkill.costForPCClass(pcClass, this).intValue();
                returnValue -= (int)(cost * curRank);
            }
        }
        return returnValue;
    }

    public void setSkinColor(String aString) {
        this.skinColor = aString;
        this.setDirty(true);
    }

    public String getSkinColor() {
        return this.skinColor;
    }

    public List getSpecialAbilityList() {
        List aList = (ArrayList)this.specialAbilityList.clone();
        int atl = this.getTotalLevels();
        int thd = this.totalHitDice();
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            PObject aPObj = (PObject)i.next();
            if (aPObj == null) continue;
            if (aPObj instanceof PCTemplate) {
                PCTemplate bTemplate = Globals.getTemplateNamed(aPObj.getName());
                if (bTemplate == null) continue;
                aList = bTemplate.addSpecialAbilitiesToList(aList, atl, thd);
                continue;
            }
            aList = aPObj.addSpecialAbilitiesToList(aList, this);
        }
        Collections.sort(aList);
        return aList;
    }

    public ArrayList getSpecialAbilityListStrings() {
        List aList = this.getSpecialAbilityList();
        ArrayList<String> bList = new ArrayList<String>();
        if (!aList.isEmpty()) {
            Iterator i = aList.iterator();
            while (i.hasNext()) {
                String saText;
                Object obj = i.next();
                SpecialAbility sa = (SpecialAbility)obj;
                if (!PrereqHandler.passesAll(sa.getPreReqList(), this, sa) || (saText = sa.getParsedText(this)) == null || saText.equals("")) continue;
                bList.add(saText);
            }
        }
        return bList;
    }

    public ArrayList getSpecialAbilityTimesList() {
        ArrayList abilityList = this.getSpecialAbilityListStrings();
        ArrayList<String> sortList = new ArrayList<String>();
        int[] numTimes = new int[abilityList.size()];
        for (int i = 0; i < abilityList.size(); ++i) {
            String ability = (String)abilityList.get(i);
            if (!sortList.contains(ability)) {
                sortList.add(ability);
                numTimes[i] = 1;
                continue;
            }
            for (int j = 0; j < sortList.size(); ++j) {
                String testAbility = (String)sortList.get(j);
                if (!testAbility.equals(ability)) continue;
                int n = j;
                numTimes[n] = numTimes[n] + 1;
            }
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < sortList.size(); ++i) {
            String ability = (String)sortList.get(i);
            if (numTimes[i] > 1) {
                ability = ability + " (" + numTimes[i] + ")";
            }
            retList.add(ability);
        }
        return retList;
    }

    public void setSpeechTendency(String aString) {
        this.speechTendency = aString;
        this.setDirty(true);
    }

    public String getSpeechTendency() {
        return this.speechTendency;
    }

    public List getSpellBooks() {
        return this.spellBooks;
    }

    public PObject getSpellClassAtIndex(int ix) {
        List aList = this.getSpellClassList();
        if (ix >= 0 && ix < aList.size()) {
            return (PObject)aList.get(ix);
        }
        return null;
    }

    public void setSpellLevelTemp(int i) {
        this.spellLevelTemp = i;
    }

    public int getSpellLevelTemp() {
        return this.spellLevelTemp;
    }

    public StatList getStatList() {
        return this.statList;
    }

    public String getSubRace() {
        String subRace = "None";
        int x = this.templateList.size();
        for (int i = 0; i < x; ++i) {
            PCTemplate template = (PCTemplate)this.templateList.get(i);
            String tempSubRace = template.getSubRace();
            if (tempSubRace.equals("None")) continue;
            subRace = tempSubRace;
        }
        return subRace;
    }

    public String getSubRegion() {
        return this.getSubRegion(true);
    }

    public void setTabName(String aString) {
        this.tabName = aString;
        this.setDirty(true);
        this.setChanged();
        this.notifyObservers("TabName");
    }

    public String getTabName() {
        return this.tabName;
    }

    public List getTempBonusItemList() {
        return this.tempBonusItemList;
    }

    public void setTempBonusList(List aList) {
        this.tempBonusList = aList;
        this.setDirty(true);
    }

    public List getTempBonusList() {
        return this.tempBonusList;
    }

    public List getTempBonusList(String aCreator, String aTarget) {
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator i = this.getTempBonusList().iterator();
        while (i.hasNext()) {
            BonusObj aBonus = (BonusObj)i.next();
            Object aTO = aBonus.getTargetObject();
            Object aCO = aBonus.getCreatorObject();
            String targetName = "";
            String creatorName = "";
            if (aCO instanceof PObject) {
                creatorName = ((PObject)aCO).getName();
            }
            if (aTO instanceof PlayerCharacter) {
                targetName = this.getName();
            } else if (aTO instanceof PObject) {
                targetName = ((PObject)aTO).getName();
            }
            if (!creatorName.equals(aCreator) || !targetName.equals(aTarget)) continue;
            aList.add(aBonus);
        }
        return aList;
    }

    public ArrayList getTemplateList() {
        return this.templateList;
    }

    public PCTemplate getTemplateNamed(String aName) {
        Iterator ti = this.templateList.iterator();
        while (ti.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)ti.next();
            if (!aTemplate.getName().equalsIgnoreCase(aName)) continue;
            return aTemplate;
        }
        return null;
    }

    public void setTrait1(String aString) {
        this.trait1 = aString;
        this.setDirty(true);
    }

    public String getTrait1() {
        return this.trait1;
    }

    public void setTrait2(String aString) {
        this.trait2 = aString;
        this.setDirty(true);
    }

    public String getTrait2() {
        return this.trait2;
    }

    public double getUsedFeatCount() {
        double iCount = 0.0;
        if (!this.featList.isEmpty()) {
            Iterator e = this.featList.iterator();
            while (e.hasNext()) {
                Feat aFeat = (Feat)e.next();
                int subfeatCount = aFeat.getAssociatedCount();
                if (subfeatCount > 1) {
                    iCount += (double)subfeatCount;
                    continue;
                }
                iCount += aFeat.getCost(this);
            }
        }
        return iCount;
    }

    public Float getVariable(String variableString, boolean isMax, boolean includeBonus, String matchSrc, String matchSubSrc) {
        return this.getVariable(variableString, isMax, includeBonus, matchSrc, matchSubSrc, true);
    }

    private double getMinMaxFirstValue(boolean isNewValue, boolean isMax, double oldValue, double newValue) {
        if (!isNewValue) {
            return newValue;
        }
        if (isMax) {
            return Math.max(oldValue, newValue);
        }
        return Math.min(oldValue, newValue);
    }

    public Float getVariable(String variableString, boolean isMax, boolean includeBonus, String matchSrc, String matchSubSrc, boolean recurse) {
        String aString;
        String aString2;
        String varInList;
        Object obj;
        Iterator oi;
        Iterator e;
        double value = 0.0;
        boolean found = false;
        if (lastVariable != null && lastVariable.equals(variableString)) {
            Logging.errorPrint("This is a deliberate warning message, not an error - Avoiding infinite loop in getVariable: repeated lookup of \"" + lastVariable + "\" at " + value);
            lastVariable = null;
            return new Float(value);
        }
        if (!this.variableList.isEmpty()) {
            e = this.variableList.iterator();
            while (e.hasNext()) {
                String nString;
                String vString = (String)e.next();
                StringTokenizer aTok = new StringTokenizer(vString, "|");
                String src = aTok.nextToken();
                if (matchSrc.length() > 0 && !src.equals(matchSrc)) continue;
                String subSrc = aTok.nextToken();
                if (matchSubSrc.length() > 0 && !subSrc.equals(matchSubSrc) || !(nString = aTok.nextToken()).equalsIgnoreCase(variableString)) continue;
                String sString = aTok.nextToken();
                double newValue = this.getVariableValue(sString, src).doubleValue();
                value = this.getMinMaxFirstValue(found, isMax, value, newValue);
                found = true;
                if ("".equals(loopVariable)) continue;
                while (loopValue > decrement) {
                    loopValue -= decrement;
                    value += this.getVariableValue(sString, src).doubleValue();
                }
                loopValue = 0;
                loopVariable = "";
            }
        }
        if (!this.aggregateFeatList().isEmpty()) {
            oi = this.aggregateFeatList().iterator();
            while (oi.hasNext()) {
                obj = (Feat)oi.next();
                varInList = this.checkForVariableInList((PObject)obj, variableString, isMax, "", "", found, value);
                if (varInList.length() <= 0) continue;
                value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(varInList));
                found = true;
            }
        }
        if (!this.getSkillList().isEmpty()) {
            oi = this.getSkillList().iterator();
            while (oi.hasNext()) {
                obj = (Skill)oi.next();
                varInList = this.checkForVariableInList((PObject)obj, variableString, isMax, "", "", found, value);
                if (varInList.length() <= 0) continue;
                value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(varInList));
                found = true;
            }
        }
        if (!this.equipmentList.isEmpty()) {
            oi = this.equipmentList.iterator();
            while (oi.hasNext()) {
                List aList2;
                List aList;
                obj = (Equipment)oi.next();
                String eS = this.checkForVariableInList((PObject)obj, variableString, isMax, "", "", found, value);
                if (eS.length() > 0) {
                    value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(eS));
                    found = true;
                }
                if (!(aList = ((Equipment)obj).getEqModifierList(true)).isEmpty()) {
                    Iterator el = aList.iterator();
                    while (el.hasNext()) {
                        EquipmentModifier em = (EquipmentModifier)el.next();
                        String varInList2 = this.checkForVariableInList(em, variableString, isMax, "", "", found, value);
                        if (varInList2.length() <= 0) continue;
                        value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(varInList2));
                        found = true;
                    }
                }
                if ((aList2 = ((Equipment)obj).getEqModifierList(false)).isEmpty()) continue;
                Iterator el = aList2.iterator();
                while (el.hasNext()) {
                    EquipmentModifier em = (EquipmentModifier)el.next();
                    String varInList3 = this.checkForVariableInList(em, variableString, isMax, "", "", found, value);
                    if (varInList3.length() <= 0) continue;
                    value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(varInList3));
                    found = true;
                }
            }
        }
        if (!this.templateList.isEmpty()) {
            oi = this.templateList.iterator();
            while (oi.hasNext()) {
                obj = (PCTemplate)oi.next();
                aString2 = this.checkForVariableInList((PObject)obj, variableString, isMax, "", "", found, value);
                if (aString2.length() <= 0) continue;
                value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(aString2));
                found = true;
            }
        }
        if (!this.companionModList.isEmpty()) {
            oi = this.companionModList.iterator();
            while (oi.hasNext()) {
                obj = (CompanionMod)oi.next();
                aString2 = this.checkForVariableInList((PObject)obj, variableString, isMax, "", "", found, value);
                if (aString2.length() <= 0) continue;
                value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(aString2));
                found = true;
            }
        }
        if (this.race != null && (aString = this.checkForVariableInList(this.race, variableString, isMax, "", "", found, value)).length() > 0) {
            value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(aString));
            found = true;
        }
        if (this.deity != null && (aString = this.checkForVariableInList(this.deity, variableString, isMax, "", "", found, value)).length() > 0) {
            value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(aString));
            found = true;
        }
        if (!this.characterDomainList.isEmpty()) {
            oi = this.characterDomainList.iterator();
            while (oi.hasNext()) {
                obj = (CharacterDomain)oi.next();
                if (((CharacterDomain)obj).getDomain() == null || (aString2 = this.checkForVariableInList(((CharacterDomain)obj).getDomain(), variableString, isMax, "", "", found, value)).length() <= 0) continue;
                value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(aString2));
                found = true;
            }
        }
        if (!this.weaponProfList.isEmpty()) {
            oi = this.weaponProfList.iterator();
            while (oi.hasNext()) {
                obj = Globals.getWeaponProfNamed((String)oi.next());
                if (obj == null || (aString2 = this.checkForVariableInList((PObject)obj, variableString, isMax, "", "", found, value)).length() <= 0) continue;
                value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(aString2));
                found = true;
            }
        }
        e = this.statList.getStats().iterator();
        while (e.hasNext()) {
            obj = (PCStat)e.next();
            aString2 = this.checkForVariableInList((PObject)obj, variableString, isMax, "", "", found, value);
            if (aString2.length() <= 0) continue;
            value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(aString2));
            found = true;
        }
        e = SettingsHandler.getGame().getUnmodifiableAlignmentList().iterator();
        while (e.hasNext()) {
            obj = (PCAlignment)e.next();
            aString2 = this.checkForVariableInList((PObject)obj, variableString, isMax, "", "", found, value);
            if (aString2.length() <= 0) continue;
            value = this.getMinMaxFirstValue(found, isMax, value, Float.parseFloat(aString2));
            found = true;
        }
        if (!found) {
            if (recurse) {
                lastVariable = variableString;
                value = this.getVariableValue(variableString, "").floatValue();
                includeBonus = false;
                found = true;
                lastVariable = null;
            } else {
                return null;
            }
        }
        if (found && includeBonus) {
            value += this.getTotalBonusTo("VAR", variableString);
        }
        return new Float(value);
    }

    public void setVirtualFeatsStable(boolean stable) {
        this.virtualFeatsStable = stable;
    }

    public TreeSet getWeaponProfList() {
        TreeSet wp = new TreeSet(this.weaponProfList);
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            PObject aPObj = (PObject)i.next();
            if (aPObj == null) continue;
            aPObj.addSelectedWeaponProfBonusTo(wp);
        }
        return wp;
    }

    public void setWeight(double i) {
        this.weightInPounds = Globals.convertWeightFromUnitSet(i);
        this.setDirty(true);
    }

    public double getWeight() {
        return Globals.convertWeightToUnitSet(this.weightInPounds);
    }

    public void setWeightInPounds(int i) {
        this.weightInPounds = i;
        this.setDirty(true);
    }

    public int getWeightInPounds() {
        return this.weightInPounds;
    }

    public void setXP(int xp) {
        int realXP = xp - this.getLAXP();
        if (realXP < 0) {
            Logging.errorPrint("ERROR: too little experience: " + realXP);
            realXP = 0;
        }
        this.setEarnedXP(realXP);
    }

    public int getXP() {
        return this.earnedXP + this.getLAXP();
    }

    public void addArmorProf(String aProf) {
        if (!this.armorProfList.contains(aProf)) {
            if (aProf.startsWith("TYPE=") || aProf.startsWith("TYPE.")) {
                this.armorProfList.add(0, aProf);
            } else {
                this.armorProfList.add(aProf);
            }
        }
        this.setDirty(true);
    }

    public void addArmorProfs(List aList) {
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            this.addArmorProf((String)i.next());
        }
    }

    public void addEquipSet(EquipSet set) {
        this.equipSetList.add(set);
        this.setDirty(true);
    }

    public void addEquipment(Equipment eq) {
        this.equipmentList.add(eq);
        if (!this.equipmentMasterList.contains(eq)) {
            this.equipmentMasterList.add(eq);
        }
        this.setDirty(true);
    }

    public void addFeat(Feat aFeat) {
        if (this.featList.contains(aFeat)) {
            Logging.errorPrint("Adding duplicate feat: " + aFeat.getName());
        }
        this.featList.add(aFeat);
        this.addNaturalWeapons(aFeat.getNaturalWeapons());
        this.setAggregateFeatsStable(false);
    }

    public void addFollower(Follower aFollower) {
        this.followerList.add(aFollower);
        this.setDirty(true);
    }

    public void addLocalEquipment(Equipment eq) {
        this.equipmentList.add(eq);
    }

    public void addNotesItem(NoteItem item) {
        this.notesList.add(item);
        this.setDirty(true);
    }

    public void addTempBonus(BonusObj aBonus) {
        this.getTempBonusList().add(aBonus);
        this.setDirty(true);
    }

    public void addTempBonusItemList(Equipment aEq) {
        this.getTempBonusItemList().add(aEq);
        this.setDirty(true);
    }

    public double calcBonusFromList(List aList) {
        double iBonus = 0.0;
        if (aList.isEmpty()) {
            return iBonus;
        }
        Iterator b = aList.iterator();
        while (b.hasNext()) {
            BonusObj aBonus = (BonusObj)b.next();
            PObject anObj = (PObject)aBonus.getCreatorObject();
            if (anObj == null) continue;
            iBonus += anObj.calcBonusFrom(aBonus, this);
        }
        return iBonus;
    }

    public void calcSizeAdjustmentBonuses() {
        this.activateAndAddBonusesFromPObject(this.getSizeAdjustment());
    }

    public void calcStatBonuses() {
        this.activateAndAddBonusesFromPObjectList(this.statList.getStats());
    }

    public boolean checkQualifyList(String qualifierItem) {
        return this.getQualifyList().contains(qualifierItem);
    }

    public int handsRequired(Equipment eq, WeaponProf wp) {
        if (!this.hasWeaponProfNamed(wp.getName())) {
            return 2;
        }
        return Globals.handsRequired(this, eq, wp);
    }

    public boolean hasWeaponProfNamed(String aName) {
        Iterator i = this.getWeaponProfList().iterator();
        while (i.hasNext()) {
            if (!aName.equalsIgnoreCase((String)i.next())) continue;
            return true;
        }
        return false;
    }

    public static BigDecimal maxClassSkillForLevel(int level, PlayerCharacter pc) {
        LevelInfo lInfo = (LevelInfo)Globals.getLevelInfo().get(String.valueOf(level));
        if (lInfo == null) {
            lInfo = (LevelInfo)Globals.getLevelInfo().get("LEVEL");
        }
        if (level > 0 && lInfo != null) {
            return lInfo.getMaxClassSkillRank(level, pc);
        }
        return BigDecimalHelper.ZERO;
    }

    public static BigDecimal maxCrossClassSkillForLevel(int level, PlayerCharacter pc) {
        LevelInfo lInfo = (LevelInfo)Globals.getLevelInfo().get(String.valueOf(level));
        if (lInfo == null) {
            lInfo = (LevelInfo)Globals.getLevelInfo().get("LEVEL");
        }
        if (level > 0 && lInfo != null) {
            return lInfo.getMaxCrossClassSkillRank(level, pc);
        }
        return BigDecimalHelper.ZERO;
    }

    public static List mergeEquipmentList(List aList, int merge) {
        Equipment eq1;
        Collections.sort(aList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                int e1 = ((Equipment)obj1).getOutputIndex();
                int obj2Index = ((Equipment)obj2).getOutputIndex();
                if (e1 == 0) {
                    e1 = 999;
                }
                if (obj2Index == 0) {
                    obj2Index = 999;
                }
                if (e1 > obj2Index) {
                    return 1;
                }
                if (e1 < obj2Index) {
                    return -1;
                }
                if (((Equipment)obj1).getName().compareToIgnoreCase(((Equipment)obj2).getName()) == 0) {
                    return ((Equipment)obj1).getParentName().compareToIgnoreCase(((Equipment)obj2).getParentName());
                }
                return ((Equipment)obj1).getName().compareToIgnoreCase(((Equipment)obj2).getName());
            }

            public boolean equals(Object obj) {
                return false;
            }

            public int hashCode() {
                return 0;
            }
        });
        if (merge == 1) {
            return aList;
        }
        ArrayList<Equipment> eq1List = new ArrayList<Equipment>();
        ArrayList<Equipment> eq2List = new ArrayList<Equipment>();
        ArrayList<Equipment> mergeList = new ArrayList<Equipment>();
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            Equipment tempEquip = (Equipment)e.next();
            Equipment eq = (Equipment)tempEquip.clone();
            eq1List.add(eq);
            eq2List.add(eq);
        }
        if (merge == 2) {
            e = eq1List.iterator();
            while (e.hasNext()) {
                eq1 = (Equipment)e.next();
                double eQty = eq1.qty();
                boolean found = false;
                for (int i = 0; i < eq2List.size(); ++i) {
                    Equipment eq2 = (Equipment)eq2List.get(i);
                    if (eq1 == eq2) {
                        eq2List.remove(eq2);
                        found = true;
                        --i;
                        continue;
                    }
                    if (eq1.isContainer() || eq1.isType("TEMPORARY") || eq2.isType("TEMPORARY") || !eq1.getName().equals(eq2.getName()) || eq1.getLocation() != eq2.getLocation() || !eq1.getParentName().equals(eq2.getParentName())) continue;
                    eq2List.remove(eq2);
                    eQty += eq2.qty();
                    found = true;
                    --i;
                }
                if (!found) continue;
                eq1.setQty(eQty);
                mergeList.add(eq1);
            }
            return mergeList;
        }
        if (merge == 0) {
            Iterator e1 = eq1List.iterator();
            while (e1.hasNext()) {
                eq1 = (Equipment)e1.next();
                double eQty = 0.0;
                boolean found = false;
                for (int i = 0; i < eq2List.size(); ++i) {
                    Equipment eq2 = (Equipment)eq2List.get(i);
                    if (!eq1.getName().equals(eq2.getName())) continue;
                    if (eq1.isContainer()) {
                        found = true;
                        continue;
                    }
                    if (eq1.isType("TEMPORARY") || eq2.isType("TEMPORARY")) {
                        found = true;
                        continue;
                    }
                    eq2List.remove(eq2);
                    eQty += eq2.qty();
                    found = true;
                    --i;
                }
                if (eQty <= 0.0) {
                    eQty = eq1.qty();
                }
                if (!found) continue;
                eq1.setQty(eQty);
                mergeList.add(eq1);
            }
            return mergeList;
        }
        return null;
    }

    public Equipment getEquipmentNamed(String aString) {
        return this.getEquipmentNamed(aString, this.getEquipmentMasterList());
    }

    public ArrayList getMiscList() {
        return this.miscList;
    }

    public void buildVariableSet() {
        this.variableSet.clear();
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            PObject aPObj = (PObject)i.next();
            if (aPObj == null) continue;
            this.variableSet.addAll(aPObj.getVariableNamesAsUnmodifiableSet());
        }
    }

    public boolean delEquipSet(EquipSet eSet) {
        if (this.equipSetList.isEmpty()) {
            return false;
        }
        boolean found = false;
        String pid = eSet.getIdPath();
        this.equipSetList.remove(eSet);
        Iterator e = this.equipSetList.iterator();
        while (e.hasNext()) {
            String abPid;
            EquipSet es = (EquipSet)e.next();
            String abParentId = es.getParentIdPath() + ".";
            if (!abParentId.startsWith(abPid = pid + ".")) continue;
            e.remove();
            found = true;
        }
        this.setDirty(true);
        return found;
    }

    public void delEquipSetItem(Equipment eq) {
        EquipSet es;
        if (this.equipSetList.isEmpty()) {
            return;
        }
        ArrayList<EquipSet> tmpList = new ArrayList<EquipSet>();
        Iterator eSet = this.equipSetList.iterator();
        while (eSet.hasNext()) {
            es = (EquipSet)eSet.next();
            Equipment eqI = es.getItem();
            if (eqI == null || !eq.equals(eqI)) continue;
            tmpList.add(es);
        }
        eSet = tmpList.iterator();
        while (eSet.hasNext()) {
            es = (EquipSet)eSet.next();
            this.delEquipSet(es);
        }
        this.setDirty(true);
    }

    public void delFollower(Follower aFollower) {
        this.followerList.remove(aFollower);
        this.setDirty(true);
    }

    public void equipmentListAddAll(List aList) {
        if (aList.isEmpty()) {
            return;
        }
        this.equipmentList.addAll(aList);
        this.equipmentMasterList.addAll(aList);
        this.setDirty(true);
    }

    public boolean hasVariable(String variableString) {
        if (!this.variableList.isEmpty()) {
            Iterator e = this.variableList.iterator();
            while (e.hasNext()) {
                StringTokenizer aTok = new StringTokenizer((String)e.next(), "|");
                aTok.nextToken();
                aTok.nextToken();
                if (!aTok.nextToken().equalsIgnoreCase(variableString)) continue;
                return true;
            }
        }
        if (Globals.hasWeaponProfVariableNamed(this.weaponProfList, variableString)) {
            return true;
        }
        return this.variableSet.contains(variableString.toUpperCase());
    }

    private void putActiveBonusMap(String aKey, String aVal) {
        this.activeBonusMap.put(aKey, aVal);
    }

    public int racialSizeInt() {
        int iSize = 0;
        if (this.race != null) {
            iSize = Globals.sizeInt(this.race.getSize());
            if (!this.templateList.isEmpty()) {
                Iterator e = this.getTemplateList().iterator();
                while (e.hasNext()) {
                    PCTemplate template = (PCTemplate)e.next();
                    String templateSize = template.getTemplateSize();
                    if (templateSize.length() == 0) continue;
                    iSize = Globals.sizeInt(templateSize);
                }
            }
        }
        return iSize;
    }

    public void removeActiveBonus(BonusObj aBonus) {
        this.activeBonusList.remove(aBonus);
    }

    public static List removeEqType(List aList, String aString) {
        ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
        Iterator mapIter = aList.iterator();
        while (mapIter.hasNext()) {
            Equipment eq = (Equipment)mapIter.next();
            if (aString.equalsIgnoreCase("CONTAINED") && eq.getParent() != null || eq.typeStringContains(aString)) continue;
            aArrayList.add(eq);
        }
        return aArrayList;
    }

    public void removeEquipment(Equipment eq) {
        this.equipmentList.remove(eq);
        this.equipmentMasterList.remove(eq);
        this.setDirty(true);
    }

    public void removeLocalEquipment(Equipment eq) {
        this.equipmentList.remove(eq);
        this.setDirty(true);
    }

    public static List removeNotEqType(List aList, String aString) {
        ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
        Iterator mapIter = aList.iterator();
        while (mapIter.hasNext()) {
            Equipment eq = (Equipment)mapIter.next();
            if (!eq.typeStringContains(aString)) continue;
            aArrayList.add(eq);
        }
        return aArrayList;
    }

    public int getACTotal() {
        return this.calcACOfType("Total");
    }

    public void setAlignment(int index, boolean bLoading) {
        this.setAlignment(index, bLoading, false);
    }

    public void setAlignment(int index, boolean bLoading, boolean bForce) {
        if (bForce || this.race.canBeAlignment(Integer.toString(index))) {
            this.alignment = index;
        } else if (bLoading && index != SettingsHandler.getGame().getIndexOfAlignment("None")) {
            ShowMessageDelegate.showMessageDialog("Invalid alignment. Setting to <none selected>", "PCGen", MessageType.INFORMATION);
            this.alignment = SettingsHandler.getGame().getIndexOfAlignment("None");
        }
        this.setDirty(true);
    }

    public String getAttackString(int index) {
        return this.getAttackString(index, 0);
    }

    public String getAttackString(int index, int bonus) {
        int i;
        String cacheLookup = "AttackString:" + index + "," + bonus;
        String cached = this.getCachedString(cacheLookup);
        if (cached != null) {
            return cached;
        }
        int masterBAB = -9999;
        int masterTotal = -9999;
        PlayerCharacter nPC = this.getMasterPC();
        int totalClassLevels = this.getTotalClassLevels();
        HashMap totalLvlMap = null;
        Map classLvlMap = null;
        if (totalClassLevels > SettingsHandler.getGame().getBabMaxLvl()) {
            totalLvlMap = this.getTotalLevelHashMap();
            classLvlMap = this.getLevelHashMap(SettingsHandler.getGame().getBabMaxLvl());
            this.pauseCache();
            this.setClassLevelsBrazenlyTo(classLvlMap);
        }
        if (nPC != null && this.getCopyMasterBAB().length() > 0) {
            masterBAB = nPC.baseAttackBonus();
            String copyMasterBAB = this.replaceMasterString(this.getCopyMasterBAB(), masterBAB);
            masterBAB = this.getVariableValue(copyMasterBAB, "").intValue();
            masterTotal = masterBAB + bonus;
        }
        int BAB = this.baseAttackBonus();
        int bonusBAB = bonus + this.baseAttackBonus();
        ArrayList<Integer> ab = new ArrayList<Integer>(10);
        int attackCycle = 1;
        int mod = bonusBAB;
        int subTotal = BAB;
        int raceBAB = this.getRace().getBAB(this);
        StringBuffer attackString = new StringBuffer();
        for (int total = 0; total < 10; ++total) {
            ab.add(new Integer(0));
        }
        for (i = 0; i < this.classList.size(); ++i) {
            PCClass aClass = (PCClass)this.classList.get(i);
            int b = aClass.baseAttackBonus(this);
            int c = aClass.attackCycle(index);
            int d = (Integer)ab.get(c) + b;
            ab.set(c, new Integer(d));
            if (c == 3) continue;
            raceBAB += b;
        }
        for (i = 2; i < 10; ++i) {
            int oldAttack;
            int newAttack = (Integer)ab.get(i);
            if (newAttack / i <= (oldAttack = ((Integer)ab.get(attackCycle)).intValue()) / attackCycle) continue;
            attackCycle = i;
        }
        if (totalLvlMap != null) {
            this.setClassLevelsBrazenlyTo(totalLvlMap);
            this.restartCache();
        }
        int attackTotal = (Integer)ab.get(attackCycle);
        int defaultAttackCycle = SettingsHandler.getGame().getBabAttCyc();
        if (attackTotal == 0) {
            attackCycle = defaultAttackCycle;
        }
        mod = Math.max(mod, masterTotal);
        subTotal = Math.max(subTotal, masterBAB);
        raceBAB = Math.max(raceBAB, masterBAB);
        if (attackCycle != defaultAttackCycle) {
            if (attackTotal / attackCycle < subTotal / defaultAttackCycle) {
                attackCycle = defaultAttackCycle;
                attackTotal = subTotal;
            } else {
                mod -= raceBAB;
                subTotal -= raceBAB;
            }
        }
        int maxAttacks = SettingsHandler.getGame().getBabMaxAtt();
        int minMultiBab = SettingsHandler.getGame().getBabMinVal();
        do {
            if (attackString.length() > 0) {
                attackString.append('/');
            }
            attackString.append(Delta.toString(mod));
            mod -= attackCycle;
        } while (((attackTotal -= attackCycle) >= minMultiBab || (subTotal -= attackCycle) >= minMultiBab) && --maxAttacks > 0);
        this.addCachedString(cacheLookup, attackString.toString());
        return attackString.toString();
    }

    private void restartCache() {
        this.serial = this.cachePaused;
        this.cachePaused = 0;
    }

    private void pauseCache() {
        this.cachePaused = this.serial;
    }

    private boolean isCachePaused() {
        return this.cachePaused > 0;
    }

    public SortedSet getAutoLanguages() {
        boolean clearRacials = false;
        TreeSet<Language> autoLangs = new TreeSet<Language>();
        Iterator e = this.templateAutoLanguages.iterator();
        while (e.hasNext()) {
            Language aLang = (Language)e.next();
            String aString = aLang.toString();
            if (".CLEARRACIAL".equals(aString)) {
                clearRacials = true;
                this.getLanguagesList().removeAll(this.getRace().getAutoLanguages());
                continue;
            }
            if (".CLEARALL".equals(aString) || ".CLEAR".equals(aString)) {
                clearRacials = true;
                autoLangs.clear();
                this.getLanguagesList().clear();
                continue;
            }
            if (".CLEARTEMPLATES".equals(aString)) {
                autoLangs.clear();
                this.getLanguagesList().removeAll(this.templateAutoLanguages);
                continue;
            }
            autoLangs.add(aLang);
        }
        if (!clearRacials) {
            autoLangs.addAll(this.getRace().getAutoLanguages());
        }
        e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            autoLangs.addAll(aClass.getAutoLanguages());
        }
        if (this.deity != null) {
            autoLangs.addAll(this.deity.getAutoLanguages());
        }
        Iterator i = this.featList.iterator();
        while (i.hasNext()) {
            Feat aFeat = (Feat)i.next();
            autoLangs.addAll(aFeat.getAutoLanguages());
        }
        i = this.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            autoLangs.addAll(aSkill.getAutoLanguages());
        }
        i = this.characterDomainList.iterator();
        while (i.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)i.next();
            if (aCD.getDomain() == null) continue;
            autoLangs.addAll(aCD.getDomain().getAutoLanguages());
        }
        e = this.equipmentList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            autoLangs.addAll(eq.getAutoLanguages());
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    autoLangs.addAll(eqMod.getAutoLanguages());
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                autoLangs.addAll(eqMod.getAutoLanguages());
            }
        }
        if (this.getKitInfo() != null) {
            e = this.getKitInfo().iterator();
            while (e.hasNext()) {
                Kit kit = (Kit)e.next();
                autoLangs.addAll(kit.getAutoLanguages());
            }
        }
        this.getLanguagesList().addAll(autoLangs);
        return autoLangs;
    }

    public void setAutoSortGear(boolean autoSortGear) {
        this.autoSortGear = autoSortGear;
        this.setDirty(true);
    }

    public boolean isAutoSortGear() {
        return this.autoSortGear;
    }

    public void setAutoSpells(boolean aBool) {
        this.autoKnownSpells = aBool;
        this.setDirty(true);
    }

    public boolean getAutoSpells() {
        return this.autoKnownSpells;
    }

    public double getBonus(int type, boolean addBonuses) {
        String cacheLookup = "getBonus:" + type + "," + addBonuses;
        Float total = this.getCachedVariable(cacheLookup);
        if (total != null) {
            return total.doubleValue();
        }
        double bonus = 0.0;
        int totalClassLevels = 0;
        HashMap totalLvlMap = null;
        Map classLvlMap = null;
        if (type == 0) {
            bonus = this.race.getBAB(this);
        } else if (type <= SettingsHandler.getGame().getUnmodifiableCheckList().size()) {
            totalClassLevels = this.getTotalClassLevels();
            if (totalClassLevels > SettingsHandler.getGame().getChecksMaxLvl()) {
                totalLvlMap = this.getTotalLevelHashMap();
                classLvlMap = this.getLevelHashMap(SettingsHandler.getGame().getChecksMaxLvl());
                this.pauseCache();
                this.setClassLevelsBrazenlyTo(classLvlMap);
            }
            bonus = this.getTotalBonusTo("CHECKS", "BASE." + SettingsHandler.getGame().getUnmodifiableCheckList().get(type - 1).toString());
            PlayerCharacter nPC = this.getMasterPC();
            if (nPC != null && this.getCopyMasterCheck().length() > 0) {
                int masterBonus = 0;
                PlayerCharacter curPC = this;
                Globals.setCurrentPC(nPC);
                masterBonus = nPC.calculateSaveBonus(type, SettingsHandler.getGame().getUnmodifiableCheckList().get(type - 1).toString(), "BASE");
                Globals.setCurrentPC(curPC);
                String copyMasterCheck = this.replaceMasterString(this.getCopyMasterCheck(), masterBonus);
                masterBonus = this.getVariableValue(copyMasterCheck, "").intValue();
                bonus = Math.max(bonus, (double)masterBonus);
            }
            if (totalLvlMap != null) {
                this.setClassLevelsBrazenlyTo(totalLvlMap);
                this.restartCache();
            }
        }
        if (addBonuses) {
            if (type == 0) {
                bonus += this.getTotalBonusTo("TOHIT", "TOHIT");
                bonus += this.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
            } else {
                bonus = type <= SettingsHandler.getGame().getUnmodifiableCheckList().size() ? (bonus += this.getTotalBonusTo("CHECKS", SettingsHandler.getGame().getUnmodifiableCheckList().get(type - 1).toString())) : (bonus += this.getSizeAdjustmentBonusTo("TOHIT", "TOHIT"));
            }
        }
        int cBonus = 0;
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            if (type != 0 && type <= SettingsHandler.getGame().getUnmodifiableCheckList().size()) continue;
            cBonus += aClass.baseAttackBonus(this);
        }
        this.addCachedVariable(cacheLookup, new Float(bonus += (double)cBonus));
        return bonus;
    }

    public double getBonusDueToType(String mainType, String subType, String bonusType) {
        String typeString = mainType + "." + subType + ":" + bonusType;
        return this.sumActiveBonusMap(typeString);
    }

    public double getBonusFeatsForNewLevel(PCClass newLevelClass) {
        double bonusFeats = 0.0;
        Integer lpf = newLevelClass.getLevelsPerFeat();
        if (lpf != null && lpf >= 0) {
            int calculatedLevel = 0;
            if (this.getRace() != null && this.isMonsterDefault()) {
                calculatedLevel += this.getRace().getMonsterClassLevels(this);
            }
            calculatedLevel += newLevelClass.getLevel();
            int levelsPerFeat = lpf;
            if (levelsPerFeat > 0) {
                bonusFeats = calculatedLevel % levelsPerFeat == 0 ? 1.0 : 0.0;
            }
        } else {
            int nonSpecificLevels = 0;
            if (this.getRace() != null && this.isMonsterDefault()) {
                nonSpecificLevels += this.getRace().getMonsterClassLevels(this);
            }
            Iterator iter = this.classList.iterator();
            while (iter.hasNext()) {
                PCClass characterClass = (PCClass)iter.next();
                Integer levelsPerFeatForClass = characterClass.getLevelsPerFeat();
                if (levelsPerFeatForClass != null && levelsPerFeatForClass >= 0) continue;
                nonSpecificLevels += characterClass.getLevel();
            }
            bonusFeats = Globals.getBonusFeatsForLevel(nonSpecificLevels);
        }
        return bonusFeats;
    }

    public List getChangeProfList() {
        LinkedList aList = new LinkedList();
        if (this.getRace() != null) {
            aList.addAll(this.getRace().getChangeProfList(this));
        }
        if (this.getDeity() != null) {
            aList.addAll(this.getDeity().getChangeProfList(this));
        }
        Iterator e = this.getTemplateList().iterator();
        while (e.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)e.next();
            aList.addAll(aTemplate.getChangeProfList(this));
        }
        e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            aList.addAll(aClass.getChangeProfList(this));
        }
        e = this.aggregateFeatList().iterator();
        while (e.hasNext()) {
            Feat aFeat = (Feat)e.next();
            aList.addAll(aFeat.getChangeProfList(this));
        }
        e = this.getSkillList().iterator();
        while (e.hasNext()) {
            Skill aSkill = (Skill)e.next();
            aList.addAll(aSkill.getChangeProfList(this));
        }
        e = this.equipmentList.iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            aList.addAll(eq.getChangeProfList(this));
            List eqmList = eq.getEqModifierList(true);
            if (eqmList.isEmpty()) continue;
            Iterator e2 = eqmList.iterator();
            while (e2.hasNext()) {
                EquipmentModifier eqMod = (EquipmentModifier)e2.next();
                aList.addAll(eqMod.getChangeProfList(this));
            }
        }
        e = this.characterDomainList.iterator();
        while (e.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)e.next();
            Domain aDomain = aCD.getDomain();
            if (aDomain == null) continue;
            aList.addAll(aDomain.getChangeProfList(this));
        }
        return aList;
    }

    public CharacterDomain getCharacterDomainForDomain(String domainName) {
        for (int i = 0; i < this.characterDomainList.size(); ++i) {
            CharacterDomain aCD = (CharacterDomain)this.characterDomainList.get(i);
            Domain aDomain = aCD.getDomain();
            if (aDomain == null || !aDomain.getName().equalsIgnoreCase(domainName)) continue;
            return aCD;
        }
        return null;
    }

    public List getCharacterDomainList() {
        return this.characterDomainList;
    }

    public Domain getCharacterDomainNamed(String domainName) {
        for (int i = 0; i < this.characterDomainList.size(); ++i) {
            CharacterDomain aCD = (CharacterDomain)this.characterDomainList.get(i);
            Domain aDomain = aCD.getDomain();
            if (aDomain == null || !aDomain.getName().equalsIgnoreCase(domainName)) continue;
            return aCD.getDomain();
        }
        return null;
    }

    public int getCharacterDomainUsed() {
        return this.characterDomainList.size();
    }

    public List getCompanionModList() {
        return this.companionModList;
    }

    public String getCopyMasterBAB() {
        Iterator e = this.companionModList.iterator();
        while (e.hasNext()) {
            CompanionMod cMod = (CompanionMod)e.next();
            if (!cMod.getType().equalsIgnoreCase(this.getMaster().getType()) || cMod.getCopyMasterBAB() == null) continue;
            return cMod.getCopyMasterBAB();
        }
        return "";
    }

    public String getCopyMasterCheck() {
        Iterator e = this.companionModList.iterator();
        while (e.hasNext()) {
            CompanionMod cMod = (CompanionMod)e.next();
            if (!cMod.getType().equalsIgnoreCase(this.getMaster().getType()) || cMod.getCopyMasterCheck() == null) continue;
            return cMod.getCopyMasterCheck();
        }
        return "";
    }

    public String getCopyMasterHP() {
        Iterator e = this.companionModList.iterator();
        while (e.hasNext()) {
            CompanionMod cMod = (CompanionMod)e.next();
            if (!cMod.getType().equalsIgnoreCase(this.getMaster().getType()) || cMod.getCopyMasterHP() == null) continue;
            return cMod.getCopyMasterHP();
        }
        return "";
    }

    public void setCurrentHP(int currentHP) {
        this.currentHP = currentHP;
        this.setDirty(true);
    }

    public boolean setDeity(Deity aDeity) {
        if (!this.canSelectDeity(aDeity)) {
            return false;
        }
        this.deity = aDeity;
        if (!this.importing) {
            this.getSpellList();
            this.deity.globalChecks(this);
        }
        this.setDirty(true);
        this.calcActiveBonuses();
        return true;
    }

    public String getDomainSource(String className) {
        Iterator i = this.domainSourceMap.keySet().iterator();
        while (i.hasNext()) {
            String aKey = i.next().toString();
            String aVal = this.domainSourceMap.get(aKey).toString();
            int aNum = Integer.parseInt(aVal);
            if (className == null && aNum > 0) {
                return aKey;
            }
            if (aKey.indexOf(className) < 0) continue;
            return aKey;
        }
        return "";
    }

    public int getECL() {
        int totalLevels = 0;
        totalLevels += this.totalNonMonsterLevels();
        totalLevels += this.totalHitDice();
        return totalLevels += this.getLevelAdjustment(this);
    }

    public void setEquipOutputOrder(int i) {
        this.equipOutputOrder = i;
        this.setDirty(true);
    }

    public int getEquipOutputOrder() {
        return this.equipOutputOrder;
    }

    public List getEquipmentOfType(String typeName, int status) {
        return this.getEquipmentOfType(typeName, "", status);
    }

    public List getEquipmentOfType(String typeName, String subtypeName, int status) {
        ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
        if (this.equipmentList.isEmpty()) {
            return aArrayList;
        }
        Iterator e = this.equipmentList.iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!eq.typeStringContains(typeName) || !"".equals(subtypeName) && !eq.typeStringContains(subtypeName) || status != 3 && (status != 2 || eq.isEquipped()) && (status != 1 || !eq.isEquipped())) continue;
            aArrayList.add(eq);
        }
        return aArrayList;
    }

    public List getEquipmentOfTypeInOutputOrder(String typeName, int status) {
        return this.sortEquipmentList(this.getEquipmentOfType(typeName, status), 0);
    }

    public List getEquipmentOfTypeInOutputOrder(String typeName, int status, int merge) {
        return this.sortEquipmentList(this.getEquipmentOfType(typeName, status), merge);
    }

    public List getEquipmentOfTypeInOutputOrder(String typeName, String subtypeName, int status, int merge) {
        return this.sortEquipmentList(this.getEquipmentOfType(typeName, subtypeName, status), 0);
    }

    public List getExpandedWeapons(int merge) {
        List weapList = this.sortEquipmentList(this.getEquipmentOfType("Weapon", 3), merge);
        for (int idx = 0; idx < weapList.size(); ++idx) {
            Equipment teq;
            int iSecondary;
            Equipment teq2;
            int iPrimary;
            Equipment eqm;
            Equipment equip = (Equipment)weapList.get(idx);
            if (equip.isDouble() && equip.getLocation() == 4) {
                eqm = (Equipment)equip.clone();
                eqm.removeType("Double");
                eqm.setTypeInfo("Head1");
                eqm.setName(PlayerCharacter.appendToName(eqm.getName(), "Head 1 only"));
                if (eqm.getOutputName().indexOf("Head 1 only") < 0) {
                    eqm.setOutputName(PlayerCharacter.appendToName(eqm.getOutputName(), "Head 1 only"));
                }
                PlayerCharacter.setProf(equip, eqm);
                weapList.add(idx + 1, eqm);
                eqm = (Equipment)equip.clone();
                String altType = eqm.getType(false);
                if (altType.length() != 0) {
                    eqm.setTypeInfo(".CLEAR." + altType);
                }
                eqm.removeType("Double");
                eqm.setTypeInfo("Head2");
                eqm.setDamage(eqm.getAltDamage(this));
                eqm.setCritMult(eqm.getAltCritMult());
                eqm.setCritRange(Integer.toString(eqm.getRawCritRange(false)));
                eqm.getEqModifierList(true).clear();
                eqm.getEqModifierList(true).addAll(eqm.getEqModifierList(false));
                eqm.setName(PlayerCharacter.appendToName(eqm.getName(), "Head 2 only"));
                if (eqm.getOutputName().indexOf("Head 2 only") < 0) {
                    eqm.setOutputName(PlayerCharacter.appendToName(eqm.getOutputName(), "Head 2 only"));
                }
                PlayerCharacter.setProf(equip, eqm);
                weapList.add(idx + 2, eqm);
                continue;
            }
            if (!equip.isMelee() || !equip.isRanged() || equip.getRange(this) == 0) continue;
            eqm = (Equipment)equip.clone();
            eqm.setTypeInfo("Both");
            eqm.removeType("Ranged.Thrown");
            eqm.setRange("0");
            PlayerCharacter.setProf(equip, eqm);
            weapList.set(idx, eqm);
            for (iPrimary = this.getPrimaryWeapons().size() - 1; iPrimary >= 0 && !(teq2 = (Equipment)this.getPrimaryWeapons().get(iPrimary)).equalTo(equip); --iPrimary) {
            }
            if (iPrimary >= 0) {
                this.getPrimaryWeapons().set(iPrimary, eqm);
            }
            for (iSecondary = this.getSecondaryWeapons().size() - 1; iSecondary >= 0 && !(teq = (Equipment)this.getSecondaryWeapons().get(iSecondary)).equalTo(equip); --iSecondary) {
            }
            if (iSecondary >= 0) {
                this.getSecondaryWeapons().set(iSecondary, eqm);
            }
            eqm = (Equipment)equip.clone();
            eqm.setTypeInfo("Ranged.Thrown.Both");
            eqm.removeType("Melee");
            eqm.setName(PlayerCharacter.appendToName(eqm.getName(), "Thrown"));
            if (eqm.getOutputName().indexOf("Thrown") < 0) {
                eqm.setOutputName(PlayerCharacter.appendToName(eqm.getOutputName(), "Thrown"));
            }
            PlayerCharacter.setProf(equip, eqm);
            weapList.add(++idx, eqm);
            if (iPrimary >= 0) {
                this.getPrimaryWeapons().add(++iPrimary, eqm);
                continue;
            }
            if (iSecondary < 0) continue;
            this.getSecondaryWeapons().add(++iSecondary, eqm);
        }
        return weapList;
    }

    public SortedSet getFavoredClasses() {
        TreeSet<String> favored = new TreeSet<String>(this.favoredClasses);
        for (int i = 0; i < this.templateList.size(); ++i) {
            PCTemplate template = (PCTemplate)this.templateList.get(i);
            String favoredClass = template.getFavoredClass();
            if (favoredClass.length() == 0 || favored.contains(favoredClass)) continue;
            favored.add(favoredClass);
        }
        return favored;
    }

    public Feat getFeatAutomaticNamed(String featName) {
        return PlayerCharacter.getFeatNamedInList(this.featAutoList(), featName);
    }

    public double getFeatBonusTo(String aType, String aName, boolean subSearch) {
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        return this.getPObjectWithCostBonusTo(this.aggregateFeatList(), aType, aName, subSearch);
    }

    public Feat getFeatNamed(String featName) {
        return PlayerCharacter.getFeatNamedInList(this.aggregateFeatList(), featName);
    }

    public Feat getFeatNamed(String featName, int featType) {
        return PlayerCharacter.getFeatNamedInList(this.aggregateFeatList(), featName, featType);
    }

    public static Feat getFeatNamedInList(List aFeatList, String featName) {
        return PlayerCharacter.getFeatNamedInList(aFeatList, featName, -1);
    }

    public Feat getFeatKeyed(String featName) {
        return this.getFeatKeyed(featName, this.aggregateFeatList());
    }

    public Feat getFeatNonAggregateKeyed(String featName) {
        return this.getFeatKeyed(featName, this.featList);
    }

    public Feat getFeatNonAggregateNamed(String featName) {
        return PlayerCharacter.getFeatNamedInList(this.featList, featName);
    }

    public int getFirstSpellLevel(Spell aSpell) {
        int anInt = 0;
        Iterator iClass = this.getClassList().iterator();
        while (iClass.hasNext()) {
            PCClass aClass = (PCClass)iClass.next();
            String aKey = aClass.getSpellKey();
            int temp = aSpell.getFirstLevelForKey(aKey, this);
            anInt = Math.min(anInt, temp);
        }
        return anInt;
    }

    public void setHasMadeKitSelectionForAgeSet(int index, boolean arg) {
        if (index >= 0 && index < 10) {
            this.ageSetKitSelections[index] = arg;
        }
        this.setDirty(true);
    }

    public List getKitInfo() {
        return this.kitList;
    }

    public int getLevelAdjustment(PlayerCharacter aPC) {
        int levelAdj = this.race.getLevelAdjustment(aPC);
        Iterator e = this.templateList.iterator();
        while (e.hasNext()) {
            PCTemplate aT = (PCTemplate)e.next();
            levelAdj += aT.getLevelAdjustment(aPC);
        }
        return levelAdj;
    }

    public List getLevelInfo() {
        return this.pcLevelInfo;
    }

    public String getLevelInfoClassKeyName(int idx) {
        if (idx >= 0 && idx < this.getLevelInfoSize()) {
            return ((PCLevelInfo)this.pcLevelInfo.get(idx)).getClassKeyName();
        }
        return "";
    }

    public int getLevelInfoClassLevel(int idx) {
        if (idx >= 0 && idx < this.getLevelInfoSize()) {
            return ((PCLevelInfo)this.pcLevelInfo.get(idx)).getLevel();
        }
        return 0;
    }

    public PCLevelInfo getLevelInfoFor(String className, int level) {
        Iterator i = this.pcLevelInfo.iterator();
        while (i.hasNext()) {
            PCLevelInfo pcl = (PCLevelInfo)i.next();
            if (pcl.getClassKeyName().equals(className)) {
                --level;
            }
            if (level > 0) continue;
            return pcl;
        }
        return null;
    }

    public int getLevelInfoSize() {
        return this.pcLevelInfo.size();
    }

    public void setLoadCompanion(boolean aBool) {
        this.autoLoadCompanion = aBool;
        this.setDirty(true);
    }

    public boolean getLoadCompanion() {
        return this.autoLoadCompanion;
    }

    public int getMaxCharacterDomains() {
        return (int)this.getTotalBonusTo("DOMAIN", "NUMBER");
    }

    public int getMaxCharacterDomains(PCClass src, PlayerCharacter aPC) {
        int i = this.getMaxCharacterDomains();
        if (i == 0 && this.domainSourceMap.size() == 0) {
            i = (int)src.getBonusTo("DOMAIN", "NUMBER", src.getLevel(), aPC);
        }
        return i;
    }

    public Float getMaxRank(String skillName, PCClass aClass) {
        BigDecimal maxRanks;
        Skill aSkill;
        int levelForSkillPurposes = this.getTotalLevels();
        if (SettingsHandler.isMonsterDefault()) {
            levelForSkillPurposes += this.totalHitDice();
        }
        if ((aSkill = Globals.getSkillNamed(skillName)).isExclusive()) {
            levelForSkillPurposes = 0;
            Iterator e = this.classList.iterator();
            while (e.hasNext()) {
                PCClass bClass = (PCClass)e.next();
                if (!aSkill.isClassSkill(bClass, this)) continue;
                levelForSkillPurposes += bClass.getLevel();
            }
            if (SettingsHandler.isMonsterDefault()) {
                levelForSkillPurposes += this.totalHitDice();
            }
            if (levelForSkillPurposes == 0) {
                levelForSkillPurposes = SettingsHandler.isMonsterDefault() ? this.getTotalLevels() + this.totalHitDice() : this.getTotalLevels();
                maxRanks = PlayerCharacter.maxCrossClassSkillForLevel(levelForSkillPurposes, this);
            } else {
                maxRanks = PlayerCharacter.maxClassSkillForLevel(levelForSkillPurposes, this);
            }
        } else {
            maxRanks = !aSkill.isClassSkill(this.classList, this) && aSkill.costForPCClass(aClass, this) == 1 ? new BigDecimal((double)PlayerCharacter.maxCrossClassSkillForLevel(levelForSkillPurposes, this).intValue()) : (!aSkill.isClassSkill(this.classList, this) ? PlayerCharacter.maxCrossClassSkillForLevel(levelForSkillPurposes, this) : PlayerCharacter.maxClassSkillForLevel(levelForSkillPurposes, this));
        }
        return new Float(maxRanks.floatValue());
    }

    public Double getMovement(int moveIdx) {
        if (this.getMovements() != null && moveIdx < this.movements.length) {
            return this.movements[moveIdx];
        }
        return new Double(0.0);
    }

    public String getMovementType(int moveIdx) {
        if (this.movementTypes != null && moveIdx < this.movementTypes.length) {
            return this.movementTypes[moveIdx];
        }
        return "";
    }

    public double movementOfType(String moveType) {
        if (this.movementTypes == null) {
            return 0.0;
        }
        for (int moveIdx = 0; moveIdx < this.movementTypes.length; ++moveIdx) {
            if (!this.movementTypes[moveIdx].equalsIgnoreCase(moveType)) continue;
            return this.movement(moveIdx);
        }
        return 0.0;
    }

    public CharacterDomain getNewCharacterDomain() {
        return this.getNewCharacterDomain(null);
    }

    public CharacterDomain getNewCharacterDomain(String className) {
        String sDom = this.getDomainSource(className);
        if (sDom.length() > 0) {
            StringTokenizer aTok = new StringTokenizer(sDom, "|");
            String aType = aTok.nextToken();
            String aName = aTok.nextToken();
            int aLevel = Integer.parseInt(aTok.nextToken());
            CharacterDomain aCD = new CharacterDomain();
            if (aType.equalsIgnoreCase("PCClass")) {
                aCD.setFromPCClass(true);
            } else {
                aCD.setFromPCClass(false);
            }
            aCD.setObjectName(aName);
            aCD.setLevel(aLevel);
            return aCD;
        }
        return null;
    }

    public boolean isNonAbility(int i) {
        if (this.race.isNonAbility(i)) {
            return true;
        }
        for (int x = 0; x < this.templateList.size(); ++x) {
            if (!((PCTemplate)this.templateList.get(x)).isNonAbility(i)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfMovements() {
        return this.movements != null ? this.movements.length : 0;
    }

    public int getOffHandLightBonus() {
        int div = this.getVariableValue("OFFHANDLIGHTBONUS", "").intValue();
        return div;
    }

    public boolean isPrimaryWeapon(Equipment eq) {
        if (eq == null) {
            return false;
        }
        Iterator e = this.primaryWeapons.iterator();
        while (e.hasNext()) {
            Equipment eqI = (Equipment)e.next();
            if (!eqI.getName().equalsIgnoreCase(eq.getName()) || eqI.getLocation() != eq.getLocation()) continue;
            return true;
        }
        return false;
    }

    public boolean isProficientWith(Equipment eq) {
        if (eq.isShield()) {
            return this.isProficientWithShield(eq);
        }
        if (eq.isArmor()) {
            return this.isProficientWithArmor(eq);
        }
        if (eq.isWeapon()) {
            return this.isProficientWithWeapon(eq);
        }
        return false;
    }

    public void setRace(Race aRace) {
        boolean firstLevel;
        Race oldRace = this.getRace();
        boolean raceIsNull = oldRace == null;
        boolean bl = firstLevel = this.getTotalClassLevels() == 1;
        if (!raceIsNull) {
            PCClass mclass;
            if (firstLevel) {
                this.setFeats(this.feats - (double)oldRace.getBonusInitialFeats());
            }
            oldRace.clearCharacterSpells();
            if (PlayerCharacter.canReassignRacialFeats()) {
                StringTokenizer aTok = new StringTokenizer(oldRace.getFeatList(this), "|");
                while (aTok.hasMoreTokens()) {
                    String aString = aTok.nextToken();
                    if (aString.endsWith(")") && Globals.getFeatNamed(aString) == null) {
                        String featName = aString.substring(0, aString.indexOf(40) - 1);
                        Feat aFeat = Globals.getFeatNamed(featName);
                        if (aFeat == null) continue;
                        this.modFeat(aString, true, false);
                        this.setFeats(this.feats - aFeat.getCost(this));
                        continue;
                    }
                    Feat aFeat = Globals.getFeatNamed(aString);
                    if (aFeat != null) {
                        String featName = aFeat.getName();
                        if (!this.hasFeat(featName) && !this.hasFeatAutomatic(featName)) continue;
                        this.modFeat(aString, true, false);
                        this.setFeats(this.feats - aFeat.getCost(this));
                        continue;
                    }
                    ShowMessageDelegate.showMessageDialog("Removing unknown feat: " + aString, "PCGen", MessageType.INFORMATION);
                }
            }
            this.getLanguagesList().removeAll(oldRace.getAutoLanguages());
            if (oldRace.getWeaponProfAutos() != null) {
                this.weaponProfList.removeAll(oldRace.getWeaponProfAutos());
            }
            if (this.racialFavoredClass.length() != 0) {
                this.favoredClasses.remove(this.racialFavoredClass);
            }
            this.removeNaturalWeapons(this.race);
            for (int x = 0; x < this.race.templatesAdded().size(); ++x) {
                this.removeTemplate(this.getTemplateNamed((String)this.race.templatesAdded().get(x)));
            }
            if (this.race.getMonsterClass(this) != null && this.race.getMonsterClassLevels(this) != 0 && (mclass = Globals.getClassNamed(this.race.getMonsterClass(this))) != null) {
                this.incrementClassLevel(this.race.getMonsterClassLevels(this) * -1, mclass, true);
            }
        }
        this.race = null;
        if (aRace != null) {
            this.race = (Race)aRace.clone();
        }
        if (this.race != null) {
            PCClass mclass;
            this.race.activateBonuses(this);
            if (!this.importing) {
                Globals.getBioSet().randomize("AGE.HT.WT", this);
                if (firstLevel) {
                    this.setFeats(this.feats + (double)this.race.getBonusInitialFeats());
                }
            }
            ArrayList existingClasses = new ArrayList(this.classList);
            this.classList.clear();
            for (int i = this.getLevelInfoSize() - 1; i >= 0; --i) {
                String classKeyName = this.getLevelInfoClassKeyName(i);
                PCClass aClass = Globals.getClassKeyed(classKeyName);
                if (aClass != null && !aClass.isMonster()) continue;
                this.removeLevelInfo(i);
            }
            ArrayList existingLevelInfo = new ArrayList(this.pcLevelInfo);
            this.pcLevelInfo.clear();
            this.skillPoints = 0;
            if (!this.importing && this.race.getMonsterClass(this) != null && this.race.getMonsterClassLevels(this) != 0 && (mclass = Globals.getClassNamed(this.race.getMonsterClass(this))) != null) {
                this.incrementClassLevel(this.race.getMonsterClassLevels(this), mclass, true);
            }
            this.pcLevelInfo.addAll(existingLevelInfo);
            if (!this.importing && raceIsNull && existingClasses.size() != 0) {
                this.setFeats(this.feats + (double)this.race.getBonusInitialFeats());
                int spMod = 0;
                int totalLevels = this.getTotalLevels();
                Integer zero = new Integer(0);
                for (int i = 0; i < existingClasses.size(); ++i) {
                    PCClass aClass = (PCClass)existingClasses.get(i);
                    if (aClass.isMonster()) continue;
                    this.classList.add(aClass);
                    int cLevels = aClass.getLevel();
                    aClass.setSkillPool(zero);
                    int cMod = 0;
                    for (int j = 0; j < cLevels; ++j) {
                        cMod += aClass.recalcSkillPointMod(this, ++totalLevels);
                    }
                    aClass.setSkillPool(new Integer(cMod));
                    this.skillPoints += (spMod += cMod);
                }
            }
            this.addNaturalWeapons(this.race.getNaturalWeapons());
            if (PlayerCharacter.canReassignRacialFeats()) {
                StringTokenizer aTok = new StringTokenizer(this.getRace().getFeatList(this), "|");
                while (aTok.hasMoreTokens()) {
                    String aString = aTok.nextToken();
                    if (aString.endsWith(")") && Globals.getFeatNamed(aString) == null) {
                        String featName = aString.substring(0, aString.indexOf(40) - 1);
                        Feat aFeat = Globals.getFeatNamed(featName);
                        if (aFeat == null) continue;
                        this.setFeats(this.feats + aFeat.getCost(this));
                        this.modFeat(aString, true, true);
                        continue;
                    }
                    Feat aFeat = Globals.getFeatNamed(aString);
                    if (aFeat != null) {
                        String featName = aFeat.getName();
                        if (this.hasFeat(featName) || this.hasFeatAutomatic(featName)) continue;
                        this.setFeats(this.feats + aFeat.getCost(this));
                        this.modFeat(aString, true, true);
                        continue;
                    }
                    ShowMessageDelegate.showMessageDialog("Adding unknown feat: " + aString, "PCGen", MessageType.INFORMATION);
                }
            }
            this.getAutoLanguages();
            this.getRacialFavoredClasses();
            this.race.getTemplates(this.importing, this);
            this.race.chooseLanguageAutos(this.importing, this);
        }
        this.setAggregateFeatsStable(false);
        this.setAutomaticFeatsStable(false);
        this.setVirtualFeatsStable(false);
        if (!this.importing) {
            this.getSpellList();
            this.race.globalChecks(this);
            this.adjustMoveRates();
            this.calcActiveBonuses();
        }
        this.setDirty(true);
    }

    public double getRaceBonusTo(String aType, String aName) {
        if (this.getRace() == null) {
            return 0.0;
        }
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        List tempList = this.getRace().getBonusListOfType(aType, aName);
        return this.calcBonusFromList(tempList);
    }

    public int getSR() {
        return this.calcSR(true);
    }

    public boolean isSecondaryWeapon(Equipment eq) {
        if (eq == null) {
            return false;
        }
        Iterator e = this.secondaryWeapons.iterator();
        while (e.hasNext()) {
            Equipment eqI = (Equipment)e.next();
            if (!eqI.getName().equalsIgnoreCase(eq.getName()) || eqI.getLocation() != eq.getLocation()) continue;
            return true;
        }
        return false;
    }

    public double getSizeAdjustmentBonusTo(String aType, String aName) {
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        return this.getBonusDueToType(aType, aName, "SIZE");
    }

    public Skill getSkillKeyed(String skillName) {
        if (this.getSkillList().isEmpty()) {
            return null;
        }
        Iterator e = this.getSkillList().iterator();
        while (e.hasNext()) {
            Skill aSkill = (Skill)e.next();
            if (!aSkill.getKeyName().equalsIgnoreCase(skillName)) continue;
            return aSkill;
        }
        return null;
    }

    public Skill getSkillNamed(String skillName) {
        if (this.getSkillList().isEmpty()) {
            return null;
        }
        Iterator e = this.getSkillList().iterator();
        while (e.hasNext()) {
            Skill aSkill = (Skill)e.next();
            if (!aSkill.getName().equalsIgnoreCase(skillName)) continue;
            return aSkill;
        }
        return null;
    }

    public void setSkillsOutputOrder(int i) {
        this.skillsOutputOrder = i;
        this.setDirty(true);
    }

    public int getSkillsOutputOrder() {
        return this.skillsOutputOrder;
    }

    public boolean isSpellCaster(int minLevel) {
        return this.isSpellCaster(minLevel, false);
    }

    public boolean isSpellCaster(int minLevel, boolean sumOfLevels) {
        int runningTotal = 0;
        Iterator e1 = this.classList.iterator();
        while (e1.hasNext()) {
            PCClass aClass = (PCClass)e1.next();
            if (aClass.getSpellType().equalsIgnoreCase("None")) continue;
            int classLevels = (int)this.getTotalBonusTo("CASTERLEVEL", aClass.getName());
            if (classLevels == 0 && (this.canCastSpellTypeLevel(aClass.getSpellType(), 0, 1) || this.canCastSpellTypeLevel(aClass.getSpellType(), 1, 1))) {
                classLevels = aClass.getLevel();
            }
            classLevels += (int)this.getTotalBonusTo("PCLEVEL", aClass.getName());
            if (sumOfLevels) {
                runningTotal += classLevels;
                continue;
            }
            if (classLevels < minLevel) continue;
            return true;
        }
        if (sumOfLevels) {
            return runningTotal > minLevel;
        }
        return false;
    }

    public boolean isSpellCaster(String spellType, int minLevel) {
        return this.isSpellCaster(spellType, minLevel, false);
    }

    public boolean isSpellCaster(String spellType, int minLevel, boolean sumLevels) {
        int runningTotal = 0;
        Iterator e1 = this.classList.iterator();
        while (e1.hasNext()) {
            PCClass aClass = (PCClass)e1.next();
            if (!spellType.equalsIgnoreCase(aClass.getSpellType())) continue;
            int classLevels = (int)this.getTotalBonusTo("CASTERLEVEL", aClass.getName());
            if (classLevels == 0 && (this.canCastSpellTypeLevel(aClass.getSpellType(), 0, 1) || this.canCastSpellTypeLevel(aClass.getSpellType(), 1, 1))) {
                classLevels = aClass.getLevel();
            }
            classLevels += (int)this.getTotalBonusTo("PCLEVEL", aClass.getName());
            if (sumLevels) {
                runningTotal += classLevels;
                continue;
            }
            if (classLevels < minLevel) continue;
            return true;
        }
        if (sumLevels) {
            return runningTotal >= minLevel;
        }
        return false;
    }

    public boolean isSpellCastermax(int maxLevel) {
        Iterator e1 = this.classList.iterator();
        while (e1.hasNext()) {
            PCClass aClass = (PCClass)e1.next();
            if (aClass.getSpellType().equalsIgnoreCase("None") || aClass.getLevel() > maxLevel) continue;
            return true;
        }
        return false;
    }

    public Map getSpellInfoMap(String key) {
        this.buildSpellInfoMap(key);
        return this.spellInfoMap;
    }

    public boolean getSpellLevelforKey(String key, int levelMatch) {
        this.buildSpellLevelMap(levelMatch);
        if (!this.spellLevelMap.containsKey(key)) {
            return false;
        }
        int levelInt = -1;
        try {
            levelInt = Integer.parseInt((String)this.spellLevelMap.get(key));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return levelMatch == levelInt;
    }

    public void getSpellList() {
        if (this.race == null) {
            return;
        }
        this.race.clearCharacterSpells();
        this.addSpells(this.race);
        if (this.deity != null) {
            this.addSpells(this.deity);
        }
        Iterator i = this.classList.iterator();
        while (i.hasNext()) {
            PCClass aClass = (PCClass)i.next();
            this.addSpells(aClass);
        }
        i = this.aggregateFeatList().iterator();
        while (i.hasNext()) {
            Feat aFeat = (Feat)i.next();
            this.addSpells(aFeat);
        }
        i = this.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            this.addSpells(aSkill);
        }
        Iterator e = this.equipmentList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            this.addSpells(eq);
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    this.addSpells(eqMod);
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                this.addSpells(eqMod);
            }
        }
        i = this.templateList.iterator();
        while (i.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)i.next();
            this.addSpells(aTemplate);
        }
    }

    public String getSpellRange(Spell aSpell, String aName, SpellInfo si) {
        String aRange = aSpell.getRange();
        String aSpellClass = "CLASS:" + aName;
        int rangeInFeet = 0;
        String aString = Globals.getGameModeSpellRangeFormula(aRange.toUpperCase());
        if (aRange.equalsIgnoreCase("CLOSE") && aString == null) {
            aString = "((CASTERLEVEL/2).TRUNC*5)+25";
        } else if (aRange.equalsIgnoreCase("MEDIUM") && aString == null) {
            aString = "(CASTERLEVEL*10)+100";
        } else if (aRange.equalsIgnoreCase("LONG") && aString == null) {
            aString = "(CASTERLEVEL*40)+400";
        }
        if (aString != null) {
            List metaFeats = si.getFeatList();
            rangeInFeet = this.getVariableValue(aSpell, aString, aSpellClass).intValue();
            if (metaFeats != null && !metaFeats.isEmpty()) {
                Iterator e = metaFeats.iterator();
                while (e.hasNext()) {
                    Feat aFeat = (Feat)e.next();
                    rangeInFeet += (int)aFeat.bonusTo("SPELL", "RANGE", this, this);
                    int iMult = (int)aFeat.bonusTo("SPELL", "RANGEMULT", this, this);
                    if (iMult <= 0) continue;
                    rangeInFeet *= iMult;
                }
            }
            aRange = aRange + " (" + Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(rangeInFeet)) + Globals.getDistanceUnit() + ")";
        }
        return aRange;
    }

    public int getClassCasterLevel(PCClass aClass) {
        int casterLevel = this.getVariableValue("CASTERLEVEL", "CLASS:" + aClass.getName()).intValue();
        return casterLevel;
    }

    public int getRaceCasterLevel(Race aRace) {
        int casterLevel = this.getVariableValue("CASTERLEVEL", "RACE:" + aRace.getName()).intValue();
        return casterLevel;
    }

    public double getStatBonusTo(String aType, String aName) {
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        List aList = this.statList.getBonusListOfType(aType, aName);
        return this.calcBonusFromList(aList);
    }

    public double getTempBonusTo(String aType, String aName) {
        double bonus = 0.0;
        if (this.getTempBonusList().isEmpty() || !this.getUseTempMods()) {
            return bonus;
        }
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        Iterator b = this.getTempBonusList().iterator();
        while (b.hasNext()) {
            PlayerCharacter bPC;
            BonusObj aBonus = (BonusObj)b.next();
            String bString = aBonus.toString();
            if (bString.indexOf(aType) < 0 || bString.indexOf(aName) < 0) continue;
            Object tarObj = aBonus.getTargetObject();
            Object creObj = aBonus.getCreatorObject();
            if (creObj == null || tarObj == null || !(creObj instanceof PObject) || !(tarObj instanceof PlayerCharacter) || (bPC = (PlayerCharacter)tarObj) != this) continue;
            PObject aCreator = (PObject)creObj;
            bonus += aCreator.calcBonusFrom(aBonus, this);
        }
        return bonus;
    }

    public double getTemplateBonusTo(String aType, String aName, boolean subSearch) {
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        return this.getPObjectWithCostBonusTo(this.templateList, aType, aName, subSearch);
    }

    public double getTotalBonusTo(String bonusType, String bonusName) {
        String prefix = bonusType + '.' + bonusName;
        return this.sumActiveBonusMap(prefix.toUpperCase());
    }

    public int getTotalLevels() {
        int totalLevels = 0;
        totalLevels += this.totalNonMonsterLevels();
        return totalLevels += this.totalHitDice();
    }

    public int getTotalPlayerLevels() {
        int totalLevels = 0;
        return totalLevels += this.totalNonMonsterLevels();
    }

    public int getTotalStatAtLevel(String statAbb, int level, boolean includePost, boolean includeTemp) {
        int curStat = this.getStatList().getTotalStatFor(statAbb, includeTemp);
        for (int idx = this.getLevelInfoSize() - 1; idx >= level; --idx) {
            int statLvlAdjust = ((PCLevelInfo)this.pcLevelInfo.get(idx)).getTotalStatMod(statAbb, includePost);
            curStat -= statLvlAdjust;
        }
        return curStat;
    }

    public int getTwoHandDamageDivisor() {
        int div = this.getVariableValue("TWOHANDDAMAGEDIVISOR", "").intValue();
        if (div == 0) {
            div = 2;
        }
        return div;
    }

    public String getUnarmedDamageString(boolean includeCrit, boolean includeStrBonus) {
        String retString = "2|1d2";
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            retString = PlayerCharacter.getBestUDamString(retString, aClass.getUdamForLevel(aClass.getLevel(), includeCrit, includeStrBonus, this));
        }
        retString = PlayerCharacter.getBestUDamString(retString, this.race.getUdamFor(includeCrit, includeStrBonus, this));
        if (this.deity != null) {
            retString = PlayerCharacter.getBestUDamString(retString, this.deity.getUdamFor(includeCrit, includeStrBonus, this));
        }
        Iterator i = this.featList.iterator();
        while (i.hasNext()) {
            Feat aFeat = (Feat)i.next();
            retString = PlayerCharacter.getBestUDamString(retString, aFeat.getUdamFor(includeCrit, includeStrBonus, this));
        }
        i = this.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            retString = PlayerCharacter.getBestUDamString(retString, aSkill.getUdamFor(includeCrit, includeStrBonus, this));
        }
        i = this.characterDomainList.iterator();
        while (i.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)i.next();
            if (aCD.getDomain() == null) continue;
            retString = PlayerCharacter.getBestUDamString(retString, aCD.getDomain().getUdamFor(includeCrit, includeStrBonus, this));
        }
        e = this.equipmentList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            retString = PlayerCharacter.getBestUDamString(retString, eq.getUdamFor(includeCrit, includeStrBonus, this));
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    retString = PlayerCharacter.getBestUDamString(retString, eqMod.getUdamFor(includeCrit, includeStrBonus, this));
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                retString = PlayerCharacter.getBestUDamString(retString, eqMod.getUdamFor(includeCrit, includeStrBonus, this));
            }
        }
        i = this.templateList.iterator();
        while (i.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)i.next();
            retString = PlayerCharacter.getBestUDamString(retString, aTemplate.getUdamFor(includeCrit, includeStrBonus, this));
        }
        return retString.substring(retString.indexOf(124) + 1);
    }

    public boolean getUseMasterSkill() {
        Iterator e = this.companionModList.iterator();
        while (e.hasNext()) {
            CompanionMod cMod = (CompanionMod)e.next();
            if (!cMod.getType().equalsIgnoreCase(this.getMaster().getType()) || !cMod.getUseMasterSkill()) continue;
            return true;
        }
        return false;
    }

    public void setUseTempMods(boolean aBool) {
        this.useTempMods = aBool;
    }

    public boolean getUseTempMods() {
        return this.useTempMods;
    }

    public Float getVariableValue(String aString, String src) {
        return this.getVariableValue(null, aString, src);
    }

    private Float getVariableValue(Spell aSpell, String aString, String src) {
        try {
            Float total = new Float(aString);
            return total;
        }
        catch (NumberFormatException e) {
            Float total;
            String cacheString = aString + "#" + src;
            if (aSpell != null) {
                cacheString = cacheString + aSpell.getName();
            }
            if (this.getSpellLevelTemp() > 0) {
                cacheString = cacheString + this.getSpellLevelTemp();
            }
            if ((total = this.getCachedVariable(cacheString)) != null) {
                return total;
            }
            total = this.getJepVariable(aSpell, aString, src);
            if (total != null) {
                this.addCachedVariable(cacheString, total);
                return total;
            }
            total = new Float(0.0);
            Float total1 = null;
            aString = aString.toUpperCase();
            src = src.toUpperCase();
            while (aString.lastIndexOf(40) >= 0) {
                int x = CoreUtility.innerMostStringStart(aString);
                int y = CoreUtility.innerMostStringEnd(aString);
                if (y < x) {
                    Logging.errorPrint("Missing closing parenthesis: " + aString);
                    this.addCachedVariable(cacheString, total);
                    return total;
                }
                String bString = aString.substring(x + 1, y);
                aString = aString.substring(0, x) + this.getVariableValue(aSpell, bString, src) + aString.substring(y + 1);
            }
            String delimiter = "+-/*";
            String valString = "";
            int mode = 0;
            int nextMode = 0;
            int endMode = 0;
            if (aString.startsWith(".IF.")) {
                StringTokenizer aTok = new StringTokenizer(aString.substring(4), ".", true);
                String bString = "";
                Float val1 = null;
                Float val2 = null;
                Float valt = null;
                int comp = 0;
                while (aTok.hasMoreTokens()) {
                    String cString = aTok.nextToken();
                    if ("GT".equals(cString) || "GTEQ".equals(cString) || "EQ".equals(cString) || "LTEQ".equals(cString) || "LT".equals(cString)) {
                        val1 = this.getVariableValue(aSpell, bString.substring(0, bString.length() - 1), src);
                        aTok.nextToken();
                        bString = "";
                        if ("LT".equals(cString)) {
                            comp = 1;
                            continue;
                        }
                        if ("LTEQ".equals(cString)) {
                            comp = 2;
                            continue;
                        }
                        if ("EQ".equals(cString)) {
                            comp = 3;
                            continue;
                        }
                        if ("GT".equals(cString)) {
                            comp = 4;
                            continue;
                        }
                        if (!"GTEQ".equals(cString)) continue;
                        comp = 5;
                        continue;
                    }
                    if ("THEN".equals(cString)) {
                        val2 = this.getVariableValue(aSpell, bString.substring(0, bString.length() - 1), src);
                        aTok.nextToken();
                        bString = "";
                        continue;
                    }
                    if ("ELSE".equals(cString)) {
                        valt = this.getVariableValue(aSpell, bString.substring(0, bString.length() - 1), src);
                        aTok.nextToken();
                        bString = "";
                        continue;
                    }
                    bString = bString + cString;
                }
                if (val1 != null && val2 != null && valt != null) {
                    Float valf = this.getVariableValue(aSpell, bString, src);
                    total = valt;
                    switch (comp) {
                        case 1: {
                            if (!(val1.doubleValue() >= val2.doubleValue())) break;
                            total = valf;
                            break;
                        }
                        case 2: {
                            if (!(val1.doubleValue() > val2.doubleValue())) break;
                            total = valf;
                            break;
                        }
                        case 3: {
                            if (CoreUtility.doublesEqual(val1.doubleValue(), val2.doubleValue())) break;
                            total = valf;
                            break;
                        }
                        case 4: {
                            if (!(val1.doubleValue() <= val2.doubleValue())) break;
                            total = valf;
                            break;
                        }
                        case 5: {
                            if (!(val1.doubleValue() < val2.doubleValue())) break;
                            total = valf;
                            break;
                        }
                        default: {
                            Logging.errorPrint("ERROR - badly formed statement:" + aString + ":" + val1.toString() + ":" + val2.toString() + ":" + comp);
                            return new Float(0.0);
                        }
                    }
                    this.addCachedVariable(cacheString, total);
                    return total;
                }
            }
            for (int i = 0; i < aString.length(); ++i) {
                String tmp;
                valString = valString + aString.substring(i, i + 1);
                if (i != aString.length() - 1 && "+-/*".lastIndexOf(aString.charAt(i)) <= -1 && (valString.length() <= 3 || !valString.endsWith("MIN") && (valString.startsWith("MODEQUIP") || !valString.endsWith("MAX")) && !valString.endsWith("REQ")) || valString.length() == 1 && "+-/*".lastIndexOf(aString.charAt(i)) > -1) continue;
                if ("+-/*".lastIndexOf(aString.charAt(i)) > -1) {
                    valString = valString.substring(0, valString.length() - 1);
                }
                if (valString.length() > 2 && valString.charAt(0) == '%' && valString.endsWith("%")) {
                    if ("".equals(loopVariable)) {
                        StringTokenizer lTok = new StringTokenizer(valString, "%:");
                        String vString = loopVariable = lTok.nextToken();
                        decrement = 1;
                        if (lTok.hasMoreTokens()) {
                            decrement = Integer.parseInt(lTok.nextToken());
                        }
                        loopValue = 0;
                        if (this.hasVariable(loopVariable)) {
                            loopValue = this.getVariable(loopVariable, true, true, "", "").intValue();
                            loopVariable = vString;
                        }
                    }
                    if (loopValue == 0) {
                        loopVariable = "";
                    }
                    valString = Integer.toString(loopValue);
                }
                if ((tmp = this.getInternalVariable(aSpell, valString, src)) != null) {
                    valString = tmp;
                } else if (valString.length() > 0) {
                    if (this.hasVariable(valString)) {
                        valString = this.getVariable(valString, true, true, "", "").toString();
                    } else {
                        double a = 0.0;
                        try {
                            a = Float.parseFloat(valString);
                        }
                        catch (NumberFormatException exc) {
                            // empty catch block
                        }
                        valString = !CoreUtility.doublesEqual(a, 0.0) ? String.valueOf(a) : this.getExportVariable(valString);
                    }
                }
                if (i < aString.length()) {
                    if (valString.endsWith(".TRUNC")) {
                        valString = String.valueOf(this.getVariableValue(aSpell, valString.substring(0, valString.length() - 6), "").intValue());
                    }
                    if (valString.endsWith(".INTVAL")) {
                        valString = this.getVariableValue(aSpell, valString.substring(0, valString.length() - 7), "").toString();
                        endMode += 10;
                    }
                    if (valString.endsWith("MIN")) {
                        valString = this.getVariableValue(aSpell, valString.substring(0, valString.length() - 3), "").toString();
                        nextMode = 0;
                        ++endMode;
                    } else if (valString.endsWith("MAX")) {
                        valString = this.getVariableValue(aSpell, valString.substring(0, valString.length() - 3), "").toString();
                        nextMode = 0;
                        endMode += 2;
                    } else if (valString.endsWith("REQ")) {
                        valString = this.getVariableValue(aSpell, valString.substring(0, valString.length() - 3), "").toString();
                        nextMode = 0;
                        endMode += 3;
                    } else if (aString.length() > 0 && aString.charAt(i) == '+') {
                        nextMode = 0;
                    } else if (aString.length() > 0 && aString.charAt(i) == '-') {
                        nextMode = 1;
                    } else if (aString.length() > 0 && aString.charAt(i) == '*') {
                        nextMode = 2;
                    } else if (aString.length() > 0 && aString.charAt(i) == '/') {
                        nextMode = 3;
                    }
                }
                try {
                    if (valString.length() > 0) {
                        switch (mode) {
                            case 0: {
                                total = new Float(total.doubleValue() + Double.parseDouble(valString));
                                break;
                            }
                            case 1: {
                                total = new Float(total.doubleValue() - Double.parseDouble(valString));
                                break;
                            }
                            case 2: {
                                total = new Float(total.doubleValue() * Double.parseDouble(valString));
                                break;
                            }
                            case 3: {
                                total = new Float(total.doubleValue() / Double.parseDouble(valString));
                                break;
                            }
                            default: {
                                Logging.errorPrint("In PlayerCharacter.getVariableValue the mode " + mode + " is unsupported.");
                            }
                        }
                    }
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                mode = nextMode;
                nextMode = 0;
                valString = "";
                if (total1 != null || endMode % 10 == 0) continue;
                total1 = total;
                total = new Float(0.0);
            }
            if (total1 != null) {
                if (endMode % 10 == 1) {
                    total = new Float(Math.min(total.doubleValue(), total1.doubleValue()));
                }
                if (endMode % 10 == 2) {
                    total = new Float(Math.max(total.doubleValue(), total1.doubleValue()));
                }
                if (endMode % 10 == 3) {
                    total = total1.doubleValue() < total.doubleValue() ? new Float(0.0) : total1;
                }
            }
            if (endMode / 10 > 0) {
                total = new Float(total.intValue());
            }
            this.addCachedVariable(cacheString, total);
            return total;
        }
    }

    private Float getCachedVariable(String lookup) {
        if (this.isCachePaused()) {
            return null;
        }
        CachedVariable cached = (CachedVariable)this.variableCache.get(lookup);
        if (cached != null) {
            if (cached.getSerial() >= this.getSerial()) {
                return (Float)cached.getValue();
            }
            this.variableCache.remove(lookup);
        }
        return null;
    }

    private void addCachedVariable(String lookup, Float value) {
        if (this.isCachePaused()) {
            return;
        }
        CachedVariable cached = new CachedVariable();
        cached.setSerial(this.getSerial());
        cached.setValue(value);
        this.variableCache.put(lookup, cached);
    }

    private String getCachedString(String lookup) {
        if (this.isCachePaused()) {
            return null;
        }
        CachedVariable cached = (CachedVariable)this.variableCache.get(lookup);
        if (cached != null) {
            if (cached.getSerial() >= this.getSerial()) {
                return cached.getValue().toString();
            }
            this.variableCache.remove(lookup);
        }
        return null;
    }

    private void addCachedString(String lookup, String value) {
        if (this.isCachePaused()) {
            return;
        }
        CachedVariable cached = new CachedVariable();
        cached.setSerial(this.getSerial());
        cached.setValue(value);
        this.variableCache.put(lookup, cached);
    }

    public String getExportVariable(String valString) {
        StringWriter sWriter = new StringWriter();
        BufferedWriter aWriter = new BufferedWriter(sWriter);
        ExportHandler aExport = new ExportHandler(new File(""));
        aExport.replaceTokenSkipMath(this, valString, aWriter);
        sWriter.flush();
        try {
            aWriter.flush();
        }
        catch (IOException e) {
            Logging.errorPrint("Couldn't flush the StringWriter used in PlayerCharacter.getVariableValue.", e);
        }
        String bString = sWriter.toString();
        try {
            valString = String.valueOf(Float.parseFloat(bString));
        }
        catch (NumberFormatException e) {
            valString = bString;
        }
        return valString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Float getJepVariable(Spell spell, String formula, String src) {
        Float f;
        PJEP parser;
        block17: {
            block16: {
                Float f2;
                block15: {
                    Logging.debugPrint(this.jepIndent + "getJepVariable: " + formula);
                    this.jepIndent = this.jepIndent + "    ";
                    parser = null;
                    try {
                        parser = PjepPool.getInstance().aquire(this, src);
                        parser.parseExpression(formula);
                        if (parser.hasError()) {
                            Logging.debugPrint(this.jepIndent + "not a JEP expression: " + formula);
                            Float f3 = null;
                            Object var12_7 = null;
                            if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                                this.jepIndent = this.jepIndent.substring(4);
                            }
                            PjepPool.getInstance().release(parser);
                            return f3;
                        }
                        Iterator iter = parser.getSymbolTable().keySet().iterator();
                        while (iter.hasNext()) {
                            String element = (String)iter.next();
                            if (element.equals("TRUE") || element.equals("FALSE") || element.equals("e") || element.equals("pi")) continue;
                            if (this.hasVariable(element)) {
                                Float value = this.getVariable(element, true, true, src, "");
                                Logging.debugPrint(this.jepIndent + "variable for: '" + element + "' = " + value);
                                parser.addVariable(element, value.doubleValue());
                                continue;
                            }
                            String foo = this.getInternalVariable(spell, element, src);
                            if (foo == null) {
                                Logging.debugPrint(this.jepIndent + "Cannot find an internal variable for: " + element);
                                f2 = null;
                                break block15;
                            }
                            Double d = new Double(Double.NaN);
                            try {
                                d = new Double(foo);
                            }
                            catch (NumberFormatException nfe) {
                                Logging.errorPrint(this.jepIndent + "Tried to parse internal variable " + foo + " as a double!");
                                Float f4 = null;
                                Object var12_9 = null;
                                if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                                    this.jepIndent = this.jepIndent.substring(4);
                                }
                                PjepPool.getInstance().release(parser);
                                return f4;
                            }
                            if (d.isNaN()) continue;
                            parser.addVariable(element, d);
                            Logging.debugPrint(this.jepIndent + "internal variable for: '" + element + "' = " + d);
                        }
                        Object result = parser.getValueAsObject();
                        if (result != null) {
                            Logging.debugPrint(this.jepIndent + "Result '" + formula + "' = " + result);
                            f = new Float(result.toString());
                            break block16;
                        }
                        Logging.debugPrint(this.jepIndent + "Result '" + formula + "' was null...");
                        f = null;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                            this.jepIndent = this.jepIndent.substring(4);
                        }
                        PjepPool.getInstance().release(parser);
                        throw throwable;
                    }
                }
                Object var12_8 = null;
                if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                    this.jepIndent = this.jepIndent.substring(4);
                }
                PjepPool.getInstance().release(parser);
                return f2;
            }
            Object var12_10 = null;
            if (this.jepIndent != null && this.jepIndent.length() >= 4) {
                this.jepIndent = this.jepIndent.substring(4);
            }
            PjepPool.getInstance().release(parser);
            return f;
        }
        Object var12_11 = null;
        if (this.jepIndent != null && this.jepIndent.length() >= 4) {
            this.jepIndent = this.jepIndent.substring(4);
        }
        PjepPool.getInstance().release(parser);
        return f;
    }

    public String getInternalVariable(Spell aSpell, String valString, String src) {
        if (!Globals.checkRule("SYS_LDPACSK") && valString.equals(this.statList.getPenaltyVar("DEX"))) {
            valString = "1000";
        }
        if ("SCORE".equals(valString) && src.startsWith("STAT:")) {
            valString = String.valueOf(this.statList.getTotalStatFor(src.substring(5)));
        } else if ("SPELLBASESTATSCORE".equals(valString)) {
            PCClass aClass = this.getClassNamed(src.substring(6));
            if (aClass != null) {
                valString = aClass.getSpellBaseStat() + "SCORE";
                if ("SPELLSCORE".equals(valString)) {
                    valString = "10";
                }
            } else {
                valString = "0";
            }
        } else if ("SPELLBASESTAT".equals(valString)) {
            PCClass aClass = this.getClassNamed(src.substring(6));
            if (aClass != null) {
                valString = aClass.getSpellBaseStat();
                if ("SPELL".equals(valString)) {
                    valString = "0";
                }
            } else {
                valString = "0";
            }
        } else if ("BASESPELLSTAT".equals(valString)) {
            PCClass aClass = null;
            if (src.length() < 7) {
                valString = "0";
            } else {
                aClass = this.getClassNamed(src.substring(6));
            }
            if (aClass != null) {
                valString = String.valueOf(this.getBaseSpellStatBonus(aClass));
            }
        } else if ("SPELLLEVEL".equals(valString)) {
            valString = String.valueOf(this.getSpellLevelTemp());
        } else if (valString.length() > 0 && SettingsHandler.getGame().getStatFromAbbrev(valString) > -1) {
            int iX = SettingsHandler.getGame().getStatFromAbbrev(valString);
            int statNum = this.statList.getTotalStatFor(valString);
            int statMod = this.statList.getModForNumber(statNum, iX);
            valString = Integer.toString(statMod);
        } else if (valString.length() == 8 && SettingsHandler.getGame().getStatFromAbbrev(valString.substring(0, 3)) > -1 && valString.endsWith(".BASE")) {
            valString = Integer.toString(this.statList.getBaseStatFor(valString.substring(0, 3)));
        } else if (valString.length() >= 8 && valString.substring(3).startsWith("SCORE")) {
            valString = valString.endsWith(".BASE") ? Integer.toString(this.statList.getBaseStatFor(valString.substring(0, 3))) : Integer.toString(this.statList.getTotalStatFor(valString.substring(0, 3)));
        } else if ("CASTERLEVEL".equals(valString) && src.startsWith("RACE:")) {
            int iLev = this.getTotalCasterLevelWithSpellBonus(aSpell, "None", "RACE." + src.substring(5), 0);
            if (iLev > 0) {
                valString = Integer.toString(iLev);
            }
        } else if ("CASTERLEVEL.TOTAL".equals(valString) || "CASTERLEVEL".equals(valString) && !src.startsWith("CLASS:")) {
            int iLev = 0;
            Iterator e = this.classList.iterator();
            while (e.hasNext()) {
                PCClass aClass = (PCClass)e.next();
                if (aClass.getSpellType() == "None") continue;
                String className = aClass.getName();
                String spellType = "None";
                int pcBonusLevel = (int)this.getTotalBonusTo("PCLEVEL", className);
                if (aClass != null && aClass.getSpellType() != "None") {
                    spellType = aClass.getSpellType();
                }
                if (CoreUtility.doublesEqual(this.getTotalBonusTo("CASTERLEVEL", className), 0.0)) {
                    int iClass = Integer.parseInt(this.getClassLevelString(className, false));
                    iLev += this.getTotalCasterLevelWithSpellBonus(aSpell, spellType, className, iClass + pcBonusLevel);
                    continue;
                }
                iLev += this.getTotalCasterLevelWithSpellBonus(aSpell, spellType, className, pcBonusLevel);
            }
            valString = Integer.toString(iLev);
        } else if ("CASTERLEVEL".equals(valString) && src.startsWith("CLASS:")) {
            String className = src.substring(6);
            CharacterDomain aCD = this.getCharacterDomainForDomain(className);
            if (aCD != null) {
                className = aCD.getObjectName();
            }
            PCClass spClass = Globals.getClassNamed(className);
            String spellType = "None";
            if (spClass != null && spClass.getSpellType() != "None") {
                spellType = spClass.getSpellType();
            }
            int pcBonusLevel = (int)this.getTotalBonusTo("PCLEVEL", className);
            int iLev = (int)this.getTotalBonusTo("CASTERLEVEL", className);
            if (iLev == 0) {
                iLev = Integer.parseInt(this.getClassLevelString(className, false));
                iLev = this.getTotalCasterLevelWithSpellBonus(aSpell, spellType, className, iLev + pcBonusLevel);
            } else {
                iLev = this.getTotalCasterLevelWithSpellBonus(aSpell, spellType, className, pcBonusLevel);
            }
            valString = Integer.toString(iLev);
        } else if ("CASTERLEVEL".equals(valString)) {
            Logging.debugPrint("src for CASTERLEVEL: " + src);
        } else if ("CL".equals(valString) && src.startsWith("CLASS:")) {
            valString = this.getClassLevelString(src.substring(6), false);
        } else if (valString.startsWith("CL=") || valString.startsWith("CL.")) {
            valString = this.getClassLevelString(valString.substring(3), false);
        } else if ((valString.startsWith("CL;BEFORELEVEL=") || valString.startsWith("CL;BEFORELEVEL.")) && src.startsWith("CLASS:")) {
            valString = this.getClassLevelString(src.substring(6) + valString.substring(2), false);
        } else if ("BL".equals(valString) && src.startsWith("CLASS:")) {
            valString = Integer.toString((int)this.getTotalBonusTo("PCLEVEL", src.substring(6)));
        } else if (valString.startsWith("BL=") || valString.startsWith("BL.")) {
            valString = Integer.toString((int)this.getTotalBonusTo("PCLEVEL", valString.substring(3)));
        } else if ("BAB".equals(valString)) {
            valString = Integer.toString(this.baseAttackBonus());
        } else if (valString.startsWith("CLASSLEVEL=") || valString.startsWith("CLASSLEVEL.")) {
            valString = this.getClassLevelString(valString.substring(11), true);
        } else if (valString.startsWith("CLASS=") || valString.startsWith("CLASS.")) {
            PCClass aClass = null;
            if (valString.length() > 6) {
                aClass = this.getClassNamed(valString.substring(6));
            } else {
                Logging.errorPrint("Error! Cannot determine CLASS!");
            }
            valString = aClass != null ? "1" : "0";
        } else if (valString.startsWith("SKILLRANK=") || valString.startsWith("SKILLRANK.")) {
            Skill aSkill = this.getSkillNamed(valString.substring(10).replace('{', '(').replace('}', ')'));
            valString = aSkill != null ? aSkill.getRank().toString() : "0";
        } else if ("TL".equals(valString)) {
            valString = Integer.toString(this.getTotalLevels());
        } else if ("HD".equals(valString)) {
            valString = Integer.toString(this.totalHitDice());
        } else if ("PROFACCHECK".equals(valString) && src.startsWith("EQ:")) {
            Equipment eq = EquipmentList.getEquipmentNamed(src.substring(3));
            valString = eq != null && !this.isProficientWith(eq) ? Integer.toString(eq.acCheck(this)) : "0";
        } else if ("ACCHECK".equals(valString) || "ACHECK".equals(valString)) {
            Equipment eq;
            int maxCheck = 0;
            Iterator e = this.getEquipmentOfType("Armor", 1).iterator();
            while (e.hasNext()) {
                eq = (Equipment)e.next();
                maxCheck += eq.acCheck(this).intValue();
            }
            e = this.getEquipmentOfType("Shield", 1).iterator();
            while (e.hasNext()) {
                eq = (Equipment)e.next();
                maxCheck += eq.acCheck(this).intValue();
            }
            valString = Integer.toString(maxCheck);
        } else if ("ARMORACCHECK".equals(valString) || "ARMORACHECK".equals(valString)) {
            int maxCheck = 0;
            Iterator e = this.getEquipmentOfType("Armor", 1).iterator();
            while (e.hasNext()) {
                Equipment eq = (Equipment)e.next();
                maxCheck += eq.acCheck(this).intValue();
            }
            valString = Integer.toString(maxCheck);
        } else if ("SHIELDACCHECK".equals(valString) || "SHIELDACHECK".equals(valString)) {
            int maxCheck = 0;
            Iterator e = this.getEquipmentOfType("Shield", 1).iterator();
            while (e.hasNext()) {
                Equipment eq = (Equipment)e.next();
                maxCheck += eq.acCheck(this).intValue();
            }
            valString = Integer.toString(maxCheck);
        } else if ("SIZE".equals(valString)) {
            valString = String.valueOf(this.sizeInt());
        } else if ("SIZEMOD".equals(valString)) {
            valString = String.valueOf((int)this.getSizeAdjustmentBonusTo("COMBAT", "AC"));
        } else if ("ENCUMBERANCE".equals(valString)) {
            valString = String.valueOf(Globals.loadTypeForLoadScore(this.getVariableValue("LOADSCORE", "").intValue(), this.totalWeight(), this));
        } else if ("MOVEBASE".equals(valString)) {
            valString = this.getRace().getMovement().toString();
        } else if (valString.startsWith("MOVE[")) {
            String moveString = valString.substring(5, valString.lastIndexOf("]"));
            valString = String.valueOf(this.movementOfType(moveString));
        } else if ("COUNT[ATTACKS]".equals(valString)) {
            valString = Integer.toString(this.getNumAttacks());
        } else if ("COUNT[CHECKS]".equals(valString)) {
            valString = String.valueOf(SettingsHandler.getGame().getUnmodifiableCheckList().size());
        } else if ("COUNT[FOLLOWERS]".equals(valString)) {
            valString = Integer.toString(this.getFollowerList().size());
        } else if ("COUNT[STATS]".equals(valString)) {
            valString = Integer.toString(SettingsHandler.getGame().s_ATTRIBLONG.length);
        } else if ("COUNT[SKILLS]".equals(valString)) {
            ArrayList skillList = this.getSkillListInOutputOrder();
            skillList.trimToSize();
            valString = Integer.toString(skillList.size());
        } else if ("COUNT[FEATS.ALL]".equals(valString)) {
            this.featList.trimToSize();
            valString = Integer.toString(this.featList.size());
        } else if ("COUNT[FEATS.HIDDEN]".equals(valString)) {
            valString = Integer.toString(this.countVisibleFeats(this.featList, false, true));
        } else if ("COUNT[FEATS]".equals(valString) || "COUNT[FEATS.VISIBLE]".equals(valString)) {
            valString = Integer.toString(this.countVisibleFeats(this.featList, true, false));
        } else if ("COUNT[VFEATS.ALL]".equals(valString)) {
            valString = Integer.toString(this.getVirtualFeatList().size());
        } else if ("COUNT[VFEATS.HIDDEN]".equals(valString)) {
            valString = Integer.toString(this.countVisibleFeats(this.getVirtualFeatList(), false, true));
        } else if ("COUNT[VFEATS]".equals(valString) || "COUNT[VFEATS.VISIBLE]".equals(valString)) {
            valString = Integer.toString(this.countVisibleFeats(this.getVirtualFeatList(), true, false));
        } else if ("COUNT[FEATSAUTO.ALL]".equals(valString)) {
            valString = Integer.toString(this.featAutoList().size());
        } else if ("COUNT[FEATSAUTO]".equals(valString) || "COUNT[FEATSAUTO.VISIBLE]".equals(valString)) {
            valString = Integer.toString(this.countVisibleFeats(this.featAutoList(), true, false));
        } else if ("COUNT[FEATSAUTO.HIDDEN]".equals(valString)) {
            valString = Integer.toString(this.countVisibleFeats(this.featAutoList(), false, true));
        } else if ("COUNT[FEATSALL]".equals(valString) || "COUNT[FEATSALL.VISIBLE]".equals(valString)) {
            valString = Integer.toString(this.aggregateVisibleFeatList().size());
        } else if ("COUNT[FEATSALL.ALL]".equals(valString)) {
            valString = Integer.toString(this.aggregateFeatList().size());
        } else if ("COUNT[FEATSALL.HIDDEN]".equals(valString)) {
            valString = Integer.toString(this.countVisibleFeats(this.aggregateFeatList(), false, true));
        } else if ((valString.startsWith("COUNT[FEATTYPE=") || valString.startsWith("COUNT[FEATTYPE.")) && valString.endsWith(".ALL]")) {
            List featTypes = CoreUtility.split(valString.substring(15, valString.length() - 5), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.aggregateFeatList(), featTypes, true, true));
        } else if ((valString.startsWith("COUNT[FEATTYPE=") || valString.startsWith("COUNT[FEATTYPE.")) && valString.endsWith(".HIDDEN]")) {
            List featTypes = CoreUtility.split(valString.substring(15, valString.length() - 8), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.aggregateFeatList(), featTypes, false, true));
        } else if ((valString.startsWith("COUNT[FEATTYPE=") || valString.startsWith("COUNT[FEATTYPE.")) && valString.endsWith(".VISIBLE]")) {
            List featTypes = CoreUtility.split(valString.substring(15, valString.length() - 9), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.aggregateFeatList(), featTypes, true, false));
        } else if ((valString.startsWith("COUNT[FEATTYPE=") || valString.startsWith("COUNT[FEATTYPE.")) && valString.endsWith("]")) {
            List featTypes = CoreUtility.split(valString.substring(15, valString.length() - 1), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.aggregateFeatList(), featTypes, true, false));
        } else if ((valString.startsWith("COUNT[VFEATTYPE=") || valString.startsWith("COUNT[VFEATTYPE.")) && valString.endsWith(".ALL]")) {
            List featTypes = CoreUtility.split(valString.substring(16, valString.length() - 5), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.getVirtualFeatList(), featTypes, true, true));
        } else if ((valString.startsWith("COUNT[VFEATTYPE=") || valString.startsWith("COUNT[VFEATTYPE.")) && valString.endsWith(".HIDDEN]")) {
            List featTypes = CoreUtility.split(valString.substring(16, valString.length() - 8), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.getVirtualFeatList(), featTypes, false, true));
        } else if ((valString.startsWith("COUNT[VFEATTYPE=") || valString.startsWith("COUNT[VFEATTYPE.")) && valString.endsWith(".VISIBLE]")) {
            List featTypes = CoreUtility.split(valString.substring(16, valString.length() - 9), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.getVirtualFeatList(), featTypes, true, false));
        } else if ((valString.startsWith("COUNT[VFEATTYPE=") || valString.startsWith("COUNT[VFEATTYPE.")) && valString.endsWith("]")) {
            List featTypes = CoreUtility.split(valString.substring(16, valString.length() - 1), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.getVirtualFeatList(), featTypes, true, false));
        } else if ((valString.startsWith("COUNT[FEATAUTOTYPE=") || valString.startsWith("COUNT[FEATAUTOTYPE.")) && valString.endsWith(".ALL]")) {
            List featTypes = CoreUtility.split(valString.substring(19, valString.length() - 5), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.featAutoList(), featTypes, true, true));
        } else if ((valString.startsWith("COUNT[FEATAUTOTYPE=") || valString.startsWith("COUNT[FEATAUTOTYPE.")) && valString.endsWith(".HIDDEN]")) {
            List featTypes = CoreUtility.split(valString.substring(19, valString.length() - 8), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.featAutoList(), featTypes, false, true));
        } else if ((valString.startsWith("COUNT[FEATAUTOTYPE=") || valString.startsWith("COUNT[FEATAUTOTYPE.")) && valString.endsWith(".VISIBLE]")) {
            List featTypes = CoreUtility.split(valString.substring(19, valString.length() - 9), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.featAutoList(), featTypes, true, false));
        } else if ((valString.startsWith("COUNT[FEATAUTOTYPE=") || valString.startsWith("COUNT[FEATAUTOTYPE.")) && valString.endsWith("]")) {
            List featTypes = CoreUtility.split(valString.substring(19, valString.length() - 1), '.');
            valString = Integer.toString(this.countVisibleFeatTypes(this.featAutoList(), featTypes, true, false));
        } else if ((valString.startsWith("COUNT[FEATNAME=") || valString.startsWith("COUNT[FEATNAME.")) && valString.endsWith(".ALL]")) {
            String featName = valString.substring(15, valString.length() - 5);
            valString = Integer.toString(this.countVisibleFeatNames(this.aggregateFeatList(), featName, true, true));
        } else if ((valString.startsWith("COUNT[FEATNAME=") || valString.startsWith("COUNT[FEATNAME.")) && valString.endsWith(".HIDDEN]")) {
            String featName = valString.substring(15, valString.length() - 8);
            valString = Integer.toString(this.countVisibleFeatNames(this.aggregateFeatList(), featName, false, true));
        } else if ((valString.startsWith("COUNT[FEATNAME=") || valString.startsWith("COUNT[FEATNAME.")) && valString.endsWith(".VISIBLE]")) {
            String featName = valString.substring(15, valString.length() - 9);
            valString = Integer.toString(this.countVisibleFeatNames(this.aggregateFeatList(), featName, true, false));
        } else if ((valString.startsWith("COUNT[FEATNAME=") || valString.startsWith("COUNT[FEATNAME.")) && valString.endsWith("]")) {
            String featName = valString.substring(15, valString.length() - 1);
            valString = Integer.toString(this.countVisibleFeatNames(this.aggregateFeatList(), featName, true, false));
        } else if (valString.startsWith("COUNT[SPELLSKNOWN") && valString.endsWith("]")) {
            int spellCount = 0;
            if (SettingsHandler.getPrintSpellsWithPC()) {
                spellCount = this.countSpellListBook(valString);
            }
            valString = Integer.toString(spellCount);
        } else if (valString.startsWith("COUNT[SPELLSINBOOK") && valString.endsWith("]")) {
            valString = valString.substring(18);
            valString = valString.substring(0, valString.length() - 1);
            int sbookCount = 0;
            if (SettingsHandler.getPrintSpellsWithPC()) {
                sbookCount = this.countSpellsInBook(valString);
            }
            valString = Integer.toString(sbookCount);
        } else if (valString.startsWith("COUNT[SPELLSLEVELSINBOOK") && valString.endsWith("]")) {
            valString = valString.substring(24);
            valString = valString.substring(0, valString.length() - 1);
            int sbookCount = this.countSpellLevelsInBook(valString);
            valString = Integer.toString(sbookCount);
        } else if (valString.startsWith("COUNT[SPELLTIMES") && valString.endsWith("]")) {
            valString = valString.substring(6);
            valString = valString.substring(0, valString.length() - 1);
            valString = String.valueOf(this.countSpellTimes(valString));
        } else if (valString.startsWith("COUNT[SPELLBOOKS") && valString.endsWith("]")) {
            valString = Integer.toString(this.getSpellBooks().size());
        } else if ("COUNT[SPELLCLASSES]".equals(valString)) {
            valString = String.valueOf(this.getSpellClassCount());
        } else if ("COUNT[SPELLRACE]".equals(valString)) {
            PObject aSpellRace = this.getSpellClassAtIndex(0);
            valString = aSpellRace instanceof Race ? "1" : "0";
        } else if ("COUNT[TEMPBONUSNAMES]".equals(valString)) {
            valString = String.valueOf(this.getNamedTempBonusList().size());
        } else if ("COUNT[CLASSES]".equals(valString)) {
            this.classList.trimToSize();
            int iCount = this.classList.size();
            if (SettingsHandler.hideMonsterClasses()) {
                Iterator ee = this.classList.iterator();
                while (ee.hasNext()) {
                    PCClass aClass = (PCClass)ee.next();
                    if (!aClass.isMonster()) continue;
                    --iCount;
                }
            }
            valString = Integer.toString(iCount);
        } else if ("COUNT[DOMAINS]".equals(valString)) {
            valString = Integer.toString(this.characterDomainList.size());
        } else if (valString.startsWith("COUNT[EQUIPMENT") && valString.endsWith("]")) {
            int merge = 0;
            if (valString.indexOf("MERGENONE") > 0) {
                merge = 1;
            } else if (valString.indexOf("MERGELOC") > 0) {
                merge = 2;
            }
            ArrayList<Equipment> aList = new ArrayList<Equipment>();
            if (!this.getEquipmentListInOutputOrder(merge).isEmpty()) {
                Iterator e = this.getEquipmentListInOutputOrder(merge).iterator();
                while (e.hasNext()) {
                    Equipment eq = (Equipment)e.next();
                    aList.add(eq);
                }
            }
            if ("COUNT[EQUIPMENT]".equals(valString)) {
                valString = Integer.toString(aList.size());
            } else {
                StringTokenizer bTok = new StringTokenizer(valString.substring(16, valString.length() - 1), ".");
                while (bTok.hasMoreTokens()) {
                    String bString = bTok.nextToken();
                    if ("NOT".equalsIgnoreCase(bString)) {
                        aList = new ArrayList(PlayerCharacter.removeEqType(aList, bTok.nextToken()));
                        continue;
                    }
                    if ("ADD".equalsIgnoreCase(bString)) {
                        aList = new ArrayList(this.addEqType(aList, bTok.nextToken()));
                        continue;
                    }
                    if (!"IS".equalsIgnoreCase(bString)) continue;
                    aList = new ArrayList(PlayerCharacter.removeNotEqType(aList, bTok.nextToken()));
                }
                valString = Integer.toString(aList.size());
            }
            aList.clear();
        } else if (valString.startsWith("COUNT[EQTYPE.") && valString.endsWith("]")) {
            Iterator e;
            int merge = 0;
            List<Equipment> aList = new ArrayList();
            StringTokenizer bTok = new StringTokenizer(valString.substring(13, valString.length() - 1), ".");
            String aType = bTok.nextToken();
            if ("MERGENONE".equals(aType)) {
                merge = 1;
                aType = bTok.nextToken();
            } else if ("MERGELOC".equals(aType)) {
                merge = 2;
                aType = bTok.nextToken();
            }
            if ("CONTAINER".equals(aType)) {
                aList.clear();
                if (!this.getEquipmentListInOutputOrder(merge).isEmpty()) {
                    e = this.getEquipmentListInOutputOrder(merge).iterator();
                    while (e.hasNext()) {
                        Equipment eq = (Equipment)e.next();
                        if (!eq.acceptsChildren()) continue;
                        aList.add(eq);
                    }
                }
            } else if ("WEAPON".equalsIgnoreCase(aType)) {
                aList = this.getExpandedWeapons(merge);
            } else if ("ACITEM".equalsIgnoreCase(aType)) {
                if (!this.getEquipmentListInOutputOrder(merge).isEmpty()) {
                    e = this.getEquipmentListInOutputOrder(merge).iterator();
                    while (e.hasNext()) {
                        Equipment eq = (Equipment)e.next();
                        if (!eq.getBonusListString("AC") || eq.isArmor() || eq.isShield()) continue;
                        aList.add(eq);
                    }
                }
            } else {
                aList = this.getEquipmentOfTypeInOutputOrder(aType, 3, merge);
            }
            while (bTok.hasMoreTokens()) {
                String bString = bTok.nextToken();
                if ("NOT".equalsIgnoreCase(bString)) {
                    aList = new ArrayList(PlayerCharacter.removeEqType(aList, bTok.nextToken()));
                    continue;
                }
                if ("ADD".equalsIgnoreCase(bString)) {
                    aList = new ArrayList(this.addEqType(aList, bTok.nextToken()));
                    continue;
                }
                if ("IS".equalsIgnoreCase(bString)) {
                    aList = new ArrayList(PlayerCharacter.removeNotEqType(aList, bTok.nextToken()));
                    continue;
                }
                if (!"EQUIPPED".equalsIgnoreCase(bString) && !"NOTEQUIPPED".equalsIgnoreCase(bString)) continue;
                boolean eFlag = "EQUIPPED".equalsIgnoreCase(bString);
                for (int ix = aList.size() - 1; ix >= 0; --ix) {
                    Equipment anEquip = (Equipment)aList.get(ix);
                    if (anEquip.isEquipped() == eFlag) continue;
                    aList.remove(anEquip);
                }
            }
            valString = Integer.toString(aList.size());
            aList.clear();
        } else if ("COUNT[CONTAINERS]".equals(valString)) {
            int merge = 0;
            ArrayList<Equipment> aList = new ArrayList<Equipment>();
            if (!this.getEquipmentListInOutputOrder(merge).isEmpty()) {
                aList.clear();
                Iterator e = this.getEquipmentListInOutputOrder(merge).iterator();
                while (e.hasNext()) {
                    Equipment eq = (Equipment)e.next();
                    if (!eq.acceptsChildren()) continue;
                    aList.add(eq);
                }
            }
            valString = Integer.toString(aList.size());
            aList.clear();
        } else if ("COUNT[SA]".equals(valString)) {
            this.specialAbilityList.trimToSize();
            valString = String.valueOf(this.getSpecialAbilityTimesList().size());
        } else if ("COUNT[TEMPLATES]".equals(valString)) {
            this.templateList.trimToSize();
            valString = String.valueOf(this.getTemplateList().size());
        } else if ("COUNT[VISIBLETEMPLATES]".equals(valString)) {
            int count = 0;
            Iterator it = this.getTemplateList().iterator();
            while (it.hasNext()) {
                int visibility = ((PCTemplate)it.next()).isVisible();
                if (visibility != 1 && visibility != 2) continue;
                ++count;
            }
            valString = Integer.toString(count);
        } else if ("COUNT[LANGUAGES]".equals(valString)) {
            valString = Integer.toString(this.getLanguagesList().size());
        } else if ("COUNT[NOTES]".equals(valString)) {
            valString = Integer.toString(this.getNotesList().size());
        } else if (valString.startsWith("COUNT[FOLLOWERTYPE.") && valString.endsWith("]")) {
            if (valString.indexOf(".") == valString.lastIndexOf(".")) {
                int countFollower = 0;
                String bString = valString.substring(19);
                bString = bString.substring(0, bString.length() - 1);
                Iterator iter = this.getFollowerList().iterator();
                while (iter.hasNext()) {
                    Follower aFollower = (Follower)iter.next();
                    if (!aFollower.getType().equalsIgnoreCase(bString)) continue;
                    ++countFollower;
                }
                valString = String.valueOf(countFollower);
            } else {
                List followers = this.getFollowerList();
                if (!followers.isEmpty()) {
                    StringTokenizer aTok = new StringTokenizer(valString, "[]");
                    aTok.nextToken();
                    String aString = aTok.nextToken();
                    aTok = new StringTokenizer(aString, ".");
                    aTok.nextToken();
                    String typeString = aTok.nextToken();
                    String restString = "";
                    int followerIndex = -1;
                    if (aTok.hasMoreTokens()) {
                        restString = aTok.nextToken();
                        followerIndex = Integer.parseInt(restString);
                        restString = "";
                        while (aTok.hasMoreTokens()) {
                            restString = restString + "." + aTok.nextToken();
                        }
                        if (restString.indexOf(".") == 0) {
                            restString = restString.substring(1);
                        }
                    }
                    restString = "COUNT[" + restString + "]";
                    ArrayList<Follower> aList = new ArrayList<Follower>();
                    for (int x = followers.size() - 1; x >= 0; --x) {
                        Follower fol = (Follower)followers.get(x);
                        if (!fol.getType().equalsIgnoreCase(typeString)) continue;
                        aList.add(fol);
                    }
                    if (followerIndex < aList.size() && aList.get(followerIndex) instanceof Follower) {
                        Follower aF = (Follower)aList.get(followerIndex);
                        Iterator p = Globals.getPCList().iterator();
                        while (p.hasNext()) {
                            PlayerCharacter nPC = (PlayerCharacter)p.next();
                            if (!aF.getFileName().equals(nPC.getFileName())) continue;
                            PlayerCharacter currentPC = this;
                            Globals.setCurrentPC(nPC);
                            valString = nPC.getVariableValue(restString, "").toString();
                            Globals.setCurrentPC(currentPC);
                        }
                    }
                }
            }
        } else if (valString.startsWith("EQTYPE")) {
            EqTypeToken token = new EqTypeToken();
            valString = token.getToken(valString, this);
        } else if (valString.startsWith("VARDEFINED:")) {
            valString = this.hasVariable(valString.substring(11).trim()) ? "1" : "0";
        } else if (valString.startsWith("HASFEAT:")) {
            valString = this.hasFeat(valString = valString.substring(8).trim()) ? "1" : "0";
        } else if (valString.startsWith("HASDEITY:")) {
            valString = this.hasDeity(valString = valString.substring(9).trim()) ? "1" : "0";
        } else if (valString.startsWith("MODEQUIP")) {
            valString = String.valueOf(this.modToFromEquipment(valString.substring(8)));
        } else if (valString.startsWith("WEIGHT.")) {
            if ("CARRIED".equals(valString = valString.substring(7))) {
                valString = this.totalWeight().toString();
            } else if ("EQUIPPED".equals(valString)) {
                valString = this.totalWeight().toString();
            } else if ("PC".equals(valString)) {
                valString = String.valueOf(this.getWeight());
            } else if ("TOTAL".equals(valString)) {
                Float aTotal = new Float(this.totalWeight().floatValue() + new Float(this.getWeight()).floatValue());
                valString = aTotal.toString();
            }
        } else if (valString.startsWith("PC.SIZE")) {
            Equipment eq;
            int modSize = 0;
            if (src.startsWith("EQ:") && (eq = this.getEquipmentNamed(src.substring(3))) != null) {
                modSize = (int)this.getTotalBonusTo("WEAPONPROF=" + eq.profName(0, this), "PCSIZE");
            }
            if (valString.equals("PC.SIZE")) {
                valString = this.getSize();
            } else if (valString.substring(8).equals("INT")) {
                valString = String.valueOf(this.sizeInt() + modSize);
            }
        } else {
            valString = null;
        }
        return valString;
    }

    private int getTotalCasterLevelWithSpellBonus(Spell aSpell, String spellType, String classOrRace, int casterLev) {
        Map domainMap;
        int z;
        int tBonus = casterLev;
        String tType = null;
        String tStr = null;
        ArrayList<CasterLevelSpellBonus> bonuses = new ArrayList<CasterLevelSpellBonus>();
        boolean replaceCasterLevel = false;
        if (classOrRace != null) {
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", classOrRace);
            if (tBonus > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", classOrRace);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if (!classOrRace.startsWith("RACE.") && (tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = "CLASS." + classOrRace)) > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
        }
        if (aSpell == null) {
            return tBonus;
        }
        if (!spellType.equals("None")) {
            tStr = "TYPE." + spellType;
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
            if (tBonus > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) > 0) {
                replaceCasterLevel = true;
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
        }
        if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = "SPELL." + aSpell.getName())) > 0) {
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) > 0) {
            replaceCasterLevel = true;
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        SortedSet school = aSpell.getSchools();
        Iterator i = school.iterator();
        while (i.hasNext()) {
            String sName = (String)i.next();
            tStr = "SCHOOL." + sName;
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
            if (tBonus > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) <= 0) continue;
            replaceCasterLevel = true;
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        SortedSet subschool = aSpell.getSubschools();
        Iterator i2 = subschool.iterator();
        while (i2.hasNext()) {
            String sName = (String)i2.next();
            tStr = "SUBSCHOOL." + sName;
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
            if (tBonus > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) <= 0) continue;
            replaceCasterLevel = true;
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        List descList = aSpell.getDescriptorList();
        if (descList != null) {
            boolean descriptorBonus = false;
            for (z = 0; z < descList.size(); ++z) {
                tStr = "DESCRIPTOR." + (String)descList.get(z);
                tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
                if (tBonus > 0) {
                    tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                    bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
                }
                if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) <= 0) continue;
                replaceCasterLevel = true;
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
        }
        if ((domainMap = aSpell.getLevelInfo(this)) != null) {
            Iterator mapKeys = domainMap.keySet().iterator();
            while (mapKeys.hasNext()) {
                String mKey = (String)mapKeys.next();
                if (!mKey.startsWith("DOMAIN|")) continue;
                tStr = "DOMAIN." + mKey.substring(7);
                tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
                if (tBonus > 0) {
                    tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                    bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
                }
                if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) <= 0) continue;
                replaceCasterLevel = true;
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
        }
        for (z = 0; z < bonuses.size() - 1; ++z) {
            CasterLevelSpellBonus zBonus = (CasterLevelSpellBonus)bonuses.get(z);
            String zType = zBonus.getType();
            if (zBonus.getBonus() == 0 || zType.equals("")) continue;
            boolean zReplace = false;
            boolean zStack = false;
            if (zType.endsWith(".REPLACE")) {
                zType = zType.substring(0, zType.length() - 8);
                zReplace = true;
            } else if (zType.endsWith(".STACK")) {
                zType = zType.substring(0, zType.length() - 6);
                zStack = true;
            }
            for (int k = z + 1; k < bonuses.size(); ++k) {
                CasterLevelSpellBonus kBonus = (CasterLevelSpellBonus)bonuses.get(k);
                String kType = kBonus.getType();
                if (kBonus.getBonus() == 0 || kType.equals("")) continue;
                boolean kReplace = false;
                boolean kStack = false;
                if (kType.endsWith(".REPLACE")) {
                    kType = kType.substring(0, kType.length() - 8);
                    kReplace = true;
                } else if (kType.endsWith(".STACK")) {
                    kType = kType.substring(0, kType.length() - 6);
                    kStack = true;
                }
                if (!zType.equals(kType)) continue;
                if (zReplace && kReplace) {
                    kBonus.setBonus(zBonus.getBonus() + kBonus.getBonus());
                    zBonus.setBonus(0);
                    continue;
                }
                if (zStack || kStack) continue;
                if (zBonus.getBonus() > kBonus.getBonus()) {
                    kBonus.setBonus(0);
                    continue;
                }
                zBonus.setBonus(0);
            }
        }
        int result = 0;
        if (!replaceCasterLevel) {
            result += casterLev;
        }
        for (int z2 = 0; z2 < bonuses.size(); ++z2) {
            CasterLevelSpellBonus resultBonus = (CasterLevelSpellBonus)bonuses.get(z2);
            result += resultBonus.getBonus();
        }
        return result;
    }

    private String getSpellBonusType(String bonusType, String bonusName) {
        String prefix = bonusType + '.' + bonusName;
        prefix = prefix.toUpperCase();
        Iterator i = this.getActiveBonusMap().keySet().iterator();
        while (i.hasNext()) {
            String aKey;
            String rString = aKey = i.next().toString();
            String tString = aKey;
            if (rString.endsWith(".STACK")) {
                tString = rString.substring(0, rString.length() - 6);
            } else if (rString.endsWith(".REPLACE")) {
                tString = rString.substring(0, rString.length() - 8);
            }
            if (tString.length() > prefix.length() && !tString.startsWith(prefix + ":") || !tString.startsWith(prefix)) continue;
            int typeIndex = tString.indexOf(":");
            if (typeIndex > 0) {
                return rString.substring(typeIndex + 1);
            }
            return "";
        }
        return "";
    }

    public List getVirtualFeatList() {
        Feat aFeat;
        Iterator e1;
        List aList;
        Feat aFeat2;
        Iterator i;
        ArrayList<Feat> vFeatList = this.getStableVirtualFeatList();
        if (vFeatList != null) {
            return vFeatList;
        }
        this.setVirtualFeatsStable(true);
        vFeatList = new ArrayList<Feat>();
        if (this.stableVirtualFeatList != null) {
            i = this.stableVirtualFeatList.iterator();
            while (i.hasNext()) {
                aFeat2 = (Feat)i.next();
                if (!aFeat2.needsSaving() || !PrereqHandler.passesAll(aFeat2.getPreReqList(), this, aFeat2)) continue;
                vFeatList.add(aFeat2);
            }
        }
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            aList = aClass.getVirtualFeatList(aClass.getLevel());
            e1 = aList.iterator();
            while (e1.hasNext()) {
                aFeat = (Feat)e1.next();
                if (!PrereqHandler.passesAll(aFeat.getPreReqList(), this, aFeat)) continue;
                vFeatList.add(aFeat);
            }
        }
        e = this.featList.iterator();
        while (e.hasNext()) {
            aFeat2 = (Feat)e.next();
            aList = aFeat2.getVirtualFeatList();
            e1 = aList.iterator();
            while (e1.hasNext()) {
                Feat bFeat = (Feat)e1.next();
                if (!PrereqHandler.passesAll(aFeat2.getPreReqList(), this, aFeat2)) continue;
                vFeatList.add(bFeat);
            }
        }
        e = this.templateList.iterator();
        while (e.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)e.next();
            aList = aTemplate.getVirtualFeatList();
            e1 = aList.iterator();
            while (e1.hasNext()) {
                aFeat = (Feat)e1.next();
                if (!PrereqHandler.passesAll(aFeat.getPreReqList(), this, aFeat)) continue;
                vFeatList.add(aFeat);
            }
        }
        if (!this.equipmentList.isEmpty()) {
            e = this.equipmentList.iterator();
            while (e.hasNext()) {
                Equipment aE = (Equipment)e.next();
                if (!aE.isEquipped()) continue;
                Iterator e12 = aE.getVirtualFeatList().iterator();
                while (e12.hasNext()) {
                    Feat aFeat3 = (Feat)e12.next();
                    if (!PrereqHandler.passesAll(aFeat3.getPreReqList(), this, aFeat3)) continue;
                    vFeatList.add(aFeat3);
                }
            }
        }
        if (this.getRace() != null) {
            e = this.getRace().getVirtualFeatList().iterator();
            while (e.hasNext()) {
                aFeat2 = (Feat)e.next();
                if (!PrereqHandler.passesAll(aFeat2.getPreReqList(), this, aFeat2)) continue;
                vFeatList.add(aFeat2);
            }
        }
        if (!this.getFollowerList().isEmpty()) {
            Iterator fm = this.getFollowerList().iterator();
            while (fm.hasNext()) {
                Follower aF = (Follower)fm.next();
                String rType = aF.getType().toUpperCase();
                String rName = aF.getRace().toUpperCase();
                Iterator cm = Globals.getCompanionModList().iterator();
                while (cm.hasNext()) {
                    CompanionMod aComp = (CompanionMod)cm.next();
                    String aType = aComp.getType().toUpperCase();
                    int iRace = aComp.getLevel(rName);
                    if (!aType.equals(rType) || iRace != 1 || aComp.getVirtualFeatList().isEmpty()) continue;
                    Iterator v1 = aComp.getVirtualFeatList().iterator();
                    while (v1.hasNext()) {
                        Feat aFeat4 = (Feat)v1.next();
                        if (!PrereqHandler.passesAll(aFeat4.getPreReqList(), this, aFeat4)) continue;
                        vFeatList.add(aFeat4);
                    }
                }
            }
        }
        i = this.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            aList = aSkill.getVirtualFeatList();
            e1 = aList.iterator();
            while (e1.hasNext()) {
                aFeat = (Feat)e1.next();
                if (!PrereqHandler.passesAll(aFeat.getPreReqList(), this, aFeat)) continue;
                vFeatList.add(aFeat);
            }
        }
        i = this.characterDomainList.iterator();
        while (i.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)i.next();
            if (aCD.getDomain() == null) continue;
            aList = aCD.getDomain().getVirtualFeatList();
            e1 = aList.iterator();
            while (e1.hasNext()) {
                aFeat = (Feat)e1.next();
                if (!PrereqHandler.passesAll(aFeat.getPreReqList(), this, aFeat)) continue;
                vFeatList.add(aFeat);
            }
        }
        if (this.deity != null) {
            List aList2 = this.deity.getVirtualFeatList();
            Iterator e13 = aList2.iterator();
            while (e13.hasNext()) {
                Feat aFeat5 = (Feat)e13.next();
                if (!PrereqHandler.passesAll(aFeat5.getPreReqList(), this, aFeat5)) continue;
                vFeatList.add(aFeat5);
            }
        }
        if (!this.companionModList.isEmpty()) {
            Iterator e2 = this.companionModList.iterator();
            while (e2.hasNext()) {
                CompanionMod aMod = (CompanionMod)e2.next();
                aList = aMod.getVirtualFeatList();
                e1 = aList.iterator();
                while (e1.hasNext()) {
                    aFeat = (Feat)e1.next();
                    if (!PrereqHandler.passesAll(aFeat.getPreReqList(), this, aFeat)) continue;
                    vFeatList.add(aFeat);
                }
            }
        }
        this.setStableVirtualFeatList(vFeatList);
        return vFeatList;
    }

    public String getVision() {
        Map visMap = new HashMap();
        if (this.race != null) {
            visMap = this.addStringToVisionMap(visMap, this.race.getVision(this));
        }
        if (this.deity != null) {
            visMap = this.addStringToVisionMap(visMap, this.deity.getVision(this));
        }
        Iterator<Object> i = this.classList.iterator();
        while (i.hasNext()) {
            PCClass aClass = (PCClass)i.next();
            visMap = this.addStringToVisionMap(visMap, aClass.getVision(this));
        }
        i = this.featList.iterator();
        while (i.hasNext()) {
            Feat aFeat = (Feat)i.next();
            visMap = this.addStringToVisionMap(visMap, aFeat.getVision(this));
        }
        i = this.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            visMap = this.addStringToVisionMap(visMap, aSkill.getVision(this));
        }
        i = this.characterDomainList.iterator();
        while (i.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)i.next();
            if (aCD.getDomain() == null) continue;
            visMap = this.addStringToVisionMap(visMap, aCD.getDomain().getVision(this));
        }
        Iterator e = this.equipmentList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            visMap = this.addStringToVisionMap(visMap, eq.getVision(this));
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    visMap = this.addStringToVisionMap(visMap, eqMod.getVision(this));
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                visMap = this.addStringToVisionMap(visMap, eqMod.getVision(this));
            }
        }
        i = this.templateList.iterator();
        while (i.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)i.next();
            visMap = this.addStringToVisionMap(visMap, aTemplate.getVision(this));
        }
        i = Globals.getVisionMap().keySet().iterator();
        while (i.hasNext()) {
            String aKey = (String)i.next();
            int aVal = (int)this.getTotalBonusTo("VISION", aKey);
            if (aVal <= 0) continue;
            HashMap<String, String> newMap = new HashMap<String, String>();
            newMap.put(aKey, "0");
            visMap = this.addStringToVisionMap(visMap, newMap);
        }
        StringBuffer vision = new StringBuffer();
        Iterator i2 = visMap.keySet().iterator();
        while (i2.hasNext()) {
            String aKey = i2.next().toString();
            Object bObj = visMap.get(aKey);
            if (bObj == null) continue;
            int val = Integer.parseInt(bObj.toString());
            if (vision.length() > 0) {
                vision.append(", ");
            }
            vision.append(aKey);
            if (val <= 0) continue;
            vision.append(" (").append(val).append("')");
        }
        return vision.toString();
    }

    public int abilityAC() {
        return this.calcACOfType("Ability");
    }

    public void addCharacterDomain(CharacterDomain aCD) {
        if (aCD != null && !this.characterDomainList.contains(aCD) && aCD.getDomain() != null) {
            this.characterDomainList.add(aCD);
            PCClass domainClass = this.getClassNamed(aCD.getObjectName());
            if (domainClass != null) {
                int _maxLevel = domainClass.getMaxCastLevel();
                aCD.getDomain().addSpellsToClassForLevels(domainClass, 0, _maxLevel);
            }
            this.setDirty(true);
        }
    }

    public void addDomainSource(String aType, String aName, int aLevel, int dNum) {
        String aString = aType + "|" + aName + "|" + aLevel;
        String sNum = Integer.toString(dNum);
        this.domainSourceMap.put(aString, sNum);
        this.setDirty(true);
    }

    public List addEqType(List aList, String aString) {
        Iterator e = this.getEquipmentList().iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (eq.typeStringContains(aString)) {
                aList.add(eq);
                this.setDirty(true);
                continue;
            }
            if (!aString.equalsIgnoreCase("CONTAINED") || eq.getParent() == null) continue;
            aList.add(eq);
            this.setDirty(true);
        }
        return aList;
    }

    public void addKit(Kit aKit) {
        if (this.kitList == null) {
            this.kitList = new ArrayList();
        }
        this.kitList.add(aKit);
        this.setDirty(true);
    }

    public void addLanguage(String aString) {
        Language aLang = Globals.getLanguageNamed(aString);
        if (aLang != null && !this.getLanguagesList().contains(aLang)) {
            this.getLanguagesList().add(aLang);
            this.setDirty(true);
        }
    }

    public void addNaturalWeapons(List weapons) {
        this.equipmentListAddAll(weapons);
        this.setDirty(true);
    }

    public void addShieldProf(String aProf) {
        if (!this.shieldProfList.contains(aProf)) {
            if (aProf.startsWith("TYPE=") || aProf.startsWith("TYPE.")) {
                this.shieldProfList.add(0, aProf);
            } else {
                this.shieldProfList.add(aProf);
            }
        }
    }

    public void addShieldProfs(List aList) {
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            this.addShieldProf((String)i.next());
        }
    }

    public Skill addSkill(Skill addSkill) {
        Skill aSkill;
        Iterator e = this.getSkillList().iterator();
        while (e.hasNext()) {
            aSkill = (Skill)e.next();
            if (!aSkill.getKeyName().equals(addSkill.getKeyName())) continue;
            return aSkill;
        }
        aSkill = (Skill)addSkill.clone();
        this.getSkillList().add(aSkill);
        this.setDirty(true);
        if (!this.importing) {
            aSkill.globalChecks(this);
            this.calcActiveBonuses();
        }
        return aSkill;
    }

    public String addSpell(CharacterSpell acs, List aFeatList, String className, String bookName, int adjSpellLevel, int spellLevel) {
        boolean isEmpty;
        List sList;
        if (acs == null) {
            return "Invalid parameter to add spell";
        }
        PCClass aClass = null;
        Spell aSpell = acs.getSpell();
        if (bookName == null || bookName.length() == 0) {
            return "Invalid spell book name.";
        }
        if (className != null && (aClass = this.getClassNamed(className)) == null && className.lastIndexOf(40) >= 0) {
            aClass = this.getClassNamed(className.substring(0, className.lastIndexOf(40)).trim());
        }
        if (aClass == null) {
            return "No class named " + className;
        }
        if (!aClass.getMemorizeSpells() && !bookName.equals(Globals.getDefaultSpellBook())) {
            return aClass.getName() + " can only add to " + Globals.getDefaultSpellBook();
        }
        int spellsFromSpecialty = 0;
        if (acs.isSpecialtySpell()) {
            ++spellsFromSpecialty;
        }
        if (!(sList = aClass.getCharacterSpell(null, bookName, adjSpellLevel)).isEmpty()) {
            Iterator i = sList.iterator();
            while (i.hasNext()) {
                CharacterSpell cs = (CharacterSpell)i.next();
                if (cs.equals(acs) || !cs.isSpecialtySpell()) continue;
                ++spellsFromSpecialty;
            }
        }
        if (!acs.isSpecialtySpell() && aClass.isProhibited(aSpell, this)) {
            return acs.getSpell().getName() + " is prohibited.";
        }
        int known = aClass.getKnownForLevel(aClass.getLevel(), spellLevel, this);
        int specialKnown = 0;
        int cast = aClass.getCastForLevel(aClass.getLevel(), adjSpellLevel, bookName, true, true, this);
        aClass.memorizedSpellForLevelBook(adjSpellLevel, bookName);
        boolean isDefault = bookName.equals(Globals.getDefaultSpellBook());
        if (isDefault) {
            specialKnown = aClass.getSpecialtyKnownForLevel(aClass.getLevel(), spellLevel, this);
        }
        if (!aClass.getMemorizeSpells() || isDefault) {
            if (!aClass.getMemorizeSpells() && !this.availableSpells(adjSpellLevel, aClass, bookName, true, acs.isSpecialtySpell(), this)) {
                if (!acs.isSpecialtySpell() && this.availableSpells(adjSpellLevel, aClass, bookName, true, true, this)) {
                    return "Your remaining slot(s) must be filled with your specialty";
                }
                return "You can only learn " + (known + specialKnown) + " spells for level " + adjSpellLevel + "\nand there are no higher-level slots available";
            }
            if (aClass.getMemorizeSpells() && !isDefault && !this.availableSpells(adjSpellLevel, aClass, bookName, false, acs.isSpecialtySpell(), this)) {
                if (!acs.isSpecialtySpell() && this.availableSpells(adjSpellLevel, aClass, bookName, false, true, this)) {
                    return "Your remaining slot(s) must be filled with your specialty or domain";
                }
                return "You can only prepare " + cast + " spells for level " + adjSpellLevel + "\nand there are no higher-level slots available";
            }
        }
        SpellInfo si = null;
        List acsList = aClass.getCharacterSpell(acs.getSpell(), "", adjSpellLevel);
        if (!acsList.isEmpty()) {
            for (int x = acsList.size() - 1; x >= 0; --x) {
                CharacterSpell c = (CharacterSpell)acsList.get(x);
                if (c.equals(acs)) continue;
                acsList.remove(x);
            }
        }
        if (!(isEmpty = acsList.isEmpty())) {
            si = acs.getSpellInfoFor(bookName, adjSpellLevel, -1, aFeatList);
        }
        if (si != null) {
            if (isDefault) {
                return "The Known Spells spellbook contains all spells of this level that you know. You cannot place spells in multiple times.";
            }
            si.setTimes(si.getTimes() + 1);
        } else {
            if (isEmpty) {
                acs = new CharacterSpell(acs.getOwner(), acs.getSpell());
                aClass.addCharacterSpell(acs);
            }
            si = acs.addInfo(adjSpellLevel, 1, bookName, aFeatList);
        }
        this.setDirty(true);
        return "";
    }

    public boolean addSpellBook(String aName) {
        if (aName != null && aName.length() > 0 && !this.spellBooks.contains(aName)) {
            this.spellBooks.add(aName);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public PCTemplate addTemplate(PCTemplate inTemplate) {
        int i;
        int x;
        PCTemplate inTmpl;
        if (inTemplate == null) {
            return null;
        }
        if (this.templateList.contains(inTemplate)) {
            return null;
        }
        Iterator i2 = this.templateList.iterator();
        while (i2.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)i2.next();
            if (!aTemplate.getName().equals(inTemplate.getName())) continue;
            return null;
        }
        int lockMonsterSkillPoints = 0;
        Iterator ci = this.classList.iterator();
        while (ci.hasNext()) {
            PCClass aClass = (PCClass)ci.next();
            if (!aClass.isMonster()) continue;
            lockMonsterSkillPoints = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
            break;
        }
        try {
            inTmpl = (PCTemplate)inTemplate.clone();
            this.templateList.add(inTmpl);
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        inTmpl.makeKitSelection(this);
        this.calcActiveBonuses();
        this.templateAutoLanguages.addAll(inTmpl.getAutoLanguages());
        this.templateLanguages.addAll(inTmpl.getLanguageBonus());
        this.getAutoLanguages();
        this.addNaturalWeapons(inTmpl.getNaturalWeapons());
        inTmpl.chooseLanguageAutos(this.importing, this);
        if (PlayerCharacter.canReassignTemplateFeats()) {
            List templateFeats = inTmpl.feats(this.getTotalLevels(), this.totalHitDice(), this);
            x = templateFeats.size();
            for (i = 0; i < x; ++i) {
                this.modFeatsFromList((String)templateFeats.get(i), true, false);
            }
        } else {
            this.setAutomaticFeatsStable(false);
        }
        List templates = inTmpl.getTemplates(this.importing, this);
        x = templates.size();
        for (i = 0; i < x; ++i) {
            this.addTemplateNamed((String)templates.get(i));
        }
        this.setQualifyListStable(false);
        if (!this.importing) {
            this.getSpellList();
            inTmpl.globalChecks(this);
        }
        this.setAutomaticFeatsStable(false);
        this.setAggregateFeatsStable(false);
        this.rebuildFeatAutoList();
        this.rebuildFeatAggreagateList();
        this.calcActiveBonuses();
        int postLockMonsterSkillPoints = 0;
        Iterator ci2 = this.classList.iterator();
        while (ci2.hasNext()) {
            PCClass aClass = (PCClass)ci2.next();
            if (!aClass.isMonster() || (postLockMonsterSkillPoints = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER")) == lockMonsterSkillPoints || postLockMonsterSkillPoints <= 0) continue;
            Iterator e = this.getLevelInfo().iterator();
            while (e.hasNext()) {
                PCLevelInfo pi = (PCLevelInfo)e.next();
                int newSkillPointsGained = aClass.recalcSkillPointMod(this, pi.getLevel());
                if (!pi.getClassKeyName().equals(aClass.getKeyName())) continue;
                int formerGained = pi.getSkillPointsGained(this);
                pi.setSkillPointsGained(newSkillPointsGained);
                pi.setSkillPointsRemaining(pi.getSkillPointsRemaining(this) + newSkillPointsGained - formerGained, this);
                aClass.setSkillPool(aClass.getSkillPool(this) + newSkillPointsGained - formerGained);
                this.setSkillPoints(this.getSkillPoints() + newSkillPointsGained - formerGained);
            }
        }
        this.setDirty(true);
        return inTmpl;
    }

    public PCTemplate addTemplateNamed(String templateName) {
        PCTemplate aTemplate;
        if (templateName == null) {
            return null;
        }
        if (templateName.startsWith("CHOOSE:")) {
            templateName = PCTemplate.chooseTemplate(templateName, this);
        }
        if ((aTemplate = Globals.getTemplateNamed(templateName)) == null && templateName.endsWith(".REMOVE")) {
            aTemplate = Globals.getTemplateNamed(templateName.substring(0, templateName.length() - 7));
            this.removeTemplate(aTemplate);
        } else {
            this.addTemplate(aTemplate);
        }
        this.setDirty(true);
        return aTemplate;
    }

    public void addWeaponProf(String aString) {
        this.addWeaponProfToList(this.featList, aString, false);
        this.setDirty(true);
    }

    public void adjustGold(double delta) {
        this.gold = new BigDecimal(this.gold.doubleValue() + delta).divide(BIG_ONE, 2, 6);
        this.setDirty(true);
    }

    public void adjustMoveRates() {
        this.movements = null;
        this.movementTypes = null;
        this.movementMult = null;
        this.movementMultOp = null;
        if (this.getRace() == null || this.getRace().getMovements() == null) {
            return;
        }
        this.movements = (Double[])this.getRace().getMovements().clone();
        this.movementTypes = (String[])this.getRace().getMovementTypes().clone();
        this.movementMult = (Double[])this.getRace().getMovementMult().clone();
        this.movementMultOp = (String[])this.getRace().getMovementMultOp().clone();
        if (!this.getTemplateList().isEmpty()) {
            this.setMoveFromList(this.getTemplateList());
        }
        if (!this.getClassList().isEmpty()) {
            this.setMoveFromList(this.getClassList());
        }
        if (!this.aggregateFeatList().isEmpty()) {
            this.setMoveFromList(this.aggregateFeatList());
        }
        if (!this.getEquipmentList().isEmpty()) {
            this.setMoveFromList(this.getEquipmentList());
            Iterator e = this.getEquipmentList().iterator();
            while (e.hasNext()) {
                Equipment eq = (Equipment)e.next();
                if (!eq.isEquipped()) continue;
                List bList = eq.getEqModifierList(true);
                this.setMoveFromList(bList);
                bList = eq.getEqModifierList(false);
                this.setMoveFromList(bList);
            }
        }
        if (!this.getTempBonusList().isEmpty() && this.getUseTempMods()) {
            this.setMoveFromList(this.getTempBonusList());
        }
        Iterator b = this.getActiveBonusList().iterator();
        while (b.hasNext()) {
            BonusObj aBonus = (BonusObj)b.next();
            if (!aBonus.getTypeOfBonus().equals("MOVEADD")) continue;
            String moveType = aBonus.getBonusInfo();
            if (moveType.startsWith("TYPE")) {
                moveType = moveType.substring(5);
            }
            moveType = CoreUtility.capitalizeFirstLetter(moveType);
            boolean found = false;
            for (int i = 0; i < this.movements.length; ++i) {
                if (!moveType.equals(this.movementTypes[i])) continue;
                found = true;
            }
            if (found) continue;
            this.setMyMoveRates(moveType, 0.0, new Double(0.0), "", 1);
        }
        this.setDirty(true);
    }

    public List aggregateSpellList(String aType, String school, String subschool, String descriptor, int minLevel, int maxLevel) {
        ArrayList<Spell> aArrayList = new ArrayList<Spell>();
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            String cName = aClass.getKeyName();
            if (aClass.getCastAs().length() > 0) {
                cName = aClass.getCastAs();
            }
            if (!"Any".equalsIgnoreCase(aType) && !aType.equalsIgnoreCase(aClass.getSpellType()) && !aType.equalsIgnoreCase(cName)) continue;
            for (int a = minLevel; a <= maxLevel; ++a) {
                List aList = aClass.getCharacterSpell(null, "", a);
                if (aList.isEmpty()) continue;
                Iterator i = aList.iterator();
                while (i.hasNext()) {
                    CharacterSpell cs = (CharacterSpell)i.next();
                    Spell aSpell = cs.getSpell();
                    if (school.length() != 0 && !aSpell.getSchools().contains(school) && subschool.length() != 0 && !aSpell.getSubschools().contains(subschool) && descriptor.length() != 0 && !aSpell.descriptorContains(descriptor)) continue;
                    aArrayList.add(cs.getSpell());
                }
            }
        }
        return aArrayList;
    }

    public int altHP() {
        int i = (int)this.getTotalBonusTo("HP", "ALTHP");
        return i;
    }

    public int baseAC() {
        return this.calcACOfType("Base");
    }

    public int baseAttackBonus() {
        String cacheLookup = "BaseAttackBonus";
        Float total = this.getCachedVariable(cacheLookup);
        if (total != null) {
            return total.intValue();
        }
        PlayerCharacter nPC = this.getMasterPC();
        if (nPC != null && this.getCopyMasterBAB().length() > 0) {
            int masterBAB = nPC.baseAttackBonus();
            String copyMasterBAB = this.replaceMasterString(this.getCopyMasterBAB(), masterBAB);
            masterBAB = this.getVariableValue(copyMasterBAB, "").intValue();
            this.addCachedVariable(cacheLookup, new Float(masterBAB));
            return masterBAB;
        }
        int totalClassLevels = this.getTotalClassLevels();
        HashMap totalLvlMap = null;
        Map classLvlMap = null;
        if (totalClassLevels > SettingsHandler.getGame().getBabMaxLvl()) {
            totalLvlMap = this.getTotalLevelHashMap();
            classLvlMap = this.getLevelHashMap(SettingsHandler.getGame().getBabMaxLvl());
            this.pauseCache();
            this.setClassLevelsBrazenlyTo(classLvlMap);
        }
        int bab = (int)this.getTotalBonusTo("COMBAT", "BAB");
        if (totalLvlMap != null) {
            this.setClassLevelsBrazenlyTo(totalLvlMap);
            this.restartCache();
        }
        this.addCachedVariable(cacheLookup, new Float(bab));
        return bab;
    }

    public int basemovement(int moveIdx, int iLoad) {
        int move = this.getMovement(moveIdx).intValue();
        return move;
    }

    public void buildSpellInfoMap(String key) {
        Iterator e;
        this.spellInfoMap.clear();
        if (!this.classList.isEmpty()) {
            e = this.classList.iterator();
            this.buildSpellInfoMap(key, e);
        }
        if (!this.companionModList.isEmpty()) {
            e = this.companionModList.iterator();
            this.buildSpellInfoMap(key, e);
        }
        if (!this.equipmentList.isEmpty()) {
            e = this.equipmentList.iterator();
            this.buildSpellInfoMap(key, e);
        }
        if (!this.aggregateFeatList().isEmpty()) {
            e = this.aggregateFeatList().iterator();
            this.buildSpellInfoMap(key, e);
        }
        if (!this.templateList.isEmpty()) {
            e = this.templateList.iterator();
            this.buildSpellInfoMap(key, e);
        }
        if (!this.characterDomainList.isEmpty()) {
            e = this.characterDomainList.iterator();
            this.buildSpellInfoMap(key, e);
        }
        if (!this.getSkillList().isEmpty()) {
            e = this.getSkillList().iterator();
            this.buildSpellInfoMap(key, e);
        }
        if (this.getRace() != null) {
            this.spellInfoMap.putAll(this.getRace().getSpellInfoMapPassesPrereqs(key, this));
        }
        if (this.getDeity() != null) {
            this.spellInfoMap.putAll(this.getDeity().getSpellInfoMapPassesPrereqs(key, this));
        }
    }

    public void buildSpellLevelMap(int levelMatch) {
        Iterator e;
        this.spellLevelMap.clear();
        if (!this.classList.isEmpty()) {
            e = this.classList.iterator();
            this.buildSpellLevelMap(levelMatch, e);
        }
        if (!this.companionModList.isEmpty()) {
            e = this.companionModList.iterator();
            this.buildSpellLevelMap(levelMatch, e);
        }
        if (!this.equipmentList.isEmpty()) {
            e = this.equipmentList.iterator();
            this.buildSpellLevelMap(levelMatch, e);
        }
        if (!this.aggregateFeatList().isEmpty()) {
            e = this.aggregateFeatList().iterator();
            this.buildSpellLevelMap(levelMatch, e);
        }
        if (!this.templateList.isEmpty()) {
            e = this.templateList.iterator();
            this.buildSpellLevelMap(levelMatch, e);
        }
        if (!this.characterDomainList.isEmpty()) {
            e = this.characterDomainList.iterator();
            this.buildSpellLevelMap(levelMatch, e);
        }
        if (!this.getSkillList().isEmpty()) {
            e = this.getSkillList().iterator();
            this.buildSpellLevelMap(levelMatch, e);
        }
        if (this.getRace() != null) {
            this.spellLevelMap.putAll(this.getRace().getSpellMapPassesPrereqs(this, levelMatch));
        }
        if (this.getDeity() != null) {
            this.spellLevelMap.putAll(this.getDeity().getSpellMapPassesPrereqs(this, levelMatch));
        }
    }

    public int calcACOfType(String ACType) {
        StringTokenizer aTok;
        PObject aPObj;
        String aString;
        Iterator e;
        List addList = SettingsHandler.getGame().getACTypeAddString(ACType);
        List removeList = SettingsHandler.getGame().getACTypeRemoveString(ACType);
        if (addList == null && removeList == null) {
            Logging.errorPrint("Invalid ACType: " + ACType);
            return 0;
        }
        int AC = 0;
        if (addList != null) {
            e = addList.iterator();
            while (e.hasNext()) {
                aString = (String)e.next();
                aPObj = new PObject();
                this.getPreReqFromACType(aString, aPObj);
                if (!PrereqHandler.passesAll(aPObj.getPreReqList(), this, aPObj)) continue;
                aTok = new StringTokenizer(aString, "|");
                AC += this.subCalcACOfType(aTok);
            }
        }
        if (removeList != null) {
            e = removeList.iterator();
            while (e.hasNext()) {
                aString = (String)e.next();
                aPObj = new PObject();
                this.getPreReqFromACType(aString, aPObj);
                if (!PrereqHandler.passesAll(aPObj.getPreReqList(), this, aPObj)) continue;
                aTok = new StringTokenizer(aString, "|");
                AC -= this.subCalcACOfType(aTok);
            }
        }
        return AC;
    }

    public void calcActiveBonuses() {
        if (this.isImporting() || this.race == null) {
            return;
        }
        this.buildVariableSet();
        String origMapVal = this.activeBonusMap.toString();
        this.setDirty(true);
        this.calcActiveBonusLoop();
        String mapVal = this.activeBonusMap.toString();
        while (!mapVal.equals(origMapVal)) {
            this.setDirty(true);
            this.calcActiveBonusLoop();
            origMapVal = mapVal;
            mapVal = this.activeBonusMap.toString();
        }
    }

    private void calcActiveBonusLoop() {
        this.clearActiveBonuses();
        this.calcStatBonuses();
        this.calcSizeAdjustmentBonuses();
        this.calcAgeBonuses();
        this.calcCheckBonuses();
        this.calcAlignmentBonuses();
        this.calcFeatBonuses();
        this.calcClassBonuses();
        this.calcCompanionModBonuses();
        this.calcEquipmentBonuses();
        this.calcTemplateBonuses();
        this.calcDomainBonuses();
        this.calcRaceBonuses();
        this.calcDeityBonuses();
        this.calcSkillBonuses();
        if (this.getUseTempMods()) {
            this.calcTempBonuses();
        }
        this.sortActiveBonusList();
        this.buildActiveBonusMap();
    }

    private void sortActiveBonusList() {
        BonusObj aBonus;
        int i;
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        int aSize = this.getActiveBonusList().size();
        for (i = 0; i < aSize; ++i) {
            aBonus = (BonusObj)this.getActiveBonusList().get(i);
            int iFound = 0;
            for (int ii = 0; ii < aList.size(); ++ii) {
                BonusObj tempBonus = (BonusObj)aList.get(ii);
                if (!tempBonus.getDependsOn(aBonus.getBonusInfo())) continue;
                iFound = ii;
            }
            aList.add(iFound, aBonus);
        }
        this.setActiveBonusList(aList);
        aList.clear();
        aSize = this.getActiveBonusList().size();
        for (i = 0; i < aSize; ++i) {
            aBonus = (BonusObj)this.getActiveBonusList().get(i);
            if (aBonus.isValueStatic()) {
                aList.add(0, aBonus);
                continue;
            }
            aList.add(aBonus);
        }
        this.setActiveBonusList(aList);
    }

    public int calcCR() {
        int CR = 0;
        int rhd = this.race.hitDice(this);
        if (rhd > 0) {
            float hitDieRatio;
            for (hitDieRatio = (float)this.totalHitDice() / (float)rhd; hitDieRatio >= 2.0f; hitDieRatio /= 2.0f) {
                CR += 2;
            }
            if ((double)hitDieRatio >= 1.5) {
                ++CR;
            }
        }
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            CR += aClass.calcCR(this);
        }
        for (int x = 0; x < this.templateList.size(); ++x) {
            CR += ((PCTemplate)this.templateList.get(x)).getCR(this.getTotalLevels(), this.totalHitDice());
        }
        int raceCR = this.race.getCR();
        if (raceCR > 0 || CR == 0) {
            CR += raceCR;
        }
        return CR;
    }

    public String calcDR() {
        Map drMap = new HashMap();
        drMap = this.addStringToDRMap(drMap, this.race.getDR());
        if (this.deity != null) {
            drMap = this.addStringToDRMap(drMap, this.deity.getDR());
        }
        Iterator i = this.classList.iterator();
        while (i.hasNext()) {
            PCClass aClass = (PCClass)i.next();
            drMap = this.addStringToDRMap(drMap, aClass.getDR());
        }
        i = this.aggregateFeatList().iterator();
        while (i.hasNext()) {
            Feat aFeat = (Feat)i.next();
            drMap = this.addStringToDRMap(drMap, aFeat.getDR());
        }
        i = this.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            drMap = this.addStringToDRMap(drMap, aSkill.getDR());
        }
        i = this.characterDomainList.iterator();
        while (i.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)i.next();
            if (aCD.getDomain() == null) continue;
            drMap = this.addStringToDRMap(drMap, aCD.getDomain().getDR());
        }
        Iterator e = this.equipmentList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            drMap = this.addStringToDRMap(drMap, eq.getDR());
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    drMap = this.addStringToDRMap(drMap, eqMod.getDR());
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                drMap = this.addStringToDRMap(drMap, eqMod.getDR());
            }
        }
        int atl = this.getTotalLevels();
        int thd = this.totalHitDice();
        Iterator i2 = this.templateList.iterator();
        while (i2.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)i2.next();
            drMap = this.addStringToDRMap(drMap, aTemplate.getDR(atl, thd));
        }
        StringBuffer DR2 = new StringBuffer();
        Iterator i3 = drMap.keySet().iterator();
        while (i3.hasNext()) {
            String damageType = i3.next().toString();
            String symbol = "";
            int protectionValue = Integer.parseInt(drMap.get(damageType).toString());
            int damageTypeAsInteger = 0;
            try {
                damageTypeAsInteger = Integer.parseInt(damageType);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            if (damageTypeAsInteger > 0) {
                symbol = "+";
            }
            protectionValue += (int)this.getTotalBonusTo("DR", symbol + damageType);
            if (DR2.length() > 0) {
                DR2.append(';');
            }
            DR2.append(protectionValue).append('/').append(symbol).append(damageType);
        }
        return DR2.toString();
    }

    public double calcMoveMult(double move, int index) {
        double iMove = 0.0;
        if (this.movementMultOp[index].charAt(0) == '*') {
            iMove = move * this.movementMult[index];
        } else if (this.movementMultOp[index].charAt(0) == '/') {
            iMove = move / this.movementMult[index];
        }
        if (iMove > 0.0) {
            return iMove;
        }
        return move;
    }

    public int calcSR(boolean includeEquipment) {
        int SR = this.race.getSR(this);
        if (this.deity != null) {
            SR = Math.max(SR, this.deity.getSR(this));
        }
        Iterator i = this.companionModList.iterator();
        while (i.hasNext()) {
            CompanionMod cMod = (CompanionMod)i.next();
            SR = Math.max(SR, cMod.getSR(this));
        }
        i = this.classList.iterator();
        while (i.hasNext()) {
            PCClass aClass = (PCClass)i.next();
            SR = Math.max(SR, aClass.getSR(this));
        }
        i = this.aggregateFeatList().iterator();
        while (i.hasNext()) {
            Feat aFeat = (Feat)i.next();
            SR = Math.max(SR, aFeat.getSR(this));
        }
        i = this.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            SR = Math.max(SR, aSkill.getSR(this));
        }
        i = this.characterDomainList.iterator();
        while (i.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)i.next();
            if (aCD.getDomain() == null) continue;
            SR = Math.max(aCD.getDomain().getSR(this), SR);
        }
        if (includeEquipment) {
            Iterator e = this.equipmentList.iterator();
            while (e.hasNext()) {
                EquipmentModifier eqMod;
                Iterator e2;
                Equipment eq = (Equipment)e.next();
                if (!eq.isEquipped()) continue;
                SR = Math.max(SR, eq.getSR(this));
                List aList = eq.getEqModifierList(true);
                if (!aList.isEmpty()) {
                    e2 = aList.iterator();
                    while (e2.hasNext()) {
                        eqMod = (EquipmentModifier)e2.next();
                        SR = Math.max(SR, eqMod.getSR(this));
                    }
                }
                if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    SR = Math.max(SR, eqMod.getSR(this));
                }
            }
        }
        int atl = this.getTotalLevels();
        int thd = this.totalHitDice();
        Iterator i2 = this.templateList.iterator();
        while (i2.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)i2.next();
            SR = Math.max(SR, aTemplate.getSR(atl, thd, this));
        }
        SR += (int)this.getTotalBonusTo("MISC", "SR");
        if (!includeEquipment) {
            SR -= (int)this.getEquipmentBonusTo("MISC", "SR");
        }
        return SR;
    }

    public boolean canCastSpellTypeLevel(String spellType, int spellLevel, int minNumSpells) {
        Iterator iter = this.classList.iterator();
        while (iter.hasNext()) {
            PCClass aClass = (PCClass)iter.next();
            if (!aClass.getSpellType().equalsIgnoreCase(spellType) || aClass.getSpellType().equalsIgnoreCase("None")) continue;
            if (aClass.getCastForLevel(aClass.getLevel(), spellLevel, this) >= minNumSpells) {
                return true;
            }
            if (aClass.getMemorizeSpells() || !aClass.zeroCastSpells()) continue;
            return true;
        }
        return false;
    }

    public boolean canSelectDeity(Deity aDeity) {
        if (aDeity == null) {
            return false;
        }
        return aDeity.canBeSelectedBy(this.classList, this.alignment, this);
    }

    public int classAC() {
        return this.calcACOfType("ClassDefense");
    }

    public String delSpell(SpellInfo si, PCClass aClass, String bookName) {
        if (bookName == null || bookName.length() == 0) {
            return "Invalid spell book name.";
        }
        if (aClass == null) {
            return "Error: Class is null";
        }
        CharacterSpell acs = si.getOwner();
        boolean isDefault = bookName.equals(Globals.getDefaultSpellBook());
        if (isDefault && aClass.isAutoKnownSpell(acs.getSpell().getName(), si.getActualLevel(), this)) {
            Logging.errorPrint("Notice: removing " + acs.getSpell().getName() + " even though it is an auto known spell");
        }
        si.setTimes(si.getTimes() - 1);
        if (si.getTimes() <= 0) {
            acs.removeSpellInfo(si);
        }
        if ((si = acs.getSpellInfoFor("", -1, -1, null)) == null) {
            aClass.removeCharacterSpell(acs);
        }
        return "";
    }

    public List addVirtualFeat(String featName, List addList) {
        Feat aFeat = Globals.getFeatNamed(featName);
        if (aFeat != null) {
            aFeat = (Feat)aFeat.clone();
            aFeat.setFeatType(2);
            if (!aFeat.getName().equalsIgnoreCase(featName)) {
                int i = featName.indexOf(40);
                int j = featName.indexOf(41);
                if (i >= 0 && j >= 0) {
                    StringTokenizer aTok = new StringTokenizer(featName.substring(i + 1, j), ",");
                    while (aTok.hasMoreTokens()) {
                        String a = aTok.nextToken();
                        if (aFeat.containsAssociated(a)) continue;
                        aFeat.addAssociated(a);
                    }
                }
            }
            if (aFeat.isMultiples()) {
                addList.add(aFeat);
            } else if (PlayerCharacter.getFeatNamedInList(addList, aFeat.getName()) == null) {
                addList.add(aFeat);
            }
        }
        this.setDirty(true);
        return addList;
    }

    public List aggregateFeatList() {
        List aggregate = this.getStableAggregateFeatList();
        if (aggregate != null) {
            return aggregate;
        }
        return this.rebuildFeatAggreagateList();
    }

    private List rebuildFeatAggreagateList() {
        String aString;
        int e1;
        Feat aggregateFeat;
        Iterator e;
        ArrayList aggregate = new ArrayList();
        HashMap<String, Feat> aHashMap = new HashMap<String, Feat>();
        if (!this.featList.isEmpty()) {
            e = ((ArrayList)this.featList.clone()).iterator();
            while (e.hasNext()) {
                Feat aFeat = (Feat)e.next();
                if (aFeat == null) continue;
                aHashMap.put(aFeat.getKeyName(), aFeat);
            }
        }
        e = this.getVirtualFeatList().iterator();
        while (e.hasNext()) {
            Feat virtualFeat = (Feat)e.next();
            if (!aHashMap.containsKey(virtualFeat.getKeyName())) {
                aHashMap.put(virtualFeat.getKeyName(), virtualFeat);
                continue;
            }
            if (!virtualFeat.isMultiples()) continue;
            aggregateFeat = (Feat)aHashMap.get(virtualFeat.getKeyName());
            aggregateFeat = (Feat)aggregateFeat.clone();
            for (e1 = 0; e1 < virtualFeat.getAssociatedCount(); ++e1) {
                aString = virtualFeat.getAssociated(e1);
                if (!aggregateFeat.isStacks() && aggregateFeat.containsAssociated(aString)) continue;
                aggregateFeat.addAssociated(aString);
            }
            aHashMap.put(virtualFeat.getName(), aggregateFeat);
        }
        aggregate.addAll(aHashMap.values());
        this.setStableAggregateFeatList(aggregate);
        e = this.featAutoList().iterator();
        while (e.hasNext()) {
            Feat autoFeat = (Feat)e.next();
            if (!aHashMap.containsKey(autoFeat.getKeyName())) {
                aHashMap.put(autoFeat.getName(), autoFeat);
                continue;
            }
            if (!autoFeat.isMultiples()) continue;
            aggregateFeat = (Feat)aHashMap.get(autoFeat.getKeyName());
            aggregateFeat = (Feat)aggregateFeat.clone();
            for (e1 = 0; e1 < autoFeat.getAssociatedCount(); ++e1) {
                aString = autoFeat.getAssociated(e1);
                if (!aggregateFeat.isStacks() && aggregateFeat.containsAssociated(aString)) continue;
                aggregateFeat.addAssociated(aString);
            }
            aHashMap.put(autoFeat.getName(), aggregateFeat);
        }
        aggregate = new ArrayList();
        aggregate.addAll(aHashMap.values());
        this.setStableAggregateFeatList(aggregate);
        return aggregate;
    }

    public List aggregateVisibleFeatList() {
        ArrayList<Feat> tempFeatList = new ArrayList<Feat>();
        Iterator e1 = this.aggregateFeatList().iterator();
        while (e1.hasNext()) {
            Feat aFeat = (Feat)e1.next();
            if (aFeat.isVisible() != 1 && aFeat.isVisible() != 2) continue;
            tempFeatList.add(aFeat);
        }
        return tempFeatList;
    }

    public int calculateSaveBonus(int saveIndex, String saveType, String tokenString) {
        StringTokenizer aTok = new StringTokenizer(tokenString, ".");
        String[] tokens = new String[aTok.countTokens()];
        int checkIndex = SettingsHandler.getGame().getIndexOfCheck(saveType) + 1;
        int save = 0;
        int i = 0;
        while (aTok.hasMoreTokens()) {
            tokens[i] = aTok.nextToken();
            if ("TOTAL".equals(tokens[i])) {
                save += (int)this.getBonus(checkIndex, true);
            } else if ("BASE".equals(tokens[i])) {
                save += (int)this.getBonus(checkIndex, false);
            } else if ("MISC".equals(tokens[i])) {
                save += (int)this.getTotalBonusTo("CHECKS", saveType);
            }
            if ("EPIC".equals(tokens[i])) {
                save += (int)this.getBonusDueToType("CHECKS", saveType, "EPIC");
            }
            if ("MAGIC".equals(tokens[i])) {
                save += (int)this.getEquipmentBonusTo("CHECKS", saveType);
            }
            if ("RACE".equals(tokens[i])) {
                save += this.calculateSaveBonusRace(saveIndex);
            }
            if ("FEATS".equals(tokens[i])) {
                save += (int)this.getFeatBonusTo("CHECKS", saveType, true);
            }
            if ("STATMOD".equals(tokens[i])) {
                save += (int)this.getCheckBonusTo("CHECKS", saveType);
            }
            if ("NOEPIC".equals(tokens[i])) {
                save -= (int)this.getBonusDueToType("CHECKS", saveType, "EPIC");
            }
            if ("NOMAGIC".equals(tokens[i])) {
                save -= (int)this.getEquipmentBonusTo("CHECKS", saveType);
            }
            if ("NORACE".equals(tokens[i])) {
                save -= this.calculateSaveBonusRace(saveIndex);
            }
            if ("NOFEATS".equals(tokens[i])) {
                save -= (int)this.getFeatBonusTo("CHECKS", saveType, true);
            }
            if ("NOSTAT".equals(tokens[i]) || "NOSTATMOD".equals(tokens[i])) {
                save -= (int)this.getCheckBonusTo("CHECKS", saveType);
            }
            ++i;
        }
        return save;
    }

    public boolean delSpellBook(String aName) {
        if (aName.length() > 0 && !aName.equals(Globals.getDefaultSpellBook()) && this.spellBooks.contains(aName)) {
            this.spellBooks.remove(aName);
            this.setDirty(true);
            Iterator i = this.classList.iterator();
            while (i.hasNext()) {
                PCClass aClass = (PCClass)i.next();
                List aList = aClass.getCharacterSpell(null, aName, -1);
                for (int j = aList.size() - 1; j >= 0; --j) {
                    CharacterSpell cs = (CharacterSpell)aList.get(j);
                    cs.removeSpellInfo(cs.getSpellInfoFor(aName, -1, -1));
                }
            }
            return true;
        }
        return false;
    }

    public void determinePrimaryOffWeapon() {
        this.primaryWeapons.clear();
        this.secondaryWeapons.clear();
        if (this.equipmentList.isEmpty()) {
            return;
        }
        ArrayList<Equipment> unequippedPrimary = new ArrayList<Equipment>();
        ArrayList<Equipment> unequippedSecondary = new ArrayList<Equipment>();
        Iterator e = this.equipmentList.iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!eq.isWeapon() || eq.getSlots(this) < 1) continue;
            boolean isEquipped = eq.isEquipped();
            if (eq.getLocation() == 1 || eq.getLocation() == 3 && this.primaryWeapons.isEmpty() || eq.getLocation() == 4) {
                if (isEquipped) {
                    this.primaryWeapons.add(eq);
                } else {
                    unequippedPrimary.add(eq);
                }
            } else if (eq.getLocation() == 3 && !this.primaryWeapons.isEmpty()) {
                if (isEquipped) {
                    this.secondaryWeapons.add(eq);
                } else {
                    unequippedSecondary.add(eq);
                }
            }
            if (eq.getLocation() == 2) {
                if (isEquipped) {
                    this.secondaryWeapons.add(eq);
                } else {
                    unequippedSecondary.add(eq);
                }
            }
            if (eq.getLocation() != 4) continue;
            for (int y = 0; y < eq.getNumberEquipped() - 1; ++y) {
                if (isEquipped) {
                    this.secondaryWeapons.add(eq);
                    continue;
                }
                unequippedSecondary.add(eq);
            }
        }
        if (Globals.checkRule("EQUIPATTACK")) {
            if (unequippedPrimary.size() != 0) {
                this.primaryWeapons.addAll(unequippedPrimary);
            }
            if (unequippedSecondary.size() != 0) {
                this.secondaryWeapons.addAll(unequippedSecondary);
            }
        }
    }

    public int dodgeAC() {
        return this.calcACOfType("Dodge");
    }

    public int equipmentAC() {
        return this.calcACOfType("Equipment") + this.calcACOfType("Armor");
    }

    public List featAutoList() {
        List autoFeatList = this.getStableAutomaticFeatList();
        if (autoFeatList != null) {
            return autoFeatList;
        }
        return this.rebuildFeatAutoList();
    }

    public List rebuildFeatAutoList() {
        String aString;
        ArrayList autoFeatList = new ArrayList();
        if (this.race != null && !PlayerCharacter.canReassignRacialFeats()) {
            StringTokenizer aTok = new StringTokenizer(this.race.getFeatList(this), "|");
            while (aTok.hasMoreTokens()) {
                PlayerCharacter.addToAutoFeatList(autoFeatList, aTok.nextToken());
            }
        }
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            Iterator e1 = aClass.getFeatAutos().iterator();
            while (e1.hasNext()) {
                int i;
                String aString2 = (String)e1.next();
                if (aString2.indexOf(124) < 1) continue;
                StringTokenizer aTok = new StringTokenizer(aString2, "|");
                try {
                    i = Integer.parseInt(aTok.nextToken());
                }
                catch (NumberFormatException exc) {
                    i = 9999;
                }
                if (i > aClass.getLevel()) continue;
                String autoFeat = aTok.nextToken();
                int idx = autoFeat.indexOf(91);
                if (idx >= 0) {
                    StringTokenizer bTok = new StringTokenizer(autoFeat.substring(idx + 1), "[]");
                    ArrayList<Prerequisite> preReqList = new ArrayList<Prerequisite>();
                    while (bTok.hasMoreTokens()) {
                        String prereqString = bTok.nextToken();
                        Logging.debugPrint("Why is the prerequisite '" + prereqString + "' parsed in PlayerCharacter.featAutoList() rather than the persistence layer");
                        try {
                            PreParserFactory factory = PreParserFactory.getInstance();
                            Prerequisite prereq = factory.parse(prereqString);
                            preReqList.add(prereq);
                        }
                        catch (PersistenceLayerException ple) {
                            Logging.errorPrint(ple.getMessage(), ple);
                        }
                    }
                    autoFeat = autoFeat.substring(0, idx);
                    if (preReqList.size() != 0) {
                        if (!this.isAutomaticFeatsStable()) {
                            this.setStableAutomaticFeatList(autoFeatList);
                        }
                        if (!PrereqHandler.passesAll(preReqList, this, null)) continue;
                    }
                }
                PlayerCharacter.addToAutoFeatList(autoFeatList, autoFeat);
            }
        }
        if (!PlayerCharacter.canReassignTemplateFeats() && !this.templateList.isEmpty()) {
            e = this.templateList.iterator();
            while (e.hasNext()) {
                this.setStableAutomaticFeatList(autoFeatList);
                PCTemplate aTemplate = (PCTemplate)e.next();
                List templateFeats = aTemplate.feats(this.getTotalLevels(), this.totalHitDice(), this);
                if (templateFeats.isEmpty()) continue;
                Iterator e2 = templateFeats.iterator();
                while (e2.hasNext()) {
                    aString = (String)e2.next();
                    StringTokenizer aTok = new StringTokenizer(aString, ",");
                    while (aTok.hasMoreTokens()) {
                        PlayerCharacter.addToAutoFeatList(autoFeatList, aTok.nextToken());
                    }
                }
            }
        }
        if (!this.characterDomainList.isEmpty()) {
            e = this.characterDomainList.iterator();
            while (e.hasNext()) {
                CharacterDomain aCD = (CharacterDomain)e.next();
                Domain aDomain = aCD.getDomain();
                if (aDomain == null) continue;
                for (int e2 = 0; e2 < aDomain.getAssociatedCount(); ++e2) {
                    aString = aDomain.getAssociated(e2);
                    if (!aString.startsWith("FEAT")) continue;
                    int idx = aString.indexOf(63);
                    if (idx > -1) {
                        PlayerCharacter.addToAutoFeatList(autoFeatList, aString.substring(idx + 1));
                        continue;
                    }
                    Logging.errorPrint("no '?' in Domain assocatedList entry: " + aString);
                }
                ArrayList domainFeatList = aDomain.getFeatList();
                if (domainFeatList.isEmpty()) continue;
                Iterator e2 = domainFeatList.iterator();
                while (e2.hasNext()) {
                    String featName = (String)e2.next();
                    PlayerCharacter.addToAutoFeatList(autoFeatList, featName);
                }
            }
        }
        this.setStableAutomaticFeatList(autoFeatList);
        this.getAutoWeaponProfs(autoFeatList);
        this.setStableAutomaticFeatList(autoFeatList);
        return autoFeatList;
    }

    public int flatfootedAC() {
        return this.calcACOfType("Flatfooted");
    }

    public boolean hasDomainSource(String aType, String aName, int aLevel) {
        String aKey = aType + "|" + aName + "|" + aLevel;
        return this.domainSourceMap.containsKey(aKey);
    }

    public boolean hasFeat(String featName) {
        return PlayerCharacter.getFeatNamedInList(this.featList, featName) != null;
    }

    public boolean hasFeatAutomatic(String featName) {
        return PlayerCharacter.getFeatNamedInList(this.featAutoList(), featName) != null;
    }

    public boolean hasFeatVirtual(String featName) {
        return PlayerCharacter.getFeatNamedInList(this.getVirtualFeatList(), featName) != null;
    }

    public boolean hasMadeKitSelectionForAgeSet(int index) {
        return index >= 0 && index < 10 && this.ageSetKitSelections[index];
    }

    public boolean hasSpecialAbility(String abilityName) {
        Iterator e = this.getSpecialAbilityList().iterator();
        while (e.hasNext()) {
            if (!((SpecialAbility)e.next()).getName().equalsIgnoreCase(abilityName)) continue;
            return true;
        }
        return false;
    }

    public int hitPoints() {
        double iConMod = this.getStatBonusTo("HP", "BONUS");
        int total = 0;
        if (this.race.hitDice(this) != 0) {
            total = this.race.calcHitPoints((int)iConMod);
        }
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            total += aClass.hitPoints((int)iConMod);
        }
        total += (int)this.getTotalBonusTo("HP", "CURRENTMAX");
        PlayerCharacter nPC = this.getMasterPC();
        if (nPC == null) {
            return total;
        }
        if (this.getCopyMasterHP().length() == 0) {
            return total;
        }
        PlayerCharacter curPC = this;
        Globals.setCurrentPC(nPC);
        int masterHP = nPC.hitPoints();
        Globals.setCurrentPC(curPC);
        String copyMasterHP = this.replaceMasterString(this.getCopyMasterHP(), masterHP);
        masterHP = this.getVariableValue(copyMasterHP, "").intValue();
        return masterHP;
    }

    public boolean ignoreEncumberedArmorMove(int armorInt) {
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            int encMove;
            PObject aPObj = (PObject)i.next();
            if (aPObj == null || armorInt > (encMove = aPObj.getEncumberedArmorMove())) continue;
            return true;
        }
        return false;
    }

    public boolean ignoreEncumberedLoadMove(int loadInt) {
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            int encMove;
            PObject aPObj = (PObject)i.next();
            if (aPObj == null || loadInt > (encMove = aPObj.getEncumberedLoadMove())) continue;
            return true;
        }
        return false;
    }

    public void incrementClassLevel(int mod, PCClass aClass) {
        this.incrementClassLevel(mod, aClass, false);
        this.setDirty(true);
    }

    public int indexOfFirstEmptyCharacterDomain() {
        for (int i = 0; i < this.characterDomainList.size(); ++i) {
            CharacterDomain aCD = (CharacterDomain)this.characterDomainList.get(i);
            if (aCD.getDomain() != null) continue;
            return i;
        }
        return -1;
    }

    public int initiativeMod() {
        int initmod = (int)this.getTotalBonusTo("COMBAT", "Initiative") + this.getVariableValue("INITCOMP", "").intValue();
        return initmod;
    }

    public int languageNum(boolean includeSpeakLanguage) {
        int i = (int)this.getStatBonusTo("LANG", "BONUS");
        Race pcRace = this.getRace();
        if (i < 0) {
            i = 0;
        }
        if (includeSpeakLanguage) {
            Iterator a = this.getSkillList().iterator();
            while (a.hasNext()) {
                Skill aSkill = (Skill)a.next();
                if (aSkill.getChoiceString().indexOf("Language") < 0) continue;
                i += aSkill.getTotalRank(this).intValue();
            }
        }
        if (pcRace != null) {
            i += pcRace.getLangNum() + (int)this.getTotalBonusTo("LANGUAGES", "NUMBER");
        }
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            int classLevel = aClass.getLevel();
            ArrayList levelAbilityList = aClass.getLevelAbilityList();
            if (levelAbilityList == null) continue;
            for (int x = levelAbilityList.size() - 1; x >= 0; --x) {
                Object obj = levelAbilityList.get(x);
                if (!(obj instanceof LevelAbilityLanguage) || classLevel < ((LevelAbilityLanguage)obj).level()) continue;
                ++i;
            }
        }
        return i += this.freeLangs;
    }

    public String listBonusesFor(String prefix) {
        StringBuffer buf = new StringBuffer();
        ArrayList<String> aList = new ArrayList<String>();
        Iterator<Object> i = this.getActiveBonusMap().keySet().iterator();
        while (i.hasNext()) {
            int b;
            String aKey = i.next().toString();
            if (!aKey.startsWith(prefix)) continue;
            if (aKey.endsWith(".REPLACE")) {
                aList.add(aKey);
                continue;
            }
            if (buf.length() > 0) {
                buf.append(", ");
            }
            String reason = "";
            if (aKey.length() > prefix.length()) {
                reason = aKey.substring(prefix.length() + 1);
            }
            if ((b = (int)this.getActiveBonusForMapKey(aKey, 0.0)) == 0) continue;
            if (!"NULL".equals(reason) && reason.length() > 0) {
                buf.append(reason).append(' ');
            }
            buf.append(Delta.toString(b));
        }
        if (!aList.isEmpty()) {
            i = aList.iterator();
            while (i.hasNext()) {
                String reason;
                String replaceKey = (String)i.next();
                if (replaceKey.length() <= 7) continue;
                String aKey = replaceKey.substring(0, replaceKey.length() - 8);
                double replaceBonus = this.getActiveBonusForMapKey(replaceKey, 0.0);
                double aBonus = this.getActiveBonusForMapKey(aKey, 0.0);
                int b = (int)Math.max(aBonus += this.getActiveBonusForMapKey(aKey + ".STACK", 0.0), replaceBonus);
                if (b == 0) continue;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                if (!"NULL".equals(reason = aKey.substring(prefix.length() + 1))) {
                    buf.append(reason).append(' ');
                }
                buf.append(Delta.toString(b));
            }
        }
        return buf.toString();
    }

    public boolean loadDescriptionFilesInDirectory(String aDirectory) {
        new File(aDirectory).list(new FilenameFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(File aFile, String aString) {
                if (aString.endsWith(".lst")) {
                    BufferedReader descriptionReader;
                    block9: {
                        descriptionReader = null;
                        File descriptionFile = new File(aFile.getPath() + File.separator + aString);
                        if (!descriptionFile.exists()) break block9;
                        descriptionReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(descriptionFile), "UTF-8"));
                        int length = (int)descriptionFile.length();
                        char[] inputLine = new char[length];
                        descriptionReader.read(inputLine, 0, length);
                        PlayerCharacter.this.setDescriptionLst(PlayerCharacter.this.getDescriptionLst() + new String(inputLine));
                    }
                    Object var8_8 = null;
                    if (descriptionReader == null) return false;
                    try {
                        descriptionReader.close();
                        return false;
                    }
                    catch (IOException e) {
                        Logging.errorPrint("Couldn't close descriptionReader in PlayerCharacter.loadDescriptionFilesInDirectory", e);
                    }
                    return false;
                    {
                        catch (IOException exception) {
                            Logging.errorPrint("IOException in PlayerCharacter.loadDescriptionFilesInDirectory", exception);
                            Object var8_9 = null;
                            if (descriptionReader == null) return false;
                            try {
                                descriptionReader.close();
                                return false;
                            }
                            catch (IOException e) {
                                Logging.errorPrint("Couldn't close descriptionReader in PlayerCharacter.loadDescriptionFilesInDirectory", e);
                            }
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (descriptionReader == null) throw throwable;
                        try {
                            descriptionReader.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            Logging.errorPrint("Couldn't close descriptionReader in PlayerCharacter.loadDescriptionFilesInDirectory", e);
                        }
                        throw throwable;
                    }
                }
                if (!aFile.isDirectory()) return false;
                PlayerCharacter.this.loadDescriptionFilesInDirectory(aFile.getPath() + File.separator + aString);
                return false;
            }
        });
        return false;
    }

    public void makeIntoExClass(PCClass aClass) {
        String exClass = aClass.getExClass();
        if (exClass.length() == 0) {
            return;
        }
        try {
            int idx;
            PCClass bClass = this.getClassNamed(exClass);
            if (bClass == null) {
                bClass = Globals.getClassNamed(exClass);
                if (bClass == null) {
                    return;
                }
                bClass = (PCClass)bClass.clone();
                this.rebuildLists(bClass, aClass, aClass.getLevel(), this);
                bClass.setLevel(aClass.getLevel(), this);
                bClass.setHitPointMap(aClass.getHitPointMap());
                idx = this.classList.indexOf(aClass);
                this.classList.set(idx, bClass);
            } else {
                this.rebuildLists(bClass, aClass, aClass.getLevel(), this);
                bClass.setLevel(bClass.getLevel() + aClass.getLevel(), this);
                for (int i = 0; i < aClass.getLevel(); ++i) {
                    bClass.setHitPoint(bClass.getLevel() + i + 1, aClass.getHitPoint(i + 1));
                }
                this.classList.remove(aClass);
            }
            for (idx = this.pcLevelInfo.size() - 1; idx >= 0; --idx) {
                PCLevelInfo li = (PCLevelInfo)this.pcLevelInfo.get(idx);
                if (!li.getClassKeyName().equals(aClass.getKeyName())) continue;
                li.setClassKeyName(bClass.getKeyName());
            }
            Iterator e = this.getSkillList().iterator();
            while (e.hasNext()) {
                Skill aSkill = (Skill)e.next();
                aSkill.replaceClassRank(aClass.getName(), exClass);
            }
            bClass.setSkillPool(aClass.getSkillPool(this));
        }
        catch (NumberFormatException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.INFORMATION);
        }
    }

    public int minXPForECL() {
        return PlayerCharacter.minXPForLevel(this.getECL(), this);
    }

    public int minXPForNextECL() {
        return PlayerCharacter.minXPForLevel(this.getECL() + 1, this);
    }

    public int miscAC() {
        return this.calcACOfType("Misc");
    }

    public int modFeat(String featName, boolean addIt, boolean addAll) {
        if (!this.importing) {
            this.getSpellList();
        }
        int retVal = addIt ? 1 : 0;
        boolean added = false;
        String subName = "";
        Feat aFeat = this.getFeatNonAggregateNamed(featName);
        String oldName = featName;
        if (aFeat == null && featName.endsWith(")")) {
            int idx = featName.indexOf(40);
            subName = featName.substring(idx + 1, featName.lastIndexOf(41));
            featName = featName.substring(0, idx).trim();
            aFeat = this.getFeatNonAggregateNamed(featName);
            if (addAll && aFeat != null && subName.length() != 0) {
                addAll = false;
            }
        }
        if (addIt && aFeat == null) {
            aFeat = Globals.getFeatNamed(featName);
            if (aFeat == null && (aFeat = Globals.getFeatNamed(oldName)) != null) {
                featName = oldName;
                subName = "";
            }
            if (aFeat == null) {
                Logging.errorPrint("Feat not found: " + oldName);
                return retVal;
            }
            aFeat = (Feat)aFeat.clone();
            this.addFeat(aFeat);
            aFeat.getTemplates(this.importing, this);
        }
        if (aFeat == null) {
            return retVal;
        }
        double j = (double)aFeat.getAssociatedCount() * aFeat.getCost(this) + this.feats;
        if (!addIt) {
            aFeat.modAdds(addIt, this);
        }
        boolean canSetFeats = true;
        if (addIt || aFeat.isMultiples()) {
            if (!addAll) {
                if ("".equals(subName)) {
                    canSetFeats = !aFeat.modChoices(this);
                } else if (addIt && aFeat.isWeaponProficiency()) {
                    this.addWeaponProfToList(this.featList, subName, false);
                    added = true;
                } else if (addIt && (aFeat.isStacks() || !aFeat.containsAssociated(subName))) {
                    aFeat.addAssociated(subName);
                } else if (!addIt && aFeat.containsAssociated(subName)) {
                    aFeat.removeAssociated(subName);
                }
            } else if (aFeat.getChoiceString().lastIndexOf(124) >= 0 && Globals.weaponTypesContains(aFeat.getChoiceString().substring(0, aFeat.getChoiceString().lastIndexOf(124)))) {
                this.addWeaponProfToList(this.featList, aFeat.getChoiceString().substring(0, aFeat.getChoiceString().lastIndexOf(124)), false);
            }
        }
        if (aFeat.isMultiples() && !addAll) {
            int n = retVal = aFeat.getAssociatedCount() > 0 ? 1 : 0;
        }
        if (!added && addIt) {
            aFeat.modAdds(addIt, this);
        }
        boolean removed = false;
        if (retVal == 0) {
            removed = this.featList.remove(aFeat);
            this.removeNaturalWeapons(aFeat);
            for (int x = 0; x < aFeat.templatesAdded().size(); ++x) {
                this.removeTemplate(this.getTemplateNamed((String)aFeat.templatesAdded().get(x)));
            }
        }
        if (!addIt && !aFeat.isMultiples() && removed) {
            j += aFeat.getCost(this);
        } else if (addIt && !aFeat.isMultiples()) {
            j -= aFeat.getCost(this);
        } else {
            int associatedListSize = aFeat.getAssociatedCount();
            if (!this.featList.isEmpty()) {
                Iterator e1 = this.featList.iterator();
                while (e1.hasNext()) {
                    Feat myFeat = (Feat)e1.next();
                    if (!myFeat.getName().equalsIgnoreCase(aFeat.getName())) continue;
                    associatedListSize = myFeat.getAssociatedCount();
                }
            }
            j -= (double)associatedListSize * aFeat.getCost(this);
        }
        if (!addAll && canSetFeats) {
            this.setFeats(j);
        }
        this.setAutomaticFeatsStable(false);
        if (addIt && !this.importing) {
            aFeat.globalChecks(false, this);
        }
        return retVal;
    }

    public int modFromArmorOnWeaponRolls() {
        Equipment eq;
        int bonus = 0;
        Iterator e = this.getEquipmentOfType("Armor", 1).iterator();
        while (e.hasNext()) {
            eq = (Equipment)e.next();
            if (eq == null || this.isProficientWith(eq)) continue;
            bonus += eq.acCheck(this).intValue();
        }
        e = this.getEquipmentOfType("Shield", 1).iterator();
        while (e.hasNext()) {
            eq = (Equipment)e.next();
            if (eq == null || this.isProficientWithShield(eq)) continue;
            bonus += eq.acCheck(this).intValue();
        }
        return bonus;
    }

    public int modToFromEquipment(String typeName) {
        int bonus = 0;
        int statBonus = 0;
        boolean used = false;
        int old = 0;
        boolean isMaxDex = false;
        boolean isACCheck = false;
        boolean isSpellFailure = false;
        boolean isAC = false;
        if ("MAXDEX".equals(typeName)) {
            isMaxDex = true;
        } else if ("ACCHECK".equals(typeName)) {
            isACCheck = true;
        } else if ("SPELLFAILURE".equals(typeName)) {
            isSpellFailure = true;
        } else if ("AC".equals(typeName)) {
            isAC = true;
        }
        if (isMaxDex) {
            bonus = statBonus = (int)this.getStatBonusTo("MISC", "MAXDEX");
        }
        int load = 0;
        if (Globals.checkRule("SYS_LDPACSK")) {
            load = Globals.loadTypeForLoadScore(this.getVariableValue("LOADSCORE", "").intValue(), this.totalWeight(), this);
        }
        if (load == 1 && isACCheck) {
            old = -3;
        } else if (load == 2 && isACCheck) {
            old = -6;
        } else if (load == 1 && isMaxDex) {
            used = true;
            bonus = 3;
        } else if (load == 2 && isMaxDex) {
            used = true;
            bonus = 1;
        } else if (load == 3 && isMaxDex) {
            used = true;
            bonus = 0;
        }
        Iterator e = this.equipmentList.iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            if (isAC) {
                bonus += eq.getACMod(this).intValue();
                continue;
            }
            if (isACCheck) {
                bonus += eq.acCheck(this).intValue();
                continue;
            }
            if (isSpellFailure) {
                bonus += eq.spellFailure(this).intValue();
                continue;
            }
            if (!isMaxDex || (old = eq.getMaxDex(this).intValue()) == 100) continue;
            if (!used || bonus > old) {
                bonus = old;
            }
            used = true;
        }
        if (isSpellFailure) {
            bonus += (int)this.getTotalBonusTo("MISC", "SPELLFAILURE");
        } else if (isACCheck) {
            bonus = Math.min(bonus, old);
            bonus += (int)this.getTotalBonusTo("MISC", "ACCHECK");
        } else if (isMaxDex) {
            if (!used) {
                bonus = 100;
            }
            if ((bonus += (int)this.getTotalBonusTo("MISC", "MAXDEX") - statBonus) < 0) {
                bonus = 0;
            } else if (bonus > 100) {
                bonus = 100;
            }
        }
        return bonus;
    }

    public double movement(int moveIdx) {
        double moveInFeet = this.getMovement(moveIdx);
        List aList = this.getEquipmentOfType("Armor", 1);
        int armorLoad = 0;
        if (aList.size() > 0) {
            Iterator a = aList.iterator();
            while (a.hasNext()) {
                Equipment armor = (Equipment)a.next();
                if (armor.isShield()) continue;
                if (armor.isHeavy() && !this.ignoreEncumberedArmorMove(2)) {
                    armorLoad = Math.max(armorLoad, 2);
                    continue;
                }
                if (!armor.isMedium() || this.ignoreEncumberedArmorMove(1)) continue;
                armorLoad = Math.max(armorLoad, 1);
            }
        }
        double armorMove = Globals.calcEncumberedMove(armorLoad, moveInFeet, true, null);
        int pcLoad = Globals.loadTypeForLoadScore(this.getVariableValue("LOADSCORE", "").intValue(), this.totalWeight(), this);
        double loadMove = Globals.calcEncumberedMove(pcLoad, moveInFeet, true, this);
        moveInFeet = Math.min(armorMove, loadMove);
        moveInFeet += this.getTotalBonusTo("MOVEADD", "TYPE." + this.getMovementType(moveIdx).toUpperCase());
        double calcMove = moveInFeet += this.getTotalBonusTo("MOVEADD", "TYPE.ALL");
        if (this.getMovementMult(moveIdx) > 0.0) {
            calcMove = this.calcMoveMult(moveInFeet, moveIdx);
        }
        double moveMult = this.getTotalBonusTo("MOVEMULT", "TYPE." + this.getMovementType(moveIdx).toUpperCase());
        if ((moveMult += this.getTotalBonusTo("MOVEMULT", "TYPE.ALL")) > 0.0) {
            calcMove = (int)(calcMove * moveMult);
        }
        double postMove = moveInFeet;
        postMove += this.getTotalBonusTo("POSTMOVEADD", "TYPE." + this.getMovementType(moveIdx).toUpperCase());
        moveInFeet = Math.max(calcMove, postMove += this.getTotalBonusTo("POSTMOVEADD", "TYPE.ALL"));
        return Globals.convertDistanceToUnitSet(moveInFeet);
    }

    public double multiclassXPMultiplier() {
        PCClass aClass;
        TreeSet<String> unfavoredClasses = new TreeSet<String>();
        SortedSet aList = this.getFavoredClasses();
        boolean hasAny = false;
        String maxClass = "";
        String secondClass = "";
        int maxClassLevel = 0;
        int secondClassLevel = 0;
        int xpPenalty = 0;
        double xpMultiplier = 1.0;
        if (aList.contains("Any")) {
            hasAny = true;
        }
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            aClass = (PCClass)e.next();
            if (aList.contains(aClass.getDisplayClassName()) || aList.contains(aClass.toString()) || !aClass.hasXPPenalty()) continue;
            unfavoredClasses.add(aClass.getDisplayClassName());
            if (aClass.getLevel() > maxClassLevel) {
                if (hasAny) {
                    secondClassLevel = maxClassLevel;
                    secondClass = maxClass;
                }
                maxClassLevel = aClass.getLevel();
                maxClass = aClass.getDisplayClassName();
                continue;
            }
            if (aClass.getLevel() <= secondClassLevel || !hasAny) continue;
            secondClassLevel = aClass.getLevel();
            secondClass = aClass.getDisplayClassName();
        }
        if (hasAny && secondClassLevel > 0) {
            maxClassLevel = secondClassLevel;
            unfavoredClasses.remove(maxClass);
            maxClass = secondClass;
        }
        if (maxClassLevel > 0) {
            unfavoredClasses.remove(maxClass);
            e = unfavoredClasses.iterator();
            while (e.hasNext()) {
                aClass = this.getClassDisplayNamed((String)e.next());
                if (aClass == null || maxClassLevel - aClass.getLevel() <= 1) continue;
                ++xpPenalty;
            }
            xpMultiplier = 1.0 - (double)xpPenalty * 0.2;
            if (xpMultiplier < 0.0) {
                xpMultiplier = 0.0;
            }
        }
        return xpMultiplier;
    }

    public int naturalAC() {
        return this.calcACOfType("NaturalArmor");
    }

    public String parseSpellString(Spell aSpell, String aString, PObject anObj) {
        String aSpellClass = null;
        if (anObj instanceof Domain) {
            CharacterDomain aCD = this.getCharacterDomainForDomain(anObj.getName());
            if (aCD != null && aCD.isFromPCClass()) {
                aSpellClass = "CLASS:" + this.getClassNamed(aCD.getObjectName());
            }
        } else if (anObj instanceof PCClass) {
            aSpellClass = "CLASS:" + anObj.getName();
        } else if (anObj instanceof Race) {
            aSpellClass = "RACE:" + anObj.getName();
        }
        if (aSpellClass == null) {
            return aString;
        }
        while (aString.lastIndexOf(40) >= 0) {
            int y;
            boolean found = false;
            int x = CoreUtility.innerMostStringStart(aString);
            if (x > (y = CoreUtility.innerMostStringEnd(aString)) || x >= aString.length() || y <= 0 || y >= aString.length()) break;
            String inCalc = aString.substring(x + 1, y);
            Float fVal = this.getVariableValue(aSpell, inCalc, aSpellClass);
            int anInt = 0;
            if (!CoreUtility.doublesEqual(fVal.floatValue(), 0.0)) {
                found = true;
                anInt = fVal.intValue();
            } else if (inCalc.indexOf("MIN") >= 0 || inCalc.indexOf("MAX") >= 0) {
                found = true;
                anInt = fVal.intValue();
            }
            if (found) {
                aString = aString.substring(0, x) + anInt + aString.substring(y + 1);
                continue;
            }
            aString = aString.substring(0, x) + "[" + inCalc + "]" + aString.substring(y + 1);
        }
        return aString;
    }

    public void populateSkills(int level, int visible) {
        Globals.sortPObjectList(this.getSkillList());
        this.removeExcessSkills(level);
        this.addNewSkills(level);
        this.removeInvisibleSkills(visible);
        int sort = -1;
        boolean sortOrder = false;
        switch (this.getSkillsOutputOrder()) {
            case 0: {
                sort = 0;
                sortOrder = true;
                break;
            }
            case 1: {
                sort = 0;
                sortOrder = false;
                break;
            }
            case 2: {
                sort = 1;
                sortOrder = true;
                break;
            }
            case 3: {
                sort = 1;
                sortOrder = false;
                break;
            }
            default: {
                return;
            }
        }
        ArrayList localSkillList = this.getSkillList();
        SkillComparator comparator = new SkillComparator(sort, sortOrder);
        int nextOutputIndex = 1;
        Collections.sort(localSkillList, comparator);
        Iterator sI = localSkillList.iterator();
        while (sI.hasNext()) {
            Skill aSkill = (Skill)sI.next();
            if (aSkill.getOutputIndex() < 0) continue;
            aSkill.setOutputIndex(nextOutputIndex++);
        }
    }

    public void removeCharacterDomain(CharacterDomain aCD) {
        if (!this.characterDomainList.isEmpty()) {
            this.characterDomainList.remove(aCD);
            this.setDirty(true);
        }
    }

    public void removeNaturalWeapons(PObject obj) {
        Iterator e = obj.getNaturalWeapons().iterator();
        while (e.hasNext()) {
            Equipment weapon = (Equipment)e.next();
            this.removeEquipment(weapon);
            this.delEquipSetItem(weapon);
            this.setDirty(true);
        }
    }

    public void removeTempBonus(BonusObj aBonus) {
        this.getTempBonusList().remove(aBonus);
        this.setDirty(true);
    }

    public void removeTempBonusItemList(Equipment aEq) {
        this.getTempBonusItemList().remove(aEq);
        this.setDirty(true);
    }

    public void removeTemplate(PCTemplate inTmpl) {
        int i;
        if (inTmpl == null) {
            return;
        }
        if (inTmpl.weaponProfAutos != null) {
            this.weaponProfList.removeAll(inTmpl.getWeaponProfAutos());
        }
        this.getLanguagesList().removeAll(inTmpl.getAutoLanguages());
        this.templateAutoLanguages.removeAll(inTmpl.getAutoLanguages());
        this.templateLanguages.removeAll(inTmpl.getLanguageBonus());
        this.removeNaturalWeapons(inTmpl);
        for (i = 0; i < inTmpl.templatesAdded().size(); ++i) {
            this.removeTemplate(this.getTemplateNamed((String)inTmpl.templatesAdded().get(i)));
        }
        for (i = 0; i < this.templateList.size(); ++i) {
            if (!((PCTemplate)this.templateList.get(i)).getName().equals(inTmpl.getName())) continue;
            this.templateList.remove(i);
            break;
        }
        if (!PlayerCharacter.canReassignTemplateFeats()) {
            this.setAutomaticFeatsStable(false);
        }
        this.setQualifyListStable(false);
        this.getSpellList();
        this.calcActiveBonuses();
        this.setDirty(true);
    }

    public String replaceMasterString(String aString, int aNum) {
        int x;
        while ((x = aString.indexOf("MASTER")) != -1) {
            String leftString = aString.substring(0, x);
            String rightString = aString.substring(x + 6);
            aString = leftString + Integer.toString(aNum) + rightString;
        }
        return aString;
    }

    public PCLevelInfo saveLevelInfo(String classKeyName) {
        PCLevelInfo li = new PCLevelInfo(classKeyName);
        this.pcLevelInfo.add(li);
        return li;
    }

    public void saveStatIncrease(String statAbb, int mod, boolean isPreMod) {
        int idx = this.getLevelInfoSize() - 1;
        if (idx >= 0) {
            ((PCLevelInfo)this.pcLevelInfo.get(idx)).addModifiedStat(statAbb, mod, isPreMod);
        }
        this.setDirty(true);
    }

    public int sizeAC() {
        return this.calcACOfType("Size");
    }

    public int sizeInt() {
        int iSize = this.racialSizeInt();
        if (this.race != null) {
            iSize += (int)this.getTotalBonusTo("SIZEMOD", "NUMBER");
            for (int i = 0; i < this.race.sizesAdvanced(this.totalHitDice()); ++i) {
                ++iSize;
            }
            if (iSize < 0) {
                iSize = 0;
            }
            if (iSize >= SystemCollections.getSizeAdjustmentListSize()) {
                iSize = SystemCollections.getSizeAdjustmentListSize() - 1;
            }
        }
        return iSize;
    }

    public int totalHitDice() {
        return this.race.hitDice(this) + this.totalMonsterLevels();
    }

    public int totalNonMonsterLevels() {
        int totalLevels = 0;
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            if (aClass.isMonster()) continue;
            totalLevels += aClass.getLevel();
        }
        return totalLevels;
    }

    public BigDecimal totalValue() {
        BigDecimal totalValue = BigDecimalHelper.ZERO;
        if (!this.getEquipmentMasterList().isEmpty()) {
            Iterator e = this.getEquipmentMasterList().iterator();
            while (e.hasNext()) {
                Equipment eq = (Equipment)e.next();
                totalValue = totalValue.add(eq.getCost(this).multiply(new BigDecimal(eq.qty())));
            }
        }
        return totalValue;
    }

    public Float totalWeight() {
        float totalWeight = 0.0f;
        Float floatZero = new Float(0.0f);
        boolean firstClothing = true;
        if (this.equipmentList.isEmpty()) {
            return floatZero;
        }
        Iterator e = this.equipmentList.iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (eq.getCarried().compareTo(floatZero) <= 0 || eq.getParent() != null) continue;
            if (eq.getChildCount() > 0) {
                totalWeight = (float)((double)totalWeight + (eq.getWeightAsDouble(this) + (double)eq.getContainedWeight(this).floatValue()));
                continue;
            }
            if (firstClothing && eq.isEquipped() && eq.isType("CLOTHING")) {
                firstClothing = false;
                totalWeight = (float)((double)totalWeight + eq.getWeightAsDouble(this) * (double)Math.max(eq.getCarried().floatValue() - 1.0f, 0.0f));
                continue;
            }
            totalWeight = (float)((double)totalWeight + eq.getWeightAsDouble(this) * (double)eq.getCarried().floatValue());
        }
        return new Float(totalWeight);
    }

    public int touchAC() {
        return this.calcACOfType("Touch");
    }

    public void updateEquipSetItem(Equipment oldItem, Equipment newItem) {
        EquipSet es;
        if (this.equipSetList.isEmpty()) {
            return;
        }
        ArrayList<EquipSet> tmpList = new ArrayList<EquipSet>();
        Iterator eSet = this.equipSetList.iterator();
        while (eSet.hasNext()) {
            es = (EquipSet)eSet.next();
            Equipment eqI = es.getItem();
            if (eqI == null || !oldItem.equals(eqI)) continue;
            tmpList.add(es);
        }
        eSet = tmpList.iterator();
        while (eSet.hasNext()) {
            es = (EquipSet)eSet.next();
            es.setValue(newItem.getName());
            es.setItem(newItem);
        }
        this.setDirty(true);
    }

    public boolean wasEverSaved() {
        return !"".equals(this.getFileName());
    }

    void setActiveBonusStack(double bonus, String bonusType) {
        String aVal;
        if (bonusType != null) {
            if (!((bonusType = bonusType.toUpperCase()).startsWith("ITEMWEIGHT") || bonusType.startsWith("ITEMCOST") || bonusType.startsWith("ACVALUE") || bonusType.startsWith("ITEMCAPACITY") || bonusType.startsWith("LOADMULT") || bonusType.indexOf("DAMAGEMULT") >= 0)) {
                bonus = (int)bonus;
            }
        } else {
            return;
        }
        int index = -1;
        StringTokenizer aTok = new StringTokenizer(bonusType, ":");
        if (aTok.countTokens() == 2) {
            String aString = aTok.nextToken();
            aString = aTok.nextToken();
            if (aString != null) {
                index = SystemCollections.getUnmodifiableBonusStackList().indexOf(aString);
            }
        } else {
            index = 1;
        }
        if (bonusType.endsWith(".STACK") || bonusType.endsWith(".REPLACE")) {
            index = 1;
        }
        if (bonus < 0.0) {
            index = 1;
        }
        if (index == -1) {
            aVal = (String)this.getActiveBonusMap().get(bonusType);
            if (aVal == null) {
                this.putActiveBonusMap(bonusType, String.valueOf(bonus));
            } else {
                this.putActiveBonusMap(bonusType, String.valueOf(Math.max(bonus, (double)Float.parseFloat(aVal))));
            }
        } else {
            if (bonusType == null) {
                bonusType = "";
            }
            if ((aVal = (String)this.getActiveBonusMap().get(bonusType)) == null) {
                this.putActiveBonusMap(bonusType, String.valueOf(bonus));
            } else {
                this.putActiveBonusMap(bonusType, String.valueOf(bonus + (double)Float.parseFloat(aVal)));
            }
        }
    }

    List getAvailableFeatNames(String featType) {
        return this.getAvailableFeatNames(featType, false);
    }

    List getAvailableFeatNames(String featType, boolean autoQualify) {
        ArrayList<String> aFeatList = new ArrayList<String>();
        List globalFeatList = Globals.getFeatList();
        int globalFeatListSize = globalFeatList.size();
        for (int index = 0; index < globalFeatListSize; ++index) {
            Feat aFeat = (Feat)globalFeatList.get(index);
            if (!aFeat.matchesType(featType) || !autoQualify && !this.qualifiesForFeat(aFeat.getKeyName()) || (this.hasFeat(aFeat.getName()) || this.hasFeatAutomatic(aFeat.getName())) && !aFeat.isMultiples()) continue;
            aFeatList.add(aFeat.getKeyName());
        }
        return aFeatList;
    }

    boolean isImporting() {
        return this.importing;
    }

    Double getMovementMult(int moveIdx) {
        if (this.getMovements() != null && moveIdx < this.movementMult.length) {
            return this.movementMult[moveIdx];
        }
        return new Double(0.0);
    }

    ArrayList getQualifyList() {
        if (!this.qualifyListStable) {
            this.qualifyArrayList = new ArrayList();
            Iterator i = this.getPObjectList().iterator();
            while (i.hasNext()) {
                PObject aPObj = (PObject)i.next();
                if (aPObj == null) continue;
                String qString = aPObj.getQualifyString();
                StringTokenizer aTok = new StringTokenizer(qString, "|");
                while (aTok.hasMoreTokens()) {
                    String qualifier = aTok.nextToken();
                    if (this.qualifyArrayList.contains(qualifier)) continue;
                    this.qualifyArrayList.add(qualifier);
                }
            }
            this.setQualifyListStable(true);
        }
        return this.qualifyArrayList;
    }

    void addVariable(String variableString) {
        this.variableList.add(variableString);
        this.setDirty(true);
    }

    void giveClassesAway(PCClass toClass, PCClass fromClass, int iCount) {
        PCLevelInfo pcl;
        if (toClass == null || fromClass == null) {
            return;
        }
        if (toClass.getLevel() + iCount > toClass.getMaxLevel()) {
            iCount = toClass.getMaxLevel() - toClass.getLevel();
        }
        if (fromClass.getLevel() <= iCount || iCount < 1) {
            return;
        }
        int iFromLevel = fromClass.getLevel() - iCount;
        int iToLevel = toClass.getLevel();
        toClass.setLevel(iToLevel + iCount, this);
        for (int i = 0; i < iCount; ++i) {
            toClass.setHitPoint(iToLevel + i, fromClass.getHitPoint(iFromLevel + i));
            fromClass.setHitPoint(iFromLevel + i, new Integer(0));
        }
        this.rebuildLists(toClass, fromClass, iCount, this);
        fromClass.setLevel(iFromLevel, this);
        Iterator li = this.pcLevelInfo.iterator();
        while (li.hasNext()) {
            pcl = (PCLevelInfo)li.next();
            if (!pcl.getClassKeyName().equals(toClass.getKeyName())) continue;
            int iTo = pcl.getLevel() + toClass.getLevel() - iToLevel;
            pcl.setLevel(iTo);
        }
        li = this.pcLevelInfo.iterator();
        while (li.hasNext()) {
            pcl = (PCLevelInfo)li.next();
            if (!pcl.getClassKeyName().equals(fromClass.getKeyName()) || pcl.getLevel() <= iFromLevel) continue;
            int iFrom = pcl.getLevel() - iFromLevel;
            pcl.setClassKeyName(toClass.getKeyName());
            pcl.setLevel(iFrom);
        }
    }

    boolean qualifiesForFeat(String featName) {
        Feat aFeat = Globals.getFeatNamed(featName);
        if (aFeat != null) {
            return this.qualifiesForFeat(aFeat);
        }
        return false;
    }

    int getCharacterDomainIndex(String domainName) {
        for (int i = 0; i < this.characterDomainList.size(); ++i) {
            CharacterDomain aCD = (CharacterDomain)this.characterDomainList.get(i);
            Domain aDomain = aCD.getDomain();
            if (aDomain == null || !aDomain.getName().equalsIgnoreCase(domainName)) continue;
            return i;
        }
        return -1;
    }

    boolean addFavoredClass(String aString) {
        if (aString.length() != 0 && !this.favoredClasses.contains(aString)) {
            this.favoredClasses.add(aString);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    void addFreeLanguage(String aString) {
        Language aLang = Globals.getLanguageNamed(aString);
        if (aLang != null && !this.getLanguagesList().contains(aLang)) {
            this.getLanguagesList().add(aLang);
            ++this.freeLangs;
            this.setDirty(true);
        }
    }

    boolean hasSpecialAbility(SpecialAbility sa) {
        String saName = sa.getName();
        String saDesc = sa.getSADesc();
        Iterator e = this.getSpecialAbilityList().iterator();
        while (e.hasNext()) {
            SpecialAbility saFromList = (SpecialAbility)e.next();
            if (!saFromList.getName().equalsIgnoreCase(saName) || !saFromList.getSADesc().equalsIgnoreCase(saDesc)) continue;
            return true;
        }
        return false;
    }

    void modFeatsFromList(String aList, boolean addIt, boolean all) {
        StringTokenizer aTok = new StringTokenizer(aList, ",");
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            Feat aFeat = this.getFeatNamed(aString);
            StringTokenizer bTok = null;
            if (aFeat != null) continue;
            aFeat = Globals.getFeatNamed(aString);
            if (aFeat == null) {
                bTok = new StringTokenizer(aString, "()", true);
                String bString = bTok.nextToken();
                int beginIndex = bString.length() + 1;
                int endIndex = aString.lastIndexOf(41);
                bTok = beginIndex <= aString.length() ? (endIndex >= beginIndex ? new StringTokenizer(aString.substring(beginIndex, endIndex), ",") : new StringTokenizer(aString.substring(beginIndex), ",")) : null;
                aString = bString.replace('(', ' ').replace(')', ' ').trim();
            } else {
                Feat bFeat = this.getFeatNamed(aFeat.getName());
                if (bFeat != null) {
                    aFeat = bFeat;
                } else {
                    aFeat = (Feat)aFeat.clone();
                    this.addFeat(aFeat);
                }
            }
            if (aFeat == null) {
                if (!addIt) {
                    return;
                }
                aFeat = Globals.getFeatNamed(aString);
                if (aFeat == null) {
                    Logging.errorPrint("Feat not found in PlayerCharacter.modFeatsFromList: " + aString);
                    return;
                }
                aFeat = (Feat)aFeat.clone();
                this.addFeat(aFeat);
            }
            if (bTok != null && bTok.hasMoreTokens()) {
                while (bTok.hasMoreTokens()) {
                    aString = bTok.nextToken();
                    if ("DEITYWEAPON".equals(aString)) {
                        WeaponProf wp = null;
                        if (this.getDeity() != null) {
                            wp = Globals.getWeaponProfNamed(this.getDeity().getFavoredWeapon());
                        }
                        if (wp == null) continue;
                        if (addIt) {
                            aFeat.addAssociated(wp.getName());
                            continue;
                        }
                        aFeat.removeAssociated(wp.getName());
                        continue;
                    }
                    if (addIt) {
                        aFeat.addAssociated(aString);
                        continue;
                    }
                    aFeat.removeAssociated(aString);
                }
            } else {
                if (!all && !aFeat.isMultiples()) {
                    if (addIt) {
                        this.setFeats(this.getFeats() + aFeat.getCost(this));
                    } else {
                        this.setFeats(this.getFeats() - aFeat.getCost(this));
                    }
                }
                this.modFeat(aString, addIt, all);
            }
            if (!aFeat.getName().endsWith("Weapon Proficiency")) continue;
            for (int e = 0; e < aFeat.getAssociatedCount(); ++e) {
                String wprof = aFeat.getAssociated(e);
                WeaponProf wp = Globals.getWeaponProfNamed(wprof);
                if (wp == null) continue;
                this.addWeaponProfToList(this.featList, wprof, false);
            }
        }
        this.setAutomaticFeatsStable(false);
    }

    boolean removeFavoredClass(String aString) {
        if (this.favoredClasses.contains(aString)) {
            this.favoredClasses.remove(aString);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    void removeVariable(String variableString) {
        Iterator e = this.variableList.iterator();
        while (e.hasNext()) {
            String aString = (String)e.next();
            if (!aString.startsWith(variableString)) continue;
            e.remove();
            this.setDirty(true);
        }
    }

    void validateCharacterDomains() {
        if (!this.importing) {
            this.getSpellList();
        }
        for (int i = this.characterDomainList.size() - 1; i >= 0; --i) {
            CharacterDomain aCD = (CharacterDomain)this.characterDomainList.get(i);
            if (aCD.isDomainValidFor(this)) continue;
            this.characterDomainList.remove(aCD);
        }
    }

    private static String getBestUDamString(String oldString, String newString) {
        if (newString == null || newString.length() < 2) {
            return oldString;
        }
        StringTokenizer aTok = new StringTokenizer(oldString, "|");
        int sides = Integer.parseInt(aTok.nextToken());
        String retString = oldString;
        aTok = new StringTokenizer(newString, " dD+-(x)");
        if (aTok.countTokens() > 1) {
            aTok.nextToken();
            int i = Integer.parseInt(aTok.nextToken());
            if (sides < i) {
                sides = i;
                retString = sides + "|" + newString;
            }
        }
        return retString;
    }

    private static boolean canReassignRacialFeats() {
        return false;
    }

    private static boolean canReassignTemplateFeats() {
        return false;
    }

    private double getActiveBonusForMapKey(String aKey, double defaultValue) {
        aKey = aKey.toUpperCase();
        String regVal = (String)this.getActiveBonusMap().get(aKey);
        if (regVal != null) {
            return Float.parseFloat(regVal);
        }
        return defaultValue;
    }

    private List getActiveBonusList() {
        return this.activeBonusList;
    }

    private List getAutoArmorProfList() {
        ArrayList aList = new ArrayList();
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            PObject aPObj = (PObject)i.next();
            if (aPObj == null) continue;
            aPObj.addAutoTagsToList("ARMORPROF", aList, this);
        }
        return aList;
    }

    private boolean isAutomaticFeatsStable() {
        return this.automaticFeatsStable;
    }

    private double getCheckBonusTo(String aType, String aName) {
        double bonus = 0.0;
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        List aList = SettingsHandler.getGame().getUnmodifiableCheckList();
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            PObject obj = (PObject)i.next();
            List tempList = obj.getBonusListOfType(aType, aName);
            if (tempList.isEmpty()) continue;
            bonus += this.calcBonusFromList(tempList);
        }
        return bonus;
    }

    private void setClassLevelsBrazenlyTo(Map lvlMap) {
        Iterator i = this.classList.iterator();
        while (i.hasNext()) {
            PCClass aClass = (PCClass)i.next();
            String lvl = (String)lvlMap.get(aClass.getName());
            if (lvl == null) {
                lvl = "0";
            }
            aClass.setLevelWithoutConsequence(Integer.parseInt(lvl));
        }
        this.calcActiveBonuses();
    }

    private String getDisplayClassName() {
        return this.classList.isEmpty() ? "Nobody" : ((PCClass)this.classList.get(this.classList.size() - 1)).getDisplayClassName();
    }

    private String getDisplayRaceName() {
        String raceName = this.getRace().toString();
        return raceName.equals("<none selected>") ? "Nothing" : raceName;
    }

    private static Feat getFeatNamedInList(List aFeatList, String featName, int featType) {
        if (aFeatList.isEmpty()) {
            return null;
        }
        Iterator e = aFeatList.iterator();
        while (e.hasNext()) {
            Feat aFeat = (Feat)e.next();
            if (!aFeat.getName().equalsIgnoreCase(featName) || featType != -1 && aFeat.getFeatType() != featType) continue;
            return aFeat;
        }
        return null;
    }

    private SortedSet getAutoWeaponProfs(List aFeatList) {
        String aString;
        int i;
        SortedSet<String> results = new TreeSet();
        Race aRace = this.getRace();
        if (aRace != null) {
            results = this.addWeaponProfsLists(aRace.getWeaponProfAutos(), results, aFeatList, true);
            for (int i2 = 0; i2 < aRace.getSelectedWeaponProfBonusCount(); ++i2) {
                String aString2 = aRace.getSelectedWeaponProfBonus(i2);
                results.add(aString2);
                this.addWeaponProfToList(aFeatList, aString2, true);
            }
            aRace.addAutoTagsToList("WEAPONPROF", (AbstractCollection)((Object)results), this);
        }
        Iterator e = this.getTemplateList().iterator();
        while (e.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)e.next();
            results = this.addWeaponProfsLists(aTemplate.getWeaponProfAutos(), results, aFeatList, true);
            for (i = 0; i < aTemplate.getSelectedWeaponProfBonusCount(); ++i) {
                aString = aTemplate.getSelectedWeaponProfBonus(i);
                results.add(aString);
                this.addWeaponProfToList(aFeatList, aString, true);
            }
            aTemplate.addAutoTagsToList("WEAPONPROF", (AbstractCollection)((Object)results), this);
        }
        e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            results = this.addWeaponProfsLists(aClass.getWeaponProfAutos(), results, aFeatList, true);
            for (i = 0; i < aClass.getSelectedWeaponProfBonusCount(); ++i) {
                aString = aClass.getSelectedWeaponProfBonus(i);
                results.add(aString);
                this.addWeaponProfToList(aFeatList, aString, true);
            }
            aClass.addAutoTagsToList("WEAPONPROF", (TreeSet)results, this);
        }
        this.setAggregateFeatsStable(false);
        e = this.aggregateFeatList().iterator();
        while (e.hasNext()) {
            Feat aFeat = (Feat)e.next();
            results = this.addWeaponProfsLists(aFeat.getWeaponProfAutos(), results, aFeatList, true);
            for (i = 0; i < aFeat.getSelectedWeaponProfBonusCount(); ++i) {
                aString = aFeat.getSelectedWeaponProfBonus(i);
                results.add(aString);
                this.addWeaponProfToList(aFeatList, aString, true);
            }
            aFeat.addAutoTagsToList("WEAPONPROF", (TreeSet)results, this);
        }
        e = this.getSkillList().iterator();
        while (e.hasNext()) {
            Skill aSkill = (Skill)e.next();
            results = this.addWeaponProfsLists(aSkill.getWeaponProfAutos(), results, aFeatList, true);
            aSkill.addAutoTagsToList("WEAPONPROF", (TreeSet)results, this);
        }
        e = this.equipmentList.iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            results = this.addWeaponProfsLists(eq.getWeaponProfAutos(), results, aFeatList, true);
            eq.addAutoTagsToList("WEAPONPROF", (TreeSet)results, this);
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    results = this.addWeaponProfsLists(eqMod.getWeaponProfAutos(), results, aFeatList, true);
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                results = this.addWeaponProfsLists(eqMod.getWeaponProfAutos(), results, aFeatList, true);
            }
        }
        if (this.deity != null) {
            results = this.addWeaponProfsLists(this.deity.getWeaponProfAutos(), results, aFeatList, true);
            this.deity.addAutoTagsToList("WEAPONPROF", (TreeSet)results, this);
        }
        e = this.characterDomainList.iterator();
        while (e.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)e.next();
            Domain aDomain = aCD.getDomain();
            if (aDomain == null) continue;
            results = this.addWeaponProfsLists(aDomain.getWeaponProfAutos(), results, aFeatList, true);
            for (int i3 = 0; i3 < aDomain.getSelectedWeaponProfBonusCount(); ++i3) {
                String aString3 = aDomain.getSelectedWeaponProfBonus(i3);
                results.add(aString3);
                this.addWeaponProfToList(aFeatList, aString3, true);
            }
            aDomain.addAutoTagsToList("WEAPONPROF", (TreeSet)results, this);
        }
        this.weaponProfList.addAll(results);
        return results;
    }

    public double getEquipmentBonusTo(String aType, String aName) {
        double bonus = 0.0;
        if (this.equipmentList.isEmpty()) {
            return bonus;
        }
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        Iterator e = this.equipmentList.iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            List tempList = eq.getBonusListOfType(aType, aName, true);
            if (eq.isWeapon() && eq.isDouble()) {
                tempList.addAll(eq.getBonusListOfType(aType, aName, false));
            }
            bonus += this.calcBonusFromList(tempList);
        }
        return bonus;
    }

    private Feat getFeatKeyed(String featName, List afeatList) {
        if (afeatList.isEmpty()) {
            return null;
        }
        Iterator e = afeatList.iterator();
        while (e.hasNext()) {
            Feat aFeat = (Feat)e.next();
            if (!aFeat.getKeyName().equalsIgnoreCase(featName)) continue;
            return aFeat;
        }
        return null;
    }

    private String getFullDisplayClassName() {
        if (this.classList.isEmpty()) {
            return "Nobody";
        }
        StringBuffer buf = new StringBuffer();
        Iterator it = this.classList.iterator();
        buf.append(((PCClass)it.next()).getFullDisplayClassName());
        while (it.hasNext()) {
            buf.append("/").append(((PCClass)it.next()).getFullDisplayClassName());
        }
        return buf.toString();
    }

    private Map getLevelHashMap(int maxLevel) {
        HashMap<String, String> lvlMap = new HashMap<String, String>();
        for (int i = 0; i < this.getLevelInfoSize(); ++i) {
            String classKeyName = this.getLevelInfoClassKeyName(i);
            String val = (String)lvlMap.get(classKeyName);
            if (val == null) {
                val = "0";
            }
            val = String.valueOf(Integer.parseInt(val) + 1);
            lvlMap.put(classKeyName, val);
            if (--maxLevel <= 0) break;
        }
        return lvlMap;
    }

    private void setMoveFromList(List aList) {
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            PObject pObj;
            Object anObj = e.next();
            if (!(anObj instanceof PObject) || (pObj = (PObject)anObj).getNumberOfMovements() < 1) continue;
            for (int i = 0; i < pObj.getNumberOfMovements(); ++i) {
                this.setMyMoveRates(pObj.getMovementType(i), pObj.getMovement(i), pObj.getMovementMult(i), pObj.getMovementMultOp(i), pObj.getMoveRatesFlag());
            }
        }
    }

    private Double[] getMovements() {
        return this.movements;
    }

    private void setMyMoveRates(String moveType, double anDouble, Double moveMult, String multOp, int moveFlag) {
        Double moveRate = new Double(anDouble);
        if ("ALL".equals(moveType)) {
            if (moveFlag == 0) {
                for (int i = 0; i < this.movements.length; ++i) {
                    this.movements[i] = moveRate = new Double(anDouble);
                }
            } else {
                for (int i = 0; i < this.movements.length; ++i) {
                    this.movements[i] = moveRate = new Double(anDouble + this.movements[i]);
                }
            }
        } else if (moveFlag == 0) {
            moveRate = new Double(anDouble);
            for (int i = 0; i < this.movements.length; ++i) {
                if (!moveType.equals(this.movementTypes[i])) continue;
                this.movements[i] = moveRate;
                this.movementMult[i] = moveMult;
                this.movementMultOp[i] = multOp;
                return;
            }
            this.increaseMoveArray(moveRate, moveType, moveMult, multOp);
        } else if (moveFlag == 1) {
            for (int i = 0; i < this.movements.length; ++i) {
                moveRate = new Double(anDouble + this.movements[i]);
                if (moveType.equals(this.movementTypes[i])) {
                    this.movements[i] = moveRate;
                    this.movementMult[i] = moveMult;
                    this.movementMultOp[i] = multOp;
                    return;
                }
                this.increaseMoveArray(moveRate, moveType, moveMult, multOp);
            }
        } else {
            moveRate = new Double(anDouble + this.movements[0]);
            for (int i = 0; i < this.movements.length; ++i) {
                if (!moveType.equals(this.movementTypes[i])) continue;
                this.movements[i] = moveRate;
                this.movementMult[i] = moveMult;
                this.movementMultOp[i] = multOp;
                return;
            }
            this.increaseMoveArray(moveRate, moveType, moveMult, multOp);
        }
        this.setDirty(true);
    }

    private int getNumAttacks() {
        return Math.min(Math.max(this.baseAttackBonus() / 5, 4), 1);
    }

    private String getOrdinal(int cardinal) {
        switch (cardinal) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    private double getPObjectWithCostBonusTo(List aList, String aType, String aName, boolean subSearch) {
        double iBonus = 0.0;
        if (aList.isEmpty()) {
            return iBonus;
        }
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            PObject anObj = (PObject)e.next();
            List tempList = anObj.getBonusListOfType(aType, aName);
            iBonus += this.calcBonusWithCostFromList(tempList, subSearch);
        }
        return iBonus;
    }

    private static void setProf(Equipment equip, Equipment eqm) {
        String profName = equip.rawProfName();
        if (profName.length() == 0) {
            profName = equip.getName();
        }
        eqm.setProfName(profName);
        eqm.setWeight("0");
        eqm.setCost("0");
    }

    private boolean isProficientWithArmor(Equipment eq) {
        ArrayList aList = this.getArmorProfList();
        for (int i = 0; i < aList.size(); ++i) {
            String aString = aList.get(i).toString();
            if (!aString.startsWith("TYPE=") && !aString.startsWith("TYPE.") || !eq.isType(aString.substring(5))) continue;
            return true;
        }
        return aList.contains(eq.profName(this));
    }

    private boolean isProficientWithShield(Equipment eq) {
        String aString;
        ArrayList aList = this.getShieldProfList();
        for (int i = 0; i < aList.size() && ((aString = aList.get(i).toString()).startsWith("TYPE=") || aString.startsWith("TYPE.")); ++i) {
            if (!eq.isType(aString.substring(5))) continue;
            return true;
        }
        return aList.contains(eq.profName(this));
    }

    private boolean isProficientWithWeapon(Equipment eq) {
        WeaponProf wp1 = Globals.getWeaponProfNamed(eq.profName(1, this));
        WeaponProf wp2 = Globals.getWeaponProfNamed(eq.profName(2, this));
        if (wp1 == null || wp2 == null) {
            return false;
        }
        if (eq.isNatural()) {
            return true;
        }
        return this.hasWeaponProfNamed(wp2.getName()) || this.hasWeaponProfNamed(wp2.getName());
    }

    private void setQualifyListStable(boolean state) {
        this.qualifyListStable = state;
    }

    private SortedSet getRacialFavoredClasses() {
        this.racialFavoredClass = this.getRace().getFavoredClass();
        if (this.racialFavoredClass.startsWith("CHOOSE:")) {
            String classChoice;
            while ((classChoice = Globals.chooseFromList("Select favored class", this.racialFavoredClass.substring(7), null, 1)) == null) {
            }
            this.racialFavoredClass = classChoice;
        }
        if (!this.addFavoredClass(this.racialFavoredClass)) {
            this.racialFavoredClass = "";
        }
        return this.favoredClasses;
    }

    private ArrayList getSelectedArmorProfList() {
        ArrayList aList = new ArrayList();
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            PObject aPObj = (PObject)i.next();
            if (aPObj == null || aPObj.getSelectedArmorProfs() == null) continue;
            aList.addAll(aPObj.getSelectedArmorProfs());
        }
        return aList;
    }

    private List getStableAggregateFeatList() {
        if (this.isAggregateFeatsStable()) {
            return this.stableAggregateFeatList;
        }
        return null;
    }

    private void setStableAutomaticFeatList(List aFeatList) {
        this.stableAutomaticFeatList = aFeatList;
        this.setAutomaticFeatsStable(aFeatList != null);
    }

    private List getStableAutomaticFeatList() {
        if (this.isAutomaticFeatsStable()) {
            return this.stableAutomaticFeatList;
        }
        return null;
    }

    private void setStableVirtualFeatList(List aFeatList) {
        this.stableVirtualFeatList = aFeatList;
        this.setVirtualFeatsStable(aFeatList != null);
    }

    private List getStableVirtualFeatList() {
        if (this.isVirtualFeatsStable()) {
            return this.stableVirtualFeatList;
        }
        return null;
    }

    private List getStringListFromBonus(BonusObj aBonus, PObject anObj) {
        LinkedList<String> aList = new LinkedList<String>();
        String bInfoString = aBonus.getBonusInfo();
        StringTokenizer aTok = new StringTokenizer(bInfoString, ",");
        int listindex = 0;
        while (aTok.hasMoreTokens()) {
            String bonusInfo = aTok.nextToken();
            if (anObj.getAssociatedCount() > 0) {
                if (aBonus.getBonusName().indexOf("%LIST") >= 0) {
                    String bonusName = aBonus.getBonusName();
                    for (int i = 0; i < anObj.getAssociatedCount(); ++i) {
                        StringBuffer ab = new StringBuffer();
                        String tName = CoreUtility.replaceFirst(bonusName, "%LIST", anObj.getAssociated(i));
                        ab.append(tName).append('.');
                        ab.append(bonusInfo);
                        if (aBonus.hasTypeString()) {
                            ab.append(':').append(aBonus.getTypeString());
                        }
                        aList.add(ab.toString().toUpperCase());
                    }
                    continue;
                }
                if (bonusInfo.indexOf("%LIST") >= 0) {
                    for (int i = 0; i < anObj.getAssociatedCount(); ++i) {
                        StringBuffer ab = new StringBuffer();
                        String tName = CoreUtility.replaceFirst(bonusInfo, "%LIST", anObj.getAssociated(i));
                        ab.append(aBonus.getTypeOfBonus()).append('.');
                        ab.append(tName);
                        if (aBonus.hasTypeString()) {
                            ab.append(':').append(aBonus.getTypeString());
                        }
                        aList.add(ab.toString().toUpperCase());
                    }
                    continue;
                }
                int cnt = anObj.getAssociatedCount();
                if (cnt <= listindex && bonusInfo.equals("LIST")) continue;
                do {
                    StringBuffer ab = new StringBuffer();
                    ab.append(aBonus.getTypeOfBonus()).append('.');
                    if (bonusInfo.equals("LIST")) {
                        ab.append(anObj.getAssociated(listindex));
                    } else {
                        ab.append(bonusInfo);
                    }
                    if (aBonus.hasTypeString()) {
                        ab.append(':').append(aBonus.getTypeString());
                    }
                    aList.add(ab.toString().toUpperCase());
                } while (aTok.countTokens() <= 0 && ++listindex < cnt);
                continue;
            }
            if (aBonus.hasVariable()) {
                StringBuffer ab = new StringBuffer();
                ab.append(aBonus.getTypeOfBonus());
                ab.append(aBonus.getVariable()).append('.');
                ab.append(bonusInfo);
                if (aBonus.hasTypeString()) {
                    ab.append(':').append(aBonus.getTypeString());
                }
                aList.add(ab.toString().toUpperCase());
                continue;
            }
            StringBuffer ab = new StringBuffer();
            ab.append(aBonus.getTypeOfBonus()).append('.');
            ab.append(bonusInfo);
            if (aBonus.hasTypeString()) {
                ab.append(':').append(aBonus.getTypeString());
            }
            aList.add(ab.toString().toUpperCase());
        }
        return aList;
    }

    private String getSubRegion(boolean useTemplates) {
        if (this.subRegion != null || !useTemplates) {
            return this.subRegion;
        }
        String s = "None";
        int x = this.templateList.size();
        for (int i = 0; i < x; ++i) {
            PCTemplate template = (PCTemplate)this.templateList.get(i);
            String tempSubRegion = template.getSubRegion();
            if (tempSubRegion.equals("None")) continue;
            s = tempSubRegion;
        }
        return s;
    }

    private int getTotalClassLevels() {
        int total = 0;
        for (int i = 0; i < this.classList.size(); ++i) {
            PCClass aClass = (PCClass)this.classList.get(i);
            total += aClass.getLevel();
        }
        return total;
    }

    private HashMap getTotalLevelHashMap() {
        HashMap<String, String> lvlMap = new HashMap<String, String>();
        Iterator i = this.classList.iterator();
        while (i.hasNext()) {
            PCClass aClass = (PCClass)i.next();
            lvlMap.put(aClass.getName(), String.valueOf(aClass.getLevel()));
        }
        return lvlMap;
    }

    private boolean isVirtualFeatsStable() {
        return this.virtualFeatsStable;
    }

    private void addListToActiveBonuses(List aList) {
        if (aList == null) {
            return;
        }
        this.activeBonusList.addAll(aList);
    }

    private void addSpells(PObject obj) {
        if (this.race == null || obj == null || obj.getSpellList() == null || obj.getSpellList().isEmpty()) {
            return;
        }
        Iterator ri = obj.getSpellList().iterator();
        while (ri.hasNext()) {
            List sList;
            PCSpell pcSpell = (PCSpell)ri.next();
            String spellName = pcSpell.getName();
            Spell aSpell = Globals.getSpellNamed(spellName);
            if (aSpell == null) {
                return;
            }
            String castCount = pcSpell.getTimesPerDay();
            int spellLevel = -1;
            int times = 1;
            int slotLevel = 0;
            PObject owner = this.race;
            if (castCount.startsWith("LEVEL=") || castCount.startsWith("LEVEL.")) {
                slotLevel = spellLevel = Integer.parseInt(castCount.substring(6));
                if (obj instanceof PCClass) {
                    owner = obj;
                }
            } else {
                times = this.getVariableValue(castCount, "").intValue();
            }
            String book = pcSpell.getSpellbook();
            if (!PrereqHandler.passesAll(pcSpell.getPreReqList(), this, pcSpell) || !(sList = owner.getCharacterSpell(aSpell, book, spellLevel)).isEmpty()) continue;
            CharacterSpell cs = new CharacterSpell(owner, aSpell);
            cs.addInfo(slotLevel, times, book);
            this.addSpellBook(book);
            owner.addCharacterSpell(cs);
        }
        this.setDirty(true);
    }

    private Map addStringToDRMap(Map drMap, String drString) {
        if (drString == null || drString.length() == 0) {
            return drMap;
        }
        StringTokenizer aTok = new StringTokenizer(drString, "|");
        while (aTok.hasMoreTokens()) {
            int z;
            String aString = aTok.nextToken();
            int x = aString.indexOf(47);
            if (x <= 0 || x >= aString.length()) continue;
            String val = aString.substring(0, x);
            String key = aString.substring(x + 1);
            if (key.length() > 0 && key.charAt(0) == '+') {
                key = key.substring(1);
            }
            int y = 0;
            Object obj = drMap.get(key);
            if (obj != null) {
                y = Integer.parseInt(obj.toString());
            }
            if ((z = this.getVariableValue(val, "").intValue()) <= y) continue;
            drMap.put(key, String.valueOf(z));
        }
        this.setDirty(true);
        return drMap;
    }

    private Map addStringToVisionMap(Map visMap, Map aMap) {
        if (aMap == null || aMap.size() == 0) {
            return visMap;
        }
        Iterator i = aMap.keySet().iterator();
        while (i.hasNext()) {
            String aKey = i.next().toString();
            String aVal = aMap.get(aKey).toString();
            Object bObj = visMap.get(aKey);
            int b = 0;
            if (bObj != null) {
                b = this.getVariableValue(bObj.toString(), "").intValue();
            }
            int a = this.getVariableValue(aVal, "").intValue();
            if ((a += (int)this.getTotalBonusTo("VISION", aKey)) < b) continue;
            visMap.put(aKey, String.valueOf(a));
        }
        return visMap;
    }

    private static void addToAutoFeatList(List autoFeatList, String featName) {
        Feat aFeat;
        String altName = "";
        String subName = "";
        if (featName.endsWith(")")) {
            subName = featName.substring(featName.indexOf(40) + 1, featName.lastIndexOf(41));
            altName = featName.substring(0, featName.indexOf(40) - 1);
        }
        if ((aFeat = PlayerCharacter.getFeatNamedInList(autoFeatList, featName)) == null && altName.length() != 0) {
            aFeat = PlayerCharacter.getFeatNamedInList(autoFeatList, altName);
        }
        if (aFeat == null) {
            aFeat = Globals.getFeatNamed(featName);
            if (aFeat == null && altName.length() != 0) {
                aFeat = Globals.getFeatNamed(altName);
            }
            if (aFeat != null) {
                aFeat = (Feat)aFeat.clone();
                if (subName.length() != 0) {
                    aFeat.addAssociated(subName);
                }
                aFeat.setFeatType(1);
                autoFeatList.add(aFeat);
            } else {
                ShowMessageDelegate.showMessageDialog("Adding unknown feat: " + featName, "PCGen", MessageType.INFORMATION);
            }
        } else if (subName.length() != 0 && aFeat.isStacks() && (aFeat.isMultiples() || !aFeat.containsAssociated(subName))) {
            aFeat.addAssociated(subName);
        }
    }

    private void setStableAggregateFeatList(List aFeatList) {
        this.stableAggregateFeatList = aFeatList;
        this.setAggregateFeatsStable(aFeatList != null);
    }

    private void addWeaponProfToList(List aFeatList, String aString, boolean isAuto) {
        if (aString.startsWith("WEAPONTYPE=") || aString.startsWith("WEAPONTYPE.")) {
            List weapList = EquipmentList.getEquipmentOfType(EquipmentList.getEquipmentList(), "WEAPON." + aString.substring(11), "");
            if (weapList.size() != 0) {
                Iterator e = weapList.iterator();
                while (e.hasNext()) {
                    Equipment weap = (Equipment)e.next();
                    WeaponProf aProf = Globals.getWeaponProfNamed(weap.profName(this));
                    if (aProf == null) continue;
                    this.addWeaponProfToList(aFeatList, aProf.getName(), isAuto);
                }
            }
            return;
        }
        if (Globals.weaponTypesContains(aString)) {
            Collection weaponProfs = Globals.getAllWeaponProfsOfType(aString);
            Iterator e = weaponProfs.iterator();
            while (e.hasNext()) {
                WeaponProf weaponProf = (WeaponProf)e.next();
                this.addWeaponProfToList(aFeatList, weaponProf.getName(), isAuto);
            }
            return;
        }
        WeaponProf wp = Globals.getWeaponProfNamed(aString);
        if (wp != null) {
            StringTokenizer aTok = new StringTokenizer(wp.getType(), ".");
            String featName = aTok.nextToken() + " Weapon Proficiency";
            while (aTok.hasMoreTokens() || featName.length() > 0) {
                Feat aFeat;
                if ("".equals(featName)) {
                    if (!aTok.hasMoreTokens()) break;
                    featName = aTok.nextToken() + " Weapon Proficiency";
                }
                if ((aFeat = PlayerCharacter.getFeatNamedInList(aFeatList, featName)) != null) {
                    if (aFeat.isMultiples() && !aFeat.containsAssociated(aString)) {
                        aFeat.addAssociated(aString);
                        aFeat.sortAssociated();
                    }
                } else {
                    aFeat = Globals.getFeatNamed(featName);
                    if (aFeat != null) {
                        if (isAuto && !aFeat.isMultiples() && !"PCGENi_WEAPON_PROFICIENCY".equalsIgnoreCase(featName)) {
                            if (PlayerCharacter.getFeatNamedInList(this.featList, featName) == null) {
                                featName = "PCGENi_WEAPON_PROFICIENCY";
                                continue;
                            }
                            featName = "";
                            continue;
                        }
                        aFeat = (Feat)aFeat.clone();
                        aFeat.addAssociated(aString);
                        if (isAuto) {
                            aFeat.setFeatType(1);
                        }
                        aFeatList.add(aFeat);
                    }
                }
                featName = "";
            }
        }
        if (!this.weaponProfList.contains(aString)) {
            this.weaponProfList.add(aString);
        }
    }

    private SortedSet addWeaponProfsLists(List aList, SortedSet aSet, List aFeatList, boolean addIt) {
        if (aList == null || aList.isEmpty()) {
            return aSet;
        }
        String sizeString = "FDTSMLHGC";
        Iterator e1 = aList.iterator();
        while (e1.hasNext()) {
            Iterator i;
            int lastComma;
            boolean flag;
            String aString = (String)e1.next();
            int idx = aString.indexOf(91);
            if (idx >= 0) {
                StringTokenizer bTok = new StringTokenizer(aString.substring(idx + 1), "[]");
                ArrayList<String> preReqList = new ArrayList<String>();
                while (bTok.hasMoreTokens()) {
                    preReqList.add(bTok.nextToken());
                }
                aString = aString.substring(0, idx);
                if (preReqList.size() != 0 && !PrereqHandler.passesAll(preReqList, this, null)) continue;
            }
            boolean bl = flag = (lastComma = aString.lastIndexOf(44)) < 0;
            if (!flag && this.race != null) {
                String eString = aString.substring(lastComma + 1);
                int s = this.sizeInt();
                for (int i2 = 0; i2 < eString.length(); ++i2) {
                    if ("FDTSMLHGC".lastIndexOf(eString.charAt(i2)) != s) continue;
                    flag = true;
                    break;
                }
                aString = aString.substring(0, lastComma);
            }
            if (!flag) continue;
            Equipment eq = EquipmentList.getEquipmentKeyed(aString);
            if (eq != null) {
                if (!addIt) continue;
                aSet.add(aString);
                this.addWeaponProfToList(aFeatList, aString, true);
                continue;
            }
            ArrayList<String> addWPs = new ArrayList<String>();
            boolean dotsFound = aString.indexOf(".") >= 0;
            boolean loadedByProfs = false;
            if (!dotsFound) {
                WeaponProf prof = Globals.getWeaponProfKeyed(aString);
                if (prof != null) {
                    addWPs.add(aString);
                    loadedByProfs = true;
                } else {
                    Collection listFromWPType = Globals.getAllWeaponProfsOfType(aString);
                    if (listFromWPType != null && !listFromWPType.isEmpty()) {
                        i = listFromWPType.iterator();
                        while (i.hasNext()) {
                            addWPs.add(i.next().toString());
                        }
                        loadedByProfs = true;
                    }
                }
            }
            if (dotsFound || !loadedByProfs) {
                String desiredTypes = "Weapon." + aString;
                List listFromEquipmentType = EquipmentList.getEquipmentOfType(EquipmentList.getEquipmentList(), desiredTypes, "");
                if (listFromEquipmentType != null && !listFromEquipmentType.isEmpty()) {
                    i = listFromEquipmentType.iterator();
                    while (i.hasNext()) {
                        String bString = ((Equipment)i.next()).profName(this);
                        addWPs.add(bString);
                    }
                }
            }
            Iterator i3 = addWPs.iterator();
            while (i3.hasNext()) {
                if (!addIt) continue;
                aSet.add(aString);
                this.addWeaponProfToList(aFeatList, (String)i3.next(), true);
            }
        }
        return aSet;
    }

    private static String appendToName(String aName, String aString) {
        StringBuffer aBuf = new StringBuffer(aName);
        int iLen = aBuf.length() - 1;
        if (aBuf.charAt(iLen) == ')') {
            aBuf.setCharAt(iLen, '/');
        } else {
            aBuf.append(" (");
        }
        aBuf.append(aString);
        aBuf.append(')');
        return aBuf.toString();
    }

    private List getAutoShieldProfList() {
        ArrayList aList = new ArrayList();
        Iterator e = this.getPObjectList().iterator();
        while (e.hasNext()) {
            PObject aPObj = (PObject)e.next();
            if (aPObj == null) continue;
            aPObj.addAutoTagsToList("SHIELDPROF", aList, this);
        }
        return aList;
    }

    private String getClassLevelString(String className, boolean doReplace) {
        PCClass aClass;
        int lvl = 0;
        int idx = className.indexOf(";BEFORELEVEL=");
        if (idx < 0) {
            idx = className.indexOf(";BEFORELEVEL.");
        }
        if (idx > 0) {
            lvl = Integer.parseInt(className.substring(idx + 13));
            className = className.substring(0, idx);
        }
        if (doReplace) {
            className = className.replace('{', '(').replace('}', ')');
        }
        if ((aClass = this.getClassNamed(className)) != null) {
            if (lvl > 0) {
                return this.getLevelBefore(aClass.getKeyName(), lvl);
            }
            return Integer.toString(aClass.getLevel());
        }
        return "0";
    }

    private String getLevelBefore(String classKey, int charLevel) {
        String thisClassKey;
        int lvl = 0;
        for (int idx = 0; idx < charLevel && (thisClassKey = this.getLevelInfoClassKeyName(idx)).length() != 0; ++idx) {
            if (!thisClassKey.equals(classKey)) continue;
            ++lvl;
        }
        return Integer.toString(lvl);
    }

    private ArrayList getPObjectList() {
        ArrayList<PObject> results = new ArrayList<PObject>();
        results.add(SettingsHandler.getGame().getAlignmentAtIndex(this.getAlignment()));
        results.add(Globals.getBioSet());
        results.addAll(SettingsHandler.getGame().getUnmodifiableCheckList());
        results.addAll(this.classList);
        results.addAll(this.companionModList);
        if (this.deity != null) {
            results.add(this.deity);
        }
        Iterator e = this.characterDomainList.iterator();
        while (e.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)e.next();
            Domain aDomain = aCD.getDomain();
            if (aDomain == null) continue;
            results.add(aDomain);
        }
        e = this.getEquipmentList().iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            results.add(eq);
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    results.add(eqMod);
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                results.add(eqMod);
            }
        }
        results.addAll(this.aggregateFeatList());
        results.add(this.getRace());
        results.add(this.getSizeAdjustment());
        results.addAll(this.getSkillList());
        results.addAll(this.statList.getStats());
        results.addAll(this.getTemplateList());
        return results;
    }

    private void getPreReqFromACType(String aString, PObject aPObj) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        String outputString = "|";
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if ((bString.startsWith("PRE") || bString.startsWith("!PRE")) && bString.indexOf(58) >= 0) {
                try {
                    Logging.debugPrint("Why is this prerequisite '" + bString + "' parsed in '" + this.getClass().getName() + ".getPreReqFromACType()' rather than the persistence layer?");
                    PreParserFactory factory = PreParserFactory.getInstance();
                    Prerequisite prereq = factory.parse(bString);
                    aPObj.addPreReq(prereq);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                }
                continue;
            }
            outputString = outputString + bString + "|";
        }
        aString = outputString.substring(1);
    }

    private ArrayList getSelectedShieldProfList() {
        ArrayList aList = new ArrayList();
        Iterator i = this.getPObjectList().iterator();
        while (i.hasNext()) {
            PObject aPObj = (PObject)i.next();
            if (aPObj == null || aPObj.getSelectedShieldProfs() == null) continue;
            aList.addAll(aPObj.getSelectedShieldProfs());
        }
        return aList;
    }

    private void addNewSkills(int level) {
        LinkedList<Object> addItems = new LinkedList<Object>();
        Iterator skillIter = Globals.getSkillList().iterator();
        while (skillIter.hasNext()) {
            Skill aSkill = (Skill)skillIter.next();
            if (!this.includeSkill(aSkill, level) || Globals.binarySearchPObject(this.getSkillList(), aSkill.getKeyName()) != null) continue;
            addItems.add(aSkill.clone());
        }
        this.getSkillList().addAll(addItems);
        this.setDirty(true);
    }

    private boolean availableSpells(int level, PCClass aClass, String bookName, boolean knownLearned, boolean isSpecialtySpell, PlayerCharacter aPC) {
        int excNon;
        int excSpec;
        int memNon;
        int memSpec;
        int memTot;
        int knownTot;
        int knownSpec;
        int knownNon;
        int i;
        boolean available = false;
        boolean isDivine = "Divine".equalsIgnoreCase(aClass.getSpellType());
        int lowExcSpec = 0;
        int lowExcNon = 0;
        int goodExcSpec = 0;
        int goodExcNon = 0;
        for (i = 0; i < level; ++i) {
            if (knownLearned) {
                knownNon = aClass.getKnownForLevel(aClass.getLevel(), i, bookName, aPC);
                knownSpec = aClass.getSpecialtyKnownForLevel(aClass.getLevel(), i, aPC);
                knownTot = knownNon + knownSpec;
            } else {
                knownTot = aClass.getCastForLevel(aClass.getLevel(), i, bookName, true, true, aPC);
                knownNon = aClass.getCastForLevel(aClass.getLevel(), i, bookName, false, true, aPC);
                knownSpec = knownTot - knownNon;
            }
            memTot = aClass.memorizedSpellForLevelBook(i, bookName);
            memSpec = aClass.memorizedSpecialtiesForLevelBook(i, bookName);
            memNon = memTot - memSpec;
            excSpec = knownSpec - memSpec;
            for (excNon = knownNon - memNon; excNon > 0 && lowExcNon < 0; --excNon, ++lowExcNon) {
            }
            while (excSpec > 0 && lowExcSpec < 0) {
                --excSpec;
                ++lowExcSpec;
            }
            if (!isDivine || knownLearned) {
                while (excNon > 0 && lowExcSpec < 0) {
                    --excNon;
                    ++lowExcSpec;
                }
                while (excNon > 0 && excSpec < 0) {
                    --excNon;
                    ++excSpec;
                }
            }
            if (excSpec < 0) {
                lowExcSpec += excSpec;
            }
            if (excNon >= 0) continue;
            lowExcNon += excNon;
        }
        i = level;
        while (true) {
            if (knownLearned) {
                knownNon = aClass.getKnownForLevel(aClass.getLevel(), i, bookName, aPC);
                knownSpec = aClass.getSpecialtyKnownForLevel(aClass.getLevel(), i, aPC);
                knownTot = knownNon + knownSpec;
            } else {
                knownTot = aClass.getCastForLevel(aClass.getLevel(), i, bookName, true, true, aPC);
                knownNon = aClass.getCastForLevel(aClass.getLevel(), i, bookName, false, true, aPC);
                knownSpec = knownTot - knownNon;
            }
            if (knownLearned && knownNon + knownSpec == 0 || !knownLearned && knownTot == 0) break;
            memTot = aClass.memorizedSpellForLevelBook(i, bookName);
            memSpec = aClass.memorizedSpecialtiesForLevelBook(i, bookName);
            memNon = memTot - memSpec;
            excSpec = knownSpec - memSpec;
            for (excNon = knownNon - memNon; excNon > 0 && lowExcNon < 0; --excNon, ++lowExcNon) {
            }
            while (excNon > 0 && goodExcNon < 0) {
                --excNon;
                ++goodExcNon;
            }
            while (excSpec > 0 && lowExcSpec < 0) {
                --excSpec;
                ++lowExcSpec;
            }
            while (excSpec > 0 && goodExcSpec < 0) {
                --excSpec;
                ++goodExcSpec;
            }
            if (!isDivine) {
                while (excNon > 0 && lowExcSpec < 0) {
                    --excNon;
                    ++lowExcSpec;
                }
                while (excNon > 0 && goodExcSpec < 0) {
                    --excNon;
                    ++goodExcSpec;
                }
                while (excNon > 0 && excSpec < 0) {
                    --excNon;
                    ++excSpec;
                }
            }
            if (isDivine) {
                if (isSpecialtySpell && excSpec > 0) {
                    available = true;
                }
                if (!isSpecialtySpell && excNon > 0) {
                    available = true;
                }
            } else {
                if (!isSpecialtySpell && excNon > 0) {
                    available = true;
                }
                if (isSpecialtySpell && (excNon > 0 || excSpec > 0)) {
                    available = true;
                }
            }
            if (available) break;
            if (excSpec < 0) {
                goodExcSpec += excSpec;
            }
            if (excNon < 0) {
                goodExcNon += excNon;
            }
            ++i;
        }
        return available;
    }

    private void buildActiveBonusMap() {
        PObject anObj;
        BonusObj aBonus;
        this.clearActiveBonusMap();
        this.processedBonusList.clear();
        this.setQualifyListStable(false);
        Iterator b = this.getActiveBonusList().iterator();
        while (b.hasNext()) {
            aBonus = (BonusObj)b.next();
            if (!aBonus.isValueStatic() || (anObj = (PObject)aBonus.getCreatorObject()) == null) continue;
            this.processedBonusList.add(aBonus);
            Iterator as = this.getStringListFromBonus(aBonus, anObj).iterator();
            while (as.hasNext()) {
                String bString = (String)as.next();
                double iBonus = aBonus.getValueAsdouble();
                this.setActiveBonusStack(iBonus, bString);
                Logging.debugPrint("BONUS: " + anObj.getName() + " : " + iBonus + " : " + bString);
            }
        }
        b = this.getActiveBonusList().iterator();
        while (b.hasNext()) {
            aBonus = (BonusObj)b.next();
            if (this.processedBonusList.contains(aBonus) || (anObj = (PObject)aBonus.getCreatorObject()) == null) continue;
            this.processBonus(aBonus);
        }
    }

    private void buildSpellInfoMap(String key, Iterator e) {
        while (e.hasNext()) {
            Object obj = e.next();
            if (obj instanceof CharacterDomain) {
                obj = ((CharacterDomain)obj).getDomain();
            }
            if (!(obj instanceof PObject)) continue;
            PObject pObj = (PObject)obj;
            this.spellInfoMap.putAll(pObj.getSpellInfoMapPassesPrereqs(key, this));
        }
    }

    private void buildSpellLevelMap(int levelMatch, Iterator e) {
        while (e.hasNext()) {
            Object obj = e.next();
            if (obj instanceof CharacterDomain) {
                obj = ((CharacterDomain)obj).getDomain();
            }
            if (!(obj instanceof PObject)) continue;
            PObject pObj = (PObject)obj;
            this.spellLevelMap.putAll(pObj.getSpellMapPassesPrereqs(this, levelMatch));
        }
    }

    private void calcAgeBonuses() {
        String ageSetLine = Globals.getBioSet().getAgeSetLine(this);
        if (ageSetLine == null) {
            return;
        }
        LinkedList<BonusObj> tempList = new LinkedList<BonusObj>();
        StringTokenizer aTok = new StringTokenizer(ageSetLine, "\t");
        aTok.nextToken();
        while (aTok.hasMoreTokens()) {
            BonusObj aBonus;
            String b = aTok.nextToken();
            if (!b.startsWith("BONUS:") || (aBonus = Bonus.newBonus(b.substring(6))) == null) continue;
            aBonus.setCreatorObject(Globals.getBioSet());
            aBonus.setApplied(true);
            tempList.add(aBonus);
        }
        if (!tempList.isEmpty()) {
            this.addListToActiveBonuses(tempList);
        }
    }

    private void calcAlignmentBonuses() {
        PCAlignment aLine = SettingsHandler.getGame().getAlignmentAtIndex(this.getAlignment());
        if (aLine != null) {
            this.activateAndAddBonusesFromPObject(aLine);
        }
    }

    private void calcArmorProfBonuses() {
        if (this.getArmorProfList().isEmpty()) {
            return;
        }
        Iterator e = this.getArmorProfList().iterator();
        while (e.hasNext()) {
            ArmorProf ap = (ArmorProf)e.next();
            ap.activateBonuses(this);
            List tempList = ap.getActiveBonuses(this);
            if (tempList.isEmpty()) continue;
            this.addListToActiveBonuses(tempList);
        }
    }

    private double calcBonusWithCostFromList(List aList, boolean subSearch) {
        double totalBonus = 0.0;
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            BonusObj aBonus = (BonusObj)e.next();
            PObject anObj = (PObject)aBonus.getCreatorObject();
            if (anObj == null) continue;
            double iBonus = 0.0;
            if (aBonus.hasPreReqs()) {
                if (PrereqHandler.passesAll(aBonus.getPrereqList(), this, null)) {
                    iBonus = anObj.calcBonusFrom(aBonus, this);
                }
            } else {
                iBonus = anObj.calcBonusFrom(aBonus, this);
            }
            int k = Math.max(1, (int)((double)anObj.getAssociatedCount() * ((HasCost)((Object)anObj)).getCost()));
            if (subSearch && anObj.getAssociatedCount() > 0) {
                k = 0;
                for (int f = 0; f < anObj.getAssociatedCount(); ++f) {
                    String aString = anObj.getAssociated(f);
                    if (!aString.equalsIgnoreCase(aBonus.getBonusInfo())) continue;
                    ++k;
                }
            }
            if (k == 0 && !CoreUtility.doublesEqual(iBonus, 0.0)) {
                totalBonus += iBonus;
                continue;
            }
            totalBonus += iBonus * (double)k;
        }
        return totalBonus;
    }

    private void calcCheckBonuses() {
        if (SettingsHandler.getGame().getUnmodifiableCheckList().isEmpty()) {
            return;
        }
        Iterator e = SettingsHandler.getGame().getUnmodifiableCheckList().iterator();
        while (e.hasNext()) {
            PObject anObj = (PObject)e.next();
            this.activateAndAddBonusesFromPObject(anObj);
        }
    }

    private void calcClassBonuses() {
        if (this.classList.isEmpty()) {
            return;
        }
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            if (aClass.getLevel() <= 0) continue;
            this.activateAndAddBonusesFromPObject(aClass);
        }
    }

    private void calcCompanionModBonuses() {
        this.activateAndAddBonusesFromPObjectList(this.companionModList);
    }

    private void calcDeityBonuses() {
        this.activateAndAddBonusesFromPObject(this.getDeity());
    }

    private void calcDomainBonuses() {
        if (this.characterDomainList.isEmpty()) {
            return;
        }
        Iterator e = this.characterDomainList.iterator();
        while (e.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)e.next();
            Domain aDomain = aCD.getDomain();
            this.activateAndAddBonusesFromPObject(aDomain);
        }
    }

    private void calcEquipmentBonuses() {
        if (this.getEquipmentList().isEmpty()) {
            return;
        }
        Iterator e = this.getEquipmentList().iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            this.activateAndAddBonusesFromPObject(eq);
        }
    }

    private void calcFeatBonuses() {
        this.activateAndAddBonusesFromPObjectList(this.aggregateFeatList());
    }

    private void calcRaceBonuses() {
        this.activateAndAddBonusesFromPObject(this.getRace());
    }

    private void calcSkillBonuses() {
        this.activateAndAddBonusesFromPObjectList(this.getSkillList());
    }

    private void calcTempBonuses() {
        if (this.getTempBonusList().isEmpty()) {
            return;
        }
        LinkedList tempList = new LinkedList(this.getTempBonusList());
        Iterator tempIter = tempList.iterator();
        while (tempIter.hasNext()) {
            BonusObj bonus = (BonusObj)tempIter.next();
            bonus.setApplied(false);
            if (bonus.hasPreReqs()) {
                if (PrereqHandler.passesAll(bonus.getPrereqList(), this, null)) {
                    bonus.setApplied(true);
                } else {
                    bonus.setApplied(false);
                }
            } else {
                bonus.setApplied(true);
            }
            if (bonus.isApplied()) continue;
            tempIter.remove();
        }
        this.addListToActiveBonuses(tempList);
    }

    private void calcTemplateBonuses() {
        this.activateAndAddBonusesFromPObjectList(this.getTemplateList());
    }

    private void activateAndAddBonusesFromPObjectList(Collection objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        Iterator e = objects.iterator();
        while (e.hasNext()) {
            PObject object = (PObject)e.next();
            this.activateAndAddBonusesFromPObject(object);
        }
    }

    private void activateAndAddBonusesFromPObject(PObject object) {
        if (object == null) {
            return;
        }
        object.activateBonuses(this);
        List tempList = object.getActiveBonuses(this);
        this.addListToActiveBonuses(tempList);
    }

    private void calcWeaponProfBonuses() {
        if (this.getWeaponProfList().isEmpty()) {
            return;
        }
        Iterator e = this.getWeaponProfList().iterator();
        while (e.hasNext()) {
            WeaponProf wp = (WeaponProf)e.next();
            wp.activateBonuses(this);
            List tempList = wp.getActiveBonuses(this);
            if (tempList.isEmpty()) continue;
            this.addListToActiveBonuses(tempList);
        }
    }

    private int calculateSaveBonusRace(int saveIndex) {
        int save = 0;
        if (saveIndex - 1 < 0 || saveIndex - 1 >= SettingsHandler.getGame().getUnmodifiableCheckList().size()) {
            return 0;
        }
        String sString = SettingsHandler.getGame().getUnmodifiableCheckList().get(saveIndex - 1).toString();
        save = (int)this.race.bonusTo("CHECKS", "BASE." + sString, this, this);
        return save += (int)this.race.bonusTo("CHECKS", sString, this, this);
    }

    private void clearActiveBonusMap() {
        this.activeBonusMap.clear();
    }

    private void clearActiveBonuses() {
        this.activeBonusList.clear();
    }

    private void setActiveBonusList(List aList) {
        this.activeBonusList.clear();
        this.activeBonusList.addAll(aList);
    }

    private int countSpellLevelsInBook(String aString) {
        PObject aObject;
        int levelNum = 0;
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        int classNum = Integer.parseInt(aTok.nextToken());
        int sbookNum = Integer.parseInt(aTok.nextToken());
        String bookName = Globals.getDefaultSpellBook();
        if (sbookNum > 0) {
            bookName = (String)this.getSpellBooks().get(sbookNum);
        }
        if ((aObject = this.getSpellClassAtIndex(classNum)) != null) {
            List aList;
            for (levelNum = 0; levelNum >= 0 && (aList = aObject.getCharacterSpell(null, bookName, levelNum)).size() >= 1; ++levelNum) {
            }
        }
        return levelNum;
    }

    private int countSpellListBook(String aString) {
        int dot = aString.lastIndexOf(46);
        int spellCount = 0;
        if (dot < 0) {
            Iterator iClass = this.classList.iterator();
            while (iClass.hasNext()) {
                PCClass aClass = (PCClass)iClass.next();
                spellCount += aClass.getCharacterSpellCount();
            }
        } else {
            int classNum = Integer.parseInt(aString.substring(17, dot));
            int levelNum = Integer.parseInt(aString.substring(dot + 1, aString.length() - 1));
            PObject aObject = this.getSpellClassAtIndex(classNum);
            if (aObject != null) {
                List aList = aObject.getCharacterSpell(null, Globals.getDefaultSpellBook(), levelNum);
                spellCount = aList.size();
            }
        }
        return spellCount;
    }

    private int countSpellTimes(String aString) {
        boolean found = false;
        StringTokenizer aTok = new StringTokenizer(aString.substring(10), ".");
        int classNum = Integer.parseInt(aTok.nextToken());
        int bookNum = Integer.parseInt(aTok.nextToken());
        int spellLevel = Integer.parseInt(aTok.nextToken());
        int spellNumber = Integer.parseInt(aTok.nextToken());
        PObject aObject = this.getSpellClassAtIndex(classNum);
        String bookName = Globals.getDefaultSpellBook();
        if (bookNum > 0) {
            bookName = (String)this.getSpellBooks().get(bookNum);
        }
        if (aObject != null || classNum == -1) {
            if (classNum == -1) {
                bookName = Globals.getDefaultSpellBook();
            }
            if (!"".equals(bookName)) {
                List charSpells;
                SpellInfo si = null;
                if (classNum == -1) {
                    ArrayList<CharacterSpell> charSpellList = new ArrayList<CharacterSpell>();
                    Iterator iClass = this.getClassList().iterator();
                    while (iClass.hasNext()) {
                        PCClass aClass = (PCClass)iClass.next();
                        List bList = aClass.getCharacterSpell(null, bookName, -1);
                        Iterator bi = bList.iterator();
                        while (bi.hasNext()) {
                            CharacterSpell cs = (CharacterSpell)bi.next();
                            if (charSpellList.contains(cs)) continue;
                            charSpellList.add(cs);
                        }
                    }
                    Collections.sort(charSpellList);
                    if (spellNumber < charSpellList.size()) {
                        CharacterSpell cs = (CharacterSpell)charSpellList.get(spellNumber);
                        si = cs.getSpellInfoFor(bookName, -1, -1);
                        found = true;
                    }
                } else if (aObject != null && spellNumber < (charSpells = aObject.getCharacterSpell(null, bookName, spellLevel)).size()) {
                    CharacterSpell cs = (CharacterSpell)charSpells.get(spellNumber);
                    si = cs.getSpellInfoFor(bookName, spellLevel, -1);
                    found = true;
                }
                if (found && si != null) {
                    return si.getTimes();
                }
            }
        }
        return 0;
    }

    private int countSpellsInBook(String aString) {
        PObject aObject;
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        int classNum = Integer.parseInt(aTok.nextToken());
        int sbookNum = Integer.parseInt(aTok.nextToken());
        int levelNum = aTok.hasMoreTokens() ? Integer.parseInt(aTok.nextToken()) : -1;
        String bookName = Globals.getDefaultSpellBook();
        if (sbookNum > 0) {
            bookName = (String)this.getSpellBooks().get(sbookNum);
        }
        if ((aObject = this.getSpellClassAtIndex(classNum)) != null) {
            List aList = aObject.getCharacterSpell(null, bookName, levelNum);
            return aList.size();
        }
        return 0;
    }

    private int countVisibleFeat(Feat feat, boolean countVisible, boolean countHidden, boolean onceOnly) {
        int visibility = feat.isVisible();
        int count = 0;
        if (countVisible && visibility != 3 && visibility != 0) {
            count = onceOnly ? ++count : (count += Math.max(1, feat.getAssociatedCount()));
        }
        if (countHidden && (visibility == 3 || visibility == 0)) {
            count = onceOnly ? ++count : (count += Math.max(1, feat.getAssociatedCount()));
        }
        return count;
    }

    private int countVisibleFeatNames(List argFeatList, String featName, boolean countVisible, boolean countHidden) {
        int count = 0;
        Iterator e1 = argFeatList.iterator();
        while (e1.hasNext()) {
            Feat aFeat = (Feat)e1.next();
            if (!aFeat.getName().equalsIgnoreCase(featName)) continue;
            count += this.countVisibleFeat(aFeat, countVisible, countHidden, false);
            break;
        }
        return count;
    }

    private int countVisibleFeatTypes(List featsList, List featTypesList, boolean countVisible, boolean countHidden) {
        int count = 0;
        Iterator e1 = featsList.iterator();
        block0: while (e1.hasNext()) {
            Feat aFeat = (Feat)e1.next();
            Iterator e2 = featTypesList.iterator();
            while (e2.hasNext()) {
                String featType = (String)e2.next();
                if (!aFeat.isType(featType)) continue;
                count += this.countVisibleFeat(aFeat, countVisible, countHidden, false);
                continue block0;
            }
        }
        return count;
    }

    private int countVisibleFeats(List argFeatList, boolean countVisible, boolean countHidden) {
        Iterator itr = argFeatList.iterator();
        int count = 0;
        while (itr.hasNext()) {
            Feat feat = (Feat)itr.next();
            count += this.countVisibleFeat(feat, countVisible, countHidden, true);
        }
        return count;
    }

    private String findTemplateGender() {
        String templateGender = "None";
        Iterator e = this.templateList.iterator();
        while (e.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)e.next();
            String aString = aTemplate.getGenderLock();
            if (aString.equals("None")) continue;
            templateGender = aString;
        }
        return templateGender;
    }

    private static int minXPForLevel(int level, PlayerCharacter pc) {
        LevelInfo lInfo = (LevelInfo)Globals.getLevelInfo().get(String.valueOf(level));
        if (lInfo == null) {
            lInfo = (LevelInfo)Globals.getLevelInfo().get("LEVEL");
        }
        if (level > 0 && lInfo != null) {
            return lInfo.getMinXP(level, pc);
        }
        return 0;
    }

    private PCClass getClassDisplayNamed(String aString) {
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            if (!aClass.getDisplayClassName().equalsIgnoreCase(aString)) continue;
            return aClass;
        }
        return null;
    }

    private void setEarnedXP(int argEarnedXP) {
        this.earnedXP = argEarnedXP;
        this.setDirty(true);
    }

    private int getLAXP() {
        return PlayerCharacter.minXPForLevel(this.getLevelAdjustment(this) + 1, this);
    }

    private SizeAdjustment getSizeAdjustment() {
        SizeAdjustment sa = SystemCollections.getSizeAdjustmentAtIndex(this.sizeInt());
        return sa;
    }

    private int getSpellClassCount() {
        return this.getSpellClassList().size();
    }

    public List getSpellClassList() {
        ArrayList<PObject> aList = new ArrayList<PObject>();
        if (!this.race.getCharacterSpell(null, "", -1).isEmpty()) {
            aList.add(this.race);
        }
        Iterator classIter = this.classList.iterator();
        while (classIter.hasNext()) {
            PObject aObject = (PObject)classIter.next();
            if (!aObject.getCharacterSpell(null, "", -1).isEmpty()) {
                aList.add(aObject);
                continue;
            }
            if (!(aObject instanceof PCClass) || ((PCClass)aObject).getSpellType().equalsIgnoreCase("None")) continue;
            aList.add(aObject);
        }
        return aList;
    }

    private String checkForVariableInList(PObject obj, String variableString, boolean isMax, String matchSrc, String matchSubSrc, boolean found, double value) {
        boolean flag = false;
        int x = obj.getVariableCount();
        for (int i = 0; i < x; ++i) {
            String vString = obj.getVariableDefinition(i);
            StringTokenizer aTok = new StringTokenizer(vString, "|");
            String src = aTok.nextToken();
            if (matchSrc.length() > 0 && !src.equals(matchSrc)) continue;
            if (matchSubSrc.length() > 0 || matchSrc.length() > 0) {
                String subSrc = aTok.nextToken();
                if (matchSubSrc.length() > 0 && !subSrc.equals(matchSubSrc)) continue;
            }
            if (!aTok.hasMoreTokens()) continue;
            String nString = aTok.nextToken();
            if (!aTok.hasMoreTokens() || !nString.equalsIgnoreCase(variableString)) continue;
            String sString = aTok.nextToken();
            Float newValue = this.getVariableValue(sString, src);
            value = !found ? (double)newValue.floatValue() : (isMax ? Math.max(value, newValue.doubleValue()) : Math.min(value, newValue.doubleValue()));
            found = true;
            flag = true;
            if ("".equals(loopVariable)) continue;
            while (loopValue > decrement) {
                loopValue -= decrement;
                value += this.getVariableValue(sString, src).doubleValue();
            }
            loopValue = 0;
            loopVariable = "";
        }
        if (flag) {
            return value + "";
        }
        return "";
    }

    private boolean hasDeity(String deityName) {
        Prerequisite prereq = new Prerequisite();
        prereq.setKind("DEITY");
        prereq.setOperand(deityName);
        prereq.setOperator(PrerequisiteComparator.EQ);
        return PrereqHandler.passes(prereq, this, null);
    }

    private boolean includeSkill(Skill skill, int level) {
        boolean UntrainedExclusiveClass = false;
        String tempSkill = skill.getUntrained();
        if (tempSkill.length() > 0 && tempSkill.charAt(0) == 'Y' && skill.isExclusive() && skill.isClassSkill(this.classList, this)) {
            UntrainedExclusiveClass = true;
        }
        return level == 2 || skill.isRequired() || skill.getTotalRank(this).floatValue() > 0.0f || level == 1 && tempSkill.length() > 0 && tempSkill.charAt(0) == 'Y' && !skill.isExclusive() || level == 1 && UntrainedExclusiveClass;
    }

    private void increaseMoveArray(Double moveRate, String moveType, Double moveMult, String multOp) {
        Double[] tempMove = this.movements;
        String[] tempType = this.movementTypes;
        Double[] tempMult = this.movementMult;
        String[] tempMultOp = this.movementMultOp;
        this.movements = new Double[tempMove.length + 1];
        this.movementTypes = new String[tempMove.length + 1];
        this.movementMult = new Double[tempMove.length + 1];
        this.movementMultOp = new String[tempMove.length + 1];
        System.arraycopy(tempMove, 0, this.movements, 0, tempMove.length);
        System.arraycopy(tempType, 0, this.movementTypes, 0, tempMove.length);
        System.arraycopy(tempMult, 0, this.movementMult, 0, tempMove.length);
        System.arraycopy(tempMultOp, 0, this.movementMultOp, 0, tempMove.length);
        this.movements[tempMove.length] = moveRate;
        this.movementTypes[tempMove.length] = moveType;
        this.movementMult[tempMove.length] = moveMult;
        this.movementMultOp[tempMove.length] = multOp;
    }

    public void incrementClassLevel(int numberOfLevels, PCClass globalClass, boolean bSilent) {
        PCClass pcClassClone;
        if (!this.importing) {
            this.getSpellList();
        }
        if (numberOfLevels > 0) {
            if (!globalClass.isQualified(this)) {
                return;
            }
            if (globalClass.isMonster() && !SettingsHandler.isIgnoreMonsterHDCap() && !this.race.isAdvancementUnlimited() && this.totalHitDice() + numberOfLevels > this.race.maxHitDiceAdvancement() && !bSilent) {
                ShowMessageDelegate.showMessageDialog("Cannot increase Monster Hit Dice for this character beyond " + this.race.maxHitDiceAdvancement() + ". This character's current number of Monster Hit Dice is " + this.totalHitDice(), "PCGen", MessageType.INFORMATION);
                return;
            }
        }
        if ((pcClassClone = this.getClassNamed(globalClass.getName())) == null) {
            if (numberOfLevels >= 0) {
                pcClassClone = (PCClass)globalClass.clone();
                if (pcClassClone == null) {
                    Logging.errorPrint("PlayerCharacter::incrementClassLevel => Clone of class " + globalClass.getName() + " failed!");
                    return;
                }
                this.classList.add(pcClassClone);
                if (numberOfLevels > 0) {
                    Set aSet = pcClassClone.getAutoLanguages();
                    this.getLanguagesList().addAll(aSet);
                }
            } else {
                return;
            }
        }
        if (numberOfLevels > 0) {
            for (int i = 0; i < numberOfLevels; ++i) {
                this.saveLevelInfo(pcClassClone.getKeyName());
                if (pcClassClone.addLevel(false, bSilent, this, false)) continue;
                this.removeLevelInfo(pcClassClone.getKeyName());
                return;
            }
        } else if (numberOfLevels < 0) {
            for (int i = 0; i < -numberOfLevels; ++i) {
                pcClassClone.subLevel(bSilent, this);
                this.removeLevelInfo(pcClassClone.getKeyName());
            }
        }
        if (PlayerCharacter.canReassignTemplateFeats()) {
            int x = this.templateList.size();
            for (int i = 0; i < x; ++i) {
                PCTemplate aTemplate = (PCTemplate)this.templateList.get(i);
                List templateFeats = aTemplate.feats(this.getTotalLevels(), this.totalHitDice(), this);
                int y = templateFeats.size();
                for (int j = 0; j < y; ++j) {
                    this.modFeatsFromList((String)templateFeats.get(j), true, false);
                }
            }
        }
        this.setAggregateFeatsStable(false);
        this.setAutomaticFeatsStable(false);
        this.setVirtualFeatsStable(false);
        this.calcActiveBonuses();
    }

    private void processBonus(BonusObj aBonus) {
        BonusObj newBonus;
        LinkedList<BonusObj> aList = new LinkedList<BonusObj>();
        Iterator ab = this.getActiveBonusList().iterator();
        while (ab.hasNext()) {
            newBonus = (BonusObj)ab.next();
            if (this.processedBonusList.contains(newBonus) || !aBonus.getDependsOn(newBonus.getBonusInfo())) continue;
            aList.add(newBonus);
        }
        ab = aList.iterator();
        while (ab.hasNext()) {
            newBonus = (BonusObj)ab.next();
            this.processBonus(newBonus);
        }
        if (this.processedBonusList.contains(aBonus)) {
            return;
        }
        this.processedBonusList.add(aBonus);
        PObject anObj = (PObject)aBonus.getCreatorObject();
        if (anObj == null) {
            return;
        }
        Iterator as = this.getStringListFromBonus(aBonus, anObj).iterator();
        while (as.hasNext()) {
            String bString = (String)as.next();
            double iBonus = anObj.calcBonusFrom(aBonus, this, bString);
            this.setActiveBonusStack(iBonus, bString);
            Logging.debugPrint("BONUS: " + anObj.getName() + " : " + iBonus + " : " + bString);
        }
    }

    private boolean qualifiesForFeat(Feat aFeat) {
        return aFeat.canBeSelectedBy(this);
    }

    private boolean hasSkill(String skillName) {
        return this.getSkillNamed(skillName) != null;
    }

    private void rebuildLists(PCClass toClass, PCClass fromClass, int iCount, PlayerCharacter aPC) {
        int fromLevel = fromClass.getLevel();
        int toLevel = toClass.getLevel();
        for (int i = 0; i < iCount; ++i) {
            fromClass.doMinusLevelMods(this, fromLevel - i);
            toClass.doPlusLevelMods(toLevel + i + 1, aPC);
        }
    }

    private void removeExcessSkills(int level) {
        Iterator skillIter = this.getSkillList().iterator();
        while (skillIter.hasNext()) {
            Skill skill = (Skill)skillIter.next();
            if (this.includeSkill(skill, level)) continue;
            skillIter.remove();
            this.setDirty(true);
        }
    }

    private void removeInvisibleSkills(int visible) {
        Iterator skillIter = this.getSkillList().iterator();
        while (skillIter.hasNext()) {
            Skill skill = (Skill)skillIter.next();
            if (skill.isVisible() == 1 || skill.isVisible() == visible) continue;
            skillIter.remove();
            this.setDirty(true);
        }
    }

    private boolean removeLevelInfo(String classKeyName) {
        for (int idx = this.pcLevelInfo.size() - 1; idx >= 0; --idx) {
            PCLevelInfo li = (PCLevelInfo)this.pcLevelInfo.get(idx);
            if (!li.getClassKeyName().equals(classKeyName)) continue;
            this.removeLevelInfo(idx);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    private void removeLevelInfo(int idx) {
        this.pcLevelInfo.remove(idx);
        this.setDirty(true);
    }

    private void rollStats(int method) {
        Iterator stat = this.statList.getStats().iterator();
        while (stat.hasNext()) {
            int roll;
            PCStat currentStat = (PCStat)stat.next();
            currentStat.setBaseScore(0);
            if (SettingsHandler.isPurchaseStatMode()) {
                currentStat.setBaseScore(SettingsHandler.getPurchaseModeBaseStatScore());
                continue;
            }
            switch (method) {
                case 0: {
                    roll = 0;
                    break;
                }
                case 8: {
                    roll = SettingsHandler.getAllStatsValue();
                    break;
                }
                default: {
                    roll = 10;
                }
            }
            if ((roll += currentStat.getBaseScore()) < currentStat.getMinValue()) {
                roll = currentStat.getMinValue();
            }
            if (roll > currentStat.getMaxValue()) {
                roll = currentStat.getMaxValue();
            }
            currentStat.setBaseScore(roll);
        }
        this.setPoolAmount(0);
        this.costPool = 0;
        this.getLanguagesList().clear();
        this.getAutoLanguages();
        this.setPoolAmount(0);
    }

    private List sortEquipmentList(List unsortedEquipList) {
        return this.sortEquipmentList(unsortedEquipList, 0);
    }

    private List sortEquipmentList(List unsortedEquipList, int merge) {
        if (unsortedEquipList.isEmpty()) {
            return unsortedEquipList;
        }
        List sortedList = PlayerCharacter.mergeEquipmentList(unsortedEquipList, merge);
        Iterator i = sortedList.iterator();
        while (i.hasNext()) {
            Equipment item = (Equipment)i.next();
            if (item.getOutputIndex() != -1) continue;
            i.remove();
        }
        return sortedList;
    }

    private int subCalcACOfType(StringTokenizer aTok) {
        int total = 0;
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            total += Integer.parseInt(BonusToken.getBonusToken("BONUS.COMBAT.AC." + aString, this));
        }
        return total;
    }

    private double sumActiveBonusMap(String prefix) {
        double bonus = 0.0;
        prefix = prefix.toUpperCase();
        LinkedList<String> aList = new LinkedList<String>();
        Iterator i = this.getActiveBonusMap().keySet().iterator();
        while (i.hasNext()) {
            String aKey = i.next().toString();
            if (aList.contains(aKey)) continue;
            String rString = aKey;
            if (rString.endsWith(".STACK")) {
                rString = rString.substring(0, rString.length() - 6);
            } else if (rString.endsWith(".REPLACE")) {
                rString = rString.substring(0, rString.length() - 8);
            }
            if (rString.length() > prefix.length() && !rString.startsWith(prefix + ":") || !rString.startsWith(prefix)) continue;
            aList.add(rString);
            aList.add(rString + ".STACK");
            aList.add(rString + ".REPLACE");
            double aBonus = this.getActiveBonusForMapKey(rString, Double.NaN);
            double replaceBonus = this.getActiveBonusForMapKey(rString + ".REPLACE", Double.NaN);
            double stackBonus = this.getActiveBonusForMapKey(rString + ".STACK", 0.0);
            if (Double.isNaN(aBonus)) {
                if (!Double.isNaN(replaceBonus)) {
                    bonus += replaceBonus;
                }
            } else {
                bonus = Double.isNaN(replaceBonus) ? (bonus += aBonus) : (bonus += Math.max(aBonus, replaceBonus));
            }
            bonus += stackBonus;
        }
        return bonus;
    }

    private int totalMonsterLevels() {
        int totalLevels = 0;
        Iterator e = this.classList.iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            if (!aClass.isMonster()) continue;
            totalLevels += aClass.getLevel();
        }
        e = this.companionModList.iterator();
        while (e.hasNext()) {
            CompanionMod cMod = (CompanionMod)e.next();
            totalLevels += cMod.getHitDie();
        }
        return totalLevels;
    }

    private void setDescriptionLst(String descriptionLst) {
        this.descriptionLst = descriptionLst;
    }

    public int getCharacterLevel(PCLevelInfo info) {
        int i = 1;
        Iterator iter = this.pcLevelInfo.iterator();
        while (iter.hasNext()) {
            PCLevelInfo element = (PCLevelInfo)iter.next();
            if (info == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private class CasterLevelSpellBonus {
        private int bonus;
        private String type;

        private CasterLevelSpellBonus() {
        }

        public CasterLevelSpellBonus(int b, String t) {
            this.bonus = b;
            this.type = t;
        }

        public int getBonus() {
            return this.bonus;
        }

        public String getType() {
            return this.type;
        }

        public void setBonus(int newBonus) {
            this.bonus = newBonus;
        }

        public String toString() {
            return "bonus: " + this.bonus + "    type: " + this.type;
        }
    }
}

