/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public final class Race
extends PObject {
    private ArrayList languageBonus = new ArrayList();
    private ArrayList monCCSkillList = null;
    private ArrayList monCSkillList = null;
    private ArrayList weaponProfBonus = new ArrayList();
    private ArrayList weaponProfs = new ArrayList();
    private HashMap hitPointMap = new HashMap();
    private Integer initMod = new Integer(0);
    private Integer naturalAC = new Integer(0);
    private Integer startingAC = new Integer(10);
    private String hitDieLock = "";
    private String ageString = "";
    private String bonusSkillList = "";
    private String chooseLanguageAutos = "";
    private String displayName = "None";
    private Dimension face = new Dimension(5, 0);
    private String favoredClass = "";
    private String featList = "";
    private String heightString = "";
    private String levelAdjustment = "0";
    private String mFeatList = "";
    private String monsterClass = null;
    private String size = "";
    private String vFeatList = "";
    private String weightString = "";
    private int[] hitDiceAdvancement;
    private boolean unlimitedAdvancement = false;
    private int BAB = 0;
    private int CR = 0;
    private int bonusInitialFeats = 0;
    private int bonusSkillsPerLevel = 0;
    private int hands = 2;
    private int hitDice = 0;
    private int hitDiceSize = 0;
    private int initialSkillMultiplier = 4;
    private int langNum = 0;
    private int legs = 2;
    private int monsterClassLevels = 0;
    private int reach = 5;

    public Race() {
        this.vision = new HashMap();
        this.vision.put("Normal", "0");
    }

    public void setAdvancementUnlimited(boolean unlimitedAdvancement) {
        this.unlimitedAdvancement = unlimitedAdvancement;
    }

    public boolean isAdvancementUnlimited() {
        return this.unlimitedAdvancement;
    }

    public void setAgeString(String aString) {
        this.ageString = aString;
    }

    public void setBAB(int newBAB) {
        this.BAB = newBAB;
    }

    public void setBonusInitialFeats(int i) {
        this.bonusInitialFeats = i;
    }

    public int getBonusInitialFeats() {
        return this.bonusInitialFeats;
    }

    public void setBonusSkillList(String aString) {
        this.bonusSkillList = aString;
    }

    public void setBonusSkillsPerLevel(int i) {
        this.bonusSkillsPerLevel = i;
    }

    public int getBonusSkillsPerLevel() {
        return this.bonusSkillsPerLevel;
    }

    public void setCR(int newCR) {
        this.CR = newCR;
    }

    public int getCR() {
        return this.CR;
    }

    public void setChooseLanguageAutos(String chooseLanguageAutos) {
        this.chooseLanguageAutos = chooseLanguageAutos;
    }

    public String getChooseLanguageAutos() {
        return this.chooseLanguageAutos;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayVision(PlayerCharacter aPC) {
        if (this.vision == null) {
            return "";
        }
        if (aPC == null) {
            return "";
        }
        StringBuffer vis = new StringBuffer(25);
        Iterator i = this.vision.keySet().iterator();
        while (i.hasNext()) {
            String aKey = i.next().toString();
            String aVal = this.vision.get(aKey).toString();
            int val = aPC.getVariableValue(aVal, "").intValue();
            if (vis.length() > 0) {
                vis.append(';');
            }
            vis.append(aKey);
            if (val == 0) continue;
            vis.append(" (").append(val).append("')");
        }
        return vis.toString();
    }

    public void setFace(int width, int height) {
        this.face = new Dimension(width, height);
    }

    public Dimension getFace() {
        return this.face;
    }

    public void setFavoredClass(String newClass) {
        this.favoredClass = newClass;
    }

    public String getFavoredClass() {
        return this.favoredClass;
    }

    public void setFeatList(String featList) {
        this.featList = featList;
    }

    public String getFeatList(PlayerCharacter aPC) {
        return this.getFeatList(aPC, true);
    }

    public String getFeatList(PlayerCharacter aPC, boolean checkPC) {
        if (checkPC && aPC != null && aPC.isMonsterDefault() && !"".equals(this.mFeatList)) {
            return this.featList + "|" + this.mFeatList;
        }
        if (!checkPC || aPC != null) {
            return this.featList;
        }
        return "";
    }

    public void setHands(int newHands) {
        this.hands = newHands;
    }

    public int getHands() {
        return this.hands;
    }

    public void setHeightString(String aString) {
        this.heightString = aString;
    }

    public void setHitDice(int newHitDice) {
        if (newHitDice < 0) {
            ShowMessageDelegate.showMessageDialog("Invalid number of hit dice in race " + this.name, "PCGen", MessageType.ERROR);
            return;
        }
        this.hitDice = newHitDice;
    }

    public void setHitDiceAdvancement(int[] advancement) {
        this.hitDiceAdvancement = advancement;
    }

    public int getHitDiceAdvancement(int index) {
        return this.hitDiceAdvancement[index];
    }

    public void setHitDiceSize(int newHitDiceSize) {
        this.hitDiceSize = newHitDiceSize;
    }

    public int getHitDiceSize(PlayerCharacter aPC) {
        return this.getHitDiceSize(aPC, true);
    }

    public int getHitDiceSize(PlayerCharacter aPC, boolean checkPC) {
        if (!checkPC || aPC != null && aPC.isMonsterDefault()) {
            return this.hitDiceSize;
        }
        return 0;
    }

    public void setHitDieLock(String hitDieLock) {
        this.hitDieLock = hitDieLock;
    }

    public void setHitPoint(int aLevel, Integer iRoll) {
        this.hitPointMap.put(Integer.toString(aLevel), iRoll);
    }

    public Integer getHitPoint(int j) {
        Integer aHP = (Integer)this.hitPointMap.get(Integer.toString(j));
        if (aHP == null) {
            return new Integer(0);
        }
        return aHP;
    }

    public void setHitPointMap(HashMap newMap) {
        this.hitPointMap.clear();
        this.hitPointMap.putAll(newMap);
    }

    public int getHitPointMapSize() {
        return this.hitPointMap.size();
    }

    public void setInitMod(Integer initMod) {
        this.initMod = initMod;
    }

    public void setInitialSkillMultiplier(int initialSkillMultiplier) {
        this.initialSkillMultiplier = initialSkillMultiplier;
    }

    public int getInitialSkillMultiplier() {
        return this.initialSkillMultiplier;
    }

    public void setLangNum(int langNum) {
        this.langNum = langNum;
    }

    public void setLanguageBonus(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, ",", false);
        while (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            if (".CLEAR".equals(token)) {
                this.getLanguageBonus().clear();
                continue;
            }
            Language aLang = Globals.getLanguageNamed(token);
            if (aLang == null) continue;
            this.getLanguageBonus().add(aLang);
        }
    }

    public ArrayList getLanguageBonus() {
        return this.languageBonus;
    }

    public void setLegs(int argLegs) {
        this.legs = argLegs;
    }

    public int getLegs() {
        return this.legs;
    }

    public void setLevelAdjustment(String newLevelAdjustment) {
        this.levelAdjustment = newLevelAdjustment;
    }

    public int getLevelAdjustment(PlayerCharacter aPC) {
        int lvlAdjust;
        if (aPC != null) {
            return aPC.getVariableValue(this.levelAdjustment, "").intValue();
        }
        try {
            lvlAdjust = Integer.parseInt(this.levelAdjustment);
        }
        catch (NumberFormatException nfe) {
            lvlAdjust = 0;
        }
        return lvlAdjust;
    }

    public String getLevelAdjustmentFormula() {
        return this.levelAdjustment;
    }

    public void setMFeatList(String mFeatList) {
        this.mFeatList = mFeatList;
    }

    public String getMFeatList() {
        return this.mFeatList;
    }

    public void setMonCCSkillList(String aString) {
        if (this.monCCSkillList == null) {
            this.monCCSkillList = new ArrayList();
        }
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if (".CLEAR".equals(bString)) {
                this.monCCSkillList.clear();
                continue;
            }
            if (bString.startsWith("TYPE.") || bString.startsWith("TYPE=")) {
                Iterator e1 = Globals.getSkillList().iterator();
                while (e1.hasNext()) {
                    Skill aSkill = (Skill)e1.next();
                    if (!aSkill.isType(bString.substring(5))) continue;
                    this.monCCSkillList.add(aSkill.getName());
                }
                continue;
            }
            this.monCCSkillList.add(bString);
        }
    }

    public void setMonCSkillList(String aString) {
        if (this.monCSkillList == null) {
            this.monCSkillList = new ArrayList();
        }
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if (".CLEAR".equals(bString)) {
                this.monCSkillList.clear();
                continue;
            }
            if (bString.startsWith("TYPE.") || bString.startsWith("TYPE=")) {
                Iterator e1 = Globals.getSkillList().iterator();
                while (e1.hasNext()) {
                    Skill aSkill = (Skill)e1.next();
                    if (!aSkill.isType(bString.substring(5))) continue;
                    this.monCSkillList.add(aSkill.getName());
                }
                continue;
            }
            this.monCSkillList.add(bString);
        }
    }

    public void setMonsterClass(String string) {
        this.monsterClass = string;
    }

    public String getMonsterClass(PlayerCharacter aPC, boolean checkPC) {
        if (!checkPC || aPC != null && !aPC.isMonsterDefault()) {
            return this.monsterClass;
        }
        return null;
    }

    public void setMonsterClassLevels(int num) {
        this.monsterClassLevels = num;
    }

    public int getMonsterClassLevels(PlayerCharacter aPC) {
        return this.getMonsterClassLevels(aPC, true);
    }

    public int getMonsterClassLevels(PlayerCharacter aPC, boolean checkPC) {
        if (!checkPC || aPC != null && !aPC.isMonsterDefault()) {
            return this.monsterClassLevels;
        }
        return 0;
    }

    public boolean isNonAbility(int statIdx) {
        List statList = SettingsHandler.getGame().getUnmodifiableStatList();
        if (statIdx < 0 || statIdx >= statList.size()) {
            return true;
        }
        String aStat = "|LOCK." + ((PCStat)statList.get(statIdx)).getAbb() + "|10";
        int x = this.getVariableCount();
        for (int i = 0; i < x; ++i) {
            String varString = this.getVariableDefinition(i);
            if (!varString.endsWith(aStat)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfHitDiceAdvancements() {
        return this.hitDiceAdvancement != null ? this.hitDiceAdvancement.length : 0;
    }

    public String getPCCText(PlayerCharacter aPC) {
        Iterator e;
        int index;
        StringBuffer txt = new StringBuffer(super.getPCCText(aPC));
        if (this.favoredClass != null && this.favoredClass.length() > 0) {
            txt.append("\tFAVCLASS:").append(this.favoredClass);
        }
        if (this.bonusInitialFeats != 0) {
            txt.append("\tSTARTFEATS:").append(this.bonusInitialFeats);
        }
        if (this.size != null && this.size.length() > 0) {
            txt.append("\tSIZE:").append(this.size);
        }
        if (this.getMovements() != null && this.getMovements().length > 0) {
            txt.append("\tMOVE:");
            for (index = 0; index < this.getMovements().length; ++index) {
                if (index > 0) {
                    txt.append(',');
                }
                txt.append(this.getMovementTypes()[index]).append(",");
                txt.append(this.getMovements()[index]);
            }
        }
        if (this.reach != 5) {
            txt.append("\tREACH:").append(this.reach);
        }
        if (this.chooseLanguageAutos != null && this.chooseLanguageAutos.length() > 0) {
            txt.append("\tCHOOSE:LANGAUTO:").append(this.chooseLanguageAutos);
        }
        if (this.languageBonus != null && !this.languageBonus.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            e = this.languageBonus.iterator();
            while (e.hasNext()) {
                if (buffer.length() != 0) {
                    buffer.append(',');
                }
                buffer.append(e.next().toString());
            }
            txt.append("\tLANGBONUS:").append(buffer.toString());
        }
        if (this.weaponProfBonus != null && this.weaponProfBonus.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            e = this.weaponProfBonus.iterator();
            while (e.hasNext()) {
                if (buffer.length() != 0) {
                    buffer.append('|');
                }
                buffer.append((String)e.next());
            }
            txt.append("\tWEAPONBONUS:").append(buffer.toString());
        }
        if (this.mFeatList != null && this.mFeatList.length() > 0) {
            txt.append("\tMFEAT:").append(this.mFeatList);
        }
        if (this.legs != 2) {
            txt.append("\tLEGS:").append(this.legs);
        }
        if (this.hands != 2) {
            txt.append("\tHANDS:").append(this.hands);
        }
        if (this.getNaturalWeapons() != null && this.getNaturalWeapons().size() > 0) {
            StringBuffer buffer = new StringBuffer();
            e = this.getNaturalWeapons().iterator();
            while (e.hasNext()) {
                Equipment natEquip;
                String eqName;
                int index2;
                if (buffer.length() != 0) {
                    buffer.append('|');
                }
                if ((index2 = (eqName = (natEquip = (Equipment)e.next()).getName()).indexOf(" (Natural/Primary)")) >= 0) {
                    eqName = eqName.substring(0, index2) + eqName.substring(index2 + " (Natural/Primary)".length());
                }
                if ((index2 = eqName.indexOf(" (Natural/Secondary)")) >= 0) {
                    eqName = eqName.substring(0, index2) + eqName.substring(index2 + " (Natural/Secondary)".length());
                }
                buffer.append(eqName).append(',');
                buffer.append(natEquip.getType(false)).append(',');
                if (!natEquip.isAttacksProgress()) {
                    buffer.append('*');
                }
                buffer.append((int)natEquip.bonusTo(aPC, "WEAPON", "ATTACKS", true) + 1).append(',');
                buffer.append(natEquip.getDamage(aPC));
            }
            txt.append("\tNATURALATTACKS:").append(buffer.toString());
        }
        if (this.initialSkillMultiplier != 4) {
            txt.append("\tSKILLMULT:").append(this.initialSkillMultiplier);
        }
        if (this.monsterClass != null) {
            txt.append("\tMONSTERCLASS:").append(this.monsterClass);
            txt.append(':').append(this.monsterClassLevels);
        }
        if (this.templates != null && this.templates.size() > 0) {
            Iterator e2 = this.templates.iterator();
            while (e2.hasNext()) {
                txt.append("\tTEMPLATE:").append((String)e2.next());
            }
        }
        if (this.hitDiceAdvancement != null && this.hitDiceAdvancement.length > 0) {
            txt.append("\tHITDICEADVANCEMENT:");
            for (index = 0; index < this.hitDiceAdvancement.length; ++index) {
                if (index > 0) {
                    txt.append(',');
                }
                if (this.hitDiceAdvancement[index] == -1 && this.isAdvancementUnlimited()) {
                    txt.append('*');
                    continue;
                }
                txt.append(this.hitDiceAdvancement[index]);
            }
        }
        if (this.CR != 0) {
            txt.append("\tCR:");
            if (this.CR < 0) {
                txt.append("1/").append(-this.CR);
            } else {
                txt.append(this.CR);
            }
        }
        if (this.startingAC != 10) {
            txt.append("\tAC:").append(this.startingAC.toString());
        }
        if (CoreUtility.doublesEqual(this.face.getHeight(), 0.0)) {
            txt.append("\tFACE:").append(this.face.getWidth() + " ft.");
        } else {
            txt.append("\tFACE:").append(this.face.getWidth() + " ft. by " + this.face.getHeight() + " ft.");
        }
        if (this.featList != null && this.featList.length() > 0) {
            txt.append("\tFEAT:").append(this.featList);
        }
        if (this.hitDice != 0 || this.hitDiceSize != 0) {
            txt.append("\tHITDICE:").append(this.hitDice).append(',').append(this.hitDiceSize);
        }
        if (this.initMod != 0) {
            txt.append("\tINIT:").append(this.initMod.toString());
        }
        if (this.langNum != 0) {
            txt.append("\tLANGNUM:").append(this.langNum);
        }
        if (!"0".equals(this.levelAdjustment)) {
            txt.append("\tLEVELADJUSTMENT:").append(this.levelAdjustment);
        }
        if (this.weaponProfs != null && this.weaponProfs.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            e = this.weaponProfs.iterator();
            while (e.hasNext()) {
                if (buffer.length() != 0) {
                    buffer.append('|');
                }
                buffer.append((String)e.next());
            }
            txt.append("\tPROF:").append(buffer.toString());
        }
        if (!"alwaysValid".equals(this.getQualifyString())) {
            txt.append("\tQUALIFY:").append(this.getQualifyString());
        }
        if (!"None".equals(this.displayName)) {
            txt.append("\tRACENAME:").append(this.displayName);
        }
        if (this.bonusSkillList != null && this.bonusSkillList.length() > 0) {
            txt.append("\tSKILL:").append(this.bonusSkillList);
        }
        if (this.vFeatList != null && this.vFeatList.length() > 0) {
            txt.append("\tVFEAT:").append(this.vFeatList);
        }
        if (this.bonusSkillsPerLevel != 0) {
            txt.append("\tXTRASKILLPTSPERLVL:").append(this.bonusSkillsPerLevel);
        }
        return txt.toString();
    }

    public void setReach(int newReach) {
        this.reach = newReach;
    }

    public int getReach() {
        return this.reach;
    }

    public void setSize(String argSize) {
        this.size = argSize;
    }

    public String getSize() {
        return this.size;
    }

    public void setStartingAC(Integer anInt) {
        this.startingAC = anInt;
    }

    public void setVisionTable(Map visionTable) {
        this.vision = visionTable;
    }

    public Map getVisionTable() {
        return this.vision;
    }

    public void setWeaponProfBonus(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        while (aTok.hasMoreTokens()) {
            this.getWeaponProfBonus().add(aTok.nextToken());
        }
    }

    public ArrayList getWeaponProfBonus() {
        return this.weaponProfBonus;
    }

    public void setWeaponProfs(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        String typeString = aTok.nextToken();
        String prefix = typeString + "|";
        while (aTok.hasMoreTokens()) {
            this.weaponProfs.add(prefix + aTok.nextToken());
        }
    }

    public Object clone() {
        Race aRace = null;
        try {
            aRace = (Race)super.clone();
            aRace.favoredClass = this.favoredClass;
            aRace.bonusSkillsPerLevel = this.bonusSkillsPerLevel;
            aRace.bonusInitialFeats = this.bonusInitialFeats;
            aRace.size = this.size;
            aRace.bonusSkillList = this.bonusSkillList;
            aRace.ageString = this.ageString;
            aRace.heightString = this.heightString;
            aRace.weightString = this.weightString;
            aRace.languageBonus = (ArrayList)this.languageBonus.clone();
            aRace.weaponProfBonus = (ArrayList)this.weaponProfBonus.clone();
            aRace.featList = this.featList;
            aRace.vFeatList = this.vFeatList;
            aRace.startingAC = new Integer(this.startingAC);
            aRace.naturalAC = new Integer(this.naturalAC);
            aRace.initMod = new Integer(this.initMod);
            aRace.langNum = this.langNum;
            aRace.initialSkillMultiplier = this.initialSkillMultiplier;
            aRace.isSpecified = this.isSpecified;
            aRace.visible = this.visible;
            aRace.levelAdjustment = this.levelAdjustment;
            aRace.CR = this.CR;
            aRace.BAB = this.BAB;
            aRace.hitDice = this.hitDice;
            aRace.hitDiceSize = this.hitDiceSize;
            aRace.hitPointMap = new HashMap(this.hitPointMap);
            aRace.hitDiceAdvancement = this.hitDiceAdvancement;
            aRace.hands = this.hands;
            aRace.reach = this.reach;
            aRace.face = this.face;
            aRace.SR = this.SR;
            aRace.DR = this.DR;
            aRace.weaponProfs = (ArrayList)this.weaponProfs.clone();
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aRace;
    }

    public boolean equals(Object obj) {
        return obj instanceof Race && ((Race)obj).getName().equals(this.getName());
    }

    public boolean hasAdvancement() {
        return this.hitDiceAdvancement != null;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int hitDice(PlayerCharacter aPC) {
        return this.hitDice(aPC, true);
    }

    public int hitDice(PlayerCharacter aPC, boolean checkPC) {
        if (!checkPC || aPC != null && aPC.isMonsterDefault()) {
            return this.hitDice;
        }
        return 0;
    }

    public void rollHP(PlayerCharacter aPC) {
        if (!aPC.isImporting()) {
            int min = 1 + (int)aPC.getTotalBonusTo("HD", "MIN");
            int max = this.hitDiceSize + (int)aPC.getTotalBonusTo("HD", "MAX");
            for (int x = 0; x < this.hitDice; ++x) {
                this.setHitPoint(x, new Integer(Globals.rollHP(min, max, this.getName(), x + 1)));
            }
        }
        aPC.setCurrentHP(aPC.hitPoints());
    }

    protected int getSR(PlayerCharacter aPC) {
        int intSR;
        if (this.SR != null && aPC != null) {
            return aPC.getVariableValue(this.SR, "").intValue();
        }
        try {
            intSR = Integer.parseInt(this.SR);
        }
        catch (NumberFormatException nfe) {
            intSR = 0;
        }
        return intSR;
    }

    protected void doGlobalTypeUpdate(String aString) {
        Globals.getRaceTypes().add(aString);
    }

    int getBAB(PlayerCharacter aPC) {
        if (aPC != null && aPC.isMonsterDefault()) {
            if (this.BAB == 0) {
                this.BAB = (int)this.bonusTo("COMBAT", "BAB", aPC, aPC);
            }
            return this.BAB;
        }
        return 0;
    }

    String getHitDieLock() {
        return this.hitDieLock;
    }

    int getLangNum() {
        return this.langNum;
    }

    String getMonsterClass(PlayerCharacter aPC) {
        return this.getMonsterClass(aPC, true);
    }

    ArrayList getWeaponProfs() {
        return this.weaponProfs;
    }

    int bonusForSkill(String skillName) {
        if (this.getBonusSkillList().length() == 0) {
            return 0;
        }
        StringTokenizer aTok = new StringTokenizer(this.bonusSkillList, "=");
        while (aTok.hasMoreTokens()) {
            String skillList = aTok.nextToken();
            int anInt = Integer.parseInt(aTok.nextToken());
            StringTokenizer bTok = new StringTokenizer(skillList, ",", false);
            while (bTok.hasMoreTokens()) {
                String aSkill = bTok.nextToken();
                if (!aSkill.equals(skillName)) continue;
                return anInt;
            }
        }
        return 0;
    }

    int calcHitPoints(int iConMod) {
        int total = 0;
        for (int i = 0; i <= this.hitDice; ++i) {
            if (this.getHitPoint(i) <= 0) continue;
            int iHp = this.getHitPoint(i) + iConMod;
            if (iHp < 1) {
                iHp = 1;
            }
            total += iHp;
        }
        return total;
    }

    boolean canBeAlignment(String aString) {
        if (this.getPreReqCount() != 0) {
            for (int e = 0; e < this.getPreReqCount(); ++e) {
                Prerequisite prereq = this.getPreReq(e);
                if (!"ALIGN".equalsIgnoreCase(prereq.getKind())) continue;
                return prereq.getKey().equalsIgnoreCase(aString);
            }
        }
        return true;
    }

    void chooseLanguageAutos(boolean flag, PlayerCharacter aPC) {
        if (!flag && !"".equals(this.chooseLanguageAutos)) {
            StringTokenizer tokens = new StringTokenizer(this.chooseLanguageAutos, "|", false);
            ChooserInterface c = ChooserFactory.getChooserInstance();
            c.setPool(1);
            c.setPoolFlag(false);
            c.setTitle("Pick a Language: ");
            SortedSet<String> list = new TreeSet<String>();
            while (tokens.hasMoreTokens()) {
                list.add(tokens.nextToken());
            }
            list = Globals.extractLanguageListNames(list);
            c.setAvailableList(new ArrayList(list));
            c.setVisible(true);
            ArrayList selectedList = c.getSelectedList();
            if (selectedList != null && selectedList.size() != 0) {
                aPC.addFreeLanguage((String)selectedList.get(0));
            }
        }
    }

    boolean hasMonsterCCSkill(String aName) {
        if (this.monCCSkillList == null || this.monCCSkillList.isEmpty()) {
            return false;
        }
        if (this.monCCSkillList.contains(aName)) {
            return true;
        }
        Iterator e = this.monCCSkillList.iterator();
        while (e.hasNext()) {
            String aString = (String)e.next();
            if (aString.lastIndexOf(37) < 0 || !aName.startsWith(aString = aString.substring(0, aString.length() - 1))) continue;
            return true;
        }
        return false;
    }

    boolean hasMonsterCSkill(String aName) {
        String aString;
        if (this.monCSkillList == null || this.monCSkillList.isEmpty()) {
            return false;
        }
        if (this.monCSkillList.contains(aName)) {
            return true;
        }
        if (this.monCSkillList.contains("LIST")) {
            for (int e = 0; e < this.getAssociatedCount(); ++e) {
                aString = this.getAssociated(e);
                if (!aName.startsWith(aString) && !aString.startsWith(aName)) continue;
                return true;
            }
        }
        Iterator e = this.monCSkillList.iterator();
        while (e.hasNext()) {
            aString = (String)e.next();
            if (aString.lastIndexOf(37) < 0 || !aName.startsWith(aString = aString.substring(0, aString.length() - 1))) continue;
            return true;
        }
        return false;
    }

    int maxHitDiceAdvancement() {
        if (this.hitDiceAdvancement != null && this.hitDiceAdvancement.length >= 1) {
            return this.hitDiceAdvancement[this.hitDiceAdvancement.length - 1];
        }
        return 0;
    }

    int sizesAdvanced(int HD2) {
        if (this.hitDiceAdvancement != null) {
            for (int x = 0; x < this.hitDiceAdvancement.length; ++x) {
                if (HD2 > this.hitDiceAdvancement[x] && this.hitDiceAdvancement[x] != -1) continue;
                return x;
            }
        }
        return 0;
    }

    private String getBonusSkillList() {
        return this.bonusSkillList;
    }
}

