/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.util.Logging;

final class RollInfo {
    protected int sides = 0;
    protected int times = 0;
    private boolean[] keepList = null;
    private int modifier = 0;
    private int rerollAbove = Integer.MAX_VALUE;
    private int rerollBelow = Integer.MIN_VALUE;
    private int totalCeiling = Integer.MAX_VALUE;
    private int totalFloor = Integer.MIN_VALUE;

    RollInfo(String rollString) {
        StringTokenizer st = new StringTokenizer(rollString, " ", true);
        try {
            String tok = st.nextToken("d");
            if ("d".equals(tok)) {
                this.times = 1;
            } else {
                this.times = Integer.parseInt(tok);
                if (st.hasMoreTokens()) {
                    tok = st.nextToken("d");
                    if (!"d".equals(tok)) {
                        Logging.errorPrint("Bad roll parsing in '" + rollString + "': missing 'd'");
                        return;
                    }
                } else {
                    this.sides = 1;
                    return;
                }
            }
            String parseChars = "/\\|mM+-tT";
            this.sides = Integer.parseInt(st.nextToken(parseChars));
            if (this.sides < 1) {
                Logging.errorPrint("Bad roll parsing in '" + rollString + "': sides < 1: " + this.sides);
                return;
            }
            block13: while (st.hasMoreTokens()) {
                tok = st.nextToken(parseChars);
                switch (tok.charAt(0)) {
                    case '/': {
                        parseChars = "mM+-tT";
                        int keepTop = Integer.parseInt(st.nextToken(parseChars));
                        if (keepTop > this.times) {
                            Logging.errorPrint("Bad keepTop in '" + rollString + "': times: " + this.times + "; keepTop: " + keepTop);
                            return;
                        }
                        this.keepList = new boolean[this.times];
                        for (int i = this.times - keepTop; i < this.times; ++i) {
                            this.keepList[i] = true;
                        }
                        continue block13;
                    }
                    case '\\': {
                        parseChars = "mM+-tT";
                        int keepBottom = Integer.parseInt(st.nextToken(parseChars));
                        if (keepBottom > this.times) {
                            Logging.errorPrint("Bad keepBottom in '" + rollString + "': times: " + this.times + "; keepBottom: " + keepBottom);
                            return;
                        }
                        this.keepList = new boolean[this.times];
                        for (int i = 0; i < keepBottom; ++i) {
                            this.keepList[i] = true;
                        }
                        continue block13;
                    }
                    case '|': {
                        parseChars = "mM+-tT";
                        tok = st.nextToken(parseChars);
                        this.keepList = new boolean[this.times];
                        StringTokenizer keepSt = new StringTokenizer(tok, ",");
                        while (keepSt.hasMoreTokens()) {
                            this.keepList[Integer.parseInt((String)keepSt.nextToken((String)",")) - 1] = true;
                        }
                        continue block13;
                    }
                    case 'm': {
                        parseChars = "M+-tT";
                        this.rerollBelow = Integer.parseInt(st.nextToken(parseChars));
                        continue block13;
                    }
                    case 'M': {
                        parseChars = "m+-tT";
                        this.rerollAbove = Integer.parseInt(st.nextToken(parseChars));
                        continue block13;
                    }
                    case '+': {
                        parseChars = "tT";
                        this.modifier = Integer.parseInt(st.nextToken(" "));
                        continue block13;
                    }
                    case '-': {
                        parseChars = "tT";
                        this.modifier = -Integer.parseInt(st.nextToken(" "));
                        continue block13;
                    }
                    case 't': {
                        parseChars = "T";
                        this.totalFloor = Integer.parseInt(st.nextToken(" "));
                        continue block13;
                    }
                    case 'T': {
                        parseChars = "t";
                        this.totalCeiling = Integer.parseInt(st.nextToken(" "));
                        continue block13;
                    }
                }
                Logging.errorPrint("Bizarre dice parser error in '" + rollString + "': not a valid delimiter");
            }
        }
        catch (NumberFormatException ex) {
            Logging.errorPrint("Bad roll string in '" + rollString + "': " + ex, ex);
        }
    }

    public static void main(String[] args) {
        Logging.setDebugMode(true);
        for (int i = 0; i < args.length; ++i) {
            RollInfo ri = new RollInfo(args[i]);
            Logging.debugPrint(ri + ": " + RollInfo.roll());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.times > 1) {
            buf.append(this.times);
        }
        buf.append("d").append(this.sides);
        while (this.keepList != null) {
            int p = 0;
            int i = 0;
            for (i = 0; i < this.times && !this.keepList[i]; ++i) {
            }
            if (i == this.times) {
                Logging.errorPrint("Bad rolls: nothing to keep!");
                return null;
            }
            for (i = 0; i < this.times && this.keepList[i]; ++i) {
            }
            if (i == this.times) break;
            p = i;
            while (i < this.times && !this.keepList[i]) {
                ++i;
            }
            if (p > 0 && i == this.times) {
                buf.append("\\").append(p);
                break;
            }
            for (i = 0; i < this.times && !this.keepList[i]; ++i) {
            }
            p = i;
            while (i < this.times && this.keepList[i]) {
                ++i;
            }
            if (p > 0 && i == this.times) {
                buf.append("/").append(this.times - p);
                break;
            }
            buf.append("|");
            boolean first = true;
            for (i = 0; i < this.times; ++i) {
                if (!this.keepList[i]) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append(i + 1);
            }
        }
        if (this.rerollBelow != Integer.MIN_VALUE) {
            buf.append("m").append(this.rerollBelow);
        }
        if (this.rerollAbove != Integer.MAX_VALUE) {
            buf.append("M").append(this.rerollAbove);
        }
        if (this.modifier > 0) {
            buf.append("+").append(this.modifier);
        } else if (this.modifier < 0) {
            buf.append("-").append(-this.modifier);
        }
        if (this.totalFloor != Integer.MIN_VALUE) {
            buf.append("t").append(this.totalFloor);
        }
        if (this.totalCeiling != Integer.MAX_VALUE) {
            buf.append("T").append(this.totalCeiling);
        }
        return buf.toString();
    }

    private static int roll() {
        boolean result = false;
        return 0;
    }
}

