/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.Arrays;
import pcgen.core.Globals;
import pcgen.util.DiceExpression;
import pcgen.util.Logging;
import pcgen.util.ParseException;

public final class RollingMethods {
    public static int roll(int times, int sides) {
        return RollingMethods.roll(times, sides, 0, times, 0);
    }

    public static int roll(int sides) {
        return Globals.getRandomInt(sides) + 1;
    }

    public static int roll(int times, int sides, int[] keep) {
        int[] rolls = new int[times];
        while (--times >= 0) {
            rolls[times] = Globals.getRandomInt(sides);
        }
        Arrays.sort(rolls);
        int total = keep.length;
        for (int i = 0; i < keep.length; ++i) {
            total += rolls[keep[i]];
        }
        return total;
    }

    public static int roll(int times, int[] shape) {
        int total = 0;
        while (--times >= 0) {
            total += shape[Globals.getRandomInt(shape.length)];
        }
        return total;
    }

    public static int roll(int times, int[] shape, int[] keep) {
        int[] rolls = new int[times];
        while (--times >= 0) {
            rolls[times] = shape[Globals.getRandomInt(shape.length)];
        }
        Arrays.sort(rolls);
        int total = 0;
        for (int i = 0; i < keep.length; ++i) {
            total += rolls[keep[i]];
        }
        return total;
    }

    static int roll(String method) {
        int r = 0;
        if (method.length() <= 0) {
            return r;
        }
        DiceExpression parser = new DiceExpression(method);
        try {
            r = parser.rollDice();
            if (r == Integer.MIN_VALUE) {
                r = 0;
            }
        }
        catch (ParseException ex) {
            Logging.errorPrint("Bad dice: " + method + ": " + ex);
        }
        return r;
    }

    private static int roll(int times, int sides, int modifier, int keepCount, int reroll) {
        int[] dieRoll = new int[times];
        for (int i = 0; i < times; ++i) {
            dieRoll[i] = RollingMethods.rollAbove(sides, reroll);
        }
        if (Logging.isDebugMode()) {
            StringBuffer rollString = new StringBuffer(times << 2);
            for (int i = 0; i < times; ++i) {
                if (rollString.length() != 0) {
                    rollString.append(" + ");
                }
                rollString.append(dieRoll[i]);
            }
        }
        if (keepCount > times) {
            keepCount = times;
        }
        int total = 0;
        for (int j = 0; j < keepCount; ++j) {
            int highIdx = 0;
            for (int i = 1; i < times; ++i) {
                if (dieRoll[i] <= dieRoll[highIdx]) continue;
                highIdx = i;
            }
            total += dieRoll[highIdx];
            dieRoll[highIdx] = 0;
        }
        return total + modifier;
    }

    private static int rollAbove(int sides, int reroll) {
        int roll = RollingMethods.roll(sides - reroll) + reroll;
        return roll;
    }
}

