/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import pcgen.core.Constants;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.PointBuyMethod;
import pcgen.core.SystemCollections;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.SortedProperties;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.Filterable;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.util.ComparableComparator;
import pcgen.util.Logging;

public final class SettingsHandler {
    private static int allStatsValue = 10;
    private static boolean abilitiesShownAsTab = false;
    private static boolean autoFeatsRefundable = false;
    private static boolean useFeatBenefits = true;
    private static boolean autogenExoticMaterial = false;
    private static boolean autogenMagic = false;
    private static boolean autogenMasterwork = false;
    private static boolean autogenRacial = false;
    private static boolean validateBonuses = false;
    private static int maxPotionSpellLevel = 3;
    private static int maxWandSpellLevel = 4;
    private static boolean allowMetamagicInCustomizer = false;
    private static boolean spellMarketPriceAdjusted = false;
    private static Map ruleCheckMap = new HashMap();
    private static String browserPath = null;
    private static int chaTabPlacement = 1;
    private static Dimension customizerDimension = null;
    private static Point customizerLeftUpperCorner = null;
    private static int customizerSplit1 = -1;
    private static int customizerSplit2 = -1;
    private static String dmNotes = "";
    private static int excSkillCost = 0;
    private static int featAutoColor = 0xB2B200;
    private static int featVirtualColor = 0xFF00FF;
    private static final Properties filterSettings = new Properties();
    private static GameMode game = null;
    private static boolean grimHPMode = false;
    private static boolean grittyACMode = false;
    private static boolean useWaitCursor = true;
    private static boolean showD20InfoAtStart = true;
    private static boolean loadURLs = false;
    private static boolean showOGLOnLoad = true;
    private static boolean hpMaxAtFirstLevel = true;
    private static int hpRollMethod = 0;
    private static int hpPct = 100;
    private static boolean ignoreMonsterHDCap = false;
    private static int includeSkills = 3;
    private static int skillsTab_IncludeSkills = 1;
    private static int intCrossClassSkillCost = 2;
    private static String invalidDmgText;
    private static String invalidToHitText;
    private static boolean gearTab_IgnoreCost;
    private static boolean gearTab_AllowDebt;
    private static int gearTab_SellRate;
    private static int gearTab_BuyRate;
    private static boolean isROG;
    private static Point leftUpperCorner;
    private static int windowState;
    private static boolean loadCampaignsAtStart;
    private static boolean loadCampaignsWithPC;
    private static int looknFeel;
    private static boolean expertGUI;
    private static boolean optionAllowedInSources;
    private static final SortedProperties options;
    private static final Properties filepaths;
    private static final String fileLocation;
    private static File pcgenFilesDir;
    private static File pccFilesLocation;
    private static File pcgPath;
    private static File portraitsPath;
    private static File pcgenCustomDir;
    private static File pcgenVendorDataDir;
    private static File pcgenDocsDir;
    private static File pcgenSystemDir;
    private static File pcgenThemePackDir;
    private static File pcgenOutputSheetDir;
    private static File gmgenPluginDir;
    private static int prereqQualifyColor;
    private static int prereqFailColor;
    private static boolean previewTabShown;
    private static String purchaseMethodName;
    private static int[] abilityScoreCost;
    private static SortedMap pointBuyStatCosts;
    private static List pointBuyMethods;
    private static boolean ranStartingWizard;
    private static int rollMethod;
    private static String rollMethodExpression;
    private static final String[] rollMethodExpressions;
    private static boolean saveCustomInLst;
    private static String selectedCharacterHTMLOutputSheet;
    private static String selectedCharacterPDFOutputSheet;
    private static boolean saveOutputSheetWithPC;
    private static boolean printSpellsWithPC;
    private static String selectedPartyHTMLOutputSheet;
    private static String selectedPartyPDFOutputSheet;
    private static String selectedEqSetTemplate;
    private static String selectedSpellSheet;
    private static boolean showFeatDialogAtLevelUp;
    private static boolean showHPDialogAtLevelUp;
    private static boolean showStatDialogAtLevelUp;
    private static boolean showToolBar;
    private static boolean showWarningAtFirstLevelUp;
    private static String skinLFThemePack;
    private static boolean summaryTabShown;
    private static int classTab_AvailableListMode;
    private static int classTab_SelectedListMode;
    private static int equipTab_AvailableListMode;
    private static int equipTab_SelectedListMode;
    private static int featTab_AvailableListMode;
    private static int featTab_SelectedListMode;
    private static int gearTab_AvailableListMode;
    private static int gearTab_SelectedListMode;
    private static int raceTab_ListMode;
    private static int skillsTab_AvailableListMode;
    private static int skillsTab_SelectedListMode;
    private static int spellsTab_AvailableListMode;
    private static int spellsTab_SelectedListMode;
    private static int cleanupTempFiles;
    private static int tabPlacement;
    private static final String tmpPath;
    private static final File tempPath;
    private static boolean toolTipTextShown;
    private static boolean useMonsterDefault;
    private static boolean wantToLoadMasterworkAndMagic;
    private static int nameDisplayStyle;
    private static boolean weaponProfPrintout;
    private static String postExportCommand;
    private static boolean hideMonsterClasses;
    private static boolean guiUsesOutputName;
    private static int singleChoicePreference;
    private static int lastTipShown;
    private static boolean showTipOfTheDay;
    private static boolean isGMGen;
    private static boolean showNatWeaponTab;

    public static void setAbilitiesShownAsATab(boolean showAbilitiesAsTab) {
        abilitiesShownAsTab = showAbilitiesAsTab;
    }

    public static boolean isAbilitiesShownAsATab() {
        return abilitiesShownAsTab;
    }

    public static int[] getAbilityScoreCost() {
        if (!SettingsHandler.isPurchaseStatModeAllowed()) {
            return null;
        }
        if (abilityScoreCost != null) {
            return abilityScoreCost;
        }
        abilityScoreCost = new int[SettingsHandler.getPurchaseScoreMax() - SettingsHandler.getPurchaseScoreMin() + 1];
        int i = 0;
        int lastStat = Integer.MIN_VALUE;
        int lastCost = 0;
        Iterator e = pointBuyStatCosts.keySet().iterator();
        while (e.hasNext()) {
            Integer statValue = (Integer)e.next();
            if (lastStat != Integer.MIN_VALUE && lastStat + 1 != statValue) {
                for (int x = lastStat + 1; x < statValue; ++x) {
                    SettingsHandler.abilityScoreCost[i++] = lastCost;
                }
            }
            Integer statCost = (Integer)pointBuyStatCosts.get(statValue);
            lastStat = statValue;
            lastCost = statCost;
            SettingsHandler.abilityScoreCost[i++] = lastCost;
        }
        return abilityScoreCost;
    }

    public static int getAbilityScoreCost(int abilityScoreIndex) {
        int[] asc = SettingsHandler.getAbilityScoreCost();
        if (asc == null) {
            return 0;
        }
        return asc[abilityScoreIndex];
    }

    public static void setAllStatsValue(int argAllStatsValue) {
        allStatsValue = argAllStatsValue;
    }

    public static int getAllStatsValue() {
        return allStatsValue;
    }

    public static void setAutogen(int idx, boolean bFlag) {
        switch (idx) {
            case 1: {
                SettingsHandler.setAutogenRacial(bFlag);
                break;
            }
            case 2: {
                SettingsHandler.setAutogenMasterwork(bFlag);
                break;
            }
            case 3: {
                SettingsHandler.setAutogenMagic(bFlag);
                break;
            }
            case 4: {
                SettingsHandler.setAutogenExoticMaterial(bFlag);
                break;
            }
        }
    }

    public static boolean getAutogen(int idx) {
        if (!SettingsHandler.wantToLoadMasterworkAndMagic()) {
            switch (idx) {
                case 1: {
                    return SettingsHandler.isAutogenRacial();
                }
                case 2: {
                    return SettingsHandler.isAutogenMasterwork();
                }
                case 3: {
                    return SettingsHandler.isAutogenMagic();
                }
                case 4: {
                    return SettingsHandler.isAutogenExoticMaterial();
                }
            }
        }
        return false;
    }

    public static void setBrowserPath(String path) {
        browserPath = path;
    }

    public static String getBrowserPath() {
        return browserPath;
    }

    public static void setChaTabPlacement(int argChaTabPlacement) {
        chaTabPlacement = argChaTabPlacement;
    }

    public static int getChaTabPlacement() {
        return chaTabPlacement;
    }

    public static void setClassTab_AvailableListMode(int listMode) {
        classTab_AvailableListMode = listMode;
    }

    public static int getClassTab_AvailableListMode() {
        return classTab_AvailableListMode;
    }

    public static void setClassTab_SelectedListMode(int listMode) {
        classTab_SelectedListMode = listMode;
    }

    public static int getClassTab_SelectedListMode() {
        return classTab_SelectedListMode;
    }

    public static void setCleanupTempFiles(int argDoCleanup) {
        cleanupTempFiles = argDoCleanup;
    }

    public static int getCleanupTempFiles() {
        return cleanupTempFiles;
    }

    public static void setCustomizerDimension(Dimension d) {
        customizerDimension = d;
    }

    public static Dimension getCustomizerDimension() {
        return customizerDimension;
    }

    public static void setCustomizerLeftUpperCorner(Point argLeftUpperCorner) {
        customizerLeftUpperCorner = argLeftUpperCorner;
    }

    public static Point getCustomizerLeftUpperCorner() {
        return customizerLeftUpperCorner;
    }

    public static void setCustomizerSplit1(int split) {
        customizerSplit1 = split;
    }

    public static int getCustomizerSplit1() {
        return customizerSplit1;
    }

    public static void setCustomizerSplit2(int split) {
        customizerSplit2 = split;
    }

    public static int getCustomizerSplit2() {
        return customizerSplit2;
    }

    public static void setDmNotes(String argDmNotes) {
        dmNotes = argDmNotes;
    }

    public static String getDmNotes() {
        return dmNotes;
    }

    public static void setEquipTab_AvailableListMode(int listMode) {
        equipTab_AvailableListMode = listMode;
    }

    public static int getEquipTab_AvailableListMode() {
        return equipTab_AvailableListMode;
    }

    public static void setEquipTab_SelectedListMode(int listMode) {
        equipTab_SelectedListMode = listMode;
    }

    public static int getEquipTab_SelectedListMode() {
        return equipTab_SelectedListMode;
    }

    public static void setExcSkillCost(int argExcSkillCost) {
        excSkillCost = argExcSkillCost;
    }

    public static int getExcSkillCost() {
        return excSkillCost;
    }

    public static void setExpertGUI(boolean argExpertGUI) {
        expertGUI = argExpertGUI;
    }

    public static boolean isExpertGUI() {
        return expertGUI;
    }

    public static void setFeatAutoColor(int newColor) {
        featAutoColor = newColor & 0xFFFFFF;
    }

    public static int getFeatAutoColor() {
        return featAutoColor;
    }

    public static void setFeatTab_AvailableListMode(int listMode) {
        featTab_AvailableListMode = listMode;
    }

    public static int getFeatTab_AvailableListMode() {
        return featTab_AvailableListMode;
    }

    public static void setFeatTab_SelectedListMode(int listMode) {
        featTab_SelectedListMode = listMode;
    }

    public static int getFeatTab_SelectedListMode() {
        return featTab_SelectedListMode;
    }

    public static void setFeatVirtualColor(int newColor) {
        featVirtualColor = newColor & 0xFFFFFF;
    }

    public static int getFeatVirtualColor() {
        return featVirtualColor;
    }

    public static void setFilePaths(String aString) {
        SettingsHandler.getFilepathProp().setProperty("pcgen.filepaths", aString);
    }

    public static String getFilePaths() {
        return SettingsHandler.getFilepathProp().getProperty("pcgen.filepaths", "pcgen");
    }

    public static Properties getFilepathProp() {
        return filepaths;
    }

    public static boolean getFirstRun() {
        File aFile = new File(fileLocation);
        return !aFile.exists();
    }

    public static boolean isGMGen() {
        return isGMGen;
    }

    public static void setGMGenOption(String optionName, boolean optionValue) {
        SettingsHandler.setGMGenOption(optionName, optionValue ? "true" : "false");
    }

    public static void setGMGenOption(String optionName, int optionValue) {
        SettingsHandler.setGMGenOption(optionName, String.valueOf(optionValue));
    }

    public static void setGMGenOption(String optionName, double optionValue) {
        SettingsHandler.setGMGenOption(optionName, String.valueOf(optionValue));
    }

    public static void setGMGenOption(String optionName, String optionValue) {
        SettingsHandler.getOptions().setProperty("gmgen.options." + optionName, optionValue);
    }

    public static boolean getGMGenOption(String optionName, boolean defaultValue) {
        String option = SettingsHandler.getGMGenOption(optionName, defaultValue ? "true" : "false");
        return "true".equalsIgnoreCase(option);
    }

    public static int getGMGenOption(String optionName, int defaultValue) {
        return Integer.decode(SettingsHandler.getGMGenOption(optionName, String.valueOf(defaultValue)));
    }

    public static Double getGMGenOption(String optionName, double defaultValue) {
        return new Double(SettingsHandler.getGMGenOption(optionName, Double.toString(defaultValue)));
    }

    public static String getGMGenOption(String optionName, String defaultValue) {
        return SettingsHandler.getOptions().getProperty("gmgen.options." + optionName, defaultValue);
    }

    public static void setGUIUsesOutputName(boolean argUseOutputName) {
        guiUsesOutputName = argUseOutputName;
    }

    public static void setGame(String g) {
        GameMode newMode = SystemCollections.getGameModeNamed(g);
        if (newMode != null) {
            game = newMode;
        }
    }

    public static GameMode getGame() {
        return game;
    }

    public static void setGearTab_AllowDebt(boolean allowDebt) {
        gearTab_AllowDebt = allowDebt;
    }

    public static boolean getGearTab_AllowDebt() {
        return gearTab_AllowDebt;
    }

    public static void setGearTab_AvailableListMode(int listMode) {
        gearTab_AvailableListMode = listMode;
    }

    public static int getGearTab_AvailableListMode() {
        return gearTab_AvailableListMode;
    }

    public static void setGearTab_BuyRate(int argBuyRate) {
        gearTab_BuyRate = argBuyRate;
    }

    public static int getGearTab_BuyRate() {
        return gearTab_BuyRate;
    }

    public static void setGearTab_IgnoreCost(boolean ignoreCost) {
        gearTab_IgnoreCost = ignoreCost;
    }

    public static boolean getGearTab_IgnoreCost() {
        return gearTab_IgnoreCost;
    }

    public static void setGearTab_SelectedListMode(int listMode) {
        gearTab_SelectedListMode = listMode;
    }

    public static int getGearTab_SelectedListMode() {
        return gearTab_SelectedListMode;
    }

    public static void setGearTab_SellRate(int argSellRate) {
        gearTab_SellRate = argSellRate;
    }

    public static int getGearTab_SellRate() {
        return gearTab_SellRate;
    }

    public static void setGmgenPluginDir(File aFile) {
        gmgenPluginDir = aFile;
    }

    public static File getGmgenPluginDir() {
        return gmgenPluginDir;
    }

    public static void setHPMaxAtFirstLevel(boolean aBool) {
        hpMaxAtFirstLevel = aBool;
    }

    public static boolean isHPMaxAtFirstLevel() {
        return hpMaxAtFirstLevel;
    }

    public static void setHPPct(int argHPPct) {
        hpPct = argHPPct;
    }

    public static int getHPPct() {
        return hpPct;
    }

    public static void setHPRollMethod(int aBool) {
        hpRollMethod = aBool;
    }

    public static int getHPRollMethod() {
        return hpRollMethod;
    }

    public static String getHTMLOutputSheetPath() {
        if ("".equals(selectedCharacterHTMLOutputSheet)) {
            return SettingsHandler.getPcgenOutputSheetDir().toString();
        }
        return new File(selectedCharacterHTMLOutputSheet).getParentFile().getAbsolutePath();
    }

    public static void setHideMonsterClasses(boolean argHideMonsterClasses) {
        hideMonsterClasses = argHideMonsterClasses;
    }

    public static void setIgnoreMonsterHDCap(boolean argIgoreCap) {
        ignoreMonsterHDCap = argIgoreCap;
    }

    public static boolean isIgnoreMonsterHDCap() {
        return ignoreMonsterHDCap;
    }

    public static void setIncludeSkills(int anInt) {
        includeSkills = anInt;
    }

    public static int getIncludeSkills() {
        return includeSkills;
    }

    public static void setIntCrossClassSkillCost(int anInt) {
        intCrossClassSkillCost = anInt;
    }

    public static int getIntCrossClassSkillCost() {
        return intCrossClassSkillCost;
    }

    public static final void setInvalidDmgText(String string) {
        invalidDmgText = string;
    }

    public static String getInvalidDmgText() {
        return invalidDmgText;
    }

    public static final void setInvalidToHitText(String string) {
        invalidToHitText = string;
    }

    public static String getInvalidToHitText() {
        return invalidToHitText;
    }

    public static void setIsGMGen(boolean GMGen) {
        isGMGen = GMGen;
    }

    public static void setLastTipShown(int argLastTipShown) {
        lastTipShown = argLastTipShown;
    }

    public static int getLastTipShown() {
        return lastTipShown;
    }

    public static void setLeftUpperCorner(Point argLeftUpperCorner) {
        leftUpperCorner = argLeftUpperCorner;
    }

    public static Point getLeftUpperCorner() {
        return leftUpperCorner;
    }

    public static void setLoadCampaignsAtStart(boolean aBool) {
        loadCampaignsAtStart = aBool;
    }

    public static boolean isLoadCampaignsAtStart() {
        return loadCampaignsAtStart;
    }

    public static void setLoadCampaignsWithPC(boolean aBool) {
        loadCampaignsWithPC = aBool;
    }

    public static boolean isLoadCampaignsWithPC() {
        return loadCampaignsWithPC;
    }

    public static void setLoadURLs(boolean aBool) {
        loadURLs = aBool;
    }

    public static boolean isLoadURLs() {
        return loadURLs;
    }

    public static void setLookAndFeel(int argLookAndFeel) {
        looknFeel = argLookAndFeel;
    }

    public static int getLookAndFeel() {
        return looknFeel;
    }

    public static void setMaxPotionSpellLevel(int anInt) {
        maxPotionSpellLevel = anInt;
    }

    public static int getMaxPotionSpellLevel() {
        return maxPotionSpellLevel;
    }

    public static void setMaxWandSpellLevel(int anInt) {
        maxWandSpellLevel = anInt;
    }

    public static int getMaxWandSpellLevel() {
        return maxWandSpellLevel;
    }

    public static void setMetamagicAllowedInEqBuilder(boolean aBool) {
        allowMetamagicInCustomizer = aBool;
    }

    public static boolean isMetamagicAllowedInEqBuilder() {
        return allowMetamagicInCustomizer;
    }

    public static void setMonsterDefault(boolean aBool) {
        useMonsterDefault = aBool;
    }

    public static boolean isMonsterDefault() {
        return useMonsterDefault;
    }

    public static void setNameDisplayStyle(int style) {
        nameDisplayStyle = style;
        PCGen_Frame1 frame = PCGen_Frame1.getInst();
        if (frame != null) {
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
    }

    public static int getNameDisplayStyle() {
        return nameDisplayStyle;
    }

    public static void setOptionAllowedInSources(boolean aBool) {
        optionAllowedInSources = aBool;
    }

    public static boolean isOptionAllowedInSources() {
        return optionAllowedInSources;
    }

    public static SortedProperties getOptions() {
        return options;
    }

    public static Dimension getOptionsFromProperties(PlayerCharacter aPC) {
        Dimension d = new Dimension(0, 0);
        String tempBrowserPath = SettingsHandler.getPCGenOption("browserPath", "");
        if (!"".equals(tempBrowserPath)) {
            SettingsHandler.setBrowserPath(tempBrowserPath);
        } else {
            SettingsHandler.setBrowserPath(null);
        }
        PersistenceManager.getInstance().setChosenCampaignSourcefiles(CoreUtility.split(SettingsHandler.getOptions().getProperty("pcgen.files.chosenCampaignSourcefiles", ""), ','));
        purchaseMethodName = SettingsHandler.getPCGenOption("purchaseMethodName", "");
        SettingsHandler.setLeftUpperCorner(new Point(SettingsHandler.getPCGenOption("windowLeftUpperCorner.X", -1.0).intValue(), SettingsHandler.getPCGenOption("windowLeftUpperCorner.Y", -1.0).intValue()));
        SettingsHandler.setWindowState(SettingsHandler.getPCGenOption("windowState", 0));
        Double dw = SettingsHandler.getPCGenOption("windowWidth", 0.0);
        Double dh = SettingsHandler.getPCGenOption("windowHeight", 0.0);
        if (!CoreUtility.doublesEqual(dw, 0.0) && !CoreUtility.doublesEqual(dh, 0.0)) {
            int width = Integer.parseInt(dw.toString().substring(0, Math.min(dw.toString().length(), dw.toString().lastIndexOf("."))));
            int height = Integer.parseInt(dh.toString().substring(0, Math.min(dh.toString().length(), dh.toString().lastIndexOf("."))));
            d = new Dimension(width, height);
        }
        SettingsHandler.setCustomizerLeftUpperCorner(new Point(SettingsHandler.getPCGenOption("customizer.windowLeftUpperCorner.X", -1.0).intValue(), SettingsHandler.getPCGenOption("customizer.windowLeftUpperCorner.Y", -1.0).intValue()));
        dw = SettingsHandler.getPCGenOption("customizer.windowWidth", 0.0);
        dh = SettingsHandler.getPCGenOption("customizer.windowHeight", 0.0);
        if (!CoreUtility.doublesEqual(dw, 0.0) && !CoreUtility.doublesEqual(dh, 0.0)) {
            SettingsHandler.setCustomizerDimension(new Dimension(dw.intValue(), dh.intValue()));
        }
        int buyRate = SettingsHandler.getPCGenOption("GearTab.buyRate", -1);
        int sellRate = SettingsHandler.getPCGenOption("GearTab.sellRate", -1);
        if (buyRate < 0 || sellRate < 0) {
            if (SettingsHandler.getPCGenOption("GearTab.ignoreCost", false)) {
                buyRate = 0;
                sellRate = 0;
            } else {
                buyRate = 100;
                sellRate = 50;
            }
        }
        Globals.initCustColumnWidth(CoreUtility.split(SettingsHandler.getOptions().getProperty("pcgen.options.custColumnWidth", ""), ','));
        showD20InfoAtStart = SettingsHandler.getPCGenOption("showD20InfoAtStart", true);
        loadURLs = SettingsHandler.getPCGenOption("loadURLs", false);
        showOGLOnLoad = SettingsHandler.getPCGenOption("showOGLOnLoad", true);
        Globals.setSourceDisplay(SettingsHandler.getPCGenOption("sourceDisplay", 0));
        Globals.setLanguage(SettingsHandler.getPCGenOption("language", "en"));
        Globals.setCountry(SettingsHandler.getPCGenOption("country", "US"));
        SettingsHandler.setAbilitiesShownAsATab(SettingsHandler.getPCGenOption("abilitiesShownAsTab", false));
        SettingsHandler.setAllStatsValue(SettingsHandler.getPCGenOption("allStatsValue", 10));
        SettingsHandler.setAutoFeatsRefundable(SettingsHandler.getPCGenOption("autoFeatsRefundable", false));
        SettingsHandler.setUseFeatBenefits(SettingsHandler.getPCGenOption("useFeatBenefits", true));
        SettingsHandler.setAutogenExoticMaterial(SettingsHandler.getPCGenOption("autoGenerateExoticMaterial", false));
        SettingsHandler.setAutogenMagic(SettingsHandler.getPCGenOption("autoGenerateMagic", false));
        SettingsHandler.setAutogenMasterwork(SettingsHandler.getPCGenOption("autoGenerateMasterwork", false));
        SettingsHandler.setAutogenRacial(SettingsHandler.getPCGenOption("autoGenerateRacial", false));
        SettingsHandler.setChaTabPlacement(SettingsHandler.getOptionTabPlacement("chaTabPlacement", 1));
        SettingsHandler.setClassTab_AvailableListMode(SettingsHandler.getPCGenOption("ClassTab.availableListMode", 0));
        SettingsHandler.setClassTab_SelectedListMode(SettingsHandler.getPCGenOption("ClassTab.selectedListMode", 0));
        SettingsHandler.setCleanupTempFiles(SettingsHandler.getPCGenOption("cleanupTempFiles", 0));
        SettingsHandler.setCustomizerSplit1(SettingsHandler.getPCGenOption("customizer.split1", -1));
        SettingsHandler.setCustomizerSplit2(SettingsHandler.getPCGenOption("customizer.split2", -1));
        SettingsHandler.setDmNotes(SettingsHandler.getPCGenOption("dmnotes", ""));
        SettingsHandler.setEquipTab_AvailableListMode(SettingsHandler.getPCGenOption("EquipTab.availableListMode", 3));
        SettingsHandler.setEquipTab_SelectedListMode(SettingsHandler.getPCGenOption("EquipTab.selectedListMode", 0));
        SettingsHandler.setExcSkillCost(SettingsHandler.getPCGenOption("excSkillCost", 0));
        SettingsHandler.setExpertGUI(SettingsHandler.getPCGenOption("expertGUI", false));
        SettingsHandler.setFeatAutoColor(SettingsHandler.getPCGenOption("featAutoColor", Color.yellow.darker().getRGB()));
        SettingsHandler.setFeatTab_AvailableListMode(SettingsHandler.getPCGenOption("FeatTab.availableListMode", 0));
        SettingsHandler.setFeatTab_SelectedListMode(SettingsHandler.getPCGenOption("FeatTab.selectedListMode", 1));
        SettingsHandler.setFeatVirtualColor(SettingsHandler.getPCGenOption("featVirtualColor", Color.magenta.getRGB()));
        SettingsHandler.setGearTab_AllowDebt(SettingsHandler.getPCGenOption("GearTab.allowDebt", false));
        SettingsHandler.setGearTab_AvailableListMode(SettingsHandler.getPCGenOption("GearTab.availableListMode", 0));
        SettingsHandler.setGearTab_BuyRate(buyRate);
        SettingsHandler.setGearTab_IgnoreCost(SettingsHandler.getPCGenOption("GearTab.ignoreCost", false));
        SettingsHandler.setGearTab_SelectedListMode(SettingsHandler.getPCGenOption("GearTab.selectedListMode", 2));
        SettingsHandler.setGearTab_SellRate(sellRate);
        SettingsHandler.setGrimHPMode(SettingsHandler.getPCGenOption("grimHPMode", false));
        SettingsHandler.setGrittyACMode(SettingsHandler.getPCGenOption("grittyACMode", false));
        SettingsHandler.setGUIUsesOutputName(SettingsHandler.getPCGenOption("GUIUsesOutputName", false));
        SettingsHandler.setHideMonsterClasses(SettingsHandler.getPCGenOption("hideMonsterClasses", false));
        SettingsHandler.setHPMaxAtFirstLevel(SettingsHandler.getPCGenOption("hpMaxAtFirstLevel", true));
        SettingsHandler.setHPPct(SettingsHandler.getPCGenOption("hpPct", 100));
        SettingsHandler.setHPRollMethod(SettingsHandler.getPCGenOption("hpRollMethod", 0));
        SettingsHandler.setIgnoreMonsterHDCap(SettingsHandler.getPCGenOption("ignoreMonsterHDCap", false));
        SettingsHandler.setIncludeSkills(SettingsHandler.getPCGenOption("includeSkills", 3));
        SettingsHandler.setSkillsTab_IncludeSkills(SettingsHandler.getPCGenOption("skillsTab_IncludeSkills", 1));
        SettingsHandler.setIntCrossClassSkillCost(SettingsHandler.getPCGenOption("intCrossClassSkillCost", 2));
        SettingsHandler.setInvalidDmgText(SettingsHandler.getPCGenOption("invalidDmgText", "N/A"));
        SettingsHandler.setInvalidToHitText(SettingsHandler.getPCGenOption("invalidToHitText", "N/A"));
        SettingsHandler.setLastTipShown(SettingsHandler.getPCGenOption("lastTipOfTheDayTipShown", -1));
        SettingsHandler.setLoadCampaignsAtStart(SettingsHandler.getPCGenOption("loadCampaignsAtStart", false));
        SettingsHandler.setLoadCampaignsWithPC(SettingsHandler.getPCGenOption("loadCampaignsWithPC", true));
        SettingsHandler.setLookAndFeel(SettingsHandler.getPCGenOption("looknFeel", 0));
        SettingsHandler.setMaxPotionSpellLevel(SettingsHandler.getPCGenOption("maxPotionSpellLevel", 3));
        SettingsHandler.setMaxWandSpellLevel(SettingsHandler.getPCGenOption("maxWandSpellLevel", 4));
        SettingsHandler.setMetamagicAllowedInEqBuilder(SettingsHandler.getPCGenOption("allowMetamagicInCustomizer", false));
        SettingsHandler.setMonsterDefault(SettingsHandler.getPCGenOption("useMonsterDefault", false));
        SettingsHandler.setOptionAllowedInSources(SettingsHandler.getPCGenOption("optionAllowedInSources", true));
        SettingsHandler.setPccFilesLocation(new File(SettingsHandler.expandRelativePath(SettingsHandler.getPCGenOption("pccFilesLocation", System.getProperty("user.dir") + File.separator + "data"))));
        SettingsHandler.setPcgenCustomDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenCustomDir", System.getProperty("user.dir") + File.separator + "data" + File.separator + "customsources"))));
        SettingsHandler.setPcgenVendorDataDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenVendorDataDir", System.getProperty("user.dir") + File.separator + "vendordata"))));
        SettingsHandler.setPcgenDocsDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenDocsDir", System.getProperty("user.dir") + File.separator + "docs"))));
        SettingsHandler.setPcgenSystemDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenSystemDir", System.getProperty("user.dir") + File.separator + "system"))));
        SettingsHandler.setPcgenThemePackDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenThemePackDir", System.getProperty("user.dir") + File.separator + "lib" + File.separator + "themes"))));
        SettingsHandler.setPcgenOutputSheetDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenOutputSheetDir", System.getProperty("user.dir") + File.separator + "outputsheets"))));
        SettingsHandler.setGmgenPluginDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("gmgen.files.gmgenPluginDir", System.getProperty("user.dir") + File.separator + "plugins"))));
        SettingsHandler.setPcgPath(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.characters", Globals.getDefaultPcgPath()))));
        SettingsHandler.setPortraitsPath(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.portraits", Globals.getDefaultPath()))));
        SettingsHandler.setPostExportCommand(SettingsHandler.getPCGenOption("postExportCommand", ""));
        SettingsHandler.setPrereqFailColor(SettingsHandler.getPCGenOption("prereqFailColor", Color.red.getRGB()));
        SettingsHandler.setPrereqQualifyColor(SettingsHandler.getPCGenOption("prereqQualifyColor", Color.black.getRGB()));
        SettingsHandler.setPreviewTabShown(SettingsHandler.getPCGenOption("previewTabShown", true));
        SettingsHandler.setRaceTab_ListMode(SettingsHandler.getPCGenOption("RaceTab.ListMode", 0));
        SettingsHandler.setRanStartingWizard(SettingsHandler.getPCGenOption("ranStartingWizard", false));
        SettingsHandler.setROG(SettingsHandler.getPCGenOption("isROG", false));
        SettingsHandler.setRollMethod(SettingsHandler.getPCGenOption("rollMethod", 0));
        SettingsHandler.setRollMethodExpression(SettingsHandler.getPCGenOption("rollMethodExpression", "roll(4,6,[2,3,4])"));
        SettingsHandler.setSaveCustomInLst(SettingsHandler.getPCGenOption("saveCustomInLst", false));
        SettingsHandler.setSaveOutputSheetWithPC(SettingsHandler.getPCGenOption("saveOutputSheetWithPC", false));
        SettingsHandler.setPrintSpellsWithPC(SettingsHandler.getPCGenOption("printSpellsWithPC", true));
        SettingsHandler.setSelectedSpellSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedSpellOutputSheet", "")));
        SettingsHandler.setSelectedCharacterHTMLOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedCharacterHTMLOutputSheet", "")), aPC);
        SettingsHandler.setSelectedCharacterPDFOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedCharacterPDFOutputSheet", "")), aPC);
        SettingsHandler.setSelectedEqSetTemplate(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedEqSetTemplate", "")));
        SettingsHandler.setSelectedPartyHTMLOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedPartyHTMLOutputSheet", "")));
        SettingsHandler.setSelectedPartyPDFOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedPartyPDFOutputSheet", "")));
        SettingsHandler.setShowFeatDialogAtLevelUp(SettingsHandler.getPCGenOption("showFeatDialogAtLevelUp", true));
        SettingsHandler.setShowHPDialogAtLevelUp(SettingsHandler.getPCGenOption("showHPDialogAtLevelUp", true));
        SettingsHandler.setShowStatDialogAtLevelUp(SettingsHandler.getPCGenOption("showStatDialogAtLevelUp", true));
        SettingsHandler.setShowTipOfTheDay(SettingsHandler.getPCGenOption("showTipOfTheDay", true));
        SettingsHandler.setShowToolBar(SettingsHandler.getPCGenOption("showToolBar", true));
        SettingsHandler.setShowWarningAtFirstLevelUp(SettingsHandler.getPCGenOption("showWarningAtFirstLevelUp", true));
        SettingsHandler.setSingleChoicePreference(SettingsHandler.getPCGenOption("ChooserSingleChoiceMethod", 0));
        SettingsHandler.setSkillsTab_AvailableListMode(SettingsHandler.getPCGenOption("SkillsTab.availableListMode", 2));
        SettingsHandler.setSkillsTab_SelectedListMode(SettingsHandler.getPCGenOption("SkillsTab.selectedListMode", 5));
        SettingsHandler.setSkinLFThemePack(SettingsHandler.getPCGenOption("skinLFThemePack", ""));
        SettingsHandler.setSpellMarketPriceAdjusted(SettingsHandler.getPCGenOption("spellMarketPriceAdjusted", false));
        SettingsHandler.setSpellsTab_AvailableListMode(SettingsHandler.getPCGenOption("SpellsTab.availableListMode", 0));
        SettingsHandler.setSpellsTab_SelectedListMode(SettingsHandler.getPCGenOption("SpellsTab.selectedListMode", 0));
        SettingsHandler.setSummaryTabShown(SettingsHandler.getPCGenOption("summaryTabShown", true));
        SettingsHandler.setTabPlacement(SettingsHandler.getOptionTabPlacement("tabPlacement", 3));
        SettingsHandler.setToolTipTextShown(SettingsHandler.getPCGenOption("toolTipTextShown", true));
        SettingsHandler.setUseWaitCursor(SettingsHandler.getPCGenOption("useWaitCursor", true));
        SettingsHandler.setWantToLoadMasterworkAndMagic(SettingsHandler.getPCGenOption("loadMasterworkAndMagicFromLst", false));
        SettingsHandler.setWeaponProfPrintout(SettingsHandler.getPCGenOption("weaponProfPrintout", true));
        SettingsHandler.parseRuleChecksFromOptions(SettingsHandler.getPCGenOption("ruleChecks", ""));
        try {
            PersistenceManager.getInstance().initialize();
        }
        catch (PersistenceLayerException e) {
            ShowMessageDelegate.showMessageDialog(e.getMessage(), "PCGen", MessageType.INFORMATION);
        }
        SettingsHandler.setGame(SettingsHandler.getPCGenOption("game", "3e"));
        Globals.loadAttributeNames();
        showNatWeaponTab = SettingsHandler.getPCGenOption("showNatWeaponTab", false);
        validateBonuses = SettingsHandler.getPCGenOption("validateBonuses", false);
        return d;
    }

    public static void setOptionsProperties(PlayerCharacter aPC) {
        String unitSetName;
        String paperName;
        if (SettingsHandler.getPcgPath() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.characters", SettingsHandler.retractRelativePath(SettingsHandler.getPcgPath().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.characters", SettingsHandler.retractRelativePath(Globals.getDefaultPath()));
        }
        SettingsHandler.getOptions().setProperty("pcgen.files.portraits", SettingsHandler.retractRelativePath(SettingsHandler.getPortraitsPath().getAbsolutePath()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedSpellOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedSpellSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedCharacterHTMLOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedCharacterHTMLOutputSheet(aPC)));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedCharacterPDFOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedCharacterPDFOutputSheet(aPC)));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedPartyHTMLOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedPartyHTMLOutputSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedPartyPDFOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedPartyPDFOutputSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedEqSetTemplate", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedEqSetTemplate()));
        SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles", CoreUtility.join((Collection)PersistenceManager.getInstance().getChosenCampaignSourcefiles(), ','));
        SettingsHandler.getOptions().setProperty("pcgen.options.custColumnWidth", CoreUtility.join((Collection)Globals.getCustColumnWidth(), ','));
        if (SettingsHandler.getPcgenCustomDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenCustomDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenCustomDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenCustomDir", "");
        }
        if (SettingsHandler.getPcgenVendorDataDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenVendorDataDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenVendorDataDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenVendorDataDir", "");
        }
        if (SettingsHandler.getPcgenDocsDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenDocsDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenDocsDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenDocsDir", "");
        }
        if (SettingsHandler.getPcgenSystemDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenSystemDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenSystemDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenSystemDir", "");
        }
        if (SettingsHandler.getPcgenOutputSheetDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenOutputSheetDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenOutputSheetDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenOutputSheetDir", "");
        }
        if (SettingsHandler.getGmgenPluginDir() != null) {
            SettingsHandler.getOptions().setProperty("gmgen.files.gmgenPluginDir", SettingsHandler.retractRelativePath(SettingsHandler.getGmgenPluginDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("gmgen.files.gmgenPluginDir", "");
        }
        if (SettingsHandler.getPcgenThemePackDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenThemePackDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenThemePackDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenThemePackDir", "");
        }
        if (SettingsHandler.getBrowserPath() != null) {
            SettingsHandler.setPCGenOption("browserPath", SettingsHandler.getBrowserPath());
        } else {
            SettingsHandler.setPCGenOption("browserPath", "");
        }
        if (Globals.getRootFrame() != null) {
            SettingsHandler.setOpenRecentOption("openRecentPCs", PCGen_Frame1.getInst().getOpenRecentPCs());
            SettingsHandler.setOpenRecentOption("openRecentParties", PCGen_Frame1.getInst().getOpenRecentParties());
        }
        if (SettingsHandler.getGame() != null) {
            SettingsHandler.setPCGenOption("game", SettingsHandler.getGame().getName());
        } else {
            SettingsHandler.setPCGenOption("game", "");
        }
        try {
            SettingsHandler.setPCGenOption("skinLFThemePack", SettingsHandler.getSkinLFThemePack());
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (SettingsHandler.getPccFilesLocation() != null) {
            SettingsHandler.setPCGenOption("pccFilesLocation", SettingsHandler.retractRelativePath(SettingsHandler.getPccFilesLocation().getAbsolutePath()));
        } else {
            SettingsHandler.setPCGenOption("pccFilesLocation", "");
        }
        if (SettingsHandler.getLeftUpperCorner() != null) {
            SettingsHandler.setPCGenOption("windowLeftUpperCorner.X", SettingsHandler.getLeftUpperCorner().getX());
            SettingsHandler.setPCGenOption("windowLeftUpperCorner.Y", SettingsHandler.getLeftUpperCorner().getY());
        }
        SettingsHandler.setPCGenOption("windowState", SettingsHandler.getWindowState());
        if (Globals.getRootFrame() != null) {
            SettingsHandler.setPCGenOption("windowWidth", Globals.getRootFrame().getSize().getWidth());
            SettingsHandler.setPCGenOption("windowHeight", Globals.getRootFrame().getSize().getHeight());
        }
        if (SettingsHandler.getCustomizerLeftUpperCorner() != null) {
            SettingsHandler.setPCGenOption("customizer.windowLeftUpperCorner.X", SettingsHandler.getCustomizerLeftUpperCorner().getX());
            SettingsHandler.setPCGenOption("customizer.windowLeftUpperCorner.Y", SettingsHandler.getCustomizerLeftUpperCorner().getY());
        }
        if (SettingsHandler.getCustomizerDimension() != null) {
            SettingsHandler.setPCGenOption("customizer.windowWidth", SettingsHandler.getCustomizerDimension().getWidth());
            SettingsHandler.setPCGenOption("customizer.windowHeight", SettingsHandler.getCustomizerDimension().getHeight());
        }
        if ((paperName = Globals.getPaperInfo(0)) != null) {
            SettingsHandler.setPCGenOption("paperName", paperName);
        }
        if ((unitSetName = Globals.getUnitSet().getName()) != null) {
            SettingsHandler.setPCGenOption("unitSetName", unitSetName);
        }
        SettingsHandler.setRuleChecksInOptions("ruleChecks");
        SettingsHandler.setPCGenOption("abilitiesShownAsTab", SettingsHandler.isAbilitiesShownAsATab());
        SettingsHandler.setPCGenOption("allowMetamagicInCustomizer", SettingsHandler.isMetamagicAllowedInEqBuilder());
        SettingsHandler.setPCGenOption("allStatsValue", SettingsHandler.getAllStatsValue());
        SettingsHandler.setPCGenOption("autoFeatsRefundable", SettingsHandler.isAutoFeatsRefundable());
        SettingsHandler.setPCGenOption("useFeatBenefits", SettingsHandler.useFeatBenefits());
        SettingsHandler.setPCGenOption("autoGenerateExoticMaterial", SettingsHandler.isAutogenExoticMaterial());
        SettingsHandler.setPCGenOption("autoGenerateMagic", SettingsHandler.isAutogenMagic());
        SettingsHandler.setPCGenOption("autoGenerateMasterwork", SettingsHandler.isAutogenMasterwork());
        SettingsHandler.setPCGenOption("autoGenerateRacial", SettingsHandler.isAutogenRacial());
        SettingsHandler.setPCGenOption("chaTabPlacement", SettingsHandler.convertTabPlacementToString(chaTabPlacement));
        SettingsHandler.setPCGenOption("ChooserSingleChoiceMethod", SettingsHandler.getSingleChoicePreference());
        SettingsHandler.setPCGenOption("ClassTab.availableListMode", SettingsHandler.getClassTab_AvailableListMode());
        SettingsHandler.setPCGenOption("ClassTab.selectedListMode", SettingsHandler.getClassTab_SelectedListMode());
        SettingsHandler.setPCGenOption("cleanupTempFiles", SettingsHandler.getCleanupTempFiles());
        SettingsHandler.setPCGenOption("country", Globals.getCountry());
        SettingsHandler.setPCGenOption("customizer.split1", SettingsHandler.getCustomizerSplit1());
        SettingsHandler.setPCGenOption("customizer.split2", SettingsHandler.getCustomizerSplit2());
        SettingsHandler.setPCGenOption("dmnotes", SettingsHandler.getDmNotes());
        SettingsHandler.setPCGenOption("EquipTab.availableListMode", SettingsHandler.getEquipTab_AvailableListMode());
        SettingsHandler.setPCGenOption("EquipTab.selectedListMode", SettingsHandler.getEquipTab_SelectedListMode());
        SettingsHandler.setPCGenOption("excSkillCost", SettingsHandler.getExcSkillCost());
        SettingsHandler.setPCGenOption("expertGUI", SettingsHandler.isExpertGUI());
        SettingsHandler.setPCGenOption("featAutoColor", "0x" + Integer.toHexString(SettingsHandler.getFeatAutoColor()));
        SettingsHandler.setPCGenOption("FeatTab.availableListMode", SettingsHandler.getFeatTab_AvailableListMode());
        SettingsHandler.setPCGenOption("FeatTab.selectedListMode", SettingsHandler.getFeatTab_SelectedListMode());
        SettingsHandler.setPCGenOption("featVirtualColor", "0x" + Integer.toHexString(SettingsHandler.getFeatVirtualColor()));
        SettingsHandler.setPCGenOption("GearTab.allowDebt", SettingsHandler.getGearTab_AllowDebt());
        SettingsHandler.setPCGenOption("GearTab.availableListMode", SettingsHandler.getGearTab_AvailableListMode());
        SettingsHandler.setPCGenOption("GearTab.buyRate", SettingsHandler.getGearTab_BuyRate());
        SettingsHandler.setPCGenOption("GearTab.ignoreCost", SettingsHandler.getGearTab_IgnoreCost());
        SettingsHandler.setPCGenOption("GearTab.selectedListMode", SettingsHandler.getGearTab_SelectedListMode());
        SettingsHandler.setPCGenOption("GearTab.sellRate", SettingsHandler.getGearTab_SellRate());
        SettingsHandler.setPCGenOption("grimHPMode", SettingsHandler.isGrimHPMode());
        SettingsHandler.setPCGenOption("grittyACMode", SettingsHandler.isGrittyACMode());
        SettingsHandler.setPCGenOption("GUIUsesOutputName", SettingsHandler.guiUsesOutputName());
        SettingsHandler.setPCGenOption("hideMonsterClasses", SettingsHandler.hideMonsterClasses());
        SettingsHandler.setPCGenOption("hpMaxAtFirstLevel", SettingsHandler.isHPMaxAtFirstLevel());
        SettingsHandler.setPCGenOption("hpPct", SettingsHandler.getHPPct());
        SettingsHandler.setPCGenOption("hpRollMethod", SettingsHandler.getHPRollMethod());
        SettingsHandler.setPCGenOption("ignoreMonsterHDCap", SettingsHandler.isIgnoreMonsterHDCap());
        SettingsHandler.setPCGenOption("includeSkills", SettingsHandler.getIncludeSkills());
        SettingsHandler.setPCGenOption("skillsTab_IncludeSkills", SettingsHandler.getSkillsTab_IncludeSkills());
        SettingsHandler.setPCGenOption("intCrossClassSkillCost", SettingsHandler.getIntCrossClassSkillCost());
        SettingsHandler.setPCGenOption("invalidDmgText", SettingsHandler.getInvalidDmgText());
        SettingsHandler.setPCGenOption("invalidToHitText", SettingsHandler.getInvalidToHitText());
        SettingsHandler.setPCGenOption("language", Globals.getLanguage());
        SettingsHandler.setPCGenOption("lastTipOfTheDayTipShown", SettingsHandler.getLastTipShown());
        SettingsHandler.setPCGenOption("loadCampaignsAtStart", SettingsHandler.isLoadCampaignsAtStart());
        SettingsHandler.setPCGenOption("loadCampaignsWithPC", SettingsHandler.isLoadCampaignsWithPC());
        SettingsHandler.setPCGenOption("loadMasterworkAndMagicFromLst", SettingsHandler.wantToLoadMasterworkAndMagic());
        SettingsHandler.setPCGenOption("loadURLs", loadURLs);
        SettingsHandler.setPCGenOption("looknFeel", SettingsHandler.getLookAndFeel());
        SettingsHandler.setPCGenOption("maxPotionSpellLevel", SettingsHandler.getMaxPotionSpellLevel());
        SettingsHandler.setPCGenOption("maxWandSpellLevel", SettingsHandler.getMaxWandSpellLevel());
        SettingsHandler.setPCGenOption("nameDisplayStyle", SettingsHandler.getNameDisplayStyle());
        SettingsHandler.setPCGenOption("optionAllowedInSources", SettingsHandler.isOptionAllowedInSources());
        SettingsHandler.setPCGenOption("postExportCommand", SettingsHandler.getPostExportCommand());
        SettingsHandler.setPCGenOption("prereqFailColor", "0x" + Integer.toHexString(SettingsHandler.getPrereqFailColor()));
        SettingsHandler.setPCGenOption("prereqQualifyColor", "0x" + Integer.toHexString(SettingsHandler.getPrereqQualifyColor()));
        SettingsHandler.setPCGenOption("previewTabShown", SettingsHandler.isPreviewTabShown());
        SettingsHandler.setPCGenOption("purchaseMethodName", purchaseMethodName);
        SettingsHandler.setPCGenOption("RaceTab.ListMode", SettingsHandler.getRaceTab_ListMode());
        SettingsHandler.setPCGenOption("ranStartingWizard", ranStartingWizard);
        SettingsHandler.setPCGenOption("rollMethod", SettingsHandler.getRollMethod());
        SettingsHandler.setPCGenOption("rollMethodExpression", SettingsHandler.getRollMethodExpression());
        SettingsHandler.setPCGenOption("saveCustomInLst", SettingsHandler.isSaveCustomInLst());
        SettingsHandler.setPCGenOption("saveOutputSheetWithPC", SettingsHandler.getSaveOutputSheetWithPC());
        SettingsHandler.setPCGenOption("printSpellsWithPC", SettingsHandler.getPrintSpellsWithPC());
        SettingsHandler.setPCGenOption("showD20InfoAtStart", showD20InfoAtStart);
        SettingsHandler.setPCGenOption("showFeatDialogAtLevelUp", SettingsHandler.getShowFeatDialogAtLevelUp());
        SettingsHandler.setPCGenOption("showHPDialogAtLevelUp", SettingsHandler.getShowHPDialogAtLevelUp());
        SettingsHandler.setPCGenOption("showNatWeaponTab", showNatWeaponTab);
        SettingsHandler.setPCGenOption("showOGLOnLoad", showOGLOnLoad);
        SettingsHandler.setPCGenOption("showStatDialogAtLevelUp", SettingsHandler.getShowStatDialogAtLevelUp());
        SettingsHandler.setPCGenOption("showTipOfTheDay", SettingsHandler.getShowTipOfTheDay());
        SettingsHandler.setPCGenOption("showToolBar", SettingsHandler.isShowToolBar());
        SettingsHandler.setPCGenOption("showWarningAtFirstLevelUp", SettingsHandler.isShowWarningAtFirstLevelUp());
        SettingsHandler.setPCGenOption("SkillsTab.availableListMode", SettingsHandler.getSkillsTab_AvailableListMode());
        SettingsHandler.setPCGenOption("SkillsTab.selectedListMode", SettingsHandler.getSkillsTab_SelectedListMode());
        SettingsHandler.setPCGenOption("sourceDisplay", Globals.getSourceDisplay());
        SettingsHandler.setPCGenOption("spellMarketPriceAdjusted", SettingsHandler.isSpellMarketPriceAdjusted());
        SettingsHandler.setPCGenOption("SpellsTab.availableListMode", SettingsHandler.getSpellsTab_AvailableListMode());
        SettingsHandler.setPCGenOption("SpellsTab.selectedListMode", SettingsHandler.getSpellsTab_SelectedListMode());
        SettingsHandler.setPCGenOption("summaryTabShown", SettingsHandler.isSummaryTabShown());
        SettingsHandler.setPCGenOption("tabPlacement", SettingsHandler.convertTabPlacementToString(tabPlacement));
        SettingsHandler.setPCGenOption("toolTipTextShown", SettingsHandler.isToolTipTextShown());
        SettingsHandler.setPCGenOption("useMonsterDefault", SettingsHandler.isUseMonsterDefault());
        SettingsHandler.setPCGenOption("useWaitCursor", SettingsHandler.getUseWaitCursor());
        SettingsHandler.setPCGenOption("validateBonuses", validateBonuses);
        SettingsHandler.setPCGenOption("weaponProfPrintout", SettingsHandler.getWeaponProfPrintout());
    }

    public static void setPCGenOption(String optionName, int optionValue) {
        SettingsHandler.setPCGenOption(optionName, String.valueOf(optionValue));
    }

    public static void setPCGenOption(String optionName, String optionValue) {
        SettingsHandler.getOptions().setProperty("pcgen.options." + optionName, optionValue);
    }

    public static int getPCGenOption(String optionName, int defaultValue) {
        return Integer.decode(SettingsHandler.getPCGenOption(optionName, String.valueOf(defaultValue)));
    }

    public static String getPCGenOption(String optionName, String defaultValue) {
        return SettingsHandler.getOptions().getProperty("pcgen.options." + optionName, defaultValue);
    }

    public static String getPDFOutputSheetPath() {
        if ("".equals(selectedCharacterPDFOutputSheet)) {
            return SettingsHandler.getPcgenOutputSheetDir().toString();
        }
        return new File(selectedCharacterPDFOutputSheet).getParentFile().getAbsolutePath();
    }

    public static void setPccFilesLocation(File argPccFilesLocation) {
        pccFilesLocation = argPccFilesLocation;
    }

    public static File getPccFilesLocation() {
        return pccFilesLocation;
    }

    public static void setPcgPath(File path) {
        pcgPath = path;
    }

    public static File getPcgPath() {
        return pcgPath;
    }

    public static void setPcgenCustomDir(File aFile) {
        pcgenCustomDir = aFile;
    }

    public static File getPcgenCustomDir() {
        return pcgenCustomDir;
    }

    public static void setPcgenVendorDataDir(File aFile) {
        pcgenVendorDataDir = aFile;
    }

    public static File getPcgenVendorDataDir() {
        return pcgenVendorDataDir;
    }

    public static void setPcgenDocsDir(File argPcgenDocsDir) {
        pcgenDocsDir = argPcgenDocsDir;
    }

    public static File getPcgenDocsDir() {
        return pcgenDocsDir;
    }

    public static void setPcgenFilesDir(File aFile) {
        if (aFile != null) {
            pcgenFilesDir = aFile;
        }
    }

    public static File getPcgenFilesDir() {
        return pcgenFilesDir;
    }

    public static void setPcgenOutputSheetDir(File aFile) {
        pcgenOutputSheetDir = aFile;
    }

    public static File getPcgenOutputSheetDir() {
        return pcgenOutputSheetDir;
    }

    public static void setPcgenSystemDir(File aFile) {
        pcgenSystemDir = aFile;
    }

    public static File getPcgenSystemDir() {
        return pcgenSystemDir;
    }

    public static File getPcgenThemePackDir() {
        return pcgenThemePackDir;
    }

    public static void setPortraitsPath(File path) {
        portraitsPath = path;
    }

    public static File getPortraitsPath() {
        return portraitsPath;
    }

    public static void setPostExportCommand(String argPreference) {
        postExportCommand = argPreference;
    }

    public static String getPostExportCommand() {
        return postExportCommand;
    }

    public static void setPrereqFailColor(int newColor) {
        prereqFailColor = newColor & 0xFFFFFF;
    }

    public static int getPrereqFailColor() {
        return prereqFailColor;
    }

    public static String getPrereqFailColorAsHtmlStart() {
        StringBuffer rString = new StringBuffer("<font color=");
        if (SettingsHandler.getPrereqFailColor() != 0) {
            rString.append("\"#").append(Integer.toHexString(SettingsHandler.getPrereqFailColor())).append("\"");
        } else {
            rString.append("red");
        }
        rString.append('>');
        return rString.toString();
    }

    public static String getPrereqFailColorAsHtmlEnd() {
        return "</font>";
    }

    public static void setPrereqQualifyColor(int newColor) {
        prereqQualifyColor = newColor & 0xFFFFFF;
    }

    public static int getPrereqQualifyColor() {
        return prereqQualifyColor;
    }

    public static void setPrintSpellsWithPC(boolean arg) {
        printSpellsWithPC = arg;
    }

    public static boolean getPrintSpellsWithPC() {
        return printSpellsWithPC;
    }

    public static PointBuyMethod getPurchaseMethodByName(String methodName) {
        if (pointBuyMethods != null) {
            int x = pointBuyMethods.size();
            for (int idx = 0; idx < x; ++idx) {
                PointBuyMethod pbm = (PointBuyMethod)pointBuyMethods.get(idx);
                if (!pbm.getMethodName().equalsIgnoreCase(methodName)) continue;
                return pbm;
            }
        }
        return null;
    }

    public static int getPurchaseMethodCount() {
        if (pointBuyMethods != null) {
            return pointBuyMethods.size();
        }
        return 0;
    }

    public static void setPurchaseMethodName(String argMethodName) {
        if (argMethodName.length() != 0) {
            SettingsHandler.setRollMethod(9);
        }
        purchaseMethodName = argMethodName;
    }

    public static int getPurchaseModeBaseStatScore() {
        int x = SettingsHandler.getPurchaseScoreMax() - SettingsHandler.getPurchaseScoreMin() + 1;
        for (int i = 0; i < x; ++i) {
            if (SettingsHandler.getAbilityScoreCost(i) != 0) continue;
            return SettingsHandler.getPurchaseScoreMin() + i;
        }
        return SettingsHandler.getPurchaseScoreMin() - 1;
    }

    public static String getPurchaseModeMethodName() {
        if (!SettingsHandler.isPurchaseStatMode()) {
            return null;
        }
        return purchaseMethodName;
    }

    public static int getPurchaseModeMethodPool() {
        if (!SettingsHandler.isPurchaseStatMode()) {
            return -1;
        }
        return SettingsHandler.getPurchaseMethodByName(purchaseMethodName).getPoints();
    }

    public static int getPurchaseScoreMax() {
        if (pointBuyStatCosts == null) {
            return -1;
        }
        return (Integer)pointBuyStatCosts.lastKey();
    }

    public static int getPurchaseScoreMin() {
        if (pointBuyStatCosts == null) {
            return -1;
        }
        return (Integer)pointBuyStatCosts.firstKey();
    }

    public static boolean isPurchaseStatMode() {
        if (pointBuyStatCosts == null || pointBuyStatCosts.size() == 0 || SettingsHandler.getRollMethod() != 9 || purchaseMethodName.length() == 0) {
            return false;
        }
        return SettingsHandler.getPurchaseMethodByName(purchaseMethodName) != null;
    }

    public static PointBuyMethod getPurhaseMethod(int idx) {
        if (pointBuyMethods == null || idx > pointBuyMethods.size()) {
            return null;
        }
        return (PointBuyMethod)pointBuyMethods.get(idx);
    }

    public static boolean isROG() {
        return isROG;
    }

    public static void setRaceTab_ListMode(int listMode) {
        raceTab_ListMode = listMode;
    }

    public static int getRaceTab_ListMode() {
        return raceTab_ListMode;
    }

    public static void setRollMethod(int argRollMethod) {
        rollMethod = argRollMethod;
        if (argRollMethod != 9) {
            SettingsHandler.setPurchaseMethodName("");
        }
        SettingsHandler.setRollMethodExpression(SettingsHandler.getRollMethodExpression(rollMethod));
    }

    public static int getRollMethod() {
        return rollMethod;
    }

    public static String getRollMethodExpression(int method) {
        return SettingsHandler.getRollMethodExpressions()[method];
    }

    public static void setRuleCheck(String aKey, boolean aBool) {
        String aVal = "N";
        if (aBool) {
            aVal = "Y";
        }
        ruleCheckMap.put(aKey, aVal);
    }

    public static boolean getRuleCheck(String aKey) {
        String aVal;
        return ruleCheckMap.containsKey(aKey) && (aVal = (String)ruleCheckMap.get(aKey)).equals("Y");
    }

    public static void setSaveCustomEquipment(boolean aBool) {
        SettingsHandler.setSaveCustomInLst(aBool);
    }

    public static boolean getSaveCustomEquipment() {
        return SettingsHandler.isSaveCustomInLst();
    }

    public static void setSaveOutputSheetWithPC(boolean arg) {
        saveOutputSheetWithPC = arg;
    }

    public static boolean getSaveOutputSheetWithPC() {
        return saveOutputSheetWithPC;
    }

    public static void setSelectedCharacterHTMLOutputSheet(String path, PlayerCharacter aPC) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && aPC != null) {
            aPC.setSelectedCharacterHTMLOutputSheet(path);
        }
        selectedCharacterHTMLOutputSheet = path;
    }

    public static String getSelectedCharacterHTMLOutputSheet(PlayerCharacter aPC) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && aPC != null && aPC.getSelectedCharacterHTMLOutputSheet().length() > 0) {
            return aPC.getSelectedCharacterHTMLOutputSheet();
        }
        return selectedCharacterHTMLOutputSheet;
    }

    public static void setSelectedCharacterPDFOutputSheet(String path, PlayerCharacter aPC) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && aPC != null) {
            aPC.setSelectedCharacterPDFOutputSheet(path);
        }
        selectedCharacterPDFOutputSheet = path;
    }

    public static String getSelectedCharacterPDFOutputSheet(PlayerCharacter aPC) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && aPC != null && aPC.getSelectedCharacterPDFOutputSheet().length() > 0) {
            return aPC.getSelectedCharacterPDFOutputSheet();
        }
        return selectedCharacterPDFOutputSheet;
    }

    public static void setSelectedEqSetTemplate(String path) {
        selectedEqSetTemplate = path;
    }

    public static String getSelectedEqSetTemplate() {
        return selectedEqSetTemplate;
    }

    public static String getSelectedEqSetTemplateName() {
        if (selectedEqSetTemplate.length() > 0) {
            int i = selectedEqSetTemplate.lastIndexOf("\\");
            return selectedEqSetTemplate.substring(i + 1);
        }
        return selectedEqSetTemplate;
    }

    public static void setSelectedPartyHTMLOutputSheet(String path) {
        selectedPartyHTMLOutputSheet = path;
    }

    public static String getSelectedPartyHTMLOutputSheet() {
        return selectedPartyHTMLOutputSheet;
    }

    public static void setSelectedPartyPDFOutputSheet(String path) {
        selectedPartyPDFOutputSheet = path;
    }

    public static String getSelectedPartyPDFOutputSheet() {
        return selectedPartyPDFOutputSheet;
    }

    public static void setSelectedSpellSheet(String path) {
        selectedSpellSheet = path;
    }

    public static String getSelectedSpellSheet() {
        return selectedSpellSheet;
    }

    public static String getSelectedSpellSheetName() {
        if (selectedSpellSheet.length() > 0) {
            int i = selectedSpellSheet.lastIndexOf("\\");
            return selectedSpellSheet.substring(i + 1);
        }
        return selectedSpellSheet;
    }

    public static void setShowD20Info(boolean aBool) {
        showD20InfoAtStart = aBool;
    }

    public static void setShowFeatDialogAtLevelUp(boolean argShowFeatDialogAtLevelUp) {
        showFeatDialogAtLevelUp = argShowFeatDialogAtLevelUp;
    }

    public static boolean getShowFeatDialogAtLevelUp() {
        return showFeatDialogAtLevelUp;
    }

    public static void setShowHPDialogAtLevelUp(boolean argShowHPDialogAtLevelUp) {
        showHPDialogAtLevelUp = argShowHPDialogAtLevelUp;
    }

    public static boolean getShowHPDialogAtLevelUp() {
        return showHPDialogAtLevelUp;
    }

    public static void setShowLicense(boolean arg) {
        showOGLOnLoad = arg;
    }

    public static void setShowStatDialogAtLevelUp(boolean argShowStatDialogAtLevelUp) {
        showStatDialogAtLevelUp = argShowStatDialogAtLevelUp;
    }

    public static boolean getShowStatDialogAtLevelUp() {
        return showStatDialogAtLevelUp;
    }

    public static void setShowTipOfTheDay(boolean argShowTipOfTheDay) {
        showTipOfTheDay = argShowTipOfTheDay;
    }

    public static boolean getShowTipOfTheDay() {
        return showTipOfTheDay;
    }

    public static void setShowWarningAtFirstLevelUp(boolean argShowWarningAtFirstLevelUp) {
        showWarningAtFirstLevelUp = argShowWarningAtFirstLevelUp;
    }

    public static boolean isShowWarningAtFirstLevelUp() {
        return showWarningAtFirstLevelUp;
    }

    public static void setSingleChoicePreference(int argPreference) {
        singleChoicePreference = argPreference;
    }

    public static int getSingleChoicePreference() {
        return singleChoicePreference;
    }

    public static void setSkillsTab_AvailableListMode(int listMode) {
        skillsTab_AvailableListMode = listMode;
    }

    public static int getSkillsTab_AvailableListMode() {
        return skillsTab_AvailableListMode;
    }

    public static void setSkillsTab_IncludeSkills(int anInt) {
        skillsTab_IncludeSkills = anInt;
    }

    public static int getSkillsTab_IncludeSkills() {
        return skillsTab_IncludeSkills;
    }

    public static void setSkillsTab_SelectedListMode(int listMode) {
        skillsTab_SelectedListMode = listMode;
    }

    public static int getSkillsTab_SelectedListMode() {
        return skillsTab_SelectedListMode;
    }

    public static void setSkinLFThemePack(String argSkinLFThemePack) {
        skinLFThemePack = argSkinLFThemePack;
    }

    public static String getSkinLFThemePack() {
        return skinLFThemePack;
    }

    public static void setSpellsTab_AvailableListMode(int listMode) {
        spellsTab_AvailableListMode = listMode;
    }

    public static int getSpellsTab_AvailableListMode() {
        return spellsTab_AvailableListMode;
    }

    public static void setSpellsTab_SelectedListMode(int listMode) {
        spellsTab_SelectedListMode = listMode;
    }

    public static int getSpellsTab_SelectedListMode() {
        return spellsTab_SelectedListMode;
    }

    public static void setTabPlacement(int anInt) {
        tabPlacement = anInt;
    }

    public static int getTabPlacement() {
        return tabPlacement;
    }

    public static File getTempPath() {
        return tempPath;
    }

    public static void setToolBarShown(boolean argShowToolBar) {
        SettingsHandler.setShowToolBar(argShowToolBar);
    }

    public static boolean isToolBarShown() {
        return SettingsHandler.isShowToolBar();
    }

    public static void setToolTipTextShown(boolean showToolTipText) {
        toolTipTextShown = showToolTipText;
        PCGen_Frame1 frame = PCGen_Frame1.getInst();
        if (frame != null) {
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
    }

    public static boolean isToolTipTextShown() {
        return toolTipTextShown;
    }

    public static void setUseFeatBenefits(boolean arg) {
        useFeatBenefits = arg;
    }

    public static void setUseWaitCursor(boolean b) {
        useWaitCursor = b;
        PCGen_Frame1.useWaitCursor(b);
    }

    public static boolean getUseWaitCursor() {
        return useWaitCursor;
    }

    public static void setWantToLoadMasterworkAndMagic(boolean bFlag) {
        wantToLoadMasterworkAndMagic = bFlag;
    }

    public static void setWeaponProfPrintout(boolean argPreference) {
        weaponProfPrintout = argPreference;
    }

    public static boolean getWeaponProfPrintout() {
        return weaponProfPrintout;
    }

    public static void addPointBuyStatCost(int statValue, int cost) {
        if (pointBuyStatCosts == null) {
            pointBuyStatCosts = new TreeMap(new ComparableComparator());
        }
        abilityScoreCost = null;
        pointBuyStatCosts.put(new Integer(statValue), new Integer(cost));
    }

    public static void addPurchaseModeMethod(String methodName, int points) {
        if (SettingsHandler.getPurchaseMethodByName(methodName) == null) {
            if (pointBuyMethods == null) {
                pointBuyMethods = new ArrayList();
            }
            PointBuyMethod pmb = new PointBuyMethod(methodName, points);
            pointBuyMethods.add(pmb);
        }
    }

    public static void clearPointBuyStatCosts() {
        pointBuyStatCosts = null;
        abilityScoreCost = null;
    }

    public static void clearPurchaseModeMethods() {
        pointBuyMethods = null;
    }

    public static boolean guiUsesOutputName() {
        return guiUsesOutputName;
    }

    public static boolean hasRuleCheck(String aKey) {
        return ruleCheckMap.containsKey(aKey);
    }

    public static boolean hideMonsterClasses() {
        return hideMonsterClasses;
    }

    public static void readGUIOptionsProperties() {
        SettingsHandler.setNameDisplayStyle(SettingsHandler.getPCGenOption("nameDisplayStyle", 0));
        if (Globals.javaVersionMajor >= 1 && Globals.javaVersionMinor >= 4 || !System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("MAC")) {
            SettingsHandler.setToolTipTextShown(SettingsHandler.getPCGenOption("toolTipTextShown", SettingsHandler.isToolTipTextShown()));
        } else {
            SettingsHandler.setToolTipTextShown(SettingsHandler.getPCGenOption("toolTipTextShown", false));
        }
        SettingsHandler.setOpenRecentPCs(SettingsHandler.getOpenRecentOption("openRecentPCs"));
        SettingsHandler.setOpenRecentParties(SettingsHandler.getOpenRecentOption("openRecentParties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void readOptionsProperties() {
        block11: {
            SettingsHandler.readFilePaths();
            SettingsHandler.readFilterSettings();
            String optionsLocation = Globals.getOptionsPath();
            FileInputStream in = null;
            in = new FileInputStream(optionsLocation);
            SettingsHandler.getOptions().load(in);
            Object var4_2 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block11;
            }
            catch (IOException ex) {
                Logging.errorPrint("Can't close options file", ex);
            }
            break block11;
            {
                catch (IOException e) {
                    Logging.debugPrint("No options file found, will create one when exiting.");
                    Object var4_3 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block11;
                    }
                    catch (IOException ex) {
                        Logging.errorPrint("Can't close options file", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Logging.errorPrint("Can't close options file", ex);
                }
                throw throwable;
            }
        }
    }

    public static String retrieveFilterSettings(String optionName) {
        return SettingsHandler.getFilterSettings().getProperty("pcgen.filters." + optionName, SettingsHandler.getOptions().getProperty("pcgen.filters." + optionName, ""));
    }

    public static boolean showD20Info() {
        return showD20InfoAtStart;
    }

    public static boolean showLicense() {
        return showOGLOnLoad;
    }

    public static boolean showNaturalWeaponTab() {
        return showNatWeaponTab;
    }

    public static void storeFilterSettings(Filterable filterable) {
        String name = filterable.getName();
        if (name == null) {
            return;
        }
        SettingsHandler.getFilterSettings().setProperty("pcgen.filters." + name + ".mode", Integer.toString(filterable.getFilterMode()));
        SettingsHandler.getFilterSettings().setProperty("pcgen.filters." + name + ".available", FilterFactory.filterListToString(filterable.getAvailableFilters()));
        SettingsHandler.getFilterSettings().setProperty("pcgen.filters." + name + ".selected", FilterFactory.filterListToString(filterable.getSelectedFilters()));
        SettingsHandler.getFilterSettings().setProperty("pcgen.filters." + name + ".removed", FilterFactory.filterListToString(filterable.getRemovedFilters()));
    }

    public static boolean useFeatBenefits() {
        return useFeatBenefits;
    }

    public static boolean wantToLoadMasterworkAndMagic() {
        return wantToLoadMasterworkAndMagic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeFilePaths() {
        block16: {
            String header = "# Emacs, this is -*- java-properties-generic -*- mode." + Constants.s_LINE_SEP + "#" + Constants.s_LINE_SEP + "# filepaths.ini -- location of other .ini files set in pcgen" + Constants.s_LINE_SEP + "# Do not edit this file manually." + Constants.s_LINE_SEP;
            String fType = SettingsHandler.getFilePaths();
            if (!fType.equals("pcgen") && !fType.equals("user") && SettingsHandler.getPcgenFilesDir() != null) {
                SettingsHandler.setFilePaths(SettingsHandler.getPcgenFilesDir().getAbsolutePath());
            }
            if (fType.equals("user")) {
                String aLoc = System.getProperty("user.home") + File.separator + ".pcgen";
                File aFile = new File(aLoc);
                if (!aFile.exists()) {
                    aFile.mkdir();
                    Logging.errorPrint(aLoc + " doesn't exist. Creating");
                } else if (!aFile.isDirectory()) {
                    ShowMessageDelegate.showMessageDialog("ERROR: " + aLoc + " is not a Directory", "PCGen", MessageType.ERROR);
                }
            }
            FileOutputStream out = null;
            out = new FileOutputStream(fileLocation);
            SettingsHandler.getFilepathProp().store(out, header);
            Object var5_5 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block16;
            }
            catch (IOException ex) {
                Logging.errorPrint("Can't close filepaths.ini file after writing", ex);
            }
            break block16;
            {
                catch (IOException e) {
                    Logging.errorPrint("Can't write filepaths.ini file", e);
                    Object var5_6 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block16;
                    }
                    catch (IOException ex) {
                        Logging.errorPrint("Can't close filepaths.ini file after writing", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    Logging.errorPrint("Can't close filepaths.ini file after writing", ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeOptionsProperties(PlayerCharacter aPC) {
        block11: {
            SettingsHandler.writeFilePaths();
            SettingsHandler.writeFilterSettings();
            String optionsLocation = Globals.getOptionsPath();
            String header = "# Emacs, this is -*- java-properties-generic -*- mode." + Constants.s_LINE_SEP + "#" + Constants.s_LINE_SEP + "# options.ini -- options set in pcgen" + Constants.s_LINE_SEP + "# Do not edit this file manually." + Constants.s_LINE_SEP;
            SettingsHandler.setOptionsProperties(aPC);
            FileOutputStream out = null;
            out = new FileOutputStream(optionsLocation);
            SettingsHandler.getOptions().mystore(out, header);
            Object var6_4 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block11;
            }
            catch (IOException ex) {
                Logging.errorPrint("Can't close options file after writing", ex);
            }
            break block11;
            {
                catch (IOException e) {
                    Logging.errorPrint("Can't write options file", e);
                    Object var6_5 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block11;
                    }
                    catch (IOException ex) {
                        Logging.errorPrint("Can't close options file after writing", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    Logging.errorPrint("Can't close options file after writing", ex);
                }
                throw throwable;
            }
        }
    }

    static boolean isAutogenExoticMaterial() {
        return autogenExoticMaterial;
    }

    static boolean isAutogenMagic() {
        return autogenMagic;
    }

    static boolean isAutogenMasterwork() {
        return autogenMasterwork;
    }

    static boolean isAutogenRacial() {
        return autogenRacial;
    }

    static void setPreviewTabShown(boolean showPreviewTab) {
        previewTabShown = showPreviewTab;
    }

    static boolean isPreviewTabShown() {
        return previewTabShown;
    }

    private static void setAutoFeatsRefundable(boolean argAutoFeatsRefundable) {
        autoFeatsRefundable = argAutoFeatsRefundable;
    }

    private static boolean isAutoFeatsRefundable() {
        return autoFeatsRefundable;
    }

    private static void setAutogenExoticMaterial(boolean aBool) {
        autogenExoticMaterial = aBool;
    }

    private static void setAutogenMagic(boolean aBool) {
        autogenMagic = aBool;
    }

    private static void setAutogenMasterwork(boolean aBool) {
        autogenMasterwork = aBool;
    }

    private static void setAutogenRacial(boolean aBool) {
        autogenRacial = aBool;
    }

    private static Properties getFilterSettings() {
        return filterSettings;
    }

    private static void setGrimHPMode(boolean argGrimHPMode) {
        grimHPMode = argGrimHPMode;
    }

    private static boolean isGrimHPMode() {
        return grimHPMode;
    }

    private static void setGrittyACMode(boolean aBool) {
        grittyACMode = aBool;
    }

    private static boolean isGrittyACMode() {
        return grittyACMode;
    }

    private static void setOpenRecentOption(String optionName, String[] strings) {
        String value = "";
        if (strings.length > 0) {
            value = value + strings[0];
            for (int i = 1; i < strings.length; ++i) {
                value = value + "|" + strings[i];
            }
        }
        SettingsHandler.setPCGenOption(optionName, value);
    }

    private static String[] getOpenRecentOption(String optionName) {
        String value = SettingsHandler.getPCGenOption(optionName, "");
        if (value == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        ArrayList<String> strings = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            strings.add(tok.nextToken());
        }
        return strings.toArray(new String[0]);
    }

    private static void setOpenRecentPCs(String[] strings) {
        PCGen_Frame1.getInst().setOpenRecentPCs(strings);
    }

    private static void setOpenRecentParties(String[] strings) {
        PCGen_Frame1.getInst().setOpenRecentParties(strings);
    }

    private static int getOptionTabPlacement(String optionName, int defaultValue) {
        int iVal;
        String aString = SettingsHandler.getPCGenOption(optionName, SettingsHandler.convertTabPlacementToString(defaultValue));
        try {
            iVal = Integer.parseInt(aString);
            switch (iVal) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    iVal = defaultValue;
                    break;
                }
            }
        }
        catch (NumberFormatException exc) {
            iVal = "TOP".equals(aString) ? 1 : ("LEFT".equals(aString) ? 2 : ("BOTTOM".equals(aString) ? 3 : ("RIGHT".equals(aString) ? 4 : defaultValue)));
        }
        return iVal;
    }

    private static void setPCGenOption(String optionName, boolean optionValue) {
        SettingsHandler.setPCGenOption(optionName, optionValue ? "true" : "false");
    }

    private static void setPCGenOption(String optionName, double optionValue) {
        SettingsHandler.setPCGenOption(optionName, String.valueOf(optionValue));
    }

    public static boolean getPCGenOption(String optionName, boolean defaultValue) {
        String option = SettingsHandler.getPCGenOption(optionName, defaultValue ? "true" : "false");
        return "true".equalsIgnoreCase(option);
    }

    private static Double getPCGenOption(String optionName, double defaultValue) {
        return new Double(SettingsHandler.getPCGenOption(optionName, Double.toString(defaultValue)));
    }

    private static void setPcgenThemePackDir(File aFile) {
        pcgenThemePackDir = aFile;
    }

    private static boolean isPurchaseStatModeAllowed() {
        return pointBuyStatCosts != null && pointBuyStatCosts.size() != 0;
    }

    private static void setROG(boolean ROG) {
        isROG = ROG;
    }

    private static void setRanStartingWizard(boolean ran) {
        ranStartingWizard = ran;
    }

    private static void setRollMethodExpression(String aString) {
        rollMethodExpression = aString;
    }

    private static String getRollMethodExpression() {
        return rollMethodExpression;
    }

    private static String[] getRollMethodExpressions() {
        return rollMethodExpressions;
    }

    private static void setRuleChecksInOptions(String optionName) {
        String value = "";
        Iterator i = ruleCheckMap.keySet().iterator();
        while (i.hasNext()) {
            String aKey = (String)i.next();
            String aVal = (String)ruleCheckMap.get(aKey);
            if (value.length() == 0) {
                value = aKey + "|" + aVal;
                continue;
            }
            value = value + "," + aKey + "|" + aVal;
        }
        SettingsHandler.getOptions().setProperty("pcgen.options." + optionName, value);
    }

    private static void setSaveCustomInLst(boolean aBool) {
        saveCustomInLst = aBool;
    }

    private static boolean isSaveCustomInLst() {
        return saveCustomInLst;
    }

    private static void setShowToolBar(boolean argShowToolBar) {
        showToolBar = argShowToolBar;
    }

    private static boolean isShowToolBar() {
        return showToolBar;
    }

    private static void setSpellMarketPriceAdjusted(boolean aBool) {
        spellMarketPriceAdjusted = aBool;
    }

    private static boolean isSpellMarketPriceAdjusted() {
        return spellMarketPriceAdjusted;
    }

    private static void setSummaryTabShown(boolean showSummaryTab) {
        summaryTabShown = showSummaryTab;
    }

    private static boolean isSummaryTabShown() {
        return summaryTabShown;
    }

    private static String getTmpPath() {
        return tmpPath;
    }

    private static boolean isUseMonsterDefault() {
        return useMonsterDefault;
    }

    private static String convertTabPlacementToString(int placement) {
        switch (placement) {
            case 3: {
                return "BOTTOM";
            }
            case 2: {
                return "LEFT";
            }
            case 4: {
                return "RIGHT";
            }
        }
        return "TOP";
    }

    private static String expandRelativePath(String path) {
        if (path.startsWith("@")) {
            path = System.getProperty("user.dir") + path.substring(1);
        }
        return path;
    }

    private static void parseRuleChecksFromOptions(String aString) {
        if (aString.length() <= 0) {
            return;
        }
        StringTokenizer aTok = new StringTokenizer(aString, ",");
        while (aTok.hasMoreTokens()) {
            String bs = aTok.nextToken();
            StringTokenizer bTok = new StringTokenizer(bs, "|");
            String aKey = bTok.nextToken();
            String aVal = bTok.nextToken();
            ruleCheckMap.put(aKey, aVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void readFilePaths() {
        block11: {
            FileInputStream in = null;
            in = new FileInputStream(fileLocation);
            SettingsHandler.getFilepathProp().load(in);
            Object var3_1 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block11;
            }
            catch (IOException ex) {
                Logging.errorPrint("Can't close filepaths.ini file", ex);
            }
            break block11;
            {
                catch (IOException e) {
                    Logging.debugPrint("No filepaths.ini file found, will create one when exiting.");
                    Object var3_2 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block11;
                    }
                    catch (IOException ex) {
                        Logging.errorPrint("Can't close filepaths.ini file", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Logging.errorPrint("Can't close filepaths.ini file", ex);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void readFilterSettings() {
        block11: {
            String filterLocation = Globals.getFilterPath();
            FileInputStream in = null;
            in = new FileInputStream(filterLocation);
            SettingsHandler.getFilterSettings().load(in);
            Object var4_2 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block11;
            }
            catch (IOException ex) {
                Logging.errorPrint("Can't close filter file", ex);
            }
            break block11;
            {
                catch (IOException e) {
                    Logging.debugPrint("No filter settings file found, will create one when exiting.");
                    Object var4_3 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block11;
                    }
                    catch (IOException ex) {
                        Logging.errorPrint("Can't close filter file", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Logging.errorPrint("Can't close filter file", ex);
                }
                throw throwable;
            }
        }
    }

    private static String retractRelativePath(String path) {
        File userDir = new File(System.getProperty("user.dir"));
        if (path.startsWith(userDir.getAbsolutePath())) {
            path = "@" + path.substring(userDir.getAbsolutePath().length());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeFilterSettings() {
        block12: {
            String header = "# Emacs, this is -*- java-properties-generic -*- mode." + Constants.s_LINE_SEP + Constants.s_LINE_SEP + "# filter.ini -- filters set in pcgen" + Constants.s_LINE_SEP + "# Do not edit this file manually." + Constants.s_LINE_SEP;
            String filterLocation = Globals.getFilterPath();
            FileOutputStream out = null;
            out = new FileOutputStream(filterLocation);
            SettingsHandler.getFilterSettings().store(out, header);
            Object var5_3 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block12;
            }
            catch (IOException ex) {
                Logging.errorPrint("Can't close filter file after writing", ex);
            }
            break block12;
            {
                catch (IOException e) {
                    Logging.errorPrint("Can't write filter settings", e);
                    var5_3 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block12;
                    }
                    catch (IOException ex) {
                        Logging.errorPrint("Can't close filter file after writing", ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    Logging.errorPrint("Can't close filter file after writing", ex);
                }
                throw throwable;
            }
        }
        Iterator<Object> it = SettingsHandler.getOptions().keySet().iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).startsWith("pcgen.filters.")) continue;
            it.remove();
        }
    }

    public static int getWindowState() {
        return windowState;
    }

    public static void setWindowState(int argWindowState) {
        windowState = argWindowState;
    }

    static {
        gearTab_IgnoreCost = false;
        gearTab_AllowDebt = false;
        gearTab_SellRate = 50;
        gearTab_BuyRate = 100;
        isROG = false;
        leftUpperCorner = null;
        windowState = 0;
        loadCampaignsAtStart = false;
        loadCampaignsWithPC = true;
        looknFeel = 1;
        expertGUI = false;
        optionAllowedInSources = true;
        options = new SortedProperties();
        filepaths = new Properties();
        fileLocation = System.getProperty("user.dir") + File.separator + "filepaths.ini";
        pcgenFilesDir = new File(System.getProperty("user.dir"));
        pccFilesLocation = null;
        pcgPath = new File(Globals.getDefaultPath());
        portraitsPath = new File(Globals.getDefaultPath());
        pcgenCustomDir = new File(Globals.getDefaultPath() + File.separator + "data" + File.separator + "customsources");
        pcgenVendorDataDir = new File(Globals.getDefaultPath() + File.separator + "vendordata");
        pcgenDocsDir = null;
        pcgenSystemDir = new File(Globals.getDefaultPath() + File.separator + "system");
        pcgenThemePackDir = new File(Globals.getDefaultPath() + File.separator + "lib" + File.separator + "themes");
        pcgenOutputSheetDir = new File(Globals.getDefaultPath() + File.separator + "outputsheets");
        gmgenPluginDir = new File(Globals.getDefaultPath() + File.separator + "plugins");
        prereqQualifyColor = 0;
        prereqFailColor = 0xFF0000;
        previewTabShown = false;
        purchaseMethodName = "";
        abilityScoreCost = null;
        pointBuyStatCosts = null;
        pointBuyMethods = null;
        ranStartingWizard = false;
        rollMethod = 1;
        rollMethodExpression = "roll(4,6,[2,3,4])";
        rollMethodExpressions = new String[]{"0", "roll(4,6,[2,3,4])", "3d6", "roll(5,6,[3,4,5])", "roll(4,5,[2,3,4])+3", "roll(4,4,[2,3,4])+6", "3d6+5", "roll(5,6,[2,4,5])", "10", ""};
        saveCustomInLst = false;
        selectedCharacterHTMLOutputSheet = "";
        selectedCharacterPDFOutputSheet = "";
        saveOutputSheetWithPC = false;
        printSpellsWithPC = true;
        selectedPartyHTMLOutputSheet = "";
        selectedPartyPDFOutputSheet = "";
        selectedEqSetTemplate = "";
        selectedSpellSheet = "";
        showFeatDialogAtLevelUp = true;
        showHPDialogAtLevelUp = true;
        showStatDialogAtLevelUp = true;
        showToolBar = true;
        showWarningAtFirstLevelUp = true;
        skinLFThemePack = null;
        summaryTabShown = false;
        classTab_AvailableListMode = 0;
        classTab_SelectedListMode = 0;
        equipTab_AvailableListMode = 3;
        equipTab_SelectedListMode = 0;
        featTab_AvailableListMode = 0;
        featTab_SelectedListMode = 1;
        gearTab_AvailableListMode = 0;
        gearTab_SelectedListMode = 2;
        raceTab_ListMode = 0;
        skillsTab_AvailableListMode = 2;
        skillsTab_SelectedListMode = 5;
        spellsTab_AvailableListMode = 0;
        spellsTab_SelectedListMode = 0;
        cleanupTempFiles = 0;
        tabPlacement = 3;
        tmpPath = System.getProperty("java.io.tmpdir");
        tempPath = new File(SettingsHandler.getTmpPath());
        toolTipTextShown = true;
        useMonsterDefault = true;
        wantToLoadMasterworkAndMagic = false;
        nameDisplayStyle = 0;
        weaponProfPrintout = true;
        postExportCommand = "";
        hideMonsterClasses = false;
        guiUsesOutputName = false;
        singleChoicePreference = 0;
        lastTipShown = -1;
        showTipOfTheDay = true;
        isGMGen = false;
        showNatWeaponTab = false;
    }
}

