/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.CharacterDomain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public final class Skill
extends PObject {
    public static final int VISIBILITY_DEFAULT = 1;
    public static final int VISIBILITY_OUTPUT_ONLY = 2;
    public static final int VISIBILITY_DISPLAY_ONLY = 3;
    public static final String COST_CLASS = "CLASS";
    public static final String COST_XCLASS = "CROSS-CLASS";
    public static final String COST_EXCL = "EXCLUSIVE";
    private static final String COST_UNK = "UNKNOWN";
    private static final int ACHECK_NONE = 0;
    private static final int ACHECK_YES = 1;
    private static final int ACHECK_NONPROF = 2;
    private static final int ACHECK_WEIGHT = 3;
    private static final int ACHECK_DOUBLE = 4;
    private ArrayList classList = new ArrayList();
    private ArrayList rankList = new ArrayList();
    private ArrayList synergyList = null;
    private String keyStat = "";
    private String rootName = "";
    private String untrained = "Y";
    private int skillVisible = 1;
    private boolean skillReadOnly = false;
    private boolean isExclusive = false;
    private boolean required = false;
    private int aCheck = 0;
    private int outputIndex = 0;

    public void setACheck(String aString) {
        if (aString.length() != 0) {
            switch (aString.charAt(0)) {
                case 'N': {
                    this.aCheck = 0;
                    break;
                }
                case 'Y': {
                    this.aCheck = 1;
                    break;
                }
                case 'P': {
                    this.aCheck = 2;
                    break;
                }
                case 'D': {
                    this.aCheck = 4;
                    break;
                }
                case 'W': {
                    this.aCheck = 3;
                    break;
                }
            }
        }
    }

    public void setACheck(int argACheck) {
        this.aCheck = argACheck;
    }

    public int getACheck() {
        return this.aCheck;
    }

    public ArrayList getChoiceStringList() {
        if (this.choiceString.length() == 0) {
            return null;
        }
        StringTokenizer aTok = new StringTokenizer(this.choiceString, "|");
        ArrayList<String> aList = new ArrayList<String>();
        while (aTok.hasMoreTokens()) {
            aList.add(aTok.nextToken());
        }
        return aList;
    }

    public ArrayList getClassList() {
        return this.classList;
    }

    public boolean isClassSkill(PCClass aClass, PlayerCharacter aPC) {
        if (aPC == null || aClass == null) {
            return false;
        }
        if (aPC.getRace().hasCSkill(this.name)) {
            return true;
        }
        if (aClass.hasSkill(this.name)) {
            return true;
        }
        if (aClass.hasCSkill(this.name)) {
            return true;
        }
        if (aClass.hasClassSkillList(this.name)) {
            return true;
        }
        if (aClass.isMonster() && aPC.getRace().hasMonsterCSkill(this.name)) {
            return true;
        }
        Iterator i = this.classList.iterator();
        while (i.hasNext()) {
            String aString = i.next().toString();
            if (aString.length() > 0 && aString.charAt(0) == '!' && (aString.substring(1).equalsIgnoreCase(aClass.getName()) || aString.substring(1).equalsIgnoreCase(aClass.getSubClassName()))) {
                return false;
            }
            if (!"ALL".equals(aString) && !aString.equalsIgnoreCase(aClass.getName()) && !aString.equalsIgnoreCase(aClass.getSubClassName()) && (aClass.getClassSkillList() == null || !aClass.getClassSkillList().contains(aString))) continue;
            return true;
        }
        Iterator e = aPC.getCharacterDomainList().iterator();
        while (e.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)e.next();
            if (aCD.getDomain() == null || !aCD.isFromPCClass(aClass.getName()) || !aCD.getDomain().hasCSkill(this.name)) continue;
            return true;
        }
        if (aPC.getDeity() != null && aPC.getDeity().hasCSkill(this.name)) {
            return true;
        }
        Iterator i2 = aPC.aggregateFeatList().iterator();
        while (i2.hasNext()) {
            Feat aFeat = (Feat)i2.next();
            if (!aFeat.hasCSkill(this.name)) continue;
            return true;
        }
        i2 = aPC.getSkillList().iterator();
        while (i2.hasNext()) {
            Skill aSkill = (Skill)i2.next();
            if (!aSkill.hasCSkill(this.name)) continue;
            return true;
        }
        e = aPC.getEquipmentList().iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            if (eq.hasCSkill(this.name)) {
                return true;
            }
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    if (!eqMod.hasCSkill(this.name)) continue;
                    return true;
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                if (!eqMod.hasCSkill(this.name)) continue;
                return true;
            }
        }
        i2 = aPC.getTemplateList().iterator();
        while (i2.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)i2.next();
            if (!aTemplate.hasCSkill(this.name)) continue;
            return true;
        }
        return false;
    }

    public String getExclusive() {
        return this.isExclusive ? "Y" : "N";
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setIsExclusive(boolean argExclusive) {
        this.isExclusive = argExclusive;
    }

    public void setKeyStat(String aString) {
        this.keyStat = aString;
    }

    public String getKeyStat() {
        return this.keyStat;
    }

    public void setOutputIndex(int newIndex) {
        this.outputIndex = newIndex;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public String getPCCText(PlayerCharacter aPC) {
        StringBuffer txt = new StringBuffer(200);
        txt.append(this.getName());
        if (this.keyStat.length() != 0) {
            txt.append("\tKEYSTAT:").append(this.keyStat);
        }
        if (this.isExclusive) {
            txt.append("\tEXCLUSIVE:YES");
        }
        if (!this.isUntrained()) {
            txt.append("\tUSEUNTRAINED:NO");
        }
        Iterator e = this.getSynergyList().iterator();
        while (e.hasNext()) {
            txt.append("\tSYNERGY:").append((String)e.next());
        }
        StringBuffer aString = new StringBuffer(100);
        Iterator e2 = this.getClassList().iterator();
        while (e2.hasNext()) {
            if (aString.length() != 0) {
                aString.append('|');
            }
            aString.append((String)e2.next());
        }
        if (aString.length() != 0) {
            txt.append("\tCLASSES:").append(aString);
        }
        if (this.aCheck != 0) {
            txt.append("\tACHECK:");
            switch (this.aCheck) {
                case 1: {
                    txt.append("YES");
                    break;
                }
                case 2: {
                    txt.append("PROFICIENT");
                    break;
                }
                case 3: {
                    txt.append("WEIGHT");
                    break;
                }
                case 4: {
                    txt.append("DOUBLE");
                    break;
                }
                default: {
                    txt.append("ERROR");
                }
            }
        }
        switch (this.isVisible()) {
            case 2: {
                txt.append("EXPORT");
                break;
            }
            case 3: {
                txt.append("GUI");
                break;
            }
            default: {
                txt.append("YES");
            }
        }
        txt.append(super.getPCCText(false, aPC));
        return txt.toString();
    }

    public Float getRank() {
        double rank = 0.0;
        for (int i = 0; i < this.rankList.size(); ++i) {
            String bSkill = (String)this.rankList.get(i);
            int iOffs = bSkill.indexOf(58);
            rank += Double.parseDouble(bSkill.substring(iOffs + 1));
        }
        return new Float(rank);
    }

    public ArrayList getRankList() {
        return this.rankList;
    }

    public void setRequired(boolean argRequired) {
        this.required = argRequired;
    }

    public void setRootName(String aString) {
        this.rootName = aString;
    }

    public String getSkillCostType(PCClass aClass, PlayerCharacter aPC) {
        if (this.costForPCClass(aClass, aPC) == 1) {
            return COST_CLASS;
        }
        if (this.costForPCClass(aClass, aPC) == 2) {
            return COST_XCLASS;
        }
        if (this.isExclusive) {
            return COST_EXCL;
        }
        return COST_UNK;
    }

    public int getSubtypeCount() {
        int i = this.getMyTypeCount();
        if (i == 0) {
            return 0;
        }
        return i - 1;
    }

    public Iterator getSubtypeIterator() {
        Iterator it = this.getMyTypeIterator();
        if (it.hasNext()) {
            it.next();
        }
        return it;
    }

    public ArrayList getSynergyList() {
        if (this.synergyList == null) {
            this.synergyList = new ArrayList();
        }
        return this.synergyList;
    }

    public Float getTotalRank(PlayerCharacter aPC) {
        return new Float(this.getRank().doubleValue() + this.getRankAdj(aPC).doubleValue());
    }

    public void setUntrained(String aString) {
        this.untrained = aString;
    }

    public String getUntrained() {
        return this.untrained;
    }

    public boolean isUntrained() {
        if (this.untrained.length() != 0) {
            return this.untrained.charAt(0) == 'Y';
        }
        return false;
    }

    public void setZeroRanks(PCClass aClass, PlayerCharacter aPC) {
        int idx;
        if (aClass == null) {
            return;
        }
        String aCName = aClass.getName();
        String bSkill = "";
        String aCNameString = aCName + ":";
        for (idx = 0; idx < this.rankList.size() && !(bSkill = (String)this.rankList.get(idx)).startsWith(aCNameString); ++idx) {
        }
        if (idx >= this.rankList.size()) {
            return;
        }
        double curRankCost = Double.parseDouble(bSkill.substring(aCName.length() + 1));
        String aResp = this.modRanks(-curRankCost, aClass, false, aPC);
        if (aResp.length() != 0) {
            Logging.debugPrint(aResp);
        }
    }

    public void addClassList(String aString) {
        StringTokenizer aTok = new StringTokenizer(aString, "|");
        while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            if (bString.length() > 0 && bString.charAt(0) == '!' && this.classList.size() > 0) {
                this.classList.add(0, bString);
                continue;
            }
            this.classList.add(bString);
        }
    }

    public static boolean chooseSpokenLanguage(PlayerCharacter aPC) {
        Skill speakLanguage = null;
        Iterator a = aPC.getSkillList().iterator();
        while (a.hasNext()) {
            Skill aSkill = (Skill)a.next();
            if (aSkill.getChoiceString().indexOf("Language") < 0) continue;
            speakLanguage = aSkill;
        }
        return Skill.chooseSpokenLanguage(aPC, speakLanguage);
    }

    public static boolean chooseSpokenLanguage(PlayerCharacter aPC, Skill speakLanguage) {
        if (aPC != null) {
            Language lang;
            if (speakLanguage == null) {
                ShowMessageDelegate.showMessageDialog("You do not have enough ranks in Speak Language", "PCGen", MessageType.ERROR);
                return false;
            }
            int numLanguages = speakLanguage.getTotalRank(aPC).intValue();
            ArrayList selectedLangNames = new ArrayList();
            ArrayList<Language> selected = new ArrayList<Language>();
            ArrayList<Language> available = new ArrayList<Language>();
            ArrayList<Language> excludedLangs = new ArrayList<Language>();
            speakLanguage.addAssociatedTo(selectedLangNames);
            Iterator e = selectedLangNames.iterator();
            while (e.hasNext()) {
                String aString = (String)e.next();
                Language aLang = Globals.getLanguageNamed(aString);
                if (aLang == null) continue;
                selected.add(aLang);
            }
            e = Globals.getLanguageList().iterator();
            while (e.hasNext()) {
                Language aLang = (Language)e.next();
                if (!PrereqHandler.passesAll(aLang.getPreReqList(), aPC, aLang)) continue;
                available.add(aLang);
            }
            e = aPC.getAutoLanguages().iterator();
            while (e.hasNext()) {
                lang = (Language)e.next();
                available.remove(lang);
                excludedLangs.add(lang);
            }
            e = aPC.getLanguagesList().iterator();
            while (e.hasNext()) {
                lang = (Language)e.next();
                if (selected.contains(lang)) continue;
                available.remove(lang);
                excludedLangs.add(lang);
            }
            Globals.sortChooserLists(available, selected);
            ChooserInterface lc = ChooserFactory.getChooserInstance();
            lc.setVisible(false);
            lc.setAvailableList(available);
            lc.setSelectedList(selectedLangNames);
            lc.setPool(numLanguages - selected.size());
            lc.setPoolFlag(false);
            lc.setVisible(true);
            ArrayList<Language> selLangs = new ArrayList<Language>();
            Iterator e2 = lc.getSelectedList().iterator();
            while (e2.hasNext()) {
                String aString = (String)e2.next();
                Language aLang = Globals.getLanguageNamed(aString);
                if (aLang == null) continue;
                selLangs.add(aLang);
            }
            aPC.getLanguagesList().clear();
            aPC.getLanguagesList().addAll(selLangs);
            aPC.getLanguagesList().addAll(excludedLangs);
            speakLanguage.clearAssociated();
            speakLanguage.addAllToAssociated(lc.getSelectedList());
            aPC.setDirty(true);
            return true;
        }
        return false;
    }

    public void setVisible(int argVisible) {
        this.skillVisible = argVisible;
    }

    public int isVisible() {
        return this.skillVisible;
    }

    public void setReadOnly(boolean argReadOnly) {
        this.skillReadOnly = argReadOnly;
    }

    public boolean isReadOnly() {
        return this.skillReadOnly;
    }

    public Object clone() {
        Skill newSkill = null;
        try {
            newSkill = (Skill)super.clone();
            newSkill.required = this.required;
            newSkill.setRootName(this.rootName);
            newSkill.setKeyStat(this.getKeyStat());
            newSkill.setIsExclusive(this.isExclusive());
            newSkill.rankList = (ArrayList)this.rankList.clone();
            newSkill.setUntrained(this.getUntrained());
            newSkill.classList = (ArrayList)this.classList.clone();
            newSkill.isSpecified = this.isSpecified;
            newSkill.aCheck = this.aCheck;
            newSkill.skillVisible = this.skillVisible;
            newSkill.skillReadOnly = this.skillReadOnly;
            if (this.synergyList != null) {
                newSkill.setSynergyList((ArrayList)this.getSynergyList().clone());
            }
            newSkill.outputIndex = this.outputIndex;
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return newSkill;
    }

    public Integer costForPCClass(PCClass aClass, PlayerCharacter aPC) {
        if (!PrereqHandler.passesAll(this.getPreReqList(), aPC, this)) {
            return new Integer(SettingsHandler.getExcSkillCost());
        }
        Integer anInt = this.isClassSkill(aClass, aPC) ? new Integer(1) : (!this.isCrossClassSkill(aClass, aPC) && this.isExclusive ? new Integer(SettingsHandler.getExcSkillCost()) : new Integer(SettingsHandler.getIntCrossClassSkillCost()));
        return anInt;
    }

    public String modRanks(double rankMod, PCClass aClass, PlayerCharacter aPC) {
        return this.modRanks(rankMod, aClass, false, aPC);
    }

    public String modRanks(double rankMod, PCClass aClass, boolean ignorePrereqs, PlayerCharacter aPC) {
        int iOffs;
        double curRank;
        int idx;
        int i = 0;
        if (!ignorePrereqs) {
            if (aClass == null) {
                return "You must be at least level one before you can purchase skills.";
            }
            i = this.costForPCClass(aClass, aPC);
            if (i == 0) {
                return "You cannot purchase this exclusive skill.";
            }
            if (rankMod > 0.0 && (double)aClass.getSkillPool(aPC).floatValue() < rankMod * (double)i) {
                return "You do not have enough skill points.";
            }
            double maxRank = aPC.getMaxRank(this.getName(), aClass).doubleValue();
            if (!Globals.checkRule("SKILLMAX") && rankMod > 0.0) {
                double ttlRank = this.getTotalRank(aPC).doubleValue();
                if (ttlRank >= maxRank) {
                    return "Skill rank at maximum (" + maxRank + ") for your level.";
                }
                if (ttlRank + rankMod > maxRank) {
                    return "Raising skill would make it above maximum (" + maxRank + ") for your level.";
                }
            }
        }
        if (this.getRank().doubleValue() + rankMod < 0.0) {
            return "Cannot lower rank below 0";
        }
        String aCName = "None";
        if (aClass != null) {
            aCName = aClass.getName();
        }
        String bSkill = "";
        String aCNameString = aCName + ":";
        for (idx = 0; idx < this.rankList.size() && !(bSkill = (String)this.rankList.get(idx)).startsWith(aCNameString); ++idx) {
        }
        if (idx >= this.rankList.size()) {
            if (rankMod < 0.0) {
                for (idx = 0; idx < this.rankList.size() && !(bSkill = (String)this.rankList.get(idx)).startsWith("None:"); ++idx) {
                }
            }
            if (idx >= this.rankList.size()) {
                bSkill = aCName + ":0";
            }
        }
        if (CoreUtility.doublesEqual(curRank = Double.parseDouble(bSkill.substring((iOffs = bSkill.indexOf(58)) + 1)), 0.0) && rankMod < 0.0) {
            return "No more ranks found for class: " + aCName + ". Try a different one.";
        }
        if (idx >= this.rankList.size()) {
            this.rankList.add(idx, bSkill);
        }
        rankMod = this.modRanks2(rankMod, idx, bSkill, aPC);
        if (!ignorePrereqs) {
            if (aClass != null) {
                aClass.setSkillPool(new Integer(aClass.getSkillPool(aPC) - (int)((double)i * rankMod)));
            }
            aPC.setSkillPoints(aPC.getSkillPoints() - (int)((double)i * rankMod));
        }
        return "";
    }

    public Integer modifier(PlayerCharacter aPC) {
        String singleType;
        int typesForBonus;
        int stat = SettingsHandler.getGame().getStatFromAbbrev(this.keyStat);
        int bonus = 0;
        if (aPC == null) {
            return new Integer(0);
        }
        if (stat >= 0) {
            bonus = aPC.getStatList().getStatModFor(this.keyStat);
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", "STAT." + this.keyStat));
        }
        bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", this.name));
        for (typesForBonus = 0; typesForBonus < this.getMyTypeCount(); ++typesForBonus) {
            singleType = this.getMyType(typesForBonus);
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", "TYPE." + singleType));
        }
        bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", "LIST"));
        bonus = (int)((double)bonus + aPC.getTotalBonusTo("SKILL", "ALL"));
        if (this.isClassSkill(aPC.getClassList(), aPC)) {
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("CSKILL", this.name));
            for (typesForBonus = 0; typesForBonus < this.getMyTypeCount(); ++typesForBonus) {
                singleType = this.getMyType(typesForBonus);
                bonus = (int)((double)bonus + aPC.getTotalBonusTo("CSKILL", "TYPE." + singleType));
            }
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("CSKILL", "LIST"));
        }
        if (!this.isClassSkill(aPC.getClassList(), aPC) && !this.isExclusive()) {
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("CCSKILL", this.name));
            for (typesForBonus = 0; typesForBonus < this.getMyTypeCount(); ++typesForBonus) {
                singleType = this.getMyType(typesForBonus);
                bonus = (int)((double)bonus + aPC.getTotalBonusTo("CCSKILL", "TYPE." + singleType));
            }
            bonus = (int)((double)bonus + aPC.getTotalBonusTo("CCSKILL", "LIST"));
        }
        bonus += aPC.getRace().bonusForSkill(this.getName());
        int aCheckBonus = this.calcACheckBonus(aPC);
        return new Integer(bonus += aCheckBonus);
    }

    private int calcACheckBonus(PlayerCharacter aPC) {
        if (this.aCheck == 0) {
            return 0;
        }
        int minBonus = 0;
        int maxBonus = 0;
        Float totalWeight = aPC.totalWeight();
        if (Globals.checkRule("SYS_WTPSK")) {
            if (this.aCheck == 3 && Globals.checkRule("SYS_WTPSK")) {
                maxBonus = -((int)(totalWeight.doubleValue() / 5.0));
            } else if (this.aCheck != 3) {
                Equipment eq;
                if (this.aCheck != 2 && Globals.checkRule("SYS_LDPACSK")) {
                    int load = Globals.loadTypeForLoadScore(aPC.getVariableValue("LOADSCORE", "").intValue(), aPC.totalWeight(), aPC);
                    switch (load) {
                        case 1: {
                            minBonus = this.aCheck == 4 ? -6 : -3;
                            break;
                        }
                        case 2: 
                        case 3: {
                            minBonus = this.aCheck == 4 ? -12 : -6;
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            Logging.errorPrint(this.getName() + ":in Skill.modifier the load " + load + " is not supported.");
                        }
                    }
                }
                List itemList = aPC.getEquipmentOfType("Armor", 1);
                Iterator e = aPC.getEquipmentOfType("Shield", 1).iterator();
                while (e.hasNext()) {
                    eq = (Equipment)e.next();
                    if (itemList.contains(eq)) continue;
                    itemList.add(eq);
                }
                e = itemList.iterator();
                while (e.hasNext()) {
                    eq = (Equipment)e.next();
                    if (this.aCheck == 1 || this.aCheck == 2 && !aPC.isProficientWith(eq)) {
                        maxBonus += eq.acCheck(aPC).intValue();
                        continue;
                    }
                    if (this.aCheck != 4) continue;
                    maxBonus += 2 * eq.acCheck(aPC);
                }
            }
        }
        return Math.min(maxBonus, minBonus);
    }

    public String qualifiedName() {
        if (this.getAssociatedCount() == 0) {
            return this.name;
        }
        StringBuffer buffer = new StringBuffer(this.getAssociatedCount() * 20);
        buffer.append(this.name).append("(");
        for (int i = 0; i < this.getAssociatedCount(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getAssociated(i));
        }
        buffer.append(")");
        return buffer.toString();
    }

    boolean isClassSkill(List aList, PlayerCharacter aPC) {
        Iterator e = aList.iterator();
        while (e.hasNext()) {
            if (!this.isClassSkill((PCClass)e.next(), aPC)) continue;
            return true;
        }
        return false;
    }

    boolean isRequired() {
        return this.required;
    }

    String getRootName() {
        return this.rootName;
    }

    Integer costForPCClassList(List aPCClassList, PlayerCharacter aPC) {
        int anInt = 0;
        int classListSize = aPCClassList.size();
        if (classListSize == 0) {
            return new Integer(anInt);
        }
        Iterator i = aPCClassList.iterator();
        while (i.hasNext()) {
            PCClass aClass = (PCClass)i.next();
            int cInt = this.costForPCClass(aClass, aPC);
            if (cInt == 1) {
                return new Integer(cInt);
            }
            if (cInt == anInt) continue;
            anInt = cInt;
        }
        return new Integer(anInt);
    }

    void replaceClassRank(String oldClass, String newClass) {
        String oldClassString = oldClass + ":";
        for (int i = 0; i < this.rankList.size(); ++i) {
            String bSkill = (String)this.rankList.get(i);
            if (!bSkill.startsWith(oldClassString)) continue;
            this.rankList.set(i, newClass + bSkill.substring(oldClass.length()));
        }
    }

    private boolean isCrossClassSkill(PCClass aClass, PlayerCharacter aPC) {
        if (this.isClassSkill(aClass, aPC)) {
            return false;
        }
        if (aPC == null || aClass == null) {
            return false;
        }
        if (aPC.getRace().hasCCSkill(this.name)) {
            return true;
        }
        Iterator e = aPC.getCharacterDomainList().iterator();
        while (e.hasNext()) {
            CharacterDomain aCD = (CharacterDomain)e.next();
            if (aCD.getDomain() == null || !aCD.isFromPCClass(aClass.getName()) || !aCD.getDomain().hasCCSkill(this.name)) continue;
            return true;
        }
        if (aPC.getDeity() != null && aPC.getDeity().hasCCSkill(this.name)) {
            return true;
        }
        if (aClass.hasCCSkill(this.name)) {
            return true;
        }
        if (aClass.isMonster() && aPC.getRace().hasMonsterCCSkill(this.name)) {
            return true;
        }
        Iterator i = aPC.aggregateFeatList().iterator();
        while (i.hasNext()) {
            Feat aFeat = (Feat)i.next();
            if (!aFeat.hasCCSkill(this.name)) continue;
            return true;
        }
        i = aPC.getSkillList().iterator();
        while (i.hasNext()) {
            Skill aSkill = (Skill)i.next();
            if (!aSkill.hasCCSkill(this.name)) continue;
            return true;
        }
        e = aPC.getEquipmentList().iterator();
        while (e.hasNext()) {
            EquipmentModifier eqMod;
            Iterator e2;
            Equipment eq = (Equipment)e.next();
            if (!eq.isEquipped()) continue;
            if (eq.hasCCSkill(this.name)) {
                return true;
            }
            List aList = eq.getEqModifierList(true);
            if (!aList.isEmpty()) {
                e2 = aList.iterator();
                while (e2.hasNext()) {
                    eqMod = (EquipmentModifier)e2.next();
                    if (!eqMod.hasCCSkill(this.name)) continue;
                    return true;
                }
            }
            if ((aList = eq.getEqModifierList(false)).isEmpty()) continue;
            e2 = aList.iterator();
            while (e2.hasNext()) {
                eqMod = (EquipmentModifier)e2.next();
                if (!eqMod.hasCCSkill(this.name)) continue;
                return true;
            }
        }
        i = aPC.getTemplateList().iterator();
        while (i.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)i.next();
            if (!aTemplate.hasCCSkill(this.name)) continue;
            return true;
        }
        return false;
    }

    private Float getRankAdj(PlayerCharacter currentPC) {
        String skillName = this.getName();
        if (currentPC == null) {
            return new Float(0.0f);
        }
        return new Float(currentPC.getTotalBonusTo("SKILLRANK", skillName));
    }

    private void setSynergyList(ArrayList argSynergyList) {
        this.synergyList = argSynergyList;
    }

    private double modRanks2(double g, int idx, String bSkill, PlayerCharacter aPC) {
        int iOffs = bSkill.indexOf(58);
        double curRank = Double.parseDouble(bSkill.substring(iOffs + 1));
        double newRank = curRank + g;
        if (!(aPC.isImporting() || this.choiceString.length() <= 0 || CoreUtility.doublesEqual(g, 0.0) || CoreUtility.doublesEqual(curRank, (int)newRank))) {
            ArrayList aArrayList = new ArrayList();
            double rankAdjustment = 0.0;
            String title = "";
            StringTokenizer aTok = new StringTokenizer(this.choiceString, "|");
            if (aTok.hasMoreTokens()) {
                title = aTok.nextToken();
            }
            if (this.choiceString.startsWith("Language")) {
                bSkill = bSkill.substring(0, iOffs + 1) + newRank;
                this.rankList.set(idx, bSkill);
                if (!Skill.chooseSpokenLanguage(aPC, this)) {
                    newRank = curRank;
                } else {
                    int maxLanguages;
                    int selectedLanguages = this.getAssociatedCount();
                    if (selectedLanguages > (maxLanguages = this.getTotalRank(aPC).intValue())) {
                        newRank = curRank;
                    }
                }
                g = newRank - curRank;
            } else {
                ChooserInterface c = ChooserFactory.getChooserInstance();
                if (title.length() != 0) {
                    c.setTitle(title);
                }
                c.setPool((int)(g + curRank + 0.0) - this.getAssociatedCount());
                c.setPoolFlag(false);
                c.setAvailableList(aArrayList);
                ArrayList s = new ArrayList();
                this.addAssociatedTo(s);
                c.setSelectedList(s);
                c.setVisible(true);
                int selectedListSize = c.getSelectedList().size();
                newRank = (double)selectedListSize - 0.0;
                g = newRank - this.getRank().doubleValue();
            }
        }
        if (CoreUtility.doublesEqual(newRank, 0.0)) {
            this.rankList.remove(idx);
        } else {
            bSkill = bSkill.substring(0, iOffs + 1) + newRank;
            this.rankList.set(idx, bSkill);
        }
        aPC.calcActiveBonuses();
        return g;
    }

    public String getModifierExplanation(PlayerCharacter aPC, boolean shortFrom) {
        String singleType;
        int typesForBonus;
        double bonusObjTotal = 0.0;
        StringBuffer bonusDetails = new StringBuffer();
        Iterator ab = this.getBonusList().iterator();
        while (ab.hasNext()) {
            BonusObj aBonus = (BonusObj)ab.next();
            double bonusVal = aBonus.getCalculatedValue(aPC);
            if (!aBonus.isApplied() || bonusVal == 0.0 || "VAR".equals(aBonus.getBonusName())) continue;
            if (bonusDetails.length() > 0) {
                bonusDetails.append(' ');
            }
            bonusDetails.append(aBonus.getDescription(shortFrom, aPC));
            bonusObjTotal += bonusVal;
        }
        double bonus = 0.0;
        if (SettingsHandler.getGame().getStatFromAbbrev(this.keyStat) >= 0) {
            bonus = aPC.getTotalBonusTo("SKILL", "STAT." + this.keyStat);
            this.appendBonusDesc(bonusDetails, bonus, "STAT");
        }
        bonus = aPC.getTotalBonusTo("SKILL", this.name) - bonusObjTotal;
        this.appendBonusDesc(bonusDetails, bonus, "OTHER");
        for (typesForBonus = 0; typesForBonus < this.getMyTypeCount(); ++typesForBonus) {
            singleType = this.getMyType(typesForBonus);
            bonus = aPC.getTotalBonusTo("SKILL", "TYPE." + singleType);
            this.appendBonusDesc(bonusDetails, bonus, "TYPE." + singleType);
        }
        bonus = aPC.getTotalBonusTo("SKILL", "LIST");
        this.appendBonusDesc(bonusDetails, bonus, "LIST");
        bonus = aPC.getTotalBonusTo("SKILL", "ALL");
        this.appendBonusDesc(bonusDetails, bonus, "LIST");
        if (this.isClassSkill(aPC.getClassList(), aPC)) {
            bonus = aPC.getTotalBonusTo("CSKILL", this.name);
            this.appendBonusDesc(bonusDetails, bonus, "CSKILL");
            for (typesForBonus = 0; typesForBonus < this.getMyTypeCount(); ++typesForBonus) {
                singleType = this.getMyType(typesForBonus);
                bonus = aPC.getTotalBonusTo("CSKILL", "TYPE." + singleType);
                this.appendBonusDesc(bonusDetails, bonus, "CSKILL");
            }
            bonus = aPC.getTotalBonusTo("CSKILL", "LIST");
            this.appendBonusDesc(bonusDetails, bonus, "CSKILL");
        }
        if (!this.isClassSkill(aPC.getClassList(), aPC) && !this.isExclusive()) {
            bonus = aPC.getTotalBonusTo("CCSKILL", this.name);
            this.appendBonusDesc(bonusDetails, bonus, "CCSKILL");
            for (typesForBonus = 0; typesForBonus < this.getMyTypeCount(); ++typesForBonus) {
                singleType = this.getMyType(typesForBonus);
                bonus = aPC.getTotalBonusTo("CCSKILL", "TYPE." + singleType);
                this.appendBonusDesc(bonusDetails, bonus, "CCSKILL");
            }
            bonus = aPC.getTotalBonusTo("CCSKILL", "LIST");
            this.appendBonusDesc(bonusDetails, bonus, "CCSKILL");
        }
        bonus = aPC.getRace().bonusForSkill(this.getName());
        this.appendBonusDesc(bonusDetails, bonus, "RACE");
        int aCheckMod = this.calcACheckBonus(aPC);
        this.appendBonusDesc(bonusDetails, aCheckMod, "ARMOR");
        return bonusDetails.toString();
    }

    private void appendBonusDesc(StringBuffer bonusDetails, double bonus, String description) {
        if (bonus == 0.0) {
            return;
        }
        if (bonusDetails.length() > 0) {
            bonusDetails.append(' ');
        }
        bonusDetails.append(Delta.toString((float)bonus));
        bonusDetails.append('[').append(description).append(']');
    }
}

