/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.TextProperty;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;

public final class SpecialAbility
extends TextProperty {
    protected String saSource = "";

    public SpecialAbility() {
    }

    public SpecialAbility(String name) {
        super(name);
    }

    public SpecialAbility(String name, String saSource) {
        super(name);
        this.saSource = saSource;
    }

    public SpecialAbility(String name, String saSource, String propDesc) {
        super(name, propDesc);
        this.saSource = saSource;
    }

    public void setQualificationClass(String oldClass, String newClass) {
        if ("".equals(this.saSource)) {
            return;
        }
        try {
            StringTokenizer aTok = new StringTokenizer(this.saSource, "|=", false);
            String typeString = aTok.nextToken();
            String className = aTok.nextToken();
            String levelString = aTok.nextToken();
            if (className.equals(oldClass)) {
                Logging.errorPrint("Source class changed from " + oldClass + " to " + newClass + " for " + this.name);
                this.setSASource(typeString + "=" + newClass + "|" + levelString);
            }
        }
        catch (Exception exc) {
            Logging.errorPrint("setQualificationClass:" + this.saSource, exc);
        }
    }

    public void setSADesc(String saDesc) {
        this.setPropDesc(saDesc);
    }

    public String getSADesc() {
        return this.getPropDesc();
    }

    public void setSASource(String saSource) {
        this.saSource = saSource;
    }

    public String getSASource() {
        return this.saSource;
    }

    public int compareTo(Object obj) {
        if (obj instanceof SpecialAbility && this.name.equals(obj.toString())) {
            return this.saSource.compareToIgnoreCase(((SpecialAbility)obj).saSource);
        }
        return this.name.compareToIgnoreCase(obj.toString());
    }

    public String toString() {
        return this.name;
    }

    boolean pcQualifiesFor(PlayerCharacter aPC) {
        int anInt;
        if ("".equals(this.saSource) || this.saSource.endsWith("|0")) {
            return true;
        }
        if (!PrereqHandler.passesAll(this.getPreReqList(), aPC, null)) {
            return false;
        }
        StringTokenizer aTok = new StringTokenizer(this.saSource, "|=", false);
        String aString = aTok.nextToken();
        String aName = aTok.nextToken();
        try {
            anInt = Integer.parseInt(aTok.nextToken());
        }
        catch (NumberFormatException exc) {
            Logging.errorPrint("pcQualifiesFor:" + this.saSource, exc);
            return false;
        }
        if ("PCCLASS".equals(aString)) {
            PCClass aClass = aPC.getClassNamed(aName);
            if (aClass == null) {
                return false;
            }
            return aClass.getLevel() >= anInt;
        }
        return aPC.getTotalLevels() >= anInt;
    }
}

