/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.core.TextProperty;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public final class SpecialProperty
extends TextProperty {
    public SpecialProperty() {
    }

    public SpecialProperty(String name) {
        super(name);
    }

    public SpecialProperty(String name, String propDesc) {
        super(name, propDesc);
    }

    public static SpecialProperty createFromLst(String input) {
        StringTokenizer tok = new StringTokenizer(input, "|", true);
        SpecialProperty sp = new SpecialProperty();
        if (!tok.hasMoreTokens()) {
            return sp;
        }
        String spName = tok.nextToken();
        boolean inPreReq = false;
        while (tok.hasMoreTokens()) {
            String cString = tok.nextToken();
            if (cString.startsWith("PRE") && cString.indexOf(":") > 0) {
                try {
                    PreParserFactory factory = PreParserFactory.getInstance();
                    Prerequisite prereq = factory.parse(cString);
                    sp.addPreReq(prereq);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint(ple.getMessage(), ple);
                }
            } else {
                spName = spName + cString;
            }
            if (!".CLEAR".equals(cString)) continue;
            spName = "";
        }
        sp.setName(spName);
        return sp;
    }
}

