/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;

public final class StatList {
    private List stats = new ArrayList();
    private PlayerCharacter ownerPC;

    public StatList(PlayerCharacter pc) {
        this.ownerPC = pc;
    }

    public int getBaseStatFor(String aStat) {
        int x = this.getIndexOfStatFor(aStat);
        if (x == -1) {
            return 0;
        }
        PCStat stat = (PCStat)this.stats.get(x);
        PlayerCharacter aPC = this.ownerPC;
        int z = aPC.getVariableValue("LOCK." + stat.getAbb(), "").intValue();
        if (z != 0 || z == 0 && aPC.hasVariable("LOCK." + stat.getAbb())) {
            return z;
        }
        z = aPC.getVariableValue("BASE." + stat.getAbb(), "").intValue();
        if (z != 0) {
            return z;
        }
        return stat.getBaseScore();
    }

    public int getBaseStatModFor(String aStat) {
        int x = this.getIndexOfStatFor(aStat);
        if (x == -1) {
            return 0;
        }
        PCStat stat = (PCStat)this.stats.get(x);
        return this.ownerPC.getVariableValue(stat.getStatMod(), "STAT:" + stat.getAbb()).intValue();
    }

    public List getBonusListOfType(String aType, String aName) {
        LinkedList aList = new LinkedList();
        Iterator e = this.stats.iterator();
        while (e.hasNext()) {
            PCStat aStat = (PCStat)e.next();
            aList.addAll(aStat.getBonusListOfType(aType, aName));
        }
        return aList;
    }

    public int getModForNumber(int aNum) {
        return this.getModForNumber(aNum, 1);
    }

    public int getModForNumber(int aNum, int statIndex) {
        PCStat stat = (PCStat)this.stats.get(statIndex);
        String aString = stat.getStatMod();
        aString = CoreUtility.replaceFirst(aString, "SCORE", Integer.toString(aNum));
        return this.ownerPC.getVariableValue(aString, "").intValue();
    }

    public String getPenaltyVar(String aStat) {
        int x = this.getIndexOfStatFor(aStat);
        if (x == -1) {
            return "";
        }
        PCStat stat = (PCStat)this.stats.get(x);
        return stat.getPenaltyVar();
    }

    public int getStatModFor(String aStat) {
        int x = this.getIndexOfStatFor(aStat);
        if (x == -1) {
            return 0;
        }
        PCStat stat = (PCStat)this.stats.get(x);
        return this.ownerPC.getVariableValue(stat.getStatMod(), "STAT:" + stat.getAbb()).intValue();
    }

    public List getStats() {
        return this.stats;
    }

    public int getTotalStatFor(String aStat) {
        return this.getTotalStatFor(aStat, true);
    }

    public int getTotalStatFor(String aStat, boolean addTempMods) {
        int y = this.getBaseStatFor(aStat);
        int x = this.getIndexOfStatFor(aStat);
        if (x == -1) {
            return y;
        }
        PCStat stat = (PCStat)this.stats.get(x);
        PlayerCharacter aPC = this.ownerPC;
        x = aPC.getVariableValue("LOCK." + stat.getAbb(), "").intValue();
        if (x != 0 || x == 0 && aPC.hasVariable("LOCK." + stat.getAbb())) {
            return x;
        }
        y = (int)((double)y + aPC.getTotalBonusTo("STAT", stat.getAbb()));
        if (!addTempMods && aPC.getUseTempMods()) {
            y = (int)((double)y - aPC.getTempBonusTo("STAT", stat.getAbb()));
        }
        return y;
    }

    public int getIndexOfStatFor(String aStat) {
        if (aStat.startsWith("STAT")) {
            int x = Integer.parseInt(aStat.substring(4));
            if (x < 0 || x >= this.stats.size()) {
                return -1;
            }
            return x;
        }
        return SettingsHandler.getGame().getStatFromAbbrev(aStat);
    }
}

