/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import pcgen.core.GameMode;
import pcgen.core.PaperInfo;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.SpecialAbility;
import pcgen.core.UnitSet;
import pcgen.core.character.EquipSlot;

public class SystemCollections {
    private static final List birthplaceList = new ArrayList(10);
    private static final List bonusStackList = new ArrayList();
    private static final List cityList = new ArrayList(10);
    private static final List gameModeList = new ArrayList();
    private static final List hairStyleList = new ArrayList(65);
    private static final List interestsList = new ArrayList(230);
    private static final List locationList = new ArrayList(30);
    private static final List paperInfoList = new ArrayList(15);
    private static final List phobiaList = new ArrayList(200);
    private static final List phraseList = new ArrayList(800);
    private static final List schoolsList = new ArrayList(20);
    private static final List sizeAdjustmentList = new ArrayList(9);
    private static final List specialsList = new ArrayList(20);
    private static final List speechList = new ArrayList(100);
    private static final List traitList = new ArrayList(550);
    private static final SizeAdjustment spareSize = new SizeAdjustment();
    private static final List unitSetList = new ArrayList(15);
    private static final HashMap equipSlotMap = new HashMap();

    private SystemCollections() {
    }

    public static GameMode getGameModeNamed(String aString) {
        Iterator e = gameModeList.iterator();
        while (e.hasNext()) {
            GameMode gameMode = (GameMode)e.next();
            if (!gameMode.getName().equalsIgnoreCase(aString)) continue;
            return gameMode;
        }
        return null;
    }

    public static SizeAdjustment getSizeAdjustmentAtIndex(int index) {
        SizeAdjustment sa = null;
        if (index >= 0 && index < sizeAdjustmentList.size()) {
            sa = (SizeAdjustment)sizeAdjustmentList.get(index);
        }
        return sa;
    }

    public static int getSizeAdjustmentListSize() {
        return sizeAdjustmentList.size();
    }

    public static SizeAdjustment getSizeAdjustmentNamed(String name) {
        if (name.trim().length() == 0) {
            return spareSize;
        }
        Iterator i = sizeAdjustmentList.iterator();
        while (i.hasNext()) {
            SizeAdjustment s = (SizeAdjustment)i.next();
            if (!s.getName().equalsIgnoreCase(name) && !s.getAbbreviation().equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    public static List getUnmodifiableBirthplaceList() {
        return Collections.unmodifiableList(birthplaceList);
    }

    public static List getUnmodifiableBonusStackList() {
        return Collections.unmodifiableList(bonusStackList);
    }

    public static List getUnmodifiableCityList() {
        return Collections.unmodifiableList(cityList);
    }

    public static List getUnmodifiableEquipSlotList() {
        ArrayList equipSlotList = (ArrayList)equipSlotMap.get(SettingsHandler.getGame().getName());
        if (equipSlotList == null) {
            equipSlotList = (List)equipSlotMap.get("*");
        }
        if (equipSlotList == null) {
            equipSlotList = new ArrayList();
        }
        return Collections.unmodifiableList(equipSlotList);
    }

    public static List getUnmodifiableGameModeList() {
        return Collections.unmodifiableList(gameModeList);
    }

    public static List getUnmodifiableHairStyleList() {
        return Collections.unmodifiableList(hairStyleList);
    }

    public static List getUnmodifiableInterestsList() {
        return Collections.unmodifiableList(interestsList);
    }

    public static List getUnmodifiableLocationList() {
        return Collections.unmodifiableList(locationList);
    }

    public static List getUnmodifiablePaperInfo() {
        return Collections.unmodifiableList(paperInfoList);
    }

    public static List getUnmodifiablePhobiaList() {
        return Collections.unmodifiableList(phobiaList);
    }

    public static List getUnmodifiablePhraseList() {
        return Collections.unmodifiableList(phraseList);
    }

    public static List getUnmodifiableSchoolsList() {
        return Collections.unmodifiableList(schoolsList);
    }

    public static List getUnmodifiableSpecialsList() {
        return Collections.unmodifiableList(specialsList);
    }

    public static List getUnmodifiableSpeechList() {
        return Collections.unmodifiableList(speechList);
    }

    public static List getUnmodifiableTraitList() {
        return Collections.unmodifiableList(traitList);
    }

    public static List getUnmodifiableUnitSet() {
        return Collections.unmodifiableList(unitSetList);
    }

    public static void addToBirthplaceList(String birthplace) {
        birthplaceList.add(birthplace);
    }

    public static void addToBonusStackList(String item) {
        bonusStackList.add(item.toUpperCase());
    }

    public static void addToCityList(String city) {
        cityList.add(city);
    }

    public static void addToEquipSlotsList(EquipSlot equipmentSlot, String gameMode) {
        ArrayList<EquipSlot> equipSlotList = (ArrayList<EquipSlot>)equipSlotMap.get(gameMode);
        if (equipSlotList == null) {
            equipSlotList = new ArrayList<EquipSlot>();
            equipSlotMap.put(gameMode, equipSlotList);
        }
        if (!equipSlotList.contains(equipmentSlot)) {
            equipSlotList.add(equipmentSlot);
        }
    }

    public static void addToGameModeList(GameMode mode) {
        gameModeList.add(mode);
    }

    public static void addToHairStyleList(String hairStyle) {
        hairStyleList.add(hairStyle);
    }

    public static void addToInterestsList(String interest) {
        interestsList.add(interest);
    }

    public static void addToLocationList(String location) {
        locationList.add(location);
    }

    public static void addToPaperInfoList(PaperInfo paper) {
        paperInfoList.add(paper);
    }

    public static void addToPhobiaList(String phobia) {
        phobiaList.add(phobia);
    }

    public static void addToPhraseList(String phrase) {
        phraseList.add(phrase);
    }

    public static void addToSchoolList(String school) {
        schoolsList.add(school);
    }

    public static void addToSizeAdjustmentList(SizeAdjustment item) {
        if (!sizeAdjustmentList.contains(item)) {
            sizeAdjustmentList.add(item);
        }
    }

    public static void addToSpecialsList(SpecialAbility sa) {
        specialsList.add(sa);
    }

    public static void addToSpeechList(String speech) {
        speechList.add(speech);
    }

    public static void addToTraitList(String trait) {
        traitList.add(trait);
    }

    public static void addToUnitSetList(UnitSet unitSet) {
        String name = unitSet.getName();
        ListIterator<UnitSet> i = unitSetList.listIterator();
        while (i.hasNext()) {
            UnitSet us = (UnitSet)i.next();
            if (!name.equals(us.getName())) continue;
            i.set(unitSet);
            return;
        }
        unitSetList.add(unitSet);
    }

    public static void clearEquipSlotsMap() {
        equipSlotMap.clear();
    }

    public static void clearGameModeList() {
        gameModeList.clear();
    }

    public static void clearPaperInfoList() {
        paperInfoList.clear();
    }

    public static void clearSizeAdjustmentList() {
        sizeAdjustmentList.clear();
    }

    public static void clearUnitSetList() {
        unitSetList.clear();
    }

    public static void sortGameModeList() {
        Collections.sort(gameModeList);
    }

    static SizeAdjustment getDefaultSizeAdjustment() {
        Iterator i = sizeAdjustmentList.iterator();
        while (i.hasNext()) {
            SizeAdjustment s = (SizeAdjustment)i.next();
            if (!s.isDefaultSize()) continue;
            return s;
        }
        return null;
    }
}

