/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.Serializable;
import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.PrereqHandler;

public abstract class TextProperty
extends PObject
implements Serializable,
Comparable {
    protected String propDesc = "";

    public TextProperty() {
    }

    public TextProperty(String name) {
        this.name = name;
    }

    public TextProperty(String name, String propDesc) {
        this.name = name;
        this.propDesc = propDesc;
    }

    public void setPropDesc(String propDesc) {
        this.propDesc = propDesc;
    }

    public int compareTo(Object obj) {
        if (obj instanceof TextProperty && this.name.equals(obj.toString())) {
            return this.propDesc.compareToIgnoreCase(((SpecialAbility)obj).propDesc);
        }
        return this.name.compareToIgnoreCase(obj.toString());
    }

    public String toString() {
        return this.name;
    }

    String getPropDesc() {
        return this.propDesc;
    }

    boolean pcQualifiesFor(PlayerCharacter pc) {
        return PrereqHandler.passesAll(this.getPreReqList(), pc, null);
    }

    public String getText() {
        String text = this.getPropDesc() == null || "".equals(this.getPropDesc()) ? this.getName() : this.getName() + " (" + this.getPropDesc() + ")";
        return text;
    }

    public String parse(String text) {
        for (int i = 0; i < this.getAssociatedCount(); ++i) {
            text = text.replaceFirst("%CHOICE", this.getAssociated(i));
        }
        return text;
    }

    public String getParsedText() {
        return this.parse(this.getText());
    }

    public String getParsedText(PlayerCharacter pc) {
        return this.getParsedText(pc, this.parse(this.getText()));
    }

    protected String getParsedText(PlayerCharacter pc, String fullDesc) {
        if (fullDesc == null || fullDesc.equals("")) {
            return "";
        }
        String retString = "";
        if (this.pcQualifiesFor(pc)) {
            StringTokenizer varTok = new StringTokenizer(fullDesc, "|");
            String description = varTok.nextToken();
            if (varTok.hasMoreTokens()) {
                boolean atLeastOneNonZero = false;
                int[] varValue = null;
                if (varTok.countTokens() != 0) {
                    varValue = new int[varTok.countTokens()];
                    for (int j = 0; j < varValue.length; ++j) {
                        String varToken = varTok.nextToken();
                        int value = pc.getVariable(varToken, true, true, "", "").intValue();
                        if (value != 0) {
                            atLeastOneNonZero = true;
                        }
                        varValue[j] = value;
                    }
                }
                if (atLeastOneNonZero) {
                    StringBuffer newAbility = new StringBuffer();
                    varTok = new StringTokenizer(description, "%", true);
                    int varCount = 0;
                    while (varTok.hasMoreTokens()) {
                        String nextTok = varTok.nextToken();
                        if ("%".equals(nextTok)) {
                            if (varValue != null && varCount < varValue.length) {
                                newAbility.append(varValue[varCount++]);
                                continue;
                            }
                            newAbility.append('%');
                            continue;
                        }
                        newAbility.append(nextTok);
                    }
                    retString = newAbility.toString();
                } else {
                    retString = "";
                }
            } else {
                retString = description;
            }
        }
        return retString;
    }
}

