/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pcgen.core.Variable;

public class VariableList
implements Cloneable {
    private ArrayList list = new ArrayList();
    private List unmodifiableList = Collections.unmodifiableList(this.list);
    private Set nameSet = null;

    public final String getDefinition(int i) {
        Variable v = (Variable)this.list.get(i);
        return v.getDefinition();
    }

    public final Variable getVariable(int i) {
        Variable v = (Variable)this.list.get(i);
        return v;
    }

    public final Set getVariableNamesAsUnmodifiableSet() {
        if (this.nameSet == null) {
            this.cacheNames();
        }
        return Collections.unmodifiableSet(this.nameSet);
    }

    public final void add(int level, String variableName, String defaultFormula) {
        Variable v = new Variable(level, variableName, defaultFormula);
        this.list.add(v);
        this.clearNameCache();
    }

    public void clear() {
        this.list.clear();
        this.nameSet = null;
    }

    public Object clone() throws CloneNotSupportedException {
        VariableList retVal = (VariableList)super.clone();
        retVal.list = (ArrayList)this.list.clone();
        return retVal;
    }

    public final boolean hasVariableNamed(String variableName) {
        String upperName = variableName.toUpperCase();
        if (this.nameSet == null) {
            this.cacheNames();
        }
        return this.nameSet.contains(upperName);
    }

    public final Iterator iterator() {
        return this.unmodifiableList.iterator();
    }

    public final void set(int idx, int level, String variableName, String defaultFormula) {
        Variable v = new Variable(level, variableName, defaultFormula);
        this.list.set(idx, v);
        this.clearNameCache();
    }

    public final int size() {
        return this.list.size();
    }

    protected final void addAll(VariableList vOther) {
        this.list.addAll(vOther.list);
        this.clearNameCache();
    }

    private final void cacheNames() {
        this.nameSet = new HashSet();
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            Variable v = (Variable)i.next();
            this.nameSet.add(v.getUpperName());
        }
    }

    private final void clearNameCache() {
        this.nameSet = null;
    }
}

