/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import java.util.StringTokenizer;
import pcgen.core.bonus.ACValue;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.CasterLevel;
import pcgen.core.bonus.Checks;
import pcgen.core.bonus.Combat;
import pcgen.core.bonus.DC;
import pcgen.core.bonus.DR;
import pcgen.core.bonus.Damage;
import pcgen.core.bonus.Domain;
import pcgen.core.bonus.Eqm;
import pcgen.core.bonus.EqmArmor;
import pcgen.core.bonus.EqmWeapon;
import pcgen.core.bonus.Feat;
import pcgen.core.bonus.HD;
import pcgen.core.bonus.HP;
import pcgen.core.bonus.ItemCapacity;
import pcgen.core.bonus.ItemCost;
import pcgen.core.bonus.ItemWeight;
import pcgen.core.bonus.Lang;
import pcgen.core.bonus.Languages;
import pcgen.core.bonus.LoadMult;
import pcgen.core.bonus.Misc;
import pcgen.core.bonus.ModSkillPoints;
import pcgen.core.bonus.MonSkillPts;
import pcgen.core.bonus.Move;
import pcgen.core.bonus.PCLevel;
import pcgen.core.bonus.PostRangeAdd;
import pcgen.core.bonus.RangeMult;
import pcgen.core.bonus.SizeMod;
import pcgen.core.bonus.Skill;
import pcgen.core.bonus.SkillPoints;
import pcgen.core.bonus.SkillPool;
import pcgen.core.bonus.SkillRank;
import pcgen.core.bonus.Slots;
import pcgen.core.bonus.Spell;
import pcgen.core.bonus.SpellCast;
import pcgen.core.bonus.SpellCastMult;
import pcgen.core.bonus.SpellKnown;
import pcgen.core.bonus.SpellKnownMult;
import pcgen.core.bonus.Stat;
import pcgen.core.bonus.ToHit;
import pcgen.core.bonus.UDam;
import pcgen.core.bonus.Var;
import pcgen.core.bonus.Vision;
import pcgen.core.bonus.Weapon;
import pcgen.core.bonus.WeaponProf;
import pcgen.core.bonus.WieldCategory;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;

public class Bonus {
    static final String[] bonusTags = new String[]{"ACVALUE", "CASTERLEVEL", "CHECKS", "COMBAT", "DAMAGE", "DC", "DOMAIN", "DR", "EQM", "EQMARMOR", "EQMWEAPON", "FEAT", "HD", "HP", "ITEMCAPACITY", "ITEMCOST", "ITEMWEIGHT", "LANG", "LANGUAGES", "LOADMULT", "MISC", "MODSKILLPOINTS", "MONNONSKILLHD", "MONSKILLPTS", "MOVE", "MOVEADD", "MOVEMULT", "PCLEVEL", "POSTMOVEADD", "POSTRANGEADD", "RANGEADD", "RANGEMULT", "SIZEMOD", "SKILL", "SKILLPOINTS", "SKILLPOOL", "SKILLRANK", "SLOTS", "SPECIALTYSPELLKNOWN", "SPELL", "SPELLCAST", "SPELLCASTMULT", "SPELLKNOWN", "SPELLKNOWNMULT", "STAT", "TOHIT", "UDAM", "VAR", "VISION", "WEAPON", "WEAPONPROF=", "WIELDCATEGORY"};
    static final int BONUS_UNDEFINED = -1;
    private static final int BONUS_ACVALUE = 0;
    private static final int BONUS_CASTERLEVEL = 1;
    private static final int BONUS_CHECKS = 2;
    private static final int BONUS_COMBAT = 3;
    private static final int BONUS_DAMAGE = 4;
    private static final int BONUS_DC = 5;
    private static final int BONUS_DOMAIN = 6;
    private static final int BONUS_DR = 7;
    private static final int BONUS_EQM = 8;
    private static final int BONUS_EQMARMOR = 9;
    private static final int BONUS_EQMWEAPON = 10;
    private static final int BONUS_FEAT = 11;
    private static final int BONUS_HD = 12;
    private static final int BONUS_HP = 13;
    private static final int BONUS_ITEMCAPACITY = 14;
    private static final int BONUS_ITEMCOST = 15;
    private static final int BONUS_ITEMWEIGHT = 16;
    private static final int BONUS_LANG = 17;
    private static final int BONUS_LANGUAGES = 18;
    private static final int BONUS_LOADMULT = 19;
    private static final int BONUS_MISC = 20;
    private static final int BONUS_MODSKILLPOINTS = 21;
    private static final int BONUS_MONSKILLPTS = 22;
    private static final int BONUS_MOVE = 23;
    private static final int BONUS_MOVEADD = 24;
    private static final int BONUS_MOVEMULT = 25;
    private static final int BONUS_PCLEVEL = 26;
    private static final int BONUS_POSTMOVEADD = 27;
    private static final int BONUS_POSTRANGEADD = 28;
    private static final int BONUS_RANGEADD = 29;
    private static final int BONUS_RANGEMULT = 30;
    private static final int BONUS_SIZEMOD = 31;
    private static final int BONUS_SKILL = 32;
    private static final int BONUS_SKILLPOINTS = 33;
    private static final int BONUS_SKILLPOOL = 34;
    private static final int BONUS_SKILLRANK = 35;
    private static final int BONUS_SLOTS = 36;
    private static final int BONUS_SPECIALTYSPELLKNOWN = 37;
    private static final int BONUS_SPELL = 38;
    private static final int BONUS_SPELLCAST = 39;
    private static final int BONUS_SPELLCASTMULT = 40;
    private static final int BONUS_SPELLKNOWN = 41;
    private static final int BONUS_SPELLKNOWNMULT = 42;
    private static final int BONUS_STAT = 43;
    private static final int BONUS_TOHIT = 44;
    private static final int BONUS_UDAM = 45;
    private static final int BONUS_VAR = 46;
    private static final int BONUS_VISION = 47;
    private static final int BONUS_WEAPON = 48;
    private static final int BONUS_WEAPONPROF = 49;
    private static final int BONUS_WIELDCATEGORY = 50;

    public static BonusObj newBonus(String bonusString) {
        int typeOfBonus = -1;
        int aLevel = -1;
        StringTokenizer aTok = new StringTokenizer(bonusString, "|");
        if (aTok.countTokens() < 3 && bonusString.indexOf("%") < 0) {
            Logging.errorPrint("Illegal bonus format: " + bonusString);
            return null;
        }
        String bonusName = aTok.nextToken().toUpperCase();
        try {
            aLevel = Integer.parseInt(bonusName);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        if (aLevel >= 0) {
            bonusName = aTok.nextToken().toUpperCase();
        }
        int equalOffset = -1;
        for (int i = 0; i < bonusTags.length; ++i) {
            if (bonusName.equals(bonusTags[i])) {
                typeOfBonus = i;
                break;
            }
            if (!bonusTags[i].endsWith("=") || !bonusName.startsWith(bonusTags[i])) continue;
            equalOffset = bonusTags[i].length();
            typeOfBonus = i;
            break;
        }
        if (typeOfBonus == -1) {
            Logging.errorPrint("Unrecognized bonus: " + bonusString);
            return null;
        }
        String bonusInfo = aTok.nextToken().toUpperCase();
        String bValue = "0";
        if (aTok.hasMoreTokens()) {
            bValue = aTok.nextToken().toUpperCase();
        }
        BonusObj aBonus = null;
        switch (typeOfBonus) {
            case 0: {
                aBonus = new ACValue();
                break;
            }
            case 1: {
                aBonus = new CasterLevel();
                break;
            }
            case 2: {
                aBonus = new Checks();
                break;
            }
            case 3: {
                aBonus = new Combat();
                break;
            }
            case 4: {
                aBonus = new Damage();
                break;
            }
            case 5: {
                aBonus = new DC();
                break;
            }
            case 6: {
                aBonus = new Domain();
                break;
            }
            case 7: {
                aBonus = new DR();
                break;
            }
            case 8: {
                aBonus = new Eqm();
                break;
            }
            case 9: {
                aBonus = new EqmArmor();
                break;
            }
            case 10: {
                aBonus = new EqmWeapon();
                break;
            }
            case 11: {
                aBonus = new Feat();
                break;
            }
            case 12: {
                aBonus = new HD();
                break;
            }
            case 13: {
                aBonus = new HP();
                break;
            }
            case 14: {
                aBonus = new ItemCapacity();
                break;
            }
            case 15: {
                aBonus = new ItemCost();
                break;
            }
            case 16: {
                aBonus = new ItemWeight();
                break;
            }
            case 17: {
                aBonus = new Lang();
                break;
            }
            case 18: {
                aBonus = new Languages();
                break;
            }
            case 19: {
                aBonus = new LoadMult();
                break;
            }
            case 20: {
                aBonus = new Misc();
                break;
            }
            case 21: {
                aBonus = new ModSkillPoints();
                break;
            }
            case 22: {
                aBonus = new MonSkillPts();
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                aBonus = new Move();
                break;
            }
            case 26: {
                aBonus = new PCLevel();
                break;
            }
            case 28: {
                aBonus = new PostRangeAdd();
                break;
            }
            case 29: 
            case 30: {
                aBonus = new RangeMult();
                break;
            }
            case 31: {
                aBonus = new SizeMod();
                break;
            }
            case 32: {
                aBonus = new Skill();
                break;
            }
            case 33: {
                aBonus = new SkillPoints();
                break;
            }
            case 34: {
                aBonus = new SkillPool();
                break;
            }
            case 35: {
                aBonus = new SkillRank();
                break;
            }
            case 36: {
                aBonus = new Slots();
                break;
            }
            case 38: {
                aBonus = new Spell();
                break;
            }
            case 39: {
                aBonus = new SpellCast();
                break;
            }
            case 40: {
                aBonus = new SpellCastMult();
                break;
            }
            case 41: {
                aBonus = new SpellKnown();
                break;
            }
            case 42: {
                aBonus = new SpellKnownMult();
                break;
            }
            case 43: {
                aBonus = new Stat();
                break;
            }
            case 44: {
                aBonus = new ToHit();
                break;
            }
            case 45: {
                aBonus = new UDam();
                break;
            }
            case 46: {
                aBonus = new Var();
                break;
            }
            case 47: {
                aBonus = new Vision();
                break;
            }
            case 48: {
                aBonus = new Weapon();
                break;
            }
            case 49: {
                aBonus = new WeaponProf();
                break;
            }
            case 50: {
                aBonus = new WieldCategory();
                break;
            }
        }
        if (aBonus != null) {
            aBonus.setBonusName(bonusName);
            aBonus.setTypeOfBonus(typeOfBonus);
            aBonus.setValue(bValue);
            while (aTok.hasMoreTokens()) {
                boolean result;
                String aString = aTok.nextToken().toUpperCase();
                if (aString.startsWith("!PRE") || aString.startsWith("PRE")) {
                    try {
                        PreParserFactory factory = PreParserFactory.getInstance();
                        aBonus.addPreReq(factory.parse(aString));
                    }
                    catch (PersistenceLayerException ple) {
                        Logging.errorPrint(ple.getMessage(), ple);
                    }
                    continue;
                }
                if (!aString.startsWith("TYPE=") && !aString.startsWith("TYPE.") || (result = aBonus.addType(aString.substring(5)))) continue;
                Logging.debugPrint("Could not add type " + aString.substring(5) + " to bonusType " + typeOfBonus + " in Bonus.newBonus");
            }
            if (equalOffset >= 0) {
                aBonus.setVariable(bonusName.substring(equalOffset));
            }
            aTok = new StringTokenizer(bonusInfo, ",");
            while (aTok.hasMoreTokens()) {
                String token = aTok.nextToken();
                boolean result = aBonus.parseToken(token);
                if (result) continue;
                Logging.debugPrint("Could not parse token " + token + " from bonusInfo " + bonusInfo + " in BonusObj.newBonus.");
            }
            if (aLevel >= 0) {
                aBonus.setPCLevel(aLevel);
            }
        }
        return aBonus;
    }
}

